// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	IPROUTES.CPP
// Description       :	Defines Classes :
//			CIPHRoute	: Function of IP Static Host Route Dialog
//			CIPNRoute	: Function of IP Static Net Route Dialog
//			CAddRoute	: Function of IP Static Route Add Dialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "iproutes.h"
#include "ipconfig.h"

#ifndef BOOTP
#include "maskdot.h"
#endif

#define MIN_METRIC			1
#define MAX_METRIC			16
#define HOST_TTL				"MultiRouter Setup - IP Static Routes"
#define ADD_HOST_TTL			"MultiRouter Setup - Add Static Route"
#define EDIT_HOST_TTL		"MultiRouter Setup - Edit Static Route"
#define TEXT_HOST				"Host/Net &Address"
#define HEADER_HOST			"Host/Net Address"

#define MSG_IP_STATIC		"MultiRouter Setup - Static Route"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// 				CIPHRoute dialog
//	Displays IP static host routes OR IP static network routes.


CIPHRoute::CIPHRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CIPHRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPHRoute)
	//}}AFX_DATA_INIT
}

void CIPHRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPHRoute)
	DDX_Control(pDX, IDC_EDIT, m_Edit);
	DDX_Control(pDX, IDC_BUTTON_HOST_REMOVE, m_HRemove);
	DDX_Control(pDX, IDC_BUTTON_HOST_ADD, m_HAdd);
	DDX_Control(pDX, IDC_LIST_HOST_ROUTES, m_HRouteList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPHRoute, CDialog)
	//{{AFX_MSG_MAP(CIPHRoute)
	ON_BN_CLICKED(IDC_BUTTON_HOST_ADD, OnButtonHostAdd)
	ON_BN_CLICKED(IDC_BUTTON_HOST_REMOVE, OnButtonHostRemove)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_LBN_SELCANCEL(IDC_LIST_HOST_ROUTES, OnSelcancelListHostRoutes)
	ON_LBN_SELCHANGE(IDC_LIST_HOST_ROUTES, OnSelchangeListHostRoutes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPHRoute message handlers

// -------------------------------------------------------------------------
// Function             :	CIPHRoute::OnButtonHostAdd()
// Arguments            :  None.
// Synopsis             :  Add new static host route to the listbox.
// Returns              :  None.
// Globals Affected     :  m_HRouteList.
// -------------------------------------------------------------------------
void CIPHRoute::OnButtonHostAdd()
{
	CAddRoute IAddRoute (this) ;

	if (IDOK == IAddRoute.DoModal())
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
					IAddRoute.m_HostNetGwayAddr.IsEmpty() &&
							(IAddRoute.m_nAddStatRoutMetric == 0))
			return;		// If all are empty no need to add.

		CString 	Str;
		Str = IAddRoute.m_HostNetAddr + '\t';
		if (IAddRoute.m_HostNetAddr.GetLength() < 9)
			Str += '\t';
		Str += IAddRoute.m_HostNetGwayAddr + '\t';
		if (IAddRoute.m_HostNetGwayAddr.GetLength() < 10)
			Str += '\t';
		Str += IAddRoute.m_AddressMask + '\t';
		if (IAddRoute.m_AddressMask.GetLength() < 10)
			Str += '\t';

		// Modified by cfp on 9-4-96
		char szMetric[10] ;
		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		Str += szMetric;
		Str += '\t';

		// Modified by Ravi on 16-08-99
		char szPort[15] ;
		itoa (IAddRoute.m_PhysicalPort, szPort, 10) ;
		Str += szPort ;

		m_HRouteList.AddString (Str) ;
	}	//end if (IDOK == ......)

	//	Update the remove & edit buttons.
	m_HRemove.EnableWindow (m_HRouteList.GetSelCount());
	m_Edit.EnableWindow (m_HRouteList.GetSelCount() == 1);
}

// -------------------------------------------------------------------------
// Function             :	CIPHRoute::OnButtonHostRemove()
// Arguments            :  None.
// Synopsis             :  Deletes selected static host route from the listbox.
// Returns              :  None.
// Globals Affected     :  m_HRouteList.
// -------------------------------------------------------------------------
void CIPHRoute::OnButtonHostRemove()
{
	int n_SelItems = m_HRouteList.GetSelCount();
	int *p_Index;
	p_Index = new int[n_SelItems];

	m_HRouteList.GetSelItems(n_SelItems, (LPINT)p_Index);

   // delete in reverse order so that the indices remain same after deletion.
	for (int i = 0 ; i < n_SelItems ; i ++)
		m_HRouteList.DeleteString (p_Index[n_SelItems - 1 - i]) ;

	delete p_Index;

//	Update the remove & edit buttons.
	m_HRemove.EnableWindow (m_HRouteList.GetSelCount()) ;
	m_Edit.EnableWindow (m_HRouteList.GetSelCount() == 1) ;
	m_HAdd.SetFocus() ;
}

// -------------------------------------------------------------------------
// Function             :	CIPHRoute::OnEdit()
// Arguments            :  None.
// Synopsis             :  Edit selected static host route from the listbox.
// Returns              :  None.
// Globals Affected     :  m_HRouteList.
// -------------------------------------------------------------------------
void CIPHRoute::OnEdit()
{
	CIPHRoute *ptrFather = (CIPHRoute *) GetParent() ;
	CIPConfig *ptrGrandFather = (CIPConfig *) ptrFather->GetParent() ;

	UpdateData(TRUE);

	if (m_HRouteList.GetSelCount() != 1)	//Only one entry can be edited.
		return ;

	int n_Index ;
	BYTE RHStr[80] ;
	char *comma ;

	CAddRoute IAddRoute (this) ;

	m_HRouteList.GetSelItems (1, (LPINT) &n_Index) ;
	m_HRouteList.GetText (n_Index, (LPSTR) RHStr) ;

//Update the members of dialog before calling DoModal().
	if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
	{
		*comma = '\0' ;
		IAddRoute.m_HostNetAddr = (char *) RHStr ;
		comma ++ ;

	//if more tab then increment the pointer.
		while (*comma == '\t')
			comma ++ ;	
		_fstrcpy ((char *) RHStr, comma) ;

	   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL)
		{
	     	*comma = '\0' ;
			IAddRoute.m_HostNetGwayAddr = (char *) RHStr ;
			comma ++ ;

			//if more tabs then increment the pointer.
			while (*comma == '\t')
				comma ++ ;
			_fstrcpy ((char *) RHStr, comma) ;

		   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
			{
	   	  	*comma = '\0' ;
				IAddRoute.m_AddressMask = (char *) RHStr ;
				comma ++ ;

				//if more tabs then increment the pointer.
				while (*comma == '\t')
					comma ++ ;
				_fstrcpy ((char *) RHStr, comma) ;

			   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
				{
			   	  	*comma = '\0' ;
					IAddRoute.m_nAddStatRoutMetric = atoi ((char *) RHStr) ;
					comma ++ ;
					
					while (*comma == '\t')
						comma ++ ;

				// Modified by cfp on 9-4-96
					IAddRoute.m_PhysicalPort = atoi (comma) ;
				}	//end if
			}	//end if
		}	//end if
	}	//end if

	if (IDOK == IAddRoute.DoModal()) 
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
					IAddRoute.m_HostNetGwayAddr.IsEmpty() &&
							(IAddRoute.m_nAddStatRoutMetric == 0))
		{  // If all are empty no need to add and delete.
			m_HAdd.SetFocus() ;
			return ;		
		}

		m_HRouteList.DeleteString(n_Index);	//Delete the edited old string.

		CString Str;
		Str = IAddRoute.m_HostNetAddr + '\t';
		if (IAddRoute.m_HostNetAddr.GetLength() < 9)
			Str += '\t';
		Str += IAddRoute.m_HostNetGwayAddr + '\t';
		if (IAddRoute.m_HostNetGwayAddr.GetLength() < 10)
			Str += '\t';
		Str += IAddRoute.m_AddressMask + '\t';
		if (IAddRoute.m_AddressMask.GetLength() < 10)
			Str += '\t';

		// Modified by cfp on 9-4-96
//		Str += IAddRoute.m_HostNetMetric;
		char szMetric[10] ;
		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		Str += szMetric ;
		Str += '\t';

		// Modified by Ravi on 16-08-99
		char szPort[10] ;
		itoa (IAddRoute.m_PhysicalPort, szPort, 10) ;
		Str += szPort ;

		m_HRouteList.AddString(Str);		//Add the new string.
	}	//end if (IDOK == ......)

//	Update the remove & edit buttons.
	m_HRemove.EnableWindow(m_HRouteList.GetSelCount());
	m_Edit.EnableWindow(m_HRouteList.GetSelCount() == 1);
	m_HAdd.SetFocus() ;
}

void CIPHRoute::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_IP_HOST_ROUTES,HELP_CONTEXT);
}

// -------------------------------------------------------------------------
// Function             :	CIPHRoute::OnInitDialog()
// Arguments            :  None.
// Synopsis             :  Adjust the tabs and display the routes inside
//									the listbox, after reading the routes from the
//									ini file.
// Returns              :  None.
// Globals Affected     :  m_HRouteList.
// -------------------------------------------------------------------------
BOOL CIPHRoute::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	CenterWindow() ; 
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

        // Set Bmps

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HRLP bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!AddBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBitmapBtn.SubclassDlgItem (IDC_BUTTON_HOST_ADD, this));
	AddBitmapBtn.SizeToContent();


	if (!DelBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Delete bitmap");

	VERIFY (DelBitmapBtn.SubclassDlgItem (IDC_BUTTON_HOST_REMOVE, this));
	DelBitmapBtn.SizeToContent();


	if (!EditBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Edit bitmap");

	VERIFY (EditBitmapBtn.SubclassDlgItem (IDC_EDIT, this));
	EditBitmapBtn.SizeToContent();


	// Set the tab positions in the list box for "address", "Gateway"
	// and "Metric" to be displyed properly
	// Get all the current static host entries and add them to
	// the list box
	BYTE	LHSIPStatic[60];
	BYTE	RHStr[300];
	char *comma;
// Added by Ravi for Static Routes
	char prefix_alphabet = 65;
	int prefix_num = 0;

	while (1)
	{
		sprintf ((LPSTR)LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num) ;

		if (!GetPrivateProfileString (IPSectionHeader, (LPCSTR) LHSIPStatic,
					StrNull, (LPSTR) RHStr, sizeof (RHStr),
							(LPCSTR) IniInWinForm))
		{
			break ;
		}

		while (1)
		{
			// Convert ','s to \t to do the display
			if ((comma = _fstrchr ((char *) RHStr, (int) ',')) != NULL)
			{
				char Str[80] ;		// Store the string which will be displayed.
	   		*comma = '\0' ;
				_fstrcpy ((char *) Str, (char *) RHStr) ;		// IP Address
				_fstrcat ((char *) Str, "\t") ;

				//if length is less add one more tab.
				if (_fstrlen ((char *) RHStr) < 9)
					_fstrcat ((char *) Str, "\t") ;

				comma ++ ;
				_fstrcpy ((char *) RHStr, comma) ;

			   if ((comma = _fstrchr ((char *) RHStr, (int) ',')) != NULL)
				{
	      		*comma = '\0' ;
					_fstrcat ((char *) Str, (char *) RHStr) ;		// Gateway Addr
					_fstrcat ((char *) Str, "\t") ;

					// if length is less add one more tab.
					if (_fstrlen ((char *) RHStr) < 10)
						_fstrcat ((char *) Str, "\t") ;

					comma ++ ;
					_fstrcpy ((char *) RHStr, comma) ;

					if ((comma = strchr ((char *) RHStr, (int) ',')) != NULL) 
					{
		      		*comma = '\0' ;
						_fstrcat ((char *) Str, (char *) RHStr) ;		// Addr Mask
						_fstrcat ((char *) Str, "\t") ;

						// if length is less add one more tab.
						if (_fstrlen ((char *) RHStr) < 10)
							_fstrcat ((char *) Str, "\t") ;

						comma ++ ;
						_fstrcpy ((char *) RHStr, comma) ;

						if ((comma = strchr ((char *) RHStr, (int) ',')) != NULL) 
						{
			      		*comma = '\0' ;
							_fstrcat ((char *) Str, (char *) RHStr) ;		// Metric
							_fstrcat ((char *) Str, "\t") ;

							// if length is less add one more tab.
//							if (_fstrlen ((char *) RHStr) < 10)
//								_fstrcat ((char *) Str, "\t") ;

							comma ++ ;
							_fstrcpy ((char *) RHStr, comma) ;

							if ((comma = strchr ((char *) RHStr, (int) ';')) != NULL) 
							{
				      		*comma = '\0' ;
							_fstrcat ((char *) Str, (char *) RHStr) ;		// Port

							comma ++ ;
							_fstrcpy ((char *) RHStr, comma) ;

							// Add the string to the listbox.
							m_HRouteList.AddString (Str) ;
							}
							else 
							{
								break ;
							}
						}
						else
						{
							break;
						}
					} 
					else
					{
						break ;
					}
		      }
				else 
				{
					break ;
				}
   		}
			else
			{
				break ;
			}
		}

		prefix_alphabet++ ;		// Prepare for reading next entry in ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	m_nOldCount = m_HRouteList.GetCount() ;	// Store the no. of entries.

	//	Update the remove & edit buttons.
	m_HRemove.EnableWindow (FALSE) ;
	m_Edit.EnableWindow (FALSE) ;

	// Update dialog data.
	UpdateData (FALSE) ;

	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void CIPHRoute::OnCancel()
{
	CDialog::OnCancel();
}

// -------------------------------------------------------------------------
// Function             :	CIPHRoute::OnOK()
// Arguments            :  None.
// Synopsis             :  Update the ini file by writing the static host 
//									routes from the listbox.
// Returns              :  None.
// Globals Affected     :  None.
// -------------------------------------------------------------------------
void CIPHRoute::OnOK()
{
	BYTE	LHSIPStatic[80];
	BYTE	RHStr[80];
	char *comma;
	char prefix_alphabet = 65;
	int prefix_num = 0;

	int n_Count = m_HRouteList.GetCount() ;

	for (int i = 0 ; i < n_Count ; i ++) 
	{
		sprintf ((LPSTR)LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num);
		m_HRouteList.GetText (i, (LPSTR) RHStr) ;  

		// Convert '\t's to ','s to store.
		if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
		{
			BYTE Str[60] ;		// To store the string to be written to ini file.

			*comma = '\0' ;
			_fstrcpy ((char *) Str, (char *) RHStr) ;	// IP Address
			_fstrcat ((char *) Str, ",") ;
	   	comma ++ ;

			// if more tab then increment the pointer.
			while (*comma == '\t')
				comma ++ ;	
			_fstrcpy ((char *) RHStr, comma) ;

		   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
			{
	      	*comma = '\0' ;
				_fstrcat ((char *) Str, (char *) RHStr) ;	 // Gateway Address
				_fstrcat ((char *) Str, ",") ;
				comma ++ ;

				// if more tabs then increment the pointer.
				while (*comma == '\t')
					comma ++ ;

				_fstrcpy ((char *) RHStr, comma) ;

			   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
				{
	   	   	*comma = '\0' ;
					_fstrcat ((char *) Str, (char *) RHStr) ;	 // Address Mask
					_fstrcat ((char *) Str, ",") ;
					comma ++ ;

					// if more tabs then increment the pointer.
					while (*comma == '\t')
						comma ++ ;

					_fstrcpy ((char *) RHStr, comma) ;

				   if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
					{
	   		   	*comma = '\0' ;
						_fstrcat ((char *) Str, (char *) RHStr) ;	 // Metric
						_fstrcat ((char *) Str, ",") ;
						comma ++ ;

						// if more tabs then increment the pointer.
						while (*comma == '\t')
							comma ++ ;

						_fstrcat ((char *) Str, comma) ;	  // Port
						_fstrcat ((char *) Str, ";") ;
					}

					WritePrivateProfileString (IPSectionHeader,
						(LPCSTR) LHSIPStatic, (LPSTR) Str, (LPCSTR) IniInWinForm) ;
				}
	      }
		}
		prefix_alphabet++ ;		// Prepare for writing next entry to ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	// if no. of old entries is more than new, the excess entries need to
	// be blanked out.
	for (i = n_Count ; i < m_nOldCount ; i ++)
	{
		sprintf ((LPSTR)LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num);
	 	WritePrivateProfileString (IPSectionHeader,
	 			(LPCSTR) LHSIPStatic, NULL, (LPCSTR) IniInWinForm) ;

		prefix_alphabet++ ;		// Prepare for writing next entry to ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	CDialog::OnOK() ;
}

/////////////////////////////////////////////////////////////////////////////
// CAddRoute dialog


CAddRoute::CAddRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CAddRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddRoute)
	m_HostNetAddr = "";
	m_HostNetGwayAddr = "";
	m_AddressMask = "";
	m_nAddStatRoutMetric = 1;
	m_PhysicalPort = 0;
	//}}AFX_DATA_INIT

}

void CAddRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddRoute)
	DDX_Control(pDX, IDC_ADD_STAT_ROUT_METRIC, m_AddStatRoutMetricWnd);
	DDX_Control(pDX, IDC_EDIT4, m_MaskWnd);
	DDX_Control(pDX, IDC_EDIT2, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT1, m_AddrWnd);
	DDX_Text(pDX, IDC_EDIT1, m_HostNetAddr);
	DDX_Text(pDX, IDC_EDIT2, m_HostNetGwayAddr);
	DDX_Text(pDX, IDC_EDIT4, m_AddressMask);
	DDX_Text(pDX, IDC_ADD_STAT_ROUT_METRIC, m_nAddStatRoutMetric);
	DDX_CBIndex(pDX, IDC_PORT, m_PhysicalPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAddRoute, CDialog)
	//{{AFX_MSG_MAP(CAddRoute)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_PORT, OnSelchangePort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAddRoute message handlers

void CAddRoute::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_IP_ADD_ROUTE,HELP_CONTEXT);
}

void CAddRoute::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

// -------------------------------------------------------------------------
// Function             :	CAddRoute::OnOK()
// Arguments            :  None.
// Synopsis             :  Validate various edit fields.
// Returns              :  None.
// Globals Affected     :  m_NRouteList.
// -------------------------------------------------------------------------
void CAddRoute::OnOK()
{
	char x[10];
	unsigned long subnet_mask;

	if(!UpdateData(TRUE))
		return;

	if (!m_HostNetAddr.IsValid() || m_HostNetAddr.IsEmpty() || m_HostNetAddr == ZeroIPAddress)
	{
		RouMsgBox(MSG_IP_INV_ADDR, MSG_IP_STATIC, 
						MB_OK | MB_ICONEXCLAMATION);
		m_AddrWnd.SetFocus();
		return;
	}

	if ((m_HostNetGwayAddr == "DHCP Assigned") ||  (m_HostNetGwayAddr == "ISP Assigned"))
		m_HostNetGwayAddr = ZeroIPAddress;

	if (m_HostNetGwayAddr != ZeroIPAddress)
	{
		if(!m_HostNetGwayAddr.IsValid() || m_HostNetGwayAddr.IsEmpty())
		{
			RouMsgBox(MSG_IP_INV_ADDR, MSG_IP_STATIC, 
							MB_OK | MB_ICONEXCLAMATION);
			m_GwayWnd.SetFocus();
			return;
		}
	}

#ifndef BOOTP
	char NewHeader[100] ;
	strcpy ((LPSTR) NewHeader, (LPCSTR) m_AddressMask) ;
#endif

	if(!m_AddressMask.IsValid() || m_AddressMask.IsEmpty()
#ifndef BOOTP
						|| m_AddressMask == ZeroIPAddress
						|| !verify_ip_subnet_mask ((char *) NewHeader))
#endif
	{
/* Added by Ravi */
		get_ip_address (m_AddressMask, &subnet_mask) ;
		if (subnet_mask != 0xFFFFFFFF)		
		{
			RouMsgBox(MSG_IP_INV_PORT_MASK, MSG_IP_STATIC, 
							MB_OK | MB_ICONEXCLAMATION);
			m_MaskWnd.SetFocus();
			return;
		}
	}

#ifdef BOOTP
	char NewHeader[100] ;
#endif
	// Modified by cfp on 12-4-96
	if ((m_nAddStatRoutMetric < MIN_METRIC) ||
				(m_nAddStatRoutMetric > MAX_METRIC))
	{
	   char ErMessage[128] ;
		sprintf (ErMessage, "Invalid Metric.\n Must be %d to %d",
				   	MIN_METRIC, MAX_METRIC) ;

		ModifyHeader (MSG_IP_STATIC, NewHeader) ;
		MessageBox (ErMessage, NewHeader, MB_OK | MB_ICONEXCLAMATION);
		m_AddStatRoutMetricWnd.SetFocus() ;
		return;
	}

	if (!GateWayAddressMatches())
	{
		ModifyHeader (MSG_IP_STATIC, NewHeader) ;
		::MessageBox ((HWND) GetSafeHwnd(), 
				"Gateway address does not match", (LPCSTR) NewHeader,
							MB_OK | MB_ICONINFORMATION) ;
		m_GwayWnd.SetFocus();
		return ;
	}

#ifndef BOOTP

#endif

	UpdateData(FALSE);

	CDialog::OnOK();
}

BOOL CAddRoute::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow(); 
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

        //Set BitMaps

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (m_HostNetGwayAddr == ZeroIPAddress)
		OnSelchangePort();

	return TRUE;  // return TRUE  unless you set the focus to a control
}
//////////////////////////////////////////////////////////////////////////
// COurList listbox

BEGIN_MESSAGE_MAP(COurList,CListBox)
	//{{AFX_MSG_MAP(COurList)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()  

void COurList::OnLButtonDown(UINT nFlags, CPoint point)
{
	CListBox::OnLButtonDown(nFlags, point);
//	((CIPHRoute *)GetParent())->m_Edit.EnableWindow(((CIPHRoute *)GetParent())->m_HRouteList.GetSelCount()==1);
//	((CIPHRoute *)GetParent())->m_HRemove.EnableWindow(((CIPHRoute *)GetParent())->m_HRouteList.GetSelCount());
}

void CIPHRoute::OnSelcancelListHostRoutes()
{
	// TODO: Add your control notification handler code here

}

void CIPHRoute::OnSelchangeListHostRoutes()
{
	// TODO: Add your control notification handler code here
	
	((CIPHRoute *)this)->m_Edit.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount()==1);
	((CIPHRoute *)this)->m_HRemove.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount());
}


int	CAddRoute::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}


BOOL CAddRoute::GateWayAddressMatches()
{
	CIPHRoute *pFather = (CIPHRoute *) GetParent() ;
	CIPConfig *pGrandFather = (CIPConfig *) pFather->GetParent() ;
	int index ;

	if (!pGrandFather->UpdateData (TRUE))
		return FALSE;

	if (m_PhysicalPort == 0)
	{
		if (IsGateWayAddressOnSameNet(pGrandFather->m_SecuredLANIPAddrStr, pGrandFather->m_SecuredLANMskStr))
			return TRUE;
		else
			return FALSE;
	}

	if (m_PhysicalPort == 1)
	{
		if (!pGrandFather->m_DHCPClientEnabled)
		{
	        if (IsGateWayAddressOnSameNet(pGrandFather->m_InternetLANIPAddrStr, pGrandFather->m_InternetLANMskStr))
				return TRUE;
			else	
				return FALSE;
		}
		else
		 	return TRUE;
	}

	if (m_PhysicalPort == 2)
	{
		if (!pGrandFather->m_ISPCheck)
		{
	        if (IsGateWayAddressOnSameNet(pGrandFather->m_WANIPAddrStr, pGrandFather->m_WANMskStr))
    	        return TRUE;
			else
				return FALSE;
		}
		else
	        return TRUE;
	}

	return FALSE;
}

BOOL CAddRoute::IsGateWayAddressOnSameNet(CString Address, CString NetMask)
{
        CDotDecimal DotAddress = Address, DotNetMask = NetMask;
	if (!DotAddress.IsValid())
		return FALSE ;
	if (!DotNetMask.IsValid())
		return FALSE;
	if (RmtLocalIpAddressesOfSameNet ((LPCSTR) DotAddress,
					  (LPCSTR) m_HostNetGwayAddr,
					  (LPCSTR) DotNetMask))
	{
		return TRUE ;
	}
	return FALSE ;
}

void CAddRoute::OnSelchangePort()
{
	CIPHRoute *pFather = (CIPHRoute *) GetParent() ;
	CIPConfig *pGrandFather = (CIPConfig *) pFather->GetParent() ;

	UpdateData(TRUE);		
	
	if (m_PhysicalPort == 0)
	{
		m_HostNetGwayAddr = "";
		m_GwayWnd.EnableWindow(TRUE);
	}

	if (m_PhysicalPort == 1)
	{
		if (pGrandFather->m_DHCPClientEnabled)
		{
			m_HostNetGwayAddr = "DHCP Assigned";
			m_GwayWnd.EnableWindow(FALSE);
		}
		else
		{
			if(m_HostNetGwayAddr == "DHCP Assigned" || m_HostNetGwayAddr == "ISP Assigned")
				m_HostNetGwayAddr = "";

			m_GwayWnd.EnableWindow(TRUE);
		}
	
	}

	if (m_PhysicalPort == 2)
	{
		if (pGrandFather->m_ISPCheck)
		{
			m_HostNetGwayAddr = "ISP Assigned";
			m_GwayWnd.EnableWindow(FALSE);
		}
		else
		{
			if(m_HostNetGwayAddr == "DHCP Assigned" || m_HostNetGwayAddr == "ISP Assigned")
				m_HostNetGwayAddr = "";

			m_GwayWnd.EnableWindow(TRUE);
		}

	}

	UpdateData(FALSE);		
}
