// iproutes.h : header file
//
/////////////////////////////////////////////////////////////////////////////
// COurList	listbox

class COurList	:	public CListBox
{				//To override the OnLButtonDown message handler.
protected:
	//{{AFX_MSG(COurList)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG     
    DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CIPHRoute dialog

class CIPHRoute : public CDialog
{
// Construction
public:
	CIPHRoute(CWnd* pParent = NULL);

// Dialog Data
	//{{AFX_DATA(CIPHRoute)
	enum { IDD = IDD_IP_HOST_ROUTES };
	CButton	m_Edit;
	CButton	m_HRemove;
	CButton	m_HAdd;
	COurList	m_HRouteList;				//Listbox with overridden OnLButtonDown
//	CString	m_FirstHead;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   CBitmapButton AddBitmapBtn;
   CBitmapButton DelBitmapBtn;
   CBitmapButton EditBitmapBtn;

	int m_nOldCount;						//To store the old no. of Entries.
// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CIPHRoute)
	afx_msg void OnButtonHostAdd();
	afx_msg void OnButtonHostRemove();
	afx_msg void OnHelp();
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnEdit();
	afx_msg void OnSelcancelListHostRoutes();
	afx_msg void OnSelchangeListHostRoutes();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CAddRoute dialog

class CAddRoute : public CDialog
{
// Construction
public:
	CAddRoute(CWnd* pParent = NULL);
	// Constructor with pointers :
	//			to the text displayed as <Host/Network Address> and
	//			to the title of the dialog.

// Dialog Data
	//{{AFX_DATA(CAddRoute)
	enum { IDD = IDD_IP_ADD_ROUTE };
	CEdit	m_AddStatRoutMetricWnd;
	CEdit	m_MaskWnd;
	CEdit	m_GwayWnd;
	CEdit	m_AddrWnd;
	CDotDecimal	m_HostNetAddr;
	CDotDecimal	m_HostNetGwayAddr;
	CString	m_AddressText;
	CDotDecimal	m_AddressMask;
	UINT	m_nAddStatRoutMetric;
	int		m_PhysicalPort;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;

	char m_szTitle[100];			//Stores the title of the dialog.

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL GateWayAddressMatches (void) ;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CAddRoute)
	afx_msg void OnHelp();
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
   afx_msg BOOL IsGateWayAddressOnSameNet(CString Address, CString NetMask);
	afx_msg void OnSelchangePort();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

