
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "ui.h"
#include "mem.h"
#include "uart.h"

/*--------------------------------------------------------------------------
File        : lzwc.c
Purpose     : This contains the routine for data compression on the lines 
            : proposed by the Lempel-Ziv-Welch algorithm
Package     : RLN SERVER
Authors     : KP
Date        : 5th July'93
--------------------------------------------------------------------------*/


#define INIT_BITS 		9
#define MAX_BITS 		9  //10				/* Not to exceed 14 */
#define HASHING_SHIFT  (MAX_BITS - 8)

#define TABLE_SIZE  521//1031			/* 521 for 9 bits */
#define  CLEAR_TABLE 	256		/* Code to flush the string table */
#define  TERMINATOR  	257		/* To mark EOF condition,instead of MAX_VALUE */
#define  FIRST_CODE		258		/* First available code for code value table */
#define  CHECK_TIME		100		/* Chk comp ratio every CHECK_TIME chars ip */
#define  MAXVAL(n) ((1 << n)-1) /* Max_value formula macro */

int CodeValue[TABLE_SIZE];		 /* This is the code value array */
word PrefixCode[TABLE_SIZE];	/* This array holds the prefix codes */
byte AppendChar[TABLE_SIZE];	/* This array holds the appended chars */
static byte far *DestPtr;
static dword InSize;
static int NumBits = INIT_BITS;         /* Starting with 9 bit codes */
static dword BytesIn = 0, BytesOut = 0; /* Used to monitor compression ratio */
static int MaxCode;			         /* old MAX_CODE */
static dword CheckPoint = CHECK_TIME;   /* For compression ratio monitoring */
static int output_bit_count = 0;
static dword output_bit_buffer = 0L;

int dnld_size=0;
int nacks=0;
int SEQ=0;
byte *dnld_data;
int FindMatch(int , word );
int OutputCode(word );
int on_dnld_data(byte *, dword);

extern dword ComprCodeSize;
extern byte crc_buff[];
byte crc_dup[257];
byte snd_buff[1224];
int snd_i=0;
extern void updatecrc(byte);
extern void snd_abort_pkt();
extern void show_progress(dword, byte);
extern void clear_uart_buff();
extern void delay();
extern int TOTAL_TIME_TICKS, time_on, time_ticks, dt_count, no_of_pkts, no_of_errors, no_of_dt_pkts;
extern byte ABORT_FLAG, current_pkt, SHOW_CLK_TICKS;


/*---------------------------------------------------------------------------
Name		: Compress
Input		: Input buf ptr, Output buf ptr
Output		: 0 or -1
Synopsis	: Compresses the input buf using the LZW algorithm
---------------------------------------------------------------------------*/
int LZWcompress(FILE *code_fl, dword size)
{
	word next_code = FIRST_CODE, character, string_code, index;
	int i;				/* All purpose integer */
	int ratio_new;		/* New compression ratio as a percentage */
	int ratio_old=100;		/* Original ratio at 100% */
	dword count = 0;
	int eof_flag=0;
	int rtn_val = -1;
	dword my_count=0;
#if 0	
	_asm {
		mov		bx,OFFSET InLZW		/* Get addr of LZW flag */
		mov		al,TRUE						/* al = 1 */
		xchg	al,[bx]						/* Force setting of flag */
		mov		val,al
	}
	if (val)
		return(-1);
#endif
	output_bit_count = 0;
	output_bit_buffer = 0;
	NumBits = INIT_BITS;
	BytesIn = BytesOut = 0;
	CheckPoint = CHECK_TIME;
	MaxCode = MAXVAL(NumBits);		/* Initialize max_value * max_code */
/*	DestPtr = output;  */
	InSize = size;
	for (i = 0;i < TABLE_SIZE; i++)	  /* Initialize the string table first */
		CodeValue[i] = -1;
	string_code = fgetc(code_fl); 
	count++;		  /* Get the first code */
	my_count++;
	dnld_data=(byte *)GetMem(sizeof(byte)*1025);
	while (1) {
		if (count==size)
			break;								/* Input data over */
		character = fgetc(code_fl);
		count++;
		my_count++;
		if (my_count==1024)
			{
		     no_of_dt_pkts++;
			  my_count=0;
			}

		index = FindMatch(string_code, character);
		if (CodeValue[index] != -1) 
			string_code = CodeValue[index];
		else {
			if (next_code <= (word)MaxCode) {
				CodeValue[index] = next_code++;
				PrefixCode[index] = string_code;
				AppendChar[index] = (byte)character;
			}
			if (OutputCode(string_code) < 0)
				goto xit;
			string_code = character;
			if (next_code > (word)MaxCode) {			/* Is Table full? */
				if (NumBits < MAX_BITS) { 		/* Any more bits? */
#ifdef	DO_DEBUG
	kprintf("Table got full ");
#endif
					MaxCode = MAXVAL(++NumBits); /* Inc code size then */
				}
				else if (BytesIn > CheckPoint) { 		/* At Check Point? */
					if (NumBits == MAX_BITS > MaxCode) {
													    /* New Comp. ratio */
						ratio_new = (int)(BytesOut * 100 / BytesIn);
						if (ratio_new > ratio_old) {
												/* Yes, Flush string table */
							if (OutputCode(CLEAR_TABLE) < 0)
								goto xit;
							NumBits = INIT_BITS;
							next_code = FIRST_CODE; /* Reset to FIRST CODE */
												/* ReInitialise this stuff */
						 	MaxCode = MAXVAL(NumBits);
							BytesIn = BytesOut = 0;
							ratio_old = 100;	/* Reset compression ratio */
									/* Reset CodeValue array */
							for(i = 0;i < TABLE_SIZE; i++)
								CodeValue[i] = -1;
						}
						else
							ratio_old = ratio_new;
					}
					/* Set new checkpoint */
					CheckPoint = BytesIn + CHECK_TIME;
				}
			}
		}
	}
	if (OutputCode(string_code) < 0)
		goto xit;
	if (next_code == (word)MaxCode) {		/* Handles special case for bit */
		if (NumBits == MAX_BITS)
			goto xit;					/* Can't increment more */
		++NumBits;						/* increment on EOF */
	}
	if (OutputCode(TERMINATOR) < 0)
		goto xit;
	if (OutputCode(0) < 0)
		goto xit;
	if (OutputCode(0) < 0)
		goto xit;
	if (OutputCode(0) < 0)
		goto xit;
	rtn_val = (int)BytesOut;
	xit:

#if 0
	if (AppendChar);
//		ReleaseMem(AppendChar);
	if (PrefixCode) ;
//		ReleaseMem((byte *)PrefixCode);
	if (CodeValue);
//		ReleaseMem((byte *)CodeValue);
#endif

#if 0
	InLZW = FALSE;
#endif
  if (dnld_size > 0 && !ABORT_FLAG)
  	 {
	   on_dnld_data(dnld_data, size);    
	 }
	ReleaseMem((byte *)dnld_data);
	return(rtn_val);
}

/*---------------------------------------------------------------------------
Name		: FindMatch
Input		: The hashing prefix, The hash character
Output		: The index in the code value table
Synopsis	: This is the hashing routine
---------------------------------------------------------------------------*/
int FindMatch(int hash_prefix, word hash_character)
{
	int index, offset;

	index = (hash_character << HASHING_SHIFT) ^ hash_prefix;
	if (index == 0)
		offset = 1;
	else
		offset = TABLE_SIZE - index;
	while(1) {
		if (CodeValue[index] == -1)
			return(index);
		if ((PrefixCode[index] == (word)hash_prefix) && 
								(AppendChar[index] == (byte)hash_character))
			return(index);
		index -= offset;
		if (index < 0)
			index += TABLE_SIZE;
	}
}

/*---------------------------------------------------------------------------
Name		: OutputCode
Input		: Output buf ptr, codeword 
Output		: 0 or -1
Synopsis	: Outputs a variable length code
---------------------------------------------------------------------------*/
int OutputCode(word code)
{
	output_bit_buffer |= (dword)code << (32 - NumBits - output_bit_count);
	output_bit_count += NumBits;
	while (output_bit_count >= 8) {
	/*	*DestPtr++ = (byte)(output_bit_buffer >> 24); */
		dnld_data[dnld_size]=(byte)(output_bit_buffer >> 24);
		updatecrc(dnld_data[dnld_size]);
		output_bit_buffer <<= 8;
		output_bit_count -= 8;
		BytesOut++;		/* For Compression Monitoring */
		dnld_size++;
		if (dnld_size==1024) 
			{ /*----data is of size 1K-----*/
		     if (on_dnld_data(dnld_data, InSize) < 0)
				 {
					 /*----Down load Aborted----*/
			       dnld_size=0;
					 return(-1);
				 }
			  dnld_size=0;
			}
		if (BytesOut == (dword)InSize) {
#ifdef DO_DEBUG
	kprintf("LZWC failed ");
#endif
			return(-1);
		}
	}
	return(0);
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_dnld_data(str, flsz)												 */
/* PURPOSE       : To send a data packet of length flsz 								 */
/* PARAMETERS    : str																			 */
/*                   -an array of bytes													 */
/*                   -holds the data to be down loaded								 */
/*                 flsz																			 */
/*                   -double word															 */
/*                   -holds the file size of the file being down loaded			 */
/* RETURN VALUE  : returns an integer indicating whether down load was 			 */
/*                 successfull																 */
/*-----------------------------------------------------------------------------*/
int on_dnld_data(byte *str, dword flsz)
  {
	 int i=0;
	 int key=0;
	 static int seqnum=1;
	 dnld_data_type dnld_dt;
	 DnLdPktHdrType hdr_type;
	 while (i < dnld_size)      /*----copy the data into the packet-----*/
		 {
		   dnld_dt.data[i]=str[i];
			i++;
		 }
	  seqnum=SEQ;

	  /*------initialise the data packet-------*/

	  dnld_dt.hdr.PacketType=PT_DATA;
	  dnld_dt.hdr.SeqNum=(byte)SEQ;
	  hdr_type.PacketType=PT_NACK;
	  current_pkt=dnld_dt.hdr.PacketType;
	  ComprCodeSize += dnld_size;
	  TOTAL_TIME_TICKS=155;
	  SHOW_CLK_TICKS=(byte)0;
	  nacks=0;

	  while (hdr_type.PacketType!=PT_ACK)
	    {
			 no_of_pkts++;
	       current_pkt=dnld_dt.hdr.PacketType;
			 show_progress(flsz, 1);
//			 display_string((byte *)"Data Packet", 0x1010, 0x1f, (void *)0);
//			 getch();
          /*----send the data packet-------*/
			 clear_uart_buff();
	       snd_packet((byte *)&dnld_dt, sizeof(DnLdPktHdrType)+dnld_size);
			 time_on=1;
	       if (rcv_dnld_packet((byte *)&hdr_type, sizeof(hdr_type)))
				 {
				   no_of_errors++;
			      continue;
				  }
			 current_pkt=hdr_type.PacketType;
			 show_progress(flsz, 0);
			 if (_kbhit())
			    {
					 /*----a key has been pressed-----*/
					 key=getch();
				    if (!key)
					   key=getch();
					 if (key==27)
						{
						  /*-----Esc key has been pressed ! send an abort packet---*/
					     SEQ=seqnum+1;
					     snd_abort_pkt();
					     ABORT_FLAG=(byte)1;
					     return(-1);
						}
				 }
			 if (time_ticks < 155)
				{
	  	         switch(hdr_type.PacketType)
			        {
			           case PT_ABORT :	/*----Abort Packet from the Target----*/
			 	                        error_win((byte *)" Down Load Aborted", 20, 10, 23);    
								            ABORT_FLAG=(byte)1;
			 					            return(-1);
												break;
						  case PT_NACK  : no_of_errors++;
						                  my_strcpy((byte *)crc_dup, (byte *)crc_buff);
						                  break;
			         }
				 }
			 else
				 {	/*------no response from the target-------*/
			      error_win((byte *)"Time Out", 18, 10, 24);
					ABORT_FLAG=(byte)1;
				   return(-1);
				 }
		 }
	  seqnum++;
	  SEQ=seqnum;
	  return(0);
  }
/*-----------------------------------------------------------------------------*/


