// Start Date                   :       8th May 1995
// Author                   	  :       Pravin
// Date Last Modified   		  :       
// Modifications : Vidy changed for PPP local&remote options
// Modifications : Vidy changed for Static host and Static Net routes list
// Modifications : Pravin changed for automatic dialing while coming up,
//						 if dial string is present in SETUP.INI.
//	Modifications : Vidy 7/11/95 added LSL and PPP section updates depending
//						on the WAN number of Ports
//						:Vidy	19/12/95 ADDED close and reopen of IniInWinForm
//						in WriteRouterIni - bug fix for config write fails
//	Modifications : Sachin added stuff for TFTP
//	Modifications : Sachin added stuff for Filtering
//	Modifications : Sachin made changes in all dialogs to change the caption
//                 to reflect the product's name
//	Modifications : Chidanand - Apr 1997 - made changes for Version 3.00
//					Supporting Dial Backup, Frame Relay, Terminal Server, 
//					Dumb TTY.
//					Also added features for Avoiding Reading setup if it is same
//					and Configuration Periodic Lock Management
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "lsldlg.h"
#include "stdlg.h"
#include "pppdlg.h"
#include "locport.h"
#include "diagnost.h"
#include "cnfread.h"
#include "wandlg.h"
#include "msgumain.h"
#include "msguview.h"
#include "boot.h"
#include "reboot.h"
#include "check.h"
#include "terminal.h"
#include "dialdlg.h"
#include	"applicat.h"
#include	"tftpread.h"
#include "tftpwrit.h"		// name was longer than 8.3 format. win95 wont work
#include "telnet.h"
//#include "wanrf200.h"
#include "ipfilter.h"
#include	"proxy.h"
#include	"ipprx.h"
#include	"ipconfig.h"
#include	"dhcpk.h"
#include "dhcp.h"
#include "portstat.h"
#include <winsock.h>
#include "tftpif.h"    //Neelu on 03-02-99
#include "mainfrm.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*-----------Neelu FOr NAT-------------*/

#include "natdlg.h"

/*-------------------------------------*/

#define WM_KBHIT       (WM_USER + 60)
#define WM_TERM_CLOSE  (WM_USER + 61)
#define WM_TELNET_READ (WM_USER + 62)
//#define MAX_LENGTH_USER_NAME  15


#define 	EVENT_TIMERID 	0xfe11


//#define WM_EVENT       (WM_USER + 63)
/*#define EVENT_PORT     1023*/

extern char UserDataFile[FILE_NAME_SIZE]; //Neelu for Event broadcast

// -------------------------------------------------------------------------
//  Timer related constants
// -------------------------------------------------------------------------
#define dChkTargetTimerID 1
#define dDNldBINChkTimerID 2
#define dDNldBINPassWordRespTimerID 3
#define dDNldBINChkRespTimerID 4
#define dDNLdBinAbortTimerID 5
#define dReadConfigTimerID 7
#define dReadConfigTimerID2 8
#define dChkRouterTimerID 9
#define dChkRouterTimerID2 10		// 9
#define dChkRouterTimerID3 11
#define dPassWordRespTimerID 12	// 10
#define dAbortTimerID 13	 // 12
#define dDnldCNFTimerID 14  // 13
#define dReadRtrVersionTimerID 15	// 1
#define dReadEthAddrTimerID	16  // 1
#define dRebootChkRouterTimerID 17 // 14	
#define dRebootDnldChkTimerID 18 // 15
#define dConnectTimerID1 19 // 2
#define dConnectTimerID2 20 // 3
#define dConnectTimerID3 21 // 4
#define dDisconnectTimerID  22 // 4
#define dGetLockTimerID 23 // 14
#define dFreeLockTimerID 24 // 16
#define dConLockPollTimerID 25	// 17
#define dRebootTimerID 26 // 20
#define TimerCount 4000    //Used for setting 4 Sec. timer.


#define dConLockPollInterval 30*1000
#define dMAX_GET_LOCK_TIMEOUT_TRIES 5

#define PollingTimerID 420
#define PollingInterval 55	//55mSec timer for polling

#define TelnetTimerID 576
#define TelnetTimerPeriod 55

#define CodeTimerID	840
#define CodeInterval 65000   // 65 Sec. timer for downloading code.

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         

#define Max_exitcount 0xff00 //Comeout if packet is not expected.

#define MaxINIString 150   // Maximum length of string in the CNF File.

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static BOOL	ApplicationDone = FALSE;

LPCSTR	MainMsgHeader = "Firewall Setup";

extern	int	CommandLineArgument;
/* sudha 21 Aug 1999 */
char ftp_name[30], ftp_Number1[10], ftp_Number2[10];


// -------------------------------------------------------------------------
// External Variable Definitions
// -------------------------------------------------------------------------

extern CTRL_FLAG;
extern int GetNumberOfLANPorts();

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog


CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainDlg)
	//}}AFX_DATA_INIT
	bConLockPollTimerActive	= FALSE;
	bGetLockCalledFromTimer = FALSE;
	eUserResponse = E_NONE;
	if (IsPortIP)
		bGotLock = TRUE;
	else
		bGotLock = FALSE;
}

void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlg)
	DDX_Control(pDX, IDC_BUTTON_NAT, m_nat);
	DDX_Control(pDX, IDC_BUTTON_STATISTICS, m_PortStat);
	DDX_Control(pDX, IDC_BUTTON_DHCP, m_DHCPWnd);
	DDX_Control(pDX, IDC_BUTTON_PROXY, m_Proxy);
	DDX_Control(pDX, IDCANCEL, m_Exit);
	DDX_Control(pDX, IDC_HELP, m_Help);
	DDX_Control(pDX, IDC_BUTTON_RETRY, m_Retry);
//	DDX_Control(pDX, IDC_BUTTON_FILTER, m_Filtering);
	DDX_Control(pDX, IDC_BUTTON_APP, m_Applications);
	DDX_Control(pDX, IDC_DNLD_CNF, m_DownloadCNF);
	DDX_Control(pDX, IDC_BUTTON_PCONSOLE, m_PConsole);
	DDX_Control(pDX, IDC_IP, m_IP);
	DDX_Control(pDX, IDC_BUTTON_WAN, m_WAN);
	DDX_Control(pDX, IDC_BUTTON_PPP, m_PPP);
	DDX_Control(pDX, IDC_BUTTON_DIAG, m_Diagnostics);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDlg, CDialog)
	//{{AFX_MSG_MAP(CMainDlg)
	ON_COMMAND(IDC_IP, OnIPConfigure)
	ON_BN_CLICKED(IDC_BUTTON_PPP, OnPPPConfigure)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_DIAG, OnDiagnostics)
	ON_BN_CLICKED(IDC_BUTTON_WAN, OnWAN)
	ON_BN_CLICKED(IDC_BUTTON_PCONSOLE, OnButtonPconsole)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_DNLD_CNF, OnDnldSetup)
	ON_BN_CLICKED(IDC_BUTTON_APP, OnButtonApp)
	ON_BN_CLICKED(IDC_RETRY, OnRetry)
	ON_BN_CLICKED(IDC_BUTTON_PROXY, OnButtonProxy)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_DHCP, OnButtonDhcp)
	ON_BN_CLICKED(IDC_BUTTON_STATISTICS, OnButtonStatistics)
	ON_BN_CLICKED(IDC_BUTTON_NAT, OnButtonNat)
	ON_MESSAGE(WM_TELNET_READ, TelnetRead)
	ON_MESSAGE(WM_KBHIT, TelnetWrite)
	ON_BN_CLICKED(IDC_DEFAULT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int	CMainDlg::RouMsgBox(HWND hWnd, int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = ::MessageBox(hWnd, Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers

// -------------------------------------------------------------------------
// Function             :	CMainDlg::OnInitDialog()
// Arguments            :  None.
// Synopsis             :  Opens COM port for all further communication.
//									Checks the target only if Dial String is absent.
//									Initializes Button State. Initializes print console
// Returns              :  TRUE.
// Globals Affected     :  TargetFound, RouterUp.
// -------------------------------------------------------------------------
BOOL CMainDlg::OnInitDialog()
{
	CWnd *pWnd;
	RECT rcDlg, rcControl;
	int temp;
	CDialog::OnInitDialog() ;
	CenterWindow() ;
	int InitSock;
	int error_code=0;
//	char local[25] ,local1[25] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	HWND hwnd;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

        // Show BitMaps
	pWnd = GetDlgItem(IDC_BUTTON_LOGO);
	if (pWnd)
	{
		GetWindowRect(&rcDlg);
		ScreenToClient(&rcDlg);
		pWnd->GetWindowRect(&rcControl);
		ScreenToClient(&rcControl);
		temp = (rcDlg.right - rcDlg.left)/2 - (rcControl.right - rcControl.left)/2;
		pWnd->MoveWindow(temp, rcControl.top, rcControl.right-rcControl.left, rcControl.bottom - rcControl.top, 1);
	}


	if (!LogoBitmapBtn.LoadBitmaps ("LOGO"))
		AfxMessageBox ("Failed to load LOGO bitmap");

	VERIFY (LogoBitmapBtn.SubclassDlgItem (IDC_BUTTON_LOGO, this));
	LogoBitmapBtn.SizeToContent();

	pWnd = GetDlgItem(IDC_BUTTON_LOGO);
	GetWindowRect(&rcDlg);
	ScreenToClient(&rcDlg);
	pWnd->GetWindowRect(&rcControl);
	ScreenToClient(&rcControl);
	temp = (rcDlg.right - rcDlg.left)/2 - (rcControl.right - rcControl.left)/2;
	pWnd->MoveWindow(rcDlg.left + temp, rcControl.top, rcControl.right-rcControl.left, rcControl.bottom - rcControl.top, 1);


        //Set Bitmaps
	if (!IPBitmapBtn.LoadBitmaps ("IP1", "IP2", "IP3", "IP4"))
		AfxMessageBox ("Failed to load IP bitmap");

	VERIFY (IPBitmapBtn.SubclassDlgItem (IDC_IP, this));
	IPBitmapBtn.SizeToContent();

	if (!PPPBitmapBtn.LoadBitmaps ("PPP1", "PPP2", "PPP3", "PPP4"))
		AfxMessageBox ("Failed to load PPP bitmap");

	VERIFY (PPPBitmapBtn.SubclassDlgItem (IDC_BUTTON_PPP, this));
	PPPBitmapBtn.SizeToContent();

	if (!WANBitmapBtn.LoadBitmaps ("WAN1", "WAN2", "WAN3", "WAN4"))
		AfxMessageBox ("Failed to load WAN bitmap");

	VERIFY (WANBitmapBtn.SubclassDlgItem (IDC_BUTTON_WAN, this));
	WANBitmapBtn.SizeToContent();

	if (!NATBitmapBtn.LoadBitmaps ("NAT1", "NAT2", "NAT3", "NAT4"))
		AfxMessageBox ("Failed to load NAT bitmap");

	VERIFY (NATBitmapBtn.SubclassDlgItem (IDC_BUTTON_NAT, this));
	NATBitmapBtn.SizeToContent();

	if (!ProxyBitmapBtn.LoadBitmaps ("PS1", "PS2", "PS3", "PS4"))
		AfxMessageBox ("Failed to load PROXY bitmap");

	VERIFY (ProxyBitmapBtn.SubclassDlgItem (IDC_BUTTON_PROXY, this));
	ProxyBitmapBtn.SizeToContent();

	if (!DHCPBitmapBtn.LoadBitmaps ("DHCP1", "DHCP2", "DHCP3", "DHCP4"))
		AfxMessageBox ("Failed to load DHCP bitmap");

	VERIFY (DHCPBitmapBtn.SubclassDlgItem (IDC_BUTTON_DHCP, this));
	DHCPBitmapBtn.SizeToContent();

	if (!PConsoleBitmapBtn.LoadBitmaps ("PC1", "PC2", "PC3", "PC4"))
		AfxMessageBox ("Failed to load PConsole bitmap");

	VERIFY (PConsoleBitmapBtn.SubclassDlgItem (IDC_BUTTON_PCONSOLE, this));
	PConsoleBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("HELP1", "HELP2", "HELP3", "HELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!ExitBitmapBtn.LoadBitmaps ("EXIT1", "EXIT2", "EXIT3", "EXIT4"))
		AfxMessageBox ("Failed to load EXIT bitmap");

	VERIFY (ExitBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	ExitBitmapBtn.SizeToContent();

	if (!StatBitmapBtn.LoadBitmaps ("STAT1", "STAT2", "STAT3", "STAT4"))
		AfxMessageBox ("Failed to load Statistics bitmap");

	VERIFY (StatBitmapBtn.SubclassDlgItem (IDC_BUTTON_STATISTICS, this));
	StatBitmapBtn.SizeToContent();

	if (!DSBitmapBtn.LoadBitmaps ("DS1", "DS2", "DS3", "DS4"))
		AfxMessageBox ("Failed to load Download bitmap");

	VERIFY (DSBitmapBtn.SubclassDlgItem (IDC_DNLD_CNF, this));
	DSBitmapBtn.SizeToContent();

	if (!RetryBitmapBtn.LoadBitmaps ("RETRY1", "RETRY2", "RETRY3", "RETRY4"))
		AfxMessageBox ("Failed to load RETRY bitmap");

	VERIFY (RetryBitmapBtn.SubclassDlgItem (IDC_BUTTON_RETRY, this));
	RetryBitmapBtn.SizeToContent();

	if (!AppBitmapBtn.LoadBitmaps ("APP1", "APP2", "APP3", "APP4"))
		AfxMessageBox ("Failed to load Applications bitmap");

	VERIFY (AppBitmapBtn.SubclassDlgItem (IDC_BUTTON_APP, this));
	AppBitmapBtn.SizeToContent();

	if (!DiagBitmapBtn.LoadBitmaps ("DIAG1", "DIAG2", "DIAG3", "DIAG4"))
		AfxMessageBox ("Failed to load Diagnostics bitmap");

	VERIFY (DiagBitmapBtn.SubclassDlgItem (IDC_BUTTON_DIAG, this));
	DiagBitmapBtn.SizeToContent();

//	if (!FilterBitmapBtn.LoadBitmaps ("FILTER1", "FILTER2", "FILTER3", "FILTER4"))
//		AfxMessageBox ("Failed to load Filter bitmap");

//	VERIFY (FilterBitmapBtn.SubclassDlgItem (IDC_BUTTON_FILTER, this));
//	FilterBitmapBtn.SizeToContent();

	// Set all the flags
	TargetFound = ConfigurationRead = RouterUp = RouterWasUp = FALSE;

	// Open port for all communication. And if dial string is present dial.
	if (IsPortIP)
	{
		strcpy (TFTPGetRemoteFileName, "CONFIG.INI") ;
		strcpy (TFTPGetLocalFileName, IniInRtrWareForm) ;

		if (CommandLineArgument != 4)
		{
			tftpread TFTPReadDlg ;
			if (TFTPReadDlg.DoModal() == IDOK) 
			{
				ConfigurationRead = TRUE ;
				InitButtonState() ;  // Sachin 29.11.95
				TargetFound = TRUE ;
				RouterUp = TRUE ; // Sachin 29.11.95
				WriteWinINI() ; // Sachin 28.11.95
			}
			else
			{
				CDialog::OnCancel(); //exit out of config all together
			}
		}
	}
	else
	{  // Read Configuration thro' COM Port

		if (cMiscCom.Open_Comm() && Connect()) 
		{
			SetCapture() ;
		   AfxGetApp()->LoadCursor (IDC_WAIT) ;
		   AfxGetApp()->DoWaitCursor (-1) ;
		   AfxGetApp()->DoWaitCursor (1) ;

		   CCheck cCheck (this) ;  // Display the Checking message
			CheckTarget() ;         // Check the status of Target.

		 if (CommandLineArgument == 6 ) /* Sreelu for upgrade */
       {
        	 cCheck.ShowWindow(FALSE);
		    CDialog::OnCancel(); //exit out of config all together
        	 Disconnect();		//Hangup if the dial string is present in SETUP.INI.
        	 cMiscCom.Close_Comm();     //Close COM port .
        	 AfxGetApp()->DoWaitCursor(0);
        	 ReleaseCapture();
//        PostQuitMessage(0);
			return TRUE;
       }

		 AfxGetApp()->DoWaitCursor (0) ;
		 ReleaseCapture() ;
		}
		else
		{
			// 6th JUNE 1996 - CFP
			// In case OpenComm fails it should not send pkts
			// and loop
			if (idComDev < 0)
			{
				::MessageBox (GetSafeHwnd(), "COM Port busy. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage (0) ;
				return TRUE ;
			}
			InitButtonState(); 	// Enable/disable the buttons
		}
	}

	//	initialize the terminal win
	if (!IsPortIP)
	{
		TermInitTerminal ((AfxGetMainWnd()->m_hWnd), (LPSTR) LoadPath,
										(int FAR *) &idComDev, CommandLineArgument) ;
		EtherNetAddr[0] = NULL ;		
	}

	if	(CommandLineArgument == 4 || CommandLineArgument == 5)
	{
		if ((CommandLineArgument == 4) && (IsPortIP))
		{
			if ((InitializeTelnetClient (GetSafeHwnd())) == -1)
			{
				::MessageBox (GetSafeHwnd(), "Telnet Client could not be initialized. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage (0) ;
				return (TRUE) ;
			}
			if (TelnetTimerID != SetTimer (TelnetTimerID, TelnetTimerPeriod, NULL))
			{
				DeInitializeTelnetClient() ;
				::MessageBox (GetSafeHwnd(), "Telnet Client could not be initialized. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage(0) ;
				return (TRUE) ;
			}
		}
		TermSetFocusTerminal();	 //Set focus to print console.
		return FALSE;
	}
	SetFocus();

#if 0	
// Neelu for Event Broadcast
	
   InitSock = InitialiseSocket(GetSafeHwnd(),&error_code);
	
	if ( InitSock == 0)   //Neelu called for Event broadcast
	{
//	   AfxMessageBox("Socket Initialise");
//	   invoke_the_timer();
	}

// Neelu Ends	
#endif
// Imran, 22.3.99 
	DnldUserEvents();
// Imran, 22.3.99 

/* sudha 17 Aug 1999 */

	char *IniFile = IniInWinForm;
	CStdioFile input (IniFile, CFile::modeRead | CFile::typeText);
	input.Flush();
	input.Close(); 

	//Vidy 25/04/98 the following is to flush the inifile and resync
	//with the disk copy. It will have serious effects if removed
	WritePrivateProfileString(NULL, NULL, NULL, (LPCSTR) IniInWinForm);

	char strRHS[50];
	int ctrl_port = 0, data_port = 0;
	
	ftp_name[0] = '\0';
	ftp_Number1[0] = '\0';
	ftp_Number2[0] = '\0';

	GetPrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Control Connection Configurable Number",
		StrNull, (LPSTR) strRHS, sizeof (strRHS),
		(LPCSTR) IniInWinForm);
	sscanf(strRHS,"%d",&ctrl_port);

	GetPrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Data Connection Configurable Number",
		StrNull, (LPSTR) strRHS, sizeof (strRHS),
		(LPCSTR) IniInWinForm);
	sscanf(strRHS,"%d",&data_port);
	
	sprintf(ftp_name,"FTP(%d,%d)",ctrl_port,data_port);
	sprintf(ftp_Number1,"%05d",ctrl_port);
	sprintf(ftp_Number2,"%05d",data_port);

	int index = 0;
	while (TCPPortStrings[index].Name) 
 	{
		if(strncmp(TCPPortStrings[index].Name, "FTP", 3) != 0)
		{
			index++;
			continue;
		}
		else
		{
			TCPPortStrings[index].Name = ftp_name;
			TCPPortStrings[index].Number1 = ftp_Number1;
			TCPPortStrings[index].Number2 = ftp_Number2;
			break;
		}
	}

	index = 0;
	while (UDPPortStrings[index].Name) 
 	{
		if(strncmp(UDPPortStrings[index].Name, "FTP", 3) != 0)
		{
			index++;
			continue;
		}
		else
		{
			UDPPortStrings[index].Name = ftp_name;
			UDPPortStrings[index].Number1 = ftp_Number1;
			UDPPortStrings[index].Number2 = ftp_Number2;
			break;
		}
	}
	
	return TRUE ;  // return TRUE  unless you set the focus to a control
}	// End of OnInitDialog()

// -------------------------------------------------------------------------
// Function             :	CMainDlg::OnCancel()
// Arguments            :  None.
// Synopsis             :  If configuration is changed confirm to exit.
//									Closes COM port. Closes print console.
// Returns              :  None.
// Globals Affected     :  None.
// -------------------------------------------------------------------------
void CMainDlg::OnCancel()
{
	if (CommandLineArgument == 0 && TargetFound) 
	{			// If target is not found
		if (WriteRouterINI(FALSE)) 
		{    			// If RouterINI is changed ....
			if (IDNO == RouMsgBox (GetSafeHwnd(), MSG_MAIN_CHECK_EXIT, MainMsgHeader,
									MB_YESNO | MB_DEFBUTTON2 | MB_ICONQUESTION))
				return ;
	   }
		else
		{
  			if (IDNO == RouMsgBox (GetSafeHwnd(), MSG_MAIN_CHECK_EXIT_2, MainMsgHeader,
									MB_YESNO | MB_ICONQUESTION))
				return ;
		}
	}
    
    
	//Free the configuration Lock
	// No need to check return value ?
	FreeLock();    
	DeInstallConLockPollTimer();
    
	KillTimer(PollingTimerID);
	Go_on = 2;
	if (!IsPortIP) {
		TermCloseTerminal();			//Close print console.
		SetCapture();
	   AfxGetApp()->LoadCursor(IDC_WAIT);
	   AfxGetApp()->DoWaitCursor(1);

		Disconnect();		//Hangup if the dial string is present in SETUP.INI.

	   cMiscCom.Close_Comm();     //Close COM port .

	   AfxGetApp()->DoWaitCursor(0);
		ReleaseCapture();
	}	//IsPortIP

	CDialog::OnCancel();
	ApplicationDone = TRUE;

}	//End of OnCancel()

void CMainDlg::OnIPConfigure()
{
//	ipprx tagIPPrx (this) ;
//	tagIPPrx.DoModal() ;
	CIPConfig tagIPConfig (this) ;
	tagIPConfig.DoModal() ;

	return ;
}

void CMainDlg::OnPPPConfigure()
{
   AfxGetApp()->LoadCursor (IDC_WAIT) ;
   AfxGetApp()->DoWaitCursor (1) ;

	CPTab cPPPTab (this) ;
	int nRetVal = cPPPTab.DoModal() ;
    
	UpdateData (FALSE);

   m_PPP.SetFocus(); 
	if (nRetVal == IDNO)
		return ;

#if 0
	char szBuf[20] ;
	GetPrivateProfileString (IPSectionHeader, 
		"DHCP", StrDisabled, szBuf, sizeof (szBuf), IniInWinForm) ;
	if (!strcmpi (StrDisabled, szBuf))
		CheckForIPClientOnly (GetSafeHwnd()) ;
#endif
	return ;
}

#if 0
void CMainDlg::OnButtonFilter()
{
	// TODO: Add your control notification handler code here
	IPFiltering IPFilter(this);

	IPFilter.DoModal() ;
	m_Filtering.SetFocus();

}
#endif

void CMainDlg::OnWAN()
{

   AfxGetApp()->LoadCursor (IDC_WAIT) ;
   AfxGetApp()->DoWaitCursor (1) ;

	CWANTab cWANTab (this) ;
	cWANTab.DoModal() ;
	
	// Chida - 28 Apr 1997
	m_WAN.SetFocus();
	InitButtonState(FALSE);
}

// -------------------------------------------------------------------------
// Function          :	CMainDlg::OnDiagnostics()
// Arguments         :  None.
// Synopsis          :  Checks the target.Initializes Button State.
//								Call RebootDnld if Router is up. Run Diagnostics.
//								Call Reboot.
// Returns           :  None.
// Globals Affected	:  TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CMainDlg::OnDiagnostics()
{
	int Retry = 0;
	ReqType  brd_req_type;
	OpenConnectionType bridge1;
	brd_req_type.Ptype = QUERY_BRIDGE_NAME;			//13
   CCheck cCheck(this);			//Display the checking message.

RETRY:
	cMiscCom.TimeOut = FALSE;
	TargetFound = FALSE;
	RouterUp = FALSE;
	
	cCheck.ShowWindow(TRUE);
   UINT nTimerID = dChkRouterTimerID;
	while(nTimerID != SetTimer(nTimerID,(UINT)TimerCount,NULL))
   	if(IDCANCEL == RouMsgBox(GetSafeHwnd(), MSG_GEN_NO_TIMER,MainMsgHeader,MB_RETRYCANCEL | 
								MB_ICONINFORMATION))
			return;                        
	
   while(1)
   {
		cMiscCom.snd_packet((BYTE *)&brd_req_type.Ptype, sizeof(brd_req_type));
		if(!(cMiscCom.rcv_packet((BYTE *)&bridge1, sizeof(bridge1), (BOOL *)&cMiscCom.TimeOut)))
				break;//No CRC error
   }
   if(cMiscCom.TimeOut) {
		if( Retry < 2) {
			Retry++ ;
			goto RETRY;
		}
		RouMsgBox(GetSafeHwnd(), MSG_GEN_NO_ROUTER, MainMsgHeader,MB_OK | MB_ICONINFORMATION);
		InitButtonState();
		return;
	}
   KillTimer(nTimerID);
	if(bridge1.Ptype == RES_TYPE)			//12
	{
		cCheck.ShowWindow(FALSE);
		TargetFound = TRUE;
		BYTE *incor;
		WORD pra;
		incor = (BYTE *)&pra;
		incor[0]=bridge1.BrdName[1];
		incor[1]=bridge1.BrdName[2];
		pra=cMiscCom.ltl_endian_word(pra);
		if (pra == 21)
			RouterUp = TRUE;
	}
	else {
		if (Retry < 1) {
			Retry++ ;
			goto RETRY;
		}
	}

	if (RouterUp) {
		if(IDCANCEL == RouMsgBox(GetSafeHwnd(), MSG_MAIN_ASK_DOWN,
			MainMsgHeader,MB_OKCANCEL | MB_ICONQUESTION)) {
			InitButtonState(FALSE);
			return;
		}
		RebootDnld();
	}
	
	CDiagnostics cDiagnostics(this);
	cDiagnostics.DoModal();

	Reboot(COLD_BOOT_MODE);
} //end of OnDiagnostics()

// -------------------------------------------------------------------------
// Function         :	CMainDlg::OnDnldSetup()
// Arguments        :   None.
// Synopsis         :   Return if setup is not changed.
//								If Router is up Call RebootDnld(). Call DnldCNF().
// Returns          :   None.
// Globals Affected :   TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CMainDlg::OnDnldSetup()
{
	if (!WriteRouterINI(FALSE))
	{ // If RouterINI is not changed ....
		if (RouMsgBox (GetSafeHwnd(), MSG_MAIN_ASK_DNLD, MainMsgHeader, MB_YESNO | 
									MB_ICONQUESTION) == IDNO)
		{
			return ;
		}
	}
	
	
	if (IsPortIP)
	{
		if (RouMsgBox (GetSafeHwnd(), MSG_MAIN_ASK_DOWN, MainMsgHeader,
								MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
		{
			DeInstallConLockPollTimer();
			WriteRouterINI(TRUE);
			strcpy (TFTPPutLocalFileName, IniInRtrWareForm) ;
			strcpy (TFTPPutRemoteFileName, "config.ini") ;
			tftpwrit	TFTPWrite ;

			if (TFTPWrite.DoModal() != IDOK)
				RouMsgBox (GetSafeHwnd(), MSG_MISC_TFTP_DNLD_ERR, MainMsgHeader,
													MB_OK | MB_ICONINFORMATION) ;
			else
			{
				/* Sachin added this to prevent prompting "Setup changed, Do you
				   want to exit ?" in case a download is followed by exit */

				CStdioFile ConfigFile ;
				char *FileName = IniInWinForm ;
				ConfigFile.Open (FileName, CFile::modeRead | CFile::typeText) ;
				ConfigFile.GetStatus (status) ;
				ConfigFile.Close() ;
			}
			InstallConLockPollTimer();
		}
		return ;
	}
    
	DeInstallConLockPollTimer();
    
    // bGotLock = FALSE;
    
	After_Abort = FALSE ;

	int Retry = 0 ;
	ReqType brd_req_type ;
	OpenConnectionType bridge1 ;
	brd_req_type.Ptype = QUERY_BRIDGE_NAME ;			// 13
   CCheck cCheck (this) ;			// Display the checking message.

RETRY :
	cMiscCom.TimeOut = FALSE ;
	TargetFound = FALSE ;
	RouterUp = FALSE ;
	
	cCheck.ShowWindow (TRUE) ;
   UINT nTimerID = dChkRouterTimerID2 ;
   while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
      if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
				MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			InstallConLockPollTimer();
			return ;                        
		}
	}
	
   while (1)
   {
		cMiscCom.snd_packet ((BYTE *) &brd_req_type.Ptype,
													sizeof (brd_req_type)) ;
		if (!(cMiscCom.rcv_packet ((BYTE *) &bridge1,
				sizeof (bridge1), (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;   // No CRC error
		}
   }

   KillTimer (nTimerID) ;
   
	if (cMiscCom.TimeOut) 
	{
		if (Retry < 2)
		{
			Retry ++ ;
			goto RETRY ;
		}
		RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_ROUTER, 
				MainMsgHeader, MB_OK | MB_ICONINFORMATION) ;
		InitButtonState() ;
		InstallConLockPollTimer ();
		return ;
	}

	if (bridge1.Ptype == RES_TYPE)			// 12
	{
		cCheck.ShowWindow (FALSE) ;
		TargetFound = TRUE ;
		BYTE *incor ;
		WORD pra ;
		incor = (BYTE *) &pra ;
		incor[0] = bridge1.BrdName[1] ;
		incor[1] = bridge1.BrdName[2] ;
		pra = cMiscCom.ltl_endian_word (pra) ;
		switch (pra) 
		{
			case ERR_NO_BRD_GET_PASSWORD :			// 18        
				PasswordPktType passwd_pkt ;
				ResultType restype ;
						
				passwd_pkt.Ptype = (BYTE) PASSWD_TYPE ;		// 30 
				passwd_pkt.Password[0] = (BYTE) 'x' ;
				passwd_pkt.Password[1] = (BYTE) '\0' ;
				cMiscCom.snd_packet ((BYTE *) &passwd_pkt, sizeof (passwd_pkt)) ;
				cMiscCom.TimeOut = FALSE ;
				nTimerID = dPassWordRespTimerID ;
				while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
				{
					if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
							MainMsgHeader,MB_RETRYCANCEL | MB_ICONINFORMATION)) 
					{
						InstallConLockPollTimer	();
						return ;                 
					}
				}
				cMiscCom.rcv_packet ((BYTE *) &restype, sizeof (restype),
															(BOOL *) &cMiscCom.TimeOut) ;
				KillTimer (nTimerID) ;

				if (cMiscCom.TimeOut)
				{
					RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_PWRD_RESP, 
						MainMsgHeader,MB_OK | MB_ICONINFORMATION) ;
				} 
				else 
				{
					if (restype.Ptype == ERR_PASSWORD) 
					{		// 13
						RouMsgBox (GetSafeHwnd(), MSG_GEN_ERR_PWRD_RESP, MainMsgHeader,
														MB_OK | MB_ICONINFORMATION) ;
					} 
					else  {
						DnldCNF() ;
					}
				}       
				break ;  

			case ERR_NO_BRD_NO_PASSWORD :			// 19
				DnldCNF() ;
				break ;

			case ERR_ROUTER_UP :
				RouterUp = TRUE ;
				RouterWasUp = TRUE ;
			  	if (IDOK == RouMsgBox (GetSafeHwnd(), MSG_MAIN_ASK_DOWN,
									MainMsgHeader,MB_OKCANCEL | MB_ICONQUESTION))
				{
					RebootDnld() ;
					goto RETRY ;
				}
				// bGotLock = TRUE; // Because Download operation was cancelled.
	       	break ;

			default :
				break ;
		}       
	}
	else
	{
		if (Retry < 1) 
		{
			Retry ++ ;
			goto RETRY ; 
		}
		RouMsgBox (GetSafeHwnd(), MSG_GEN_UNKNOWN_PKT,
				MainMsgHeader, MB_OK | MB_ICONINFORMATION) ;
	}
	InstallConLockPollTimer();
   	InitButtonState(FALSE) ;
   
}	// End of OnDnldSetup


// -------------------------------------------------------------------------
// Function         :	CMainDlg::OnDnldCNF()
// Arguments        :   None.
// Synopsis         :   Download the setup. Call Reboot(), if downloaded 
//								successfully.
// Returns          :   None.
// Globals Affected :   status(status of Windows INI after closing it).
// -------------------------------------------------------------------------
void CMainDlg::DnldCNF()
{
	TargetCmdType cmd_type ;
	ResultType restype ;
			
	cMiscCom.TimeOut = FALSE ;

	WriteRouterINI(TRUE);		// Convert only just before download 24/4/97

	DeInstallConLockPollTimer();

	UINT nTimerID = dChkRouterTimerID3 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
				MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			goto ReturnPoint ;
		}
	}
								
	cmd_type.Ptype = (BYTE) 0 ;
	cmd_type.TargetAction = (BYTE) DN_LD_CNF ;	// 3
	cMiscCom.CODE_CRC = 0xFFFF ;
	cMiscCom.ComprCodeSize = 0 ;
	cMiscCom.snd_packet ((BYTE *) &cmd_type, sizeof (cmd_type)) ;
	cMiscCom.rcv_packet ((BYTE *) &restype, sizeof (restype),
													(BOOL *) &cMiscCom.TimeOut) ;
	KillTimer (nTimerID) ;
	if (cMiscCom.TimeOut) 
	{
		RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_RESP,
				MainMsgHeader, MB_OK | MB_ICONINFORMATION) ;
	} 
	else 
	{
		dnld_head_type dnld_header ;
		DnLdPktHdrType hdr_type ;

		dnld_header.headtype.DnLdAddress = FL_SYSTEM_CFG ;

		dnld_header.headtype.MagicNum = (WORD) MAGIC_NUM ;					

		dnld_header.headtype.StartAddr = 0 ;
		dnld_header.headtype.LoadAddr = 0 ;
							
		dnld_header.headtype.MagicNum = cMiscCom.ltl_endian_word (
														dnld_header.headtype.MagicNum) ;
		dnld_header.headtype.DnLdAddress = cMiscCom.little_endian (
													dnld_header.headtype.DnLdAddress) ;
		strcpy ((char *) dnld_header.headtype.Version, "v2.00") ;

		cMiscCom.SetDateStamp() ;
		strcpy ((char *) dnld_header.headtype.DateStamp, cMiscCom.DateStamp) ;
		strcpy ((char *)dnld_header.headtype.Dmy, "") ;
		memset (dnld_header.headtype.Reserved, 0, 21) ;
		dnld_header.hdr.PacketType = PT_HEADER ;	// 1
		dnld_header.hdr.SeqNum = (BYTE) 0 ;
		hdr_type.PacketType = PT_UNKNOWN ;          // 0

		cMiscCom.TimeOut = FALSE ;

		nTimerID = dAbortTimerID ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
		{
			if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER, MainMsgHeader,
					MB_RETRYCANCEL | MB_ICONINFORMATION)) 
			{
				goto ReturnPoint ;
			}
		}

		cMiscCom.ABORT = FALSE ;
		int no_of_Abort = 0 ;
		while ((hdr_type.PacketType != PT_ACK) && !cMiscCom.ABORT) 
		{   // 6
			cMiscCom.snd_dnld_packet ((BYTE *) &dnld_header,
														sizeof (dnld_header)) ;
			if (cMiscCom.rcv_dnld_packet ((BYTE *) &hdr_type,
						sizeof (hdr_type), (BOOL *) &cMiscCom.TimeOut))
			{
				continue ;
			}
			if (!cMiscCom.TimeOut) 
			{
				KillTimer (nTimerID) ;
				switch (hdr_type.PacketType)
				{
					case PT_ABORT :		// 3 
						if (no_of_Abort == 1) 
						{
							RouMsgBox (GetSafeHwnd(), MSG_COM_ROUTER_ABORT,
								MainMsgHeader,MB_OK | MB_ICONINFORMATION) ;
							cMiscCom.ABORT = TRUE ;
						}
						no_of_Abort ++ ;
						break ;

					default :
						break ;
				}
			}
		}
		if (cMiscCom.ABORT)
			goto ReturnPoint ;

		// Send the configuration file.
		cMiscCom.TimeOut = FALSE ;
		nTimerID = dDnldCNFTimerID ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
		{
			if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
					MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
			{
				goto ReturnPoint ;
			}
		}
		CString FileName = IniInRtrWareForm ;
		cMiscCom.cnf_dnld ((BOOL *) &cMiscCom.TimeOut, FileName, FALSE) ;
		KillTimer (nTimerID) ;
		if (!cMiscCom.ABORT) 
		{
			cMiscCom.snd_eof_packet ((BOOL *) &cMiscCom.TimeOut, FALSE) ;

			// Update the status of the IniInWinForm file.
			char *pOutFileName = IniInWinForm ;
			CStdioFile output ;
			output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
			// Initialize the status of Windows INI file.
			output.GetStatus (status) ;
			output.Close() ;

			//Reboot the target
			if (RouterWasUp)
				Reboot (WARM_BOOT_MODE) ;
			else
				Reboot (COLD_BOOT_MODE) ;
		}
		else
		{
			if (CTRL_FLAG == 1)
				CTRL_FLAG = 0 ;
			After_Abort = TRUE ;
		}
	}
ReturnPoint:
	RouterWasUp = FALSE ;

	InstallConLockPollTimer();

}	// end of DnldCNF

int wildstrcmp (LPSTR str1, LPSTR str2)
{
	while (*str1 && *str2)
	{
		if (*str1 == '?' || *str2 == '?')
		{	// is any of them a ? char
			str1++;
			str2++;						// if yes skip compare at this char
			continue;
		}
		if (*str1 == '*' || *str2 == '*') 	// is any of them a * char
			return 0;								// if yes return match

		if (*str1 < *str2)
			return -1;
		else
			if (*str1 > *str2)
				return 1;

		str1++;
		str2++;
	}
	return ((int)*str1 - (int)*str2);
}
// -------------------------------------------------------------------------
// Function 			:	CMainDlg::WriteRouterINI(BOOL Convert)
// Arguments			:  None.
// Synopsis 			:  Converts Windows INI to Router CNF, only if the Windows 
//                  		INI is changed after Reading.
// Returns  			:  TRUE if it is changed, else FALSE.
// Globals Affected  :  None.
// -------------------------------------------------------------------------
BOOL CMainDlg::WriteRouterINI(BOOL Convert)
{

	char* pInFileName = IniInWinForm ; 
	CStdioFile input;
   char Filter_string[] = "Filter", Forward_string[] = "Forward" ;
   char *TempPointer ;
   int i, DontWrite = 0 ;
   if(!input.Open( pInFileName, CFile::modeRead | CFile::typeText ))
   {
      RouMsgBox(GetSafeHwnd(), MSG_GEN_FILE_OPEN_ERR, MainMsgHeader,MB_OK | 
						MB_ICONINFORMATION);
      return(FALSE);
   }

   CFileStatus Instatus;
	if(input.GetStatus(Instatus))
	{
		if(status.m_mtime == Instatus.m_mtime) {
			input.Close();
			return (FALSE);
		}
	}               
	else {
		input.Close();
		return (FALSE);
	}

	input.Close();				//Write and Get PrivateProfileStrings shouldn't fail
	//Vidy, Chid added this
	if (Convert == FALSE)
		return TRUE;

	RouconCrossCheckPPP();		// vidy added this 19th Aug 95
   input.Open( pInFileName, CFile::modeRead | CFile::typeText );

	char* pOutFileName = IniInRtrWareForm;
	CStdioFile output( pOutFileName, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );	//VIDY changed from TXT to BIN

	char sBuf[MaxINIString];
	char *ch, *ptr ;
	char pBuf[MaxINIString];

	while((input.ReadString(sBuf , MaxINIString)) != NULL)
	{
		// PINTO 28/1/97
		// There must not be any "0d"s in the sBuf by now
		while (ptr = strchr (sBuf, '\r'))
		{
			strcpy (ptr, ptr + 1) ;
		}
		// So that no blank lines are added
		if (sBuf[0] == '\n')
			continue ;
		// PINTO 28/1/97

		if((ch = strchr(sBuf,(int) '[')) != NULL) //Check for section header
		{
			*ch = '\0';
			strcpy(pBuf,sBuf);
			strcat(pBuf,"[[ ");
			strcpy(sBuf,++ch);
			if((ch = strchr(sBuf,(int) ']')) != NULL)
			{
				*ch = '\0' ;
				strcat(pBuf,sBuf);
				strcat(pBuf," = Section Start ]]");	//Change the section header
				strcat(pBuf,++ch);
				strcpy(sBuf, pBuf);
			}
			else
			{
				strcat(pBuf,sBuf);
				strcpy(sBuf,pBuf);      
			}
		}                      
		else
		{
			// 
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp ("PPP Port? Option%*",sBuf) ||
							!wildstrcmp ("PPP Port? Remote Option%*",sBuf))
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}
			// Changes by Vidy for Static Host and Static Net routes
			// Since there can be multiple Static Host routes we addedd
			// '$?' where ?=A,B,... to the beginning of some lines
			// it is now time to remove these
			if ( !wildstrcmp(sBuf, "$? *")) {
				strcpy(pBuf, (LPCSTR)&sBuf[3]);
				strcpy(sBuf, pBuf);
			}
            
			//Neelu added for NAT
                        //Prabha, 25/2/98, for NAT entries, as there are multiple entries
			//beginning with $%c%d, they've to be taken care of
			int prefix_num = 2;
			if ( !wildstrcmp(sBuf, "$?*")) 
			{
				while ((sBuf[prefix_num] >= '0') && (sBuf[prefix_num] <= '9'))	
					prefix_num++;
				strcpy(pBuf, (LPCSTR)&sBuf[prefix_num]);
				strcpy(sBuf, pBuf);
			}

                        
                        
                        #if 0
                        // added by oss on 8-11-96 to check in frame relay option			
			if((ch = strstr(sBuf,"Virtual Port to DLCI")) != NULL)
			{
				ch += 20;		//Look after "virtual port to DLCI "
				*ch = '\0' ;                  
				strcpy(pBuf, sBuf);
				char *ptr;		// just swap the two available numbers
				ch++;
				ch += 4;			// add 4 so that it points to =
				ptr = ch + 3;
				strcpy(sBuf, ptr);
				*ptr = '\0';
				strcat(pBuf, ch);
				strcat(pBuf, ",");
				*ch = '\0' ;                  
				ch -= 4;
				strcat(pBuf, ch);
				strcat(pBuf, sBuf);
				strcpy(sBuf, pBuf);
			}       
			else
			#endif
                        {
				if((ch = strstr(sBuf,"Port")) != NULL)
				{
					ch += 4;		//Look after "Port"
					int c = *ch;
					if((c >= 0x30) && (c <= 0x39))	//Check for digit.
					{
						*ch = '\0' ;                  
						strcpy(pBuf, sBuf);
						int c2 = *(++ch);
						BOOL flag = FALSE;
						if((c2 >= 0x30) && (c2 <= 0x39))	//Check for digit.
						{
							ch++;
							flag = TRUE ;
						}       
						strcpy(sBuf,ch);        
						if((ch = strchr(sBuf, (int) '=')) != NULL)
						{
							*ch = '\0' ;
							strcat(pBuf, sBuf);
							strcat(pBuf, "=");
							char temp[4];
							temp[0] = flag ? c  : '0';
							temp[1] = flag ? c2 :  c;
							temp[2] = ',';
							temp[3] = '\0' ;
							strcat(pBuf, temp);
							strcat(pBuf, ++ch);
							strcpy(sBuf, pBuf);
						}       
					}
				}       
				else if((ch = strstr(sBuf, "Frame Relay DLCI")) != NULL)
				{
					char *ch1;
					if((ch1 = strstr(sBuf, "Number")) != NULL)
					{
						ch1 += 6; // add 6 for the number
						char store_temp[3];
 						store_temp[0] = *ch1;
 						store_temp[1] = *(ch1 + 1);
 						store_temp[2] = '\0';
						*ch1 = '\0';
						strcpy(pBuf, sBuf);
 						strcat(pBuf, "=");
						strcat(pBuf, store_temp);
 						strcat(pBuf, ",");
						ch1 += 3;
 						strcat(pBuf, ch1);
					}
					else
					{
						ch += 16;		//Look after "Frame Relay DLCI"
						*ch = '\0';
						strcpy(pBuf, sBuf);
						char store_temp[5];
						store_temp[0] = *(ch + 1);
						store_temp[1] = *(ch + 2);
						store_temp[2] = *(ch + 3);
						store_temp[3] = *(ch + 4);
						store_temp[4] = '\0';
						ch += 5;
						if((ch1 = strchr(ch,(int) '=')) != NULL)
						{
							*ch1 = '\0';
							strcat(pBuf, ch);
							strcat(pBuf, "=");
							strcat(pBuf, store_temp);
							ch1++;
							strcat(pBuf, ",");
							strcat(pBuf, ch1);
						}
					}
					strcpy(sBuf, pBuf);
				}
// DHCP vvvvv
				else if((ch = strstr(sBuf, "DHCP Tag")) != NULL)
				{
					char *sptr;
					int TagNumber;
					char LHS[40], RHS[MAX_INI_OPTN_LEN * 3];

					if (*sBuf == '$')
						sptr = sBuf+3;
					else
						sptr = sBuf;


					sscanf(sptr, "DHCP Tag%2d %[^=]=%[^\0]", &TagNumber, LHS, RHS);
					sprintf(sBuf, "DHCP Tag %s=%02d,%s", LHS, TagNumber, RHS);
				}
//DHCP ^^^^
			}


		// Put " = " inplace of "="
			if((ch = strchr(sBuf,(int) '=')) != NULL)
			{
				*ch = '\0';
				strcpy(pBuf, sBuf);
				strcat(pBuf, " = ");
				strcat(pBuf, ++ch);
				strcpy(sBuf, pBuf);
			}
		}
      if ((strstr (sBuf, Filter_string) || strstr (sBuf, Forward_string)))
      {
         for (i = 0 ; i < NUMBER_OF_FILTERS ; i++)
         {
            if (strstr (sBuf, FilterStrings[i]) == NULL)
               continue ;
            TempPointer = strchr (sBuf, '=') ;
            TempPointer += 2 ;
            if (strlen(TempPointer) > 5)
            {
               output.WriteString(sBuf);
                  break ;
            }
            else
               break ;
         }
         if (i >= NUMBER_OF_FILTERS)
            output.WriteString(sBuf);
      }
      else
		   output.WriteString(sBuf);
	}
	output.Write("\0\0", 2);
	input.Close();
	output.Close();
	return (TRUE);
}       //End of WriteRouterINI

// -------------------------------------------------------------------------
// Function        :       CMainDlg::WriteWinINI()
// Arguments       :       None.
// Synopsis        :       Converts Router CNF to Windows INI.
// Returns         :       None.
// Globals Affected:       status(status of Windows INI after closing it).
// -------------------------------------------------------------------------
void CMainDlg::WriteWinINI()
{
   int i ;
	char *pInFileName = IniInRtrWareForm ;
	CStdioFile input (pInFileName, CFile::modeRead | CFile::typeText) ;

#if 0
	WritePrivateProfileString(DHCPSectionHeader ,
			(LPCSTR) NULL,(LPSTR)NULL, (LPCSTR) IniInWinForm);
#endif

	char *pOutFileName = IniInWinForm ;
	CStdioFile output (pOutFileName, CFile::modeCreate | CFile::modeWrite 
									| CFile::typeText) ;
	char sBuf[MaxINIString] ;
	char *ch ;
	char *pBuf = new char[MaxINIString] ;
   char FilterIndicies[NUMBER_OF_FILTERS + 1][5] ;

	char StaticRouteTableIndex[5] ;
	char StaticHostRouteIndex[5] ;
	char StaticNetRouteIndex[5] ;
	char ProxyAppIndex[5] ;
	char ProxyAppInfoIndex[5];
	int PropertyTagUID[MAX_NUM_ADDR_RANGES];
	int BindingTagUID[MAX_NUM_ADDR_RANGES];
    	
        //Neelu added for NAT
        
        ////The prefix alphabets of the entries of type $%c%d, where %c->A,B,...,Z
	////%d is an integer.
	char ip_alphabet = 65, app_alphabet = 65;
	char gl_alphabet = 65, dy_alphabet = 65;
	char st_alphabet = 65, pr_alphabet1 = 65, pr_alphabet2 = 65;
    	char fo_alphabet = 65, rc_alphabet = 65;
    	char ra_alphabet = 65, mac_alphabet = 65, dn_alphabet = 65;
	char strt_alphabet = 65, stnt_alphabet = 65, sttb_alphabet = 65;

	int ip_num = 0, app_num = 0;
	int gl_num = 0, dy_num = 0;
	int st_num = 0, pr_num1 = 0, pr_num2 = 0;
	int fo_num = 0, rc_num = 0;
	int ra_num = 0, mac_num = 0, dn_num = 0;
	int strt_num = 0, stnt_num = 0, sttb_num = 0;
	int port_num;
//	int port_num;

        // Neelu Ends
        
        
        for (i = 0; i < MAX_NUM_ADDR_RANGES; i++) {
		PropertyTagUID[i] = 0;
		BindingTagUID[i] = 0;
	}
			
	strcpy (ProxyAppIndex, "$A ") ;
	strcpy (ProxyAppInfoIndex, "$A ") ;

   for (i = 0 ; i < NUMBER_OF_FILTERS ; i ++)
      strcpy (FilterIndicies[i], "$A ") ;

	while ((input.ReadString (sBuf , MaxINIString)) != NULL) 
	{
		if ((ch = strchr (sBuf, (int) '[')) != NULL) 
		{	// Check for section header
			*(++ch) = '\0' ;
			strcpy (pBuf, sBuf) ;
			ch += 2 ;
			strcpy (sBuf, ch) ;
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(-- ch) = '\0' ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, ++ ch) ;
				ch = strstr (sBuf,"]]") ;
				if (ch != NULL)
				{
					strcat (pBuf, ++ ch) ;
					strcpy (sBuf, pBuf) ;
				}
			}
			else 
			{
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
			}
		}
		else
		{
			if ((ch = strstr (sBuf, "Virtual Port to DLCI")) != NULL)
			{
				ch += 20; 	//Look after "Virtual Port to DLCI"
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					*ch = '\0';
				 	strcpy(pBuf, sBuf);
					strcat(pBuf, " ");
				  	ch2++;
					char storing[2];
					storing[0] = *(ch2 +4);
					storing[1] = '\0';
					*(ch2 + 4) = '\0';
					strcat(pBuf, ch2);
					strcat(pBuf, " ");
					ch2 --;
					*ch2 = '\0';
					ch ++;
					strcat(pBuf, ch);
					strcat(pBuf, storing);
					strcpy(sBuf, pBuf);
				}
			}
			// We need to put Port Number on the left hand side of
			// '=' sign to make different strings for different ports
			// for using windows GetPrivateProfileString API function
			if ((ch = strstr (sBuf, "Port")) != NULL)
         {
            for (i = IP_PORT_FILTERS_BASE_INDEX ;
							i < (IP_PORT_FILTERS_BASE_INDEX + 
										NUMBER_OF_IP_PORT_FILTERS) ; i ++)
				{
               if (strncmp (FilterStrings[i], sBuf, 10) == 0)
                  goto NoReplacement ;
				}
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL) 
				{
					ch += 4 ;				//Look after "Port"
					*ch = '\0' ;
					strcpy (pBuf, sBuf) ;
					strcpy(sBuf, ++ch);
					ch2 = strchr (sBuf, (int) ',') ;
					if (ch2 != NULL) 
					{       
						*ch2 = '\0' ;
						if((*(ch2 - 2)) == '0')
							strcat (pBuf, (ch2 - 1)) ;
						else
							strcat (pBuf, (ch2 - 2)) ;
						*(ch2 - 2) = '\0' ;
						strcat (pBuf, " ") ;         
						strcat (pBuf, sBuf) ;
						strcat (pBuf, ++ ch2) ;
						strcpy (sBuf, pBuf) ;
					}       
				}                   
			}
			else if ((ch = strstr (sBuf, "Frame Relay DLCI")) != NULL)
			{
				char *ch1;
				if ((ch1 = strstr (sBuf, "Number")) != NULL)
				{
					ch1 += 6;	 // add 6 for the number
					*ch1 = '\0';
					strcpy(pBuf, sBuf);
					ch1 += 3;
					char store_temp[3];
					store_temp[0] = *ch1;
					store_temp[1] = *(ch1 + 1);
					store_temp[2] = '\0';
					strcat(pBuf, store_temp);
					strcat(pBuf, " = ");
					ch1 += 3; // two for numbers and one for comma
					strcat(pBuf, ch1);
					strcpy(sBuf, pBuf);
				}
				else
				{
					ch += 16;		// add 16 for "Frame Relay DLCI"
					*ch = '\0';
					ch++;
					strcpy(pBuf, sBuf);
					if ((ch1 = strchr (ch, (int) '=')) != NULL)
					{
						ch1++;
						*(ch1 + 5) = '\0';
						strcat(pBuf, ch1);
						strcat(pBuf, " ");
						*ch1 = '\0';
						strcat(pBuf, ch);
						strcat(pBuf, " ");
						ch1 += 6;
						strcat(pBuf, ch1);
						strcpy(sBuf, pBuf);
					}
				}
			}
// added for DHCP  vvvv
			else if ((ch = strstr (sBuf, "DHCP Tag ")) != NULL)
			{
				char LHS[40], RHS[MAX_INI_OPTN_LEN * 3];
				int	TagNumber;

				sscanf(sBuf, "DHCP Tag %[^=]=%2d,%[^\0]", LHS, &TagNumber, RHS);
				if (strstr(LHS, "Properties"))
				{
					sprintf(sBuf, "$%c DHCP Tag%d %s= %s", 
						(char)('A'+ PropertyTagUID[TagNumber]++), TagNumber, LHS, RHS);
				}
				else if (strstr(LHS, "Bindings"))
				{
					sprintf(sBuf, "$%c DHCP Tag%d %s= %s", 
						(char)('A'+ BindingTagUID[TagNumber]++), TagNumber, LHS, RHS);
				}
				else
				{
					sprintf(sBuf, "DHCP Tag%d %s= %s", TagNumber, LHS, RHS);
				}
			}
//Added for DHCP ^^^^^^

NoReplacement : ;
			// Put "=" in place of " = "
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(ch - 1) = '\0' ;
				strcpy (pBuf, sBuf) ;
				strcat (pBuf, "=") ;
				ch += 2 ;
				strcat (pBuf, ch) ;
				strcpy (sBuf, pBuf) ;
			}
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp ("PPP Port? Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? Remote Option=*", sBuf)) 
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// also to the LHS for making unique LHS strings for
				// Windows ini APIs to work

				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
			// Changes by Vidy for Static Host and Static Net routes
			// Since there can be multiple Static Host routes we need to
			// somehow differentiate them for Windows API to work
			// We add '$?? ' where ??=A0,B0,... to the beginning of these lines
			if (strstr (sBuf, "IP Static Host Route"))
        	{
				sprintf (pBuf, "$%c%d%s", strt_alphabet, strt_num, sBuf);
            strcpy (sBuf, pBuf) ;
				strt_alphabet++;
				if (strt_alphabet > 90)
				{
					strt_alphabet = 65;
					strt_num++;
				}
			}
        	else if (strstr (sBuf, "IP Static Net Route"))
			{
				sprintf (pBuf, "$%c%d%s", stnt_alphabet, stnt_num, sBuf);
            strcpy (sBuf, pBuf) ;
				stnt_alphabet++;
				if (stnt_alphabet > 90)
				{
					stnt_alphabet = 65;
					stnt_num++;
				}
			}
			else if (strstr (sBuf, "IP Static Route Table Entries"))
			{
				sprintf (pBuf, "$%c%d%s", sttb_alphabet, sttb_num, sBuf);
            strcpy (sBuf, pBuf) ;
				sttb_alphabet++;
				if (sttb_alphabet > 90)
				{
					sttb_alphabet = 65;
					sttb_num++;
				}
			}
	        else if (strstr (sBuf, "Proxy Server Application List"))
			{
				strcpy (pBuf, ProxyAppIndex) ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
				ProxyAppIndex[1] ++ ;
			}
//Vidy vvvvv 17/10/97
			else if (strstr (sBuf, "Proxy Application Info"))
			{
				strcpy (pBuf, ProxyAppInfoIndex) ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
				ProxyAppInfoIndex[1] ++ ;
			}

//Vidy ^^^^     			else if ((strstr (sBuf, "Filter")) || (strstr (sBuf, "Forward")))
        	{
           	for (i = 0 ; i < NUMBER_OF_FILTERS ; i ++)
           	{
           		if (strstr (sBuf, FilterStrings[i]) == NULL)
                 	continue ;
            
               strcpy (pBuf, FilterIndicies[i]) ;
               strcat (pBuf, sBuf) ;
               strcpy (sBuf, pBuf) ;
               FilterIndicies[i][1] ++ ;
               break ;
            }
         }
	
         //Neelu added for NAT
			 if ((strstr (sBuf, "Proxy Server Global Address List")) != NULL)
			{														 
				wsprintf (pBuf, "$%c%d%s", gl_alphabet, gl_num, sBuf);
            strcpy (sBuf, pBuf) ;
				gl_alphabet++;
				if (gl_alphabet > 90)
				{
					gl_alphabet = 65;
					gl_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Local Internet Servers")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", dy_alphabet, dy_num, sBuf);
            strcpy (sBuf, pBuf) ;
				dy_alphabet++;
				if (dy_alphabet > 90)
				{
					dy_alphabet = 65;
					dy_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Mapped Address List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", st_alphabet, st_num, sBuf);
            strcpy (sBuf, pBuf) ;
				st_alphabet++;
				if (st_alphabet > 90)
				{
					st_alphabet = 65;
					st_num++;
				}
			}	  // Neelu Ends
         else if ((strstr (sBuf, "Proxy Server Forbidden Address List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", fo_alphabet, fo_num, sBuf);
            strcpy (sBuf, pBuf) ;
				fo_alphabet++;
				if (fo_alphabet > 90)
				{
					fo_alphabet = 65;
					fo_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Restricted Client List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", rc_alphabet, rc_num, sBuf);
            strcpy (sBuf, pBuf) ;
				rc_alphabet++;
				if (rc_alphabet > 90)
				{
					rc_alphabet = 65;
					rc_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Restricted Application List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", ra_alphabet, ra_num, sBuf);
            strcpy (sBuf, pBuf) ;
				ra_alphabet++;
				if (ra_alphabet > 90)
				{
					ra_alphabet = 65;
					ra_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Restricted MAC Address List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", mac_alphabet, mac_num, sBuf);
            strcpy (sBuf, pBuf) ;
				mac_alphabet++;
				if (mac_alphabet > 90)
				{
					mac_alphabet = 65;
					mac_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Restricted Domain Name List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", dn_alphabet, dn_num, sBuf);
            strcpy (sBuf, pBuf) ;
				dn_alphabet++;
				if (dn_alphabet > 90)
				{
					dn_alphabet = 65;
					dn_num++;
				}
			}
/* Added by Sreelu for IP & App that Needs no authentication.... */
			else if ((strstr (sBuf, "Proxy Default IP List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", ip_alphabet, ip_num, sBuf);
            strcpy (sBuf, pBuf) ;
				ip_alphabet++;
				if (ip_alphabet > 90)
				{
					ip_alphabet = 65;
					ip_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Default Application List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", app_alphabet, app_num, sBuf);
            strcpy (sBuf, pBuf) ;
				app_alphabet++;
				if (app_alphabet > 90)
				{
					app_alphabet = 65;
					app_num++;
				}
			}
         
      }
		output.WriteString (sBuf) ;
	}
	output.Close() ;
	input.Close() ;
	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	output.GetStatus(status) ;	//Initialize the status of Windows INI file.
	output.Close() ;
	delete [] pBuf ;  
        WritePrivateProfileString(NULL, NULL, NULL, IniInWinForm);
}       //End of WriteWinINI

extern	BOOL	DontReadConfiguration;

// -------------------------------------------------------------------------
// Function				:	CMainDlg::CheckTarget()
// Arguments			:	None.
// Synopsis          :	Checks the status of target. Reads configuration if
//								its found.
// Returns           :	TRUE if it is found, else FALSE.
// Globals Affected  :	RouterUp , TargetFound.
// -------------------------------------------------------------------------
BOOL CMainDlg::CheckTarget()
{
	BOOL Retry = TRUE ;
	ReqType brd_req_type ;
	OpenConnectionType bridge1 ;

	LED_Flash_Count = 0 ;	// Initialize the counter for LED flashing.
	Go_on = 1 ;					// Initialize to read char from COM port.
	CTRL_FLAG = 0 ;		 	// Initialize control to be with Timer routine.

   KillTimer (PollingTimerID) ; 	// Kill any previous Timer with this ID.

	// Set the timer for polling.
   while (PollingTimerID != SetTimer (PollingTimerID,
										   	(UINT) PollingInterval, NULL))
	{
      if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
	 						 MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
			 return FALSE ;    
		}
	}

   brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13

RETRY :
	cMiscCom.TimeOut = FALSE ;
   UINT nTimerID = dChkTargetTimerID ;
   while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
      if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
	 						MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
			 return FALSE ;    
		}
	}
   while (1)
   {
      cMiscCom.snd_packet ((BYTE *) &brd_req_type.Ptype, 
														sizeof (brd_req_type)) ;
      if (!(cMiscCom.rcv_packet ((BYTE *) &bridge1, sizeof(bridge1), 
														  (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;   // No CRC error
		}
	}
    
   KillTimer (nTimerID) ;
   TargetFound = !cMiscCom.TimeOut ;
    
   if (!cMiscCom.TimeOut)
   {
      if (bridge1.Ptype == RES_TYPE)            // 12
      {
	   	BYTE *incor ;
			WORD pra ;
			incor = (BYTE *) &pra ;
			incor[0] = bridge1.BrdName[1] ;
			incor[1] = bridge1.BrdName[2] ;
			pra = cMiscCom.ltl_endian_word (pra) ;

			switch (pra)
 			{
 				case ERR_ROUTER_UP :      		 	// No_Err
 					RouterUp = TRUE ;     // Router is running and
												 // you can't Download
 					break ;                                                          

 				default :
				  	break ;
			}       
	   }
   }

	if (!DontReadConfiguration)
	{
	    if (TargetFound)
		 {
		 	int ReadResult ;
			ReadResult = ReadConfig() ;

			while (ReadResult != 3)
			{		// read returns 3 if everything OK
				if (RouMsgBox (GetParent()->GetSafeHwnd(), MSG_MAIN_ERR_CNF_READ, MainMsgHeader,
								MB_RETRYCANCEL | MB_ICONQUESTION) == IDRETRY)
				{
					ReadResult = ReadConfig() ;
				}
				else 
				{
					TargetFound = FALSE ;
					RouterUp = FALSE ;
					ConfigurationRead = FALSE ;
					// bGotLock = FALSE;
					break ;
				}
			}
   	 }
		 else
		 {
			if (Retry) 
			{
				Retry = FALSE ;
				goto RETRY ;
			}
			RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_ROUTER, MainMsgHeader,
										MB_OK | MB_ICONINFORMATION) ;
		 }
	}	//if DontReadConfiguration

   if (CommandLineArgument != 6)                
	   InitButtonState() ;
   return TargetFound ;
} //end of CheckTarget()

BOOL	CMainDlg::CheckCRCofCNF(WORD CRCread)
{
	cMiscCom.CODE_CRC = 0xFFFF;

	char* pInFileName = IniInRtrWareForm;
	
/* Chida - 28 Apr 1997 
	To fix problem of crashing when "ROUTER.CNF" is not present. */	
    OFSTRUCT aDummy;
	
	if (OpenFile (pInFileName, 	&aDummy, OF_EXIST) == HFILE_ERROR)
		return FALSE;
	
	CStdioFile input( pInFileName, CFile::modeRead | CFile::typeText );

	char sBuf[1025];
	UINT nReadCount;
	nReadCount = input.Read(sBuf , 1024);
	while(nReadCount != 0)
	{
      for(UINT k=0; k < nReadCount; k++)
         cMiscCom.updatecrc(sBuf[k]);
		nReadCount = input.Read(sBuf , 1024);
	}
   cMiscCom.updatecrc((BYTE) 0);
   cMiscCom.updatecrc((BYTE) 0);
	input.Close();

	if (cMiscCom.CODE_CRC == CRCread)
		return TRUE;

	return FALSE;
}
// -------------------------------------------------------------------------
// Function   			:	CMainDlg::ReadConfig()
// Arguments  			:	None.
// Synopsis   			:	Reads Configuration and stores in IniInRtrWareForm
// Returns    			:	integer.
// Globals Affected  :	None.
// -------------------------------------------------------------------------
int CMainDlg::ReadConfig()
{
   BOOL NoTimer = FALSE ;
   char *pOutFileName = IniInRtrWareForm ; // ROUTER.CNF
   int RetryCount = 0 ;
	
   HeaderType ConfigHeader ;
		
   ReadLocReqType read_req ;
   ReadLocRespType read_resp ;

   CCNFRead cReadCNF (this) ;
   CCNFRead *p_cReadCNF ;
   p_cReadCNF = &cReadCNF ;

   UINT nTimerID = dReadConfigTimerID ;
   while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
      if (IDCANCEL == RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_GEN_NO_TIMER,
					MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
         NoTimer = TRUE ;
      }
	}
			
   cMiscCom.TimeOut = FALSE ;
/*   read_req.Address = cMiscCom.little_endian (0x11400) ; */
   read_req.Address = cMiscCom.little_endian (FL_CFG_HDR) ;
   read_req.Ptype = READ_REQ_TYPE ;		// 31
   read_req.Length = sizeof (ConfigHeader) ;

   while (1)
   {    
      cMiscCom.snd_packet ((BYTE *) &read_req, sizeof (read_req)) ;
      if (!(cMiscCom.rcv_packet ((BYTE *) &read_resp,
				sizeof (ConfigHeader) + 5, (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;     // No CRC Error
		}
   }

   if (!cMiscCom.TimeOut)
	{	// Config header is read.
      char m_szTempBuf[25] ;
		char *ptr ;

      KillTimer (nTimerID) ;

		if (read_resp.ErrCode != 0)		// did the read get through
			goto WrongHead ;

		if (read_req.Address != read_resp.Address)
			goto WrongHead ;

      memcpy (&ConfigHeader, read_resp.buffer, sizeof (ConfigHeader)) ;

		ptr = (char *) ConfigHeader.Version ;
		if ((*ptr >= 'a' && *ptr <= 'z') ||
					(*ptr >= 'A' && *ptr <= 'Z') ||
							(*ptr >= '0' && *ptr <= '9'))
		{
	      strcpy (m_szTempBuf, (char *) ConfigHeader.Version) ;
		}
		else
		{
	      strcpy (m_szTempBuf, "Unknown") ;
		}
      m_szTempBuf[24] = 0 ; 	// To ensure a NULL character at the end.
//      cReadCNF.m_Version = m_szTempBuf ;

		ptr = (char *) ConfigHeader.DateStamp ;
		if ((*ptr >= 'a' && *ptr <= 'z') ||
						(*ptr >= 'A' && *ptr <= 'Z') ||
								(*ptr >= '0' && *ptr <= '9'))
		{
	      strcpy (m_szTempBuf, (char *) ConfigHeader.DateStamp) ;  
		}
		else
		{
	      strcpy (m_szTempBuf, "Not available") ;
		}
      m_szTempBuf[24] = 0 ;  	// To ensure a NULL character at the end.
      cReadCNF.m_Date = m_szTempBuf ;
					
      ConfigHeader.CRC = cMiscCom.ltl_endian_word (ConfigHeader.CRC);
      wsprintf((LPSTR) m_szTempBuf,
				(LPSTR) "0x%-5x%s", ConfigHeader.CRC, "") ;
      cReadCNF.m_CRC = m_szTempBuf ;
      cReadCNF.m_CRC.MakeUpper() ;
      cReadCNF.m_CRC.SetAt(1,'x') ;
					
      ConfigHeader.CodeLength = cMiscCom.little_endian (
																ConfigHeader.CodeLength) ;
      wsprintf ((LPSTR) m_szTempBuf,
				(LPSTR) "%-5ld%s", ConfigHeader.CodeLength, "") ;
      cReadCNF.m_Length = m_szTempBuf ;

      cReadCNF.UpdateData (FALSE) ;

   }
	else 
	{
WrongHead :
//		output.Close() ;
		MessageBox ("Not able to read Boot Header", NULL, MB_OK | MB_ICONINFORMATION) ;
		return 0 ;
	}

	//Try to get the configuration lock from configuration manager
	if (!GetLock())
		return 0;

			
	if (! CheckCRCofCNF (ConfigHeader.CRC)) 
	{
   	CStdioFile output (pOutFileName,
		CFile::modeCreate | CFile::modeWrite | CFile::typeBinary) ;

   	read_req.Ptype = READ_REQ_TYPE ;		// 31
   	read_req.Length = 128 ;
   	read_req.Address = ConfigHeader.DnLdAddr ;  // DnldAddress
   	DWORD m = 0 ;       // Progress variable for reading configuration.

	//	Set the gauge to display progress of configuration read.
	
		CHorzGauge *wndHorzGauge = new (CHorzGauge) ;        
   	CRect rc ;

		(p_cReadCNF->GetDlgItem (IDC_STATIC_RECT))->GetWindowRect (&rc) ;
		p_cReadCNF->ScreenToClient (&rc) ;

   	wndHorzGauge->Create ((CWnd *) p_cReadCNF, rc) ;
   	wndHorzGauge->SetGaugeInfo ("",
										  	0,
									   	100, 
							 	GU_ELEVATED,
								GU_DEPRESSED,
									  	TRUE,
									 	FALSE,
									 	FALSE, 
			  	RGB (0xff, 0xff, 0xff),
			  	RGB (0x80, 0x80, 0x80), 
			        	RGB (0, 0, 0xff),
			  	RGB (0xc0, 0xc0, 0xc0), 
						  	RGB (0, 0, 0)
			  	) ;
    
   	AfxGetApp()->LoadCursor (IDC_WAIT) ;
   	AfxGetApp()->DoWaitCursor (1) ;
   	BOOL FLAG = TRUE ;
		//If user wants to cancel reading after abnormal condition.

		cMiscCom.CODE_CRC = 0xFFFF ;

   	while ((m < ConfigHeader.CodeLength) && (FLAG))
   	{ 
			if (ConfigHeader.CodeLength)
	      	wndHorzGauge->UpdateProgress ((m * 100) / ConfigHeader.CodeLength) ;
      	UINT nTimerID = dReadConfigTimerID2 ;
      	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
			{
				if (IDCANCEL == RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_GEN_NO_TIMER,
						MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
				{
			    	NoTimer = TRUE ;
	   		 	goto endread ;                       
				}
			}
			
			cMiscCom.TimeOut = FALSE ;

			// put some invalid
			lstrcpy ((LPSTR) read_resp.buffer, (LPCSTR) "$~~~$") ;		
			while (1)
      	{ 
				cMiscCom.snd_packet ((BYTE *) &read_req, sizeof (read_req)) ;
				if (!(cMiscCom.rcv_packet ((BYTE *) &read_resp,
					sizeof (read_resp), (BOOL *) &cMiscCom.TimeOut)))
				{
					break ;  // No CRC Error
				}
      	}
			
      	if (cMiscCom.TimeOut) 
			{
         	RetryCount ++ ;
         	if (RetryCount > 2)
				{
					AfxGetApp()->DoWaitCursor (0) ;
					FLAG = (IDYES == RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_MAIN_NO_DATA_RTRY,
									MainMsgHeader,
										MB_YESNO| MB_DEFBUTTON1 | MB_ICONINFORMATION)) ; 
					AfxGetApp()->LoadCursor (IDC_WAIT) ;
					AfxGetApp()->DoWaitCursor (1) ;
					cMiscCom.FlushReadBuf() ;
         	}
				continue ;
      	}
			else 
			{
				RetryCount = 0 ;
				KillTimer (nTimerID) ;
      	}

			// Added by Vidy
			if (read_req.Address != read_resp.Address)
			{
				// delay
				for (DWORD counter = 0 ; counter != 0xFFFFF ; counter ++) ;	
				cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
				continue ;
			}
			if (!lstrcmp ((LPSTR) read_resp.buffer, (LPCSTR) "$~~~$"))
			{
				continue ;
			}

			switch (read_resp.Ptype) 
			{
				case READ_RESP_TYPE :			// 32
					if (!read_resp.ErrCode) 
					{
						int i ;
						m += 128 ;
						if (m <= ConfigHeader.CodeLength) 
						{
							output.Write (read_resp.buffer, 128) ;

							for (i = 0 ; i < 128 ; i ++)
								cMiscCom.updatecrc (read_resp.buffer[i]) ;

						}
						else
						{		// Adjust for last packet length.
							int tm = 128 - (int) (m - ConfigHeader.CodeLength) ;
							output.Write (read_resp.buffer, tm) ;
							for (i = 0 ; i < tm ; i ++)
								cMiscCom.updatecrc (read_resp.buffer[i]) ;
						}
						// DownLoad Address
						read_req.Address =
							cMiscCom.little_endian (read_req.Address) ;  // DnldAddress
						read_req.Address += 0x80 ; //Increment by 128 bytes.
						read_req.Address = cMiscCom.little_endian (read_req.Address) ;
					}
					else
					{
						FLAG = !(IDCANCEL == RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_MAIN_READ_ERR,
										MainMsgHeader,
							MB_RETRYCANCEL | MB_DEFBUTTON2 | MB_ICONINFORMATION)) ;
					}
					break ;
			}
		}

	endread :                
		wndHorzGauge->DestroyGauge() ;
		delete wndHorzGauge ;
		output.Close() ;
		if (NoTimer)
			return 0 ;



		AfxGetApp()->DoWaitCursor (0) ;

		// This is for checking if we have read the stuff correctly
		cMiscCom.updatecrc ((BYTE) 0) ;
		cMiscCom.updatecrc ((BYTE) 0) ;
		if (cMiscCom.CODE_CRC != ConfigHeader.CRC)
		{
			RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_MAIN_CHK_ERR_MEM, StrNull, MB_OK) ;
			return 1 ;
		}
		else 
			if (!CheckCRCofCNF (ConfigHeader.CRC)) 
			{
				RouMsgBox (p_cReadCNF->GetSafeHwnd(), MSG_MAIN_CHK_ERR_FILE, StrNull, MB_OK) ;
				return 2 ;
			}	
	}

	WriteWinINI() ; 	// Convert this format to Windows Format.

	// Check if AG support is provided
	// Telnet/TFTP/AG button should be modified accordingly

	// Set a periodic timer for Locking Router                
	InstallConLockPollTimer();

	ConfigurationRead = TRUE ;
	return 3 ;
}     //End of ReadConfig

// -------------------------------------------------------------------------
// Function         :      CMainDlg::InitButtonState()
// Arguments        :      None.
// Synopsis         :      Enables/disables Main Dialog buttons and updates
//									Router status depending on the TargetFound, 
//									RouterUp.
// Returns          :      None.
// Globals Affected :      None.
// -------------------------------------------------------------------------
void CMainDlg::InitButtonState (BOOL pUpdateVersion)
{
	char szRHS[30];

	m_IP.EnableWindow (ConfigurationRead) ; 
	m_PPP.EnableWindow (ConfigurationRead) ;

	GetPrivateProfileString (PPPSectionHeader, "PPP", StrEnabled, szRHS, sizeof(szRHS), IniInWinForm);
	if (strcmp (szRHS, StrEnabled))
		m_PPP.EnableWindow (FALSE);
	
	m_Proxy.EnableWindow(ConfigurationRead) ;
	m_DHCPWnd.EnableWindow(ConfigurationRead) ;
	m_WAN.EnableWindow (ConfigurationRead) ;
	m_Applications.EnableWindow (ConfigurationRead) ;
        if (IsPortIP)
        	m_DownloadCNF.EnableWindow (ConfigurationRead);
        else
	    m_DownloadCNF.EnableWindow (ConfigurationRead && (bGotLock || (eUserResponse == E_IGNORE))) ;

	m_Diagnostics.EnableWindow (ConfigurationRead) ;
	m_nat.EnableWindow (ConfigurationRead); //Neelu For NAT

//	m_DeviceDrivers.EnableWindow (ConfigurationRead) ;
	m_Filtering.EnableWindow (ConfigurationRead) ;

	// Addded by cfp on 28-3-96

//      Commented for new UI
// 	m_OtherSetup.EnableWindow (ConfigurationRead) ;
	if (ConfigurationRead)
		RevampHelpExitRetryButtons() ;

	if (ConfigurationRead)
	{
		m_PPP.EnableWindow (TRUE);
	}

	if (IsPortIP) 
	{
		m_Diagnostics.EnableWindow (FALSE) ;
		m_PConsole.EnableWindow (FALSE) ; // Sachin 4.1.96
#if PROXY_SERVER
		m_PortStat.EnableWindow(TRUE);		// Sachin 01/12/1997
#else
		m_PortStat.EnableWindow(FALSE);		//Vidy 3.11.97
#endif

//		m_Status.SetWindowText ((LPCSTR) "Status: Running") ;
//		m_Version.SetWindowText ((LPCSTR) "TFTP Connection") ;
		return ;
	}
				
	if(!TargetFound)
	{
//		m_Status.SetWindowText ((LPCSTR) "Status: Unknown") ;
//		m_Version.SetWindowText ((LPCSTR) "Version: Unknown") ;	// Pravin 5th Oct.
		return ;					// Pravin 5th Oct.
	}
	else
		if(RouterUp)
		{
//			m_Status.SetWindowText ((LPCSTR) "Status: Running") ;
			m_PortStat.EnableWindow(TRUE);		//Vidy 3.11.97
		}
		else
		{
//			m_Status.SetWindowText ((LPCSTR) "Status: Waiting Download") ;
			m_PortStat.EnableWindow(FALSE);		//Vidy 3.11.97
		}

// Get the Router Version and display it

	if (pUpdateVersion)
	{
   		ReadLocReqType read_req ;
   		ReadLocRespType read_resp ;
		HeaderType	CodeHead ;	// Downloaded code header
		BootConfigType	ConfigHead ;
   
		cMiscCom.TimeOut = FALSE ;
   		read_req.Address = cMiscCom.little_endian (FL_CODE_HDR) ;
   		read_req.Ptype = READ_REQ_TYPE ; // 31
   		read_req.Length = sizeof (CodeHead) ;

   		UINT nTimerID = dReadRtrVersionTimerID ;
   		while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
		{
      		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER, 
									MainMsgHeader, MB_RETRYCANCEL)) 
			{
				return ;
      		}
		}
			
   		while (1)
   		{    
      		cMiscCom.snd_packet ((BYTE *) &read_req, sizeof (read_req)) ;
      		if (!(cMiscCom.rcv_packet ((BYTE *) &read_resp, 
					sizeof (CodeHead) + 3, (BOOL *) &cMiscCom.TimeOut)))
			{
					break ;  // No CRC Error
			}
		}

		if (!cMiscCom.TimeOut)
		{
			KillTimer (nTimerID) ;
			memcpy (&CodeHead, read_resp.buffer, sizeof (CodeHead)) ;
		
			char szTempBuf[30] ;
			wsprintf (szTempBuf, "Firewall Version: %s", CodeHead.Version) ;
//			m_Version.SetWindowText ((LPCSTR) szTempBuf) ;
		}
		else 
//			m_Version.SetWindowText ((LPCSTR) "N.A.") ;

		// Now get and store the ether net address - used for IPX internal
		// router network
		cMiscCom.TimeOut = FALSE ;
   		read_req.Address = cMiscCom.little_endian (FL_BOOT_HDR) ;
   		read_req.Ptype = READ_REQ_TYPE ; // 31
   		read_req.Length = sizeof (ConfigHead) ;

   		nTimerID = dReadEthAddrTimerID ;
   		while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
		{
      		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER, 
										MainMsgHeader, MB_RETRYCANCEL)) 
			{
				return ;
      		}
		}

   		while (1) 
		{    
      		cMiscCom.snd_packet ((BYTE *) &read_req, sizeof (read_req)) ;
      		if (!(cMiscCom.rcv_packet ((BYTE *) &read_resp,
								sizeof (ConfigHead) + 3, (BOOL *) &cMiscCom.TimeOut)))
			{
				break ;   // No CRC Error
			}
   		}

		if (!cMiscCom.TimeOut) 
		{
			KillTimer (nTimerID) ;
			memcpy (&ConfigHead, read_resp.buffer, sizeof (ConfigHead)) ;

			LPSTR BytePtr, NetAddrPtr ;
			int i, upper_nibble, lower_nibble ;

			for (i = 0, BytePtr = (LPSTR) ConfigHead.EthernetAddr,
					NetAddrPtr = EtherNetAddr ;	i < 6 ; i ++, BytePtr ++)
			{
				upper_nibble = (*BytePtr >> 4) & 0x0F ;
				lower_nibble = (*BytePtr)  & 0x0F ;
				if (upper_nibble >= 0 && upper_nibble <= 9)
					*NetAddrPtr++ = '0' + upper_nibble ;
				else
					*NetAddrPtr++ = 'A' + upper_nibble - 10 ;
				if (lower_nibble >= 0 && lower_nibble <= 9)
					*NetAddrPtr++ = '0' + lower_nibble ;
				else
					*NetAddrPtr++ = 'A' + lower_nibble - 10 ; 
			}
			*NetAddrPtr = NULL ;		// terminate with a NULL
		}   
	}
}	// End of InitButtonState()

// -------------------------------------------------------------------------
// Function         :       CMainDlg::Reboot()
// Arguments        :       None.
// Synopsis         :       Reboots the Router and updates its status.
// Returns          :       None.
// Globals Affected :       TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CMainDlg::Reboot (char BootMode)
{
	UINT nTimerID ;

   CReboot cReboot (this) ;
	AfxGetApp()->LoadCursor (IDC_WAIT) ;
	AfxGetApp()->DoWaitCursor (1) ;

	RebootType rebootpkt ;
	
        
        rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;	   // 22
        rebootpkt.BootType = BootMode ;           // System Reboot

	cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
	cMiscCom.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;

	UINT BootWaitTimer ;
	if (BootMode == WARM_BOOT_MODE)
		BootWaitTimer = 5000 ;
	else
		BootWaitTimer = 20000 ;
	nTimerID = dRebootTimerID ;
	cMiscCom.TimeOut = FALSE ;
	while (nTimerID != SetTimer (nTimerID, (UINT) BootWaitTimer, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER, 
				MainMsgHeader,MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
			return ;    
		}
	}
   while (!cMiscCom.TimeOut)	// Delay
	{
		MSG msg ;
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
		}
	}
	cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
	if (CTRL_FLAG == 1)
		CTRL_FLAG = 0 ;

	TargetFound = FALSE ;
   RouterUp = FALSE ;
   for (int k = 0 ; ((k < 20) && !RouterUp) ; k ++)
   {
		ReqType brd_req_type ;
	  	OpenConnectionType bridge1 ;
	  
		brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
		cMiscCom.TimeOut = FALSE ;
		RouterUp = FALSE ; 
		UINT nTimerID = dRebootChkRouterTimerID;
		while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
		{
			if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
						MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
			{
				return ;    
			}
		}
		while (1)
		{
			cMiscCom.snd_packet ((BYTE *) &brd_req_type.Ptype,
														sizeof(brd_req_type)) ;
			if (!(cMiscCom.rcv_packet ((BYTE *) &bridge1,
					sizeof (bridge1), (BOOL *) &cMiscCom.TimeOut)))
			{
				break ;    // No CRC error
			}
		}
    
		TargetFound = !cMiscCom.TimeOut ;
    
	   if (!cMiscCom.TimeOut)
		{
   	  	KillTimer (nTimerID) ;
			if (bridge1.Ptype == RES_TYPE)			// 12
			{
	     		BYTE *incor ;
				WORD pra ;
				incor = (BYTE *) &pra ;
				incor[0] = bridge1.BrdName[1] ;
				incor[1] = bridge1.BrdName[2] ;
				pra = cMiscCom.ltl_endian_word (pra) ;
				switch (pra)
				{
					case 21 :       // RouterUp
						RouterUp = TRUE ; // Router is running
												// and you can't Download
						break ;                                                          

					default :
						break ;
				}       
		  	}
		}
	}
   cReboot.DestroyWindow() ;
	AfxGetApp()->DoWaitCursor (0) ;
	InitButtonState() ;
}  //End of Reboot


// -------------------------------------------------------------------------
// Function         :       CMainDlg::RebootDnld()
// Arguments        :       None.
// Synopsis         :       Brings Router down so that it waits for download
//									 and updates its status.
// Returns          :       None.
// Globals Affected :       TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CMainDlg::RebootDnld()
{
	RebootType rebootpkt ;

	rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;		// 22 
	rebootpkt.BootType = 0 ;         // Reboot to Download Code

	cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
	cMiscCom.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;

	if (CTRL_FLAG == 1)
		CTRL_FLAG = 0 ;
	cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
	
	TargetFound = FALSE ;
	RouterUp = FALSE ;
	CReboot cReboot (this) ;
	AfxGetApp()->LoadCursor (IDC_WAIT) ;
	AfxGetApp()->DoWaitCursor (1) ;
	for (int k = 0 ; (k < 20 && !TargetFound) ; k ++)
	{
		ReqType brd_req_type ;
	   OpenConnectionType bridge1 ;
	   
		brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
		cMiscCom.TimeOut = FALSE ;
		RouterUp = FALSE ;
		UINT nTimerID = dRebootDnldChkTimerID ;
		while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
		{
			if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
					MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;    
			}
		}
		while (1)
		{
			cMiscCom.snd_packet ((BYTE *) &brd_req_type.Ptype,
															sizeof (brd_req_type)) ;
			if (!(cMiscCom.rcv_packet ((BYTE *) &bridge1,
					sizeof (bridge1), (BOOL *) &cMiscCom.TimeOut)))
			{
				break ;    // No CRC error
			}
		}
    
      KillTimer (nTimerID) ;
		TargetFound = !cMiscCom.TimeOut ;
    
		if (!cMiscCom.TimeOut)
		{
			if (bridge1.Ptype == RES_TYPE)		// 12
			{
				BYTE *incor ;
				WORD pra ;
				incor = (BYTE *) &pra ;
				incor[0] = bridge1.BrdName[1] ;
				incor[1] = bridge1.BrdName[2] ;
				pra = cMiscCom.ltl_endian_word (pra) ;
				switch (pra)
				{
					case 21 :               // Router is Up
						RouterUp = TRUE ;    // Router is running
													// and you can't Download
						break ;                                                          

					default :
						break ;
				}
			}
		}
	}
	cReboot.DestroyWindow() ;
	AfxGetApp()->DoWaitCursor (0) ;
   InitButtonState() ;
	cMiscCom.FlushReadBuf() ;	// Flush the receive buffer
	if (CTRL_FLAG == 1)
		CTRL_FLAG = 0 ;
}  //END OF   RebootDnld

void CMainDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_MCI,HELP_CONTEXT);
	
}

// TRUE if rcv_packet or rcv_dnld_packet is called
extern int ExpectingReplyPacket ;
// --------------------------- OnTimer Routine ------------------------
//
//		CTRL_FLAG is used to transfer control from routine to routine.
//			CTRL_FLAG = 0 -> OnTimer routine has the control.
//			CTRL_FLAG = 1 -> rcv_packet / rcv_dnld_packet has the control.
//			CTRL_FLAG = 2 -> Emulator has control.
//			CTRL_FLAG = 3 -> Emulator had called rcv_char and OnTimer routine
//									can make it 0 so that next time it can make Go-on
//									flag as 2 and rcv_char will finish if it isn't
//									already completed.
//								********************
//		Go_on is used to time the rcv_char function.
//			Go_on = 0 ->	rcv_char is in execution. Time it out by making it 2.
//			Go_on = 1 ->	rcv_char can be called after making it 0.
//			Go_on = 2 ->	prepare for reading char by making it 1.
//
// ---------------------------------------------------------------------------

void CMainDlg::OnTimer (UINT nIDEvent)
{
	if (ApplicationDone)
		CDialog::OnTimer (nIDEvent) ;

	if (nIDEvent == TelnetTimerID)
		TelnetClientTimer() ;
	else
	   if (nIDEvent == CodeTimerID) 
		{			// Timer for downloading Code.
	      	if (Loopcount >= 10) 
			{
				KillTimer (nIDEvent) ;
				cMiscCom.TimeOut = TRUE;
 		   	}
	      	Loopcount ++ ;
		}
		else
		{
			if (nIDEvent == PollingTimerID) 
			{		// Timer for polling COM port.
				LED_Flash_Count ++ ;		// count for updating LEDs.
				if (LED_Flash_Count >= 9) 
				{
					LED_Flash_Count = 0 ;
					BYTE signals = cMiscCom.GetRS232() ;
					TermShowSignals (signals) ;		// Update LEDs.
				}
#if 1				//WAN device configuration missing chars from
					//the device
#define COM_READ_BLOCK_SIZE 128
				int com_read_block_length ;
				char com_buffer[COM_READ_BLOCK_SIZE] ;

				if (CommandLineArgument == 4)
				{
					/* Read the com port and just put it on the terminal */
					com_read_block_length = cMiscCom.receive_buffer (&com_buffer[0], COM_READ_BLOCK_SIZE) ;
					if (com_read_block_length)
						TermEmulation (&com_buffer[0], com_read_block_length) ;
				}
				else
				{
#endif
					if (CTRL_FLAG == 1) 
					{
						exitcount ++ ;
						if (exitcount >= Max_exitcount)
							CTRL_FLAG = 0 ;
						if (After_Abort) 
						{ 			// Download Setup is aborted by target.
							After_Abort = FALSE ;
							CTRL_FLAG = 0 ;
						}
					}
					if (CTRL_FLAG == 0) 
					{				// Can read char from COM port.
						char ch ;
						switch (Go_on)
						{
							case 0 :			// Timeout occured and char couldn't be read.
								Go_on = 2 ;	// Make it true.
								break ;		// So that it comes out of rcv_char.
								
							case 1 :
								Go_on = 0 ;
								if (!cMiscCom.timer_rcv_char (&ch))
									break ;
								if (ExpectingReplyPacket && (ch == (BYTE) 0x7e))
								{
									CTRL_FLAG = 1 ;	// Relinquish control to rcv_packet
									exitcount = 0 ;
								}
								else
									Emulator (ch) ;	// Print Console
								break ;
					
							case 2 :
								Go_on = 1 ;	// Make it ready for reading char next time.
								break ;
						}
					}
					if (CTRL_FLAG == 3) 	// Emulator couldn't read a char.
						CTRL_FLAG = 0 ;
#if 1
				}
#endif
			}
		   // Vidy, Chida - 25 Apr 1997		   
			else if (nIDEvent == dGetLockTimerID || nIDEvent == dFreeLockTimerID)
			{
				KillTimer (nIDEvent) ;
				cMiscCom.TimeOut = TRUE;
			}
		   	else if (nIDEvent == dConLockPollTimerID) 
	   		{
				// Keep trying to get the configuration lock from configuration manager
				if (bConLockPollTimerActive)
				{	
					bGetLockCalledFromTimer	= TRUE;
					GetLock();
					bGetLockCalledFromTimer	= FALSE;
					
					if (eUserResponse == E_ABORT)
					{
					// If we donot get the lock, kill the application
//		   				AfxGetApp()->LoadCursor(IDC_WAIT);
//		   				AfxGetApp()->DoWaitCursor(1);

						KillTimer (nIDEvent);
						PostQuitMessage (0) ;
					}

				}
				else
					KillTimer (nIDEvent);
	   		}
			else
			{
	      		KillTimer (nIDEvent) ;
		      	cMiscCom.TimeOut = TRUE ;
			}
	   }
		CDialog::OnTimer(nIDEvent);
}       // End of OnTimer

void CMainDlg::OnButtonPconsole()
{
	TermSetFocusTerminal();	 //Set focus to print console.
}

// -------------------------------------------------------------------------
// Function         :       CMainDlg::Emulator
// Arguments        :       character.
// Synopsis         :       Sends the character to Print console. Keeps control
//									 till a 0x7e is recd. or unable to receive char.
// Returns          :       None.
// Globals Affected :       CTRL_FLAG , exitcount
// -------------------------------------------------------------------------
void CMainDlg::Emulator (char ch)
{
	char c ;
	CTRL_FLAG = 2 ;			// Stay in Emulator
	TermEmulation (&ch, 1) ;
	while (CTRL_FLAG == 2)	// Stay in Emulator
	{
		CTRL_FLAG = 3 ;
		Go_on = 0 ;
		if (cMiscCom.timer_rcv_char (&c))
		{	// Read a character
			CTRL_FLAG = 2 ;
			if (ExpectingReplyPacket && (c == (BYTE) 0x7e)) 
			{
				if (exitcount < Max_exitcount)
				{
					CTRL_FLAG = 1 ;		// Relinquish Control to rcv_packet/rcv_dnld_packet
					exitcount = 0 ;
				}
			}
			else
				TermEmulation (&c, 1) ;
		}
		else
			CTRL_FLAG = 0 ;
	}
}	// End of Emulator()

// -------------------------------------------------------------------------
// Function   			:	CMainDlg::Connect()
// Arguments  			:	None.
// Synopsis   			:	Dials if the dial string is present in the SETUP.INI 
//								file. Otherwise it assumes a direct connection.
// Returns    			:	TRUE if connection established, otherwise FALSE.
// Globals Affected  :	None.
// -------------------------------------------------------------------------
BOOL CMainDlg::Connect()
{
	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	GetPrivateProfileString (LPortSectionHeader, DialString,
					(LPCSTR) "ATDP", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;

	//	If Dial string is empty, then no need to dial.
	if (m_DialString.IsEmpty() || cMiscCom.IsDCDPresent())	
		return TRUE ;				// Its a direct connection.

	// Dial the Router.
	CDialDlg cDialDlg (this) ; 

	char mdm_init_string[50] ;
	char mdm_resp[30] ;
		
	char *tmp ;

	GetPrivateProfileString (LPortSectionHeader, InitString,
						(LPCSTR) "ATS0=1&E5", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_InitString = szBuf ;

	m_InitString += "^M" ;
	tmp = m_InitString.GetBuffer (50) ;
	cMiscCom.ConvertControls ((BYTE *) mdm_init_string, (BYTE *) tmp) ;
	m_InitString.ReleaseBuffer() ;

	GetPrivateProfileString (LPortSectionHeader, InitRespString,
						(LPCSTR) "OK", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_InitResponse = szBuf;
	tmp = m_InitResponse.GetBuffer (30) ;
	cMiscCom.ConvertControls ((BYTE *) mdm_resp, (BYTE *) tmp) ;
	m_InitResponse.ReleaseBuffer() ;

	cMiscCom.TimeOut = FALSE ;
	UINT nTimerID = dConnectTimerID1 ; 
	while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
										MainMsgHeader, MB_RETRYCANCEL)) 
		{
			goto Error_Exit ;
		}
	}

	// send modem init string and wait for response	
	cMiscCom.snd_mdm_command ((BYTE *) mdm_init_string, 	
													strlen (mdm_init_string)) ;	
	if (!cMiscCom.rcv_mdm_response ((BYTE *) mdm_resp, 	
											(BOOL *) &cMiscCom.TimeOut))	
	{	
		// timeout occured and no response	
		KillTimer (nTimerID) ;	
		RouMsgBox (GetSafeHwnd(), MSG_MAIN_NO_MDM_RESP,	
			MainMsgHeader, MB_OK | MB_ICONSTOP) ;	
		goto Error_Exit ;
	}	
	else 	// Got the init response.	
		KillTimer (nTimerID) ;	
	
	// Modem initialized successfully now send the dial string.
	char mdm_dial_string[30] ;
	char mdm_connect_resp[30] ;

	m_DialString += "^M" ;
	tmp = m_DialString.GetBuffer (30) ;
	cMiscCom.ConvertControls ((BYTE *) mdm_dial_string, (BYTE *) tmp) ;
	m_DialString.ReleaseBuffer() ;

  	GetPrivateProfileString (LPortSectionHeader, ConnectString,
						(LPCSTR) "CONNECT", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_ConnectResponse = szBuf ;
	tmp = m_ConnectResponse.GetBuffer (30) ;
	cMiscCom.ConvertControls ((BYTE *) mdm_connect_resp, (BYTE *) tmp) ;
	m_ConnectResponse.ReleaseBuffer() ;
												 
	cMiscCom.TimeOut = FALSE ;
	nTimerID = dConnectTimerID2 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
								MainMsgHeader, MB_RETRYCANCEL)) 
		{
			goto Error_Exit ;
		}
	}

	// Send dial string and wait for connect response.
	cMiscCom.snd_mdm_command ((BYTE *) mdm_dial_string,
											strlen (mdm_dial_string)) ;
	if (!cMiscCom.rcv_mdm_response ((BYTE *) mdm_connect_resp, 
												(BOOL *) &cMiscCom.TimeOut) ) 
	{
			KillTimer (nTimerID) ;
			UINT nTimerID = dConnectTimerID3 ;
			cMiscCom.TimeOut = FALSE ;
			char mdm_hangup[2] ;

			while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
			{
				if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
										MainMsgHeader, MB_RETRYCANCEL)) 
				{
					goto Error_Exit ;
				}
			}

			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0 ;
			cMiscCom.hangup_mdm (mdm_hangup, (BOOL *) &cMiscCom.TimeOut) ;
			KillTimer (nTimerID) ;
			RouMsgBox (GetSafeHwnd(), MSG_COM_ERR_CONNECT, MainMsgHeader, MB_OK | 
																MB_ICONINFORMATION) ;     
			goto Error_Exit ;
	}       
	else 	// Got the connect response.
		KillTimer (nTimerID) ;

	cDialDlg.DestroyWindow() ;
	return TRUE ;

Error_Exit:
	cDialDlg.DestroyWindow() ;
	return FALSE ;
}	// End of Connect

// -------------------------------------------------------------------------
// Function   			:	CMainDlg::Disconnect()
// Arguments  			:	None.
// Synopsis   			:	Hangs if the dial string is present in the SETUP.INI 
//								file. Otherwise it assumes a direct connection.
// Returns    			:	None.
// Globals Affected  :	None.
// -------------------------------------------------------------------------
void CMainDlg::Disconnect()
{
	char 	szBuf[50];
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse;

	GetPrivateProfileString(LPortSectionHeader, DialString,
					(LPCSTR) "ATDP",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_DialString = szBuf;

	if (m_DialString.IsEmpty())
		return;
	if (cMiscCom.IsDCDPresent() )
		if (RouMsgBox(GetSafeHwnd(), MSG_GEN_ASK_HUP, MainMsgHeader, MB_YESNO
					| MB_DEFBUTTON1 | MB_ICONQUESTION) != IDYES)
		return;

	cMiscCom.TimeOut = FALSE;
	char mdm_hangup[2];

	UINT nTimerID = dDisconnectTimerID ;
	while(nTimerID != SetTimer(nTimerID,(UINT)2000,NULL))
		if(IDCANCEL == RouMsgBox(GetSafeHwnd(), MSG_GEN_NO_TIMER,MainMsgHeader,MB_RETRYCANCEL)) {
			return;
		}

	mdm_hangup[0] = 0x1b ;
	mdm_hangup[1] = 0;
	cMiscCom.hangup_mdm(mdm_hangup, (BOOL *) &cMiscCom.TimeOut);
	KillTimer(nTimerID);
}	//End of Disconnect



void CMainDlg::OnButtonApp()
{
	// TODO: Add your control notification handler code here
	APPLICAT Applications ;
	Applications.DoModal();
}

LRESULT CMainDlg::TelnetRead(WPARAM wParam, LPARAM lParam)
{
	TelnetReadMsgReceived() ;
	return (NULL) ;
}

LRESULT CMainDlg::TelnetWrite(WPARAM wParam, LPARAM lParam)
{
	TelnetWriteMsgReceived(wParam, lParam) ;
	return (NULL) ;
}


void CMainDlg::OnRetry()
{
	// TODO: Add your control notification handler code here
		if (Connect()) 
		{   
			SetCapture();
		   AfxGetApp()->LoadCursor(IDC_WAIT);
		   AfxGetApp()->DoWaitCursor(-1);
		   AfxGetApp()->DoWaitCursor(1);

		   CCheck cCheck(this);			//Display the Checking message
			CheckTarget();             //Check the status of Target.
		   AfxGetApp()->DoWaitCursor(0);
			ReleaseCapture();
		}
		InitButtonState() ;
}

// Added by cfp
void CMainDlg::RevampHelpExitRetryButtons() 
{
	m_Retry.ShowWindow (SW_HIDE) ;
	m_Retry.EnableWindow (FALSE) ;
}


BOOL RmtLocalIpAddressesOfSameNet (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask)
{
 	unsigned char Local[4] ;
	unsigned char Remote[4] ;
	unsigned char Mask[4] ;

	ConvertDotDecimal (LocalAddr, &Local[0]) ;
	ConvertDotDecimal (RmtAddr, &Remote[0]) ;
	ConvertDotDecimal (AddrMask, &Mask[0]) ;

	// Make it faster
#if 0
	for (int i = 0 ; i < 4 ; i ++)
	{
		if ((Local[i] & Mask[i]) == (Remote[i] & Mask[i]))
			continue ;
		return FALSE ;
	}
#endif

	unsigned long local_address, remote_address, subnet_mask ;

	local_address = *((unsigned long *) &Local[0]) ;
	remote_address = *((unsigned long *) &Remote[0]) ;
	subnet_mask = *((unsigned long *) &Mask[0]) ;

	if ((local_address & subnet_mask) == (remote_address & subnet_mask))
		return TRUE ;
	else
		return FALSE ;
}


BOOL RmtLocalIpAddressesOfSameNet_2 (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR LocalMask, LPCSTR RmtMask)
{
 	unsigned char Local[4] ;
	unsigned char Remote[4] ;
	unsigned char L_Mask[4] ;
	unsigned char R_Mask[4] ;

	ConvertDotDecimal (LocalAddr, &Local[0]) ;
	ConvertDotDecimal (RmtAddr, &Remote[0]) ;
	ConvertDotDecimal (LocalMask, &L_Mask[0]) ;
	ConvertDotDecimal (RmtMask, &R_Mask[0]) ;

	unsigned long local_address, remote_address, local_mask, remote_mask ;

	local_address = *((unsigned long *) &Local[0]) ;
	remote_address = *((unsigned long *) &Remote[0]) ;
	local_mask = *((unsigned long *) &L_Mask[0]) ;
	remote_mask = *((unsigned long *) &R_Mask[0]) ;

	if ((local_address & local_mask) == (remote_address & remote_mask))
		return TRUE ;
	else
		return FALSE ;
}


void ConvertDotDecimal (LPCSTR Addr, unsigned char *pAddr) 
{
	char szAddr[30] ;
	char *ptr ;

	strcpy (szAddr, Addr) ;
	ptr = &szAddr[0] ;

	while (*ptr)
	{
		if (*ptr == '.')
		{
			*ptr = 0x00 ;
			*pAddr++ = (unsigned char) atoi (szAddr) ;
			ptr ++ ;
			strcpy (szAddr, ptr) ;
			ptr = &szAddr[0] ;
		}
		else
			ptr ++ ;
	}
	*pAddr = (unsigned char) atoi (szAddr) ;
	return ;
}


void CheckForIPClientOnly (HWND hWnd)
{
	int nWanPorts = GetPrivateProfileInt (LSLSectionHeader,
									 "LSL Number of WAN Ports", 1, IniInWinForm) ;
	char szPPPLHS[80] ;
	char szPPPRHS[50] ;
	char szIPLHS[80] ;
	char szIPLocalAddr[25] ;
	char szIPMask[25] ;
	char szIPRmtAddr[25] ;
	char szMsgBuf[100] ;
	char szIPRHS[20] ;

	for (int i = 0 ; i < nWanPorts ; i ++)
	{
		sprintf (szIPLHS, "IP Port%d BOOTP", i + 1) ;
		GetPrivateProfileString (IPSectionHeader,
			szIPLHS, StrDisabled, szIPRHS, sizeof (szIPRHS),
					IniInWinForm) ;
		if (strcmp (szIPRHS, StrDisabled) == 0)
		{
			sprintf (szPPPLHS, "%s%d%s", "PPP Port", i, 
											" Remote Port Client Only") ;
			GetPrivateProfileString (PPPSectionHeader,
					szPPPLHS, StrDisabled, szPPPRHS, 
							sizeof (szPPPRHS), IniInWinForm) ;
			if (!strcmpi (szPPPRHS, StrEnabled))
			{
				sprintf (szIPLHS, "%s%d%s", "IP Port", (i + 1), " Address") ;
				GetPrivateProfileString (IPSectionHeader,
						szIPLHS, StrNull, szIPLocalAddr, 
								sizeof (szIPLocalAddr), IniInWinForm) ;

				sprintf (szIPLHS, "%s%d%s", "IP Port", (i + 1), " Address Mask") ;
				GetPrivateProfileString (IPSectionHeader,
						szIPLHS, StrNull, szIPMask, 
								sizeof (szIPMask), IniInWinForm) ;

				sprintf (szIPLHS, "%s%d%s", "IP Port", (i + 1), " Remote Address") ;
				GetPrivateProfileString (IPSectionHeader,
						szIPLHS, StrNull, szIPRmtAddr, 
								sizeof (szIPRmtAddr), IniInWinForm) ;

				if (!RmtLocalIpAddressesOfSameNet
					 ((LPCSTR) szIPLocalAddr, (LPCSTR) szIPRmtAddr, (LPCSTR) szIPMask))
				{
					sprintf (szMsgBuf, "%s%d%s", "Local and Remote addresses \
in the IP section for WAN Port", (i + 1), " should belong to the same net") ;
					::MessageBox (hWnd, szMsgBuf, "Warning!!!",
											MB_OK | MB_ICONINFORMATION) ;
				}
		
				if (!RmtLocalIpAddressesHaveDiffHost
					 ((LPCSTR) szIPLocalAddr, (LPCSTR) szIPRmtAddr, (LPCSTR) szIPMask))
				{
					sprintf (szMsgBuf, "%s%d%s", "Local and Remote addresses \
in the IP section for WAN Port", (i + 1), " should have different host IDs") ;
					::MessageBox (hWnd, szMsgBuf, "Warning!!!",
											MB_OK | MB_ICONINFORMATION) ;
				}
			}
		}
	}		
	return ;
}

#if 0
BOOL CheckForWANClientOnly()
{
	int nWanPorts = GetPrivateProfileInt (LSLSectionHeader,
									 "LSL Number of WAN Ports", 1, IniInWinForm) ;

	char szPPPLHS[80] ;
	char szPPPRHS[50] ;
	char szWANLHS[80] ;
	char szWANRHS[50] ;

	for (int i = 0 ; i < nWanPorts ; i ++)
	{
		sprintf (szPPPLHS, "%s%d%s", "PPP Port", i, 
												" Remote Client Type only") ;
		GetPrivateProfileString (PPPSectionHeader,
				szPPPLHS, StrDisabled, szPPPRHS, 
						sizeof (szPPPRHS), IniInWinForm) ;
		if (!strcmpi (szPPPRHS, StrEnabled))
		{
			sprintf (szWANLHS, "%s%d%s", "WAN Port", i, " ASYNC") ;
			GetPrivateProfileString (WANSectionHeader,
 				szWANLHS, StrDisabled, szWANRHS,
						sizeof (szWANRHS), IniInWinForm) ;
			if (!strcmpi (szWANRHS, StrDisabled))
				return FALSE ;

			sprintf (szWANLHS, "%s%d%s", "WAN Port", i, " Auto Answer") ;
			GetPrivateProfileString (WANSectionHeader,
 				szWANLHS, StrDisabled, szWANRHS,
						sizeof (szWANRHS), IniInWinForm) ;
			if (!strcmpi (szWANRHS, StrDisabled))
				return FALSE ;
		}
	}
	return TRUE ;
}
#endif


BOOL RmtLocalIpAddressesHaveDiffHost (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask)
{
 	unsigned char Local[4] ;
	unsigned char Remote[4] ;
	unsigned char Mask[4] ;

	ConvertDotDecimal (LocalAddr, &Local[0]) ;
	ConvertDotDecimal (RmtAddr, &Remote[0]) ;
	ConvertDotDecimal (AddrMask, &Mask[0]) ;

	// This cannot be used because of a bug in the compiler
	// and it takes more time
#if 0
	for (int i = 0 ; i < 4 ; i ++)
	{
		Mask[i] = ~Mask[i] ;
		if (!Mask[i])
 			continue ;
		if (Local[i] & Mask[i] == Remote[i] & Mask[i])
			return FALSE ;
	}
#endif

	unsigned long local_address, remote_address, subnet_mask ;

	local_address = *((unsigned long *) &Local[0]) ;
	remote_address = *((unsigned long *) &Remote[0]) ;
	subnet_mask = *((unsigned long *) &Mask[0]) ;

	if ((local_address & ~subnet_mask) == (remote_address & ~subnet_mask))
		return FALSE ;

	return TRUE ;
}

/*----------------------------------------------------------------------------
	Module           : IsBackupEnabled
	Author           : Chidanand
	Input            : None
	Output           : None
	Synopsis	     : Check is done if Dial Backup is enabled
	Globals affected : None
----------------------------------------------------------------------------*/
BOOL CMainDlg::IsBackupEnabled (void)
{
#if 0
	int i;
	char szLHS[100], szRHS[20];

	for (i = 0 ; i < 2 ; i++)
	{
		sprintf (szLHS, "PPP Port%d Link", (i * 10) + 1) ;
		GetPrivateProfileString ((LPCSTR) PPPSectionHeader, (LPCSTR) szLHS, (LPCSTR) StrDisabled, (LPSTR) szRHS,
					sizeof (szRHS), (LPCSTR) IniInWinForm) ;
		if (strcmp (szRHS, StrEnabled) == 0)
			return TRUE;
	}
#endif
	return FALSE;
}

/*----------------------------------------------------------------------------
	Module           : IsWanPortEnabled
	Author           : Chidanand
	Input            : Port No (0-relative)
	Output           : TRUE if enabled; FALSE if disabled
	Synopsis	     : Check is done if WAN Port is enabled
	Globals affected : None
----------------------------------------------------------------------------*/
BOOL CMainDlg::IsWanPortEnabled (int pPortNo)
{
	char szLHS[100], szRHS[20];

	sprintf (szLHS, "WAN Port%d", pPortNo) ;
	GetPrivateProfileString (WANSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (strcmp (szRHS, StrEnabled) == 0);
}

/*----------------------------------------------------------------------------
	Module           : IsWanPortAsync
	Author           : Chidanand
	Input            : Port No (0-relative)
	Synopsis	     : Returns TRUE if WAN port is ASYNC
	Globals affected : None
----------------------------------------------------------------------------*/
BOOL CMainDlg::IsWanPortAsync (int pPortNo)
{
	char szLHS[100], szRHS[20];

	sprintf (szLHS, "WAN Port%d ASYNC", pPortNo) ;
	GetPrivateProfileString (WANSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (BOOL)(strcmp (szRHS, StrEnabled) == 0);
}


BOOL CMainDlg::IsWanPortAnswering (int pPortNo)
{
	char szLHS[100], szRHS[20];

	sprintf (szLHS, "WAN Port%d Auto Answer", pPortNo) ;
	GetPrivateProfileString (WANSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (BOOL)(strcmp (szRHS, StrEnabled) == 0);
}


BOOL CMainDlg::IsPPPEnabled (int pPortNo)
{
	char szLHS[100], szRHS[20];

	sprintf (szLHS, "PPP Port%d", pPortNo) ;
	GetPrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (strcmp (szRHS, StrEnabled) == 0);
}

BOOL CMainDlg::IsSLIPEnabled (int pPortNo)
{
	char szLHS[100], szRHS[20];

	sprintf (szLHS, "PPP Port%d SLIP", pPortNo) ;
	GetPrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (strcmp (szRHS, StrEnabled) == 0);
}


BOOL CMainDlg::IsIPEnabled (int pPortNo)
{
	char szLHS[100], szRHS[20];
	
	GetPrivateProfileString (IPSectionHeader, "IP", StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	if (strcmp (szRHS, StrEnabled))
		return FALSE;
	
	sprintf (szLHS, "IP Port%d", pPortNo) ;
	GetPrivateProfileString (IPSectionHeader, szLHS, StrDisabled, szRHS, sizeof (szRHS), IniInWinForm) ;
	return (BOOL)(strcmp (szRHS, StrEnabled) == 0);
}


/*----------------------------------------------------------------------------
	Module           : EnablePPP
	Author           : Chidanand
	Input            : Port No (0-relative)
						pEnable - TRUE to turn ON PPP, FALSE to turn it OFF.
	Output           : None
	Synopsis	     : Writes string to enable or disable a specific port of PPP
	Globals affected : None
----------------------------------------------------------------------------*/
void CMainDlg::EnablePPP (int pPortNo, BOOL pEnable)
{  
	char szLHS[100];
	LPCSTR 	szTemp ;

	sprintf (szLHS, "PPP Port%d", pPortNo) ;
	szTemp = pEnable ? StrEnabled : StrDisabled;
	WritePrivateProfileString (PPPSectionHeader, szLHS, szTemp, IniInWinForm) ;
}

/*----------------------------------------------------------------------------
	Module           : EnableSLIP
	Author           : Chidanand
	Input            : Port No (0-relative)
						pEnable - TRUE to turn ON, FALSE to turn it OFF.
	Output           : None
	Synopsis	     : Writes string to enable or disable a specific port of SLIP
						If disabling, it disables CSLIP also.
	Globals affected : None
----------------------------------------------------------------------------*/
void CMainDlg::EnableSLIP (int pPortNo, BOOL pEnable)
{  
	char szLHS[100];
	LPCSTR 	szTemp ;

	sprintf (szLHS, "PPP Port%d SLIP", pPortNo) ;
	szTemp = pEnable ? StrEnabled : StrDisabled;
	WritePrivateProfileString (PPPSectionHeader, szLHS, szTemp, IniInWinForm) ;
	if (pEnable)
	{
		sprintf (szLHS, "LSL Port%d Maximum Buffer Size", pPortNo + GetNumberOfLANPorts()) ;
		WritePrivateProfileString(LSLSectionHeader, szLHS, "2014", IniInWinForm);
	}
	else
	{
		sprintf (szLHS, "LSL Port%d Maximum Buffer Size", pPortNo + GetNumberOfLANPorts()) ;
		WritePrivateProfileString(LSLSectionHeader, szLHS, "1500", IniInWinForm);
		sprintf (szLHS, "PPP Port%d CSLIP", pPortNo) ;
		WritePrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, IniInWinForm) ;
	}
}

void CMainDlg::EnableCSLIP (int pPortNo, BOOL pEnable)
{  
	
	char szLHS[100];
	LPCSTR 	szTemp ;

	sprintf (szLHS, "PPP Port%d CSLIP", pPortNo) ;
	szTemp = pEnable ? StrEnabled : StrDisabled;
	WritePrivateProfileString (PPPSectionHeader, szLHS, szTemp, IniInWinForm) ;
	if (pEnable)
	{
		// If CSLIP is enabled, enable both SLIP and VJC
		EnableSLIP (pPortNo, pEnable); 

		sprintf (szLHS, "VJC Port%d", pPortNo) ;
		WritePrivateProfileString ("VJC Compression", szLHS, StrEnabled, IniInWinForm) ;
	}
}

BOOL CMainDlg::GetLock (void)
{   
	static int sConsLockTimeoutCnt = 0;
	static int sConsLockFailCnt = 0;
	static BOOL sReentrancyFlag = FALSE;
	
// TEMP : fix
	if (!RouterUp || IsPortIP)
	{
		bGotLock = TRUE;	
		return TRUE;	
	}

    // If user has chosen IGNORE earlier, no GetLock() in future.
	if (eUserResponse == E_IGNORE)
		return TRUE;    
	
	
	if (sReentrancyFlag)
		return TRUE ;
	sReentrancyFlag = TRUE ;


	//Try to get the configuration lock from configuration manager
	//******
	char szRHS[30], szMessage[80];
	ReqType Request;
	ResultType Result;


#if 0	
	//Looks like this Lock is not very smooth
	//This is for Kevin to start testing
	bGotLock = TRUE;	
	return TRUE;
#endif


    // First deinstall periodic timer. After response/timeout we can 
    // install again.
	DeInstallConLockPollTimer () ;	// To avoid tile of message boxes

	// Prepare Request record	
	memset (&Request, 0, sizeof(Request));
	Request.Ptype = GET_LOCK ;	

	// Install timer
   	UINT nTimerID = dGetLockTimerID ;
   	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
    	if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
					MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
      		//   NoTimer = TRUE ;
      	}
	}
	
	// Send GET_LOCK request to router and wait for response
   	cMiscCom.TimeOut = FALSE ;
   	while (1)
   	{    
    	cMiscCom.snd_packet ((BYTE *) &Request, sizeof (Request)) ;
      	if (!(cMiscCom.rcv_packet ((BYTE *) &Result,
				sizeof (Result), (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;     // No CRC Error
		}
   	}
   	
   	
   	if (!cMiscCom.TimeOut)
	{
		// We have got some response. Check fields in it for a match.
		if (Result.Ptype == LOCK_RESP_TYPE)
		{		
			// This is the response for our Lock Request
			sConsLockFailCnt = sConsLockTimeoutCnt = 0;

			// Check result code of GET_LOCK request			
			if (Result.ErrorCode == LK_LOCKED_OK)
			{   
				// We got the LOCK.
				// Now if there is a switch over in the lock status, 
				// then enable controls also.
				eUserResponse = E_NONE;
				bGotLock = TRUE;
            if (CommandLineArgument != 6)                                             
					InitButtonState (FALSE);	// If there is change of lock state, show it up.
			}
			else
			{ 
				// Our lock request is REJECTED   
				// Display the message reg. who has locked it.
				switch (Result.ErrorCode)
				{
				case LK_LOCK_OWNED_BY_TELNET :
					strcpy (szRHS, "Telnet");
					break;
				
				case LK_LOCK_OWNED_BY_WEB :
					strcpy (szRHS, "Web Browser");
					break;
			
				case LK_LOCK_OWNED_BY_DUMB_TTY :
					strcpy (szRHS, "Dumb Terminal");
					break;

				default :				
					strcpy (szRHS, "somebody");
				}
			
				wsprintf (szMessage, "Router Configuration has been locked by %s.", szRHS);
				int aID = ::MessageBox (GetSafeHwnd(),(LPCSTR) szMessage, 
					(LPCSTR) MainMsgHeader, MB_ABORTRETRYIGNORE | MB_DEFBUTTON1 | MB_ICONQUESTION) ;
				
				eUserResponse = (aID == IDABORT) ? E_ABORT : ((aID == IDRETRY) ? E_RETRY : E_IGNORE);
				bGotLock = FALSE;
            if (CommandLineArgument != 6)  /* Sreelu for upgrade */                                           
					InitButtonState (FALSE);
        	}
        }
        else
        {
        	// We got some packet other than Lock Response
        	// Ignore this and treat it similar to Get-Lock time out.
			if (++sConsLockFailCnt >= dMAX_GET_LOCK_TIMEOUT_TRIES)
			{
				// Display message and Modify bGotLock only after Max.tries fail.
				sConsLockFailCnt = 0;

				int aID = RouMsgBox (GetSafeHwnd(), MSG_MAIN_LOCK_FAIL_EXIT, MainMsgHeader,
									MB_ABORTRETRYIGNORE | MB_DEFBUTTON1 | MB_ICONQUESTION);
				
				eUserResponse = (aID == IDABORT) ? E_ABORT : ((aID == IDRETRY) ? E_RETRY : E_IGNORE);
				bGotLock = FALSE;
            if (CommandLineArgument != 6)  /* Sreelu for upgrade */                                           
					InitButtonState (FALSE);
			}
        }
	} 
	else 
	{
		// Time out
		if (++sConsLockTimeoutCnt >= dMAX_GET_LOCK_TIMEOUT_TRIES)
		{
			// Display message and Modify bGotLock only after Max.tries fail.
			sConsLockTimeoutCnt = 0;
			int aID = RouMsgBox (GetSafeHwnd(), MSG_MAIN_LOCK_TIMEOUT_EXIT, MainMsgHeader,
									MB_ABORTRETRYIGNORE | MB_DEFBUTTON1 | MB_ICONQUESTION);
									
			eUserResponse = (aID == IDABORT) ? E_ABORT : ((aID == IDRETRY) ? E_RETRY : E_IGNORE);
			bGotLock = FALSE;
         if (CommandLineArgument != 6)  /* Sreelu for upgrade */                                           
				InitButtonState (FALSE);
		}
	}
	
	if (bGetLockCalledFromTimer && (eUserResponse == E_NONE || eUserResponse == E_RETRY))
		InstallConLockPollTimer (FALSE) ;

	sReentrancyFlag = FALSE ;

	return bGotLock;
}
 
 
BOOL CMainDlg::FreeLock (void)
{

	if (IsPortIP)
		return TRUE;

	// Release the configuration lock from configuration manager
	if (!bGotLock)
		return FALSE;

	ReqType Request;
	ResultType Result;
   	Request.Ptype = FREE_LOCK ;	// Free the lock
   	
   	UINT nTimerID = dFreeLockTimerID ;
   	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
					MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
       // 	NoTimer = TRUE ;
      	}
	}
	
	cMiscCom.TimeOut = FALSE ;
   	while (1)
   	{    
    	cMiscCom.snd_packet ((BYTE *) &Request, sizeof (Request)) ;
      	if (!(cMiscCom.rcv_packet ((BYTE *) &Result,
				sizeof (Result), (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;     
		}
   	}
   	if (!cMiscCom.TimeOut)
	{	
		bGotLock = FALSE;
		
		// Do we have to check Error code ..?..
	} 
	else 
	{
		// Time out
		return FALSE;
	}
	return TRUE;
}

void CMainDlg::InstallConLockPollTimer (BOOL pCallGetLockFirst)
{
	if (IsPortIP)
		return;
		
    // If user has chosen IGNORE, No GetLock() in future.
	if (eUserResponse == E_IGNORE)
		return;    
	
	// Chida - 2 May 1997
	if (!bConLockPollTimerActive && pCallGetLockFirst)
		GetLock();    
	// Chida - 2 May 1997
    
	KillTimer (dConLockPollTimerID);
   	while (dConLockPollTimerID != SetTimer (dConLockPollTimerID,
										   	(UINT) dConLockPollInterval, NULL))
	{
		if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
	 						 MainMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
			return;    
		}
	}
	bConLockPollTimerActive	= TRUE;
}

void CMainDlg::DeInstallConLockPollTimer (void)
{
	KillTimer (dConLockPollTimerID);
	bConLockPollTimerActive	= FALSE;
}


void CMainDlg::OnButtonProxy()
{
	// TODO: Add your control notification handler code here
	Proxy ProxyDlg(this);

	ProxyDlg.DoModal();
	
}

HBRUSH CMainDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	// TODO: Add your message handler code here and/or call default
	
	return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

}

void CMainDlg::OnButtonDhcp()
{
	// TODO: Add your control notification handler code here
	DHCP DHCPDlg(this);

	DHCPDlg.DoModal();
}

void CMainDlg::OnButtonStatistics()
{
	// TODO: Add your control notification handler code here
	CPortStat cPort;
   cPort.DoModal();
}

void CMainDlg::OnButtonNat()
{
       
	// TODO: Add your control notification handler code here
	CNATDlg nat(this);
	nat.DoModal();
}

#if 0
int CMainDlg::invoke_the_timer()
{
	AfxMessageBox("Calling timer Func");
	int error_code;
	char local1[25];
	UINT nTimerID  = this->SetTimer(EVENT_TIMERID, MAX_EVENT_RESPONSE_WAIT, NULL) ;

	if(nTimerID == 0)
	{
		AfxMessageBox("Failed");
		return -1;
	}
		AfxMessageBox("Pass");
       
	recieve_data_from_the_packet(&error_code);
        sprintf(local1, "%d" ,error_code);	
      	AfxMessageBox(local1);
	
	return 0;
}
#endif

//Neelu added  this  event handler function for Event Broadcast
#if 0
LRESULT CMainDlg::OnBroadcastEvent(WPARAM wParam, LPARAM lParam)
{
	int error_code=0;
	enum EVENT_CATEG event_type;
	char local1[25];
   //    	char user_event_string[150];
	CMainDlg Cdlg;
	CWnd *Current_Window = Cdlg.GetActiveWindow();
  	recieve_data_from_the_packet(&error_code,&event_type);
// Post a message to user events log dialog if it is alive
	if(event_type==WAN_EVENT_BDCAST)
		Current_Window->PostMessage(WM_LOG_EVENT, 0 ,0 );
	else
		Current_Window->PostMessage(WM_USER_LOG_EVENT, 0 ,0 );
	
	return (NULL) ;

}
#endif
// Imran, 22.3.99
#define ReadLogTimerID 3
#define OPEN_LOG_TIMER_PERIOD  3000
#define READ_LOG_TIMER_PERIOD  6000

void CMainDlg::DnldUserEvents()
{
#if 0       
if (IsPortIP)   ////thro' TFTP
	{
		m_tftp_log_request_made = TRUE;

		strcpy (TFTPGetRemoteFileName, "usrdnld.log") ;
		strcpy (TFTPGetLocalFileName, UserDataFile) ;

		tftpread TFTPReadDlg ;
		TFTPReadDlg.DoModal() ;
		UpdateUserHistory();
		m_tftp_log_request_made = FALSE ;
	}
	else			////Through COM port
	{
		CFile input ;				

   	if (!input.Open (UserDataFile, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary))
	   {
	     	return ;
		}

		////Request for open log
		BOOL log_transferred = FALSE;
		ReqType LogViewPkt;
		ResultType LogViewRes;
		LogViewPkt.Ptype = (BYTE) OPEN_USER_EVENT_LOG;
		LogViewPkt.ReqType = 0;
		LogViewPkt.ReqSubType = 0;
		LogViewPkt.Dmy0 = 0;
	  	cMiscCom.TimeOut = FALSE;

   	UINT nTimerID = ReadLogTimerID ;
	  	while (nTimerID != SetTimer (nTimerID, (UINT) OPEN_LOG_TIMER_PERIOD, NULL))
		{
  		   	break;
		}
		
   	while (1)
	  	{
			cMiscCom.snd_packet ((BYTE *) &LogViewPkt, sizeof (ReqType));
			if (!(cMiscCom.rcv_packet2 ((BYTE *) &LogViewRes,
				sizeof (ResultType), (BOOL *) &cMiscCom.TimeOut)))
			{
				break ;   // No CRC error
			}
	  	}
		
	   KillTimer (nTimerID) ;
   	if (cMiscCom.TimeOut)
		{
				return;
		}
		////If OPEN_LOG is successful, give a call for DNLD LOG
		if (LogViewRes.ErrorCode != ERR_NO_LOGGING)
		{
			////Request for read log
			ReadLocReqType ReadLocReqPkt;
			ReadLocRespType ReadLocRespPkt;
			int	BlockAddr = 0;
			int	CumRetries = 0;
			ReadLocReqPkt.Ptype = (BYTE) DNLD_USER_EVENT_LOG;
			ReadLocReqPkt.Length = 128;
			ReadLocReqPkt.Address = cMiscCom.little_endian(BlockAddr);
/*			Cwaitdlg wait(AfxGetMainWnd());
			wait.InvalidateRect(NULL);
			wait.UpdateWindow(); 	  */

REPEATREAD:
	   	cMiscCom.TimeOut = FALSE;
		   UINT nTimerID = ReadLogTimerID ;
  			while (nTimerID != SetTimer (nTimerID, (UINT) READ_LOG_TIMER_PERIOD, NULL))
			{
  			   	break;
			}

			cMiscCom.FlushReadBuf();
			cMiscCom.snd_packet ((BYTE *) &ReadLocReqPkt, sizeof (ReadLocReqType));
			if (cMiscCom.rcv_packet2 ((BYTE *) &ReadLocRespPkt,
				sizeof (ReadLocRespType), (BOOL *) &cMiscCom.TimeOut))
			{	//This indicates a CRC error in received packet
				//We need to reread the same packet
			   KillTimer (nTimerID) ;
				goto REPEATREAD;
			}

		   KillTimer (nTimerID) ;
  			if (cMiscCom.TimeOut) 
			{
				if (CumRetries++ < 5)	//beyond these many, we giveup!
				{
					goto REPEATREAD;
				}
				if (!log_transferred)		 ////If something has been transferred
				{									 ////don't show the 'no response' box.
//					wait.DestroyWindow();
//	   			RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_RESP, ProxySectionHeader,  
//						MB_OK | MB_ICONINFORMATION); 
					closelog();
					return;					
				}
				else
				{
//					wait.DestroyWindow();
					input.Close();
					UpdateUserHistory();
				 	closelog();
					return;
				}
			}
			if (ReadLocRespPkt.ErrCode == ERR_READ_EVENT_LOG)
			{////Error in reading
  				closelog();
				return;
			}
			if (ReadLocReqPkt.Address != ReadLocRespPkt.Address)
			{	//check if request and response match
				goto REPEATREAD;
			}

			log_transferred = TRUE;
			input.Write ((LPCSTR)ReadLocRespPkt.buffer, ReadLocRespPkt.Length);

			if (ReadLocRespPkt.Length == 128)
			{////If the length = 128, then there may be still more to read
				cMiscCom.FlushReadBuf();
				BlockAddr++;
				ReadLocReqPkt.Address = cMiscCom.little_endian(BlockAddr);
				goto REPEATREAD;
			}
			else
			{
//				wait.DestroyWindow();
				input.Close();
				UpdateUserHistory();
				closelog();
			}
		}
	}
#endif       
	return;			  
}

void CMainDlg::closelog()
{
	////Send a request to close log	
	#if 0
	ReqType CloseLogPkt;
	ResultType CloseLogRes;
	CloseLogPkt.Ptype = (BYTE) CLOSE_USER_EVENT_LOG;
	CloseLogPkt.ReqType = 0;
	CloseLogPkt.ReqSubType = 0;
	CloseLogPkt.Dmy0 = 0;
  	cMiscCom.TimeOut = FALSE;
   UINT nTimerID = ReadLogTimerID ;
  	while (nTimerID != SetTimer (nTimerID, (UINT) OPEN_LOG_TIMER_PERIOD, NULL))
	{
  	   	break;
	}
   while (1)
	{
		cMiscCom.snd_packet ((BYTE *) &CloseLogPkt, sizeof (ReqType));
		if (!(cMiscCom.rcv_packet2 ((BYTE *) &CloseLogRes,
			sizeof (ResultType), (BOOL *) &cMiscCom.TimeOut)))
		{
			break ;   // No CRC error
		}
	}
	KillTimer (nTimerID);
	if (cMiscCom.TimeOut)
	{
		return;
	}
#endif
return;
}

void CMainDlg::UpdateUserHistory()
{
	CStdioFile input;
	char *FileName = UserDataFile ;
	char Buf[128];	
	char *ch;

	if (!input.Open(FileName, CFile::modeRead | CFile::typeText))
		return;

	while((input.ReadString(Buf , MaxINIString)) != NULL)
	{
		if ((ch = strchr (Buf, (int)'#')) != NULL)  
			*ch = '\0';
		if ((Buf[0]) && (Buf[0] != '\n'))
			CreateLogFiles(Buf);
	}
	input.Close();
}

void CMainDlg::CreateLogFiles(char *buf)
{
	int trash,dd,mm,yy;
	CStdioFile input;
	char filename[16];

	sscanf(buf,"%02d:%02d:%02d     %02d-%02d-%d",&trash,&trash,&trash,&dd,&mm,&yy);
	sprintf(filename,"%02d%02d%04d.log",dd,mm,yy);
  	if (!input.Open (filename, CFile::modeWrite | CFile::typeBinary))
	{
	  	if (!input.Open (filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary))
			return;
	}
	else
	{
		input.SeekToEnd();
	}
	input.Write(buf,strlen(buf));
	input.Close();
}



void CMainDlg::OnDefault()
{
	// TODO: Add your control notification handler code here
	return;	
}
