// -------------------------------------------------------------------------
// Project Name			:	Standard progress gauges for MultiExpress Suite
//							programs.
// Module Name			:	Gauges main file.
// File Name			:	MSGUMAIN.CPP
// Description			:	Implements the base class for the gauges used in
//							MultiExpress Suite for Windows.  This base class
// 							is used by the module MSGUVIEW for deriving all
// 							the gauges.
// Start Date			:	19 Oct 1994
// Author				:	Srini
// Date Last Modified	:	
// Modifications		:	
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "math.h"
#include "msgumain.h"

// -------------------------------------------------------------------------
// External Function Definitions
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// External Variable Definitions
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Static Variable Declarations
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------

#define		IDC_CHILD_WND		100
         
BEGIN_MESSAGE_MAP(CGauges, CWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()


// -------------------------------------------------------------------------
// 					The main gauge window class implementation
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CGauges::CGauges()
// Arguments		:	None.
// Synopsis			:	Constructor for the CGauges class.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
CGauges::CGauges()
{
}

// -------------------------------------------------------------------------
// Function			:	CGauges::~CGauges()
// Arguments		:	None.
// Synopsis			:	Destructor for the CGauges class.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
CGauges::~CGauges()
{
}

// -------------------------------------------------------------------------
// Function			:	CGauges::Create()
// Arguments		:	Parent window and dimensions of the gauge wrt parent.
// Synopsis			:	Creates a gauge window of the specified type.
// Returns			:	TRUE on success, FALSE otherwise.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
BOOL
CGauges::Create(CWnd* pParent, CRect& rcDim)
{

	// Create the gauge window
	if (! CWnd::Create(NULL, "", WS_CHILD | WS_VISIBLE,
							m_rcDim, pParent, IDC_CHILD_WND, NULL))
		return (FALSE);
		
	// This is the size of the gauge.
	m_rcDim = rcDim;
		
	return (TRUE);
}

// -------------------------------------------------------------------------
// Function			:	CGauges::SetGaugeInfo()
// Arguments		:	Caption string, Min and Max vals to display in the
//						gauge, Number of divisions (def 3), Style of
//						the gauge (def depressed), include percent
//						figures (def FALSE), color to be used for
//						filling (def Black) and color of caption text
//						(def Black).
// Synopsis			:	Sets the gauge info for displaying.
// Returns			:	TRUE on success, FALSE otherwise.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
BOOL
CGauges::SetGaugeInfo(LPCSTR lpszCaption, DWORD nMinVal, DWORD nMaxVal, int nStyle, int nInStyle,
				BOOL bPercent, BOOL bScale, BOOL bRange, DWORD dwClrBrdrUp, 
				DWORD dwClrBrdrDn, DWORD dwClrFill, DWORD dwClrBk, DWORD dwClrTxt)
{
	if (nMinVal >= nMaxVal)
		return (FALSE);

	// Set all the values.
	m_strCaption = lpszCaption;
	m_nCurVal = m_nMinVal = nMinVal;
	m_nMaxVal = nMaxVal;
	m_nGaugeStyle = nStyle;
	m_nInGaugeStyle = nInStyle;
	m_bInclPercent = (bPercent) ? TRUE : FALSE;
	m_bInclScale = (bScale) ? TRUE : FALSE;
	m_bInclRange = (bRange) ? TRUE : FALSE;
	m_RGBClrBorderUp = dwClrBrdrUp;
	m_RGBClrBorderDn = dwClrBrdrDn;
	m_RGBClrFill = dwClrFill;
	m_RGBClrBk = dwClrBk;
	m_RGBClrTxt = dwClrTxt;
	
	// We need to calculate the size of the gauge window and resize it.
	CalcGaugeWndSize(this);
	this->MoveWindow(m_rcWndDim.left, m_rcWndDim.top, m_rcWndDim.Width(),
												m_rcWndDim.Height(), TRUE);
	
	return (TRUE);
}

// -------------------------------------------------------------------------
// Function			:	CGauges::SetGaugeRange()
// Arguments		:	The new minimum and maximum range values.
// Synopsis			:	Changes the minimum and maximum range values for the
// 						Gauge.
// Returns			:	True on success, FALSE on error.
// Globals Affected	:	The current progress value is RESET to the mimimum
//						range value.
// -------------------------------------------------------------------------
BOOL
CGauges::SetGaugeRange(DWORD nNewMinRange, DWORD nNewMaxRange)
{
	if (nNewMinRange >= nNewMaxRange)
		return (FALSE);

	m_nCurVal = m_nMinVal = nNewMinRange;
	m_nMaxVal = nNewMaxRange;

	// Repaint the gauge.
	Invalidate();

	return (TRUE);
}

// -------------------------------------------------------------------------
// Function			:	CGauges::UpdateProgress()
// Arguments		:	Current value for displaying on the progress gauge.
// Synopsis			:	Updates the progress gauge.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CGauges::UpdateProgress(DWORD nCurVal)
{
	if (nCurVal < m_nMinVal || nCurVal > m_nMaxVal)
		return;
		
	// If we are initialising, then invalidate so that we draw the filling
	// rect also.
	if ((m_nCurVal = nCurVal) == m_nMinVal)
		Invalidate();
	else
		DrawProgress(this);		// Call the DrawProgress() virtual function
								// to do the job.
}

// -------------------------------------------------------------------------
// Function			:	CGauges::DestroyGauge()
// Arguments		:	None.
// Synopsis			:	Destroys the gauge created previously.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CGauges::DestroyGauge(void)
{
	CWnd::DestroyWindow();
}

// -------------------------------------------------------------------------
// Function			:	CGauges::OnPaint()
// Arguments		:	None.
// Synopsis			:	Calls the function that updates the gauge.  The
// 						DoPaint() function is a pure virtual function that
// 						is defined by each of the different gauges.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CGauges::OnPaint(void)
{
	DoPaint(this);	// Call the DoPaint() virtual function to repaint the gauge
}

// -------------------------------------------------------------------------
// End of file - MSGUMAIN.CPP
// -------------------------------------------------------------------------

