// -------------------------------------------------------------------------
// Project Name			:	Standard progress gauges for MultiExpress Suite
//							programs.
// Module Name			:	Gauges main include file.
// File Name			:	MSGUMAIN.H
// Description			:	Implements the base class for the gauges used in
//							MultiExpress Suite for Windows.
// Start Date			:	19 Oct 1994
// Author				:	Srini
// Date Last Modified	:	
// Modifications		:	
// -------------------------------------------------------------------------

#ifndef		__MSGUMAIN__
#define		__MSGUMAIN__

// The different gauge styles.
#define	GU_NORMAL		1
#define	GU_DEPRESSED	2
#define	GU_ELEVATED		3

// -------------------------------------------------------------------------
// Pure virtual base class for deriving all the different gauges.
// -------------------------------------------------------------------------
class	CGauges : public CWnd {

	protected:
	
		DWORD		m_nMinVal;			// The min value for the scale
		DWORD		m_nMaxVal;			// The max value for the scale
		DWORD		m_nCurVal;			// The current value for progress display
		int			m_nGaugeStyle;		// The gauge style
		int			m_nInGaugeStyle;	// The inner gauge style
		BOOL		m_bInclPercent;		// Include percent figure ?
		BOOL		m_bInclRange;		// Display Range ?
		BOOL		m_bInclScale;		// Include scale marks
		CRect		m_rcDim;			// Coordinates of the gauge
		CRect		m_rcWndDim;			// Coordinates of the window that we created
		CString		m_strCaption;		// Caption to display
		DWORD		m_RGBClrBorderUp;	// Color of pen for border up
		DWORD		m_RGBClrBorderDn;	// Color of pen for border down
		DWORD		m_RGBClrFill;		// The color used to fill the gauge
		DWORD		m_RGBClrBk;			// The color for the gauge background
		DWORD		m_RGBClrTxt;		// The color for the caption text

	public:
	
		CGauges();
    	virtual	~CGauges();
    	
		BOOL	Create(CWnd* pParent, CRect& rcDim);
		BOOL	SetGaugeInfo(LPCSTR lpszCaption, DWORD nMinVal, DWORD nMaxVal,
								int nStyle = GU_DEPRESSED,
								int	nInStyle = GU_ELEVATED,
								BOOL bPercent = FALSE,
								BOOL bScale = TRUE,
								BOOL bRange = TRUE,
								DWORD dwClrBrdrUp = RGB(0x80, 0x80, 0x80),
								DWORD dwClrBrdrDn = RGB(0xff, 0xff, 0xff),
								DWORD dwClrFill = RGB(0x00, 0x00, 0x00),
								DWORD dwClrBk = RGB(0xc0, 0xc0, 0xc0),
								DWORD dwClrTxt = RGB(0x00, 0x00, 0x00));
		void	UpdateProgress(DWORD nCurVal);
		DWORD	GetMinRange(void)	{ return (m_nMinVal); }
		DWORD	GetCurrentProgress(void)	{ return (m_nCurVal); }
		DWORD	GetMaxRange(void)	{ return (m_nMaxVal); }
		BOOL	SetGaugeRange(DWORD nNewMinRange, DWORD nNewMaxRange);
		void	DestroyGauge(void);
		
	protected:
                           
		virtual	void	DrawProgress(CWnd* pGaugeWnd) = 0;
		virtual	void	DoPaint(CWnd* pGaugeWnd) = 0;
		virtual	void	CalcGaugeWndSize(CWnd* pGaugeWnd) = 0;
		
		afx_msg void	OnPaint();

		DECLARE_MESSAGE_MAP()
		
};

#endif		// __MSGUMAIN__

// -------------------------------------------------------------------------
// End of file - MSGUMAIN.H
// -------------------------------------------------------------------------
