// -------------------------------------------------------------------------
// Project Name                 :       MultiRouter Setup for Windows 
// File Name                    :       POWERON.CPP
// Description                  :       Defines the CPowerOn Class 
// Start Date                   :       8th May 1995
// Author                   	  :       Pravin
// Date Last Modified   		  :       
// Modifications                :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include	"locport.h"
#include "poweron.h"
#include "boot.h"
#include "check.h"
#include "reboot.h"
#include "dialdlg.h"
#include "userscom.h"
#include "usrdata.h"

#define TimerCount 4000    // Used for setting 4 Sec. timer.
#define BufSize 150
#define DefaultFile "MTROUTER.CNF"

LPCSTR  DefDnMsgHeader = "MultiRouter Setup - Default Setup";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL LookForTargetOnly ;
extern int CommandLineArgument;

/////////////////////////////////////////////////////////////////////////////
// CPowerOn dialog


CPowerOn::CPowerOn(CWnd* pParent /*=NULL*/)
	: CDialog(CPowerOn::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPowerOn)
	m_Msg1 = "";
	//}}AFX_DATA_INIT

}

void CPowerOn::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPowerOn)
	DDX_Control(pDX, IDC_STATIC_MESSAGE_1, m_Msg1Wnd);
	DDX_Text(pDX, IDC_STATIC_MESSAGE_1, m_Msg1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPowerOn, CDialog)
	//{{AFX_MSG_MAP(CPowerOn)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPowerOn message handlers

BOOL CPowerOn::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	// Open COM port for communication
	if (!cMiscDown.Open_Comm())
	{
		RouMsgBox (MSG_COM_ERR_OPEN, DefDnMsgHeader, MB_OK | MB_ICONSTOP) ;
		SendMessage (WM_CLOSE) ;
		return TRUE ;
	}

	// Dial the Router if the Dial string is present.
	if (!Connect())
	{
		RouMsgBox (MSG_COM_ERR_CONNECT, DefDnMsgHeader, MB_OK | MB_ICONSTOP) ;
		OnCancel() ;
		return FALSE ;
	}

	if (LookForTargetOnly)
	{ 
		// Actual download of configuration does not take place here
		m_Msg1Wnd.SetWindowText ("Power off and power on the Router") ;

		// Check if target is found and running
		CCheck cCheck (this) ;
		GetRouterStatus (FALSE) ;

		if (TargetFound)
		{
			if (RouterUp)
			{
			     if (firewall_upgraded)
			     {
				     if (RouMsgBox (MSG_PWN_REBT_DNLD_UPGR_STUP,
					     	 DefDnMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES) 
				     {
					     OnCancel() ;
					     return FALSE ;
				     }
			     }
			     else
			     {
				     if (RouMsgBox (MSG_PWN_REBT_DNLD_STUP,
					     	DefDnMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES)
				     {
					     OnCancel() ;
					     return FALSE ;
				     }
                  }
				RebootDnld() ;
				if (!(TargetFound && !RouterUp))
				{
					RouMsgBox (MSG_PWN_ERR_REBT,
								DefDnMsgHeader, MB_OK | MB_ICONSTOP) ;
					OnCancel() ;
					return FALSE ;
				}
			}
			// Get EtherNetAddress
			GetEthernetAddress() ;
			cMiscDown.Close_Comm() ;
			CDialog::OnOK() ;
		}
		else
		{
			m_Msg1Wnd.SetWindowText ("Power off and power on the Router") ;
			return TRUE ;  // return TRUE  unless you set the focus to a control
		}
	}
	else
	{
		// this is to download MTROUTER.CNF
		m_Msg1Wnd.SetWindowText ("Ready to Download default Setup") ;
	}
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

BOOL CPowerOn::LookString()
{
   UINT nTimerID = 31 ;
	char szBuf[BufSize] ;         // 150 char buffer
	int i = 0 ;
	char ch ;

	memset (szBuf, 0, sizeof (szBuf)) ;
	cMiscDown.TimeOut = FALSE ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 10000, NULL))
	{
      if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
						DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return FALSE ;
		}
	}
	
	// Fill the first few characters without comparison
	while ((i < 15) && (!cMiscDown.TimeOut))
	{
		ch = cMiscDown.rcv_char (&cMiscDown.TimeOut) ;
		if ((!cMiscDown.TimeOut) && (ch != 0))
			szBuf[i ++] = ch ;
	}

	// Look for the string "download" in the buffer.
	while ((strstr (szBuf, "download") == NULL) && (!cMiscDown.TimeOut))
	{
		ch = cMiscDown.rcv_char (&cMiscDown.TimeOut) ;
		if ((!cMiscDown.TimeOut) && (ch != 0))
			szBuf[i ++] = ch ;
		if (i >= (BufSize - 1))
			cMiscDown.TimeOut = TRUE ;
	}
	KillTimer (nTimerID) ;
	cMiscDown.snd_char ('d') ;	    // send char 'd' to the target.
	return (!cMiscDown.TimeOut) ;
}


void CPowerOn::GetEthernetAddress (void)
{
	// Now get and store the ether net address - used for IPX internal
	// router network
   ReadLocReqType read_req ;
   ReadLocRespType read_resp ;
	BootConfigType	ConfigHead ;

	cMiscDown.TimeOut = FALSE ;
   read_req.Address = cMiscDown.little_endian (FL_BOOT_HDR) ;
   read_req.Ptype = READ_REQ_TYPE ; // 31
   read_req.Length = sizeof (ConfigHead) ;

   UINT nTimerID = 1 ;
   while (nTimerID != SetTimer (nTimerID, (UINT) 10000, NULL))
	{
      if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
										DefDnMsgHeader, MB_RETRYCANCEL))
		{
			return ;
      }
	}

   while (1)
	{    
      cMiscDown.snd_packet ((BYTE *) &read_req, sizeof (read_req)) ;
      if (!cMiscDown.rcv_packet2 ((BYTE *) &read_resp,
						sizeof (ConfigHead) + 3, (BOOL *) &cMiscDown.TimeOut))
		{
			break ;  // No CRC Error
		}
   }

	KillTimer (nTimerID) ;
	if (!cMiscDown.TimeOut)
	{
		memcpy (&ConfigHead, read_resp.buffer, sizeof (ConfigHead)) ;
		LPSTR BytePtr, NetAddrPtr ;
		int i, upper_nibble, lower_nibble ;

		for (i = 0, BytePtr = (LPSTR) ConfigHead.EthernetAddr,
				NetAddrPtr = EtherNetAddr ; i < 6 ; i ++, BytePtr ++)
		{
			upper_nibble = (*BytePtr >> 4) & 0x0F ;
			lower_nibble = (*BytePtr)  & 0x0F ;
			if (upper_nibble >= 0 && upper_nibble <= 9)
				*NetAddrPtr++ = '0' + upper_nibble ;
			else
				*NetAddrPtr++ = 'A' + upper_nibble - 10 ;
			if (lower_nibble >= 0 && lower_nibble <= 9)
				*NetAddrPtr++ = '0' + lower_nibble ;
			else
				*NetAddrPtr++ = 'A' + lower_nibble - 10 ;
		}
		*NetAddrPtr = NULL ;		// terminate with a NULL
	}
}

void CPowerOn::OnOK()
{
	SetCapture() ;
	AfxGetApp()->LoadCursor (IDC_WAIT) ;
	AfxGetApp()->DoWaitCursor (1) ;

	if (!LookForTargetOnly)
	{
		// This is to actually download the configuration
		DnldSetup() ;
		Disconnect() ;
		AfxGetApp()->DoWaitCursor (0) ;
		ReleaseCapture() ;
		cMiscDown.Close_Comm() ;
		CDialog::OnOK() ;
		return ;
	}

	CCheck cCheck(this) ;
	// if the "download" string is found download the Configuration.
	if (LookString())
	{
		// Get EtherNetAddress
		GetEthernetAddress() ;
		Disconnect() ;
		AfxGetApp()->DoWaitCursor (0) ;
		ReleaseCapture() ;
		cMiscDown.Close_Comm() ;
		CDialog::OnOK() ;
	}
	else
	{
		AfxGetApp()->DoWaitCursor (0) ;
		ReleaseCapture() ;
		if (IDRETRY == RouMsgBox (MSG_GEN_NO_RESP_RTRY,
					DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONQUESTION))
		{
			return ;
		}
		else
		{
			cCheck.ShowWindow (FALSE) ;
			Disconnect() ;
			cMiscDown.Close_Comm() ;
			CDialog::OnCancel() ;
		}
	}
}	// end of OnOK


// -------------------------------------------------------------------------
// Function         :	CPowerOn::DnldSetup()
// Arguments        :   None.
// Synopsis         :   Return if setup is not changed.
//								If Router is up Call RebootDnld(). Call DnldCNF().
// Returns          :   None.
// Globals Affected :   TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CPowerOn::DnldSetup()
{
	int Retry = 0 ;
	ReqType brd_req_type ;
	OpenConnectionType bridge1 ;
	brd_req_type.Ptype = QUERY_BRIDGE_NAME ;			// 13

RETRY:
	cMiscDown.TimeOut = FALSE ;
   UINT nTimerID = 33 ;
   while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
      if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, DefDnMsgHeader,
												MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			goto ReturnPoint ;
		}
	}                 
	
   while (1)
   {
		cMiscDown.FlushReadBuf();
		cMiscDown.snd_packet ((BYTE *) &brd_req_type.Ptype,
														sizeof (brd_req_type)) ;
		if (!(cMiscDown.rcv_packet2 ((BYTE *) &bridge1,
							sizeof (bridge1), (BOOL *) &cMiscDown.TimeOut)))
		{
			break ;   // No CRC error
		}
   }

   KillTimer (nTimerID) ;
   if (cMiscDown.TimeOut)
	{
		if (Retry < 2)
		{
			Retry ++ ;
			goto RETRY ;
		}
		RouMsgBox (MSG_GEN_NO_ROUTER,
					DefDnMsgHeader, MB_OK | MB_ICONINFORMATION) ;
		goto ReturnPoint ;
	}

	if (bridge1.Ptype == RES_TYPE)			// 12
	{
		BYTE *incor ;
		WORD pra ;
		incor = (BYTE *) &pra ;
		incor[0] = bridge1.BrdName[1] ;
		incor[1] = bridge1.BrdName[2] ;
		pra = cMiscDown.ltl_endian_word (pra) ;
		switch (pra)
		{
			case ERR_NO_BRD_GET_PASSWORD :			// 18  
				PasswordPktType passwd_pkt ;
				ResultType restype ;
						
				passwd_pkt.Ptype = (BYTE) PASSWD_TYPE ;		// 30
				passwd_pkt.Password[0] = (BYTE) 'x' ;
				passwd_pkt.Password[1] = (BYTE) '\0' ;
		
				cMiscDown.FlushReadBuf() ;
				cMiscDown.TimeOut = FALSE ;
				nTimerID = 34 ;
				while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
				{
					if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
								DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
					{
						goto ReturnPoint ;
					}
				}
				cMiscDown.snd_packet ((BYTE *) &passwd_pkt,
															sizeof (passwd_pkt)) ;
				cMiscDown.rcv_packet2 ((BYTE *) &restype,
								sizeof (restype), (BOOL *) &cMiscDown.TimeOut) ;
				KillTimer (nTimerID) ;
				if (cMiscDown.TimeOut)
				{
					RouMsgBox (MSG_GEN_NO_PWRD_RESP,
							DefDnMsgHeader, MB_OK | MB_ICONINFORMATION) ;
				} 
				else
				{
					if (restype.Ptype == ERR_PASSWORD)
					{		// 13
						RouMsgBox (MSG_GEN_ERR_PWRD_RESP, 
									DefDnMsgHeader,MB_OK | MB_ICONINFORMATION) ;
					} 
					else 
						DnldCNF() ;
				}       
				break ;

			case ERR_NO_BRD_NO_PASSWORD :			// 19
				DnldCNF() ;
				break ;

			case ERR_ROUTER_UP :
			  	RouMsgBox (MSG_GEN_ROUTER_IS_UP, DefDnMsgHeader, MB_OK) ;
	       	break ;

			default :
				break ;
		}       
	}
	else
	{
		if (Retry < 1)
		{
			Retry ++ ;
			goto RETRY ;
		}
		RouMsgBox (MSG_GEN_UNKNOWN_PKT,
					DefDnMsgHeader, MB_OK | MB_ICONINFORMATION) ;
	}
ReturnPoint :
	cMiscDown.Close_Comm() ;			// We must do this here
}				// End of DnldSetup

// -------------------------------------------------------------------------
// Function         :	CPowerOn::DnldCNF()
// Arguments        :   None.
// Synopsis         :   Download the setup. Call Reboot(), if downloaded 
//								successfully.
// Returns          :   None.
// Globals Affected :   status(status of Windows INI after closing it).
// -------------------------------------------------------------------------
void CPowerOn::DnldCNF()
{
	TargetCmdType cmd_type ;
	ResultType restype ;
			
	DnldUDBDefault();

	cMiscDown.TimeOut = FALSE ;
	UINT nTimerID = 35 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;                 
		}
	}
								
	cmd_type.Ptype = (BYTE) TRGT_CMD_TYPE ;
	cmd_type.TargetAction = (BYTE) DN_LD_CNF ;	  // 3
	cMiscDown.CODE_CRC = 0xFFFF ;
	cMiscDown.ComprCodeSize = 0 ;

	cMiscDown.FlushReadBuf() ;
	cMiscDown.snd_packet ((BYTE *) &cmd_type, sizeof (cmd_type)) ;
	cMiscDown.rcv_packet2 ((BYTE *) &restype,
					sizeof (restype), (BOOL *) &cMiscDown.TimeOut) ;
	
	KillTimer (nTimerID) ;
	if (cMiscDown.TimeOut) 
	{
		RouMsgBox (MSG_GEN_NO_RESP, DefDnMsgHeader, MB_OK | MB_ICONINFORMATION) ;
	} 
	else 
	{
		dnld_head_type dnld_header ;  // Sent
		DnLdPktHdrType hdr_type ;		// For response
		
		dnld_header.headtype.DnLdAddress = FL_SYSTEM_CFG ;
		dnld_header.headtype.MagicNum = (WORD) MAGIC_NUM ;
		dnld_header.headtype.StartAddr = 0 ;
		dnld_header.headtype.LoadAddr = 0 ;
		
		dnld_header.headtype.MagicNum =
			cMiscDown.ltl_endian_word (dnld_header.headtype.MagicNum) ;
		dnld_header.headtype.LoadAddr =
			cMiscDown.little_endian (dnld_header.headtype.LoadAddr) ;
		dnld_header.headtype.StartAddr =
			cMiscDown.little_endian (dnld_header.headtype.StartAddr) ;
		dnld_header.headtype.DnLdAddress =
				cMiscDown.little_endian (dnld_header.headtype.DnLdAddress); 
		strcpy ((char *) dnld_header.headtype.Version, "v0.99") ;

		cMiscDown.SetDateStamp() ;
		strcpy ((char *) dnld_header.headtype.DateStamp, cMiscDown.DateStamp) ;
		strcpy ((char *) dnld_header.headtype.Dmy, "") ;
		memset (dnld_header.headtype.Reserved , 0,
							sizeof (dnld_header.headtype.Reserved)) ;

		dnld_header.hdr.PacketType = PT_HEADER ;	 // 1
		dnld_header.hdr.SeqNum = (BYTE) 0 ;

		hdr_type.PacketType = PT_UNKNOWN ;          // 0

		cMiscDown.TimeOut = FALSE ;
		nTimerID = 36 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
						DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;
			}
		}

		cMiscDown.ABORT = FALSE ;
		int no_of_Abort = 0 ;
		while ((hdr_type.PacketType != PT_ACK) && !cMiscDown.ABORT)
		{   // 6
			cMiscDown.FlushReadBuf() ;
			cMiscDown.snd_dnld_packet ((BYTE *) &dnld_header,
															sizeof (dnld_header)) ;
			if (cMiscDown.rcv_dnld_packet2 ((BYTE *) &hdr_type,
							sizeof (hdr_type), (BOOL *) &cMiscDown.TimeOut))
			{
				continue ;   // CRC error
			}

			if (!cMiscDown.TimeOut)
			{
				switch (hdr_type.PacketType)
				{
					case PT_ABORT :		// 3 
						if (no_of_Abort == 1)
						{
							RouMsgBox (MSG_COM_ROUTER_ABORT,
								DefDnMsgHeader, MB_OK | MB_ICONINFORMATION) ;
							cMiscDown.ABORT = TRUE ;
						}
						no_of_Abort ++ ;
						break ;

					default :
						break ;
				}
			}
		}

		KillTimer (nTimerID) ;
		if (cMiscDown.ABORT)
			return ;

		// Send the configuration file.
		cMiscDown.TimeOut = FALSE ;
		nTimerID = 37 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;
         }
      }

		CString SetupFileName ;
		SetupFileName = IniInRtrWareFormDef;
		cMiscDown.cnf_dnld ((BOOL *) &cMiscDown.TimeOut, SetupFileName, TRUE) ;
		KillTimer (nTimerID) ;

		if (!cMiscDown.ABORT)
		{
			cMiscDown.FlushReadBuf() ;	 // Flush the receive buffer
			cMiscDown.snd_eof_packet ((BOOL *) &cMiscDown.TimeOut, TRUE) ;

         if (CommandLineArgument != 6)	 // Reboot the target
				Reboot() ; 
		}       
	}
}	// end of DnldCNF


void CPowerOn::OnTimer (UINT nIDEvent)
{
	KillTimer (nIDEvent) ;
	cMiscDown.TimeOut = TRUE ;
	CDialog::OnTimer (nIDEvent) ;
}


// --------------------------------------------------------------------------
//	Function	:	GetRouterStatus
//	This routine will check for the router and set TargetFound and RouterUp
//	variables
// --------------------------------------------------------------------------
void CPowerOn::GetRouterStatus (BOOL ShowCheckDlg)
{
	ReqType brd_req_type ;
   OpenConnectionType bridge1 ;
	if (ShowCheckDlg)
		CCheck cCheck (this) ;
	   
	brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
	cMiscDown.TimeOut = FALSE ;
	TargetFound = RouterUp = FALSE ;

	UINT nTimerID = 15 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;
    	}
	}

	while (1)
	{
		cMiscDown.snd_packet ((BYTE *) &brd_req_type.Ptype,
													sizeof (brd_req_type)) ;
		if (!cMiscDown.rcv_packet2 ((BYTE *) &bridge1,
				sizeof (bridge1), (BOOL *) &cMiscDown.TimeOut))
		{
			break ;   // No CRC error
		}
	}
 
   KillTimer (nTimerID) ;
	TargetFound = !cMiscDown.TimeOut ;
 
	if (TargetFound)
	{
		if (bridge1.Ptype == RES_TYPE)		// 12
		{
			BYTE *incor ;
			WORD pra ;
			incor = (BYTE *) &pra ;
			incor[0] = bridge1.BrdName[1] ;
			incor[1] = bridge1.BrdName[2] ;
			pra = cMiscDown.ltl_endian_word (pra) ;
			switch (pra)
			{
				case ERR_ROUTER_UP :  // Router is Up
					RouterUp = TRUE ;  // Router is running and you can't Download
					break ;
                                                           
				default :
					break ;
			}
		}
	}
}


// -------------------------------------------------------------------------
// Function         :       CPowerOn::RebootDnld()
// Arguments        :       None.
// Synopsis         :       Brings Router down so that it waits for download
//									 and updates its status.
// Returns          :       None.
// Globals Affected :       TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CPowerOn::RebootDnld()
{
   int retries;               
	RebootType rebootpkt ;
	rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;		// 22
	rebootpkt.BootType = COLD_BOOT_MODE ;     // Reboot to Download Code

	cMiscDown.FlushReadBuf() ;	 // Flush the receive buffer
	cMiscDown.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;
	
	TargetFound = FALSE ;
	RouterUp = FALSE ;
	CReboot cReboot (this) ;
	AfxGetApp()->LoadCursor (IDC_WAIT) ;
	AfxGetApp()->DoWaitCursor (1) ;

	CCheck cCheck (this) ;

   if (CommandLineArgument == 6)
           retries = 5;
   else
           retries = 20;
	
	for (int k = 0 ; (k < retries && !TargetFound) ; k ++)
		GetRouterStatus (FALSE) ;

	cReboot.DestroyWindow() ;
	AfxGetApp()->DoWaitCursor (0) ;
	cMiscDown.FlushReadBuf() ;	    // Flush the receive buffer
}  //	END OF   RebootDnld



void CPowerOn::Reboot()
{
   CReboot cReboot (this) ;

	RebootType rebootpkt ;
	BOOL RouterUp ;

	rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;		//  22
	rebootpkt.BootType = 1 ;			         // System Reboot

	UINT nTimerID = 20 ;
	cMiscDown.TimeOut = FALSE ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 3000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
				DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
		   cReboot.DestroyWindow() ;
			return ;
		}
	}

   while (!cMiscDown.TimeOut)		// Delay (3 seconds)
	{
		MSG msg ;
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
		}
	}

	cMiscDown.FlushReadBuf() ;		// Flush the receive buffer
	cMiscDown.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;

	nTimerID = 20 ;
	cMiscDown.TimeOut = FALSE ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 20000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
				DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
		   cReboot.DestroyWindow() ;
			return ;
		}
	}

   while (!cMiscDown.TimeOut)		// Delay (20 seconds)
	{
		MSG msg ;
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
		}
	}
	cMiscDown.FlushReadBuf() ;		// Flush the receive buffer

   RouterUp = FALSE ;
   for (int k = 0 ; (k < 20 && !RouterUp) ; k ++)
   {
		ReqType brd_req_type ;
	  	OpenConnectionType bridge1 ;
	  
		brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
		cMiscDown.TimeOut = FALSE ;
		RouterUp = FALSE ;
		UINT nTimerID = 14 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				cReboot.DestroyWindow() ;
				return ;
			}
		}

		while (1)
		{
			cMiscDown.FlushReadBuf() ;		// Flush the receive buffer
			cMiscDown.snd_packet ((BYTE *) &brd_req_type.Ptype,
																sizeof (brd_req_type)) ;
			if (!cMiscDown.rcv_packet2 ((BYTE *) &bridge1,
							sizeof (bridge1), (BOOL *) &cMiscDown.TimeOut))
			{
				break ;	// No CRC error
			}
		}
    
  	  	KillTimer (nTimerID) ;
	   if (!cMiscDown.TimeOut)
		{
			if (bridge1.Ptype == RES_TYPE)			// 12
			{
	     		BYTE *incor ;
				WORD pra ;
				incor = (BYTE *) &pra ;
				incor[0] = bridge1.BrdName[1] ;
				incor[1] = bridge1.BrdName[2] ;
				pra = cMiscDown.ltl_endian_word (pra) ;
				switch (pra)
				{
					case ERR_ROUTER_UP :       // RouterUp
						RouterUp = TRUE ; // Router is running and you can't Download
						break ;

					default :
						break ;
				}       
		  	}
		}
	}
   cReboot.DestroyWindow() ;
}	// end of Reboot

void CPowerOn::OnCancel()
{
	Disconnect();
	cMiscDown.Close_Comm();

	CDialog::OnCancel();
}


BOOL CPowerOn::Connect()
{
	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
			(LPCSTR) DialString, (LPCSTR) "ATDP", (LPSTR) szBuf,
					sizeof(szBuf),	(LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;

	if (m_DialString.IsEmpty() || cMiscDown.IsDCDPresent())
		return TRUE ;

	CDialDlg cDialDlg (this) ;

	// Dial the Router.
	UINT nTimerID = 2 ;
	{
		char mdm_init_string[50] ;
		char mdm_resp[30] ;
		
		char *tmp ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader, 
			(LPCSTR) InitString, (LPCSTR) "ATS0=1&E5", (LPSTR) szBuf,
				sizeof(szBuf), (LPCSTR) OwnIniFile) ;
		m_InitString = szBuf ;

		m_InitString += "^M" ;
		tmp = m_InitString.GetBuffer (50) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_init_string, (BYTE *)tmp) ;
		m_InitString.ReleaseBuffer() ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) InitRespString, (LPCSTR) "OK", (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_InitResponse = szBuf ;
		tmp = m_InitResponse.GetBuffer (30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_resp, (BYTE *) tmp) ;
		m_InitResponse.ReleaseBuffer() ;

		cMiscDown.TimeOut = FALSE ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
											DefDnMsgHeader, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// send modem init string and wait for response
		cMiscDown.snd_mdm_command ((BYTE *) mdm_init_string,
														strlen (mdm_init_string)) ;
		if (!cMiscDown.rcv_mdm_response ((BYTE *) mdm_resp, 
														(BOOL *) &cMiscDown.TimeOut))
		{
			// timeout occured and no response
			KillTimer (nTimerID) ;
			RouMsgBox (MSG_PWN_NO_MDM_RESP,
							DefDnMsgHeader, MB_OK | MB_ICONSTOP) ;
			SendMessage (WM_CLOSE) ;
			goto Error_Exit ;
		}
		KillTimer (nTimerID) ;
	}
	
	// Modem initialized successfully now send the dial string.
	{	
		char mdm_dial_string[30] ;
		char mdm_connect_resp[30] ;
		char *tmp ;

		m_DialString += "^M" ;
		tmp = m_DialString.GetBuffer (30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_dial_string, (BYTE *) tmp) ;
		m_DialString.ReleaseBuffer() ;

   	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) ConnectString, (LPCSTR) "CONNECT",
					(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_ConnectResponse = szBuf ;
		tmp = m_ConnectResponse.GetBuffer (30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_connect_resp, (BYTE *) tmp) ;
		m_ConnectResponse.ReleaseBuffer() ;

		cMiscDown.TimeOut = FALSE ;
		nTimerID = 3 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 45000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, 
											DefDnMsgHeader, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// Send the dial string and wait for connect response.
		cMiscDown.snd_mdm_command ((BYTE *) mdm_dial_string,
														strlen (mdm_dial_string)) ;
		if (!cMiscDown.rcv_mdm_response ((BYTE *) mdm_connect_resp, 
															(BOOL *) &cMiscDown.TimeOut))
		{
			KillTimer (nTimerID) ;
			UINT nTimerID = 4 ;
			cMiscDown.TimeOut = FALSE ;
			char mdm_hangup[2] ;

			while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
			{
				if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, 
											DefDnMsgHeader, MB_RETRYCANCEL))
				{
					SendMessage (WM_CLOSE) ;
					goto Error_Exit ;
				}
			}

			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0 ;
			cMiscDown.hangup_mdm (mdm_hangup, (BOOL *) &cMiscDown.TimeOut) ;
			KillTimer (nTimerID) ;
		}       
		else
		{
			KillTimer (nTimerID) ;
			cDialDlg.DestroyWindow() ;
			return TRUE ;
		}
	}
Error_Exit:
	cDialDlg.DestroyWindow() ;
	return FALSE ;
}	// End of Connect

void CPowerOn::Disconnect()
{
	ShowWindow(FALSE);
	char 	szBuf[50];
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse;

	GetPrivateProfileString(LPortSectionHeader, DialString,
			(LPCSTR) "ATDP",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile) ;
	m_DialString = szBuf;

	if (m_DialString.IsEmpty())
		return;
	if (cMiscDown.IsDCDPresent())
		if (RouMsgBox(MSG_GEN_ASK_HUP, DefDnMsgHeader, MB_YESNO
					| MB_DEFBUTTON1 | MB_ICONQUESTION) != IDYES)
		return;

	UINT nTimerID = 4;
	cMiscDown.TimeOut = FALSE;
	char mdm_hangup[2];

	while(nTimerID != SetTimer(nTimerID,(UINT)2000,NULL))
		if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER,DefDnMsgHeader,MB_RETRYCANCEL)) {
			return;
		}

	mdm_hangup[0] = 0x1b ;
	mdm_hangup[1] = 0;
	cMiscDown.hangup_mdm(mdm_hangup, (BOOL *) &cMiscDown.TimeOut);
	KillTimer(nTimerID);
}	//End of Disconnect


int	CPowerOn::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}


//Added by Ravi
void 
CPowerOn::DnldUDBDefault()
{
	WriteLocReqType  UDBWriteReqType;
	ResultType       UDBResultType;
	HEADER_TYPE UDBHeader;

	memset(&UDBHeader, 0, sizeof(UDBHeader));
	strcpy(UDBHeader.version, VERSION2);
	UDBHeader.magic_number = 0xABCD;
	UDBHeader.magic_number = cMiscDown.ltl_endian_word (UDBHeader.magic_number);
	UDBHeader.down_load_address = cMiscDown.little_endian((DWORD) UDB_DNLD_ADDR);

	strcpy((LPSTR)UDBHeader.reserved, "USERDEFAULT"); // Default
	strcpy((LPSTR)UDBHeader.Description, "USER DATABASE");

	for (int i=0; i < sizeof(UDBHeader); i += sizeof(UDBWriteReqType.Buffer))
 	{
		UDBWriteReqType.Length = 
		(sizeof(UDBHeader) - i) > sizeof(UDBWriteReqType.Buffer) ? 
				sizeof(UDBWriteReqType.Buffer) : (sizeof(UDBHeader) - i);

		memcpy(UDBWriteReqType.Buffer, (BYTE *) &UDBHeader + i, UDBWriteReqType.Length);
  		
		UDBWriteReqType.Length = cMiscDown.ltl_endian_word(UDBWriteReqType.Length);

		UDBWriteReqType.Address = cMiscDown.little_endian(UDB_HEADER_START + i);

		UDBWriteReqType.Ptype = WRITE_REQ_TYPE;

		cMiscDown.TimeOut = FALSE ;

		UINT nTimerID = 35 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
						DefDnMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;                 
			}
		}

		cMiscDown.FlushReadBuf() ;
		cMiscDown.snd_packet ((BYTE *) &UDBWriteReqType, sizeof (UDBWriteReqType)) ;
		cMiscDown.rcv_packet2 ((BYTE *) &UDBResultType,
					sizeof (UDBResultType), (BOOL *) &cMiscDown.TimeOut);

		KillTimer (nTimerID) ;

		if (cMiscDown.TimeOut) 
		{
			RouMsgBox (MSG_GEN_NO_RESP, DefDnMsgHeader, MB_OK | MB_ICONINFORMATION);
			break;
		} 
 	}
	return ;
}
