// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	ROUCON.CPP
// Description       :	Defines the class behaviors for the application.
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :  Vidy 20/10/95
//								Vidy 7/11/95	added LSL and PPP dependency of WAN
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "ctl3d.h"
#include "maindlg.h"
#include "mainfrm.h"
#include "roudoc.h"
#include "rouvw.h"
#include "poweron.h"
#include "wandefs.h"
#include "powercod.h"
#include "tftpread.h"
#include "tftpwrit.h"		// name was longer than 8.3 format. win95 wont work
#include "boot.h"
#include "usersdlg.h"
#include "userdlg.h"//Neelu
#include "compress.h"
#include "userscom.h"
//#include "userdata.h"
#include "bootvers.h"
#include "tftpdnld.h"
#include "ipconfig.h"
#include "ipdnld.h"
#include "ipprx.h"
#include "dhcpk.h"
#include "upgrade.h"
#include "ipdetect.h"  //Neelu on 03-02-99
#include "autodete.h"  //Neelu on 03-02-99
#include "tftpif.h"    //Neelu on 03-02-99
#include "dot.h"       //Neelu on 03-02-99
#include "userlog.h"   //Neelu on 19-04-99
#include "userfilt.h"	// Added by Sreelu For User Filter Tab
#include "usrdata.h"	
// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------
// #define PollingTimerID 420	//Vidy removed the redefinition
#define PollingInterval 55	//55mSec timer for polling

#define CodeTimerID	840
#define CodeInterval 65000   // 65 Sec. timer for downloading code.

// #define Max_exitcount 0xff00 //Comeout if packet is not expected.

#define MaxINIString 150   // Maximum length of string in the CNF File.
#define MAX_SECTION_LIST 20    //used for UPGRADE PROXY
#define TimerCount 4000    //Used for setting 4 Sec. timer.

//Neelu 0n 03-2-99
#define AutoDetectTimerCount 5000    //Used for setting 4 Sec. timer.
#define AUTODETECT_TIMER	0xfe11
#define WAIT_FOR_BOOT_TIMER	0xfe12
#define MAX_UDP_RESPONSE_TIMER 10000  // Neelu taken fm Jo timer for 10 secs.
//Neelu ported fm Jo on 03-02-99

#define  MTR_SETUP   "Router Setup"

/* brindha on 17/8/99. from Big Proxy. */
int boot_upgraded = 0; 
int firewall_upgraded =0;
char BootVerString[20] ;

char FileName[FILE_NAME_SIZE];          // Used for UPGRADE PROXY
char LoadPath[FILE_NAME_SIZE] ;				// directory pathname of executable file
char OwnIniFile[FILE_NAME_SIZE] ;			// configuration ini file "SETUP.INI"
char IniInWinForm[FILE_NAME_SIZE] ;			// Router ini file in windows form
char IniInRtrWareForm[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char NewIniInWinForm[FILE_NAME_SIZE];  // New Router ini file in windows form "MTROUTER.INI"
char IniInRtrWareFormDef[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char IniInTempDef[FILE_NAME_SIZE]; // Router ini file in RouterWare form "TEMP.CNF"
char UDBCompressedDBaseFile[FILE_NAME_SIZE] ;    // Compressed User DBase File
char UDBUnCompressedDBaseFile[FILE_NAME_SIZE] ; //  Uncompressed User DBase File
char UserDataFile[FILE_NAME_SIZE]; //Neelu for Event broadcast
char LogFileName[FILE_NAME_SIZE];  // Imran 22.3.99
char UserEventBdcastFile[FILE_NAME_SIZE]; // Imran 22.3.99 

/* brindha on 17/8/99. from Big Proxy. */
char BootUpgrBinFile[FILE_NAME_SIZE] ;	// Boot Upgraded Bin file 
char B16BitBinFile[FILE_NAME_SIZE] ;	// Boot Upgraded Bin file 
char FirmwareBinFile[FILE_NAME_SIZE] ;	// Firmware Bin File

char EtherNetAddr[13] ;			// ethernet address - printable string
BOOL LookForTargetOnly ;
BOOL DownloadSetupOnly ;
BOOL DefaultSetup = FALSE; /* Neelu 05/02/99 */
BOOL ModifyIPAddress = FALSE ; /* Neelu 05/02/99 */
CString MessageString ;
CString WindowText ;

LPCSTR StrEnabled = "enabled" ;
LPCSTR StrDisabled = "disabled" ;
LPCSTR StrNull = "" ;
LPCSTR StrNotFound = "String Not Found";

extern LPCSTR MainMsgHeader ;

BOOL DontReadConfiguration = FALSE ;
int CommandLineArgument = 0 ;

BOOL IsPortIP = FALSE ;		// is true if we are going to use TFTP
char TFTPPutLocalFileName[FILE_NAME_SIZE] ;
char TFTPPutRemoteFileName[TFTP_NAME_SIZE] ;
char TFTPGetLocalFileName[FILE_NAME_SIZE] ;
char TFTPGetRemoteFileName[TFTP_NAME_SIZE] ;

UINT NumberOfPorts = 2 ; // Just in case no assignment takes place

/* 9/7/97 chetan */
BOOL IsLanTalker = FALSE ;
BOOL IsRF200 = FALSE ;
/* 9/7/97 chetan */


#ifdef NEW_BOOT_2
DWORD CodeLoadAddress ;
DWORD CodeStartAddress ;
DWORD FlCodeStartAddress ;

char *DialogTitleFormat = "%s - %s";

TFTPCodeBurnStruct TFTPCodeAddressDetails ;
#endif /* NEW_BOOT_2 */



#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// If these sizes are changed same changes
// should be carried out in \roucon\tftp\tftpcomp.c
// and in mtrouter.bin
#define MAX_READ_SIZE (8 * 1024) 
#define MAX_UNCOMP_SIZE (10 * 1024)

/* Neelu ported fm Jo on 03-02-99 */
extern DetectSuccess ;
CDotDecimal dotdecimal_configured_ip_address ;
/* Neelu ported fm Jo on 03-02-99*/

/////////////////////////////////////////////////////////////////////////////
// CRouconApp

BEGIN_MESSAGE_MAP(CRouconApp, CWinApp)
	//{{AFX_MSG_MAP(CRouconApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRouconApp construction

CRouconApp::CRouconApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

int	CRouconApp::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	HWND	WindowWithFocus;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	WindowWithFocus = GetFocus();

	Ret_val = AfxGetMainWnd()->MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);

	SetFocus(WindowWithFocus);

	return Ret_val;

}


// vidy added this 19th Aug 95
void	RouconCrossCheckPPP(void)		
{
	int	port, number_of_enabled_wan_ports;
	char	PPPAsyncStr[80];
	char	WANAsyncStr[80];
	char	szBuf[30];
	char	WANPortStr[80], LSLPortStr[80], PPPPortStr[80];
	
	strcpy(PPPAsyncStr, "PPP Port0 Asynchronous Link");
	strcpy(WANAsyncStr, "WAN Port0 ASYNC");

	for (port = 0; port < 3; port++) {
		// make string for the proper port number
		PPPAsyncStr[8] = '0' + port;
		WANAsyncStr[8] = '0' + port;
		// read the port WAN async type
		GetPrivateProfileString(WANSectionHeader,
			(LPCSTR) WANAsyncStr, StrNull,(LPSTR) szBuf ,sizeof(szBuf),
			(LPCSTR) IniInWinForm);
		if (szBuf[0]) {
			WritePrivateProfileString(PPPSectionHeader, 
				(LPCSTR) PPPAsyncStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
		}
	}

	/* we need to update the LSL section and PPP section setup
	based on the WAN port setup, for number of ports and their
	enabled/disabled state, this is for SNMP to report correctly
	7.11.95*/

	strcpy(WANPortStr, "WAN Port0");
	strcpy(LSLPortStr, "LSL Port1");	//LSL port 0 is Ethernet
	strcpy(PPPPortStr, "PPP Port0");
	number_of_enabled_wan_ports = 0;

	for (port = 0; port < 3; port++) {
		// make string for the proper port number
		WANPortStr[8] = '0' + port;
		LSLPortStr[8] = '1' + port;	//LSL port 0 is Ethernet
		PPPPortStr[8] = '0' + port;
		// read the port WAN async type
		GetPrivateProfileString(WANSectionHeader,
			(LPCSTR) WANPortStr, StrNull,(LPSTR) szBuf ,sizeof(szBuf),
			(LPCSTR) IniInWinForm);
		if (szBuf[0]) {
			WritePrivateProfileString(LSLSectionHeader, 
				(LPCSTR) LSLPortStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, 
				(LPCSTR) PPPPortStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
		}
		if ( !strcmp(szBuf, StrEnabled))
			number_of_enabled_wan_ports++;
	}
}

// -------------------------------------------------------------------------
// Function 			:	CRouconApp::RAWriteRouterINI()
// Arguments			:  None.
// Synopsis 			:  Converts Windows INI to MTRouter CNF, only if the Windows 
//                  		INI is changed after Reading.
// Returns  			:  TRUE if it is changed, else FALSE.
// Globals Affected  :  None.
// -------------------------------------------------------------------------
BOOL CRouconApp::RAWriteRouterINI()
{
   char* pInFileName; 
#if 0
   if (CommandLineArgument == 6)	   // Added by Sreelu for Upgrade
           pInFileName = NewIniInWinForm ;
   else
           pInFileName = IniInWinForm ;
#endif

   pInFileName = IniInWinForm ;  // Converting Roucon.ini to Mtrouter.cnf
 	CStdioFile input;
   if(!input.Open( pInFileName, CFile::modeRead | CFile::typeText ))
   {
		DoMessageBox("Could not open `ROUCON.INI'", MB_OK, 0);
      return(FALSE);
   }

	char* pOutFileName = IniInRtrWareFormDef;
	CStdioFile  output;
// Added by Sreelu for Upgrade...
	if(CommandLineArgument == 6)
	{
// Copy Mtrouter.cnf to a temp file
		remove(IniInTempDef);
		rename(IniInRtrWareFormDef,IniInTempDef);
	}
	remove(IniInRtrWareFormDef);
//... Added by Sreelu for Upgrade
	  //VIDY changed from TXT to BIN
	if(!output.Open( pOutFileName, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary ))
	{
		DoMessageBox("Could not open `MTROUTER.CNF'", MB_OK, 0);
      return(FALSE);
 	}
	char* pRtrCnf = IniInRtrWareForm;
	CStdioFile output_rtrcnf( pRtrCnf, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );

	char sBuf[MaxINIString];
	char *ch, *ptr;
	char pBuf[MaxINIString];

	while((input.ReadString(sBuf , MaxINIString)) != NULL)
	{
		// PINTO 28/1/97
		// There must not be any "0d"s in the sBuf by now
		while (ptr = strchr (sBuf, '\r'))
		{
			strcpy (ptr, ptr + 1) ;
		}
		// To remove blank lines
		if (sBuf[0] == '\n')
			continue ;
		// PINTO 28/1/97

		if((ch = strchr(sBuf,(int) '[')) != NULL) //Check for section header
		{
			*ch = '\0';
			strcpy(pBuf,sBuf);
			strcat(pBuf,"[[ ");
			strcpy(sBuf,++ch);
			if((ch = strchr(sBuf,(int) ']')) != NULL)
			{
				*ch = '\0' ;
				strcat(pBuf,sBuf);
				strcat(pBuf," = Section Start ]]");     //Change the section header
				strcat(pBuf,++ch);
				strcpy(sBuf, pBuf);
			}
			else
			{
				strcat(pBuf,sBuf);
				strcpy(sBuf,pBuf);      
			}
		}                      
		else
		{
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp("PPP Port? Option%*",sBuf) ||
							!wildstrcmp("PPP Port? Remote Option%*",sBuf)) {
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}

                       	// Changes by Vidy for Static Host and Static Net routes
			// Since there can be multiple Static Host routes we addedd
			// '$?' where ?=A,B,... to the beginning of some lines
			// it is now time to remove these
			if ( !wildstrcmp(sBuf, "$? *")) {
				strcpy(pBuf, (LPCSTR)&sBuf[3]);
				strcpy(sBuf, pBuf);
			}
			//Prabha, 25/2/98, for NAT entries, as there are multiple entries
			//beginning with $%c%d, they've to be taken care of
			int prefix_num = 2;
			if ( !wildstrcmp(sBuf, "$?*")) 
			{
				while ((sBuf[prefix_num] >= '0') && (sBuf[prefix_num] <= '9'))	
					prefix_num++;
				strcpy(pBuf, (LPCSTR)&sBuf[prefix_num]);
				strcpy(sBuf, pBuf);
			}
			
			
                        
         if((ch = strstr(sBuf,"Port")) != NULL)
			{
				ch += 4;		//Look after "Port"
				int c = *ch;
				if((c >= 0x30) && (c <= 0x39))	//Check for digit.
				{
					*ch = '\0' ;                  
					strcpy(pBuf, sBuf);
					int c2 = *(++ch);
					BOOL flag = FALSE;
					if((c2 >= 0x30) && (c2 <= 0x39))	//Check for digit.
					{
						ch++;
						flag = TRUE ;
					}       
					strcpy(sBuf,ch);        
					if((ch = strchr(sBuf, (int) '=')) != NULL)
					{
						*ch = '\0' ;
						strcat(pBuf, sBuf);
						strcat(pBuf, "=");
						char temp[4];
						temp[0] = flag ? c  : '0';
						temp[1] = flag ? c2 :  c;
						temp[2] = ',';
						temp[3] = '\0' ;
						strcat(pBuf, temp);
						strcat(pBuf, ++ch);
						strcpy(sBuf, pBuf);
					}       
				}
			}       

                        
// Added by Sreelu ....
// DHCP vvvvv
			   if((ch = strstr(sBuf, "DHCP Tag")) != NULL)
				{
					char *sptr;
					int TagNumber;
					char LHS[40], RHS[MAX_INI_OPTN * 3];

					if (*sBuf == '$')
						sptr = sBuf+3;
					else
						sptr = sBuf;

					sscanf(sptr, "DHCP Tag%2d %[^=]=%[^\0]", &TagNumber, LHS, RHS);
					sprintf(sBuf, "DHCP Tag %s=%02d,%s", LHS, TagNumber, RHS);
				}
//DHCP ^^^^

//Proxy Server Application List vvvv
		   if((ch = strstr(sBuf, "Proxy Server Application List")) != NULL)
			{
		  		char *sptr;
		  		char RHS[MAX_INI_OPTN * 3];

		  		if (*sBuf == '$')
		  			sptr = sBuf+3;
		  		else
		  			sptr = sBuf;

		  		sscanf(sptr, "Proxy Server Application List%[^\0]", RHS);
		  		sprintf(sBuf, "Proxy Server Application List%s", RHS);
			}				

//Proxy Server Application List ^^^^

//... Added by Sreelu

		// Put " = " inplace of "="
			if((ch = strchr(sBuf,(int) '=')) != NULL)
			{
				*ch = '\0';
				strcpy(pBuf, sBuf);
				strcat(pBuf, " = ");
				strcat(pBuf, ++ch);
				strcpy(sBuf, pBuf);
			}
		}
		output.WriteString(sBuf);               
		output_rtrcnf.WriteString(sBuf);               
	}
	output.Write("\0\0", 2);
	output_rtrcnf.Write("\0\0", 2);
	return (TRUE);
}       //End of WriteRouterINI

// -------------------------------------------------------------------------
// Function        :       CRouconApp::WriteWinINI()
// Arguments       :       None.
// Synopsis        :       Converts Router CNF to Windows INI.
// Returns         :       None.
// -------------------------------------------------------------------------
BOOL CRouconApp::RAWriteWinINI()
{
	char *pInFileName = IniInRtrWareFormDef ;
	char Buf[80];
	int PropertyTagUID[MAX_NUM_ADDR_RANGES];
	int BindingTagUID[MAX_NUM_ADDR_RANGES];

	CStdioFile input ;
	if (!input.Open (pInFileName, CFile::modeRead | CFile::typeText ))
	{
		DoMessageBox ("Could not open File : MTROUTER.CNF", MB_OK, 0) ;
		return FALSE ;
	}
									   
	char *pOutFileName ;
   if (CommandLineArgument == 6)	   /* Added by Sreelu for Upgrade */    								   
           pOutFileName = NewIniInWinForm ;
   else
           pOutFileName = IniInWinForm ;

/*	CStdioFile output (pOutFileName, CFile::modeCreate | CFile::modeWrite 
											| CFile::typeText ) ;*/

	CStdioFile output;
	if ( !output.Open(pOutFileName, CFile::modeCreate | CFile::modeWrite 
											| CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pOutFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char sBuf[MaxINIString] ;
	char *ch ;
	char *pBuf = new char[MaxINIString] ;
        
        //Neelu Added for NAT
	
	char ProxyAppIndex[5] ;
	char ProxyAppInfoIndex[5];
        
        
	char gl_alphabet = 65, dy_alphabet = 65;
	char st_alphabet = 65, pr_alphabet1 = 65, pr_alphabet2 = 65;
	char fo_alphabet = 65, rc_alphabet = 65;
	char ra_alphabet = 65, mac_alphabet = 65, dn_alphabet = 65;
	char strt_alphabet = 65, stnt_alphabet = 65, sttb_alphabet = 65; // Added by Ravi

	int gl_num = 0, dy_num = 0;
	int st_num = 0, pr_num1 = 0, pr_num2 = 0;
	int fo_num = 0, rc_num = 0;
	int ra_num = 0, mac_num = 0, dn_num = 0;
	int strt_num = 0, stnt_num = 0, sttb_num = 0;
	int port_num;

	//Neelu Ends
        
	for (int i = 0; i < MAX_NUM_ADDR_RANGES; i++) {
		PropertyTagUID[i] = 0;
		BindingTagUID[i] = 0;
	}
        //Neelu Added for NAT
			
	strcpy (ProxyAppIndex, "$A ") ;
	strcpy (ProxyAppInfoIndex, "$A ") ;
        //Neelu Ends
        
        
        while ((input.ReadString (sBuf, MaxINIString)) != NULL)
	{
		if ((ch = strchr (sBuf, (int) '[')) != NULL)    //Check for section header
		{
			*(++ ch) = '\0' ;
			strcpy (pBuf, sBuf) ;
			ch += 2 ;
			strcpy (sBuf, ch) ;
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(-- ch) = '\0' ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, ++ ch) ;
				ch = strstr (sBuf, "]]") ;
				if (ch != NULL)
				{
					strcat (pBuf, ++ ch) ;
					strcpy (sBuf, pBuf) ;
				}
			}
			else
			{
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
			}
		}
		else
		{
			if ((ch = strstr (sBuf, "Virtual Port to DLCI")) != NULL)
			{
				ch += 20;       //Look after "Virtual Port to DLCI"
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					*ch = '\0';
					strcpy(pBuf, sBuf);
					strcat(pBuf, " ");
					ch2++;
					char storing[2];
					storing[0] = *(ch2 +4);
					storing[1] = '\0';
					*(ch2 + 4) = '\0';
					strcat(pBuf, ch2);
					ch2 --;
					*ch2 = '\0';
					strcat(pBuf, " ");
					ch ++;
					strcat(pBuf, ch);
					strcat(pBuf, storing);
					strcpy(sBuf, pBuf);
				}
			}

			if ((ch = strstr (sBuf, "Port")) != NULL)
			{   
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					ch += 4 ;                               //Look after "Port"
					*ch = '\0' ;
					strcpy (pBuf, sBuf) ;
					strcpy (sBuf, ++ ch) ;
					ch2 = strchr (sBuf, (int) ',') ;
					if (ch2 != NULL)
					{       
						*ch2 = '\0' ;
						if ((*(ch2-2)) == '0')
							strcat (pBuf, (ch2-1)) ;
						else
							strcat (pBuf, (ch2-2)) ;
						*(ch2-2) = '\0' ;
						strcat (pBuf, " ") ;         
						strcat (pBuf, sBuf) ;
						strcat (pBuf, ++ ch2) ;
						strcpy (sBuf, pBuf) ;
					}       
				}                   
			}
			else
			{
				if ((ch = strstr (sBuf, "Channel")) != NULL)    
				{   
					char *ch2 ;
					if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
					{
						ch += 7 ;                               //Look after "Channel"
						*ch = '\0' ;
						strcpy (pBuf, sBuf) ;
						strcpy (sBuf, ++ ch) ;
						ch2 = strchr (sBuf, (int) ',') ;
						if (ch2 != NULL)
						{       
							*ch2 = '\0' ;
							if ((*(ch2-2)) == '0')
								strcat (pBuf, (ch2-1)) ;
							else
								strcat (pBuf, (ch2-2)) ;
							*(ch2-2) = '\0' ;
							strcat (pBuf, " ") ;         
							strcat (pBuf, sBuf) ;
							strcat (pBuf, ++ ch2) ;
							strcpy (sBuf, pBuf) ;
						}       
					}                   
				}
				else
				{
					if ((ch = strstr (sBuf, "Frame Relay DLCI")) != NULL)
					{
						char *ch1;
						if ((ch1 = strstr (sBuf, "Number")) != NULL)
						{
							ch1 += 6;        // add 6 for the number
							*ch1 = '\0';
							strcpy(pBuf, sBuf);
							ch1 += 3;
							char store_temp[3];
							store_temp[0] = *ch1;
							store_temp[1] = *(ch1 + 1);
							store_temp[2] = '\0';
							strcat(pBuf, store_temp);
							strcat(pBuf, " = ");
							ch1 += 3; // two for numbers and one for comma
							strcat(pBuf, ch1);
							strcpy(sBuf, pBuf);
						}
						else
						{
							ch += 16;               // add 16 for "Frame Relay DLCI"
							*ch = '\0';
							ch++;
							strcpy(pBuf, sBuf);
							if ((ch1 = strchr (ch, (int) '=')) != NULL)
							{
								ch1 ++;
								*(ch1 + 5) = '\0';
								strcat(pBuf, ch1);
								strcat(pBuf, " ");
								*ch1 = '\0';
								strcat(pBuf, ch);
								strcat(pBuf, " ");
								ch1 += 6;
								strcat(pBuf, ch1);
								strcpy(sBuf, pBuf);
							}
						}
					}
				}
		 	}
// Added by Sreelu ....
// added for DHCP  vvvv
			if ((ch = strstr (sBuf, "DHCP Tag ")) != NULL)
			{
				char LHS[40], RHS[MAX_INI_OPTN * 3];
				int	TagNumber;

				sscanf(sBuf, "DHCP Tag %[^=]=%2d,%[^\0]", LHS, &TagNumber, RHS);
				if (strstr(LHS, "Properties"))
				{
					sprintf(sBuf, "$%c DHCP Tag%d %s= %s", 
						(char)('A'+ PropertyTagUID[TagNumber]++), TagNumber, LHS, RHS);
				}
				else if (strstr(LHS, "Bindings"))
				{
					sprintf(sBuf, "$%c DHCP Tag%d %s= %s", 
						(char)('A'+ BindingTagUID[TagNumber]++), TagNumber, LHS, RHS);
				}
				else
				{
					sprintf(sBuf, "DHCP Tag%d %s= %s", TagNumber, LHS, RHS);
				}
			}
//Added for DHCP ^^^^^^
//....Added by Sreelu

			// Put "=" in place of " = "
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(ch - 1) = '\0';
				strcpy (pBuf, sBuf) ;
				strcat (pBuf, "=") ;
				ch += 2 ;
				strcat (pBuf, ch) ;
				strcpy (sBuf, pBuf) ;
			}
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp ("PPP Port? Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? Remote Option=*", sBuf))
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// also to the LHS for making unique LHS strings for
				// Windows ini APIs to work

				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
		        //Neelu added for NAT
                        // Changes by Vidy for Static Host and Static Net routes
			// Since there can be multiple Static Host routes we need to
			// somehow differentiate them for Windows API to work
			// We add '$? ' where ?=A,B,... to the beginning of these lines
//Vidy ^^^^     
			if (strstr (sBuf, "IP Static Host Route"))
			{
				sprintf (pBuf, "$%c%d%s", strt_alphabet, strt_num, sBuf);
            strcpy (sBuf, pBuf) ;
				strt_alphabet++;
				if (strt_alphabet > 90)
				{
					strt_alphabet = 65;
					strt_num++;
				}
			}
			else if (strstr (sBuf, "IP Static Net Route"))
			{
				sprintf (pBuf, "$%c%d%s", stnt_alphabet, stnt_num, sBuf);
            strcpy (sBuf, pBuf) ;
				stnt_alphabet++;
				if (stnt_alphabet > 90)
				{
					stnt_alphabet = 65;
					stnt_num++;
				}
			}
			else if (strstr (sBuf, "IP Static Route Table Entries"))
			{
				sprintf (pBuf, "$%c%d%s", sttb_alphabet, sttb_num, sBuf);
            strcpy (sBuf, pBuf) ;
				sttb_alphabet++;
				if (sttb_alphabet > 90)
				{
					sttb_alphabet = 65;
					sttb_num++;
				}
			}
			else if (strstr (sBuf, "Proxy Server Application List"))
			{
				strcpy (pBuf, ProxyAppIndex) ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
				ProxyAppIndex[1] ++ ;
			}
//Vidy vvvvv 17/10/97
			else if (strstr (sBuf, "Proxy Application Info"))
			{
				strcpy (pBuf, ProxyAppInfoIndex) ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
				ProxyAppInfoIndex[1] ++ ;
			}
			else if ((strstr (sBuf, "Proxy Server Global Address List")) != NULL)
	      	{														 
			wsprintf (pBuf, "$%c%d%s", gl_alphabet, gl_num, sBuf);
          strcpy (sBuf, pBuf) ;
				gl_alphabet++;
				if (gl_alphabet > 90)
				{
					gl_alphabet = 65;
					gl_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Local Internet Servers")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", dy_alphabet, dy_num, sBuf);
            strcpy (sBuf, pBuf) ;
				dy_alphabet++;
				if (dy_alphabet > 90)
				{
					dy_alphabet = 65;
					dy_num++;
				}
			}
			else if ((strstr (sBuf, "Proxy Server Mapped Address List")) != NULL)
			{
				wsprintf (pBuf, "$%c%d%s", st_alphabet, st_num, sBuf);
            strcpy (sBuf, pBuf) ;
				st_alphabet++;
				if (st_alphabet > 90)
				{
					st_alphabet = 65;
					st_num++;
				}
			}
		}
		output.WriteString (sBuf) ;
	}
	output.Close() ;
	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	delete [] pBuf ;  
        WritePrivateProfileString(NULL, NULL, NULL, IniInWinForm);
	return TRUE ;
}       // End of WriteWinINI

// -------------------------------------------------------------------------
// Function        :       CRouconApp::UpGradeProxy()
// Arguments       :       None.
// Synopsis        :       Incorporates changes in Roucon.ini into MTRouter.ini       
// Returns         :       None.
// -------------------------------------------------------------------------
BOOL CRouconApp::UpGradeProxy()
{

        LPCSTR SECTION_LIST[MAX_SECTION_LIST]=
        {
                "LSL Multiplex Layer",
                "SOCKET Interface",
                "IP Routing",
                "PPP Device Driver",
                "CCP Compression",
                "VJC Compression",
                "SNMP Management",
                "WAN Serial Device Driver",
                "TCP Transport",
                "TELNET Server",
                "TFTP",
                "DHCP",
                "WEB Server",
                "PROXY Server",
					 "USER Database",
					 "SNTP Client"
        };

        LPCSTR SectionHeader; 

	char sBuf[120 * 50], *temp_buf;
        char LHS_Buf[MaxINIString] ;
        char RHS_Buf[MaxINIString] ;
        char pBuf[MaxINIString] ;
	char *ch ;
	
        for (int i=0; i<MAX_SECTION_LIST; i++)
        {
                SectionHeader = SECTION_LIST[i];
                GetPrivateProfileString(SectionHeader, NULL, StrNull, 
                        (LPSTR) sBuf, sizeof(sBuf), (LPCSTR) NewIniInWinForm);
                ch = sBuf;
                while (*ch != '\0')
                {
                        strcpy (LHS_Buf, ch);
                        GetPrivateProfileString(SectionHeader, 
                                (LPCSTR) LHS_Buf, (LPCSTR) StrNull, (LPSTR) RHS_Buf, 
                                        sizeof(RHS_Buf), (LPCSTR) NewIniInWinForm);
                        GetPrivateProfileString(SectionHeader, 
                                (LPCSTR) LHS_Buf, (LPCSTR) StrNotFound, (LPSTR) pBuf, 
                                        sizeof(pBuf), (LPCSTR) IniInWinForm);
                       if (!strcmp(pBuf, StrNotFound))
							  {
                                WritePrivateProfileString(SectionHeader, 
                                        (LPCSTR) LHS_Buf, (LPCSTR) RHS_Buf, (LPCSTR) IniInWinForm); 
							  }
							  if(!strcmp(LHS_Buf, "LSL Total Buffer Size"))	
							  {
                           WritePrivateProfileString(SectionHeader, 
                              (LPCSTR) LHS_Buf, "1300000", (LPCSTR) IniInWinForm); 
							  }		
 
                       temp_buf = ch + strlen (LHS_Buf) + 1;
                       ch = temp_buf;
                }
        }

        // On 29/7/98
        // HANDLE MISCELLANEOUS STRINGS 
        //PPPMiscUpgrade();

	return TRUE ;
}      // End of UpGradeProxy


/////////////////////////////////////////////////////////////////////////////
// The one and only CRouconApp object

CRouconApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CRouconApp initialization

void CRouconApp::GetBootVersionAndSetVars (CWnd *pWnd, char *VerStr)
{
	if (GetBootVersion (pWnd, VerStr) == TRUE)
	{
		strcpy (BootUpgrBinFile, LoadPath) ;
		strcat (BootUpgrBinFile, BOOT_16BIT_BIN) ;  

		strcpy (B16BitBinFile, LoadPath) ;
		strcat (B16BitBinFile, BOOT_16BIT_BIN) ;  // Boot16bit.bin

		/* Ravi on 13 Dec 1999 */
		strcpy (FirmwareBinFile, LoadPath);
		strcat (FirmwareBinFile, FIRMWARE_BIN);
   }
}

BOOL CRouconApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	int length ;
   char *ptr ;
	char szBuf[30] ;
	char ApplicationName[50] ;
	BootConfigType ConfigHeader ;
	unsigned char *BytePointer ;
	char *NetAddrPointer ;
	int i, UpperNibble, LowerNibble ;
	CMainDlg mdlg;

   length = GetModuleFileName (m_hInstance, LoadPath, FILE_NAME_SIZE) ;
   ptr = &LoadPath[length] ;
   while (*ptr != '\\')
      ptr -- ;
   *(ptr + 1) = NULL ;

   /* create all the ini File names */
   strcpy (OwnIniFile, LoadPath) ;
   strcat (OwnIniFile, LocalINI) ; // Setup.Ini

   strcpy (IniInWinForm, LoadPath) ;
   strcat (IniInWinForm, TempINI) ;  // Roucon.Ini

   strcpy (NewIniInWinForm, LoadPath) ;
   strcat (NewIniInWinForm, NewINI) ;  // MTRouter.Ini

   strcpy (IniInRtrWareForm, LoadPath) ;
   strcat (IniInRtrWareForm, CNF_File) ;  // Router.Cnf
	// IniInRtrWareForm contains the configuration file

   strcpy (IniInRtrWareFormDef, LoadPath) ;
   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
	// IniInRtrWareFormDef contains the default configuration file

   strcpy (IniInTempDef, LoadPath) ;
   strcat (IniInTempDef, TEMP_File) ;  // temp.Cnf
	// IniInTempDef contains the default configuration file

	strcpy (UDBCompressedDBaseFile, LoadPath) ;  // Compressed User DBase
	strcat (UDBCompressedDBaseFile, UDB_COMPR_DBASE_FILE) ; 

	strcpy (UDBUnCompressedDBaseFile, LoadPath) ;  // UnCompressed User DBase
	strcat (UDBUnCompressedDBaseFile, UDB_UNCOMPR_DBASE_FILE) ; 

  	strcpy (UserDataFile, LoadPath);  //Neelu for Event broadcast
	strcat (UserDataFile, UDB_EVENT_FILE); //Neelu for Event broadcast

// Imran 22.3.99
	strcpy (LogFileName, LoadPath) ;  // Log File
	strcat (LogFileName, LOG_FILE) ; 

	strcpy (UserEventBdcastFile, LoadPath) ;  // File containing latest bd'cast message
	strcat (UserEventBdcastFile, USER_EVENTS_BROADCAST_FILE) ;
// Imran 22.3.99

	Ctl3dRegister (m_hInstance) ;
	Ctl3dAutoSubclass (m_hInstance) ;

	SetDialogBkColor() ;        // Set dialog background color to gray
	LoadStdProfileSettings() ;  // Load standard INI file
									    // options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	// create main window
	CMainFrame *p_MainFrame;
	if (m_lpCmdLine[0] != 0)
	{
		p_MainFrame = new CMainFrame ;
		if (!p_MainFrame->LoadFrame (IDR_MAINFRAME))
			return FALSE ;
	}
	else
		p_MainFrame = (CMainFrame *)&mdlg;

	m_pMainWnd = p_MainFrame ;

	((CWnd *) p_MainFrame)->CenterWindow() ;
//	((CWnd *) p_MainFrame)->ShowWindow(TRUE) ;

	CommandLineArgument = 0 ;

	DownloadSetupOnly = FALSE ;
	LookForTargetOnly = FALSE ;
	DontReadConfiguration = FALSE ;

	// Check if the port is TFTP
	GetPrivateProfileString((LPCSTR) "Port Setup",
		(LPCSTR) "Communication type",
					(LPCSTR) "Serial", (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) OwnIniFile) ;

	if (!strcmpi (szBuf, "IP"))
		IsPortIP = TRUE ;

	GetPrivateProfileString ((LPCSTR) "Port Setup",
		(LPCSTR) "Application Name", (LPCSTR) "Router Setup",
			(LPSTR) ApplicationName , sizeof (ApplicationName),
						(LPCSTR) OwnIniFile) ;
	
	WindowText = ApplicationName ;
	/* 9/7/97 */
	IsLanTalker = !strcmpi (ApplicationName, "LANTalker") ;
	IsRF200 = !strcmpi (ApplicationName, "RouteFinder200") ;
	/* 9/7/97 */
	MainMsgHeader = ApplicationName ;

/* brindha on 17/8/99. from Big Proxy. */
	memset (BootVerString, 0, sizeof (BootVerString)) ;

/* If command line argument is other than for download wizard setup 
& not thru TFTP */	
	if((!IsPortIP) || ((m_lpCmdLine[0] != '3') && (m_lpCmdLine[0] != '1')))
	   GetBootVersionAndSetVars(p_MainFrame, BootVerString);  

	CodeLoadAddress = COD_LOAD_ADDR ;
	CodeStartAddress = COD_START_ADDR ;
	FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_CodeLoadAddress = COD_LOAD_ADDR ;
	TFTPCodeAddressDetails.TFTP_CodeStartAddress = COD_START_ADDR ;

	if (m_lpCmdLine[0] == '2')
	{
		CommandLineArgument = 2;
		if (!IsPortIP) // For COM Port
		{	
			CPowerCode cPowerCode ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerCode.DoModal())
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
		else // using TFTP
		{
			if (RouMsgBox (MSG_MAIN_ASK_DOWN,
						MainMsgHeader, MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
			{
				CFileDialog cFileDialog (TRUE, (LPCSTR) "*.BIN",
							NULL, OFN_HIDEREADONLY /*| OFN_CREATEPROMPT*/,
			   	         (LPCSTR) "Firmware Files (*.bin) | *.bin ||", NULL) ;
				cFileDialog.CenterWindow () ;
				if (IDOK != cFileDialog.DoModal())
				{
					PostQuitMessage (0) ;
					return TRUE ;
				}

				CString CodeFileName = cFileDialog.GetPathName() ;
				char *Ptr = CodeFileName.GetBuffer(0) ;

/* brindha on 17/8/99. */
				if (strcmp(CodeFileName,B16BitBinFile) == 0)
				{
					if (strncmp(BootVerString,NEW_BOOT_VERSION,4) >= 0)
					{
						if (RouMsgBox (MSG_PWN_REBT_UPGR_NO_NEED,
								 MainMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES) 
						{
							PostQuitMessage (0) ;
							return TRUE ;
						}
					}
                       boot_upgraded = 1 ;
                  }

				struct
				{
					BYTE Version[8] ;
					BYTE DateStamp[24] ;
					BYTE MagicNumber[5] ;
				} FileHeader ;

				CStdioFile Input ;

				if (!Input.Open (CodeFileName,
						CFile::modeRead | CFile::typeBinary))
				{
					RouMsgBox (MSG_GEN_FILE_OPEN_ERR, MainMsgHeader, 
													MB_OK | MB_ICONINFORMATION) ;

					PostQuitMessage (0) ;
					return (TRUE) ;
				}

				Input.Read (&FileHeader, 37) ;
				Input.Close() ;

				char szMagic[10] ;
				sprintf (szMagic, "%X", (WORD) MAGIC_NUM) ;
				if (strcmp ((LPCSTR) &FileHeader.MagicNumber, szMagic)) 
				{
					RouMsgBox (MSG_PWN_INV_CODE, MainMsgHeader,
														MB_OK | MB_ICONSTOP) ;
					PostQuitMessage (0) ;
					return TRUE ;
				}

				strcpy (TFTPPutLocalFileName, Ptr) ;
				strcpy (TFTPPutRemoteFileName, "MTROUTER.BIN") ;

//				TFTPWaitMessage TFTPCompressionProgress ((CWnd *) p_MainFrame) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;

				SetCapture(NULL);
				tftpwrit TFTPFirmwareUpdate ;
				if (IDOK != TFTPFirmwareUpdate.DoModal())
				{
                       if (boot_upgraded)  
                            boot_upgraded = 0 ;
					PostQuitMessage (0) ;
					return TRUE ;
				}
/* brindha on 18/8/99. */
                  if (boot_upgraded)
                  {
   				RouMsgBox (MSG_PWN_DNLD_BOOT_WAIT, MainMsgHeader, 
        						MB_OK | MB_ICONINFORMATION) ;
                       boot_upgraded = 0 ;
                  }
			}
			else
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
		PostQuitMessage (0) ;		// exit out after firmwareupdate
		return TRUE ;
	}

	/* Download default setup */
	/* 3 --> while installing roucon */
	/* 1 --> while downloading default setup */
	if ((m_lpCmdLine[0] == '3') || (m_lpCmdLine[0] == '1'))
	{
		CommandLineArgument = 3 ;

#if 0
//Added by Sreelu for Updating UserDataBase.
		CUsersComDlg cUsersComDlg ((CWnd *) NULL) ;
		cUsersComDlg.DoModal(); 
#endif
	
		/* Using TFTP for Download Default setup */
		if (IsPortIP)
		{
//Neelu ported fm Jo on 03-02-1999		
			GetPrivateProfileString((LPCSTR) "Port Setup", (LPCSTR) "Auto Detect",
				(LPCSTR) "Disabled", (LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;

			if (!strcmp (szBuf, "Enabled"))
			{

				// Create Modeless AutoDetect Box...
				CAutodetect Autodetect;


				// Now the Dialog Box is Created.. So Initialise the Sockets..
				int retry = 0 ;
				BOOL result = Autodetect.InitialiseSockets(retry);
				
				if (result == FALSE)
				{
		  		  	AfxMessageBox("Unable to proceed with autodetection....") ;
					UnInitUDP() ;
					return TRUE ;
				}

				MSG Msg;
				BOOL bMsgFound;
				BOOL bTimerExpired = FALSE;
				BOOL return_value ;

				while(bTimerExpired == FALSE)
				{
				   bMsgFound = PeekMessage(&Msg, Autodetect.m_hWnd,0,0,PM_REMOVE);
					if(bMsgFound == TRUE)
					{
						switch(Msg.message)
						{
							case WM_TIMER:
									Autodetect.TimerExpired(Msg.wParam);
									if (Msg.wParam == AUTODETECT_TIMERID)
										bTimerExpired = TRUE;
									else
										if (Msg.wParam == AUTODETECT_RETRY_TIMERID)
										{
											retry = 1 ;
											Autodetect.InitialiseSockets(retry);
										}
									break;
							case WM_UDP_EVENT_OCCURED:
							        	return_value = Autodetect.ResponseReceived();
									break;
							default:break;
						}

						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}

				if (DetectSuccess == FALSE)
				{
						AfxMessageBox("Autodetection Failed");
						UnInitUDP() ;
				   	return FALSE ;
				}
				else
				{
				   CIPDetect ipdetect ;	
				   ipdetect.DoModal() ;
				}
//				char WindowText[80] ;

//				strcpy (WindowText, "Please Wait...Configuring ProxyServer and rebooting") ; 
//				Autodetect.m_wait_msg = WindowText ;
//				Autodetect.SetWindowText (m_wait_msg) ;

				bTimerExpired = FALSE;
				UINT nTimerID = Autodetect.SetTimer(WAIT_FOR_BOOT_TIMER, MAX_UDP_RESPONSE_TIMER, NULL) ;
				while(bTimerExpired == FALSE)
				{
				         bMsgFound = PeekMessage(&Msg, Autodetect.m_hWnd, 0, 0, PM_REMOVE);
					if(bMsgFound == TRUE)
					{
						switch(Msg.message)
						{
							case WM_TIMER:
									if (Msg.wParam == WAIT_FOR_BOOT_TIMER)
									{
										Autodetect.TimerExpired(Msg.wParam);
										bTimerExpired = TRUE;
									}
									break;
							case WM_UDP_EVENT_OCCURED:
							        	return_value = Autodetect.ResponseReceived();
										break;
							default:break;
						}
						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}
				UnInitUDP() ;
/* Changed by Ravi */
				if (dotdecimal_configured_ip_address.IsEmpty())
				{
					PostQuitMessage (0) ;
				 	return TRUE;
				}
/* Changed by Ravi */

				WritePrivateProfileString ((LPCSTR) "Port Setup",			
					(LPCSTR) "Router IP Address", (LPCSTR) dotdecimal_configured_ip_address, (LPCSTR) OwnIniFile) ;

				ModifyIPAddress = TRUE ;
			}

//Neelu ported fm Jo Ends on 03-02-1999		
		      //	GetBootVersionAndSetVars(p_MainFrame, BootVerString);
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

			tftpread TFTPReadDialog ;
			if (TFTPReadDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}

			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;

				for (i = 0,
						  BytePointer = &ConfigHeader.EthernetAddr[0],
							  NetAddrPointer = &EtherNetAddr[0] ; i < 6 ;
									  i++, BytePointer++)
				{
					UpperNibble = (*BytePointer >> 4) & 0x0F ;
					LowerNibble = (*BytePointer) & 0x0F ;

					if ((UpperNibble >= 0) && (UpperNibble <= 9))
						*NetAddrPointer++ = '0' + UpperNibble ;
					else
						*NetAddrPointer++ = 'A' + UpperNibble - 10 ;

					if ((LowerNibble >= 0) && (LowerNibble <= 9))
						*NetAddrPointer++ = '0' + LowerNibble ;
					else
						*NetAddrPointer++ = 'A' + LowerNibble - 10 ;
				}
				*NetAddrPointer = NULL ;
			}
			else
			{
				::MessageBox (((CWnd *) p_MainFrame)->GetSafeHwnd(), "Could not initialize configuration read. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage (0) ;
				return TRUE ;
			}
		
		}

		// Ask the user to connect the router and power on
		// If already connected just power off and power on
		if (!RAWriteWinINI())
		{	// Convert MTROUTER.CNF to ROUCON.INI
			::MessageBox (((CWnd *) p_MainFrame)->GetSafeHwnd(), "Error in writing configuration. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
			PostQuitMessage (0) ;
			return TRUE ;
		}

		// read ether net address and check if router network corresponds
		// to that of the one in roucon.ini. if same, just download
		// else invoke the dialog boxes
		LookForTargetOnly = TRUE ;   // Just read ethernet address
											  // Do not download setup now	
		if (!IsPortIP)
		{
			CPowerOn cPowerOn ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerOn.DoModal() )
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

#if 0			// Commented by Sreelu for Wizard Setup
		CIPConfig tagIPConfig ((CWnd *) p_MainFrame) ;
		tagIPConfig.DoModal() ;
#endif

		CIPDNLD ipdnld ((CWnd *) p_MainFrame) ;
		ipdnld.DoModal() ;

		WANDefs cWANDefs ((CWnd *) p_MainFrame) ;
		cWANDefs.DoModal() ;

		char temp_get[15];
		BOOL WanAsync = TRUE ;
		GetPrivateProfileString (WANSectionHeader, "WAN Port0 ASYNC",
				StrDisabled, temp_get, sizeof (temp_get), IniInWinForm) ;
		if (strcmp (temp_get, StrEnabled) != 0)
			WanAsync = FALSE ;

		RAWriteRouterINI() ;	// Convert modified ROUCON.INI to MTROUTER.CNF

		// Now we are actually going to download the setup
		LookForTargetOnly = FALSE ;
		if (!IsPortIP)
		{
			CPowerOn c1PowerOn ((CWnd *) p_MainFrame) ;
			c1PowerOn.DoModal() ;
		}
		else
		{
			if (RouMsgBox (MSG_MAIN_ASK_DOWN, MainMsgHeader,
									MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
			{
// Writing UserDatabase Defaults - Added by Sreelu.
			strcpy (TFTPPutLocalFileName, UDBUnCompressedDBaseFile) ;
			strcpy (TFTPPutRemoteFileName, UDB_COMPR_DBASE_FILE) ;

			// Use TFTP write
			tftpwrit TFTPWriteUserDataBase ;
			TFTPWriteUserDataBase.DoModal() ; 
// Writing UserDatabase Defaults - Added by Sreelu.

				strcpy (TFTPPutLocalFileName, IniInRtrWareFormDef) ;
				strcpy (TFTPPutRemoteFileName, "CONFIG.INI") ;

				tftpwrit TFTPPutDefaultSetup ;
				TFTPPutDefaultSetup.DoModal() ;
			}
		}
		//Copy the mtrouter.cnf to router.cnf to avoid reading of cnf
		//when tyring to configure next time

		PostQuitMessage (0) ;
		return TRUE ;
	}

	if (m_lpCmdLine[0] == '4')
	{
		DontReadConfiguration = TRUE;
		CommandLineArgument = 4;
	}

	if (m_lpCmdLine[0] == '5')
	{
		DontReadConfiguration = TRUE;
		CommandLineArgument = 5;
	}
	

// Added by Sreelu for upgrade
	if (m_lpCmdLine[0] == '6')
	{
/* brindha on 17/8/99. from Big Proxy. */
        if (IsPortIP)
		{
			RouMsgBox (MSG_UPGRADE_TFTP_ERROR, MainMsgHeader,
												MB_OK | MB_ICONSTOP) ;
			PostQuitMessage (0) ;
			return TRUE ;
		}

		CommandLineArgument = 6;
        DefaultSetup = TRUE; /* Default  Setup  */

		GetBootVersionAndSetVars(p_MainFrame, BootVerString);

#if 0
//Added by Sreelu for Updating UserDataBase.
		CUsersComDlg cUsersComDlg ((CWnd *) NULL) ;
		cUsersComDlg.DoModal(); 
#endif
	
        CMainDlg mdlg(p_MainFrame);
        mdlg.DoModal();     //Reading router.cnf from FLASH PROM to HARD DISK
      
        RAWriteWinINI();    //Converting new mtrouter.cnf to new mtrouter.ini

        firewall_upgraded = 1 ;

/* brindha on 17/8/99.from Big Proxy. */
      //Download boot upgraded bin only if boot version is lesser than NEW_BOOT_VERSION.
		if (strncmp(BootVerString,NEW_BOOT_VERSION,4) < 0)
		{
			boot_upgraded = 1 ;
      	     CPowerCode cPowCode ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowCode.DoModal())
			{
				boot_upgraded = 0 ;
                  firewall_upgraded = 0 ;
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

        AfxGetApp()->LoadCursor (IDC_WAIT) ;
        AfxGetApp()->DoWaitCursor (1) ;

		CUpGrade cUpgrade(p_MainFrame);
		cUpgrade.InvalidateRect(NULL);
        cUpgrade.UpdateWindow();
        UpGradeProxy();     // router.ini = router.ini + new strings from mtrouter.ini + new modules(e.g.,OSPF)
        cUpgrade.DestroyWindow();

	 	LookForTargetOnly = TRUE;   // Just read ethernet address
		CPowerOn cPowerOn ((CWnd *) p_MainFrame);
		if (IDCANCEL == cPowerOn.DoModal())
		{
             firewall_upgraded = 0 ;
			PostQuitMessage (0) ;
			return TRUE ;
		}
        firewall_upgraded = 0 ;

#if 0 
// Sreelu for Upgrade
	// User can modify any of the parameters in the Setup if required...
  		CIPConfig tagIPConfig ((CWnd *) p_MainFrame) ;
   	tagIPConfig.DoModal() ;
		WANDefs cWANDefs ((CWnd *) p_MainFrame) ;
		cWANDefs.DoModal() ;
	//...	
		char temp_get[15];
		BOOL WanAsync = TRUE ;
		GetPrivateProfileString (WANSectionHeader, "WAN Port0 ASYNC",
				StrDisabled, temp_get, sizeof (temp_get), IniInWinForm) ;
		if (strcmp (temp_get, StrEnabled) != 0)
			WanAsync = FALSE ;
#endif // Sreelu for Upgrade

        RAWriteRouterINI(); //Converting router.ini to mtrouter.cnf

//Download new configuration mtrouter.cnf into box

		LookForTargetOnly = FALSE ;
		CPowerOn c1PowOn ((CWnd *) p_MainFrame) ;
		if (c1PowOn.DoModal() == IDCANCEL)
		{
/* brindha on 19/8/99. */
             if (!boot_upgraded)
             {
			     PostQuitMessage (0) ;
			     return TRUE ;
             }
             else  // If user intended to upgrade boot only & not config. upgrade. - brindha.
             {
   	          RouMsgBox (MSG_PWN_DNLD_BOOT_WAIT, MainMsgHeader,
        				MB_OK | MB_ICONINFORMATION) ;
             }
		}
        boot_upgraded = 0 ;

// Convert temp.cnf mtrouter.cnf
		remove(IniInRtrWareFormDef);
		rename(IniInTempDef,IniInRtrWareFormDef);

//Download firmware
        CPowerCode cPowCode ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowCode.DoModal())
		{
			PostQuitMessage (0) ;
			return TRUE ;
		} 

		PostQuitMessage (0) ;
		return TRUE ;
 	}

	// This is for USER DATABASE
	if (m_lpCmdLine[0] == '7')
	{
		CommandLineArgument = 7 ;

		if (IsPortIP)    // If via Ethernet port
		{
			// This is done to find the number of ports
			// From the Configuration
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;	

			tftpread TFTPReadDialog ;	
			if (TFTPReadDialog.DoModal() != IDOK)
			{	
				PostQuitMessage (0) ;	
				return TRUE ;	
			}	

			// Open the BOOT.CFG in the Executable's path dir	
			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;	
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;	
				NumberOfPorts = (UINT) ConfigHeader.NumberOfPorts ;
				fclose (FilePointer) ;

				// Delete BOOT.CFG file
				remove (TFTPGetLocalFileName) ;
			}
			else
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Could not read/create header file",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}

			// Get the User data Base from the Box
			// which is compressed and without the
			// Header
			strcpy (TFTPGetRemoteFileName, UDB_COMPR_DBASE_FILE) ;
			strcpy (TFTPGetLocalFileName, UDBCompressedDBaseFile) ;

			tftpread TFTPReadUserDBDialog ;
			if (TFTPReadUserDBDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return (TRUE) ;
			}

			char UDBHeaderFilePath[200] ;
			FILE *UDBHeaderFile ;
			char UDBVer[20] ;

			memset (UDBVer, 0, sizeof (UDBVer)) ;
			strcpy (UDBHeaderFilePath, LoadPath) ;
			strcat (UDBHeaderFilePath, UDB_HDR_FILE) ;
			UDBHeaderFile = fopen (UDBHeaderFilePath, "rb") ;
			if (UDBHeaderFile == NULL)
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Couldn't read UDB Version",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}
			else
			{
				fread (UDBVer, sizeof (UDBVer), 1, UDBHeaderFile) ;
			}

			// Uncompress the user data base file
			// in USER.DTB
			// without the Header into USER.TMR file
			FILE *FileCompressedDBase = fopen (TFTPGetLocalFileName, "rb") ;
			if (FileCompressedDBase == NULL)		
			{		
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Unable to read Compressed DataBase",		
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;		
				return TRUE ;		
			}		
			
			FILE *FileUnCompressedDBase =
					fopen (UDBUnCompressedDBaseFile, "wb") ;		
			if (FileUnCompressedDBase == NULL)
			{		
				fclose (FileCompressedDBase) ;		
 			
				// To delete the file		
				remove (TFTPGetLocalFileName) ;
	 		
				MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
					(LPCSTR) "Unable to read DataBase",		
						(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;		
				return TRUE ;		
			}		

			if (!strcmpi (UDBVer, VERSION2))
			{
				// just remane compressed file as uncompressed
				// as there is no compression for VERSION2
				// Delete the following file so that "rename" does not fail
				fclose (FileUnCompressedDBase) ;
				fclose (FileCompressedDBase) ;		
				remove (UDBUnCompressedDBaseFile) ;
				rename (UDBCompressedDBaseFile, UDBUnCompressedDBaseFile) ;
			}
			else
			{
				LZWExpandFromFile (FileCompressedDBase, FileUnCompressedDBase) ;		
				fclose (FileUnCompressedDBase) ;
				fclose (FileCompressedDBase) ;		
			}

#if 0		// Commented by Sreelu For User Filter Tab
			
			// Pop up the Users List Dialog
		     //	CUsersDlg cUsers ((CWnd *) p_MainFrame) ;
		       CUserDlg cUser ((CWnd *) p_MainFrame);	
		       if (cUser.DoModal() == IDCANCEL)
			{		
			   PostQuitMessage (0) ;
				return TRUE ;
			}
#endif
			UserFilterTab UFilter ((CWnd *) p_MainFrame);	
//		   UFilter.DoModal();
		   if (UFilter.DoModal() == IDCANCEL)
			{		
			   PostQuitMessage (0) ;
				return TRUE ;
			}

			strcpy (TFTPPutLocalFileName, UDBUnCompressedDBaseFile) ;
			strcpy (TFTPPutRemoteFileName, UDB_COMPR_DBASE_FILE) ;

			// Use TFTP write
			tftpwrit TFTPWriteUserDataBase ;
			TFTPWriteUserDataBase.DoModal() ; 

			// Delete the uncompressed data base 
			// first destroying the contents
			FileUnCompressedDBase =
							fopen (UDBUnCompressedDBaseFile, "wb") ;		
			fclose (FileUnCompressedDBase) ;
			remove (UDBUnCompressedDBaseFile) ;

		   PostQuitMessage (0) ;
			return TRUE ;
   	}
		else // via COM Port
		{
#if 0
		CUserDlg cUser ((CWnd *) p_MainFrame);	
	      cUser.DoModal();
		   PostQuitMessage (0) ;
			return TRUE ;
#endif
			
			CUsersComDlg cUsersComDlg ((CWnd *) NULL) ;
			cUsersComDlg.DoModal(); 
		   PostQuitMessage (0) ;
			return TRUE ;
		}
	}

	if (m_lpCmdLine[0] == '8')
	{
		CommandLineArgument = 8 ;
		if (IsPortIP)    // If via Ethernet port
		{
			userlog logview ((CWnd *) p_MainFrame);
			if (logview.DoModal() == IDOK)
			{		
			    PostQuitMessage (0) ;
			    return TRUE ;
		       	}
			PostQuitMessage (0) ;
			return TRUE ;
				
		}
		else
		{
			AfxMessageBox("Via Com Port not Supported");
			PostQuitMessage (0) ;
			return TRUE;		
		}
		
	}
		
	mdlg.DoModal() ;

	((CWnd *) p_MainFrame)->SendMessage (WM_CLOSE) ;
	return TRUE ;
}

int CRouconApp::ExitInstance()
{
	Ctl3dUnregister(m_hInstance);
	return(CWinApp::ExitInstance());
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CRouconApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

int CRouconApp::wildstrcmp(LPSTR str1, LPSTR str2)
{
	while (*str1 && *str2)
	{
		if (*str1 == '?' || *str2 == '?')
		{	// is any of them a ? char
			str1 ++ ; 
			str2 ++ ;						// if yes skip compare at this char
			continue ;
		}
		if (*str1 == '*' || *str2 == '*') 	// is any of them a * char
			return 0 ;								// if yes return match

		if (*str1 < *str2)
			return -1 ;
		else
			if (*str1 > *str2)
				return 1 ;

		str1 ++ ;
		str2 ++ ;
	}
	return ((int)*str1 - (int)*str2) ;
}

/////////////////////////////////////////////////////////////////////////////
// CRouconApp commands

void LZWExpandFromFile (FILE *sfp, FILE *dfp)
{
	int read_block_len ;
	unsigned short nread, decomp_size ;

	BYTE *read_buf = new BYTE[MAX_READ_SIZE] ;
	if (read_buf == NULL)
		return ;

	BYTE *comp_buf = new BYTE[MAX_UNCOMP_SIZE] ;
	if (comp_buf == NULL)
	{
		delete [] read_buf ;
		return ;
	} 

	do
	{
		if (fread (&read_block_len, 1, sizeof (read_block_len), sfp) !=
													sizeof (read_block_len))
			break;

		read_block_len = change_endian ((WORD) read_block_len);

		if (read_block_len < 0)
		{
			nread = decomp_size = fread (comp_buf, sizeof (char), 
												-read_block_len, sfp);
		}
		else
		{
			nread = fread (read_buf, sizeof(char), read_block_len, sfp);
			decomp_size = LZ15VExpandBuf ((unsigned char far *) read_buf,
						nread, (unsigned char far *) comp_buf, MAX_UNCOMP_SIZE) ;
		}

		fwrite (comp_buf, sizeof (char), decomp_size, dfp);
	}
	while (1) ;

	delete [] read_buf ;
	delete [] comp_buf ; 

	return ;
}


static unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

/*----------------------------------------------------------------------------
	Module : PutLeadingZeroes
	Author : Chetan
	Input  : IPX Address Buffer
	Output : none
----------------------------------------------------------------------------*/
void PutLeadingZeroes (LPSTR lpszIPXNetAddr)
{
	char szAddr[8 + 1] ;

	int nAddrLen = strlen (lpszIPXNetAddr) ;

	// If length is 8 no need of adding leading zeroes
	// or may be "AutoLearn"
	if (nAddrLen >= 8)
		return ;

	// Add the leading zeroes
	for (int i = 0 ; i < (8 - nAddrLen) ; i ++)
		szAddr[i] = '0' ;
	szAddr[i] = 0x00 ;

	// Concatenate the address
	strcat (szAddr, lpszIPXNetAddr) ;
	strcpy (lpszIPXNetAddr, szAddr) ;
	return ;
}


/* Added by cfp 7/12/96 */
void ModifyEndOfRouconIniString (LPCSTR lpcszSection, LPCSTR lpcszLHS, int nCommas, LPCSTR lpcszModifier)
{
	char szRHS[100] ;
	LPSTR pComma ;
	CString csBalance;

	GetPrivateProfileString (lpcszSection, lpcszLHS, (LPCSTR) StrNull,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (!szRHS[0])
		return ;

	pComma = &szRHS[0] ;
	while (nCommas)
	{
		pComma = strchr (pComma, (int) ',') ;
		if (pComma == NULL)
			return ;
		pComma ++ ;
		if (nCommas == 1)
		{
			*pComma = 0 ;
			csBalance = pComma+1;	//Store balance

			strcat (szRHS, lpcszModifier) ;
			if (pComma = strchr(csBalance, (int) ','))
				strcat(szRHS, pComma);

			WritePrivateProfileString (lpcszSection,
					lpcszLHS, (LPCSTR) szRHS, (LPCSTR) IniInWinForm) ;
		}
		nCommas -- ;
	}
	return ;
}

#ifdef NEW_BOOT_2
BOOL CRouconApp::GetBootVersion (CWnd *pWnd, char *VerStr)
{
	BootConfigType ConfigHeader ;

	if (IsPortIP)
	{
		if (m_lpCmdLine[0] == '6')
			return FALSE;
		else
		{
		     strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
		     strcpy (TFTPGetLocalFileName, LoadPath) ;
		     strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

		     tftpread TFTPReadDialog ;
		     if (TFTPReadDialog.DoModal() != IDOK)
		     {
			     return FALSE ;
		     }

		     FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
		     if (FilePointer != NULL)
		     {
			     fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;
			     strcpy (VerStr, (LPCSTR) ConfigHeader.Version) ;
			     fclose (FilePointer) ;
			     remove (TFTPGetLocalFileName) ;
			     return TRUE ;
		     }
		     return FALSE ;
	     }
   }
	else
	{
		CBootVersion BootDlg (pWnd) ;
		BootDlg.VersionString = VerStr ;
		if (BootDlg.DoModal() == IDCANCEL)
 			return FALSE ;
		else 
			return TRUE ; 
//		BootDlg.DoModal() ;
//		return TRUE ;
	}
}
#endif /* NEW_BOOT_2 */

BOOL IsValidHexadecimalString(LPCSTR pstr)
{
	for (	; *pstr; pstr++)
	{
		if (*pstr >= '0' && *pstr <='9')
			continue;
		if(*pstr >= 'a' && *pstr <='f')
			continue;
		if (*pstr >= 'A' && *pstr <='F')
			continue;
		return FALSE;
	}
	return TRUE;
}

DWORD SwapDWord (DWORD IntelMotorola)
{
	DWORD TempDWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempDWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 3) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 2) ;
	*(TempPtrDest + 2) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 3) = *(TempPtrSrc + 0) ;

	return TempDWord ;
}

WORD SwapWord (WORD IntelMotorola)
{
	WORD TempWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 0) ;

	return TempWord ;
}

void PunctuateLong(LPSTR OutStr, DWORD number)
{
	char tBuf[40];
	int	src_idx, dst_idx, length, copy_len;

	length = sprintf(tBuf, "%lu", number);

	for(src_idx = 0, dst_idx = 0, copy_len = length;
					tBuf[src_idx]; copy_len--, src_idx++, dst_idx++)
	{
		if (src_idx && !((copy_len) % 3))
		{
			OutStr[dst_idx++] = ',';
		}
		OutStr[dst_idx] = tBuf[src_idx];
	}
	OutStr[dst_idx] = 0;

}

void DwordToDayHrMinSecs(LPSTR OutStr, DWORD time)
{
	long days, hours, mins, secs;

	days = time / ((long)60 * 60 * 24);   // number of days

	time %= ((long)60 * 60 * 24);			// remaining hours

	hours = time / (60 * 60);			// number of hours

	time %= (60 * 60);					// remaining minutes

	mins = time / 60;					// number of minutes

	secs = time % 60;					// remaing seconds

	sprintf(OutStr, " %03ld : %02ld : %02ld : %02ld", days, hours, mins, secs);

}
 





