// roucon.h : main header file for the ROUCON application
//

#ifndef _ROUCON_H_

#define _ROUCON_H_

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif
#define	FILE_NAME_SIZE		128
#define	TFTP_NAME_SIZE		15
#define  MAX_INI_OPTN		40

#include "resource.h"       // main symbols
#include	"secthdr.h"		//config ini sections

/* Sachin, 03rd October */
#define PPP_USER_NAME_SIZE 41
#define PPP_PASSWORD_SIZE 41
/* Sachin, 03rd October */

#define	NUM_WAN_PORTS	1
#define	NUM_LAN_PORTS	2
#define	MAX_NUM_PORTS	(NUM_WAN_PORTS + NUM_LAN_PORTS)

extern UINT NumberOfPorts ;

#define  TempINI  		"ROUCON.INI"
#define  NewINI  		   "MTROUTER.INI"
#define  LocalINI 		"SETUP.INI"
#define	CNF_File			"ROUTER.CNF"
#define	DEF_CNF_File	"MTROUTER.CNF"
#define	TEMP_File		"TEMP.CNF"
#define  UDB_COMPR_DBASE_FILE "USER.DTB"
#define  UDB_UNCOMPR_DBASE_FILE "USER.TMR"
#define 	UDB_EVENT_FILE		 "USER.EVT"	//Neelu for Event broadcast
#define  LOG_FILE   "PROCON.LOG"  // Imran 22.3.99
#define  USER_EVENTS_BROADCAST_FILE   "USERFILE"  // Imran 22.3.99
/* brindha on 17/8/99. for Boot Upgrade */
#define  BOOT_16BIT_BIN  "NEWBOOT.BIN"
#define  NEW_BOOT_VERSION "3.01"
#define  FIRMWARE_BIN "FW300.BIN" /* Ravi on 13 Dec 1999 */

extern int CommandLineArgument;

extern   char FileName[FILE_NAME_SIZE];          // Used for UPGRADE PROXY
extern   char LoadPath[FILE_NAME_SIZE];			 // directory pathname of executable file
extern   char OwnIniFile[FILE_NAME_SIZE];		 // configuration ini file "SETUP.INI"
extern   char IniInWinForm[FILE_NAME_SIZE];		 // Router ini file in windows form "ROUCON.INI"
extern   char NewIniInWinForm[FILE_NAME_SIZE];  // New Router ini file in windows form "MTROUTER.INI"
extern 	char IniInRtrWareForm[FILE_NAME_SIZE] ; // Router ini file in RouterWare form "ROUTER.CNF"
extern   char IniInRtrWareFormDef[FILE_NAME_SIZE]; // Router ini file in RouterWare form "ROUTER.CNF"
extern   char IniInTempDef[FILE_NAME_SIZE]; // Router ini file in RouterWare form "TEMP.CNF"
extern   char LogFileName[FILE_NAME_SIZE]; // Imran 22.3.99 
extern   char UserDataFile[FILE_NAME_SIZE]; // Imran 22.3.99 
extern   char UserEventBdcastFile[FILE_NAME_SIZE]; // Imran 22.3.99 

/* brindha on 17/8/99. from big proxy. */
extern char BootUpgrBinFile[FILE_NAME_SIZE] ;	// Boot Upgraded Bin file 
extern char B16BitBinFile[FILE_NAME_SIZE] ;	// Boot Upgraded Bin file 
extern char FirmwareBinFile[FILE_NAME_SIZE]; //Ravi on 13 Dec 1999


extern char UDBCompressedDBaseFile[FILE_NAME_SIZE] ;   // Compressed User DBase File
extern char UDBUnCompressedDBaseFile[FILE_NAME_SIZE] ; //  Uncompressed User DBase File
extern	char EtherNetAddr[13];		 // ethernet address printable string form

extern	BOOL	IsPortIP;				// is true if we are going to use TFTP
extern	char	TFTPPutLocalFileName[FILE_NAME_SIZE];
extern	char	TFTPPutRemoteFileName[TFTP_NAME_SIZE];
extern	char	TFTPGetLocalFileName[FILE_NAME_SIZE];
extern	char	TFTPGetRemoteFileName[TFTP_NAME_SIZE];

extern	void RouconCrossCheckPPP(void);
extern	int	ValidIPXNetAddr(LPCSTR NetAddr);
extern   void  PutLeadingZeroes (LPSTR lpszIPXNetAddr) ;

extern void ModifyEndOfRouconIniString (LPCSTR lpcszSection, LPCSTR lpcszLHS, int nCommas, LPCSTR lpcszModifier) ;


extern	CString	MessageString ;

extern CString WindowText ;
	
/* brindha on 17/8/99. from Big Proxy. */
extern int boot_upgraded ; 
extern int firewall_upgraded ;
extern char BootVerString[20] ;

extern	LPCSTR	StrEnabled ;
extern	LPCSTR	StrDisabled ;
extern	LPCSTR	StrNull ;

extern	char *DialogTitleFormat ;

/* 9/7/97 chetan */
extern BOOL IsLanTalker ;
extern BOOL IsRF200 ;
/* 9/7/97 chetan */

#ifdef NEW_BOOT_2
#define BOOT_VER_2 "2.00"
#endif /* NEW_BOOT_2 */



/////////////////////////////////////////////////////////////////////////////
// CRouconApp:
// See roucon.cpp for the implementation of this class
//

class CRouconApp : public CWinApp
{
public:
	CRouconApp();
	BOOL RAWriteRouterINI();
	BOOL RAWriteWinINI();
   BOOL UpGradeProxy();
	int wildstrcmp(LPSTR, LPSTR);

// Overrides
	virtual BOOL InitInstance();
	int ExitInstance();
// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	
#ifdef NEW_BOOT_2
	BOOL GetBootVersion (CWnd *pWnd, char *VerStr) ;
	void	GetBootVersionAndSetVars (CWnd *pWnd, char *VerStr);
#endif /* NEW_BOOT_2 */	

	//{{AFX_MSG(CRouconApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

BOOL RmtLocalIpAddressesOfSameNet (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask) ;
BOOL RmtLocalIpAddressesOfSameNet_2 (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR LocalMask, LPCSTR RmtMask);
BOOL RmtLocalIpAddressesHaveDiffHost (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask) ;
void ConvertDotDecimal (LPCSTR Addr, unsigned char *pAddr) ;
BOOL IsValidHexadecimalString(LPCSTR pStr);
DWORD SwapDWord (DWORD IntelMotorola);
WORD SwapWord (WORD IntelMotorola);
void PunctuateLong(LPSTR OutStr, DWORD number);
void DwordToDayHrMinSecs(LPSTR OutStr, DWORD time);


/////////////////////////////////////////////////////////////////////////////
#endif


