// proxy.cpp : implementation file
//
// Vidy started coding for proxy server 18/07/97

#include "stdafx.h"
#include "procon.h"
#include "proxy.h"
#include "prxaddit.h"
#include "prxfilt.h"
#include "ftpports.h"

// Added by Quande
NameNumber TCPPortStrings[] = {
	{"Echo(7)", 1, "00007", "", "Echo Application"},
	{"FTP(20,21)", 2, "00020", "00021", "File Transfer Protocol"},
	{"Telnet(23)", 1, "00023", "", "Telnet application"},
	{"SMTP(25)", 1, "00025", "", "Simple Mail Transfer Protocol - e-mail"},
	{"Nameserver(42)", 1, "00042", "", "On-line Host Name Service"},
	{"DNS(53)", 1, "00053", "", "Domain Name Server"},
	{"TFTP(69)", 1, "00069", "", "Trivial File Transfer Protocol"},
	{"Gopher(70)", 1, "00070", "", "Distributed docmentaion search and retrieval"},
	{"Finger(79)", 1, "00079", "", "Finger user information protocol"},
	{"WWW-HTTP(80)", 1, "00080", "", "World Wide Web - Hiper Text Transfer Protocol"},
	{"POP-3(110)", 1, "00110", "", "Post Office Protocol (Ver 3) - e-mail"},
	{"NNTP(119)", 1, "00119", "", "Network News Transfer Protocol"},
	{"IMAP(143)", 1, "00143", "", "Internet Message Access Protocol"},
	{"NewS(144)", 1, "00144", "", ""},
	{"SNMP(161)", 1, "00161", "", "Simple Network Management Protocol"},
	{"SNMP-TRAP(162)", 1, "00162", "", "Simple Network Management Protocol"},
	{"IRC(194)", 1, "00194", "", "Internet Relay Chat Protocol"},
	{"IMAP3(220)", 1, "00220", "", "Interactive Mail Access Protocol V3"},
	{"https(443)", 1, "00443", "", "Secure Socket Layer-Hyper Text Transfer Protocol"},
	{"SSL-SMTP(465)", 1, "00465", "", "Secure Socket Layer-Simple Mail Transfer Protocol"},
	{"Rlogin(513)", 1, "00513", "", "Remote login - telnet"},
	{"chat(531)", 1, "00531", "", "Conference"},
	{"readnews(532)", 1, "00532", "", ""},
	{"SSL-NNTP(563)", 1, "00563", "", "Secure Socket Layer-Network News Transfer Protocol"},
	{"SSL-FTP(989,990)", 2, "00989", "00990", "Secure Socket Layer-File Transfer Protocol"},
	{"SSL-Telnet(992)", 1, "00992", "", "Secure Socket Layer-Telnet"},
	{"SSL-IMAP4(993)", 1, "00993", "", "Secure Socket Layer-IMAP V4"},
	{"SSL-IRC(994)", 1, "00994", "", "Secure Socket Layer-IRC"},
	{"SSL-POP3(995)", 1, "00995", "", "Secure Socket Layer-POP3"},
	{"Real audio/video(1090)", 1, "01090", "", "Real audio/video application"},
	{"PPTP(1723)", 1, "01723", "", "Point To Point Tunneling Protocol"},
	{"MS-Streaming(1755)", 1, "01755", "", "MicroSoft Netshow Video/Audio Streaming"},
	{"MIRC(6667)", 1, "06667", "", "MIRC Chat"},
	{"Real audio/video(7070)", 1, "07070", "", "Real audio/video application"},
	{"Vxtreme(8000)", 1, "08000", "", "Vxtreme audio/video application"},
	{"Road Runner(6284)", 1, "06284", "", "Road Runner login port"},
	{"Road Runner(6285)", 1, "06285", "", "Road Runner login port"},
	{"Road Runner(7283)", 1, "07283", "", "Road Runner login port"},
	{"AOL(5190)", 1, "05190", "", "American OnLine Instant Messenger"},
	{"Q931(900,902)", 2, "00900", "00902", "VOIP Call Setup"},
  	{"RTP(5004,5006)", 2, "05004", "05006", "Real-time Transport Protocol"},
  	{"RTCP(5005,5007)", 2, "05005", "05007", "Real-time Transport Control Protocol"},
	NULL
};

NameNumber UDPPortStrings[] = {
	{"Echo(7)", 1, "00007", "", "Echo Application"},
	{"FTP(20,21)", 2, "00020", "00021", "File Transfer Protocol"},
	{"Telnet(23)", 1, "00023", "", "Telnet application"},
	{"SMTP(25)", 1, "00025", "", "Simple Mail Transfer Protocol - e-mail"},
	{"Nameserver(42)", 1, "00042", "", "On-line Host Name Service"},
	{"DNS(53)", 1, "00053", "", "Domain Name Server"},
	{"TFTP(69)", 1, "00069", "", "Trivial File Transfer Protocol"},
	{"Gopher(70)", 1, "00070", "", "Distributed docmentaion search and retrieval"},
	{"Finger(79)", 1, "00079", "", "Finger user information protocol"},
	{"WWW-HTTP(80)", 1, "00080", "", "World Wide Web - Hiper Text Transfer Protocol"},
	{"POP-3(110)", 1, "00110", "", "Post Office Protocol (Ver 3) - e-mail"},
	{"NNTP(119)", 1, "00119", "", "Network News Transfer Protocol"},
	{"IMAP(143)", 1, "00143", "", "Internet Message Access Protocol"},
	{"NewS(144)", 1, "00144", "", ""},
	{"SNMP(161)", 1, "00161", "", "Simple Network Management Protocol"},
	{"SNMP-TRAP(162)", 1, "00162", "", "Simple Network Management Protocol"},
	{"IRC(194)", 1, "00194", "", "Internet Relay Chat Protocol"},
	{"IMAP3(220)", 1, "00220", "", "Interactive Mail Access Protocol V3"},
	{"https(443)", 1, "00443", "", "Secure Socket Layer-Hyper Text Transfer Protocol"},
	{"SSL-SMTP(465)", 1, "00465", "", "Secure Socket Layer-Simple Mail Transfer Protocol"},
	{"chat(531)", 1, "00531", "", "Conference"},
	{"readnews(532)", 1, "00532", "", ""},
	{"SSL-NNTP(563)", 1, "00563", "", "Secure Socket Layer-Network News Transfer Protocol"},
	{"SSL-FTP(989,990)", 2, "00989", "00990", "Secure Socket Layer-File Transfer Protocol"},
	{"SSL-Telnet(992)", 1, "00992", "", "Secure Socket Layer-Telnet"},
	{"SSL-IMAP4(993)", 1, "00993", "", "Secure Socket Layer-IMAP V4"},
	{"SSL-IRC(994)", 1, "00994", "", "Secure Socket Layer-IRC"},
	{"SSL-POP3(995)", 1, "00995", "", "Secure Socket Layer-POP3"},
	{"Real audio/video(1090)", 1, "01090", "", "Real audio/video application"},
	{"PPTP(1723)", 1, "01723", "", "Point To Point Tunneling Protocol"},
	{"MS-Streaming(1755)", 1, "01755", "", "MicroSoft Netshow Video/Audio Streaming"},
	{"MIRC(6667)", 1, "06667", "", "MIRC Chat"},
	{"Real audio/video(7070)", 1, "07070", "", "Real audio/video application"},
	{"Vxtreme(8000)", 1, "08000", "", "Vxtreme audio/video application"},
	{"Road Runner(6284)", 1, "06284", "", "Road Runner login port"},
	{"Road Runner(6285)", 1, "06285", "", "Road Runner login port"},
	{"Road Runner(7283)", 1, "07283", "", "Road Runner login port"},
	{"AOL(5190)", 1, "05190", "", "American OnLine Instant Messenger"},
	{"Q931(900,902)", 2, "00900", "00902", "VOIP Call Setup"},
  	{"RTP(5004,5006)", 2, "05004", "05006", "Real-time Transport Protocol"},
  	{"RTCP(5005,5007)", 2, "05005", "05007", "Real-time Transport Control Protocol"},
	NULL
};

NameNumber *PortNameNumberMap[] = {
	TCPPortStrings,
	UDPPortStrings,
	NULL
};

char f_name[30], f_ctrl[10], f_data[10];
extern char ftp_name[30], ftp_Number1[10], ftp_Number2[10];

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char *pFootNote = "$";
char *PortSeparator = ",";  // Neelu

LPCSTR ProxySectionHeader = "PROXY Server";
LPCSTR ProxyAppsIniString = "$A Proxy Server Application List";
LPCSTR ProxyAppsInfoIniString = "$A Proxy Application Info";
static LPCSTR ErrMsgHdr = "Proxy Add/Edit Entry";     // Neelu

//LPCSTR FillTabs = "\t";
#if 0
typedef	struct	tagNameNumber {
	char *Name;
	int  NumberOfPorts;	//Some Protocols use more than one ports (TFTP)
	char *Number1;
	char *Number2;
	char *SingleLineHelp;
}NameNumber;

static NameNumber ProtocolNameNumberMap[] = {
	{"TCP", 1, "00006", ""},
	{"UDP", 1, "00017", ""},
	NULL
};

static NameNumber TCPPortStrings[] = {
	{"Echo(7)", 1, "00007", "", "Echo Application"},
	{"FTP(20,21)", 2, "00020", "00021", "File Transfer Protocol"},
	{"Telnet(23)", 1, "00023", "", "Telnet application"},
	{"SMTP(25)", 1, "00025", "", "Simple Mail Transfer Protocol - e-mail"},
	{"Nameserver(42)", 1, "00042", "", "On-line Host Name Service"},
	{"DNS(53)", 1, "00053", "", "Domain Name Server"},
	{"TFTP(69)", 1, "00069", "", "Trivial File Transfer Protocol"},
	{"Gopher(70)", 1, "00070", "", "Distributed docmentaion search and retrieval"},
	{"Finger(79)", 1, "00079", "", "Finger user information protocol"},
	{"WWW-HTTP(80)", 1, "00080", "", "World Wide Web - Hiper Text Transfer Protocol"},
	{"POP-3(110)", 1, "00110", "", "Post Office Protocol (Ver 3) - e-mail"},
	{"NNTP(119)", 1, "00119", "", "Network News Transfer Protocol"},
	{"IMAP(143)", 1, "00143", "", "Internet Message Access Protocol"},
	{"NewS(144)", 1, "00144", "", ""},
	{"SNMP(161)", 1, "00161", "", "Simple Network Management Protocol"},
	{"SNMP-TRAP(162)", 1, "00162", "", "Simple Network Management Protocol"},
	{"IRC(194)", 1, "00194", "", "Internet Relay Chat Protocol"},
	{"IMAP3(220)", 1, "00220", "", "Interactive Mail Access Protocol V3"},
	{"https(443)", 1, "00443", "", "Secure Socket Layer-Hyper Text Transfer Protocol"},
	{"SSL-SMTP(465)", 1, "00465", "", "Secure Socket Layer-Simple Mail Transfer Protocol"},
	{"Rlogin(513)", 1, "00513", "", "Remote login - telnet"},
	{"chat(531)", 1, "00531", "", "Conference"},
	{"readnews(532)", 1, "00532", "", ""},
	{"SSL-NNTP(563)", 1, "00563", "", "Secure Socket Layer-Network News Transfer Protocol"},
	{"SSL-FTP(989,990)", 2, "00989", "00990", "Secure Socket Layer-File Transfer Protocol"},
	{"SSL-Telnet(992)", 1, "00992", "", "Secure Socket Layer-Telnet"},
	{"SSL-IMAP4(993)", 1, "00993", "", "Secure Socket Layer-IMAP V4"},
	{"SSL-IRC(994)", 1, "00994", "", "Secure Socket Layer-IRC"},
	{"SSL-POP3(995)", 1, "00995", "", "Secure Socket Layer-POP3"},
	{"Real audio/video(1090)", 1, "01090", "", "Real audio/video application"},
	{"PPTP(1723)", 1, "01723", "", "Point To Point Tunneling Protocol"},
	{"MS-Streaming(1755)", 1, "01755", "", "MicroSoft Netshow Video/Audio Streaming"},
	{"MIRC(6667)", 1, "06667", "", "MIRC Chat"},
	{"Real audio/video(7070)", 1, "07070", "", "Real audio/video application"},
	{"Vxtreme(8000)", 1, "08000", "", "Vxtreme audio/video application"},
	{"Road Runner(6284)", 1, "06284", "", "Road Runner login port"},
	{"Road Runner(6285)", 1, "06285", "", "Road Runner login port"},
	{"Road Runner(7283)", 1, "07283", "", "Road Runner login port"},
	NULL
};

static NameNumber UDPPortStrings[] = {
	{"Echo(7)", 1, "00007", "", "Echo Application"},
	{"FTP(20,21)", 2, "00020", "00021", "File Transfer Protocol"},
	{"Telnet(23)", 1, "00023", "", "Telnet application"},
	{"SMTP(25)", 1, "00025", "", "Simple Mail Transfer Protocol - e-mail"},
	{"Nameserver(42)", 1, "00042", "", "On-line Host Name Service"},
	{"DNS(53)", 1, "00053", "", "Domain Name Server"},
	{"TFTP(69)", 1, "00069", "", "Trivial File Transfer Protocol"},
	{"Gopher(70)", 1, "00070", "", "Distributed docmentaion search and retrieval"},
	{"Finger(79)", 1, "00079", "", "Finger user information protocol"},
	{"WWW-HTTP(80)", 1, "00080", "", "World Wide Web - Hiper Text Transfer Protocol"},
	{"POP-3(110)", 1, "00110", "", "Post Office Protocol (Ver 3) - e-mail"},
	{"NNTP(119)", 1, "00119", "", "Network News Transfer Protocol"},
	{"IMAP(143)", 1, "00143", "", "Internet Message Access Protocol"},
	{"NewS(144)", 1, "00144", "", ""},
	{"SNMP(161)", 1, "00161", "", "Simple Network Management Protocol"},
	{"SNMP-TRAP(162)", 1, "00162", "", "Simple Network Management Protocol"},
	{"IRC(194)", 1, "00194", "", "Internet Relay Chat Protocol"},
	{"IMAP3(220)", 1, "00220", "", "Interactive Mail Access Protocol V3"},
	{"https(443)", 1, "00443", "", "Secure Socket Layer-Hyper Text Transfer Protocol"},
	{"SSL-SMTP(465)", 1, "00465", "", "Secure Socket Layer-Simple Mail Transfer Protocol"},
	{"chat(531)", 1, "00531", "", "Conference"},
	{"readnews(532)", 1, "00532", "", ""},
	{"SSL-NNTP(563)", 1, "00563", "", "Secure Socket Layer-Network News Transfer Protocol"},
	{"SSL-FTP(989,990)", 2, "00989", "00990", "Secure Socket Layer-File Transfer Protocol"},
	{"SSL-Telnet(992)", 1, "00992", "", "Secure Socket Layer-Telnet"},
	{"SSL-IMAP4(993)", 1, "00993", "", "Secure Socket Layer-IMAP V4"},
	{"SSL-IRC(994)", 1, "00994", "", "Secure Socket Layer-IRC"},
	{"SSL-POP3(995)", 1, "00995", "", "Secure Socket Layer-POP3"},
	{"Real audio/video(1090)", 1, "01090", "", "Real audio/video application"},
	{"PPTP(1723)", 1, "01723", "", "Point To Point Tunneling Protocol"},
	{"MS-Streaming(1755)", 1, "01755", "", "MicroSoft Netshow Video/Audio Streaming"},
	{"MIRC(6667)", 1, "06667", "", "MIRC Chat"},
	{"Real audio/video(7070)", 1, "07070", "", "Real audio/video application"},
	{"Vxtreme(8000)", 1, "08000", "", "Vxtreme audio/video application"},
	{"Road Runner(6284)", 1, "06284", "", "Road Runner login port"},
	{"Road Runner(6285)", 1, "06285", "", "Road Runner login port"},
	{"Road Runner(7283)", 1, "07283", "", "Road Runner login port"},
	NULL
};

static NameNumber *PortNameNumberMap[] = {
	TCPPortStrings,
	UDPPortStrings,
	NULL
};
#endif
int Proxy::IsKnownProtocol(LPCSTR Protocol)
{
	int 	index;

	// for all known protocols
	for (index = 0; ProtocolNameNumberMap[index].Name; index++)
	{
		// Check if Protocol name is present in the ProtocolNameNummberMap
		if ( ! strcmpi(Protocol, ProtocolNameNumberMap[index].Name))
		{
			return index;
		}
	}
	return -1;
}
/////////////////////////////////////////////////////////////////////////
// Don't call this routine with illeagal indices
LPSTR	Proxy::GetPortName(int ProtocolIndex, int PortIndex, LPSTR PortName)
{
	if ((PortNameNumberMap[ProtocolIndex])[PortIndex].Name)
	{
		strcpy(PortName, (PortNameNumberMap[ProtocolIndex])[PortIndex].Name);
	}
	else
	{
		return NULL;
	}
	return PortName;
}

/////////////////////////////////////////////////////////////////////////////
// Given the Protocol name and Port name in string form
// get the protocol number and Port number in string form and return TRUE
//
int Proxy::GetProtocolPortNumber(LPCSTR ProtocolPort,
	LPSTR Protocol, LPSTR Port, int EntryIndex)
{
	int 	index_1, index_2;
//	char	FormatStr[20];

	// if we didn't find a mathching name then it is already a number
	// so first copy the stuff as is
   //	sprintf(FormatStr, "%%s%s%%%[^\\0%]", FillTabs);
   //	sscanf(ProtocolPort, FormatStr, Protocol, Port);
	sscanf(ProtocolPort, "%s\t%[^\0]", Protocol, Port);

	// for all known protocols
	for (index_1 = 0; ProtocolNameNumberMap[index_1].Name; index_1++)
	{
		// Check if Protocol name is present in the ProtocolNameNummberMap
		if ( ! strcmpi(Protocol, ProtocolNameNumberMap[index_1].Name))
		{
			// matching Protocol name found so copy the number
			strcpy(Protocol, ProtocolNameNumberMap[index_1].Number1);

			// for all ports known for this protocol
			for (index_2 = 0; (PortNameNumberMap[index_1])[index_2].Name; index_2++)
			{
				//Check if port name is present in PortNameNumberMap
				if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Name))
				{
					// matching Port name found so copy the number
					if (EntryIndex == 0)
					{
						strcpy(Port, (PortNameNumberMap[index_1])[index_2].Number1);
					}
					else
					{
						strcpy(Port, (PortNameNumberMap[index_1])[index_2].Number2);
					}
					return (PortNameNumberMap[index_1])[index_2].NumberOfPorts;
				}
			}
			return 0;
		}
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// Given the protocol number and Port number in decimal string form
// get the Protocol name and Port name in string form and return it
//
// Also in put may be like "TCP-<num>" we need to handle this too
//
//Sudha 23rd Oct 97
LPSTR Proxy::GetUserProtocolPortName(LPCSTR Protocol, LPCSTR Port, LPCSTR Higher_port, LPSTR ProtocolPort)
{
	int	index_1, index_2,tmpVal;
	char	tmpProtocol[PROTOCOL_NAME_SIZE],tmpProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	tmpPort[PORT_NAME_SIZE],strLHS[40],strRHS[200],tmpstrRHS[9];
   char  tPort[PORT_NAME_SIZE],tmpnumProtocol[PROTOCOL_NAME_SIZE];
   BOOL PortFound = FALSE;

	strcpy (tmpProtocol, Protocol);		// store these
   strcpy (tmpnumProtocol, Protocol);
	strcpy (tmpPort, Port);

	// for all known protocols
	for (index_1 = 0; ProtocolNameNumberMap[index_1].Name; index_1++)
	{
		// Check if Protocol number is present in the ProtocolNameNummberMap
		if (( ! strcmpi(Protocol, ProtocolNameNumberMap[index_1].Number1)) ||
			(!strcmpi(Protocol, ProtocolNameNumberMap[index_1].Name)))
		{
			// matching Protocol number found so copy the name
			strcpy(tmpProtocol, ProtocolNameNumberMap[index_1].Name);

			// for all ports known for this protocol
			for (index_2 = 0; (PortNameNumberMap[index_1])[index_2].Name; index_2++)
			{
				//Check if port number is present in PortNameNumberMap
				if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Number1))
				{
					// matching Port number found so copy the name
					strcpy(tmpPort, (PortNameNumberMap[index_1])[index_2].Name);
				        PortFound = TRUE;
					break;
				}
				else if((PortNameNumberMap[index_1])[index_2].NumberOfPorts > 1)
				{
					if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Number2))
					{
						// matching Port number found so copy the name
						strcpy(tmpPort, (PortNameNumberMap[index_1])[index_2].Name);
				                PortFound = TRUE;
						break;
					}
				}

			}
         if (!PortFound)
         {
            strcpy(strLHS,ProxyAppsInfoIniString);
            sscanf(tmpnumProtocol,"%d",&tmpVal);
            sprintf(tmpnumProtocol,"%04x",tmpVal);
            sscanf(tmpPort,"%d",&tmpVal);
            sprintf(tmpPort,"%04x",tmpVal);
            sprintf(tmpProtocolPort,"%s,%s\0",tmpnumProtocol,tmpPort);

            LPSTR comma, sptr;
            char Proto[PROTOCOL_NAME_SIZE],Por[PORT_NAME_SIZE],Desc[DESC_LEN],PorHigher[PORT_NAME_SIZE];
            
            while(GetPrivateProfileString(ProxySectionHeader,(LPCSTR) strLHS,
               StrNull, (LPSTR) strRHS, sizeof (strRHS),
                  (LPCSTR) IniInWinForm))
            {
               sptr = (LPSTR) strRHS;

               while (1)
               {
                  if ((comma = strchr (sptr, (int) ',')) != NULL)
                  {
                     *comma = '\0' ;
                     strcpy((LPSTR)Proto, sptr);

                     sptr = comma + 1;

                     if ((comma = strchr (sptr, (int) ',')) != NULL)
                     {
                        *comma = '\0';
                        strcpy((LPSTR)Por, sptr);

                        sptr = comma + 1;

			if(Higher_port != 0) 
			{	
	                      if ((comma = strchr (sptr, (int) ',')) != NULL)
       		              {
                	           *comma = '\0';
	                           strcpy((LPSTR)Desc, sptr);

        	                   sptr = comma + 1;

			 	   if ((comma = strchr (sptr, (int) ',')) != NULL)
				   {
					*comma = '\0';
					strcpy((LPSTR)Desc, sptr);
			
                        	   	sptr = comma + 1;
	                           }
                                   else
                      		   {
					strcpy((LPSTR)Desc, sptr);
        		           }

                        sprintf(tmpstrRHS,"%s,%s\0",Proto,Por);
                        if(!strncmp(tmpstrRHS,tmpProtocolPort,sizeof(tmpstrRHS)))
                        {
				sscanf(tmpPort,"%04x",&tmpVal);
				sprintf(tmpPort,"%u",tmpVal);
			   	if(Higher_port != 0)
                           {
				sscanf (PorHigher, "%04x", &tmpVal) ;
	         		sprintf (PorHigher, "%u", tmpVal) ;
	         		sprintf (tPort, "%s%s(%s,%s)", pFootNote, Desc, tmpPort, PorHigher) ;
                               
			   }	
			   else
			   sprintf(tPort,"%s%s(%s)", pFootNote, Desc, tmpPort);
                           sprintf(tmpPort,"%s",tPort);

                           goto RETLABEL;
                        }
                        else
                           continue;


                	      }
			}
			}
		}
                else
		     break;
		}
			strLHS[1]++;
            }
				/* JeyaSudha 03/01/1998 */
            sscanf(tmpPort,"%04x",&tmpVal);
            sprintf(tmpPort,"$(%u)",tmpVal);
         }
			break;
		}
	}
RETLABEL:	sprintf(ProtocolPort, "%s\t%s", tmpProtocol, tmpPort);
	return ProtocolPort;
}

//Sudha 23rd Oct 97
BOOL Proxy::IsProtocolPortNameInMap(LPCSTR Protocol, LPCSTR Port)
{
	int	index_1, index_2;
   BOOL IsPortFound = FALSE;


	// for all known protocols
	for (index_1 = 0; ProtocolNameNumberMap[index_1].Name; index_1++)
	{
		for (index_2 = 0; (PortNameNumberMap[index_1])[index_2].Name; index_2++)
		{
			//Check if port number is present in PortNameNumberMap
		  	if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Number1))
		  	{
		  		// matching Port number found so copy the name
            IsPortFound = TRUE;
			  	break;
			}
			else if((PortNameNumberMap[index_1])[index_2].NumberOfPorts > 1)
			{
				if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Number2))
				{
					// matching Port number found so copy the name
               IsPortFound = TRUE;
					break;
				}
			}
		}
   }
   return(IsPortFound);
}
//Sudha 23rd Oct 97 
LPSTR Proxy::GetProtocolPortName(LPCSTR Protocol, LPCSTR Port, LPSTR ProtocolPort)
{
   char	tmpProtocol[PROTOCOL_NAME_SIZE],tmpPort[PORT_NAME_SIZE];
   
	strcpy (tmpProtocol, Protocol);		// store these
   strcpy (tmpPort, Port);
   
   sprintf(ProtocolPort, "%s\t%s", tmpProtocol, tmpPort);
	return ProtocolPort;
}

/////////////////////////////////////////////////////////////////////////////
// Given the protocol number and Port number in string form
// get the single line help
//
// Also in put may be like "TCP-<num>" we need to handle this too
//
LPSTR Proxy::GetProtocolPortHelp(LPCSTR Protocol, LPCSTR Port)
{
	int	index_1, index_2;

	// for all known protocols
	for (index_1 = 0; ProtocolNameNumberMap[index_1].Name; index_1++)
	{
		// Check if Protocol number is present in the ProtocolNameNummberMap
		if (( ! strcmpi(Protocol, ProtocolNameNumberMap[index_1].Number1)) ||
			(!strcmpi(Protocol, ProtocolNameNumberMap[index_1].Name)))
		{
			// matching Protocol number found.
			// for all ports known for this protocol
			for (index_2 = 0; (PortNameNumberMap[index_1])[index_2].Name; index_2++)
			{
				//Check if port number is present in PortNameNumberMap
				if (!strcmpi (Port, (PortNameNumberMap[index_1])[index_2].Name))
				{
					// matching Port number found so copy the name
					return (PortNameNumberMap[index_1])[index_2].SingleLineHelp;
				}
			}
			break;
		}
	}
	return "User Defined Port number";
}

/////////////////////////////////////////////////////////////////////////////
// Proxy dialog
Proxy::Proxy(CWnd* pParent /*=NULL*/)
	: CDialog(Proxy::IDD, pParent)
{
	//{{AFX_DATA_INIT(Proxy)
	//}}AFX_DATA_INIT
}

void Proxy::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Proxy)
	DDX_Control(pDX, IDC_PROXY_ANY_APP, m_ProxyAnyApp);
	DDX_Control(pDX, IDC_STATIC1, m_FootNoteWnd);
	DDX_Control(pDX, IDC_STATIC_LINE_HELP, m_LineHelp);
	DDX_Control(pDX, IDC_LIST_PROXY_LIST, m_ProxyListWnd);
	DDX_Control(pDX, IDC_BUTTON_PROXY_EDIT, m_EdtWnd);
	DDX_Control(pDX, IDC_BUTTON_PROXY_DELETE, m_DelWnd);
	DDX_Control(pDX, IDC_BUTTON_PROXY_ADD, m_AddWnd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(Proxy, CDialog)
	//{{AFX_MSG_MAP(Proxy)
	ON_BN_CLICKED(IDC_BUTTON_PROXY_ADD, OnButtonProxyAdd)
	ON_BN_CLICKED(IDC_BUTTON_PROXY_DELETE, OnButtonProxyDelete)
	ON_BN_CLICKED(IDC_BUTTON_PROXY_EDIT, OnButtonProxyEdit)
	ON_BN_CLICKED(IDC_BUTTON_PROXY_HELP, OnButtonProxyHelp)
	ON_LBN_SELCHANGE(IDC_LIST_PROXY_LIST, OnSelchangeProxyList)
	ON_BN_CLICKED(IDC_BUTTON_PROXY_FILTERING, OnButtonProxyFiltering)
	ON_BN_CLICKED(IDC_FTP_PORTS, OnFtpPorts)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Proxy message handlers

void Proxy::OnButtonProxyAdd()
{
	// TODO: Add your control notification handler code here
	m_CurProtocol = StrNull;		//We are going to add (not edit)
	m_CurPort = StrNull;

	PrxAddit PrxAdditDlg(this);		// Create a Add/Edit Dialog

	PrxAdditDlg.DoModal();		//Invoke the dialog
}

BOOL	Proxy::IsEntryUnique(LPCSTR Protocol, LPCSTR Port)
{
	int	index = 0;
	char	NewProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];

	//The list box stores it as names if possible
	GetProtocolPortName(Protocol, Port, NewProtocolPort);
	while(1)
	{
		if (m_ProxyListWnd.GetText(index++, ProtocolPort) != LB_ERR)
		{
			if ( ! strcmpi(ProtocolPort, NewProtocolPort))
				return FALSE;
		}
		else
		{
			break;
		}
	}
	return TRUE;
}
//Sudh 23rd Oct 97
BOOL	Proxy::IsUserEntryUnique(LPCSTR Protocol, LPCSTR Port)
{
	int	index = 0,tmpVal,IntValLo, IntValHi, Proto;
	char	tmpProtocol[PROTOCOL_NAME_SIZE],tmpPort[PORT_NAME_SIZE];
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char  dmy[DESC_LEN],dmy1,dmy2,dmy3,tmpnPort[5],nPort[5],tPort[5];
	char  ErrMsg[50], NewDesc[DESC_LEN], PrevDesc[DESC_LEN],PortName[DESC_LEN]; //Neelu
	int Prot, Porindex=0; //Neelu

// Neelu,22/12/98
	sscanf(Port,"%c%[^(]", &dmy1, NewDesc)  ;
	if(!strcmp(Protocol,"TCP"))
		Prot = 0;
	else
		Prot = 1;
	while(GetPortName(Prot,Porindex,PortName))
	{
		sscanf(PortName,"%[^(]",PrevDesc);
		if(!strcmpi(PrevDesc,NewDesc))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Description already used",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE;
		}	
		Porindex++;
	}
// Neelu,22/12/98


// Neelu
	if(strchr(Port, (int) ','))
		return(IsPortRangeEntryUnique(Protocol,Port));
// Neelu

#if 0   
   sscanf(Port,"%[^(]%c%[^)]%c",dmy,&dmy1,nPort,&dmy2);
   sscanf(nPort,"%d",&tmpVal);
   sprintf(tPort,"%05u",tmpVal);
#endif

// Neelu,4/1/99 
	sscanf(Port,"%c%[^(]%c%[^)]%c", &dmy1, NewDesc,&dmy2, nPort, &dmy3)  ;
	sscanf(nPort,"%d", &tmpVal) ;
// Neelu,4/1/99 

   sprintf(tPort,"%05u",tmpVal);

   if(IsProtocolPortNameInMap(Protocol,tPort))
      return FALSE;
	while(1)
	{
		if (m_ProxyListWnd.GetText(index++, ProtocolPort) != LB_ERR)
		{

         sscanf(ProtocolPort,"%s\t%s",tmpProtocol,tmpPort);

// Neelu,29/12/98
// Neelu, 4/1/99
// Same description should not be used for different ports
			sscanf(tmpPort,"%c%[^(]%c%d", &dmy1, PrevDesc, &dmy1, &IntValLo);
			if((tmpVal != IntValLo) && (!strcmpi(NewDesc,PrevDesc)))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Description already used",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return FALSE;
			}
// Neelu, 4/1/99
// Imran,7/1/99
// Different descriptions for same port should not be used
			if((tmpVal == IntValLo) && (strcmpi(NewDesc,PrevDesc) != 0))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Different Descriptions cannot be used for same port",
								(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return FALSE;
			}
// Imran,7/1/99
			if(!strcmp(tmpProtocol, Protocol))
			{
				sscanf(tmpPort,"%c%[^(]", &dmy1, PrevDesc);
				if(!strcmpi(NewDesc,PrevDesc))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Description already used",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					return FALSE;
				}
			}
// Neelu,22/12/98
// Neelu 
			if(strchr(ProtocolPort, (int) ',' ))
			{
				if(!strcmp(tmpProtocol, Protocol))
				{
					sscanf(tmpPort, "%[^(]%c%[^)]%c", dmy, &dmy1, tmpnPort, &dmy2) ;
				 	sscanf(tmpnPort,"%d%c%d", &IntValLo, &dmy2,&IntValHi);
				 	if((tmpVal >= IntValLo ) && (tmpVal <= IntValHi ))
				 	{
				 		sprintf(ErrMsg,"Duplicate entry.\nCannot Add");
					 	::MessageBox (GetSafeHwnd(), (LPCSTR) ErrMsg,(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return FALSE ;
				 	}
				}
				continue;
			 }
// Neelu


         if(!strcmp(tmpProtocol,Protocol))
         {
            sscanf(tmpPort,"%[^(]%c%[^)]%c",dmy,&dmy1,tmpnPort,&dmy2);
            if(!strcmp(tmpnPort,nPort))
               return FALSE;
         }
      }
		else
		{
			break;
		}
	}
	return TRUE;
}



// Neelu,for port range addition
BOOL	Proxy::IsPortRangeEntryUnique(LPCSTR Protocol, LPCSTR Port)
{
	int	index = 0, IntVal, NewValLo, NewValHi, PrevValLo,PrevValHi ;
	char	tmpProtocol[PROTOCOL_NAME_SIZE], tmpPort[PORT_NAME_SIZE] ,tPort[10] ;
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE] ;
  	char 	dmy[DESC_LEN], dmy1, dmy2, dmy3, dmy4, tmpnPortLo[10], tmpnPortHi[10], LoPort[10], HiPort[10];
	char 	ErrMsg[50], PrevDesc[DESC_LEN], NewDesc[DESC_LEN];

   sscanf(Port,"%c%[^(]%c%[^,]%c%[^)]%c", &dmy1, NewDesc, &dmy2, LoPort, &dmy3, HiPort, &dmy4)  ;
   sscanf(LoPort,"%d", &NewValLo) ;
	sscanf(HiPort,"%d", &NewValHi);
	for(index = NewValLo; index <= NewValHi ; index++)
	{
	   sprintf(tPort, "%05u",  index) ;
   	if(IsProtocolPortNameInMap(Protocol, tPort))
		{
			sprintf(ErrMsg,"A standard Port(%d) is included in the Range.\nCannot Add",index);
		   ::MessageBox (GetSafeHwnd(), (LPCSTR) ErrMsg,(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE ;
		}
	}
	
	index = 0;
   while(1)
   {
  	  if (m_ProxyListWnd.GetText(index++, ProtocolPort) != LB_ERR)
	  {
		   	if(!strstr(ProtocolPort, pFootNote))
					continue;
// Imran,7/1/99 
		  		if(GlbIndex == index)  // When editing,dont compare with the same entry
					continue;
// Imran,7/1/99
 
         	sscanf(ProtocolPort, "%s\t%s", tmpProtocol, tmpPort) ;
// Imran, 4/1/99
// Same description should not be used for different ports
		   	if(strchr(tmpPort, (int) ','))
				{
	        	    sscanf(tmpPort, "%c%[^(]%c%d%c%d%c", &dmy1, &PrevDesc, &dmy2, &PrevValLo, &dmy3, &PrevValHi, &dmy4) ;
					 if(((PrevValLo !=  NewValLo) || (NewValHi != PrevValHi)) &&
					 		(!strcmpi(NewDesc,PrevDesc)))
					 {
					 	::MessageBox (GetSafeHwnd(), (LPCSTR) "Description already used",
								(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return FALSE;
					 }
// Imran,7/1/99
// Different descriptions for same port should not be used
					if(((PrevValLo == NewValLo) && (PrevValHi == NewValHi)) &&
							(strcmpi(NewDesc,PrevDesc) != 0))
							
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Different Descriptions cannot be used for same port",
							(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return FALSE;
					}
// Imran,7/1/99
				}
// Imran, 4/1/99
				 	
         	if(!strcmp(tmpProtocol, Protocol))
				{
// Imran, 22/12/98
					sscanf(tmpPort,"%c%[^(]", &dmy1, PrevDesc);
					if(!strcmpi(NewDesc,PrevDesc))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Description already used",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return FALSE;
					}
// Imran,22/12/98
			   	if(strchr(tmpPort, (int) ','))
					{
            	    sscanf(tmpPort, "%[^(]%c%[^,]%c%[^)]%c", dmy, &dmy1, LoPort, &dmy2, HiPort, &dmy3) ;
						 sscanf(LoPort,"%d", &PrevValLo) ;
					    sscanf(HiPort,"%d", &PrevValHi);
		
            	    if((NewValLo == PrevValLo) || (NewValHi == PrevValHi) || (NewValLo == PrevValHi)
						 		|| (NewValHi == PrevValLo))
						  {
						  	  ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry.Cannot Add",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
								return FALSE ;
						  }
// Imran,22/12/98
						  if(((NewValLo >= PrevValLo) && (NewValLo <= PrevValHi)) ||
								((NewValHi >= PrevValLo) && (NewValHi <= PrevValHi)))
						  {
						  	  ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry.Cannot Add",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
								return FALSE ;
						  }
						  if(((PrevValLo >= NewValLo) && (PrevValLo <= NewValHi)) ||
								((PrevValHi >= NewValLo) && (PrevValHi <= NewValHi)))
						  {
						  	  ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry.Cannot Add",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
								return FALSE ;
						  }
// Imran,22/12/98
					}
					else
					{
            	    sscanf(tmpPort, "%[^(]%c%d%c", dmy, &dmy1, &IntVal, &dmy2);
	   			    if((IntVal >= NewValLo ) && (IntVal <= NewValHi ))
						 {
								sprintf(ErrMsg,"A user defined Port(%d) is included in the Range.\nCannot Add",IntVal);
							   ::MessageBox (GetSafeHwnd(), (LPCSTR) ErrMsg,(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
								return FALSE ;
						 }
					}
				}
  	  }
	  else
		  	break ;
   }
	return TRUE ;
}

// Neelu,for port range addition




BOOL	Proxy::AddEntry(LPCSTR Protocol, LPCSTR Port)
{
	char Str[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	int index;

	if (m_ProxyListWnd.GetCount() >= MAX_NUMBER_OF_APPLICATIONS)
		return FALSE;

	GetProtocolPortName((LPCSTR)Protocol, (LPCSTR)Port, (LPSTR)Str);

	index = m_ProxyListWnd.AddString (Str) ;

	m_ProxyListWnd.SetCurSel(index);
	OnSelchangeProxyList();

	return TRUE;
}

BOOL	Proxy::DeleteEntry(LPCSTR Protocol, LPCSTR Port)
{
	char Str[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	int	DeleteIndex;

	// Form the entry name as in  the list box
	GetProtocolPortName((LPCSTR)Protocol, (LPCSTR)Port, (LPSTR)Str);

	//Get the index of this string. Start serach from first index
	DeleteIndex = m_ProxyListWnd.FindStringExact (0, Str);
	if (DeleteIndex == LB_ERR)
		return FALSE;

	//Delete it
	if ( m_ProxyListWnd.DeleteString (DeleteIndex) == LB_ERR)
		return FALSE;

	if (DeleteIndex)
		m_ProxyListWnd.SetCurSel(DeleteIndex-1);
	else
		m_ProxyListWnd.SetCurSel(DeleteIndex);
	OnSelchangeProxyList();

	return TRUE;
}

void Proxy::OnButtonProxyEdit()
{
	int SelIndex;
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	Protocol[PROTOCOL_NAME_SIZE],Port[PORT_NAME_SIZE];

	// TODO: Add your control notification handler code here
	if ((SelIndex = m_ProxyListWnd.GetCurSel()) == LB_ERR)
		return;
	// Get current selection
	if (m_ProxyListWnd.GetText(SelIndex, ProtocolPort) == LB_ERR)
		return;

	GlbIndex = SelIndex + 1; // Imran,7/11/99

	sscanf(ProtocolPort, "%s\t%[^\0]", Protocol, Port);

	m_CurProtocol = Protocol;
	m_CurPort = Port;

	PrxAddit PrxAdditDlg(this);		// Create a Add/Edit Dialog

	PrxAdditDlg.DoModal();		//Invoke the dialog

//	m_LineHelp.SetWindowText("");	// Remove the single line help also
}

void Proxy::OnButtonProxyDelete()
{
	int SelIndex;

	if ((SelIndex = m_ProxyListWnd.GetCurSel()) == LB_ERR)
		return;
	m_ProxyListWnd.DeleteString (SelIndex);

	if (SelIndex)
		m_ProxyListWnd.SetCurSel(SelIndex-1);
	else
		m_ProxyListWnd.SetCurSel(SelIndex);
	OnSelchangeProxyList();
}

void Proxy::OnButtonProxyHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY, HELP_CONTEXT);
}

BOOL Proxy::OnInitDialog()
{
	int	number_of_entries=0;
	CDialog::OnInitDialog();
 
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
		WindowText.GetBuffer(0),SubHeadingPointer);

	SetWindowText (WindowHeader) ;


        //Set BitMaps

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_BUTTON_PROXY_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!AddBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBitmapBtn.SubclassDlgItem (IDC_BUTTON_PROXY_ADD, this));
	AddBitmapBtn.SizeToContent();

	if (!DelBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Delete bitmap");

	VERIFY (DelBitmapBtn.SubclassDlgItem (IDC_BUTTON_PROXY_DELETE, this));
	DelBitmapBtn.SizeToContent();

	if (!EditBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Edit bitmap");

	VERIFY (EditBitmapBtn.SubclassDlgItem (IDC_BUTTON_PROXY_EDIT, this));
	EditBitmapBtn.SizeToContent();

	if (!FTPBitmapBtn.LoadBitmaps ("FTP1", "FTP2", "FTP3", "FTP3"))
		AfxMessageBox ("Failed to load FTP bitmap");

	VERIFY (FTPBitmapBtn.SubclassDlgItem (IDC_FTP_PORTS, this));
	FTPBitmapBtn.SizeToContent();

	GlbIndex = 0; // Imran,7/1/99

	if (!FilterBmpBtn.LoadBitmaps ("FILT1", "FILT2", "FILT3", "FILT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (FilterBmpBtn.SubclassDlgItem (IDC_BUTTON_PROXY_FILTERING, this));
	FilterBmpBtn.SizeToContent();

/* sudha 17 Aug 1999 */
	char strRHS[50];
	int ctrl_port = 0, data_port = 0;

	GetPrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Control Connection Configurable Number",
		StrNull, (LPSTR) strRHS, sizeof (strRHS),
		(LPCSTR) IniInWinForm);
	
	strcpy(f_ctrl,strRHS); /* ftp control port */
	sscanf(strRHS,"%d",&ctrl_port);

	GetPrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Data Connection Configurable Number",
		StrNull, (LPSTR) strRHS, sizeof (strRHS),
		(LPCSTR) IniInWinForm);

	strcpy(f_data,strRHS); /* ftp data port */
	sscanf(strRHS,"%d",&data_port);

	/* update the list */
	// Get all the current static host entries and add them to
	// the list box
	BYTE	LHSProxyList[60];
	BYTE	RHStr[200];
	BYTE	Protocol[20], Port[20], Higher_port[20];
	int	TabStop = 40;
	int	IntVal,list_index;
        char ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE], szRHS[20];
	LPSTR comma, sptr ;

	/* Added by Ravi on 29 Oct 1998 ... */
	GetPrivateProfileString (ProxySectionHeader, (LPCSTR) "Proxy Any Application",
				StrNull, (LPSTR) szRHS, sizeof (szRHS),
				(LPCSTR) IniInWinForm);

	if ( !strcmp(szRHS, StrEnabled) )
		m_ProxyAnyApp.SetCheck(TRUE) ;
	else	
		m_ProxyAnyApp.SetCheck(FALSE) ;
	/* ... Added by Ravi on 29 Oct 1998 */


	m_ProxyListWnd.SetTabStops (1, (LPINT)&TabStop) ;
	strcpy ((char *) LHSProxyList, ProxyAppsIniString);
	while ( number_of_entries < MAX_NUMBER_OF_APPLICATIONS)
	{
		if (!GetPrivateProfileString (ProxySectionHeader, (LPCSTR) LHSProxyList,
					StrNull, (LPSTR) RHStr, sizeof (RHStr),
							(LPCSTR) IniInWinForm))
		break ;
		sptr = (LPSTR) RHStr;

LOOP1:		while (1)
		{
			if ((comma = strchr (sptr, (int) ',')) != NULL)
			{
				char Str[80] ;		// Store the string which will be displayed.
		   		*comma = '\0' ;
				strcpy((LPSTR)Protocol, sptr);	// Store this

				sptr = comma + 1;

			   if ((comma = strchr (sptr, (int) ',')) != NULL)
				{
			      		*comma = '\0' ;
					strcpy((LPSTR)Port, sptr);		// Store this

					sptr = comma + 1;
				}
				else
				{
					strcpy((LPSTR)Port, sptr);		// Store this
				}

				//In the Ini file Protocol and Port numbers are written
				//as hex. but display is always in decimal. So convert it
				sscanf((LPCSTR)Protocol, "%4x", &IntVal);
				sprintf((LPSTR)Protocol, "%05u", IntVal);
				sscanf((LPCSTR)Port, "%4x", &IntVal);

				sprintf((LPSTR)Port, "%05u", IntVal);
//Sudha 23rd Oct 97
				GetUserProtocolPortName((LPCSTR)Protocol, (LPCSTR)Port, (LPCSTR)Higher_port, (LPSTR)Str);
            list_index = 0;
            while(1)
	         {
               if (m_ProxyListWnd.GetText(list_index++, ProtocolPort) != LB_ERR)
		         {
		            if(strcmp(Str,ProtocolPort))
                     continue;
                  else
                     goto LOOP1;
                }
                else
                   break;
            }

				m_ProxyListWnd.AddString (Str) ;
				number_of_entries++;

				if (number_of_entries == MAX_NUMBER_OF_APPLICATIONS)
					break;
   		}
			else
				break ;
		}
		LHSProxyList[1] ++ ;		// Prepare for reading next entry in ini file.
	}

/* Added By Ravi on 13 Jan 1999 ... */
	number_of_entries = 0;
	strcpy ((char *) LHSProxyList, ProxyAppsInfoIniString);
	while ( number_of_entries < MAX_NUMBER_OF_APPLICATIONS)
	{
		if (!GetPrivateProfileString (ProxySectionHeader, (LPCSTR) LHSProxyList,
					StrNull, (LPSTR) RHStr, sizeof (RHStr),
							(LPCSTR) IniInWinForm))
		break ;
		sptr = (LPSTR) RHStr;


LOOP2:		while (1)
		{
			if ((comma = strchr (sptr, (int) ',')) != NULL)
			{
/* Added By Ravi */	
				char UserDesc[20];
				char ProtPort[200];
/* Added By Ravi */	

	   		*comma = '\0' ;
				strcpy((LPSTR)Protocol, sptr);	// Store this


				sptr = comma + 1;

			   if ((comma = strchr (sptr, (int) ',')) != NULL)
				{
			      		*comma = '\0' ;
					strcpy((LPSTR)Port, sptr);		// Store this

					sptr = comma + 1;
				}

			   if ((comma = strchr (sptr, (int) ',')) != NULL)
				{
			      		*comma = '\0' ;
					strcpy((LPSTR)Higher_port, sptr);		// Store this

					sptr = comma + 1;
				}

			   if ((comma = strchr (sptr, (int) ',')) != NULL)
				{
			      		*comma = '\0' ;
					strcpy((LPSTR)UserDesc, sptr);		// Store this

					sptr = comma + 1;
				}
				else
				{
					strcpy((LPSTR)UserDesc, sptr);		// Store this
				}



				//In the Ini file Protocol and Port numbers are written
				//as hex. but display is always in decimal. So convert it
				sscanf((LPCSTR)Protocol, "%4x", &IntVal);

				if (IntVal == 6) 
				   strcpy((LPSTR)Protocol, "TCP");
			  else
				   strcpy((LPSTR)Protocol, "UDP");

				sscanf((LPCSTR)Port, "%4x", &IntVal);
				sprintf((LPSTR)Port, "%u", IntVal);
				sscanf((LPCSTR)Higher_port, "%4x", &IntVal);
				sprintf((LPSTR)Higher_port, "%u", IntVal);

#if Ravi
				if (Higher_port != 0)
#endif
				if(strcmp((LPSTR)Higher_port, "0"))
	        		 sprintf (ProtPort, "%s\t%s%s(%s,%s)", Protocol, pFootNote, UserDesc, Port, Higher_port);
				else
				   sprintf(ProtPort,"%s\t%s%s(%s)", Protocol, pFootNote, UserDesc,Port);


//Sudha 23rd Oct 97
/*				GetUserProtocolPortName((LPCSTR)Protocol, (LPCSTR)Port, (LPCSTR)Higher_port, (LPSTR)Str); */
#if 0
            list_index = 0;
            while(1)
	         {
               if (m_ProxyListWnd.GetText(list_index++, ProtocolPort) != LB_ERR)
		         {
		            if(strcmp(ProtPort,ProtocolPort))
                     continue;
                  else
                     goto LOOP2;
                }
                else
                   break;
            }
#endif

				m_ProxyListWnd.AddString (ProtPort) ;
				number_of_entries++;					 

				if (number_of_entries == MAX_NUMBER_OF_APPLICATIONS)
					break;
   		}
			else
				break ;
		}
		LHSProxyList[1] ++ ;		// Prepare for reading next entry in ini file.
	}
/* ... Added By Ravi On 13 Jan 1999 */

	//	Update the remove & edit buttons.
	m_DelWnd.EnableWindow (FALSE) ;
	m_EdtWnd.EnableWindow (FALSE) ;

	// Update dialog data.
	UpdateData (FALSE) ;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//////////////////////////////////////////////////////////////////////
// Get entries from the list box. Extract the Protocol number and port
// number. write at most five entries into each string. write multiple
// strings if needed.
void Proxy::OnOK()
{
	int	number_of_entries = 0,number_of_info_entries = 0;
	int no_of_info_entries = 0;
	int	length,IVal,IntVal;
	int	number_of_ports = 0;
	int	list_index = 0;
	char	Protocol[PROTOCOL_NAME_SIZE];
	char	Port[PORT_NAME_SIZE];
   	char    Higher_port[PORT_NAME_SIZE];
   char  Descrptn[DESC_LEN],dmy1,dmy2,dmy3;
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	StrRHS[80], StrLHS[40],StrDescRHS[80],StrDescLHS[40];
   BOOL UserDef = FALSE;

	// TODO: Add extra validation here
	// Update member variabled
	UpdateData (TRUE) ;

	StrRHS[0] = NULL;

	/* Added by Ravi on 29 Oct 1998 ... */
	if(m_ProxyAnyApp.GetCheck())
		strcpy(StrRHS, "enabled");
	else
		strcpy(StrRHS, "disabled");

	WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
		(LPCSTR) "Proxy Any Application", (LPCSTR) StrRHS, (LPCSTR) IniInWinForm) ;


/* sudha 18 Aug 1999 for configurable ftp control & data ports */
	int ctrl_port = 0, data_port = 0, index = 0;

	sscanf(f_ctrl,"%05d", &ctrl_port);
	sscanf(f_data,"%05d", &data_port);

	sprintf(StrRHS,"%d",ctrl_port);
	WritePrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Control Connection Configurable Number",
		(LPCSTR) StrRHS,(LPCSTR) IniInWinForm);

	sprintf(StrRHS,"%d",data_port);
	WritePrivateProfileString (ProxySectionHeader, 
		(LPCSTR) "Proxy Server FTP Data Connection Configurable Number",
		(LPCSTR) StrRHS,(LPCSTR) IniInWinForm);

	sprintf(ftp_name,"FTP(%d,%d)",ctrl_port,data_port);
	sprintf(ftp_Number1,"%05d",ctrl_port);
	sprintf(ftp_Number2,"%05d",data_port);

	while (TCPPortStrings[index].Name) 
 	{
		if(strncmp(TCPPortStrings[index].Name, "FTP", 3) != 0)
		{
			index++;
			continue;
		}
		else
		{
			TCPPortStrings[index].Name = ftp_name;
			TCPPortStrings[index].Number1 = ftp_Number1;
			TCPPortStrings[index].Number2 = ftp_Number2;
			break;
		}
	}

	index = 0;
	while (UDPPortStrings[index].Name) 
 	{
		if(strncmp(UDPPortStrings[index].Name, "FTP", 3) != 0)
		{
			index++;
			continue;
		}
		else
		{
			UDPPortStrings[index].Name = ftp_name;
			UDPPortStrings[index].Number1 = ftp_Number1;
			UDPPortStrings[index].Number2 = ftp_Number2;
			break;
		}
	}
	
	/* ... Added by Ravi on 29 Oct 1998 */

	StrRHS[0] = NULL;

	//First remove all the applications in the ini before writing
	strcpy(StrLHS, ProxyAppsIniString);
   
	while(1)
	{
		if (!GetPrivateProfileString (ProxySectionHeader, (LPCSTR) StrLHS,
					StrNull, (LPSTR) StrRHS, sizeof (StrRHS),
							(LPCSTR) IniInWinForm))
			break ;

		WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
			(LPCSTR) StrLHS, (LPCSTR) NULL, (LPCSTR) IniInWinForm) ;
		StrLHS[1]++;		//update for the next read
	}

	strcpy(StrLHS, ProxyAppsIniString);

	while(1)
	{
		if (m_ProxyListWnd.GetText(list_index++, ProtocolPort) == LB_ERR)
		{
		   //if we have accumulated anything in the StrRHS string
		   //We need to write it off now. Also in such a case
		   if (length = strlen(StrRHS))
			{
			   //There WILL be a ',' at the end which we MUST remove
			   //before writing
				StrRHS[length - 1] = NULL;
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
				  	(LPCSTR) StrLHS, (LPCSTR) StrRHS, (LPCSTR) IniInWinForm) ;
			}
			break;
		}
//Sudha 23rd Oct 97^^^^^
      if(strstr(ProtocolPort, pFootNote))
      {
	 continue; // Ravi
         UserDef = TRUE;
         sscanf(ProtocolPort,"%s\t%c%[^(]%c%[^)]",Protocol,&dmy1,Descrptn,&dmy2,Port);
         if(!strcmp(Protocol,"TCP"))
            strcpy(Protocol,"0006");
         else if(!strcmp(Protocol,"UDP"))
            strcpy(Protocol,"0011");

         sscanf(Port, "%d",&IVal);
         sprintf(Port,"%04x",IVal); 
      }    
      if(!UserDef)
      {
	number_of_ports = GetProtocolPortNumber(ProtocolPort, Protocol, Port, 0);
	sscanf(Protocol, "%d", &IntVal);
	sprintf(Protocol, "%04x",IntVal);
	sscanf(Port, "%d", &IntVal);
	sprintf(Port, "%04x",IntVal);
      }
      else
         UserDef = FALSE;
//Sudha ^^^^^
      AddOneMore:
		number_of_entries++;		//got one more entry;
		//The <Protocol,Port> has to be written as hex values and display
	   //is decimal. So convert it


		strcat(StrRHS, Protocol);
		strcat(StrRHS, ",");
		strcat(StrRHS, Port);

		if ((number_of_entries % MAX_PROXY_ENTRIES_IN_ONE_INI) == 0)
		{
		   WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
		      (LPCSTR) StrLHS, (LPCSTR) StrRHS, (LPCSTR) IniInWinForm) ;
		   StrLHS[1]++;			//update to next index
		   StrRHS[0] = NULL;
		}
		else
		{
		   strcat(StrRHS, ",");  //the next pair must be separated by a ','
		}
		if (number_of_ports > 1)
		{
		   GetProtocolPortNumber(ProtocolPort, Protocol, Port, 1);
		   number_of_ports = 0;		// there can be at most 2 ports
        	   sscanf(Protocol, "%d", &IntVal);
		   sprintf(Protocol, "%04x",IntVal);
		   sscanf(Port, "%d", &IntVal);
		   sprintf(Port, "%04x",IntVal);
		   goto AddOneMore;
		}
   }
#if 0   
   wsprintf(StrRHS,"%d",number_of_entries);
   WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
      (LPCSTR) "Proxy Server Number of Applications",
      (LPCSTR) StrRHS, (LPCSTR) IniInWinForm) ;
#endif   
     //Writing user defined port descriptions in roucon.ini file
   StrDescRHS[0] = NULL;

   //First remove all the applications in the ini before writing
   strcpy(StrDescLHS, ProxyAppsInfoIniString);

   while(1)
	{
		if (!GetPrivateProfileString (ProxySectionHeader, (LPCSTR) StrDescLHS,
			StrNull, (LPSTR) StrDescRHS, sizeof (StrDescRHS),
		  		(LPCSTR) IniInWinForm))
			break ;

		WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
			(LPCSTR) StrDescLHS, (LPCSTR) NULL, (LPCSTR) IniInWinForm) ;
		StrDescLHS[1]++;		//update for the next read
	}
   strcpy(StrDescLHS, ProxyAppsInfoIniString) ;
   list_index = 0;
   int IntVal1;	// Neelu

   while(1)
   {
      if (m_ProxyListWnd.GetText(list_index++, ProtocolPort) == LB_ERR)
	   {
		   //if we have accumulated anything in the StrDescRHS string
		   //We need to write it off now. Also in such a case
		   if (length = strlen(StrDescRHS))
			{ 
			   //There WILL be a ',' at the end which we MUST remove
			   //before writing
				StrDescRHS[length - 1] = NULL;
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
				 	(LPCSTR) StrDescLHS, (LPCSTR) StrDescRHS, (LPCSTR) IniInWinForm) ;
			}
			break;
		}
      if(strstr(ProtocolPort, pFootNote))
      {
         UserDef = TRUE;
         sscanf(ProtocolPort,"%s\t%c%[^(]%c%[^)]",Protocol,&dmy1,Descrptn,&dmy2,Port);
         no_of_info_entries++;
         if(!strcmp(Protocol,"TCP"))
            strcpy(Protocol,"0006");
         else if(!strcmp(Protocol,"UDP"))
            strcpy(Protocol,"0011");

//         sscanf(Port, "%d",&IVal);
//         sprintf(Port,"%04x",IVal);

				if(strchr(Port,(int) ','))
				{
	 				sscanf(Port, "%d%c%d",&IVal,&dmy1,&IntVal1);
                			sprintf(Higher_port,"%04x",IntVal1);
              
				}
	 			else
	 			{
         				sscanf(Port,"%d",&IVal);    
	 				sprintf(Higher_port,"%04x",0);
				}	
         				sprintf(Port,"%04x",IVal);

            
         strcat(StrDescRHS, Protocol);
         strcat(StrDescRHS,",");
         strcat(StrDescRHS,Port);
         strcat(StrDescRHS,",");
	 strcat(StrDescRHS,Higher_port);
	 strcat(StrDescRHS,",");
	 strcat(StrDescRHS, Descrptn);

         if ((no_of_info_entries % MAX_INFO_ENTRIES_IN_ONE_INI) == 0)
		   {
		      WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
			      (LPCSTR) StrDescLHS, (LPCSTR) StrDescRHS, (LPCSTR) IniInWinForm) ;
			   StrDescLHS[1]++;			//update to next index
			   StrDescRHS[0] = NULL;
		   }
		   else
		   {
			   strcat(StrDescRHS, ",");  //the next pair must be separated by a ','
		   }
      }
   }
   //Write the number of user defined descriptions 

   wsprintf(StrDescRHS,"%d",number_of_entries + number_of_info_entries);
   WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
      (LPCSTR) "Proxy Server Number of Applications",
      (LPCSTR) StrDescRHS, (LPCSTR) IniInWinForm) ;
   
   
   wsprintf(StrDescRHS,"%d",no_of_info_entries);
   WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
      (LPCSTR) "Proxy Server User Defined Description",
     		(LPCSTR) StrDescRHS, (LPCSTR) IniInWinForm) ;

	CDialog::OnOK();
}

LPCSTR Proxy::GetOneLineMessage()
{
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	Protocol[PROTOCOL_NAME_SIZE];
	char	Port[PORT_NAME_SIZE];
	int	SelIndex;

	// TODO: Add your control notification handler code here
	if ((SelIndex = m_ProxyListWnd.GetCurSel()) == LB_ERR)
		return "";
	// Get current selection
	if (m_ProxyListWnd.GetText(SelIndex, ProtocolPort) == LB_ERR)
		return "";

	sscanf(ProtocolPort, "%s\t%[^\0]", Protocol, Port);

	return GetProtocolPortHelp(Protocol, Port);
}

void Proxy::OnSelchangeProxyList()
{
	int	number_of_sels = 0;
	int	Selection;
	char	ProtocolPortName[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	// TODO: Add your control notification handler code here

	m_LineHelp.SetWindowText("");
	if ( (Selection = m_ProxyListWnd.GetCurSel()) != LB_ERR)
		number_of_sels = 1;
	if (number_of_sels == 0)
	{
		//Disable Edit and delete Button
		m_EdtWnd.EnableWindow (FALSE) ;
		m_DelWnd.EnableWindow (FALSE) ;
	}
	else if (number_of_sels == 1)
	{
		//Enable Edit and delte Buttons
		m_ProxyListWnd.GetText(Selection, ProtocolPortName);
		if (strstr(ProtocolPortName, pFootNote))	//Editing only for user defined
			m_EdtWnd.EnableWindow (TRUE) ;
		else
			m_EdtWnd.EnableWindow (FALSE) ;

		m_DelWnd.EnableWindow (TRUE) ;
		m_LineHelp.SetWindowText(GetOneLineMessage());
	}
}

void Proxy::OnButtonProxyFiltering()
{
	// TODO: Add your control notification handler code here
	CPrxfilt prxfilt;
	prxfilt.DoModal();
}

void Proxy::OnFtpPorts()
{
	// TODO: Add your control notification handler code here
	CFtpPorts ftp;
	ftp.DoModal();
	
}
