// -------------------------------------------------------------------------
// Project Name		:	PSetup for MTRouter Setup for Windows 
// File Name         :	LOCPORT.CPP
// Description       :	Defines Class :
//									CLocalPortDlg	: Function of Port Setup Dialog.
// Start Date        :	4th Oct 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "psetup.h"
#include "locport.h"

#include "stdlib.h"    // cfp
#include "string.h"    // cfp

LPCSTR	SECTION_HEADER		 = "Port Setup";
LPCSTR	INIT_STR				 = "Modem Init String";
LPCSTR	COMM_TYPE			 = "Communication Type";
LPCSTR	PORT_STR				 = "Select Port";
LPCSTR	CONNECT_STR			 = "Modem Connect Response";
LPCSTR	DIAL_STR				 = "Modem Dial String";
LPCSTR	INIT_RES_STR		 = "Modem Init Response";
LPCSTR	HANG_STR				 = "Modem Hangup String";
LPCSTR	ROUTER_IP_ADDR		 = "Router IP Address";

LPCSTR   IP_ADDRESSES       = "IP Addresses" ;  // cfp
LPCSTR   NO_OF_IP_ADDRESSES = "No Of IP Addresses" ;  // cfp

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLocalPortDlg dialog


CLocalPortDlg::CLocalPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLocalPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLocalPortDlg)
	m_Port = "";
	m_ConnectResponse = "";
	m_DialString = "";
	m_InitString = "";
	m_InitResponse = "";
	m_HangupString = "";
	m_IPAddr = "";
	//}}AFX_DATA_INIT
}

void CLocalPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLocalPortDlg)
	DDX_Control(pDX, IDC_COMBO2, m_cboxIPAddrWnd);
	DDX_Control(pDX, IDC_STATIC_NOTE_TEXT, m_NoteText);
	DDX_Control(pDX, IDC_STATIC_NOTE, m_Note);
	DDX_Control(pDX, IDC_RADIO_TFTP, m_RadioTFTP);
	DDX_Control(pDX, IDC_RADIO_COM, m_RadioCom);
	DDX_Control(pDX, IDC_STATIC_IP_ADDR_HDR, m_IPAddrHdrWnd);
	DDX_Control(pDX, IDC_MODEM_TXT, m_ModemText);
	DDX_Control(pDX, IDC_RESPONSE, m_InitRespWnd);
	DDX_Control(pDX, IDC_INIT_STRING, m_InitStrWnd);
	DDX_Control(pDX, IDC_HANG_UP, m_HangWnd);
	DDX_Control(pDX, IDC_DIAL_STRING, m_DialStrWnd);
	DDX_Control(pDX, IDC_CONNECT_RESPONSE, m_ConnectWnd);
	DDX_Control(pDX, IDC_INIT_STR_TXT, m_InitStrText);
	DDX_Control(pDX, IDC_INIT_RESP_TXT, m_InitRespText);
	DDX_Control(pDX, IDC_HANG_TXT, m_HangText);
	DDX_Control(pDX, IDC_DIAL_TXT, m_DialText);
	DDX_Control(pDX, IDC_CONNECT_TXT, m_ConnectText);
	DDX_Control(pDX, IDC_PORT_TEXT, m_PortText);
	DDX_Control(pDX, IDC_COMBO1, m_PortWnd);
	DDX_CBString(pDX, IDC_COMBO1, m_Port);
	DDV_MaxChars(pDX, m_Port, 4);
	DDX_Text(pDX, IDC_CONNECT_RESPONSE, m_ConnectResponse);
	DDV_MaxChars(pDX, m_ConnectResponse, 20);
	DDX_Text(pDX, IDC_DIAL_STRING, m_DialString);
	DDV_MaxChars(pDX, m_DialString, 20);
	DDX_Text(pDX, IDC_INIT_STRING, m_InitString);
	DDV_MaxChars(pDX, m_InitString, 40);
	DDX_Text(pDX, IDC_RESPONSE, m_InitResponse);
	DDV_MaxChars(pDX, m_InitResponse, 20);
	DDX_Text(pDX, IDC_HANG_UP, m_HangupString);
	DDX_CBString(pDX, IDC_COMBO2, m_IPAddr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLocalPortDlg, CDialog)
	//{{AFX_MSG_MAP(CLocalPortDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_RADIO_COM, OnRadioCom)
	ON_BN_CLICKED(IDC_RADIO_TFTP, OnRadioTftp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLocalPortDlg message handlers

BOOL CLocalPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
   CenterWindow();

	char OldWindowTitle[80] ;
	GetWindowText (OldWindowTitle, sizeof (OldWindowTitle)) ;

	char *Hyphen ;
	Hyphen = strchr (OldWindowTitle, (int) '-') ;
	Hyphen += 2 ;

	char szProdName[25] ;
	char NewWindowTitle[80] ;
	GetPrivateProfileString (SECTION_HEADER, (LPCSTR) "Application Name",
			(LPCSTR) "Router", (LPSTR) szProdName, sizeof (szProdName),
	 					  (LPCSTR) OwnIniFile) ;

	strcpy (NewWindowTitle, szProdName) ;
	strcat (NewWindowTitle, " - ") ;
	strcat (NewWindowTitle, Hyphen) ;
	SetWindowText (NewWindowTitle) ;

//Get the values of parameters
   char szBuf[50];
	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) INIT_STR,
					(LPCSTR) "ATS0=1&E5",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_InitString = szBuf;

	GetIPAddressListFromIni() ;			// cfp
	
/*	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) ROUTER_IP_ADDR,
					(LPCSTR) "0.0.0.0",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_IPAddr = szBuf;
	m_cboxIPAddrWnd.AddString ((LPCSTR) m_IPAddr) ; 
	CheckForDuplicates() ;   cfp */

	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) PORT_STR,
					(LPCSTR) "COM1",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_Port = szBuf;
	GetPrivateProfileString((LPCSTR) SECTION_HEADER, COMM_TYPE,
					(LPCSTR) "COM1",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	if ( !strcmp(szBuf, "IP")) {
		m_RadioTFTP.SetCheck(1);
		m_RadioCom.SetCheck(0);
		SetButtonStates(FALSE);
	} else {
		m_RadioTFTP.SetCheck(0);
		m_RadioCom.SetCheck(1);
		SetButtonStates(TRUE);
	}

    GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) CONNECT_STR,
					(LPCSTR) "CONNECT",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_ConnectResponse = szBuf;

	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) DIAL_STR,
					(LPCSTR) "ATDP",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_DialString = szBuf;

	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) INIT_RES_STR,
					(LPCSTR) "OK",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_InitResponse = szBuf;

	GetPrivateProfileString((LPCSTR) SECTION_HEADER, (LPCSTR) HANG_STR,
					(LPCSTR) "~~~+++~~~ATH0",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_HangupString = szBuf;
	
//Update the Dialog Box fields.
	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLocalPortDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	UpdateData (TRUE) ;
	if (m_RadioTFTP.GetCheck())
	{
	   if (!m_IPAddr.IsValid() || !strlen(m_IPAddr))
		{
			MessageBox ("Invalid Router IP address.\n\
Please refer Help for example.", "Router Port Setup",
												MB_ICONINFORMATION | MB_OK) ;
			m_cboxIPAddrWnd.SetFocus() ;
			return ;
  		}
	}

	// Write the Parameters to INI file
	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) PORT_STR, (LPCSTR) m_Port, (LPCSTR) OwnIniFile) ;
	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) ROUTER_IP_ADDR, (LPCSTR) m_IPAddr, (LPCSTR) OwnIniFile) ;

	CString CTemp ;
	if (m_RadioCom.GetCheck())
		CTemp = "Serial" ;
	else
		CTemp = "IP" ;
	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
			COMM_TYPE, (LPCSTR) CTemp, (LPCSTR) OwnIniFile) ;

   WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) INIT_STR, (LPCSTR) m_InitString, (LPCSTR) OwnIniFile) ;

	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) CONNECT_STR, (LPCSTR) m_ConnectResponse, (LPCSTR) OwnIniFile) ;

	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) DIAL_STR, (LPCSTR) m_DialString, (LPCSTR) OwnIniFile) ;

	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) INIT_RES_STR, (LPCSTR) m_InitResponse, (LPCSTR) OwnIniFile) ;
					
	WritePrivateProfileString ((LPCSTR) SECTION_HEADER,
		(LPCSTR) HANG_STR, (LPCSTR) m_HangupString, (LPCSTR) OwnIniFile) ;

	WriteIPAddressesToIni() ; // cfp

	CDialog::OnOK() ;
}

void CLocalPortDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PORT_SETUP,HELP_CONTEXT);
	
}

void CLocalPortDlg::SetButtonStates(BOOL PortIsCOM)
{
	if (PortIsCOM) {
		// If PortIsCOM then disable IP Address field
		m_IPAddrHdrWnd.EnableWindow(FALSE);
		m_cboxIPAddrWnd.EnableWindow(FALSE);
		m_ModemText.EnableWindow(TRUE);
		m_InitRespWnd.EnableWindow(TRUE);
		m_InitStrWnd.EnableWindow(TRUE);
		m_HangWnd.EnableWindow(TRUE);
		m_DialStrWnd.EnableWindow(TRUE);
		m_ConnectWnd.EnableWindow(TRUE);
		m_InitStrText.EnableWindow(TRUE);
		m_InitRespText.EnableWindow(TRUE);
		m_HangText.EnableWindow(TRUE);
		m_DialText.EnableWindow(TRUE);
		m_ConnectText.EnableWindow(TRUE);
		m_PortText.EnableWindow(TRUE);
		m_PortWnd.EnableWindow(TRUE);
		m_Note.EnableWindow(TRUE);
		m_NoteText.EnableWindow(TRUE);

	} else {
		// Otherwise enable only IP Address
		m_IPAddrHdrWnd.EnableWindow(TRUE);
		m_cboxIPAddrWnd.EnableWindow(TRUE);
		m_ModemText.EnableWindow(FALSE);
		m_InitRespWnd.EnableWindow(FALSE);
		m_InitStrWnd.EnableWindow(FALSE);
		m_HangWnd.EnableWindow(FALSE);
		m_DialStrWnd.EnableWindow(FALSE);
		m_ConnectWnd.EnableWindow(FALSE);
		m_InitStrText.EnableWindow(FALSE);
		m_InitRespText.EnableWindow(FALSE);
		m_HangText.EnableWindow(FALSE);
		m_DialText.EnableWindow(FALSE);
		m_ConnectText.EnableWindow(FALSE);
		m_PortText.EnableWindow(FALSE);
		m_PortWnd.EnableWindow(FALSE);
		m_Note.EnableWindow(FALSE);
		m_NoteText.EnableWindow(FALSE);
	}
}

void CLocalPortDlg::OnRadioCom()
{
	// TODO: Add your control notification handler code here
	SetButtonStates(TRUE);
}

void CLocalPortDlg::OnRadioTftp()
{
	// TODO: Add your control notification handler code here
	SetButtonStates(FALSE);
}

// cfp
void CLocalPortDlg::GetIPAddressListFromIni (void) 
{
	char szBuf[50] ;
	char szBuf1[15] ;

	// Clear all the strings in the list box of the drop-down-combo-box
	m_cboxIPAddrWnd.ResetContent();

	// Get the previous IP address from the setup.ini file
	GetPrivateProfileString ((LPCSTR) SECTION_HEADER,
			(LPCSTR) ROUTER_IP_ADDR, (LPCSTR) "128.2.3.4",
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
	m_IPAddr = szBuf ;

	int i = 0 ;	
	while (TRUE)
	{
		sprintf (szBuf1, "IPAddr%d", i + 1) ;	// like IPAddr1, IPAddr2, etc.
		GetPrivateProfileString ((LPCSTR) IP_ADDRESSES, (LPCSTR) szBuf1,
			(LPCSTR) "", (LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		if (!szBuf[0])
			break ;
		m_cboxIPAddrWnd.AddString ((LPCSTR) szBuf) ;
		i ++ ;
	}
	return ;
}

// cfp
void CLocalPortDlg::WriteIPAddressesToIni (void) 
{
	char szBuf[3 + 1 + 3 + 1 + 3 + 1 + 3 + 2] ;
	char szBuf1[15] ;
	
	// First clear the IP Addresses section
	WritePrivateProfileString (IP_ADDRESSES, (LPCSTR) NULL,
			(LPCSTR) "", (LPCSTR) OwnIniFile) ;
	int NoOfItems = m_cboxIPAddrWnd.GetCount() ;
	for (int i = 0 ; i < NoOfItems ; i ++)
	{
		m_cboxIPAddrWnd.GetLBText (i, (LPSTR) szBuf) ;
		sprintf (szBuf1, "IPAddr%d", i + 1) ;
		// Check for Duplicate Strings
		if (!strcmpi (szBuf, m_IPAddr))
		{
			m_cboxIPAddrWnd.DeleteString (i) ;
			i -- ;
			NoOfItems -- ;
			continue ;
		}	
		WritePrivateProfileString (IP_ADDRESSES, (LPCSTR) szBuf1,
				(LPCSTR) szBuf, (LPCSTR) OwnIniFile) ;
	}
	// Copy the newly edited IP Address into INI file
	sprintf (szBuf1, "IPAddr%d", i + 1) ;
	WritePrivateProfileString (IP_ADDRESSES, (LPCSTR) szBuf1,
			(LPCSTR) m_IPAddr, (LPCSTR) OwnIniFile) ;
	return ;
}
