// -------------------------------------------------------------------------
// Project Name		:	PSetup for MTRouter Setup for Windows 
// File Name         :	LOCPORT.CPP
// Description       :	Defines Class :
//								CLocalPortDlg	: Function of Port Setup Dialog.
// Start Date        :	4th Oct 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "psetup.h"
#include "ctl3d.h"

#include "mainfrm.h"
#include "psetdoc.h"
#include "psetvw.h"
#include "locport.h"

// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------

char OwnIniFile[128];			// configuration ini file "SETUP.INI"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPSetupApp

BEGIN_MESSAGE_MAP(CPSetupApp, CWinApp)
	//{{AFX_MSG_MAP(CPSetupApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPSetupApp construction

CPSetupApp::CPSetupApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPSetupApp object

CPSetupApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CPSetupApp initialization

BOOL CPSetupApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// If Not 1st Instance
	if (m_hPrevInstance != NULL)
	{
		HWND hWnd, hChildWnd;

		// Find the Handle of Parent window
		hWnd = ::FindWindow((LPCSTR) NULL,
							(LPCSTR) m_pszAppName) ;
		// Get the last of the child windows that was active
		hChildWnd = ::GetLastActivePopup(hWnd);
		// Make it active
		::SetActiveWindow(hChildWnd);
		// Return false to make InitInstance fail
		return FALSE;
	}
	
	int   length ; 
   char  *ptr ;

   length = GetModuleFileName (m_hInstance, OwnIniFile, 128) ;
   ptr = &OwnIniFile[length] ;
   while (*ptr != '\\')
   	ptr -- ;
    *(ptr+1) = NULL ;
    /* create all the ini File names */
    _fstrcat (OwnIniFile, LocalINI) ;

    Ctl3dRegister (m_hInstance) ;
    Ctl3dAutoSubclass (m_hInstance) ;

	LoadStdProfileSettings() ;  // Load standard INI file options
										 //	(including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

#if 0
	CSingleDocTemplate *pDocTemplate ;
	pDocTemplate = new CSingleDocTemplate (
										IDR_MAINFRAME,
										RUNTIME_CLASS(CPSetupDoc),
										RUNTIME_CLASS(CMainFrame), // main SDI frame
																			// window
										RUNTIME_CLASS(CPSetupView)
							 ) ;
	AddDocTemplate (pDocTemplate) ;
#endif

	// create main window
	CMainFrame *p_MainFrame = new CMainFrame ;
	if (!p_MainFrame->LoadFrame (IDR_MAINFRAME))
		return FALSE ;
	m_pMainWnd = p_MainFrame ;

	((CWnd *) p_MainFrame)->CenterWindow() ;

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

//Display the dialog for port setup.
	CLocalPortDlg cPortDlg ((CWnd *) p_MainFrame) ;
	cPortDlg.DoModal() ;

//Send the Message to exit.
	((CWnd *) p_MainFrame)->SendMessage (WM_CLOSE) ;

	return TRUE ;
}


int CPSetupApp::ExitInstance()
{
	// Check made to see that Unregistering does not
	// take place for instances other than 1st
	if (m_hPrevInstance == NULL)
		Ctl3dUnregister (m_hInstance) ;
	return (CWinApp::ExitInstance()) ;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg() ;

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CPSetupApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CPSetupApp commands
