// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	REBOOT.CPP
// Description       :	Defines CReboot Class which displays Rebooting 
//								Message.
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "reboot.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReboot dialog


CReboot::CReboot(CWnd* pParent /*=NULL*/)
	: CDialog(CReboot::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReboot)
	m_reboot = "";
	//}}AFX_DATA_INIT
	Create(IDD,pParent);
	CenterWindow();
	ShowWindow(SW_SHOW);
}

void CReboot::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReboot)
	DDX_Text(pDX, IDC_STATIC_REBOOT, m_reboot);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CReboot, CDialog)
	//{{AFX_MSG_MAP(CReboot)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CReboot message handlers

void CReboot::OnDestroy()
{
	CDialog::OnDestroy();
	
	ReleaseCapture();
	
}

BOOL CReboot::OnInitDialog()
{
	CDialog::OnInitDialog();

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

/* brindha on 17/8/99 & 18/8/99. */
	if (boot_upgraded)
   {
        if (firewall_upgraded)
		     m_reboot.LoadString(MSG_PWN_DNLD_BOOT_REBT) ;
        else
        {     
		     m_reboot.LoadString(MSG_PWN_DNLD_BOOT_WAIT) ;
             boot_upgraded = 0 ;
        }
   }
	else
		m_reboot.LoadString(MSG_PWN_DNLD_CODE_REBT) ;

	UpdateData(FALSE) ;

	SetCapture() ;
	
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

