/*--------------------------------------------------------------------------*/
/*	File		:	CONDNS.C												*/
/*	Purpose		:	This file contains conditional statement routines.		*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#include	"windows.h"

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

#include	<string.h>
#include	<stdlib.h>

/*--------------------------------------------------------------------------*/
/*	Name		:	PifStatement											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <if_statement>									*/
/*--------------------------------------------------------------------------*/

int		PifStatement(CodeTypeFptr *c_ptr)
{
	byte	else_label[LABEL_NAME_LEN];
	byte	endif_label[LABEL_NAME_LEN];
	ExprNodeType	*expr_ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	GetToken();
	c_ptr1 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	Pexpression(&expr_ptr);
	if (expr_ptr) {
		/*	Check if expression is of integer/real type.	*/
		switch (expr_ptr->ExprType) {
			case E_INTEGER :
			case E_INT_CONST :
			case E_REAL :
			case E_REAL_CONST :
				break;
			default :
				Error(ERR_EXP_INT_REAL_EXPECTED);
		}
		TempVarCount = 0;	/*	Reset temporaries count.	*/
		EmitExpression(expr_ptr, &c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		/*	Save expression value in global and kill temporaries.	*/
		c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType, expr_ptr->Name,
					expr_ptr->ExprType, 0, PreDefVars[CONDN_VARIABLE].VarName);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);

		KillTemporaries(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		/*	Generate code to jump to else part if expression is zero.	*/
		GenerateLabelName(else_label);
		c_ptr2 = EmitCode(Q_JZ, expr_ptr->ExprType,
						PreDefVars[CONDN_VARIABLE].VarName, 0, 0, else_label);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		ReleaseNodes(expr_ptr);
	}
	if (Token == Q_THEN)
		GetToken();
	else {
		Error(ERR_THEN_EXPECTED);
		goto error_exit;
	}
	PstatementList(&c_ptr2);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	if (Token == Q_ELSE) {
		/*	Generate code to jump to end of IF statement at the end of	*/
		/*	THEN part of the IF statement.	*/
		GenerateLabelName(endif_label);
		c_ptr2 = EmitCode(Q_JMP, 0, endif_label, 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		/*	Generate the label for beginning of ELSE part of IF statement.	*/
		c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, else_label, 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		GetToken();
		PstatementList(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, endif_label, 0, 0, 0);
	}
	else {
		/*	Optional ELSE part was not given, so generate code to mark	*/
		/*	end of IF statement.	*/
		c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, else_label, 0, 0, 0);
	}
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	*c_ptr = c_ptr1;
	if (Token == Q_ENDIF)
		GetToken();
	else {
		Error(ERR_ENDIF_EXPECTED);
		goto error_exit;
	}
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PswitchStatement										*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <switch_statement>								*/
/*--------------------------------------------------------------------------*/

int		PswitchStatement(CodeTypeFptr *c_ptr)
{
	byte	table_label[LABEL_NAME_LEN];	/*	Cmp and jump table label.	*/
	byte	endswitch_label[LABEL_NAME_LEN];
	byte	case_label[LABEL_NAME_LEN];
	byte	default_label[LABEL_NAME_LEN];
	byte	dontcare;	/*	Whether it is a case or default statement.	*/
	int		case_type;	/*	Type of case constant.	*/
	int		expr_type;	/*	Type of switch expression.	*/
	int		no_of_defaults;	/*	Number of default statements.	*/
/*	byte	*expr_name;		Name of variable which has expression value.	*/
	ExprNodeType	*expr_ptr;
	CodeTypeFptr	c_ptr1;	/*	Pointers to build code for various cases.	*/
	CodeTypeFptr	c_ptr2;
	CodeTypeFptr	c_ptr3;	/*	Pointers to build compare and jump table.	*/
	CodeTypeFptr	c_ptr4;
	CodeTypeFptr	c_ptr5;	/*	Pointer to look for duplicate case	*/
							/*	constants in compare and jump table.	*/

	*c_ptr = c_ptr1 = c_ptr2 = c_ptr3 = c_ptr4 = c_ptr5 = 0;
/*	expr_name = 0; */
	expr_ptr = 0;
	no_of_defaults = 0;
	GenerateLabelName(table_label);	/*	Get a compare and jump table label.	*/
	GenerateLabelName(endswitch_label);
	c_ptr1 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	GetToken();
	Pexpression(&expr_ptr);
	if (expr_ptr) {
		/*	Switch expression must evaluate to an integer or string.	*/
		if (expr_ptr->ExprType != E_INTEGER && expr_ptr->ExprType != E_STRING)
			Error(ERR_SWITCH_EXPRESSION);
		TempVarCount = 0;	/*	Reset temporaries count.	*/
		EmitExpression(expr_ptr, &c_ptr2);

		/*	Remember the expression type and the name of the variable in	*/
		/*	which the expression value is stored and release the expr tree.	*/
		expr_type = expr_ptr->ExprType;
		/*	Save expression value in global and kill temporaries.	*/
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType, expr_ptr->Name,
										expr_ptr->ExprType, 0,
										PreDefVars[CONDN_VARIABLE].VarName);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		KillTemporaries(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		ReleaseNodes(expr_ptr);
	}
	/*	Generate a jump to the compare and jump table label.	*/
	c_ptr2 = EmitCode(Q_JMP, 0, table_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	while (Token == Q_CASE || Token == Q_DEFAULT) {
		c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		dontcare = (byte) (Token == Q_DEFAULT);	/*	Case or default ?	*/
		if (Token == Q_CASE) {
			GetToken();
			if (Token == Q_INT_CONST || Token == Q_STRING_CONST) {
				switch (Token) {
					case Q_INT_CONST : case_type = E_INTEGER; break;
					case Q_STRING_CONST : case_type = E_STRING; break;
				}
				if (expr_type != case_type)
					Error(ERR_CASE_TYPE_CONFLICT);
			}
			else { 
				/*	Only integer or string constants are allowed.	*/
				Error(ERR_CASE_CONSTANT);
			}
		}
		else {
			if (no_of_defaults)	/*	Only one default statement allowed.	*/
				Error(ERR_MORE_THAN_ONE_DEFAULT);
			no_of_defaults++;
		}
		/*	Generate the case/default label name.	*/
		GenerateLabelName(case_label);
		c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, case_label, 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		if (!dontcare) {
			/*	Check for duplicate case constants.	*/
			for (c_ptr5 = c_ptr3; c_ptr5; c_ptr5 = c_ptr5->NextCode) {
				if (!strcmp(c_ptr5->Arg1, TokenStr)) {
					Error(ERR_DUPLICATE_CASE_CONSTANT);
					break;
				}
			}
			/*	Change the case label to the corresponding constant type.	*/
			switch (case_type) {
				case E_INTEGER : case_type = E_INT_CONST; break;
				case E_STRING : case_type = E_STRING_CONST; break;
			}
			/*	Generate instruction to compare and jump.	*/
			c_ptr4 = EmitCode(Q_JEQ, expr_type,
									PreDefVars[CONDN_VARIABLE].VarName,
									case_type, TokenStr, case_label);
			c_ptr3 = MergeCodes(c_ptr3, c_ptr4);
		}
		else {
			/*	Remember the default label for now. At the end of the jump	*/
			/*	table add the unconditional jump to the default label.	*/
			strcpy(default_label, case_label);
		}
		GetToken();
		PstatementList(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		if (Token == Q_ENDCASE)
			GetToken();
		else {
			Error(ERR_ENDCASE_EXPECTED);
			goto error_exit;
		}
		/*	Generate jump to statement after endswitch.	*/
		c_ptr2 = EmitCode(Q_JMP, 0, endswitch_label, 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	}
	/*	Generate the compare and jump table label.	*/
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, table_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	if (no_of_defaults) {
		/*	Default given, generate an unconditional jump for that label.	*/
		c_ptr4 = EmitCode(Q_JMP, 0, default_label, 0, 0, 0);
		c_ptr3 = MergeCodes(c_ptr3, c_ptr4);
	}
	/*	Append the code for the compare and jump table now.	*/
	c_ptr1 = MergeCodes(c_ptr1, c_ptr3);
	/*	Generate label to signal endswitch.	*/
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, endswitch_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	*c_ptr = c_ptr1;

#if 0
	if (expr_name) {
#ifndef WIN
		free(expr_name);
#else
		LocalFree(expr_name);
#endif
		expr_name = 0;
	}
#endif
	if (Token == Q_ENDSWITCH)
		GetToken();
	else {
		Error(ERR_ENDSWITCH_EXPECTED);
		goto error_exit;
	}
	return(0);

	error_exit :

#if 0
	if (expr_name)
#ifndef WIN
		free(expr_name);
#else
		LocalFree(expr_name);
#endif
#endif

	return(-1);
}
