/* ------------------------------------------------------------------------
	File		:	DLGBOX.H
	Synopsis	:	Modifies the dialog control colors and draws borders
					for Listbox, Edit controls and group box.
					This file has to be included by all applications
					using the DLG module.
	Author		:	Srinivasan S
	Date		:	20 Apr 1993
 ----------------------------------------------------------------------- */
/* Files need include only dlgbox.h */
#include <commdlg.h>

/* Global PUSH BUTTON ids used in dialog boxes */
#define	OURIDOK			1000
#define	OURIDCANCEL		1001
#define	IDC_SELECT		1002
#define	IDC_SETTING		1003
#define	IDC_DIAL		1004
#define	IDC_DELETE		1005
#define	IDC_VIEW_EDT	1006
#define	IDC_NEW			1007
#define	IDC_ABORT		1008
#define	IDC_HIDE		1009
#define	IDC_MORE		1010
#define	IDC_CONNECT		1011
#define	IDC_SAVE		1012
#define	IDC_EXECUTE		1013
#define	IDC_DEBUG		1014
#define	IDC_COMPILE		1015
#define	IDC_LEARN		1016
#define	IDC_RESET		1017
#define	IDC_LOAD		1018

#define	DLG_BTN_UNCHKED		0
#define	DLG_BTN_CHKED		1
#define	DLG_BTN_GRAYED		2

#define	DLG_FOCUS_MARGIN	2

/* Bitmap ids to be used in the RC file */
/* Include dlg.h along with other files in the RC file */
/*
#define	IDR_CHECK_OFF		100
#define	IDR_CHECK_ON		101
#define	IDR_CHECK_GRAY		102
#define	IDR_RADIO_OFF		103
#define	IDR_RADIO_ON		104
#define	IDR_RADIO_GRAY		105
*/
/* Groupboxes will be modified only if the ids are greater then or equal */
/* to this base number */
#define		PUSH_BTN_BASE		1000
#define		PUSH_BTN_END		1099
/*
#define		CHECK_BOX_BASE		1100
#define		CHECK_BOX_END		1199
#define		RADIO_BTN_BASE		1200
#define		RADIO_BTN_END		1299
*/
#define		GROUP_BOX_BASE		1300
#define		GROUP_BOX_END		1399
#define		EDIT_BOX_BASE		1400
#define		EDIT_BOX_END		1499
#define		LIST_BOX_BASE		1500
#define		LIST_BOX_END		1599
#define		COMBO_BOX_BASE		1600
#define		COMBO_BOX_END		1699
#define		STAT_TEXT_BASE		1700
#define		STAT_TEXT_END		1799
#define		SCRL_BAR_BASE		1800
#define		SCRL_BAR_END		1899
#define		ICONS_BASE			1900
#define		ICONS_END			1999
#define		RECT_BASE			2000
#define		RECT_END			2099

/* Colors available for background and pen */

#define		DLG_BLACK		0
#define		DLG_WHITE		1
#define		DLG_LTGRAY		2
#define		DLG_DKGRAY		3

/* Functions available in the MDI module */
/*
BOOL 	FAR PASCAL DLGInit(HINSTANCE hInst, int BackGroundColor,
										int PenColor, int PenWidth);
void 	FAR PASCAL DLGClose(void);
BOOL 	FAR PASCAL DLGShowFileOpenDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowSaveAsDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowPrintDlgBox(LPPRINTDLG lpPd);
BOOL 	FAR PASCAL DLGShowFontDlgBox(LPCHOOSEFONT lpCf);
HBRUSH	FAR PASCAL DLGModifyColors(WPARAM wParam, LPARAM lParam);
*/
/* Routines implementing owner draw radio buttons and check boxes */
/*
void 	FAR PASCAL DLGInitDialog(HWND hDlg, WORD FAR * ControlBuf);
void 	FAR PASCAL DLGEndDialog(void);
void 	FAR PASCAL DLGCheckDlgButton(HWND hDlg, WORD CntlId, UINT uChecked);
int 	FAR PASCAL DLGIsDlgButtonChecked(HWND hDlg, WORD CntlId);
void 	FAR PASCAL DLGCheckRadioButton(HWND hDlg, WORD StartId,
										WORD EndId, WORD CheckId);
void 	FAR PASCAL DLGEnableRadioButton(HWND hDlg, WORD CtlID, BOOL State);
void 	FAR PASCAL DLGDrawItemControl(HWND hDlg, WORD idCtl,
										LPDRAWITEMSTRUCT lpInfo);
*/
/* Call back function to be exported */
/*
UINT 	CALLBACK DLGCtlColorFunc(HWND, UINT, WPARAM, LPARAM);
*/
/* ************************ FUNCTION SYNOPSIS **************************** */
/*
	1.	DLGInit()				-	Initialises the Dlg module and creates
									the pen and brush of the required colors.

	2.	DLGClose()				-	Frees up the local resources.  Should be
									called before PostQuitMessage().

	3.	DLGShowFileOpenDlgBox()	-	Displays the FileOpen common dialog box
									after installing a HOOK function to
									modify the colors.
	4.	DLGShowSaveAsDlgBox()	-	Displays the Save as common dialog box
									after installing a HOOK function to
									modify the colors.
	5.	DLGShowPrintDlgBox()	-	Displays the printer common dialog box
									after installing a HOOK function to
									modify the colors.

	6.	DLGShowFontDlgBox()		-	Displays the Font common dialog box
									after installing a HOOK function to
									modify the colors.

	7.	DLGModifyColors()		-	Modifies the colors of a dialog box.
									Should be called in response to a
									WM_CTLCOLOR message.

	8.	DLGInitDialog()			-	To be called in response to WM_INITDIALOG
									message if the dialog box has owner
									draw radio buttons or check boxes.

	9.	DLGEndDialog()			-	To be called before EndDialog() is made
									if DLGInitDialog() call was made to use
									owner draw radio buttons or check boxes.

	10.	DLGCheckDlgButton()		-	Function to replace CheckDlgButton()
									for owner draw radio button or check box.

	11.	DLGIsDlgButtonChecked()	-	Function to replace IsDlgButtonChecked()
									for owner draw radio button or check box.

	12.	DLGCheckRadioButton()	-	Function to replace CheckRadioButton()
									for owner draw radio button or check box.

	13.	DLGEnableRadioButton()	-	Function to disable or enable a owner
									drawn radio button.  Should be used
									instead of EnableWindow() call.

	14.	DLGDrawItemControl()	-	Function to be called in response to
									WM_DRAWITEM message for drawing owner
									draw radio buttons and check boxes.

	14.	DLGCtlColorFunc()		-	The callback HOOK function.

	This line should be present in the EXPORTS section in your DEF file:

		DLGCtlColorFunc				@__
*/

extern	HBRUSH FAR PASCAL DLGModifyColors(WPARAM wParam, LPARAM lParam);

/***************************************************************************
	file	:	looks.h
	parameters which defines the looks of MEW
***************************************************************************/

#define		KEY_VERT_CLEARANCE		2
#define		KEY_HORZ_CLEARANCE		2
#define		KEY_HEIGHT				2
#define		KEY_STR_BORDER			1
#define		KEY_X_VERT				( (KEY_VERT_CLEARANCE + KEY_HEIGHT ) * 2)

#define		EXE_NAME_MAX_SIZE		128
#define		KEY_MARGIN				4
#define		TRM_SHADE				1
#define		TRM_IN_SHADE			2

#define		TB_HORZ_START			10
#define		TB_VERT_START			3
#define		TB_HORZ_WIDTH			37

#define		IDTB_BASE				300
/* button selection macro */
#define TBBUTTONINDEX(x)	(x - IDTB_BASE)
#define TBBUTTON(x)	ghTBButtons[TBBUTTONINDEX(x)]
/* tool bar indices */
#define		IDTB_PBK				(IDTB_BASE + 0)
#define		IDTB_SCROLL				(IDTB_BASE + 1)
#define		IDTB_XFER_SETUP			(IDTB_BASE + 2)
#define		IDTB_XFER_UP			(IDTB_BASE + 3)
#define		IDTB_XFER_DOWN			(IDTB_BASE + 4)
#define		IDTB_MDM_SETUP			(IDTB_BASE + 5)
#define		IDTB_KBD_MAPPING		(IDTB_BASE + 6)
#define		IDTB_CON_DISCON			(IDTB_BASE + 7)
#define		IDTB_DIAL_HUP			(IDTB_BASE + 8)
#define		IDTB_SCRIPT				(IDTB_BASE + 9)

#define		IDTB_UPLD_DROP			(IDTB_BASE + 50 - 0)
#define		IDTB_SIG_WND			(IDTB_BASE + 50 - 1)

#define		NUM_OF_TBBUTTONS		10

/* the resourceIds for bmps */
#define		IDRN_PBK				200
#define		IDRD_PBK				201
#define		IDRG_PBK				202

#define		IDRN_SCROLL				210		/* oops!! 6 state button */
#define		IDRD_SCROLL				211
#define		IDRG_SCROLL				212
#define		IDRN_ALT_SCROLL			213
#define		IDRD_ALT_SCROLL			214
#define		IDRG_ALT_SCROLL			215

#define		IDRN_XFER_SETUP			220
#define		IDRD_XFER_SETUP			221
#define		IDRG_XFER_SETUP			222

#define		IDRN_XFER_UP			230
#define		IDRD_XFER_UP			231
#define		IDRG_XFER_UP			232

#define		IDRN_XFER_DOWN			240
#define		IDRD_XFER_DOWN			241
#define		IDRG_XFER_DOWN			242

#define		IDRN_MDM_SETUP			250
#define		IDRD_MDM_SETUP			251
#define		IDRG_MDM_SETUP			252

#define		IDRN_KBD_MAPPING		260
#define		IDRD_KBD_MAPPING		261
#define		IDRG_KBD_MAPPING		262

#define		IDRN_CON_DISCON			270		// this is 6 state button 
#define		IDRD_CON_DISCON			271
#define		IDRG_CON_DISCON			272
#define		IDRN_ALT_CON_DISCON		273
#define		IDRD_ALT_CON_DISCON		274
#define		IDRG_ALT_CON_DISCON		275

#define		IDRN_DIAL_HUP			280
#define		IDRD_DIAL_HUP			281
#define		IDRG_DIAL_HUP			282
#define		IDRN_ALT_DIAL_HUP		283
#define		IDRD_ALT_DIAL_HUP		284
#define		IDRG_ALT_DIAL_HUP		285

#define		IDRN_SCRIPT				290
#define		IDRD_SCRIPT				291
#define		IDRG_SCRIPT				292

#define		IDRN_UPLD_DROP			500
#define		IDRG_UPLD_DROP			501

#define		IDRN_SIG_WIN			502
#define		IDRG_SIG_WIN			503
#define		IDR_SIG_ON				504
#define		IDR_SIG_OFF				505
#define		IDF_SIG_GRAY			506

