#ifndef __SCRTCONS__

#define __SCRTCONS__

/*--------------------------------------------------------------------------*/
/*	File		:	SCRTCONS.H												*/
/*	Purpose		:	This file contains constants for script file processing.*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#define	MAX_TOKEN_LEN		81	/*	Max length of a token, 80 + null.	*/

#define	LABEL_NAME_LEN		17	/*	Max length of a generated label name.	*/

#define	MAX_EXPR_TOKENS		18	/*	No. of distinct tokens in expression.	*/

#define	MAX_LEVELS			2	/*	Maximum scope levels for symbols.	*/

#define	END_PROC_REACHED	0x01	/*	End of function reached.	*/
#define	FUNCTION_ASSIGNED	0x02	/*	Fn assigned within body.	*/
#define	BUILT_IN_FUNCTION	0x04	/*	Built in fn, for optional args.	*/
#define	OPTIONAL_ARGS		0x08	/*	Optional arguments present or not.	*/
#define	FORWARD_DEFINED		0x10	/*	Procedure body defined forward.	*/
#define	PROC_BODY_DEFINED	0x20	/*	Procedure body for forward defined	*/
									/*	procedure found.	*/

/*	Following constatnts indicate if a particular built-in function is	*/
/*	valid for METERM / MEREMOTE / MEWTERM.	*/

#define	METERM_FN		0x01	/*	Function defined for METERM.	*/
#define	MEREMOTE_FN		0x02	/*	Function defined for MEREMOTE.	*/
#define	MEWTERM_FN		0x04	/*	Function defined for MEWTERM.	*/

#define	LABEL_USED			0x01	/*	Label was used as target.	*/
#define	LABEL_DEFINED		0x02	/*	Label was defined.	*/

#define	E_LVALUE			1	/*	Expr has lvalue.	*/
#define	E_RVALUE			2	/*	Expr has rvalue.	*/

enum {	/*	The order should match entries in Precedence table.	*/
	Q_UNARY_MINUS,
	Q_PLUS,
	Q_MINUS,
	Q_TIMES,
	Q_DIV,
	Q_LESS_OR_EQUAL,
	Q_GREATER_OR_EQUAL,
	Q_IS_EQUAL,
	Q_IS_NOT_EQUAL,
	Q_LESS,
	Q_GREATER,
	Q_NOT,
	Q_LP,
	Q_RP,
	Q_AND,
	Q_OR,
	Q_COMMA,
	Q_ID,
	Q_INT_CONST,
	Q_REAL_CONST,
	Q_STRING_CONST,
	Q_SEMICOLON,
	Q_COLON,
	Q_ASSIGNMENT,
	Q_LABEL,
	Q_ILLEGAL,
	Q_IF,
	Q_THEN,
	Q_ELSE,
	Q_ENDIF,
	Q_WHILE,
	Q_DO,
	Q_ENDWHILE,
	Q_FOR,
	Q_TO,
	Q_DOWNTO,
	Q_STEP,
	Q_ENDFOR,
	Q_SWITCH,
	Q_CASE,
	Q_DEFAULT,
	Q_ENDCASE,
	Q_ENDSWITCH,
	Q_PROC,
	Q_ENDPROC,
	Q_FORWARD,
	Q_RETURN,
	Q_GOTO,
	Q_VAR,
	Q_INTEGER,
	Q_REAL,
	Q_STRING,
	Q_VOID,
} tok_type;

enum {
	L,		/*	Less, shift.	*/
	E,		
	G,
	E1,	/*	unmatched paranthesis, ')' expected.	*/
	E2,	/*	binary operator expected between ')' and '('.	*/
	E3,	/*	binary operator expected between ')' and unary operator.	*/
	E4,	/*	binary operator expected between ')' and identifier.	*/
	E5,	/*	binary operator expected between identifiers.	*/
	E6,	/*	null expression provided.	*/
} action_type;

/*	Maintain the sequence in the following list.  They are used in	*/
/*	getting the arguments in function calls. See below.	*/

enum {
	E_INTEGER,	/*	Expression evaluates to an integer.	*/
	E_REAL,		/*	Expression evaluates to a real.	*/
	E_STRING,	/*	Expression evaluates to a string.	*/
	E_INT_CONST,	/*	Expression is an integer constant.	*/
	E_REAL_CONST,	/*	Expression is a real constant.	*/
	E_STRING_CONST,	/*	Expression is a string constant.	*/
	E_VOID,		/*	Expression type is void.	*/
	E_INVALID,	/*	Expression is invalid.	*/
	E_UNKNOWN,	/*	Expression type unknown.	*/
} expression_type;

enum {	/*	List of operators/instructions.	*/
	Q_MOV = Q_SEMICOLON,
	Q_LABEL_DEFN,	/*	Label declaration.	*/
	Q_JMP,	/*	Unconditional jump.	*/
	Q_JZ,	/*	Jump on zero.	*/
	Q_JNZ,	/*	Jump on non-zero.	*/
	Q_JEQ,	/*	Jump on first and second arg value same.	*/
	Q_JNEQ,	/*	Jump on first and second arg value difference.	*/
	Q_PUSH,	/*	Push argument for call.	*/
	Q_CALL,	/*	Function call.	*/
	Q_RET,	/*	Return from a function.	*/
	Q_LINENO,	/*	Psuedocode for embedding line numbers.	*/
	Q_PROCEDURE,	/*	Psuedocode for procedure beginning.	*/
	Q_ENDPROCEDURE,	/*	Psuedocode for procedure end.	*/
	Q_PARAM,	/*	Psuedocode for procedure parameter.	*/
	Q_DECLARE,	/*	Psuedocode for variable declaration.	*/
	Q_TEMPCOUNT,	/*	Psuedocode indicating no. of temporaries.	*/
	Q_KILL,	/*	Psuedocode for killing temporaries.	*/
} inst_type;

enum {
	VAR_GLOBAL,	/*	Global variable.	*/
	VAR_PARAM,	/*	Parameter variable.	*/
	VAR_LOCAL,	/*	Local variable.	*/
	VAR_TEMPORARY,	/*	Temporary variable.	*/
	VAR_CONDITION,	/*	$CONDN_VAR.	*/
	VAR_RETURN,		/*	$RET_VAR.	*/
} var_type;

#define	Q_EXPRESSION	0xff	/*	To indicate an expression node.	*/
#define	Q_FN_CALL		0xfe	/*	To indicate a fn call expression.	*/

/*	Indices for the predefined variables.	*/

#define	CONDN_VARIABLE		0		/*	Index for condn variable.	*/
#define	RETURN_VARIABLE		1
#define	CONNECTED_VARIABLE	2
#define	EOF_VARIABLE		3
#define	MEHOST_VARIABLE		4

/*	The following constants are used to read off paramaeters in fn calls.	*/

#define	INTEGER			(1 << E_INTEGER)
#define	INT_CONST		(1 << E_INT_CONST)
#define	REAL			(1 << E_REAL)
#define	REAL_CONST		(1 << E_REAL_CONST)
#define	STRING			(1 << E_STRING)
#define	STRING_CONST	(1 << E_STRING_CONST)
#define	DONT_CARE		(INTEGER | INT_CONST | REAL | REAL_CONST | STRING | \
							STRING_CONST)


/*	Following constants used for file open modes.	*/

#define	READONLY	0x00
#define	READWRITE	0x02
#define	EXCLUSIVE	0x10


#endif
