#ifndef __SCRTFUNS__

#define __SCRTFUNS__


/*--------------------------------------------------------------------------*/
/*	File		:	SCRTTYPE.H												*/
/*	Purpose		:	This file contains type declarations.					*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

/*	Functions in SCRIPT.C	*/

extern	int		compiler_main(int argc, char *argv[]);
extern	byte	*SkipPathname(byte *ptr);
extern	byte	*CheckForExtn(byte *file_name);
extern	int		AddBuiltInFunctions(void);
extern	int		AddPreDefinedVariables(void);

/*	Functions in PROGRAM.C	*/

extern	int		Pprogram(void);
extern	int		Pdeclarations(CodeTypeFptr *c_ptr);
extern	int		PprocDeclarations(void);
extern	int		PargumentList(DefnArgType **a_ptr, CodeTypeFptr *c_ptr);
extern	int		Pargument(DefnArgType **a_ptr, CodeTypeFptr *c_ptr);
extern	int		PstatementList(CodeTypeFptr *c_ptr);
extern	int		Pstatement(CodeTypeFptr *c_ptr);
extern	int		PelemtStatement(CodeTypeFptr *c_ptr);

/*	Functions in CHECK.C	*/

extern	int		CheckAssignment(SymInfoType *sym_ptr, ExprNodeType *expr_ptr);
extern	int		CheckUndefinedLabels(SymInfoType *sym_ptr);
extern	int		CheckForwardProcedures(SymInfoType *sym_ptr);
extern	int		CompatibleArgs(int arg_type, int expr_type);
extern	int		CheckFunctionArgs(SymInfoType *sym_ptr, CallArgType *arg_list);
extern	int		ResolveLabels(CodeTypeFptr c_ptr);
extern	int		GetLabelOffset(byte *name);
extern	int		GetResultType(byte operator, byte type1, byte type2);

/*	Functions in CONDNS.C	*/

extern	int		PifStatement(CodeTypeFptr *c_ptr);
extern	int		PswitchStatement(CodeTypeFptr *c_ptr);

/*	Functions in LOOPS.C	*/

extern	int		PforStatement(CodeTypeFptr *c_ptr);
extern	int		PwhileStatement(CodeTypeFptr *c_ptr);

/*	Functions in EXPR.C	*/

extern	int		Pexpression(ExprNodeType **expr_ptr);
extern	byte	ValidExprTerminal(int token);
extern	void	ReleaseNodes(ExprNodeType *node);
extern	void	GenerateTempVar(byte *name_ptr);
extern	int		FixExprType(int operator, byte e_type1, byte e_type2);

/*	Functions in CODE.C	*/

extern	byte	*EmitExpression(ExprNodeType *node, CodeTypeFptr *c_ptr);
extern	CodeTypeFptr	EmitCode(int operator, int type1, byte *name1, int type2, byte *name2, byte *name3);
extern	void	FreeCodes(CodeTypeFptr c_ptr);
extern	CodeTypeFptr	MergeCodes(CodeTypeFptr c_ptr1, CodeTypeFptr c_ptr2);
extern	void	PrintCodes(CodeTypeFptr c_ptr);
extern	int		InitCodeSpace(void);
extern	int		FreeCodeSpace(void);
extern	CodeTypeFptr	GetCodeNode(void);
extern	void	FreeCodeNode(CodeTypeFptr c_ptr);
extern	CodeTypeFptr	NextCodeNode(void);
extern	int		KillTemporaries(CodeTypeFptr *c_ptr);
extern	int		FormArgString(byte type, byte *name, byte *buffer);
extern	int		WriteQuads(CodeTypeFptr c_ptr);

/*	Functions in TOKEN.C	*/

extern	int		GetToken(void);
extern	void	CnvtToUpper(byte *token);
extern	int		CheckForResdWord(byte *token);
extern	int		HexValue(int ch);
extern	int		SkipComment(int *ch_ptr);
extern	void	Error(int err_id);
extern	byte	*CnvtLineNo(void);

/*	Functions in SYMBOL.C	*/

extern	int		AddSymbol(byte *name, int sym_type, SymInfoType **n_ptr);
extern	SymInfoType	*FindSymbol(byte *name);
extern	void	PurgeSymbols(SymInfoType *n_ptr);
extern	void	GenerateLabelName(byte *name_ptr);

/*	Functions in FILEIO.C	*/

extern	int		Open(byte *file_name, byte mode);
extern	void	Close(int file_handle);
extern	int		Create(byte *file_name);
extern	int		Read(int file_handle, byte *buffer, int count);
extern	int		FWrite(int file_handle, byte *buffer, int count);
extern	int		Delete(byte *file_name);
extern	int		GetChar(void);

/*	Functions in OPTIMIZE.C	*/

extern	int		OptTransMovs(CodeTypeFptr c_ptr);
extern	int		OptTemps(CodeTypeFptr c_ptr);

/*	Functions in DISPRTNS.C	*/

extern	word	CheckForMeterm(void);
extern	void	PutStr(byte *string);
extern	void	ShowMesg(byte *string, byte key_wait);

/*	Functions in INTRTNS.ASM	*/

extern	void	SetVectors(void);
extern	void	ResetVectors(void);

#endif
