/***************************************************************************
*	file	:   winmain.c
*	function:   takes care of the windows part of ME script compiler
*	SYNOP	:	When compiled with WIN defined, it produces code for windows
*				version of script.exe application.
***************************************************************************/


#ifdef WIN		/* All windows related variables */
#include	"windows.h"
#include	"winmain.h"
#include	"commdlg.h"

#include    "scrtmesg.h"
#include    "scrtcons.h"
#include    "scrttype.h"
#include    "scrtdata.h"
#include	"dlgbox.h"
#include "scrtfuns.h"

#include    <string.h>
#include    <stdlib.h>
#include	<stdio.h>

HANDLE	hCompileWnd;
HANDLE	hInst;					/* application instance handle */
HANDLE	hMewCompAccTable;			/* accelerator table handle */

HWND    hCompileStatDlg;

HCURSOR	hCurCursor;			/* current cursor handle */
HCURSOR	hStandard;			/* standard arrow cursor */
HCURSOR	hHourGlass;			/* hour glass cursor */
BYTE	*MewScrtTitle = "Router - Script Compiler";

BYTE    *args[6];
BYTE	IOFilePathName[128];
OPENFILENAME	OpenFileName;
BYTE	ScriptFilesDir[128];
BYTE	ScriptFilter[] = "Script files (*.SCR)\000*.SCR\000";
BYTE	MEWParamsSec[] = "MEW";
BYTE	arg1[20];
BYTE	arg2[20];
BYTE	arg3[128];
BYTE	arg4[20];
BYTE	arg5[10];
BYTE	arg6[10];

RECT	TermWndRect;

#define		X_OFF	10
#define		CHARS_IN_MEM_LINE	80
#define		LINES_IN_MEM_SCREEN	50
#define		LINE_SIZE	(CHARS_IN_MEM_LINE + 1)
#define		INC_BUF_INDX(x)		x = (x + 1) % LINES_IN_MEM_SCREEN
#define		LINES_IN_DISPLAY_MEM()	\
				((bufTail + LINES_IN_MEM_SCREEN - bufHead) % \
				LINES_IN_MEM_SCREEN)

int		LinesInDisp;
int		CharHeight;
int		bufHead, bufTail;
int		CurDispY = 0;
PSTR	pDispBuf;
RECT	DispRect;

byte	TmpStr[80];

#define		IDC_NO_ERROR		1797
#define		IDC_ERROR			1796
byte	BlankLine[] = "                                                  \
                                                                ";

/****************************************************************************
 * Function   : WinMain(HANDLE, HANDLE, LPSTR, int)
 * Synopsis   : Creates the main app. window, calls an initialization
 *		 		function and enters the message loop.
 ****************************************************************************/
int PASCAL
WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG   	msg;
	int		ret;
	int		indx;
	FARPROC lpDlgProc;

   LPSTR	ptr, ptr1;

	hInst = hInstance;
	
	/* Register the window classes if this is the first instance of the app. */
	if (!hPrevInstance)
		if (!InitInstances (hInstance))
	    	return NULL;

	hStandard = LoadCursor (NULL, IDC_ARROW);
	hHourGlass = LoadCursor (NULL, IDC_WAIT);

	hMewCompAccTable = LoadAccelerators (hInst, "MewCompilerAcc");
/* chetan 16/10/96 */
	DLGInit (hInst, DLG_LTGRAY, DLG_DKGRAY, 16); 
/* chetan 16/10/96 */

	hCurCursor = hHourGlass;	/* set the cursor to HourGlass */
	SetCursor (hCurCursor);

	args[0] = arg1;
	args[1] = arg2;
	args[2] = arg3;
	args[3] = arg4;
	args[4] = arg5;
	args[5] = arg6;

	/* process the command line */

	for (indx = 1, ptr= lpCmdLine; ptr; indx++, ptr = ptr1) 
	{
			if (ptr1 = _fstrchr(ptr, ' ')) 
				ptr1++;
			lstrcpy(args[indx], ptr);
	}
	/* get dir name into ScriptFilesDir */
	if( ptr = _fstrchr(args[2], ' '))
		*ptr = '\0';
	lstrcpy(ScriptFilesDir, arg3);
	ptr = ScriptFilesDir;
	ptr += lstrlen(ptr);
	while (*ptr != '\\' && *ptr != ':' && ScriptFilesDir != ptr)
		ptr--;
	if ( *ptr == ':')
		*++ptr = 0;
	else
		*ptr = 0;

	/* get the dimensions of the compile window */
		if( args[3] != "" ) {
			sscanf( args[3], "%3d %3d %3d %3d", &TermWndRect.left, &TermWndRect.top,
			   &TermWndRect.right, &TermWndRect.bottom );
			args[3] = "";
		}

	/* create the app. window */
	hCompileWnd = CreateWindow ("MEWSCRTMAIN",
			 				MewScrtTitle,
			 				WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CAPTION 
							|	WS_BORDER,
			 				(TermWndRect.right ? TermWndRect.left + 20 : CW_USEDEFAULT),
			 				(TermWndRect.right ? TermWndRect.top + 20 : CW_USEDEFAULT),
			 				(TermWndRect.right ? (TermWndRect.right - TermWndRect.left) : CW_USEDEFAULT),
			 				(TermWndRect.right ? (TermWndRect.bottom - TermWndRect.top) : CW_USEDEFAULT),
							(HWND) NULL,
			 				NULL,
			 				hInstance,
			 				(LPSTR) NULL);

	if (!hCompileWnd)
		return NULL;

	ShowWindow (hCompileWnd, SW_SHOWMAXIMIZED);
	UpdateWindow (hCompileWnd);
	InitDisplay(hCompileWnd);


	hCurCursor = hHourGlass;	/* Set cursor to hour glass */
	SetCursor (hCurCursor);

	/* Call main here with proper parameters setup */
	if (indx > 2) {
	    _fstrupr(args[2]);
		args[0] = "Script";
		args[1] = "MEWTERM";

		/* display the status dialog */
		lpDlgProc = MakeProcInstance((FARPROC)CompileDialogProc, hInstance);
		hCompileStatDlg = CreateDialog(hInstance, "COMPILER",
		hCompileWnd, lpDlgProc);
		
		WriteLine("");
		lstrcpy(TmpStr, "SCRIPT FILE : ");
		lstrcat(TmpStr, args[2]);
		WriteLine(TmpStr);
		
		compiler_main(indx, args);

		/* Remove the status dialog box */
		SendMessage(hCompileStatDlg, WM_COMMAND,IDC_SHOW_STATUS, NULL);
	}

	hCurCursor = hStandard;	/* reset the cursor to standard one */
	SetCursor (hCurCursor);

	while (GetMessage((LPMSG)&msg, NULL, NULL, NULL)) {
		if (hCompileStatDlg && IsDialogMessage(hCompileStatDlg, &msg))
			continue;
		ret = TranslateAccelerator(hCompileWnd, hMewCompAccTable, (LPMSG)&msg);
		if (!ret) {
			TranslateMessage((LPMSG)&msg);
			DispatchMessage((LPMSG)&msg); 
		}
	}
	return(msg.wParam);
}

void	ResetCompiler(void)
{
	PurgeSymbols(Display[0]);
	Display[0] = 0;
	TokenLen = 0;
	Token = 0;
	CodeSize = 0;
	ErrCount = 0;
	LineNo = 1;
	TempVarCount = 0;
	TotalTempCount = 0;
	ParamCount = 0;
	LabelCount = 0;
	Scope = 0;
}
/****************************************************************************
 * Function   : InitInstances (hInstance)
 * Synopsis   : Registers the window classes.
 * returns    : TRUE	-  if RegisterClass() went off ok
 *		 		FALSE	-  otherwise.
 ****************************************************************************/
BOOL NEAR PASCAL
InitInstances (HANDLE hInstance)
{
    BOOL     bSuccess;
	WNDCLASS WndClass;				/* window class variable */

	/* register the parent window class */
    WndClass.style			= CS_DBLCLKS;
    WndClass.cbClsExtra		= 0;
    WndClass.cbWndExtra		= 0;
    WndClass.lpfnWndProc	= MainCompileWndProc;
    WndClass.hInstance		= hInstance;
    WndClass.hIcon			= LoadIcon (hInstance, "mew");
    WndClass.hCursor	   	= NULL;
    WndClass.hbrBackground	= GetStockObject (LTGRAY_BRUSH);
    WndClass.lpszMenuName	= (LPSTR) "MewScrtMenu",
    WndClass.lpszClassName	= (LPSTR) "MEWSCRTMAIN";
    bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);
	return bSuccess;
}

void	RepaintScreen(HDC hDC)
{
	int		yoff;
	int		startline;
	PSTR	Str;

	/* First Get the start line */
	if (LinesInDisp >= LINES_IN_DISPLAY_MEM()) {
		startline = bufHead;
	} else {
		startline = (bufTail + LINES_IN_MEM_SCREEN - LinesInDisp) %
					LINES_IN_MEM_SCREEN;
	}
	/* paint till start line = bufTail from beginning of screen */
	SetBkColor(hDC, RGB(0xC0, 0xC0, 0xC0));		/* Set the backgound color */
		
	for (yoff = 0; startline != bufTail; yoff++, INC_BUF_INDX(startline)) {
		Str = pDispBuf + startline * LINE_SIZE;
		TextOut (hDC, X_OFF, yoff * CharHeight, Str, strlen(Str));
	}
}

/****************************************************************************
 * Function   : MainCompileWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the main app. window. Processes all the
 *		 		menu selections and other messages.
 ****************************************************************************/
long FAR PASCAL
MainCompileWndProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
	HDC 	hDc;
	PAINTSTRUCT ps;
	DLGPROC	lpProcAbout;
	HWND	hScrDlg;
	WORD	wparam;
	LPSTR ptr ;
	int		retval ;

    switch (message){
		case WM_MOUSEMOVE:
			SetCursor (hStandard);
			break;

		case WM_SIZE :
		{
		RECT		Rect;
		HDC			hDC;
		TEXTMETRIC	TextMetric;

			if (wParam == SIZEICONIC) {
				break;
			}

			GetClientRect( hWnd, &Rect);
			hDC = GetDC(hWnd);
			/* get sizes of character */
			if(retval = GetTextMetrics( hDC, &TextMetric));
			ReleaseDC(hWnd, hDC);
		
			/* Compute display size */
			CharHeight = TextMetric.tmHeight + TextMetric.tmExternalLeading;
			LinesInDisp = (Rect.bottom - Rect.top - 10) / CharHeight;
			/* repaint entire client area erasing background */
			InvalidateRect(hWnd, NULL, TRUE );
//			if (CurDispY >= LinesInDisp)
/*				CurDispY = LinesInDisp - 1;		 max value of CurDispY */
			LinesInDisp = min (LinesInDisp, LINES_IN_MEM_SCREEN);
			DispRect = Rect;
			DispRect.bottom = (LinesInDisp) * CharHeight;
			break;
		}

		case WM_CREATE:
		if ( ! ScriptFilesDir[0])
			if (GetProfileString (MEWParamsSec, "ScriptDir",
						(LPSTR)"", ScriptFilesDir, 128));
			break;

		case WM_SETFOCUS:
	    	return DefWindowProc(hWnd, message, wParam, lParam);

		case WM_COMMAND:
			switch(wParam) {
				case IDC_COMP_COMPILE:
					OpenAndCompileFile(hWnd);
					break;
				case IDC_COMP_EXIT:
ExitPt:
					if (args[4] != "") {
						if( ptr = _fstrchr(args[4], ' '))
							*ptr = '\0';
						hScrDlg = (HWND)atoi(args[4]);
						wparam  = (WORD)atoi(args[5]);
						if(ErrCount)
							SendMessage( hScrDlg, WM_COMMAND, wparam, IDC_ERROR);
						else
							SendMessage( hScrDlg, WM_COMMAND, wparam, IDC_NO_ERROR);
					}
					DestroyWindow (hWnd);
					break;
				case IDC_COMP_ABOUT:
					lpProcAbout = (DLGPROC) MakeProcInstance(AboutDlgProc, hInst);
					DialogBox(hInst, "About", hWnd, lpProcAbout);
					FreeProcInstance ((FARPROC)lpProcAbout);
					break;
				default :
					break;
			}
			break;

		case WM_PAINT:
		    hDc = BeginPaint (hWnd, (LPPAINTSTRUCT)&ps);
			RepaintScreen(hDc);
		    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);

	    	break;

		case WM_CLOSE:
			goto ExitPt;

		case WM_DESTROY:
	    	PostQuitMessage (0);
			DLGClose();
	    	break;

		default:
	    	return DefWindowProc(hWnd, message, wParam, lParam);
    }
}
/*
show commdlg to user and let him select a file for compilation 
*/

void	OpenAndCompileFile(HWND hWnd)
{
	BYTE	*cmdline[3];
	FARPROC lpDlgProc;

	if ( !GetOpenFilePathName(hWnd, ScriptFilesDir,
			"Compile MEW Script", NULL, "SCR"))
		return;

	cmdline[0] = "Script";
	cmdline[1] = "MEWTERM";
	cmdline[2] = IOFilePathName;

	args[2] = IOFilePathName;

	/* display the status dialog */
	lpDlgProc = MakeProcInstance((FARPROC)CompileDialogProc, hInst);
	hCompileStatDlg = CreateDialog(hInst, "COMPILER", hCompileWnd, lpDlgProc);

	WriteLine("");
	lstrcpy(TmpStr, "SCRIPT FILE : ");
	lstrcat(TmpStr, args[2]);
	WriteLine(TmpStr);
	
	compiler_main(3, cmdline);
	/* Remove the status dialog box */
	SendMessage(hCompileStatDlg, WM_COMMAND,IDC_SHOW_STATUS, NULL);
	return;
}


/***************************************************************************
*	Routine	:	GetOpenFilePathName()
*	Input	:	
*	Return	:	
*	Synopsis:	Gets a file name for opening
***************************************************************************/
BOOL	GetOpenFilePathName(HWND hWnd, LPSTR InitDir, LPSTR Head,
		LPSTR Filter, LPSTR Extn)
{

	IOFilePathName[0] = NULL;
	memset (&OpenFileName, 0, sizeof(OPENFILENAME));
	OpenFileName.lStructSize = sizeof(OPENFILENAME);
	OpenFileName.hwndOwner = hWnd;
	if (Filter)
		OpenFileName.lpstrFilter = Filter;
	else
		OpenFileName.lpstrFilter = ScriptFilter;

	OpenFileName.nFilterIndex = 1;
	OpenFileName.lpstrFile = IOFilePathName;
	OpenFileName.nMaxFile = 128;
	OpenFileName.lpstrFileTitle = NULL;
	OpenFileName.nMaxFileTitle = 0;
	OpenFileName.lpstrInitialDir = InitDir;
	OpenFileName.lpstrTitle = Head;
	OpenFileName.lpstrDefExt = Extn;
	OpenFileName.Flags = OFN_FILEMUSTEXIST |
							OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

	if (DLGShowFileOpenDlgBox(&OpenFileName)) {
		_fstrupr(IOFilePathName);
		return TRUE;
	}
	return FALSE;
}

/****************************************************************************/
/* Routine : CompileDialogProc                                                        */
/* Purpose : Dialog Procedure for Script Compiler Dialog Box                       */
/****************************************************************************/

BOOL FAR PASCAL CompileDialogProc(HWND hDlg, UINT message, WPARAM wParam, 
          LPARAM lParam)
{
	char	StatStr[80];	

	switch (message) {
	case WM_CTLCOLOR:
		return DLGModifyColors(wParam, lParam);
	
	case WM_INITDIALOG :
/* chetan 16/10/96 */
/*		 	DLGCenterDialog(hDlg); */
/* chetan 16/10/96 */
		 	SetWindowText (GetDlgItem(hDlg, IDC_FILE_NAME), args[2]);
			return TRUE;

	case WM_COMMAND :

			if( wParam == IDC_SHOW_STATUS ) {

				WriteLine("");
				sprintf( StatStr, " Number of Source Lines  : %d", LineNo);
				WriteLine( StatStr);
				sprintf( StatStr, " Errors In Compilation       : %d", ErrCount);
				WriteLine( StatStr);
				sprintf( StatStr, " Executable Code Size     : %d", CodeSize);
				WriteLine( StatStr);
				WriteLine("");

//				ResetCompiler();		/* don't reset error count !! */
				DestroyWindow(hDlg);
				hCompileStatDlg  = NULL;
				return TRUE;
			}
	}
	return FALSE;
}
/*-------------------------------------------------------------------------- *
 * Function 	: AboutDlgProc
 * Synopsis 	: Displays the about dialob box.
 *-------------------------------------------------------------------------- */
BOOL FAR PASCAL
AboutDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char	szBuffer[81], szTemp[81];
	DWORD	dwFreeMemory, dwWinFlags;
	WORD	wFreeResources, wRevision, wVersion;

	switch (uMsg) {
		case WM_INITDIALOG:
/*			DLGCenterDialog(hDlg); */
			wVersion = LOWORD(GetVersion());
			switch (HIBYTE(wVersion)) {
		    	case 10:
       				wRevision = 1;
		         	break;

      			default:
					wRevision = 0;
        		 	break;
			}
   			wVersion &= 0xFF;

   			GetDlgItemText(hDlg, 529, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, wVersion, wRevision);
   			SetDlgItemText(hDlg, 529, szBuffer);

	   		// set windows mode information
   			dwWinFlags = GetWinFlags();
	   		if (dwWinFlags & WF_ENHANCED)
				lstrcpy(szBuffer, "386 Enhanced Mode");
	   		else if (dwWinFlags & WF_STANDARD)
				lstrcpy(szBuffer, "Standard Mode");
	   		else if (dwWinFlags & WF_WLO)
				lstrcpy(szBuffer, "WLO Compatibility Mode");
	   		else
				lstrcpy(szBuffer, "Undefined Mode");

	   		SetDlgItemText(hDlg, 532, szBuffer);

	   		// get free memory information
	   		dwFreeMemory = GetFreeSpace(0) / 1024L;
	   		GetDlgItemText(hDlg, 533, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, dwFreeMemory);
	   		SetDlgItemText(hDlg, 533, (LPSTR) szBuffer);

	   		// get free resources information
	   		wFreeResources = GetFreeSystemResources(0);
	   		GetDlgItemText(hDlg, 534, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, wFreeResources);
	   		SetDlgItemText(hDlg, 534, (LPSTR) szBuffer);
			return (TRUE);

		case WM_CTLCOLOR:
			return (DLGModifyColors(wParam, lParam));

		case WM_COMMAND:
			switch(wParam) {
				case IDOK:
				case IDCANCEL:
			    	EndDialog(hDlg, TRUE);
			    	return (TRUE);

				default:
					break;
			}
			break;
	}
	return (FALSE);
}

/*****************************************************************************
*	Function	: WriteLine
*	Input		: pointer to string to be displayed
*	Return		: 															 *
*	Synopsis	: 
*****************************************************************************/

void	WriteLine(char *DisplayStr)
{
	int		indx;
	PSTR	ptr;


	if (ptr = strchr(DisplayStr, '\n'))
		*ptr = NULL;
	if (ptr = strchr(DisplayStr, '\r'))
		*ptr = NULL;


	/* copy the string to disp mem */
	ptr = pDispBuf + bufTail * LINE_SIZE;

	for (indx = 0; *DisplayStr && indx <= CHARS_IN_MEM_LINE; indx++)
		*ptr++ = *DisplayStr++;		/* write chars */
	*ptr == NULL;

	ptr = pDispBuf + bufTail * LINE_SIZE;	/* this needs to be written */

	/* increment the pointer(s) */
	INC_BUF_INDX(bufTail);
	if (bufTail == bufHead)	/* if buffer tail == buffer head inc head also */
		INC_BUF_INDX(bufHead);
	WriteLineInDisplay(ptr);
}

void	WriteLineInDisplay(char *DisplayStr)
{
	HDC		hDC = 0;

	if ( LinesInDisp < 2)
		return;

	hDC = GetDC(hCompileWnd);
	SetBkColor(hDC, RGB(0xC0, 0xC0, 0xC0));		/* Set the backgound color */

	if (CurDispY >= LinesInDisp) {	/* we need to scroll */
		CurDispY--;
		/* Issue a scroll */
		ScrollWindow(hCompileWnd, 0, -CharHeight, NULL, (LPRECT) &DispRect);
		TextOut (hDC, 0, CurDispY * CharHeight, BlankLine, strlen(BlankLine));
		UpdateWindow(hCompileWnd);
	} else {
		TextOut (hDC, X_OFF, CurDispY * CharHeight, DisplayStr, strlen(DisplayStr));
	}
	CurDispY++;

	ReleaseDC(hCompileWnd, hDC);
}

/****************************************************************************
*	Function	: 
*	Synopsis	: This function gets the font size, client area coordinates *
*	and allocates memory for the display buffer                             *
****************************************************************************/
void	InitDisplay(HWND hWnd)
{
	RECT		Rect;
	HDC			hDC;
	TEXTMETRIC	TextMetric;


	GetClientRect( hWnd, &Rect);
	hDC = GetDC(hWnd);
	/* get sizes of character */
	GetTextMetrics(hDC, &TextMetric);
	SetBkColor(hDC, RGB(0xC0, 0xC0, 0xC0));		/* Set the backgound color */
	ReleaseDC(hWnd, hDC);
		
	/* Compute display size */
	CharHeight = TextMetric.tmHeight + TextMetric.tmExternalLeading;
	LinesInDisp = (Rect.bottom - Rect.top - 10) / CharHeight;
	LinesInDisp = min (LinesInDisp, LINES_IN_MEM_SCREEN);
	DispRect = Rect;
	DispRect.bottom = (LinesInDisp) * CharHeight;

	/* Allocate memory for display buffer */
	pDispBuf = (PSTR) LocalAlloc(LPTR , LINES_IN_MEM_SCREEN * LINE_SIZE);
}

#endif
