#include 	"windows.h"
#include	<sys\types.h>
#include	<sys\stat.h>
#include    <string.h>
#include    <stdlib.h>
#include	<stdio.h>

#include "resource.h"
#include	"edit.h"
#include	"file.h"
#include	"ourdlgbx.h"
#include	"dlgbox.h"
#include "res.h"

HCURSOR	hCurCursor;			/* current cursor handle */
HCURSOR	hStandard;			/* standard arrow cursor */
HCURSOR	hHourGlass;			/* hour glass cursor */
BYTE	ScriptFilesDir[128];

HANDLE	hInst;

/* chetan */
BYTE arg[256] ;

HANDLE 	hAccTable;		/* handle to accelerator table */
HWND 	hEditWnd;		/* handle to edit window */

HANDLE	hEditBuffer;		/* handle to editing buffer        */
PSTR	pEditBuffer;		
HANDLE 	hOldBuffer;			/* old buffer handle               */
struct	stat FileStatus;	/* information from fstat()        */
BOOL 	bEdited;            /* TRUE if the file is changed     */

char 	*Untitled = "Edit Script - (Untitled)";
char	*ScriptTitle = "Edit Script - %s";
char	*ScrtSaveHeader = "Save Script file as";
char    *MEWEdtHelpFile = "RTRSCR.HLP";
BYTE	EditFileName[13];		/* The name */
BYTE	ScriptFileName[13];
BYTE	ScriptFileDir[128];

BYTE	ScriptExtn[] = ".SCR";
BYTE	*ScriptFiles = "*.SCR";
char	*ScrtFilter = "Script Files(*.scr)\000*.scr\000";
BYTE	TmpStr[128];

BYTE	IOFilePathName[128];
int 	hFile;

HGLOBAL		hEditStr;
EDITtype   far *pEditStr;

HWND hMainWnd ;
/****************************************************************************
 * FUNCTION: InitEditApplication(HANDLE)
 * PURPOSE : Initializes window data and registers window class
 ****************************************************************************/
BOOL
InitEditApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = EditWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "EditFileMenu";
    wc.lpszClassName = "EditFileWClass";

    return (RegisterClass(&wc));
}


/****************************************************************************
 * FUNCTION:  WinMain(HANDLE, int)
 * PURPOSE :  Creates script edit window.
 ****************************************************************************/
int PASCAL
WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   RECT Rect ;
	int IOStatus ;
	HWND hwnd ;               /* handle to main window           */
	int ret ;
	MSG msg ;

	hInst = hInstance ;

	/* Register the window classes if this is the first instance of the app. */
	if (!hPrevInstance)
		if (!InitEditApplication (hInstance))
	    	return NULL ;

	hStandard = LoadCursor (NULL, IDC_ARROW) ;
	hHourGlass = LoadCursor (NULL, IDC_WAIT) ;

	hAccTable = LoadAccelerators(hInstance, "EditFileAcc");
	DLGInit (hInstance, DLG_WHITE, DLG_DKGRAY, 16);

	/* chetan */
	lstrcpy (arg, lpCmdLine) ;

	/* source path name in arg */
	if (arg[0]) 
	{
		/* separate the file name & the path name */
		SeparateFile (ScriptFilesDir, ScriptFileName, arg) ;
	}


   hwnd = CreateWindow (
		"EditFileWClass",
		Untitled,					/* No name to start with */
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
      hInstance,
      NULL
      ) ;

    if (!hwnd)
        return NULL ;

	 hMainWnd = hwnd ;
    GetClientRect (hwnd, (LPRECT) &Rect) ;
    /* Create a child window */
    hEditWnd = CreateWindow ("EDIT",				/* This is an EDIT window	*/
		NULL,							/* No Name for now */
        WS_CHILD | WS_VISIBLE |	
        ES_MULTILINE |						/* Multiline text editor	*/
        WS_VSCROLL | WS_HSCROLL |			/* Manual thumb positioning	*/
        ES_AUTOHSCROLL | ES_AUTOVSCROLL,		/* Auto scrolling of window	*/
        0,
        0,
        (Rect.right-Rect.left),
        (Rect.bottom-Rect.top),
		  hwnd,							/* Parent window of edit window */
        IDC_EDIT,                          /* Child window i.d. */
        hInstance,
        NULL);

    if (!hEditWnd) 
	 {
        DestroyWindow (hwnd) ;
        return NULL ;
    }

	/* allocate memory for the structure to be sent back to MEWTRM */
	hEditStr = GlobalAlloc (GMEM_SHARE | GHND, sizeof (EDITtype)) ;
	pEditStr = (EDITtype far *) GlobalLock (hEditStr) ;

	if (!ScriptFileName[0])
	{	/* No name Specified */
		EditFileName[0] = NULL ;
		goto show_win ;
	}
	else
	{
		lstrcpy (EditFileName, ScriptFileName) ;
		MakeFullFileName (TmpStr, ScriptFilesDir, EditFileName) ;
	}

	/* Open the file */
	if ((hFile = _lopen (TmpStr, READ)) == -1) 
	{
		sprintf (TmpStr, "Error opening file %s", EditFileName) ;  
		MessageBox (hEditWnd, TmpStr, NULL, MB_OK) ;	
	}
	else 
	{
		/* Make sure there's enough room for the file */
		fstat (hFile, &FileStatus) ;
		if (FileStatus.st_size > MAXFILESIZE) 
		{
			MessageBox (hEditWnd, "File too big to edit", NULL, MB_OK) ;
			/* The buffer is set now. Display it and leave the rest to edit */
			goto show_win ;
		}
	}

	/* Initialize the edit buffer with file name if we have one */
   if (hFile != HFILE_ERROR ) 
   {
  		/* Allocate edit buffer to the size of the file + 1 */
		hEditBuffer = LocalAlloc (LMEM_ZEROINIT | LMEM_MOVEABLE,
													(WORD) (FileStatus.st_size + 1)) ;
		if (!hEditBuffer) 
		{
			MessageBox (hEditWnd, "No Local memory available", NULL, MB_OK) ;
			DestroyWindow (hwnd) ;
			DestroyWindow (hEditWnd) ;
			hEditWnd = NULL ;
			bEdited = FALSE ;
   	   return TRUE ;
		}

		pEditBuffer = LocalLock (hEditBuffer) ;
		IOStatus = _lread (hFile, pEditBuffer, (WORD) FileStatus.st_size) ;
		_lclose (hFile) ;
		LocalUnlock (hEditBuffer) ;

		/* # bytes read must equal file size */
		if (IOStatus != (int) FileStatus.st_size) 
		{
			sprintf (TmpStr, "Error reading from %s", EditFileName) ;
			MessageBox (hEditWnd, TmpStr, NULL, MB_OK) ;
		}
		/* Set up a new buffer and window title */
		sprintf (TmpStr, ScriptTitle, EditFileName) ;
		SetNewBuffer (hwnd, hEditBuffer, TmpStr) ;
	}

show_win :
	/* The buffer is set now. Display it and leave the rest to edit */
	ShowWindow (hwnd, SW_SHOWMAXIMIZED) ;
   UpdateWindow (hwnd) ;
	bEdited = FALSE ;

	while (GetMessage ((LPMSG) &msg, NULL, NULL, NULL)) 
	{
		ret = TranslateAccelerator (hwnd, hAccTable, (LPMSG) &msg) ;
		if (!ret) 
		{
			TranslateMessage ((LPMSG) &msg) ;
			DispatchMessage ((LPMSG)&msg) ; 
		}
	}
	return msg.wParam ;

}


/****************************************************************************
    FUNCTION: EditWndProc(HWND, unsigned, WORD, LONG)
    PURPOSE:  Processes messages
    MESSAGES:
        WM_COMMAND    - application menu (About dialog box)
        WM_DESTROY    - destroy window
        WM_SIZE       - window size has changed
        WM_QUERYENDSESSION - willing to end session?
        WM_ENDSESSION - end Windows session
        WM_CLOSE      - close the window
        WM_SIZE       - window resized

    COMMENTS:
        WM_COMMAND processing:

            IDM_NEW - query to save current file if there is one and it has
                      been changed, clear buffer and start new file.

            IDM_OPEN - query to save current file if there is one and it
                       has been changed, open a new file.

            IDM_SAVE - save current file, prompt for name if none exists.

            IDM_SAVEAS - prompt for new filename to save to, save file.

            IDC_EDIT - change "bEdited" flag to indicate if edit buffer has
                      been modified.  Affects actions of IDM_NEW and
                      IDM_OPEN.  Reset when file is saved.

            IDM_EXIT - query to save current file if there is one and it
                       has been changed, then exit.

        After the size of the file is determined, only enough memory to store
        the file is allocated for the Edit buffer.  The edit control will
        automatically expand this memory as needed.  Once the file has been
        read into the edit buffer, unlock the memory.  Use whatever was
        obtained from the read() function, even if an error occured.  This
        allows partial salvage of a file with a bad sector.
****************************************************************************/

long FAR PASCAL EditWndProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
	int ret ;
	FARPROC lpDlgFn ;

	switch (message) 
	{
		case WM_COMMAND :
	      switch (wParam) 
	   	{
				case IDM_SAVE :
            	if (bEdited)
               	SaveEditFile (hWnd) ;
               break ;

				case IDM_OVERWRITE :
					OverWrite (hWnd) ;
					break ;

                /* edit menu commands */
				case IDM_UNDO:
					/* Check if an Undo is possible. If so do it */
					if (SendMessage (hEditWnd, EM_CANUNDO, 0, 0L))
						SendMessage (hEditWnd, EM_UNDO, 0, 0L) ;
					break ;

            case IDM_CUT:
					// this will cut the current selection to clipboard
						SendMessage (hEditWnd, WM_CUT, 0, 0L);
						break;

            case IDM_COPY:
					// Copy the current selection to Clipboard
						SendMessage (hEditWnd, WM_COPY, 0, 0L);
						break;

            case IDM_PASTE:
					// this will copy clipboard text to current cursor pos
						SendMessage (hEditWnd, WM_PASTE, 0, 0L);
						break;

            case IDM_CLEAR:
                	break;  

            case IDM_EXIT:
						ret = QuerySaveEditFile (hWnd) ;
						/* Back up the File that was edited */
						BackupScriptFile() ;

					/* send a message back to mewtrm , containing the editfilename
					& the scriptfilesdir */
						lstrcpy(pEditStr->EditFile, EditFileName);
						lstrcpy(pEditStr->EditFilePath, ScriptFilesDir);

						GlobalUnlock (hEditStr);
						GlobalFree (hEditStr) ;
						if (!ret)
						{	/* didn't save*/
							DestroyWindow(hWnd);
							hEditWnd = NULL;

							break;
						}
TerminEdit:
						DestroyWindow(hWnd);
						hEditWnd = NULL;
         	      break;

					case IDC_EDIT:
               	if (HIWORD (lParam) == EN_ERRSPACE) 
						{
							LoadString(hInst, 460, TmpStr, 128);
							MessageBox(hEditWnd, "No Local memory available", NULL, MB_OK);
                  }
						if (HIWORD (lParam) == EN_CHANGE)
							bEdited = TRUE;				/* Text has changed	*/
                     break;

					case IDM_HLP_INDEX:
						GetMEWPathName (TmpStr);
						if ((strlen(TmpStr)+13) < EXE_NAME_MAX_SIZE)
							lstrcat(TmpStr, MEWEdtHelpFile);
						else
							lstrcat(TmpStr, "?");
		           	WinHelp (hWnd, TmpStr, HELP_INDEX, 0L) ;
    	          	break;

					case IDM_HLP_INTRO:
						GetMEWPathName (TmpStr);
						if ((strlen(TmpStr)+13) < EXE_NAME_MAX_SIZE)
							lstrcat(TmpStr, MEWEdtHelpFile);
						else
							lstrcat(TmpStr, "?");
		  				WinHelp (hWnd, TmpStr, HELP_CONTEXT,
								(DWORD) ID_introduction);
    	          	break;

					case IDM_HLP_CMDS:
						GetMEWPathName (TmpStr);
						if ((strlen(TmpStr)+13) < EXE_NAME_MAX_SIZE)
							lstrcat(TmpStr, MEWEdtHelpFile);
						else
							lstrcat(TmpStr, "?");
			  			WinHelp (hWnd, TmpStr, HELP_CONTEXT,
									(DWORD) ID_alphabetical);
    	          	break;

					case IDM_HLP_FUNC:
						GetMEWPathName (TmpStr);
						if ((strlen(TmpStr)+13) < EXE_NAME_MAX_SIZE)
							lstrcat(TmpStr, MEWEdtHelpFile);
						else
							lstrcat(TmpStr, "?");
			  			WinHelp (hWnd, TmpStr, HELP_CONTEXT,
									(DWORD) ID_functionwise);
    		        	break;
            } 
            break;

		case WM_SETFOCUS:
        	SetFocus (hEditWnd);
         break;

      case WM_SIZE:
			MoveWindow(hEditWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
         break;

      case WM_QUERYENDSESSION:             /* message: to end the session? */
         return (QuerySaveEditFile(hWnd));

      case WM_CLOSE:                       /* message: close the window    */
         QuerySaveEditFile(hWnd);
			goto TerminEdit;
         break;

		case WM_GETMINMAXINFO:
			break;					/* no sizing */

		case WM_DESTROY:
			PostQuitMessage(0);
			DLGClose();
			break;

      default:
         return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}


#if 0
long FAR PASCAL OverWriteFn (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
	char szLocation[200] ;
	HWND hEdit ;
	int nRetVal ;

 	hEdit = GetDlgItem (hWnd, IDC_EDIT_FROM) ;
	switch (message)
	{
		case WM_INITDIALOG :
			SendDlgItemMessage (hWnd, IDC_EDIT_FROM, EM_LIMITTEXT, 200 - 1, 0L) ;
			MakeFullFileName (TmpStr, ScriptFilesDir, EditFileName) ;
			AnsiUpper (TmpStr) ;
			SetDlgItemText (hWnd, IDC_STATIC_FILE_LOCATION, (LPCSTR) TmpStr) ;
			return TRUE ;

		case WM_COMMAND :
			switch (wParam)
			{
				case IDOK :
					GetDlgItemText (hWnd, IDC_EDIT_FROM, 
							(LPSTR) szLocation, sizeof (szLocation)) ;
					MakeFullFileName (TmpStr, ScriptFilesDir, EditFileName) ;
					nRetVal = OverWrite (szLocation, TmpStr) ;
					switch (nRetVal)
					{
						case 1 :
							MessageBox (hWnd, "Source File Not Found", 
																	"Script", MB_OK) ;
							SetFocus (hEdit) ;
							return FALSE ;

						case 2 :
							MessageBox (hWnd, "Max file size exceeded",
												"Script", MB_OK) ;
							SetFocus (hEdit) ;
							return FALSE ;

						case 3 :
								MessageBox (hWnd,
									"Destination file could not be created",
																	 "Script", MB_OK) ;
								break ;
					}
					bEdited = FALSE ;
					EndDialog (hWnd, TRUE) ;
					return TRUE ;

				case IDCANCEL :
					EndDialog (hWnd, TRUE) ;
					return TRUE ;
			}
	}
	return 0L ;
}
#endif
