// sntpcfg.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "sntpcfg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDotDecimal DotValue;
char	*SNTPMsgHeader="SNTP Setup";
LPCSTR SNTPSectionHeader ="SNTP Client" ;

/////////////////////////////////////////////////////////////////////////////
// SntpCfg dialog


SntpCfg::SntpCfg(CWnd* pParent /*=NULL*/)
	: CDialog(SntpCfg::IDD, pParent)
{
	//{{AFX_DATA_INIT(SntpCfg)
	m_DaylightCheck = FALSE;
	m_SNTPCheck = FALSE;
	m_ServAddStr = "";
	m_TimeZoneStr = "";
	m_TimeOffsetStr = "";
	m_MoveClockStr = "";
	m_StartTimeStr = "";
	m_EndTimeStr = "";
	//}}AFX_DATA_INIT
}

void SntpCfg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SntpCfg)
	DDX_Control(pDX, IDC_STATIC1, m_Static1Ctrl);
	DDX_Control(pDX, IDC_STAT_TIME_OFFSET, m_StatTimeOffsetCtrl);
	DDX_Control(pDX, IDC_STAT_TIME_ZONE, m_StatTimeZoneCtrl);
	DDX_Control(pDX, IDC_TIME_OFFSET, m_TimeOffsetCtrl);
	DDX_Control(pDX, IDC_TIME_ZONE, m_TimeZoneCtrl);
	DDX_Control(pDX, IDC_STAT_SER_ADD, m_StatAddCtrl);
	DDX_Control(pDX, IDC_STATIC2, m_MinStaticCtrl);
	DDX_Control(pDX, IDC_MOVE_CLOCK, m_MoveClockCtrl);
	DDX_Control(pDX, IDC_STAT_MOVE_CLOCK, m_MoveClkCtrl);
	DDX_Control(pDX, IDC_SERVER_ADD, m_ServAddWnd);
	DDX_Control(pDX, IDC_END_TIME, m_EndTimeCtrl);
	DDX_Control(pDX, IDC_START_TIME, m_StartTimeCtrl);
	DDX_Control(pDX, IDC_SNTP_CHECK, m_SNTPWnd);
	DDX_Control(pDX, IDC_STATIC_DLS, m_DLSCtrl);
	DDX_Control(pDX, IDC_STAT_END_TIME, m_StatETime);
	DDX_Control(pDX, IDC_STAT_END_ORDINAL, m_StatEOrdinal);
	DDX_Control(pDX, IDC_STAT_END_MONTH, m_StatEMonth);
	DDX_Control(pDX, IDC_STAT_END_DAY, m_StatEDay);
	DDX_Control(pDX, IDC_STAT_START_DAY, m_StatSDay);
	DDX_Control(pDX, IDC_STAT_START_MONTH, m_StatSMonth);
	DDX_Control(pDX, IDC_STAT_START_ORDINAL, m_StatSOrdinal);
	DDX_Control(pDX, IDC_STAT_START_TIME, m_StatSTime);
	DDX_Control(pDX, IDC_DAY_LIGHT_CHECK, m_DayLightCtrl);
	DDX_Control(pDX, IDC_END_ORDINAL, m_EOrdinalCtrl);
	DDX_Control(pDX, IDC_END_MONTH, m_EMonthCtrl);
	DDX_Control(pDX, IDC_END_DAY, m_EDayCtrl);
	DDX_Control(pDX, IDC_START_ORDINAL, m_SOrdinalCtrl);
	DDX_Control(pDX, IDC_START_DAY, m_SDayCtrl);
	DDX_Control(pDX, IDC_START_MONTH, m_SMonthCtrl);
	DDX_Check(pDX, IDC_DAY_LIGHT_CHECK, m_DaylightCheck);
	DDX_Check(pDX, IDC_SNTP_CHECK, m_SNTPCheck);
	DDX_Text(pDX, IDC_SERVER_ADD, m_ServAddStr);
	DDX_Text(pDX, IDC_TIME_ZONE, m_TimeZoneStr);
	DDX_Text(pDX, IDC_TIME_OFFSET, m_TimeOffsetStr);
	DDX_Text(pDX, IDC_MOVE_CLOCK, m_MoveClockStr);
	DDX_Text(pDX, IDC_START_TIME, m_StartTimeStr);
	DDX_Text(pDX, IDC_END_TIME, m_EndTimeStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(SntpCfg, CDialog)
	//{{AFX_MSG_MAP(SntpCfg)
	ON_BN_CLICKED(IDC_BTN_CANCEL, OnBtnCancel)
	ON_BN_CLICKED(IDC_BTN_HELP, OnBtnHelp)
	ON_BN_CLICKED(IDC_BTN_OK, OnBtnOk)
	ON_BN_CLICKED(IDC_DAY_LIGHT_CHECK, OnDayLightCheck)
	ON_BN_CLICKED(IDC_SNTP_CHECK, OnSntpCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// SntpCfg message handlers

void SntpCfg::OnBtnCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}

void SntpCfg::OnBtnHelp()
{
	AfxGetApp()->WinHelp (0x20000 + IDD_SNTP, HELP_CONTEXT) ;
	
}

void SntpCfg::OnBtnOk()
{
	// TODO: Add your control notification handler code here
	int Index, hrs, min;
	char szRHS[50];

	UpdateData(TRUE);

	if(m_SNTPWnd.GetCheck() == TRUE)
		strcpy(szRHS, "enabled");
	else
		strcpy(szRHS, "disabled");

  	WritePrivateProfileString(SNTPSectionHeader ,
     	  (LPCSTR) "SNTP",(LPSTR)szRHS, (LPCSTR) FileName);

/* Added by Ravi on 14/09/1999 ... */
  	if(m_DaylightCheck == TRUE)
		strcpy(szRHS, "enabled");
	else
		strcpy(szRHS, "disabled");

	WritePrivateProfileString(SNTPSectionHeader ,
 	     (LPCSTR) "SNTP Daylight Savings",(LPSTR)szRHS, (LPCSTR) FileName);
/* ... Added by Ravi on 14/09/1999 */


  if(m_SNTPWnd.GetCheck() == TRUE)
  {			
	DotValue = m_ServAddStr;
	if (m_ServAddStr.IsEmpty())
	{
		DotValue = ZeroIPAddress;
		m_ServAddStr=ZeroIPAddress;
	}	

	if(strcmp(DotValue,ZeroIPAddress) && !DotValue.IsValid())
	{
	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid SNTP Server Address",
		      (LPCSTR) SNTPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_ServAddWnd.SetFocus();
		return;
	}
	
	WritePrivateProfileString(SNTPSectionHeader ,
 	     (LPCSTR) "SNTP Server IP Address",(LPCSTR)m_ServAddStr, (LPCSTR) FileName);
	if(m_TimeZoneStr.IsEmpty())
	{
		strcpy(szRHS,"PDT");
		m_TimeZoneStr = szRHS;
	}

	WritePrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP TimeZone Standard Name",
		  (LPCSTR)m_TimeZoneStr, (LPCSTR) FileName);


	DotValue = m_TimeOffsetStr;
	if(!DotValue.IsValidTime())
	{
	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Offset Time\n Enter in hh:mm format",
		      (LPCSTR) SNTPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}
	strcpy(szRHS, m_TimeOffsetStr);
	sscanf(szRHS, "%02d:%02d", &hrs, &min);
	wsprintf(szRHS, "%02d:%02d", hrs, min);
	WritePrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP Offset From UTC", 
		  (LPSTR)szRHS, (LPCSTR) FileName);

	WritePrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Offset", 
		  (LPCSTR)m_MoveClockStr, (LPCSTR) FileName);

	if(m_DaylightCheck == TRUE)
		strcpy(szRHS, "enabled");
	else
		strcpy(szRHS, "disabled");

	WritePrivateProfileString(SNTPSectionHeader ,
 	     (LPCSTR) "SNTP Daylight Savings",(LPSTR)szRHS, (LPCSTR) FileName);

	if(m_DaylightCheck == TRUE)
	{
		Index = m_SOrdinalCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index+1);
		WritePrivateProfileString(SNTPSectionHeader ,
 	 	    (LPCSTR) "SNTP Daylight Start Day", (LPSTR)szRHS, (LPCSTR) FileName);

		Index = m_SDayCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight Start WeekDay",(LPSTR)szRHS, (LPCSTR) FileName);
	
		Index = m_SMonthCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index+1);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight Start Month",(LPSTR)szRHS, (LPCSTR) FileName);
	
		DotValue = m_StartTimeStr;
		if(!DotValue.IsValidTime())
		{
		   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Time\n Enter in hh:mm format",
			      (LPCSTR) SNTPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_StartTimeCtrl.SetFocus();
			return;
		}		
		strcpy(szRHS,m_StartTimeStr);
		sscanf(szRHS, "%02d:%02d", &hrs, &min);
		wsprintf(szRHS, "%d", hrs);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight Start Time Hour",(LPSTR)szRHS, (LPCSTR) FileName);
	
		wsprintf(szRHS, "%d", min);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight Start Time Minute",(LPSTR)szRHS, (LPCSTR) FileName);
	
		Index = m_EOrdinalCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index+1);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight End Day",(LPSTR)szRHS, (LPCSTR) FileName);
	
		Index = m_EDayCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight End WeekDay",(LPSTR)szRHS, (LPCSTR) FileName);
	
		Index = m_EMonthCtrl.GetCurSel();
		wsprintf(szRHS, "%d", Index+1);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight End Month",(LPSTR)szRHS, (LPCSTR) FileName);


		DotValue = m_EndTimeStr;
		if(!DotValue.IsValidTime())
		{
		   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Time\n Enter in hhhh:mmmm format",
			      (LPCSTR) SNTPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_EndTimeCtrl.SetFocus();
			return;
		}		
		strcpy(szRHS,m_EndTimeStr);
		sscanf(szRHS, "%02d:%02d", &hrs, &min);
		wsprintf(szRHS, "%d", hrs);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight End Time Hour",(LPSTR)szRHS, (LPCSTR) FileName);

		wsprintf(szRHS, "%d", min);
		WritePrivateProfileString(SNTPSectionHeader ,
	 	     (LPCSTR) "SNTP Daylight End Time Minute",(LPSTR)szRHS, (LPCSTR) FileName);
	}
  }

	CDialog::OnOK();
}

void SntpCfg::EnableDayLightSavings()
{
		m_SOrdinalCtrl.EnableWindow(TRUE);
		m_SDayCtrl.EnableWindow(TRUE);
		m_SMonthCtrl.EnableWindow(TRUE);
		m_StartTimeCtrl.EnableWindow(TRUE);
		m_EOrdinalCtrl.EnableWindow(TRUE);
		m_EDayCtrl.EnableWindow(TRUE);
		m_EMonthCtrl.EnableWindow(TRUE);
		m_EndTimeCtrl.EnableWindow(TRUE);
		m_MoveClkCtrl.EnableWindow(TRUE);

		m_StatSOrdinal.EnableWindow(TRUE);
		m_StatSDay.EnableWindow(TRUE);
		m_StatSMonth.EnableWindow(TRUE);
		m_StatSTime.EnableWindow(TRUE);
		m_StatEOrdinal.EnableWindow(TRUE);
		m_StatEDay.EnableWindow(TRUE);
		m_StatEMonth.EnableWindow(TRUE);
		m_StatETime.EnableWindow(TRUE);
		m_MoveClockCtrl.EnableWindow(TRUE);

		m_DLSCtrl.EnableWindow(TRUE);
		m_MinStaticCtrl.EnableWindow(TRUE);
}

void SntpCfg::DisableDayLightSavings()
{
		m_SOrdinalCtrl.EnableWindow(FALSE);
		m_SDayCtrl.EnableWindow(FALSE);
		m_SMonthCtrl.EnableWindow(FALSE);
		m_StartTimeCtrl.EnableWindow(FALSE);
		m_EOrdinalCtrl.EnableWindow(FALSE);
		m_EDayCtrl.EnableWindow(FALSE);
		m_EMonthCtrl.EnableWindow(FALSE);
		m_EndTimeCtrl.EnableWindow(FALSE);
		m_MoveClkCtrl.EnableWindow(FALSE);

		m_StatSOrdinal.EnableWindow(FALSE);
		m_StatSDay.EnableWindow(FALSE);
		m_StatSMonth.EnableWindow(FALSE);
		m_StatSTime.EnableWindow(FALSE);
		m_StatEOrdinal.EnableWindow(FALSE);
		m_StatEDay.EnableWindow(FALSE);
		m_StatEMonth.EnableWindow(FALSE);
		m_StatETime.EnableWindow(FALSE);
		m_MoveClockCtrl.EnableWindow(FALSE);

		m_DLSCtrl.EnableWindow(FALSE);
		m_MinStaticCtrl.EnableWindow(FALSE);
}

void SntpCfg::OnDayLightCheck()
{
	// TODO: Add your control notification handler code here
	if(m_DayLightCtrl.GetCheck())
		EnableDayLightSavings();
	else
		DisableDayLightSavings();
}

BOOL SntpCfg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDC_BTN_OK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDC_BTN_CANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_BTN_HELP, this));
	HelpBitmapBtn.SizeToContent();

	char	szRHS[40], time[20];
	UINT Index, hrs, min;
	strcpy(FileName, IniInWinForm);

#if Ravi
	GetPrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP", (LPCSTR) StrNull, 
							(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);

	if(!strcmp(szRHS,"enabled"))
	{
		m_SNTPCheck = TRUE;
		m_SNTPWnd.SetCheck(TRUE);
		EnableSntpClient();
	}
	else
	{
		m_SNTPCheck = FALSE;
		m_SNTPWnd.SetCheck(FALSE);
		DisableSntpClient();
	}
#endif

	GetPrivateProfileString(SNTPSectionHeader, (LPCSTR) "SNTP Server IP Address", ZeroIPAddress,
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);
	m_ServAddStr = szRHS;

	GetPrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP TimeZone Standard Name", "PDT",
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);
	m_TimeZoneStr = szRHS;

	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Offset", 
				60, (LPCSTR) FileName);
	sprintf(szRHS, "%d", Index);
	m_MoveClockStr =	szRHS;

	GetPrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP Offset From UTC", "60:00",
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);
	m_TimeOffsetStr =	szRHS;

	GetPrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Savings", (LPCSTR) StrNull,
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);
	if(!strcmp(szRHS,"enabled"))
	{
		m_DayLightCtrl.SetCheck(TRUE);
		m_DaylightCheck = TRUE;
		EnableDayLightSavings();
	}
	else
	{
		m_DayLightCtrl.SetCheck(FALSE);
		m_DaylightCheck = FALSE;
		DisableDayLightSavings();
	}
	
	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Start Day",
		  0, (LPCSTR) FileName);
	m_SOrdinalCtrl.SetCurSel(Index-1);

	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Start WeekDay",
		  0, (LPCSTR) FileName);
	m_SDayCtrl.SetCurSel(Index);
		
	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Start Month",
		  0, (LPCSTR) FileName);
	m_SMonthCtrl.SetCurSel(Index-1);

	hrs = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Start Time Hour",
		  0, (LPCSTR) FileName);

	min = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight Start Time Minute",
		  0, (LPCSTR) FileName);

	sprintf(time, "%02d:%02d", hrs, min);
	m_StartTimeStr = time;
	
	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight End Day",
		  0, (LPCSTR) FileName);
	m_EOrdinalCtrl.SetCurSel(Index-1);

	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight End WeekDay",
		  0, (LPCSTR) FileName);
	m_EDayCtrl.SetCurSel(Index);
		
	Index = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight End Month",
		  0, (LPCSTR) FileName);
	m_EMonthCtrl.SetCurSel(Index-1);

	hrs = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight End Time Hour",
		  0, (LPCSTR) FileName);

	min = GetPrivateProfileInt(SNTPSectionHeader ,(LPCSTR) "SNTP Daylight End Time Minute",
		  0, (LPCSTR) FileName);

	sprintf(time, "%02d:%02d", hrs, min);
	m_EndTimeStr = time;

/* Moved by Ravi From top. 14/09/1999 ... */
	GetPrivateProfileString(SNTPSectionHeader ,(LPCSTR) "SNTP", (LPCSTR) StrNull, 
							(LPSTR)szRHS, sizeof(szRHS), (LPCSTR) FileName);
	if(!strcmp(szRHS,"enabled"))
	{
		m_SNTPCheck = TRUE;
		m_SNTPWnd.SetCheck(TRUE);
		EnableSntpClient();
		OnDayLightCheck();
	}
	else
	{
		m_SNTPCheck = FALSE;
		m_SNTPWnd.SetCheck(FALSE);
		DisableSntpClient();
	}
/* ... Moved by Ravi From top. 14/09/1999 */

	UpdateData(FALSE);	//display data in dialog
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void SntpCfg::EnableSntpClient()
{
	m_Static1Ctrl.EnableWindow(TRUE);
	m_StatTimeOffsetCtrl.EnableWindow(TRUE);
	m_TimeZoneCtrl.EnableWindow(TRUE);
	m_StatTimeZoneCtrl.EnableWindow(TRUE);
	m_TimeOffsetCtrl.EnableWindow(TRUE);
	m_StatAddCtrl.EnableWindow(TRUE);
	m_ServAddWnd.EnableWindow(TRUE);
	m_DayLightCtrl.EnableWindow(TRUE);
	EnableDayLightSavings();
}


void SntpCfg::DisableSntpClient()
{
	m_Static1Ctrl.EnableWindow(FALSE);
	m_StatTimeOffsetCtrl.EnableWindow(FALSE);
	m_TimeZoneCtrl.EnableWindow(FALSE);
	m_StatTimeZoneCtrl.EnableWindow(FALSE);
	m_TimeOffsetCtrl.EnableWindow(FALSE);
	m_StatAddCtrl.EnableWindow(FALSE);
	m_ServAddWnd.EnableWindow(FALSE);
	m_DayLightCtrl.EnableWindow(FALSE);
	DisableDayLightSavings();
} 


void SntpCfg::OnSntpCheck()
{
	// TODO: Add your control notification handler code here
	if(m_SNTPWnd.GetCheck() == TRUE)
		EnableSntpClient();
	else
		DisableSntpClient();
}
