#include <windows.h>
#include <winsock.h>
#include <stdio.h>

#include "tnetcons.h"
#include "tnetif.h"

#define WM_TELNET_READ (WM_USER + 62)

void *memset (void *, int, int) ;

#define TELNET_PORT  	23

#define MAJOR_VERSION	1
#define MINOR_VERSION	2
#define WSA_MAKEWORD(x,y)	((y) * 256 + (x)) /* HI:Minor, LO:Major */

char WinsockDLL[] = "WINSOCK.DLL" ;
int VersionRequested = WSA_MAKEWORD (MAJOR_VERSION, MINOR_VERSION) ;
int TelnetClientSocket, LastError ;
unsigned long ServerIPAddress ;

HINSTANCE WinsockHandle ;

int (PASCAL FAR *DWSAStartup)(WORD wVersionRequired, LPWSADATA lpWSAData);
int (PASCAL FAR *DWSACleanup)(void);
int (PASCAL FAR *DWSAGetLastError)(void);
int (PASCAL FAR *DWSAAsyncSelect)(SOCKET s, HWND hWnd, u_int wMsg,long lEvent);
int (PASCAL FAR *Dclosesocket)(SOCKET s);
int (PASCAL FAR *Dbind)(SOCKET s, const struct sockaddr FAR *addr, int namelen);
int (PASCAL FAR *Drecv)(SOCKET s, char FAR * buf, int len, int flags) ;
int (PASCAL FAR *Dsend)(SOCKET s, const char FAR * buf, unsigned int len, int flags);
SOCKET (PASCAL FAR *Dsocket)(int af, int type, int protocol);
int (PASCAL FAR *Dconnect)(SOCKET Socket, const struct sockaddr FAR *Name, int NameLength);
u_short (PASCAL FAR *Dntohs)(u_short netshort);
u_long (PASCAL FAR *Dntohl)(u_long netlong);
u_short (PASCAL FAR *Dhtons)(u_short hostshort);

unsigned long TelnetTimerCount = 0xFF ;
void FAR PASCAL __loadds TelnetTimer (void)
{
	if (TelnetTimerCount)
		TelnetTimerCount-- ;
}

int FAR PASCAL __loadds TelnetProcess (char *Buffer, int MaxLength, unsigned int *BufferLength)
{
	int ret ;

	ret = Drecv (TelnetClientSocket, Buffer, MaxLength, 0) ;
	if ((ret == SOCKET_ERROR) || (ret == 0))
	{
		*BufferLength = 0 ;
		return (DWSAGetLastError()) ;
	}

	*BufferLength = (unsigned int)ret ;
	return 0 ;
}

void FAR PASCAL _loadds TelnetSend (char *Buffer, int unsigned BufferLength)
{
	Dsend (TelnetClientSocket, Buffer, BufferLength, 0) ;
}


enum TELNET_CLIENT_INIT_RESULT FAR PASCAL _loadds TelnetInit (HWND WindowHandle, unsigned char IPAddressString[])
{
	WSADATA wsaData ;
	int ret ;
	struct sockaddr_in LocalSocket ;
	struct sockaddr_in RemoteSocket ;
	char *TempPointer ;
	int t1, t2, t3, t4, c ;

	sscanf (&IPAddressString[0], "%d%c%d%c%d%c%d", &t1, &c, &t2, &c, &t3, &c, &t4) ;
	TempPointer = (char *)&ServerIPAddress ;
	TempPointer[0] = t1 ;
	TempPointer[1] = t2 ;
	TempPointer[2] = t3 ;
	TempPointer[3] = t4 ;

	WinsockHandle = LoadLibrary (WinsockDLL) ;
	if (WinsockHandle < HINSTANCE_ERROR)
	{
		return (LOAD_LIBRARY_FAILED) ;
	}

	if ((DWSAStartup = GetProcAddress (WinsockHandle, "WSAStartup")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((DWSACleanup = GetProcAddress (WinsockHandle, "WSACleanup")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((DWSAGetLastError = GetProcAddress (WinsockHandle, "WSAGetLastError")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((DWSAAsyncSelect = GetProcAddress (WinsockHandle, "WSAAsyncSelect")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dclosesocket = GetProcAddress (WinsockHandle, "closesocket")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dbind = GetProcAddress (WinsockHandle, "bind")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Drecv = GetProcAddress (WinsockHandle, "recv")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dsend = GetProcAddress (WinsockHandle, "send")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dsocket = GetProcAddress (WinsockHandle, "socket")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dconnect = GetProcAddress (WinsockHandle, "connect")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dntohs = GetProcAddress (WinsockHandle, "ntohs")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dntohl = GetProcAddress (WinsockHandle, "ntohl")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	if ((Dhtons = GetProcAddress (WinsockHandle, "htons")) == NULL)
	{
		FreeLibrary (WinsockHandle) ;
		return (GET_PROC_FAILED) ;
	}

	ret = DWSAStartup (VersionRequested, &wsaData) ;
	if (ret != 0)
	{
		FreeLibrary (WinsockHandle) ;
		switch (ret)
		{
			case (WSASYSNOTREADY) :
				return (NETWORK_SUBSYSTEM_NOT_READY) ;

			case (WSAVERNOTSUPPORTED) :
				return (VERSION_NOT_SUPPORTED) ;

			default :
				return (FAILURE) ;
		}
	}

	TelnetClientSocket = Dsocket (PF_INET, SOCK_STREAM, 0) ;
	if (TelnetClientSocket == INVALID_SOCKET)
	{
		LastError = DWSAGetLastError () ;
		FreeLibrary (WinsockHandle) ;
		return (SOCKET_OPEN_FAILED) ;
	}

	memset (&LocalSocket, 0, sizeof (LocalSocket)) ;
	LocalSocket.sin_family = PF_INET ;

	ret = Dbind (TelnetClientSocket, (struct sockeddr FAR *)&LocalSocket, sizeof (LocalSocket)) ;
	if (ret != 0)
	{
		LastError = DWSAGetLastError () ;
		Dclosesocket (TelnetClientSocket) ;
		FreeLibrary (WinsockHandle) ;
		return (BIND_FAILED) ;
	}

	memset (&RemoteSocket, 0, sizeof (RemoteSocket)) ;
	RemoteSocket.sin_family = PF_INET ;
	RemoteSocket.sin_addr.s_addr = ServerIPAddress ;
	RemoteSocket.sin_port = Dhtons (TELNET_PORT) ;
	if (Dconnect (TelnetClientSocket, &RemoteSocket, sizeof (struct sockaddr_in)) != 0)
	{
		LastError = DWSAGetLastError () ;
		Dclosesocket (TelnetClientSocket) ;
		FreeLibrary (WinsockHandle) ;
		return (CONNECT_FAILED) ;
	}

	ret = DWSAAsyncSelect (TelnetClientSocket, WindowHandle, WM_TELNET_READ, FD_READ) ;
	if (ret != 0)
	{
		LastError = DWSAGetLastError () ;
		Dclosesocket (TelnetClientSocket) ;
		FreeLibrary (WinsockHandle) ;
		return (ASYNC_SELECT_FAILED) ;
	}

	return (SUCCESS) ;
}

void FAR PASCAL __loadds TelnetDeInit (void)
{
	Dclosesocket (TelnetClientSocket) ;
	FreeLibrary (WinsockHandle) ;

	return ;
}
