/*----------------------------------------------------------------------------
*	File		:	EMLNDATA.c
*	Purpose		:	data structure declarations for Terminal Emulation
*	Package		:	MultiExpress (Windows) - Version 2.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

#include	"windows.h"

#include	"emlntype.h"
#include	"emlncons.h"
#include	"emlnfuns.h"

BYTE	*TermFileExtn = ".trm";
BYTE	*TmpTermFileExtn = ".~rm";
BYTE	Terminals[MAX_NO_OF_TERMINALS][TERM_NAME_LEN] = {"VT100"};
BYTE	NoOfTerminals;

BYTE	BackSpaceChar = 0x08;		/*	Back space character.			*/
BYTE	Attribute;					/*	Attribute for the character to	*/
BYTE	EmlnAttribute;					/*	Attribute for the character to	*/
									/*	be displayed.					*/
BYTE	GraphicsAdd = 0;
BYTE	SuppressEcho = 0;

BYTE	EmlnVT100originMode;			/*	Sets row for home position; 0	*/
										/*	for top left corner, else 1.	*/
BYTE	EmlnVT100insertMode;			/*	Set if in insert mode.			*/
BYTE	EmlnVT100charSet;				/*	To save character set.			*/
BYTE	*EmlnVT100_G0charSet;			/*	To save G0 character set.		*/
BYTE	*EmlnVT100_G1charSet;			/*	To save G1 character set.		*/
BYTE	EmlnArgs[MAX_EMLN_ARGS];	/*	Argument list for a command.	*/
BYTE	EmlnArgCnt;					/*	No. of arguments read so far.	*/
WORD	EmlnCursorPosition;			/*	To save cursor position.		*/
WORD	EmlnCursorType;				/*	To save cursor type.			*/

WORD	CurrentState;				/*	Current state.					*/
WORD	NoOfStates;					/*	Total no. of states in state mc.*/
StateType	*StateTable;			/*	State transition table pointer.	*/

KeyExpansionType	*KeyExpansion;		/*	Pointer to array of records		*/
										/*	having expasnion strings for	*/
										/*	various keys. This array should	*/
										/*	be terminated with a key value	*/
										/*	of KEY_NOT_PRESENT(0xffff).		*/

										/*	List of function pointers for	*/
										/*	terminal emulation - the last	*/
										/*	value should be null.			*/
void	(*EmulnFnTable[])() = {
	NULL, EchoChar, CursorUp, CursorDown, CursorRight, CursorLeft,
	DelToBeginningOfLine, DelToEndOfLine, EmlnClearScreen, ComputeArg,
	AdvanceArg, EmlnSetCursor, ClearFromCursor, BeginReverseVideo,
	EndReverseVideo, ShowHexValue, EraseChar, DisplayCharacter, AdvanceCursor,
	EraseInLine, BeginHighlight, EndHighlight, BeginBlink, EndBlink,
	SetToNormalAttribute, ClearUptoCursor, SetANSIcolors, SaveCursorPosition,
	RestoreCursorPosition, SaveCursorType, RestoreCursorType, MoveToNextLine,
	PrintScreen, ComputeOffsetArg, TurnOnPrintRedirection,
	TurnOffPrintRedirection, TurnOnNumlock, TurnOffNumlock, InsertLine,
	EmlnScrollUp, TurnOnGraphics, TurnOffGraphics, InsertChar, ANSIdeviceStatReq,
	VT100terminalStatReq, VT100deviceQuery, VT100printerStatReq,
	MoveToPrevLine, VT100printControl, SetVT100termParams,
	ResetVT100termParams, SetVT100LocalEcho, ResetVT100LocalEcho,
	SetVT100CharSet_0, SetVT100CharSet_1, SelectVT100CharSet_0,
	SelectVT100CharSet_1, VT100EchoChar, VT100cancelSeq, DeleteLine,
	SetVT100scrollRegion, MoveToLineBegin,
	StripHighBit, CheckVT100screenAlignment, SetVT100insertMode,
	ResetVT100insertMode, NULL
};

int		NoOfFunctions = sizeof(EmulnFnTable) / sizeof(EmulnFnTable[0]);

BYTE	VT100charSet;	/*	Currently active VT100 character set.	*/
BYTE	*VT100_G0charSet;
BYTE	*VT100_G1charSet;
BYTE	VT100_UScharSet[] = {
			0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
			0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
			0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
			0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
			0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
			0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
			0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
			0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
			0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
			0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
			0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
			0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
			0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
			0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
			0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x00,
};
BYTE	VT100_UKcharSet[] = {
			0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
			0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
			0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
			0x20, 0x21, 0x22, 0x9c, 0x24, 0x25, 0x26, 0x27,
			0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
			0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
			0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
			0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
			0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
			0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
			0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
			0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
			0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
			0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
			0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x00,
};
BYTE	VT100_SpecialCharSet[] = {
			0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
			0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
			0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
			0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
			0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
			0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
			0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
			0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
			0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
			0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
			0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x20,
			0x04, 0xb0, 0x48, 0x46, 0x43, 0x4c, 0xf8, 0xf1,
			0x4e, 0x56, 0xd9, 0xbf, 0xda, 0xc0, 0xc5, 0xc4,
			0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0xb4, 0xc1, 0xc2,
			0xb3, 0xf3, 0xf2, 0xe3, 0xd8, 0x9c, 0x2e, 0x00,
};
#ifdef OPENFILE
OFSTRUCT	OfDumpFileStruct;
#endif

int	hTermDC;					/* the global terminal DC */
WORD	LinesInScreen;			/* Number of lines in screen */
WORD	CellsInLine;			/* number of characters per line */

/*-----------------------  Last  Line  ----------------------------------- */
