/*----------------------------------------------------------------------------
*	File		:	EMLNTYPE.H
*	Purpose		:	typedefs fot terminal emulation
*	Package		:	MultiExpress (Windows) - Version 2.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

typedef	struct tagKeyExp {
	WORD	Key;						/*	Key to be expanded.				*/
	BYTE	*Expansion;					/*	Expansion for the key.			*/
	struct	tagKeyExp *Next;					/* next pointer */
} KeyExpansionType;

typedef	struct {
	WORD	State;						/*	Current state to match.			*/
	BYTE	LoCh;						/*	Character range, low value.		*/
	BYTE	HiCh;						/*	Character range, high value.	*/
	WORD	NextState;					/*	Next state to move to.			*/
	BYTE	Transition;					/*	Set to force invoking next hdlr.*/
	void	(*Hdlr)(void);				/*	Handler to be called for input.	*/
} StateType;

typedef	struct {
	StateType	*TablePtr;				/*	State transition table pointer.	*/
	WORD	NoOfStates;					/*	Max no. of states in table.		*/
} StateMcType;

typedef	struct	{
	BYTE	*KeyStr;					/*	Key decription string.			*/
	BYTE	*ExpnStr;					/*	Key expansion string.			*/
} KeyExpnStrType;

/* Skip struct. This is used to skip some settings info contained in the
ME TRM files. MEW get them from the MEW Phone book entry Info. Not from
the TRM files */
typedef struct tagSkipStruct{
	BYTE	AutoMargin;
	BYTE	BackSpace;
	BYTE	OverStrike;
	BYTE	BackSpaceBlank;
	BYTE	WrapBackSpace;
	BYTE	StandOutScroll;
	BYTE	LinesInScreen;
	BYTE	CharsInLine;
} SkipStructType;
