/*--------------------------------------------------------------------------*/
/*	File		:	EMULN.C													*/
/*	Purpose		:	Emulation init and "trm" files related stuff			*/
/*	Package		:	MultiExpress (W).										*/
/*	Authors		:	S. Narasimhan. (Vidy)									*/
/*	Date		:	November 25, 1990.										*/
/*--------------------------------------------------------------------------*/

#include	<windows.h>

#include	"session.h"
#include	"main.h"

#include	"emlnfuns.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlndata.h"
#include	"wstdio.h"

#include	"status.h"
#include	"file.h"
#include	"kbd.h"
#include	"sys\types.h"
#include	"stdio.h"
#include	"dos.h"
#include	"io.h"
#include	"fcntl.h"
#include	"sys\stat.h"
#include	"scroll.h"

/***************************************************************************
*	Routine	:	ChangeEmulationType (BYTE *newtype)
*	Input	:	pointer to the new type name string
*	Return	:	TRUE if changed successfully else FALSE
*	Synopsis:	Checks if there is a valid description file.
*				if it is present, the old information is discarded and new
*				type is setup
***************************************************************************/
BOOL	ChangeEmulationType (BYTE *newtype)
{

	ClearScreen();
	ResetScrollBuffer();
	lstrcpy (PbkEntry.TrmParams.TermName, newtype);
	return InitEmulation();
}

extern	BYTE	ForceFormFeed;	// force a form feed at end of printing
/*--------------------------------------------------------------------------*/
/*	Name		:	InitEmulation											*/
/*	Input		:	None													*/
/*	Output		:	None													*/
/*	Synopsis	:	Initializes terminal emulation.							*/
/*--------------------------------------------------------------------------*/

BYTE	InitEmulation(void)
{

	PurgeTermInfo();					/*	Purge the earlier entry.		*/
	if ( !*TRMPRMS.TermName)
		lstrcpy (PbkEntry.TrmParams.TermName, "TTY");	/* make it a dumb tty */
	if (!ReadTermInfo(PbkEntry.TrmParams.TermName)) {
		lstrcpy (PbkEntry.TrmParams.TermName, "TTY");	/* make it a dumb tty */
//		UpdateStatusBar(TTY_FLD_IDX);
		ScrollTopMargin = 0;
		ScrollBottomMargin = (BYTE) (LinesInScreen - 1);
		return(FALSE);
	}
	Attribute = NormAttrib;
	ScrollTopMargin = 0;
	ScrollBottomMargin = (BYTE) (LinesInScreen - 1);
	CurrentState = 0;
	GraphicsAdd = SuppressEcho = 0;
	ForceFormFeed = 0;	/*	No form feed on print termination.	*/
	EmlnVT100_G0charSet = EmlnVT100_G1charSet = VT100_G0charSet =
									VT100_G1charSet = VT100_UScharSet;
	EmlnVT100charSet = VT100charSet = 0;
	EmlnVT100originMode = 0;	/*	Top left corner for home cursor.	*/
	EmlnVT100insertMode = 0;	/*	Set insert mode off.	*/
	ResetArgs();

	return(TRUE);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	ReadTermInfo											*/
/*	Input		:	terminal name											*/
/*	Output		:	true/false												*/
/*	Synopsis	:	Reads terminal info file and initializes key expansions	*/
/*						and state machine description. If error in			*/
/*						allocating memory false is returned, else true.		*/
/*						StateTable, NoOfStates, & KeyExpansion are updated.	*/
/*--------------------------------------------------------------------------*/

BYTE	ReadTermInfo(BYTE *term_name)
{
	int		file_handle;
	WORD	i, idx;
	WORD	expansion_info_len;
	WORD	no_of_keys;
	WORD	escape_seqs_len;
	BYTE	*ptr;
	BYTE	file_name[PATH_NAME_LEN + FILE_NAME_LEN - 1];
	SkipStructType	SkipStruct;
	KeyExpansionType	*tmpptr, *lastptr;

	StateTable = NULL;
	NoOfStates = 0;
	KeyExpansion = NULL;

	MakeFullFileName(file_name, LoadPath, term_name);
//	MakeFullFileName(file_name, ".\\", term_name);
	lstrcat(file_name, TermFileExtn);

	if ((file_handle = _lopen(file_name, READ)) == EOF) {
		LoadString(hInst, 299, TmpStr, 128);
		DispMsgBox_s(GetFocus(), MSG_FILEOPEN, TmpStr, term_name, MB_OK);
		return(FALSE);
	}
	if (_lread(file_handle, &expansion_info_len, sizeof(expansion_info_len)) !=
												sizeof(expansion_info_len)) {
		goto error_exit;
	}
	if (_lread(file_handle, &no_of_keys, sizeof(no_of_keys)) !=
														sizeof(no_of_keys)) {
		goto error_exit;
	}
	/* First _lreadin the keys after allocating nodes */
	for ( idx = 0; idx < no_of_keys; idx++) {

		/* Get memory for this node */
		if ( !(tmpptr = ( KeyExpansionType *) MemAlloc(sizeof(KeyExpansionType))))
			goto error_exit;
	
		/* Fill the Key slot by reading */
		if (_lread(file_handle, &tmpptr->Key, sizeof(WORD)) != sizeof(WORD))
			goto error_exit;

		/* make the Expansion NULL */
		tmpptr->Expansion = NULL;
		tmpptr->Next = NULL;

		/* add this to the existing KeyExpansion list */
		if ( !KeyExpansion) {	/* the head is null */
			KeyExpansion = lastptr = tmpptr;
		} else {
			lastptr->Next = tmpptr;
			lastptr = tmpptr;
		}
	}

	tmpptr = KeyExpansion;
	/* next readin the strings after allocating memory */
	for ( idx = 0; idx < no_of_keys; idx++, tmpptr = tmpptr->Next) {
		/* Read one string from the file into TmpStr */
		for (i = 0; ; i++) {
			if (_lread(file_handle, &TmpStr[i], sizeof(BYTE)) != sizeof(BYTE))
				goto error_exit;
			if ( ! TmpStr[i])
				break;
		}
//		CnvtToPrintableSeq (&TmpStr[128], TmpStr); // +670 mdmdial.c

		/* allocate memory for this string */
		if (!(tmpptr->Expansion = (BYTE *)
							MemAlloc(lstrlen(&TmpStr[128]) + 1)))
			goto error_exit;

		/* copy this Expansion into the proper place */
		lstrcpy(tmpptr->Expansion, &TmpStr[128]);
	}

	/* Cleanup the list by removing the Keys with NULL expansion strings */
	KeyExpansion = RemoveNullExpansions(KeyExpansion);

	if (_lread(file_handle, (BYTE *) &escape_seqs_len, sizeof(escape_seqs_len)) !=
													sizeof(escape_seqs_len)) {
		goto error_exit;
	}
	if (_llseek(file_handle, (long) escape_seqs_len, SEEK_CUR) == (long) -1) {
		goto error_exit;
	}

	/* This is to skip a whole lot of information  which are stored in the
	ME trm files. MEW Gets these things from the session params file and
	not from the TRM files */

	if (_lread(file_handle, &SkipStruct, sizeof(SkipStruct)) !=
													sizeof(SkipStruct)) {
		goto error_exit;
	}
										/*	Read state machine description.	*/
	if (_lread(file_handle, &NoOfStates, sizeof(NoOfStates)) !=
														sizeof(NoOfStates)) {
		goto error_exit;
	}
	if (!(ptr = (BYTE *) MemAlloc( NoOfStates * sizeof(StateType)))) {
		goto error_exit;
	}
	StateTable = (StateType *) ptr;
	for (idx = 0; idx < NoOfStates; idx++) {
		if (_lread(file_handle, (BYTE *) &StateTable[idx], sizeof(StateType)) !=
														sizeof(StateType)) {
			goto error_exit;
		}
		if (FP_OFF(StateTable[idx].Hdlr) >= (WORD) (NoOfFunctions - 1))
			StateTable[idx].Hdlr = 0;	/* unsupported fn. Ignore */
		else							/*	Convert index to function ptr.	*/
			StateTable[idx].Hdlr = EmulnFnTable[FP_OFF(StateTable[idx].Hdlr)];
	}
	_lclose(file_handle);
//	UpdateStatusBar (TTY_FLD_IDX); /* Update emln type */
	return(TRUE);

error_exit :
	PurgeTermInfo();
	_lclose(file_handle);
	return(FALSE);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PurgeTermInfo											*/
/*	Input		:	None													*/
/*	Output		:	None													*/
/*	Synopsis	:	This routine releases memory taken by term info.		*/
/*--------------------------------------------------------------------------*/

void	PurgeTermInfo(void)
{
	if (KeyExpansion) {
		PurgeExpList(KeyExpansion);
		KeyExpansion = NULL;
	}
	if (StateTable) {
		MemFree ((LPSTR) StateTable);
		StateTable = NULL;
	}
	NoOfStates = 0;
}

/*--------------------------------------------------------------------------*/
/*	Name		:	SetTermDefaultCfg										*/
/*	Input		:	None													*/
/*	Output		:	None													*/
/*	Synopsis	:	This routine sets the deafult configuration.			*/
/*--------------------------------------------------------------------------*/

void	SetTermDefaultCfg(void)
{
	PbkEntry.TrmParams.AddLFtoCR = FALSE;
	PbkEntry.TrmParams.EchoOn = FALSE;
	PbkEntry.TrmParams.TabStops = DEFAULT_TAB_STOP;
	PbkEntry.TrmParams.AutoMargin = TRUE;
	PbkEntry.TrmParams.BackSpace = TRUE;
	PbkEntry.TrmParams.OverStrike = TRUE;
	PbkEntry.TrmParams.BackSpaceBlank = TRUE;
	PbkEntry.TrmParams.WrapBackSpace = TRUE;
	PbkEntry.TrmParams.StandOutScroll = TRUE;
	PbkEntry.TrmParams.FollowCursor = FALSE;
//	Initing the terminal type and purging kbd mapping is also to be done
	PbkEntry.TrmParams.LinesInScreen = DEF_LINES_IN_SCREEN;
	PbkEntry.TrmParams.CharsInLine = DEF_CHARS_IN_LINE;
	lstrcpy(TRMPRMS.TermName, "ANSI");
	ScrollTopMargin = (BYTE)0;
	ScrollBottomMargin = (BYTE)DEF_LINES_IN_SCREEN - 1;
}


/***************************************************************************
*	Routine	:	WriteFnKeysInfo(BYTE *filename)
*	Input	:	
*	Return	:	Returns FALSE in case some problem, else TRUE
*	Synopsis:	This routine rewrites the current trm file with the new
*				key mapping information
***************************************************************************/
BOOL	WriteFnKeysInfo (BYTE *filename, KeyExpansionType *keylist)
{
	return TRUE;
}
/***********************   Last  Line 	************************************/

