/****************************************************************************
 * Filename   : fonts.c
 * Purpose    : This file contains the functions to handle fonts selection
 *				for the terminal window.
 ****************************************************************************/

#include	<windows.h>

#include "mew.h"
#include "main.h"
#include	"fonts.h"
#include	"wstdio.h"
#include	"windisp.h"
#include <commdlg.h>
#include	"dlgbox.h"
#include	"file.h"

LOGFONT 	TerminalLogFont = {
		-12, 0, 0, 0, FW_NORMAL, 0, 0, 0, DEFAULT_CHARSET,
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		FIXED_PITCH, "System"};

/****************************************************************************
Routine	:	
Input	:	
Return	:	
Synop	:	
****************************************************************************/
int CALLBACK EnumFontCallBack(LOGFONT FAR *lpNLF, TEXTMETRIC FAR *lpNTM,
					int FontType, LPARAM lParam)
{
	LPSTR ptr = (LPSTR)lParam;

	if ( !lstrcmp (TerminalLogFont.lfFaceName, lpNLF->lfFaceName))
		if ((lpNLF->lfPitchAndFamily & 3) == FIXED_PITCH) {
			*(BOOL FAR *)lParam = TRUE;
			return 0;
		}
	return 1;
}
/****************************************************************************
Routine	:	RatifyFontVals(void)
Input	:	None
Return	:	None
Synop	:	Checks the TerminalLogFont fields and corrects illegal vals
****************************************************************************/
BOOL
RatifyFontVals(void)
{
	FONTENUMPROC	lpEnumFontCallBack;
	int	Found = FALSE;

	if (TerminalLogFont.lfHeight > MAX_FONT_HEIGHT ||
								TerminalLogFont.lfHeight < -MAX_FONT_HEIGHT)
		TerminalLogFont.lfHeight = DEF_TERM_CHAR_HEIGHT;
	if (TerminalLogFont.lfWidth > 20 || TerminalLogFont.lfWidth < 0)
		TerminalLogFont.lfWidth = DEF_TERM_CHAR_WIDTH;
	if (TerminalLogFont.lfWeight > FW_BOLD || TerminalLogFont.lfWeight < 0)
		TerminalLogFont.lfWeight = FW_NORMAL;

	/* if there is font name make sure it exists */
	if ( TerminalLogFont.lfFaceName[0]) {
		/* enumerate font families and check for presence of FaceName */
		lpEnumFontCallBack = (FONTENUMPROC)MakeProcInstance( (FARPROC)
								EnumFontCallBack, hInst);
		EnumFontFamilies(hTermDC, NULL,
					lpEnumFontCallBack, (LPARAM)(DWORD)(int far *)&Found);
		FreeProcInstance((FARPROC) lpEnumFontCallBack);
		if (Found)
			return TRUE;
	}
	/* if no font name or name doesn't exist, select system font */
	lstrcpy(TerminalLogFont.lfFaceName, "System");
	return FALSE;
}
/****************************************************************************
Routine	:	ChangeTerminalFont(void)
Input	:	None
Return	:	TRUE or FALSE
Synop	:	Creates the font described in global "TerminalLogFont" struct.
			if created successfully, it is selected for hTermDC and TRUE
			is returned. FALSE returned otherwise.
****************************************************************************/
BOOL
ChangeTerminalFont (void)
{
	TEXTMETRIC 	Metrics;
	HFONT		hOldFont, hFont;

	if (hFont = CreateFontIndirect(&TerminalLogFont)) {
		hOldFont = SelectObject(hTermDC, hFont);
		DeleteObject(hOldFont);
	} else {
		return FALSE;
	}
	PaintTermBackGnd();		/* We need to redraw the entire screen */

    GetTextMetrics (hTermDC, &Metrics);
	nStdioCharWidth = Metrics.tmMaxCharWidth;
	nStdioCharHeight = (Metrics.tmHeight + Metrics.tmExternalLeading);

	DestroyTermCursor();
	SetupWinMatrix();
	CreateTermCursor(GetCursorPosition());
					// Think of changing shape for italic font

	InvalidateRect (hTermWnd, NULL, FALSE);
	UpdateWindow (hTermWnd);
	return TRUE;
}

/****************************************************************************
Routine	:	MakeFontWeightBold(void)
Input	:	None
Return	:	TRUE or FALSE
Synop	:	Makes the font bold. Returns TRUE if OK else FALSE
****************************************************************************/
BOOL
MakeFontWeightBold (void)
{
	int		oldweight = TerminalLogFont.lfWeight;

	TerminalLogFont.lfWeight = FW_BOLD;
	if ( ! ChangeTerminalFont()) {		/* failure in setting bold fold */
		TerminalLogFont.lfWeight = oldweight;
		return FALSE;
	}
	return TRUE;
}

/****************************************************************************
Routine	:	MakeFontWeightNormal(void)
Input	:	None
Return	:	TRUE or FALSE
Synop	:	Makes the font bold. Returns TRUE if OK else FALSE
****************************************************************************/
BOOL
MakeFontWeightNormal (void)
{
	int		oldweight = TerminalLogFont.lfWeight;

	TerminalLogFont.lfWeight = FW_NORMAL;
	if ( ! ChangeTerminalFont()) {		/* failure in setting bold fold */
		TerminalLogFont.lfWeight = oldweight;
		return FALSE;
	}
	return TRUE;
}

/****************************************************************************
Routine	:	SelectTerminalFont(HWND)
Input	:	HWND main window handle
Return	:	none
Synop	:	uses COMMDLG to select and change terminal font.
****************************************************************************/
void	SelectTerminalFont(HWND hWnd)
{
	CHOOSEFONT	cf;
	LOGFONT		tmpLogFont = TerminalLogFont;		/* save settings	*/
	BYTE		style[25];

	memset(&cf, 0, sizeof(CHOOSEFONT));			/* set all fields to 0 */

	cf.lStructSize = sizeof (CHOOSEFONT);
	cf.hwndOwner = hWnd;
	cf.lpLogFont = &TerminalLogFont;
	cf.Flags = CF_SCREENFONTS | CF_FIXEDPITCHONLY | CF_INITTOLOGFONTSTRUCT |
			CF_USESTYLE | CF_FORCEFONTEXIST | CF_LIMITSIZE;
	cf.nSizeMin = 2; cf.nSizeMax = 40;
	cf.lpszStyle = style;
	if (TerminalLogFont.lfWeight > FW_NORMAL)
		lstrcpy(style, "Bold");
	else
		lstrcpy(style, "Regular");
		
	cf.nFontType = REGULAR_FONTTYPE | SCREEN_FONTTYPE;

	if (DLGShowFontDlgBox(&cf)) {
		TerminalLogFont.lfItalic = 0;		/* no italics for now */
		if ( TestFontFixedPitch(&TerminalLogFont) > 0) {
			ChangeTerminalFont ();
			return;
		} else {
			DispMsgBox(hWnd, 272, NULL, MB_OK);
		}
	}
	TerminalLogFont = tmpLogFont;
}

int
TestFontFixedPitch(LOGFONT *LgFnt)
{
	HFONT hFont, hOldFont;
	int		ret_val;
    TEXTMETRIC Metrics;

	if (hFont = CreateFontIndirect(LgFnt)) {
		hOldFont = SelectObject(hTermDC, hFont);

	    /* get the text metrics for the font we are using */
    	GetTextMetrics(hTermDC, &Metrics);

	    /* calculate the height and width of the font  */
    	ret_val = (Metrics.tmMaxCharWidth == Metrics.tmAveCharWidth) ? 1 : -1;

		SelectObject(hTermDC, hOldFont);
		DeleteObject(hFont);
		return ret_val;
	} else {
		/* could not create the font */
		return -2;
	}
}
/****************************************************************************/


