/****************************************************************************
 * Filename   : looks.c
 * Purpose    : this file contains some UI routines.
 ****************************************************************************/

#include	<windows.h>
#include	<shellapi.h>
#include	"commdlg.h"

#include	"looks.h"
#include	"main.h"
#include	"mew.h"
#include	"session.h"
#include	"file.h"
#include	"term.h"
#include	"scroll.h"
#include	"emlntype.h"
#include	"kbd.h"
#include	"wstdio.h"
#include	"mewlog.h"
#include	"status.h"
#include	"myprint.h"
#include	"fonts.h"
#include	"clrsetup.h"

// PENs and BRUSHes
HPEN		hOldPen;				// old pen handle
HPEN		hNullPen;  				// null pen handle
HPEN		hBlackPen;				// black pen handle
HPEN		hWhitePen;	  			// white pen handle
HPEN		hLightGreyPen;			// light grey pen handle
HPEN		hGreyPen;				// grey pen handle
HPEN		hHatchPen;				// black and white hatch pen handle

HBRUSH		hOldBrush;				// old brush handle
HBRUSH		hBlackBrush;			// black brush handle
HBRUSH		hWhiteBrush;			// white brush handle
HBRUSH		hLightGreyBrush;		// light grey brush handle
HBRUSH		hGreyBrush;				// grey brush handle
HBRUSH		hGrBlBrush;				// grey brush handle

BYTE		*MEWHelpFile = "MEWHELP.HLP";
HWND		hUpldDropWnd, hSigWnd, hDtrtsWnd;

#define		IDTB_DTRTS_WND			(IDTB_BASE + 50 - 2)
#define		IDRG_DTRTS				507
#define		IDRN_DTRTS				508

/*#########################################################################
						TOOL BAR related routines.
###########################################################################*/

HWND	ghTBButtons[NUM_OF_TBBUTTONS + 1];

BOOL TBButtonDisabled[NUM_OF_TBBUTTONS] = {
	FALSE,					// Button #1	-- Log
	FALSE,					// Button #2	-- Scroll
	FALSE,					// Button #3	-- Print
};

/****************************************************************************
Synop	:	General purpose routine to do BitBlit into a DC
***************************************************************************/
void	CopyBitMap(HDC hDc, int Resource, int x, int y, int width, int height)
{
	HBITMAP hbm, hOldbm;
	HDC		hMemDC;

	hbm = LoadBitmap(hInst, MAKEINTRESOURCE(Resource));
	if (! hbm)
		return;
	hMemDC = CreateCompatibleDC(hDc);
	hOldbm = SelectObject(hMemDC, hbm);
	if (hOldbm) {
		BitBlt(hDc, x, y, width, height,
			hMemDC,
			0, 0,
			SRCCOPY);
		SelectObject(hMemDC, hOldbm);
	}
	DeleteDC(hMemDC);
	DeleteObject(hbm); 
}



/****************************************************************************
 * Function   : DtrtsWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the Tool bar window.
 ****************************************************************************/
long FAR PASCAL	DtrtsWndProc (HWND hWnd, unsigned message,
												WORD wParam, LONG lParam)
{
	HDC 	hDc;
    PAINTSTRUCT ps;

	switch (message){
		case WM_MOUSEMOVE:
			SetCursor (hStandard);
			break;

		case WM_PAINT:
		    hDc = BeginPaint (hWnd, (LPPAINTSTRUCT)&ps);

			/* BitBlit SigWin first */
			CopyBitMap(hDc, IDRN_DTRTS, 0, 0, /* TBB_X_SIZE*/ 93, TBB_Y_SIZE);

			/* otherwise according to LineStatus set LED colors */
			/* first check for DTR */
			if (LineStatus & DTR_MASK) 
				CopyBitMap(hDc, IDR_SIG_ON, 26, 9, 7, 7);

			/* check for RTS */
			if (LineStatus & RTS_MASK) 
				CopyBitMap(hDc, IDR_SIG_ON, 26, 20, 7, 7);

		    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
			break;

        case WM_CLOSE:
            DestroyWindow(hWnd);
			break;

		default:
	    	return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0L;
}


/****************************************************************************
 * Function   : SigWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the Tool bar window.
 ****************************************************************************/
long FAR PASCAL	SigWndProc (HWND hWnd, unsigned message,
												WORD wParam, LONG lParam)
{
	HDC 	hDc;
    PAINTSTRUCT ps;

	switch (message){
		case WM_MOUSEMOVE:
			SetCursor (hStandard);
			break;

		case WM_PAINT:
		    hDc = BeginPaint (hWnd, (LPPAINTSTRUCT)&ps);

			/* BitBlit SigWin first */
			CopyBitMap(hDc, IDRN_SIG_WIN, 0, 0, 93, TBB_Y_SIZE);

			/* otherwise according to LineStatus set LED colors */
			/* first check dor DCD */
			if (LineStatus & DCD_MASK) 
				CopyBitMap(hDc, IDR_SIG_ON, 12, 16, 10, 10);
			else
				CopyBitMap(hDc, IDR_SIG_OFF, 12, 16, 10, 10);

			if (LineStatus & CTS_MASK) 
				CopyBitMap(hDc, IDR_SIG_ON, 41, 16, 10, 10);
			else
				CopyBitMap(hDc, IDR_SIG_OFF, 41, 16, 10, 10);

			if (LineStatus & DSR_MASK) 
				CopyBitMap(hDc, IDR_SIG_ON, 68, 16, 10, 10);
			else
				CopyBitMap(hDc, IDR_SIG_OFF, 68, 16, 10, 10);

		    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
			break;

        case WM_CLOSE:
            DestroyWindow(hWnd);
			break;

		default:
	    	return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0L;
}
extern	HWND	hConfigWnd;
			
/****************************************************************************
 * Function   : TbarWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the Tool bar window.
 ****************************************************************************/
long FAR PASCAL	TbarWndProc (HWND hWnd, unsigned message,
												WORD wParam, LONG lParam)
{
	HDC		hDc;
    PAINTSTRUCT ps;

    switch (message){
		case WM_MOUSEMOVE:
			SetCursor (hStandard);
			break;

		case WM_COMMAND:
			if (TBButtonDisabled[TBBUTTONINDEX(wParam)])
				break;
			switch (wParam) {

			// File Log
				case IDTB_LOG:
					LogOptionsDlg(hWnd);
					break;
				break;

			// Scroll buffer
				case IDTB_SCROLL:
			        if (ScrollLock)
            		    ExitScrollMode();
			        else
            		    EnterScrollMode();
				break;

				// Print Log
				case IDTB_PRINT:
					TogglePrinter();
				break;

				// switch windows to config
				case IDTB_CONFIG:
					// switch to the setup window
					SetFocus(GetLastActivePopup(hConfigWnd));
				break;

				// select terminal fonts
				case IDTB_FONTS:
					if ( IN_SCROLL)
						break;
					SelectTerminalFont(hWnd);
				break;

				// Select rterminal colors
				case IDTB_COLOR:
					InvokeDialog (hWnd, (LPSTR)"COLORDLG", ColorSetupDlgProc);
				break;

			}

		case WM_PAINT:
		   hDc = BeginPaint (hWnd, (LPPAINTSTRUCT)&ps);
			tbShowToolbar();		  	
		   EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    	break;

  		case WM_DRAWITEM:
	   		// owner draw control stuff
			tbDrawControl(hWnd, (LPDRAWITEMSTRUCT)lParam);
    		break;

        case WM_CLOSE:
            DestroyWindow(hWnd);
            break;

		default:
	    	return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return(NULL);
}


/***************************************************************************
Routine	:	tbCreateDtrtsWnd
Synop	:	Creates RS232 out going signals window as child of TbarWnd
***************************************************************************/
void	tbCreateDtrtsWnd(void)
{
#if 0
	hDtrtsWnd = CreateWindow ( "DTRTS", NULL, 
		WS_CHILD | WS_VISIBLE, 13*TBB_X_SHIFT, 3, TBB_X_SIZE,
				TBB_Y_SIZE, hTbarWnd, IDTB_DTRTS_WND, hInst, (LPSTR) NULL);
	UpdateWindow(hDtrtsWnd);
#endif
}	


/***************************************************************************
Routine	:	tbCreateSigWnd
Synop	:	Creates RS232 signals window as child of TbarWnd
***************************************************************************/
void	tbCreateSigWnd(void)
{
	hSigWnd = CreateWindow ( "RS232WIN", NULL, 
		WS_CHILD | WS_VISIBLE,
				TbarWndRect.right - 93 - TB_HORZ_START /* 12*TBB_X_SHIFT */,
				TB_VERT_START,
				93 /* TBB_X_SIZE */,	TBB_Y_SIZE, hTbarWnd, IDTB_SIG_WND, hInst,
					(LPSTR) NULL);
	UpdateWindow(hSigWnd);
}	

/****************************************************************************
 * Function   : CreateTbarWnd (HWND)
 * Purpose    : creates the tool bar window if it needs to be shown.
 ****************************************************************************/
int
CreateTbarWnd (HWND hParentWnd)
{
	HBRUSH	hBrush;

	if (! ShowTbarWnd)
		return FALSE;

    hTbarWnd = CreateWindow("ROUTOOLBAR",
					(LPSTR)NULL,
					WS_CHILD | WS_VISIBLE | WS_BORDER,
					TbarWndRect.left,
					TbarWndRect.top,
					(TbarWndRect.right - TbarWndRect.left),
					(TbarWndRect.bottom - TbarWndRect.top),
					hParentWnd,
					IDC_TBAR_WND,	/* child control ID */
					hInst,
					(LPSTR)NULL);
	if (! hTbarWnd) {
		ShowTbarWnd = FALSE;
		return FALSE;
	}
	hBrush = CreateSolidBrush(ColorTable[ColorSetup.Tbar]);
	SetClassWord(hTbarWnd, GCW_HBRBACKGROUND, (WORD)hBrush);
	DeleteObject(hBrush);
	if (ShowTbarWnd)
		InvalidateRect(hTbarWnd, NULL, TRUE);

	tbCreateToolbar();
	tbCreateSigWnd();
	tbCreateDtrtsWnd();

	return TRUE;
}

/****************************************************************************
 * FUNCTION	: tbCreateToolbar (void)
 * PURPOSE	: Creates different tool buttons
 ****************************************************************************/
void
tbCreateToolbar (void)
{								  
	int		index;

	/* Create toolbar buttons for later use */
	for (index = 0; index < NUM_OF_TBBUTTONS; index++)
		tbCreateToolbarButton (IDTB_BASE + index, TB_HORZ_START +
							index * TBB_X_SHIFT, TB_VERT_START);
}

/****************************************************************************
 * FUNCTION	: tbCreateToolbarButton (int, int, int)
 * PURPOSE	: creates on tool bar button (child of TbarWnd) whose
 			  index is passed in
 ****************************************************************************/
void	tbCreateToolbarButton (int Button, int x, int y)
{
	TBBUTTON (Button) = CreateWindow ( "button", NULL, 
		WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_OWNERDRAW,
		x, y, TBB_X_SIZE, TBB_Y_SIZE, hTbarWnd, Button, hInst, (LPSTR) NULL);
}
	
/****************************************************************************
 * FUNCTION	: tbEnableToolbarButton (int)
 * PURPOSE	: if a button is disabled, enable it and redisplay
 ****************************************************************************/
void	tbEnableToolbarButton (int Button)
{
	if (TBButtonDisabled[TBBUTTONINDEX(Button)] == TRUE) {
		TBButtonDisabled[TBBUTTONINDEX(Button)] = FALSE;
		if (ShowTbarWnd)
			InvalidateRect (TBBUTTON(Button), NULL, FALSE);
	}
}

/****************************************************************************
 * FUNCTION	: tbDisableToolbarButton (int)
 * PURPOSE	: if a button is enabled, disable it and redisplay
 ****************************************************************************/
void	tbDisableToolbarButton (int Button)
{
	if (TBButtonDisabled[TBBUTTONINDEX(Button)] == FALSE) {
		TBButtonDisabled[TBBUTTONINDEX(Button)] = TRUE;
		if (ShowTbarWnd)
			InvalidateRect (TBBUTTON(Button), NULL, FALSE);
	}
}

/***************************************************************************
Routine	:	tbUpdateToolbarButton()
Synop	:	redisplay a toolbar button
***************************************************************************/
void	tbUpdateToolbarButton(int	Button)
{
	if (ShowTbarWnd)
		InvalidateRect(TBBUTTON(Button), NULL, FALSE);
}

/***************************************************************************
Routine	:	tbUpdateToolbar
Synop	:	Depending upon current MEW state redisplay the tool bar
***************************************************************************/
void	tbUpdateToolbar(void)
{
	int		dis_state[NUM_OF_TBBUTTONS];
	int		i;

	/* initially disable all the buttons */
	for (i=0; i < NUM_OF_TBBUTTONS; dis_state[i] = FALSE, i++);

	if (IN_SCROLL) {
		dis_state[IDTB_FONTS - IDTB_BASE] = TRUE;
		dis_state[IDTB_CONFIG - IDTB_BASE] = TRUE;
		dis_state[IDTB_PRINT - IDTB_BASE] = TRUE;
		dis_state[IDTB_LOG - IDTB_BASE] = TRUE;
	}
	if (CommandLineArgument == 4 || CommandLineArgument == 5) {
		dis_state[IDTB_CONFIG - IDTB_BASE] = TRUE;
	}

	/* now check and change the status of the tool bar buttons */
	for (i = 0; i < NUM_OF_TBBUTTONS; i++) {
		if (dis_state[i])
			tbDisableToolbarButton ( i + IDTB_BASE);
		else 
			tbEnableToolbarButton ( i + IDTB_BASE);
	}
}

/****************************************************************************
 * FUNCTION	: tbShowToolbar (void)
 * PURPOSE	: 
 ****************************************************************************/
void	tbShowToolbar(void)
{
	/* Put up toolbar */
	tbShowHideToolbar(TRUE, SW_SHOWNORMAL);
}	

/****************************************************************************
 * FUNCTION	: tbHideToolbar (void)
 * PURPOSE	: 
 ****************************************************************************/
void	tbHideToolbar(void)
{
	/* Hide buttons */
	tbShowHideToolbar(FALSE, SW_HIDE);
}

/****************************************************************************
 * FUNCTION	: tbShowHideToolbar (BOOL, int)
 * PURPOSE	: 
 ****************************************************************************/
void	tbShowHideToolbar(BOOL Enable, int Show)
{
	tbShowHideButton (IDTB_SCROLL, Enable, Show);
}

/****************************************************************************
 * FUNCTION	: tbShowHideButton (int, BOOL, int)
 * PURPOSE	: 
 ****************************************************************************/
void	tbShowHideButton(int Button, BOOL Enable, int Show)
{
	EnableWindow(TBBUTTON (Button), Enable);
	ShowWindow(TBBUTTON (Button), Show);
}

/****************************************************************************
 * FUNCTION	: tbDrawControl (HWND, LPDRAWITEMSTRUCT)
 * PURPOSE	: 
 ****************************************************************************/
int
tbDrawControl(HWND hWnd, LPDRAWITEMSTRUCT lpInfo)
{
	int ResourceID;

	if (lpInfo->CtlType != ODT_BUTTON)
		return 0;

	ResourceID = ((lpInfo->CtlID - IDTB_BASE) * 10 + 200);

	switch(lpInfo->CtlID) {		// six state buttons are handeled here
		case IDTB_LOG:
			ResourceID = (FileLogging) ? IDRN_ALT_LOG : IDRN_LOG;
		break;
		case IDTB_SCROLL:
			ResourceID = (ScrollLock) ? IDRN_ALT_SCROLL : IDRN_SCROLL;
		break;
		case IDTB_PRINT:
			ResourceID = (PrintLogging) ? IDRN_ALT_PRINT : IDRN_PRINT;
		break;

	}
    if (lpInfo->itemState & ODS_SELECTED) {
        ResourceID += 1;
		  if (TBButtonDisabled[TBBUTTONINDEX(lpInfo->CtlID)])
        		ResourceID += 1;
    } else if (TBButtonDisabled[TBBUTTONINDEX(lpInfo->CtlID)])
        ResourceID += 2;

	if ((lpInfo->itemAction & ODA_DRAWENTIRE)
									|| (lpInfo->itemAction & ODA_SELECT))
		CopyBitMap(lpInfo->hDC, ResourceID,
			(lpInfo->rcItem).left,
			(lpInfo->rcItem).top,
			(lpInfo->rcItem).right - (lpInfo->rcItem).left,
			(lpInfo->rcItem).bottom - (lpInfo->rcItem).top);

	if ( (lpInfo->itemAction & ODA_SELECT)
			&& (lpInfo->itemState & ODS_FOCUS)
				&&  !(lpInfo->itemState & ODS_SELECTED))
		SetFocus(hTermWnd);

	return 1;
}

/*###########################################################################
		status and button related routines
###########################################################################*/
void	CreateBrushesAndPens(void)
{

	hNullPen			= CreatePen (PS_NULL,  1, RGB(   0,    0,    0));
	hBlackPen			= CreatePen (PS_SOLID, 1, RGB(   0,    0,    0));
	hWhitePen			= CreatePen (PS_SOLID, 1, RGB(0xFF, 0xFF, 0xFF));
	hLightGreyPen		= CreatePen (PS_SOLID, 1, RGB(0xC0, 0xC0, 0xC0));
	hGreyPen			= CreatePen (PS_SOLID, 1, RGB(0x80, 0x80, 0x80));
	hHatchPen  			= CreatePen (PS_SOLID, 1, RGB(  82,   82,   82));

	hBlackBrush 		= CreateSolidBrush(RGB(   0,    0,    0));
	hWhiteBrush 		= CreateSolidBrush(RGB(0xFF, 0xFF, 0xFF));
	hLightGreyBrush 	= CreateSolidBrush(RGB(0xC0, 0xC0, 0xC0));
	hGreyBrush 			= CreateSolidBrush(RGB(0x80, 0x80, 0x80));
}

void	DeleteBrushesAndPens(void)
{
	DeleteObject(hNullPen);
	DeleteObject(hBlackPen);
	DeleteObject(hWhitePen);
	DeleteObject(hLightGreyPen);
	DeleteObject(hGreyPen);
	DeleteObject(hHatchPen);

	DeleteObject(hBlackBrush);
	DeleteObject(hWhiteBrush);
	DeleteObject(hLightGreyBrush);
	DeleteObject(hGreyBrush);
}

/***************************************************************************
Routine	:	DrawPushButton()
Synop	:	This is a general routine which draws push button in
			up/down state and status window.
***************************************************************************/
void	DrawPushButton(HDC hDc, LPRECT rect, LPSTR str,
		BOOL button_up, BOOL horiz_center, BOOL button_type)
{
	HBRUSH	hBrush, hOldBrush;
	HPEN	hOldPen;
	RECT	nrect;

	nrect.left = rect->left + KEY_HORZ_CLEARANCE;
	nrect.top = rect->top + KEY_VERT_CLEARANCE;
	nrect.right = rect->right - KEY_HORZ_CLEARANCE;
	nrect.bottom = rect->bottom - KEY_VERT_CLEARANCE;

	hOldPen = SelectObject (hDc, hNullPen);
	if (button_up) {

	 	hOldBrush = SelectObject(hDc, hWhiteBrush);
		Rectangle (hDc, nrect.left, nrect.top, nrect.right, nrect.bottom);

		/* then draw a drakgrey rectangle on right bottom size */
	 	SelectObject(hDc, hGreyBrush);
		Rectangle (hDc, nrect.left + KEY_HEIGHT, nrect.top + KEY_HEIGHT,
				nrect.right, nrect.bottom);
	} else {		/* button down */
	 	hOldBrush = SelectObject(hDc, hGreyBrush);
		Rectangle (hDc, nrect.left, nrect.top, nrect.right, nrect.bottom);

		/* then draw a drakgrey rectangle on right bottom size */
	 	SelectObject(hDc, hWhiteBrush);
		Rectangle (hDc, nrect.left + KEY_HEIGHT, nrect.top + KEY_HEIGHT,
			nrect.right, nrect.bottom);
	}

	// Select pen for the key bg or status bg, also set same text bg
	if (button_type) {
		hBrush = CreateSolidBrush(ColorTable[ColorSetup.KeyBg]);
		SetBkColor(hDc, ColorTable[ColorSetup.KeyBg]);
	} else {
		hBrush = CreateSolidBrush(ColorTable[ColorSetup.StatBg]);
		SetBkColor(hDc, ColorTable[ColorSetup.StatBg]);
	}
 	SelectObject(hDc, hBrush);

	Rectangle (hDc, nrect.left + KEY_HEIGHT, nrect.top + KEY_HEIGHT,
			nrect.right - KEY_HEIGHT, nrect.bottom - KEY_HEIGHT);
	// Restore the old brush and pen
	SelectObject (hDc, hOldBrush);
	SelectObject (hDc, hOldPen);
	DeleteObject(hBrush);

	// Set color for text
	SetTextColor(hDc, ColorTable[ColorSetup.KeyFg]);

	nrect.left += (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.right -= (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.top += (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.bottom -= (KEY_HEIGHT + KEY_STR_BORDER);

	if (str) {
		if (horiz_center)
			DrawText (hDc, (LPSTR)str,	lstrlen(str), (LPRECT)&nrect,
				DT_CENTER | DT_SINGLELINE | DT_VCENTER);
		else
			DrawText (hDc, (LPSTR)str,	lstrlen(str), (LPRECT)&nrect,
				DT_SINGLELINE | DT_VCENTER);
	}

}
/***************************************************************************
Synop	:	Draw a push button in up state
***************************************************************************/
void	DrawPushButtonUp(HDC hDc, LPRECT rect, LPSTR str)
{
	DrawPushButton(hDc, rect, str, TRUE, TRUE, TRUE);
}

/***************************************************************************
Synopsis :	Draw a push button in down state
***************************************************************************/
void	DrawPushButtonDn(HDC hDc, LPRECT rect, LPSTR str)
{
	DrawPushButton(hDc, rect, str, FALSE, TRUE, TRUE);
}

/***************************************************************************
Synopsis :
***************************************************************************/
void	DrawStatusWin(HDC hDc, LPRECT rect, LPSTR str)
{
	DrawPushButton(hDc, rect, str, FALSE, TRUE, FALSE);
}
/***************************************************************************
Synopsis :	Quick help is displayed as a deppressed button !
***************************************************************************/
void	DisplayQHelp(HDC hDc, LPRECT rect, LPSTR str)
{
	DrawPushButton(hDc, rect, str, FALSE, FALSE, FALSE);
}
/***************************************************************************
Synopsis :	rewrites only the text portion of status win. avoids flicker
***************************************************************************/
void	DrawStatusWinText(HDC hDc, LPRECT rect, LPSTR str, BOOL EraseBk)
{
	RECT	nrect;
	HBRUSH	hBrush, hOldBrush;
	HPEN	hOldPen;

	nrect.left = rect->left + KEY_HORZ_CLEARANCE;
	nrect.top = rect->top + KEY_VERT_CLEARANCE;
	nrect.right = rect->right - KEY_HORZ_CLEARANCE;
	nrect.bottom = rect->bottom - KEY_VERT_CLEARANCE;

	if (EraseBk) {
		hOldPen = SelectObject (hDc, hNullPen);
		hBrush = CreateSolidBrush(ColorTable[ColorSetup.StatBg]);
		hOldBrush = SelectObject(hDc, hBrush);

		Rectangle (hDc, nrect.left + KEY_HEIGHT, nrect.top + KEY_HEIGHT,
			nrect.right - KEY_HEIGHT, nrect.bottom - KEY_HEIGHT);
		SelectObject (hDc, hOldPen);
		SelectObject(hDc, hOldBrush);
		DeleteObject(hBrush);
	}

	SetBkColor(hDc, ColorTable[ColorSetup.StatBg]);
	SetTextColor(hDc, ColorTable[ColorSetup.KeyFg]);

	nrect.left += (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.right -= (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.top += (KEY_HEIGHT + KEY_STR_BORDER);
	nrect.bottom -= (KEY_HEIGHT + KEY_STR_BORDER);

	if (str)
		DrawText (hDc, (LPSTR)str,	lstrlen(str), (LPRECT)&nrect,
				DT_CENTER | DT_SINGLELINE | DT_VCENTER);
}


/****************************************************************************
 * FUNCTION	: GetMEWPathName
 * PURPOSE	: Get the MEW exe pathname.
 ***************************************************************************/
void	GetMEWPathName( LPSTR szFileName)
{
	LPSTR	pcFileName;
	int     nFileNameLen;

	nFileNameLen = GetModuleFileName(hInst, szFileName,	EXE_NAME_MAX_SIZE);
	pcFileName = szFileName + nFileNameLen;

	while (pcFileName > szFileName) {
		if (*pcFileName == '\\' || *pcFileName == ':') {
			*(++pcFileName) = '\0';
			break;
		}
		nFileNameLen--;
		pcFileName--;
	}
	return;
}

/****************************************************************************
 * FUNCTION	: MakeHelpPathName
 * PURPOSE	: MEW assumes the file "MEW.HLP" is in the same
 *            directory as the executable. This function derives the full
 *			  path name of the help file from the path of the executable.
 ***************************************************************************/
void	MakeHelpPathName(void)
{
	GetMEWPathName (TmpStr);
	if ((strlen(TmpStr)+13) < EXE_NAME_MAX_SIZE)
		lstrcat(TmpStr, MEWHelpFile);
	else
		lstrcat(TmpStr, "?");
	return;
}

/***************************************************************************
Routine	:	
Synop	:
***************************************************************************/
void	ClearTermBorder(HDC hDc)
{
	HBRUSH	hBrush, hOldBrush;
	HPEN	hOldPen;
	RECT	nrect;

	if (!hTermWnd)			/* don't draw the border now */
		return;	

	/* select the null pen */
	hOldPen = SelectObject (hDc, hNullPen);

	/* select the white brush */
	hBrush = CreateSolidBrush(ColorTable[ColorSetup.TermWin]);
	hOldBrush = SelectObject(hDc, hBrush);

	/* draw a while rectangle */
	nrect.left = TermWndRect.left + TRM_SHADE;
	nrect.top = TermWndRect.top + TRM_SHADE;
	nrect.right = TermWndRect.right - TRM_SHADE + 1;
	nrect.bottom = TermWndRect.bottom - TRM_SHADE + 1;
	Rectangle (hDc, nrect.left, nrect.top, nrect.right, nrect.bottom);

	SelectObject(hDc, hOldBrush);	/* MUST NOT delete a selected brush */
	DeleteObject(hBrush);
	
	/* select lighter or darker pen */
	hBrush = CreateSolidBrush(ColorTable[ColorSetup.TermWin ^ 8]);
 	SelectObject(hDc, hBrush);

	/* draw the inner-most rectangle */
	nrect.left = TermWndRect.left + TERM_BORDER - TRM_IN_SHADE;
	nrect.top = TermWndRect.top + TERM_BORDER - TRM_IN_SHADE;
	nrect.right = TermWndRect.right - TERM_BORDER + TRM_IN_SHADE + 1;
	nrect.bottom = TermWndRect.bottom - TERM_BORDER + TRM_IN_SHADE + 1;
	Rectangle (hDc, nrect.left, nrect.top, nrect.right, nrect.bottom);

	// Restore the old brush and pen
	SelectObject(hDc, hOldBrush);	/* MUST NOT delete a selected brush */
	DeleteObject(hBrush);
	SelectObject (hDc, hOldPen);
}
