/****************************************************************************
 * Filename   : main.h
 * Purpose    : This file contains the definitions and prototype declarations
 *              for main.c.
 ****************************************************************************/

/* action values to adjust the window dimensions */
#define		HIDE_STATUSBAR	3
#define		SHOW_STATUSBAR	4
#define		HIDE_TIMEBAR	5
#define		SHOW_TIMEBAR	6
#define		HIDE_TBAR		7
#define		SHOW_TBAR		8

#define		BLACK			0x00
#define		RED				0x01
#define		GREEN			0x02
#define		YELLOW			0x03
#define		BLUE			0x04
#define		MAGENTA			0x05
#define		CYAN			0x06
#define		WHITE			0x07
/* high intensity colors */
#define		HI_BLACK		0x08
#define		HI_RED			0x09
#define		HI_GREEN		0x0A
#define		HI_YELLOW		0x0B
#define		HI_BLUE			0x0C
#define		HI_MAGENTA		0x0D
#define		HI_CYAN			0x0E
#define		HI_WHITE		0x0F

#define		DEF_COLOR	0x07
#define		DEF_BKGND	((DEF_COLOR >> 4) & 0x7)

/* color byte encoding scheme for MEW */
/*
	+-----+-----+-----+-----+-----+-----+-----+-----+
	|     |   back ground	| HI  |   fore ground   |
	+-----+-----+-----+-----+-----+-----+-----+-----+
*/

#define		FORE_GROUND(color_byte)		((color_byte) & 0x0F)
#define		BACK_GROUND(color_byte)		(((color_byte) >> 4) & 0x07)

#define		MAX_COLORS	16

extern	COLORREF	ColorTable[];	

#define	FILE_NAME_LEN		13			/*	Max length of file name.		*/
#define	PATH_NAME_LEN		68			/*	Path of file to be sent/recd.	*/

/* from version 2.00 MEW messages are alll in a string table */
/* this is the base index in string table where MEW messages start */
#define	MEW_STR_MSG_BASE	200

#define	MSG_FILECREATE		(MEW_STR_MSG_BASE + 0)
#define	MSG_FILEOPEN		(MEW_STR_MSG_BASE + 1)
#define	MSG_FILEREAD		(MEW_STR_MSG_BASE + 2)
#define	MSG_FILEWRITE		(MEW_STR_MSG_BASE + 3)
#define	MSG_FILESEEK		(MEW_STR_MSG_BASE + 4)
#define	MSG_GLMEM			(MEW_STR_MSG_BASE + 5)
#define	MSG_LOCALMEM		(MEW_STR_MSG_BASE + 6)
#define	MSG_COMREAD			(MEW_STR_MSG_BASE + 7)
#define	MSG_COMWRITE		(MEW_STR_MSG_BASE + 8)
#define	MSG_CONFIG			(MEW_STR_MSG_BASE + 9)
#define	MSG_MODEM			(MEW_STR_MSG_BASE + 10)
#define	MSG_DIAL			(MEW_STR_MSG_BASE + 11)
#define	MSG_PRNOPEN			(MEW_STR_MSG_BASE + 12)
#define	MSG_PRNINSTALL		(MEW_STR_MSG_BASE + 13)
#define	MSG_SCRLBUF			(MEW_STR_MSG_BASE + 14)
#define	MSG_NOSERVER		(MEW_STR_MSG_BASE + 15)
#define	MSG_NOMCSI			(MEW_STR_MSG_BASE + 16)
#define	MSG_CLIPBOARD		(MEW_STR_MSG_BASE + 17)
#define	MSG_NOFONT			(MEW_STR_MSG_BASE + 18)
#define	MSG_NOFONTSIZE		(MEW_STR_MSG_BASE + 19)
#define	MSG_PMNACK			(MEW_STR_MSG_BASE + 20)
#define	MSG_PMTIMEOUT		(MEW_STR_MSG_BASE + 21)
#define	MSG_EXIT			(MEW_STR_MSG_BASE + 22)
#define	MSG_CHANGE_LINE		(MEW_STR_MSG_BASE + 23)
#define	MSG_HEAD			(MEW_STR_MSG_BASE + 24)
#define	MSG_HANGUP			(MEW_STR_MSG_BASE + 25)
#define	MSG_QSESN1			(MEW_STR_MSG_BASE + 26)
#define	MSG_QSESN2			(MEW_STR_MSG_BASE + 27)
#define	MSG_ER_CHAR_VAL		(MEW_STR_MSG_BASE + 28)
#define	MSG_ER_LINE_VAL		(MEW_STR_MSG_BASE + 29)
#define	MSG_ER_COLOR1		(MEW_STR_MSG_BASE + 30)
#define	MSG_ER_COLOR2		(MEW_STR_MSG_BASE + 31)
#define	MSG_SET_DEF_PARAMS	(MEW_STR_MSG_BASE + 32)
#define	MSG_NO_FILE_NAME	(MEW_STR_MSG_BASE + 33)
#define	MSG_SAVE_EDIT		(MEW_STR_MSG_BASE + 34)
#define	MSG_NO_WILDCARDS	(MEW_STR_MSG_BASE + 35)
#define	MSG_NO_FILE_CANCEL	(MEW_STR_MSG_BASE + 36)
#define	MSG_NO_FILES		(MEW_STR_MSG_BASE + 37)
#define	MSG_KBD_QSAVE		(MEW_STR_MSG_BASE + 38)
#define	MSG_KBD_CLR_MAP		(MEW_STR_MSG_BASE + 39)
#define	MSG_KBD_ER_SAVE		(MEW_STR_MSG_BASE + 40)
#define	MSG_NO_HELP			(MEW_STR_MSG_BASE + 41)
#define	MSG_SAVE_SYS_DEFS	(MEW_STR_MSG_BASE + 42)
#define	MSG_CNF_QSAVE		(MEW_STR_MSG_BASE + 43)
#define	MSG_DESC_EXISTS		(MEW_STR_MSG_BASE + 44)
#define	MSG_NO_CNFS			(MEW_STR_MSG_BASE + 45)
#define	MSG_NO_FNAME		(MEW_STR_MSG_BASE + 46)
#define	MSG_ER_LOG_OPEN		(MEW_STR_MSG_BASE + 47)
#define	MSG_SCRT_DEL		(MEW_STR_MSG_BASE + 48)
#define	MSG_SCRL_NO_PAT		(MEW_STR_MSG_BASE + 49)
#define	MSG_SCRL_NO_MATCH	(MEW_STR_MSG_BASE + 50)
#define	MSG_SESN_EFNAME		(MEW_STR_MSG_BASE + 51)
#define	MSG_SESN_EPSSWD		(MEW_STR_MSG_BASE + 52)
#define	MSG_SESN_EDESC		(MEW_STR_MSG_BASE + 53)
#define	MSG_SESN_EPHONE		(MEW_STR_MSG_BASE + 54)
#define	MSG_SESN_EXTRA		(MEW_STR_MSG_BASE + 55)
#define	MSG_SESN_ECONN		(MEW_STR_MSG_BASE + 56)
#define	MSG_SESN_EWTIME		(MEW_STR_MSG_BASE + 57)
#define	MSG_SESN_ERTRYCONT	(MEW_STR_MSG_BASE + 58)
#define	MSG_SESN_ERTRYWAIT	(MEW_STR_MSG_BASE + 59)
#define	MSG_ERROR_CNF		(MEW_STR_MSG_BASE + 60)
#define	MSG_TERM_COLUMNS	(MEW_STR_MSG_BASE + 61)
#define	MSG_INVALID_TABS	(MEW_STR_MSG_BASE + 62)

// Sachin
#define WM_KBHIT       (WM_USER + 60)
#define WM_TERM_CLOSE  (WM_USER + 61)
#define WM_TELNET_READ (WM_USER + 62)

#define ABORT_OUTPUT_COMMAND 0xF5
#define INTERRUPT_PROCESS_COMMAND 0xF4


/* global data from main.c */
extern	HANDLE	hInst;			/* application instance handle */
extern	HWND	hMainWnd;		/* main window handle */
extern	HWND	hTermWnd;		/* terminal window handle */
extern	HWND	hTbarWnd;		/* Tool Bar window handle */
extern	HWND	hStatusWnd;		/* status bar window handle */
extern	HWND	hTimeWnd;		/* time bar window handle */
extern	HANDLE	hMewAccTable;	/* accelerator table handle */
extern	WNDCLASS WndClass;		/* window class variable */
extern	HCURSOR	hCurCursor;		/* current cursor */
extern	HCURSOR	hSaveCursor;	/* save cursor */
extern	HCURSOR	hStandard;		/* standard arrow cursor */
extern	HCURSOR	hHourGlass;		/* hour glass cursor */
extern	HCURSOR	hCross;			/* crosshair cursor for cut&pate */
extern	HCURSOR hIBeam;			/* I-beam cursor in Terminal window */
extern	HCURSOR hFinger;
extern	RECT	MainWndRect;	/* main window dimensions */
extern	RECT	TermWndRect;	/* terminal window dimensions */
extern	RECT	TbarWndRect;	/* Tool Bar window dimensions */
extern	RECT	StatusWndRect;	/* status bar window dimensions */
extern	RECT	TimeWndRect;	/* time bar window dimensions */
extern	RECT	MainDim;			/* complete main window dimensions */
extern	BOOL	ShowStatusWnd;	/* show or hide status bar */
extern	BOOL	ShowTimeWnd;	/* show or hide time bar */
extern	BOOL	ShowTbarWnd;	/* show or hide tool bar window */
extern	WORD	CurState;		/* current state of the session */
extern	BOOL	InMenu;			/* whether currently in menu selection */
extern	BOOL	Iconified;		/* MEW main window has been iconified */
extern	int	FAR *LineHdlPtr;
extern	int	CommandLineArgument;

/* prototype declarations for main.c */
int  	PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL 	NEAR PASCAL InitInstances(HANDLE);
void	InitColorTable(void);
void	ExitFunctions(HWND hWnd);
long 	FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
int 	FAR PASCAL AboutDlgProc(HWND hDlg, unsigned message, WPARAM wParam, LONG lParam);
void	HandleMenuItems(void);
void	ModifyTransferMenu (void);
int	InvokeDialog (HWND hWnd, LPSTR DlgName, FARPROC DlgFn);
int	ComputeWinDimensions (HWND hWnd);
void	DisplayMEWindows(void);
void	DisplayMEWindow (WORD Action);
void	AdjustWinDimensions (WORD Action);
void	ComputeTimeWndCoords(void);
void	ComputeTbarWndCoords(void);
void	ComputeStatusWndCoords(void);
void	ComputeTermWndCoords(void);
void	DisplayLogo (HDC hDc);
void	SetupDriverFns (void);

LPSTR	MemAlloc (WORD wSize);
void	MemFree (LPSTR pMemPtr);

int 	FAR PASCAL DummyDrvrFn (void);
int		DispMsgBox(HWND hWnd, int Idx, LPSTR Title, int Flags);
int		DispMsgBox_s(HWND hWnd, int Idx, LPSTR Title, LPSTR Str, int Flags);
int		DispMsgBox_d(HWND hWnd, int Idx, LPSTR Title, int Val, int Flags);

