/*--------------------------------------------------------------------------*/
/*	File		:	MEWLOG.C												*/
/*	Purpose		:	This file contains remote file log routines.			*/
/*--------------------------------------------------------------------------*/

#include	<windows.h>
#include	<fcntl.h>
#include	<sys\types.h>
#include	<sys\stat.h>
#include	<commdlg.h>
#include	<share.h>
#include	<io.h>
#include	<stdlib.h>

#include	"main.h"
#include	"mew.h"
#include	"session.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlndata.h"
#include	"status.h"
#include	"mewlog.h"
#include	"file.h"
#include	"myprint.h"
#include	"dlgbox.h"
#include	"looks.h"

WORD	CheckedButton;
BYTE	*LogErrHeader = "Log Settings error";
BYTE	LogFileName[13] = "mtrouter.log";
BYTE	FileLogging;					/*	Set to FALSE if log suspended.	*/
BYTE	LogState;
int	LogFd = -1;							/*	Log file descriptor.			*/

BYTE	LogBuffer[LOG_BUFFER_SIZE];		/*	Buffer for logging session.		*/
WORD	LogBufferWriteIdx;				/*	Write index into log buffer.	*/

BYTE	LogFilter[] = "Log files (*.LOG)\000*.LOG\000";
char	LogFilesDir[68];
BYTE	SelFilePathName[128];
/*--------------------------------------------------------------------------*/
/*	Name		:	OpenLogFile												*/
/*	Input		:	file_name, log file name.								*/
/*	Output		:	0 if successful, else -1.								*/
/*	Synopsis	:	Opens the log file by the specifed name.				*/
/*--------------------------------------------------------------------------*/

int		OpenLogFile(LPSTR file_name)
{
	CloseLogFile();						/*	If log file already open close.	*/
	SeparateFile(LogFilesDir, LogFileName, file_name);
	
	if ( ! LogFilesDir[0]) /* directory not specified */
		lstrcpy(LogFilesDir, LoadPath);
	else
		if( !strchr(LogFilesDir, ':')) { /* relative path name specified */
			_fullpath(TmpStr, LogFilesDir, 68);
			lstrcpy(LogFilesDir, TmpStr);
		}

	/* open the file and trucuate if it exists, else create */
	_lcreat(file_name, 0);	// creat the file with normal attribs

	if ((LogFd = _lopen(file_name, READ_WRITE)) < 0) {
		goto error_exit;
	}
	FileLogging = TRUE;
	LogBufferWriteIdx = 0;
	LogState = LOG_OPEN;
	UpdateStatusBar(LOG_FLD_IDX);
	return(0);

	error_exit :
	LogFd = -1;							/*	Set to an invalid value.		*/
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	AppendLogFile											*/
/*	Input		:	file_name, log file name.								*/
/*	Output		:	0 if successful, else -1.								*/
/*	Synopsis	:	Opens the specified log file in append mode.			*/
/*--------------------------------------------------------------------------*/

int		AppendLogFile(BYTE *file_name)
{
	CloseLogFile();						/*	If log file already open close.	*/
	SeparateFile(LogFilesDir, LogFileName, file_name);

	if ( ! LogFilesDir[0]) /* directory not specified */
		lstrcpy(LogFilesDir, LoadPath);
	else

	if( !strchr(LogFilesDir, ':')) {/* relative path name specified */
		_fullpath(TmpStr, LogFilesDir, 68);
		lstrcpy(LogFilesDir, TmpStr);
	}

	/* open the file in append mode to write if it exists */
	/* create the file if doesn't exists */
//	if ((LogFd = open(file_name, O_CREAT | O_WRONLY | O_APPEND | O_BINARY ,
//					S_IREAD | S_IWRITE)) < 0) {
	if ((LogFd = _lopen(file_name, READ_WRITE)) < 0) {
		goto error_exit;
	}
	FileLogging = TRUE;
	LogBufferWriteIdx = 0;
	LogState = LOG_OPEN;
	UpdateStatusBar(LOG_FLD_IDX);
	return(0);

	error_exit :
	LogFd = -1;							/*	Set to an invalid value.		*/
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	CloseLogFile											*/
/*	Input		:	None													*/
/*	Output		:	None													*/
/*	Synopsis	:	If the log file is open it is closed.					*/
/*--------------------------------------------------------------------------*/

void	CloseLogFile(void)
{
	if (LogFd >= 0) {					/*	Check if log file open.			*/
		FlushLogBuffer();
		_lclose(LogFd);
		LogState = LOG_CLOSED;
		UpdateStatusBar(LOG_FLD_IDX);
		LogFd = -1;						/*	Invalidate file handle.			*/
		FileLogging = FALSE;
	}
}

/*--------------------------------------------------------------------------*/
/*	Name		:	SuspendLog												*/
/*	Input		:	None													*/
/*	Output		:	0 if successful, else -1.								*/
/*	Synopsis	:	Suspends the session logging if log file is open, else	*/
/*						-1 is returned.										*/
/*--------------------------------------------------------------------------*/

int		SuspendLog(void)
{
	if (LogFd >= 0) {					/*	Log file open ?					*/
		FileLogging = FALSE;
		LogState = LOG_SUSPENDED;
		UpdateStatusBar(LOG_FLD_IDX);
		return(0);
	}
	else								/*	Log file is not open.			*/
		return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	ResumeLog												*/
/*	Input		:	None													*/
/*	Output		:	0 if successful, else -1.								*/
/*	Synopsis	:	If logging is suspended it is resumed and 0 is returned,*/
/*						else -1 is returned.								*/
/*--------------------------------------------------------------------------*/

int		ResumeLog(void)
{
	if (LogFd >= 0) {					/*	Log file open ?					*/
		FileLogging = TRUE;
		LogState = LOG_OPEN;
		UpdateStatusBar(LOG_FLD_IDX);
		return(0);
	}
	else								/*	Log file is not open.			*/
		return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	FlushLogBuffer											*/
/*	Input		:	None													*/
/*	Output		:	0 if successfully flushed, else -1.						*/
/*	Synopsis	:	Flushes the log buffer into log file.					*/
/*--------------------------------------------------------------------------*/
int		FlushLogBuffer(void)
{
	if (LogFd >= 0) {
		if (_lwrite(LogFd, LogBuffer, LogBufferWriteIdx) !=
												(UINT) LogBufferWriteIdx) {
			LoadString(hInst, 330, TmpStr, 128);
			ShowMesg (TmpStr);
			_lclose(LogFd);
			LogFd = -1;
			return(-1);
		}
	}
	LogBufferWriteIdx = 0;
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	WriteToLogFile											*/
/*	Input		:	None										 			*/
/*	Output		:	-1 or 0													*/
/*	Synopsis	:	Writes the RecdChar to the log buffer. may flush		*/
/*--------------------------------------------------------------------------*/

int		WriteToLogFile(void)
{
	if (LogBufferWriteIdx >= LOG_BUFFER_SIZE - 2) {
		if (FlushLogBuffer() < 0)
			return(-1);
	}
	LogBuffer[LogBufferWriteIdx++] = RecdChar;
	if ( PbkEntry.TrmParams.AddLFtoCR && RecdChar == CR_ASCII) {
		LogBuffer[LogBufferWriteIdx++] = LF_ASCII;
	}
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	StartLog												*/
/*	Input		:	None													*/
/*	Output		:	return value of OpenLogFile								*/
/*	Synopsis	:	Opens the log file specified by LogFileName and returns	*/
/*						the return value OpenLogFile.						*/
/*--------------------------------------------------------------------------*/

int		StartLog(void)
{
	BYTE	path_name[PATH_NAME_LEN + FILE_NAME_LEN - 1];

	lstrcpy (path_name, LogFileName);
	return(OpenLogFile((LPSTR) path_name));
}

/*--------------------------------------------------------------------------*/
/*	Name		:	AppendLog												*/
/*	Input		:	None													*/
/*	Output		:	Zero													*/
/*	Synopsis	:	Opens the log file LogFileName in append mode.			*/
/*--------------------------------------------------------------------------*/

int		AppendLog(void)
{
	BYTE	path_name[PATH_NAME_LEN + FILE_NAME_LEN - 1];

	lstrcpy (path_name, LogFileName);
	return(AppendLogFile(path_name));
}

/***************************************************************************
*	Routine	:	LogOptionsDlgProc
*	Input	:	
*	Return	:	
*	Synopsis:	Handles the log options dialog box messages that are passed
				on by the common dialog box.
***************************************************************************/
/*int FAR PASCAL*/
UINT	CALLBACK
LogOptionsDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	int 	i;

	switch (message) {

		case WM_INITDIALOG :
			DLGCenterDialog(hDlg);

			/* first disable all controls in the window */
			for (i = IDC_LOG_OPEN; i <= IDC_LOG_RESUME; i++)
				EnableWindow (GetDlgItem(hDlg, i), FALSE);

			/* Show the current log file name */
			SetDlgItemText (hDlg, IDC_LOG_FILE_NAME, (LPSTR) LogFileName);

			/* Enable the controls depending on the log state */
			switch (LogState) {
				case LOG_CLOSED :
					/* Enable Append and Open radio buttons */
					EnableWindow(GetDlgItem(hDlg, IDC_LOG_OPEN), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_LOG_APPEND), TRUE);
					CheckedButton = IDC_LOG_OPEN;
					break;

				case LOG_OPEN :
					/* Enable Close and Suspend radio buttons */
					CheckedButton = IDC_LOG_CLOSE;
					EnableWindow(GetDlgItem(hDlg, IDC_LOG_SUSPEND), TRUE);
OpenEnable:
					EnableWindow(GetDlgItem(hDlg, IDC_LOG_CLOSE), TRUE);
					/* disable name edit, namelist, dirlist ... */
					EnableWindow(GetDlgItem (hDlg, IDC_LOG_FILE_NAME), FALSE);
					EnableWindow(GetDlgItem (hDlg, 0x460), FALSE);
					EnableWindow(GetDlgItem (hDlg, 0x461), FALSE);
					EnableWindow(GetDlgItem (hDlg, 0x470), FALSE);
					EnableWindow(GetDlgItem (hDlg, 0x471), FALSE);
					break;

				case LOG_SUSPENDED :
					CheckedButton = IDC_LOG_RESUME;
					EnableWindow (GetDlgItem(hDlg, IDC_LOG_RESUME), TRUE);
					goto OpenEnable;
			}
			CheckRadioButton (hDlg, IDC_LOG_OPEN, IDC_LOG_RESUME, CheckedButton);
			SetFocus(GetDlgItem(hDlg, IDOK));
			return TRUE;

		case WM_COMMAND :
			switch (wParam) {
				case IDC_LOG_OPEN :
				case IDC_LOG_CLOSE :
				case IDC_LOG_APPEND :
				case IDC_LOG_SUSPEND :
				case IDC_LOG_RESUME :
//					if (IsDlgButtonChecked(hDlg, wParam) == DLG_BTN_GRAYED)
//						break;
					CheckedButton = wParam;
					CheckRadioButton (hDlg, IDC_LOG_OPEN, IDC_LOG_RESUME, wParam);
					return TRUE;
				case IDOK:
				case IDCANCEL:
					return FALSE;
			}
	}
	return FALSE;
}

/****************************************************************************
*	Routine	:	LogOptionsDlg												*
*	Input	: 	Handle to main window										*
*	Synopsis:	This function calls the common dialog box to read in the 	*
*	log file name and its state. The messages due to the added controls are *
*	processed by the LogOptionsDlgProc.										*
****************************************************************************/
void	LogOptionsDlg(HWND	hW)
{
	int	i;

	if (! LogFilesDir[0]) {
		lstrcpy(LogFilesDir, ".\\");
		lstrcpy(LogFileName, "mtrouter.log");
	}
			
	if(GetFilePathName(hW, (LPSTR) LogFilesDir,
		"Firewall Console - Log Settings", LogFilter,
		"LOG", (FARPROC)&LogOptionsDlgProc, (LPSTR)"LOGOPTIONSDLG")) {
			switch (CheckedButton) {
				case IDC_LOG_OPEN :
				case IDC_LOG_APPEND :
  					i = (CheckedButton == IDC_LOG_OPEN) ?
  							OpenLogFile ((LPSTR)SelFilePathName) :
  								AppendLogFile (SelFilePathName);
  					if (i < 0)
  						DispMsgBox(hMainWnd, MSG_ER_LOG_OPEN, NULL, MB_OK);
  					break;

  				case IDC_LOG_CLOSE :
  					CloseLogFile();
  					break;
							
  				case IDC_LOG_SUSPEND :
  					SuspendLog();
  					break;

  				case IDC_LOG_RESUME :
  					ResumeLog();
  					break;
  			}
			UpdateStatusBar(LOG_FLD_IDX);
			tbUpdateToolbarButton(IDTB_LOG);
//			tbUpdateToolbar();
  	}		
}

/***************************************************************************
*	Routine	:	GetFilePathName()
*	Input	:	
*	Return	:	
*	Synopsis:	Gets a file name for opening
***************************************************************************/
BOOL	GetFilePathName(HWND hWnd, LPSTR InitDir, LPSTR Head,
		LPSTR Filter, LPSTR Extn, FARPROC HookFuncPtr, LPSTR Template)
{

	BOOL	RetVal;
	FARPROC	HookFuncProc;
	OPENFILENAME	ofn;
//	DWORD	ret;

	SelFilePathName[0] = NULL;
	memset ((LPSTR)&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = Filter;

	ofn.nFilterIndex = 1;
	ofn.lpstrFile = &SelFilePathName[0];
	ofn.nMaxFile = 128;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = InitDir;
	ofn.lpstrTitle = Head;
	ofn.lpstrDefExt = Extn;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY |
						 OFN_ENABLETEMPLATE | OFN_ENABLEHOOK | OFN_SHAREAWARE;

	ofn.lpTemplateName = Template;
	/* Install a hook procedure */
	HookFuncProc = MakeProcInstance( HookFuncPtr, hInst);
	ofn.lpfnHook = HookFuncProc;

	/* Invoke the dialog box */
	RetVal = GetOpenFileName((LPOPENFILENAME) &ofn);

//	ret = CommDlgExtendedError();
	/* free the hook function */
	FreeProcInstance(HookFuncProc);

	return (RetVal);
}

/**********************   Last Line   ************************************/

