/****************************************************************************
 * Filename   : session.h
 * Purpose    : This file contains the definitions and structure type
 *				declarations for all the variables related with a session.
 ****************************************************************************/


#define	LINE_NAME_LEN	31
#define	FILE_NAME_LEN	13
#ifdef	TERM_NAME_LEN
#undef	TERM_NAME_LEN
#endif
#define	TERM_NAME_LEN	9


/* mask on the line signals bytes */
#define	DTR_MASK		0x01
#define	RTS_MASK		0x02
#define	DCD_MASK		0x80
#define	DSR_MASK		0x20
#define	CTS_MASK		0x10

#define	MAX_NUM_STATES		4

/* various states */
#define	ST_NORMAL_MODE		0
#define	ST_SCROLL_MODE		1
#define	ST_WANCHAT_MODE	2
#define	ST_MUXCONF_MODE	3

/* Masks on CurState */
#define	MSK_SCROLL_MODE	  		( 1 << ST_SCROLL_MODE)

#define	IS_CONNECTED()		(CurState & (MSK_CONNECTED | MSK_WAIT_INBOUND) )

/* certain condition checks used before for executing commands */
#define	IN_SCROLL		(CurState & MSK_SCROLL_MODE)


#define	UNAME_LEN			20
#define	PASSWORD_LEN		20
#define	DESC_LEN				50
#define	PHONE_NUM_LEN		60
#define	XTRA_MDM_CMD_LEN	30
#define	SESN_CONN_RESP_LEN	50

#define	NULL_STRING			""
#define	DEF_CONNECT_TIME	45
#define	DEF_RETRY_COUNT		3
#define	DEF_RETRY_WAIT		5

#define	MAX_CONNECT_TIME	180			// upto 3 minutes before carrier
#define	MAX_RETRY_COUNT		100
#define	MAX_RETRY_WAIT		300			// upto 5 minutes before redial

/* line param type structure, This is passed into DLLs also */
typedef	struct {
	DWORD	BaudRate;		/* actual baud rate value */
	BYTE	Parity;			/* parity value as defined in windows.h */
	BYTE	DataLen;		/* actual data length */
	BYTE	StopBits;		/* number of stop bits as defined in windows.h */
	BYTE	FlowControl;	/* flow control state */
	WORD	BreakLen;		/* length of break signal */
	BYTE	LineType;				/* current line type as defined above */
	BYTE	LineName[LINE_NAME_LEN];/* current line name */
} LineParamsType;

/* This structure is changed in session setup dialog */
typedef struct tagSesnStup {
	BYTE	Name[UNAME_LEN + 1];		/* User name for the session */
	BYTE	Description[DESC_LEN + 1];		/* session description */
	BYTE	Script [ FILE_NAME_LEN + 1];	/* script file name */
	BYTE	PhoneNumber[PHONE_NUM_LEN + 1];	/* Phone number for the session */
	BYTE	XtraMdmCmd[XTRA_MDM_CMD_LEN + 1];	/* session specific extra mdm str*/
	BYTE	ConnectResp[SESN_CONN_RESP_LEN + 1]; /* session spec. connect str */
	BYTE	ConnectWaitTime;			/* Wait time for connect resp(sec) */
	BYTE	ConnectRetryCount;			/* number of connect retries */
	BYTE	ConnectRetryWait;			/* Time to wait before redial */
} SesnParamsType;
/* Session variant params for the terminal */
typedef	struct tagTermParms {
	BYTE	TermName[TERM_NAME_LEN];/* current session terminal name	*/
	BYTE	StripLF;				/*	Set to strip LF.				*/
	BYTE	AddLFtoCR;				/*	add Line feed to CR				*/
	BYTE	TabStops;				/*	Tab stops at columns			*/
	BYTE	AutoMargin;				/*	Terminal has auto margin ?		*/
	BYTE	BackSpace;				/*	Can backspace on ^H ?			*/
	BYTE	BackSpaceBlank;			/*	Can overstrike backspace by ' '?*/
	BYTE	WrapBackSpace;			/*	Can backspace wrapback ?		*/
	BYTE	OverStrike;				/*	Can overstrike on backspace ?	*/
	BYTE	StandOutScroll;			/*	Will scroll in standout mode ?	*/
	BYTE	FollowCursor;			/* 	Follow the cursor by moving win ? */
	BYTE	CharsInLine;			/*	Number of Characters in Line	*/
	BYTE	LinesInScreen;			/*	Number of Lines per screen.		*/
	BYTE	EchoOn;					/*	Local echo done if TRUE.		*/
} TermParamsType;

/* ascii file xfer settings  */
typedef	struct tagAsciiParams {
	int	CharDelay;
	int	LineDelay;
	int	ExpandTabs;
	int	CRLFTrans;
} AsciiParamsType;

typedef	struct	tagZmParams {
	BOOL	CrshRcvr;
	BOOL	AutoDnld;
	BOOL	EscCtls;
	BOOL	Crc32;
	int		Rxbuflen;
} ZmParamsType;

/* Kermit initialization string */
typedef struct {
	BYTE 	ToCharMaxLen;					/* tochar(max_len) */
	BYTE 	ToCharTimeout;					/* tochar(timeout) */
	BYTE 	ToCharNoOfPadChars;				/* tochar(no of pad chars) */
	BYTE 	CtlPadChar;						/* ctl(pad char) */
	BYTE 	ToCharEOL;						/* ToChar(EOL) */
	BYTE 	CtlQChar;						/* To quote control char */
	BYTE 	BinQChar;						/* To quote 8 bit chars */
	BYTE 	ChkType;						/* Checksum type (1,2,3) */
	BYTE 	ReptChar;						/* To show repeat */
	BYTE 	CapByte;						/* Capability byte */
	BYTE	WindowSize;						/* Window size 0-31 */
	BYTE	MaxLX1;							/* hi part of pkt max len */
	BYTE	MaxLX2;							/* lo part of pkt max len */
} KermitInitData;

typedef struct tagPbkEntry {
	SesnParamsType	SnParams;		/* Session setup for the entry */
	LineParamsType	LnParams;		/* Line parameters of entry */
	TermParamsType	TrmParams;		/* Terminal Parameters of entry */
	BYTE	Protocol;				/* Xfer protocol of the session */
	union {							/* Xfer parameters of Protocol, if any */
		AsciiParamsType	AsciiParams;
		ZmParamsType	ZmParams;
		KermitInitData	OurInitData;
	} XfrParams;
	/* Last successful connection */
	/* number of calls made */
	/* total duration of connection */
} PbkEntryType;

#define		PbkEntrySize	(sizeof(PbkEntryType))

#define	TRMPRMS		(PbkEntry.TrmParams)		/* for brievity */
#define	SNPRMS		(PbkEntry.SnParams)
#define	LNPRMS		(PbkEntry.LnParams)


/* DDE timer declarations */
#define	DDE_TIMER_ID	0x51
#define	DDE_PERIOD		10000

/* extern variable declarations */
extern	PbkEntryType	PbkEntry;

/* prototype declarations for session.c */
void	SetDefSessionInfo(void);

BOOL	ProcessFileName (BYTE *ptr, BYTE *ext);
BOOL	CreateConnectTimer (void);
void	DestroyConnectTimer (void);
WORD 	FAR PASCAL ConnectTimer (HWND hWnd, WORD wMsg, int nIDEvent, DWORD dwTime);
int 	FAR PASCAL SetSesnDlgProc (HWND hDlg, WORD message, WORD wParam, LONG lParam);
void	TerminateSession(void);
BOOL	InitiateSession(BOOL exec_script, BOOL load_only);

