/****************************************************************************
 * Filename   : status.h
 * Purpose    : This file contains the prototype declarations for status.c.
 ****************************************************************************/

#define	MAX_STAT_FIELDS	2			/* max number of fields in status bar */
#define	MAX_FIELD_LEN	20			/* maximum field title length */

#define	LED_SCROLLLOCK	4
#define	LED_NUMLOCK		5
#define	LED_CAPSLOCK	6

#define	LIGHT_ON			1
#define	LIGHT_OFF		2
#define	LIGHT_TOGGLE	3

#define	LOG_FLD_IDX		0
#define	PRINT_FLD_IDX	1

typedef	struct {
	BYTE	Title[MAX_FIELD_LEN+1];	/* status field title */
	RECT	Coords;					/* each field dimensions */
} StatusField;

/* global data from status.c */

extern	int		CurHlpIdx;
extern	BOOL	HelpInStatus;

extern	char	*MainStatusStrs[];
extern	char	*StatusFldStrs[];
extern	StatusField	StatFields[];
extern	LineParamsType	TmpConParams;


/* prototype declarations for status.c */
long 	FAR PASCAL StatusWndProc(HWND, unsigned, WORD, LONG);
int	CreateStatusWnd (HWND hParentWnd);
void	DisplaySessionStatus (void);
int	DisplayStatusBar (HDC hDc);
void	ReDisplayStatusBar(void);
int	ComputeStatFieldCoords (void);
int	CheckClickOnField (HWND hDc, LONG XYPos);
void	UpdateStatusBar (int FldIdx);
char 	*GetStatusStr (void);

void	ShowOneLineHelp (int index);
void	ShowCurOneLineHelp (HDC hDc);
void	CloseOneLineHelp (void);
int	GetOneLineHelpIdx (WORD ItemID);
int	GetTopBarOneLineHelpIdx (WORD MenuHandle);
void	HandleKbdLeds (BYTE KbdLed, BYTE Flag);
int	CheckOverButton (HWND hWnd, LONG XYPos);
