/*----------------------------------------------------------------------------
*	File			:	TERM.C
*	Purpose		:	Terminal window creation and setup dialog proc
*	Package		:	MultiExpress (Windows) - Version 2.00
*	Authors		:	Vidy
*	Date			:	21st December 1991.
*---------------------------------------------------------------------------*/

#include 	<windows.h>
#include	"commdlg.h"
/* For the _dos_findfirst call */
#include	"dos.h"
#include	"errno.h"

#include	"main.h"
#include	"mew.h"
#include "term.h"
#include	"session.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlndata.h"
#include	"emlnfuns.h"
#include	"wstdio.h"
#include	"windisp.h"
#include	"status.h"
#include	"config.h"
#include	"scroll.h"
#include	"file.h"
#include	"dlgbox.h"
#include	"mewlog.h"

#define		TERM_TIMER_ID	0x52
#define		EMUL_BUFF_SIZE	512

char		TermDataBuf[EMUL_BUFF_SIZE];
extern	void snd_packet(BYTE *pkt_data, int pkt_size);
extern BOOL IsPortIP ;
extern HWND	hConfigWnd;

char	*TermSpec = "*.TRM";	/* terminal emuln files spec */
FileListType	*TrmList;		/* The terminal names list */
TermParamsType	*TrmTmp;		/* Temporary location pointer for term params */

//extern	BOOL	NewEntryFlag;

/***************************************************************************
*	Routine	:	CopyFileName
*	Input	:	
*	Return	:	
*	Synopsis:	Copies only the file name from second argument to first
*				argument without extension. Terminates the copied string
*				with a NULL. Avoid path name if present
***************************************************************************/
void	CopyFileName (BYTE *to, BYTE *from)
{
	BYTE	*ptr;

	ptr = from + strlen (from) - 1;		/* point to last char */
	while ( (ptr > from) && (*ptr != '\\'))
		ptr --;
	if (*ptr == '\\')
		ptr++;

	while (*ptr && *ptr != '.')
		*to++ = *ptr++;

	*to = '\0';
}
/*---------------------------------------------------------------------------
 *	Name		:	CompactFileList()
 *	Input		:	a files list and an indx in that
 *	Output		:	
 *	Synopsis	:	Removes an entry corresponding to indx from flist
 *--------------------------------------------------------------------------*/
void	CompactFileList(FileListType *flist, BYTE indx)
{
	BYTE	nfiles;
	for (nfiles = 0; *(BYTE *) (flist + nfiles); nfiles++);	/* total entries */
	if (indx >= nfiles)		/* This shouldn't happen */
		return;
	for ( ; indx < nfiles; indx++)
		strcpy((BYTE *) (flist + indx), (BYTE *) (flist + indx + 1));
}

/*---------------------------------------------------------------------------
 *	Name		:	
 *	Input		:	
 *	Output		:	
 *	Synopsis	:	
 *--------------------------------------------------------------------------*/
FileListType *SortFileList (FileListType *src_list)
{
	FileListType *dst_list;
	BYTE	*min_ptr;
	int		src_indx, dst_indx, num_files;

	if (! src_list )
		return NULL;
		
	/* first get the number of files */
	for (num_files = 0; * (BYTE *) (src_list + num_files) ; num_files++);
	if (!num_files)
		return (src_list);

	/* allocate so much * file list size memory */
	dst_list = (FileListType *)
			MemAlloc ( (num_files + 1) * sizeof(FileListType) );
	if (!dst_list)			/* return original list if no mem to sort */
		return src_list;

	/* fill the dst_list with the minimum pointers one-by-one */
	for (dst_indx = 0; dst_indx < num_files; dst_indx++) {
		min_ptr = (BYTE *) src_list;
		for (src_indx = 0; src_indx < num_files; src_indx++) {
			if (strcmp(min_ptr, (BYTE *) (src_list + src_indx)) > 0)
				min_ptr = (BYTE *) (src_list + src_indx);
		}
		/* copy this iteration's minimum value to the current dst_indx */
		strcpy((BYTE *) (dst_list + dst_indx), min_ptr);
		*min_ptr = 0x7F;		/* make this big for next iteration */
	}
	MemFree ((LPSTR) src_list); 		/* free the old list */
	return dst_list;				/* return the new sorted list */
}

/***************************************************************************
*	Routine	:	MakeFileList (char *DirPathName, char *FileSpec)
*	Input	:	extension string pointer
*	Return	:	pointer to FileListType
*	Synopsis:	Finds out how many files with the specification "filename"
*				is present in the current directory. "filename" will mostly
*				have wildcards. Used to get a list of files like .TRM
*				and script files.
*				Finds out howmany "filename" files are there in the directory.
*				allocates (that many + 1) * 9 bytes and fills with the
*				names without extension. The last slot is made a NULL
*				If file_list is NULL upon return it means there are
*				no files in the	directory with this extension
***************************************************************************/
FileListType
*MakeFileList (char *DirPathName, char *FileSpec)
{
	int		nfiles = 0;			/* number of files in the directory */
	int		index;
	char	FullFileSpec[68];	/* buffer containing the full pathname spec */
	FileListType *file_list;
	struct	find_t fileinfo;

	/* make the full path specification */
	MakeFullFileName(FullFileSpec, DirPathName, FileSpec);

	if ( ! _dos_findfirst(FullFileSpec, _A_NORMAL, &fileinfo)) {
		nfiles++;						/* Found at least one file */
		while ( ! _dos_findnext ( &fileinfo))
			nfiles ++;						/* one more found */
	}
	if (nfiles) {		/* There is at least one trm file */
		/* Get memory from local heap for storing the names */
	   file_list = (FileListType *)
			MemAlloc ( (nfiles + 1) * sizeof(FileListType) );

		if (!file_list)		/* No memory */
			return NULL;

		_dos_findfirst (FullFileSpec, _A_NORMAL, &fileinfo);
		CopyFileName ((BYTE *)file_list, fileinfo.name);

		for (index = 1; index < nfiles; index++ ) {
			_dos_findnext ( &fileinfo);
			CopyFileName ( (BYTE *) (file_list + index), fileinfo.name);
		}
		* (BYTE *) (file_list + index) = NULL;	/* Last entry is NULL */

	} else {
		file_list = NULL;		/* No trm files at all */
	}
	return  (SortFileList(file_list));
}

extern	WORD FAR PASCAL 
AutoZmTimer (HWND hWnd, WORD wMsg, int ID, DWORD dwTime);
extern	FARPROC	lpAutoZmTimer;

/****************************************************************************
 * Function   : CreateTermWnd (HWND)
 * Purpose    : creates the terminal window.
 ****************************************************************************/
int
CreateTermWnd (HWND hParentWnd, HANDLE hInstance)
{

	 /* Init emulation. Read in the TRM and CFG files init state machine */
	InitEmulation();

	/* open the terminal window. get the DC etc */
    wopen(hParentWnd, TRUE);
	
	InitTermParams(LinesInScreen, CharsInLine);

	SetTimer (hTermWnd, TERM_TIMER_ID, TERM_POLL_TIMER, (DWORD)NULL);
								/* set a 50ms timer */
	if (! ScrollBuffSize)
		SetScrollBuffSize(DEF_SCROLL_BUF_SIZE);

	return TRUE;
}

/***************************************************************************
*	Routine	:	ReadAndDisp (void)
*	Input	:	None
*	Return	:	None
*	Synopsis:	If the current state is a simple connection, read chars from
*				the line and call emulation
***************************************************************************/
void	ReadAndDisp(void)
{
//	int	count = 0;
//	int	tcount = 0;
//	if ((count = (* DriverFns[LINE_READ])
//				(*LineHdlPtr, (LPSTR)TermDataBuf, EMUL_BUFF_SIZE) ) > 0) {
//		Emulation((LPSTR)TermDataBuf, count);
//	}
}

/***************************************************************************
*	Routine	:	SendChars (BYTE FAR * ch, WORD count)
*	Input	:	pointer to string of chars and number of chars
*	Return	:	None
*	Synopsis:	Writes the specified number of chars on the line if connected
*				It is written on the screen
***************************************************************************/
int 	SendChars(BYTE FAR *ptr, WORD count)
{
//		return (* DriverFns[LINE_WRITE])(*LineHdlPtr, ptr, count);
	return 0;
}

/***************************************************************************
*	Routine	:	WritePort (BYTE ch)
*	Input	:	ch to go out
*	Return	:	None
*	Synopsis:	Writes the character to the line. Also echos the char
*				if local echo is enabled
***************************************************************************/
void	WritePort(BYTE ch)
{
	if (!IsPortIP)
		WriteComm (*LineHdlPtr, &ch, 1);
	else
	{
		SendMessage (hConfigWnd, WM_KBHIT, ch, 0) ;
	}
}

/***************************************************************************
*	Routine	:	WriteNchars(LPSTR ptr, WORD count)
*	Input	:	pointer to chars go out and count
*	Return	:	None
*	Synopsis:	Writes the characters to the line. Doesn't echo the char
***************************************************************************/
void	WriteNchars (LPSTR pointer, WORD count)
{
	WriteComm (*LineHdlPtr, pointer, count);
}

/****************************************************************************
*	Routine	:	ChangeScreenWidth (BYTE clms)
*	Input	:	clms number of new columns
*	Return	:	None
*	Synopsis:	Changes the number of columns to the new value passed in.
*				If 0 is passed then the clms are set to 132 or 80.
****************************************************************************/
BOOL	ChangeScreenWidth (BYTE clms)
{
	BYTE	new_width;

	if (!clms) 		/* This is a change request with mouse click */
		new_width = (BYTE)((CharsInLine == 80) ? 132 : 80);
	else
		new_width = clms;
		
	if ( !InitTermParams( LinesInScreen, new_width)) {
		TRMPRMS.CharsInLine = CharsInLine;
		return FALSE;
	}

	TRMPRMS.CharsInLine = new_width;
	InvalidateRect(hTermWnd, NULL, FALSE);		/* invalidate display area */
	SetupWinMatrix ();		/* We need to update win sizes */
	UpdateWindow(hTermWnd);
	ReDrawCursor();
	return TRUE;
}
/****************************************************************************
*	Routine	:	ChangeScreenHeight (BYTE rows)
*	Input	:	New height
*	Return	:	None
*	Synopsis:	Changes the number lines to the new value passed in.
*				If 0 is passed then height is set to DEF_LINES_IN_SCREEN
****************************************************************************/
BOOL	ChangeScreenHeight(BYTE rows)
{
	BYTE	new_height;

	new_height = (BYTE) ((rows) ? rows : DEF_LINES_IN_SCREEN);
		
	if ( !InitTermParams( rows, CharsInLine)) {	/* effect the new change */
		TRMPRMS.LinesInScreen = LinesInScreen;
		return FALSE;
	}

	TRMPRMS.LinesInScreen = rows;
	InvalidateRect(hTermWnd, NULL, FALSE);		/* invalidate display area */

	SetupWinMatrix ();						/* We need to update win sizes */
	UpdateWindow(hTermWnd);
	ReDrawCursor();
	return TRUE;
}

/****************************************************************************
The following routines are for talking to MTRouter.
*****************************************************************************/
#define	ULONG		DWORD
#define	USHORT	WORD

#include	"brcif.h"

char	ResetSequence[5] = "ATRZ";
#define	ResetSequenceLength	(sizeof(ResetSequence) - 1)

char	XmitResetSequence[6] = "ATRZ\r";
#define	XmitResetSequenceLength	(sizeof(XmitResetSequence) - 1)

/* The following routine is a simple search on an incomming stream of
characters for a pattern which has no repeating characters as ATRZ.
if characters in the patterns repeat this algo may fail. Since it is
simple and enough for our purpose this is OK */

int	PatternMatchState = 0;

BOOL	CheckExitSequence(char rcvchar)
{
	if (rcvchar == ResetSequence[PatternMatchState])
	{
		PatternMatchState++;
		if (PatternMatchState == ResetSequenceLength)
			return TRUE;
	}
	else
	{
		if (rcvchar == ResetSequence[0])
			PatternMatchState = 1;
		else
			PatternMatchState = 0;
	}
	return FALSE;
}

void	SendStartMuxInitPacket(void)
{
	ReqType	RequestStruct;

	RequestStruct.Ptype = MUX_INITIALIZATION_START;
	RequestStruct.ReqType = 0;
	RequestStruct.ReqSubType = 0;
	RequestStruct.Dmy0 = 0;

	snd_packet ((LPSTR) &RequestStruct, sizeof(RequestStruct));
}

void	SendMuxResetCommand(void)
{
	int err;

  	err = WriteComm (*LineHdlPtr, XmitResetSequence, XmitResetSequenceLength);
  	if(err != XmitResetSequenceLength)	
  		MessageBox(hTermWnd, "Error writing COM port", "Firewall",
				MB_OK | MB_ICONEXCLAMATION);
}


void SendStartWanTalkPacket (int PortNumber)
{

	ReqType RequestStruct ;

	RequestStruct.Ptype = SMC_WAN_CHAT_START ;
	RequestStruct.ReqType = 0 ;
	RequestStruct.ReqSubType = PortNumber ;
	RequestStruct.Dmy0 = 0 ;

	snd_packet ((LPSTR) &RequestStruct, sizeof(RequestStruct));
}

void SendSetDTRPacket (BOOL Set)
{
	ReqType RequestStruct ; 

	RequestStruct.Ptype = SET_WAN_DTR_SIGNAL_STATE ;
	RequestStruct.ReqType = 0 ;
	RequestStruct.ReqSubType = (BYTE) Set ;
	RequestStruct.Dmy0 = 0 ;

	snd_packet ((LPSTR) &RequestStruct, sizeof (RequestStruct)) ;
}

static unsigned int crctab[] = 
{ 0x0000,  0x1189,  0x2312,  0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 
0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 
0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e, 
0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 
0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 
0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 
0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c, 
0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 
0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 
0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3, 
0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a, 
0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 
0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 
0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1, 
0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 
0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 
0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 
0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff, 
0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 
0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 
0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5, 
0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd, 
0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 
0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 
0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3, 
0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 
0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 
0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 
0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1, 
0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 
0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 
0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78};

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 0xFF)] ^ (crc << 8) ^ ((cp) & 0xFF))

BYTE CommandPacket[100] ;
int Pindex ;
COMSTAT lpStat ;

// -------------------------------------------------------------------------
// Function				:	fill
// Arguments         :	ch (BYTE).
// Synopsis          :	Quote the special character. And fill in the packet.
// Returns           :	None.
// Globals Affected  :	CommandPacket[] , Pindex.
// -------------------------------------------------------------------------
void fill(BYTE ch)
{
	switch((BYTE) ch)
	{ 
		case (BYTE)0x7e : /*-----ch='~'-----*/
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x5e;
			break;
		case (BYTE)0x7d : 
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x5d;
			break;
		case (BYTE)0x13 : 
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x33;
			break;
		case (BYTE)0x11 : 
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x31;
			break;
		case (BYTE)0x93 : 
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x93^0x20;
			break;
		case (BYTE)0x91 : 
			CommandPacket[Pindex++] = (BYTE)0x7d;
			CommandPacket[Pindex++] = (BYTE)0x91^0x20;
			break;
		default          :
			CommandPacket[Pindex++] = (BYTE)ch;
			break;
	}
}
// -------------------------------------------------------------------------
// Function				:	snd_packet
// Arguments         :	packet to be sent, its size.
// Synopsis          :	Sends a packet with BridgeID.
// Returns           :	None.
// Globals Affected  :	CommandPacket[] , Pindex.
// -------------------------------------------------------------------------
void snd_packet (BYTE *pkt_data, int pkt_size)
{
	int j, err, crc ;

   Pindex = 0 ;
   crc = 0xffff ;
   CommandPacket[Pindex++] = (BYTE) 0x7e ;
   for (j = 0 ; j < 4 ; j ++) 
	{
      fill (0) ;
	  	crc = updcrc (0, crc) ;
   }                               

   j = 0 ;
   while (j < pkt_size) 
	{
      fill (pkt_data[j]) ;
      crc = updcrc (pkt_data[j], crc) ;
      j ++ ;
   }
   crc = updcrc (0, updcrc (0, crc)) ;
   fill ((BYTE) ((crc >> 8) & 0xff)) ; /*---send Ist BYTE of crc----*/
   fill ((BYTE) (crc & 0xff)) ;        /*---send IInd BYTE of crc---*/  
   CommandPacket[Pindex++] = (BYTE) 0x7e ;							  /*---send quote character----*/
  		
/*  	GetCommError(*LineHdlPtr,lpStat);
  	while (lpStat == NULL)
  		GetCommError (*LineHdlPtr, idComDev, lpStat) ;
	while((lpStat->cbOutQue) != 0) 
	{
		GetCommError (*LineHdlPtr, idComDev, lpStat) ;
		while (lpStat == NULL)
	      GetCommError(*LineHdlPtr, idComDev, lpStat);
	}
*/
  	err = WriteComm(*LineHdlPtr, CommandPacket, Pindex);
  	if(err != Pindex)	
  		MessageBox(hTermWnd, "Error writing COM port", "Firewall",
				MB_OK | MB_ICONEXCLAMATION);
} 

void	WarmRebootRouter(void)
{
	if (!IsPortIP)
	{
		RebootType RebootPkt;
		RebootPkt.Ptype = (BYTE)REBOOT_TYPE;		//  22;
		RebootPkt.BootType = WARM_BOOT_MODE;      // System WARM Reboot

		snd_packet ((LPSTR) &RebootPkt, sizeof(RebootPkt));
	}
	else
	{
		SendMessage (hConfigWnd, WM_TERM_CLOSE, NULL, NULL) ;
	}
}

/**************************   Last  Line   ********************************/
