?PLM=0
memM	EQU	1
include cmacros.inc

EXTRN	__0040h:abs		;selector for BIOS data area.

time    struc
        hour	dw  ?
        minute	dw  ?
        second	dw  ?
time    ends

date    struc
        year	dw  ?
        month	dw  ?
        day	dw  ?
date    ends

assumes CS,CODE
assumes DS,DATA

sBegin   CODE

cProc   GetTime, <PUBLIC, FAR>
        parmW   pTime               ; pointer to the structure to fill
cBegin
        mov     ax, 2c00h           ; get time
        int     21h
        mov     bx, pTime
        xor     ax, ax
        mov     al, ch
        mov     [bx].hour, ax
        mov     al, cl
        mov     [bx].minute, ax
        mov     al, dh
        mov     [bx].second, ax
cEnd

cProc   GetDate, <PUBLIC, FAR>
        parmW   pDate               ; pointer to the structure to fill
cBegin
        mov     ax, 2a00h           ; get date
        int     21h
        mov     bx, pDate
        mov     [bx].year, cx
	xor	ax, ax
        mov     al, dh
        mov     [bx].month, ax
        mov     al, dl
        mov     [bx].day, ax
cEnd

cProc   MemCopyFarNear, <PUBLIC, FAR>
	parmD	lpSrc		; far pointer to the source
    parmW   pDest		; near pointer to the destination
	parmW	Count		; number of bytes to transfer
cBegin
	push	si
	push	di
	push	es
	push	ds
	mov	di, pDest		; dest buf offset
	mov	ax, ds			; dest buf segment
	mov	es, ax			; es:di destination
	mov	si, WORD PTR [lpSrc]	; src buf offset
	mov	ax, WORD PTR [lpSrc+2]	; src buf segment
	mov	ds, ax			; ds:si the source
	mov	cx, Count		; packet size
	cld
	rep	movsb
	pop	ds
	pop	es
	pop	di
	pop	si
cEnd

cProc   MemCopyNearFar, <PUBLIC, FAR>
	parmW	pSrc		; near pointer to the source
    parmD   lpDest		; far pointer to the destination
	parmW	Count		; number of bytes to transfer
cBegin
	push	si
	push	di
	push	es
	mov	di, WORD PTR [lpDest]	; dest buf offset
	mov	ax, WORD PTR [lpDest+2]	; dest buf segment
	mov	es, ax			; es:di destination
	mov	si, pSrc		; src buf offset
						; ds:si source
	mov	cx, Count		; packet size
	cld
	rep	movsb
	pop	es
	pop	di
	pop	si
cEnd

cProc   GetKbdLeds, <PUBLIC, FAR>
cBegin
	push	es
	mov	ax, __0040h
	mov	es, ax
	mov	bx, 17h
	xor	ax, ax
	mov	al, BYTE PTR es:[bx]
	pop	es
cEnd

cProc   SetKbdLeds, <PUBLIC, FAR>
	parmB	NewStatus
cBegin
	push	es
	mov	ax, __0040h
	mov	es, ax
	mov	bx, 17h
	mov	al, NewStatus
	mov	BYTE PTR es:[bx], al
	pop	es
cEnd

cProc	GetComMdmStatus, <PUBLIC, FAR>
	parmW	ComIndex
cBegin
	push	es
	mov	ax, __0040h
	mov	es, ax
	mov	bx, ComIndex
	shl	bx, 1
	mov	dx, WORD PTR es:[bx]
	add	dx, 6
	xor	ax, ax
	in	al, dx
	pop	es
cEnd

sEnd	CODE
        END
