/*----------------------------------------------------------------------------
*	File		:	WSTDIO.H
*	Purpose		:	Constants and prototypes for WSTDIO.C
*	Package		:	MultiExpress (Windows) - Version 2.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

#define	RIGHT_MARGIN	0	//2			/* device units margin at right */
#define	BOTTOM_MARGIN	0	//2			/* device units margin at bottom */
#define	XSHIFT_QUANTUM	5			/* Shift a minimum of 5 char in X dir */
#define		DEF_LINES_IN_SCREEN		25
#define		DEF_CHARS_IN_LINE		80


extern	BYTE	LinesInScreen;		/* Number of lines per screen */
extern	BYTE	CharsInLine;		/* Number of chars in a line */
extern	BYTE	CellsInLine;		/* Space for a NULL also */
extern	BYTE	MaxClmIndx;			/* Maximum Screen column  (max nCurX val) */
extern	BYTE	MaxRowIndx;			/* Maximum Screen row (max nCurY val) */
extern	BYTE	FollowCursor;		/* We need to reposition the window */
extern	RECT	TermWindow;			/* The actual window area we use */

extern	BYTE	WinOrgX; 	/*	Origin of display window wrt sDispBuffer */
extern	BYTE	WinOrgY; 	/* Changes when the user scrolls the display */
extern	BYTE	RowsInWin;	/* Changes when resizing occurs or a differnt */
extern	BYTE	ClmsInWin;	/* font is selected	*/

extern	BYTE	AutoMargin;				/* Wrap at EOL if true */
extern	BYTE	BackSpace;				/* Backspace flag */
extern	BYTE	BackSpaceChar;			/* Backspace char new value */
extern	BYTE	WrapBackSpace;			/* Wrap on back space if in first column */


extern	char	*sScreenBuff;	/* Circular Array of characters on TTY */
										/* remains fixed after the memory allocation */
extern	char	*sAttribBuff;	/* attributes buffer */
extern	char	*sScreenBuffLast;	/* end of Circular Array of characters on TTY */
										/* remains fixed after the memory allocation */
extern	WORD	ScrnBufSize;		/* = CellsInLine * LinesInScreen */
extern	char	*sDispOrig;		/* Current Display origin */
										/* this keeps changing as the screen scrolls */
extern	BYTE	nCurX;			/* Current cursor position wrt DispOrig */
extern	BYTE	nCurY;
extern	HDC		hTermDC;		/* Terminal display context */
extern	char	BlankLine[];
extern	BOOL	InFocus;

extern	DWORD	StdiobkRGB;						/* background color */
extern	DWORD	StdiotextRGB;					/* text color */
extern	short nStdioCharWidth;
extern	short nStdioCharHeight; 	/* width and height of Stdio font chars */
extern	BYTE	LineStatus;

extern	BYTE	CurAttrib;			/* Current attributes */
extern	BYTE	NormAttrib;			/* Normal terminal attributes */



extern	BOOL 	stdioInit(HANDLE);
extern	HWND 	wopen(HWND,BOOL);
extern	HWND 	CreateStdioWindow(LPSTR,DWORD,int,int,int,int,HWND,HANDLE,BOOL);
extern	BOOL 	wputs(LPSTR);
extern	long 	FAR PASCAL StdioWndProc(HWND,unsigned,WORD,LONG);
extern	void	SetupWinMatrix (void);
extern	void	SetupStdioDC(void);
extern	char	*GetStdioLine(short indx);
extern	char	*GetNextRowPtr (char *disptr);
extern	int		InitTermParams(BYTE nlines, BYTE nchars);
extern	void 	InitStdio(HWND hWnd);
extern	void	CharOutWin(BYTE ch);
extern	int		CursorVisible(void);
extern	void	AdjustWin(void);
extern	int		ScrollLeft(BYTE count);
extern	int		ScrollRight(BYTE count);
extern	int		ScrollUp(BYTE count);
extern	int		ScrollDown(BYTE count);
extern	void	MoveWinOrg(BYTE new_x, BYTE new_y);
extern	void	ScrollX (WORD sb_type, BYTE scrl_pos);
extern	void	ScrollY (WORD sb_type, BYTE scrl_pos);


