
#include <stdio.h>  
#include <conio.h>
#include "ui.h"  	  									
#include "mem.h"
#include "uicons.h"			
#include "tst.h"
#include "uart.h"
#include "uierr.h"


#define header_ "main menu"
#define HELP_FILE "xblcon.hlp"
#define HELP_HDER "HELP"
ReadLocReqType mem_dt_req_type;
// int no_of_bridges=2;   
int on_brd_info(int);
int passwd_win_id;   /*---holds password win id number-----*/
int chng_flag=0;	
int cms_exit=0;
byte *com_str;			/*----holds the port number as a string --*/
byte *sv_str;			/*----holds the message to be displayed---*/

extern int save_flag; 
extern byte current_pkt;
extern word ltl_endian_word(word);
extern window_blank(win_data *, byte, byte);
extern int ActiveWinId;
extern bool *endinput_ptr;
extern int com1;
extern int DOWN_LOAD;


extern win_attb WinAttbs[];
extern void clear_uart_buff();
extern byte SHOW_CLK_TICKS;
extern win_data help_win;
extern int time_ticks, time_on, QUIT, TOTAL_TIME_TICKS;
extern int on_dnld(int);

byte menu_fld_attb[]={0x0f, 0x07, 0x0f, 0x07}; /*---holds the attribute bytes for menus---*/
byte atts[4]={0x1f, 0x17, 0x0f, 0x0f};

void exit_win(menu_data *);
int on_brd_select(int);

extern int on_modem_info(int);
extern void set_timer();
extern void InitHelpLib(byte *, byte *, void (*)(int));

void on_help(void);
int on_exit(void);

int exit_flag=0;/*---indicates whether the user has selected 'Yes' or 'No' option---*/

void dummy_help_err(int i)
  {
     i++;
	  error_win((byte *)"help error", 25, 10, 28);
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : color_crt																	 */
/* PURPOSE       : To determine the video adapter card								 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : returns 1 for color monitor 0 otherwise.							 */
/*-----------------------------------------------------------------------------*/
int color_crt()
   {
	  int i=0;
	  _asm
	     {
		      mov ah, 0fh
			   int 10h
			   cmp al, 7h
			   je  MONO     ; monochrome 
		      mov i, 1		 ; color monitor
		 MONO :
			}
	  return(i);
	}
/*-----------------------------------------------------------------------------*/


int on_dummy_return(int i)
  { 
    return(i);
  }

int on_dummy_exit(void)
   {
	   return(OK);
	}

int status_win(byte *err_msg, int x, int y, int msg_x)
   {
     win_data *err_win;
	  int xy;
	  int err_win_id;
	  xy=(((y+1) << 8) | msg_x);  /*--put msg_x & y in one word --*/

	  err_win=(win_data *)GetMem(sizeof(win_data));
	  init_win(err_win, (byte)x, (byte)y, 4, 30, (void *)0,  MSG_TYPE, 1, 1, on_dummy_exit, 
	               (void *)0, (void *)0, (void *)0);
	  err_win_id=create_win(err_win);
	  realise_win(err_win_id);
	  draw_window(err_win_id, 0x1f);
	  display_string((byte *)err_msg, xy, 0x1f, (void *)0);
	  return(err_win_id);
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : error_win(err_msg, x, y, msg_x)										 */
/* PURPOSE       : To create an error message window and to display message.	 */
/* PARAMETER     : err_msg																		 */
/*                   -pointer to array of bytes											 */
/*                   -points to the message to be displayed							 */
/*                 x																				 */
/*               	   -integer																	 */
/*                   -holds x co-ordinate of the window								 */
/*                 y																				 */
/*                   -integer																	 */
/*                   -holds y co-ordinate of the window								 */
/*                 msg_x																		 */
/*                   -integer																	 */
/*                   -holds x co-ordinate of the message on the screen			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void error_win(byte *err_msg, int x, int y, int msg_x)
  {
     win_data *err_win;
	  int xy;
	  int err_win_id;

	  err_win=(win_data *)GetMem(sizeof(win_data));
	  /*------initialise MSG_TYPE window--------*/
	  init_win(err_win, (byte)x, (byte)y, (byte)4, (byte)30, (byte *)"Error", MSG_TYPE, (byte)1, 
	             (byte)0, on_dummy_exit, (void *)0, (void *)0, (void *)0);
	  err_win_id=create_win(err_win);
	  realise_win(err_win_id);
	  xy=(((y+1) << 8) | msg_x);	 /*----put y & msg_x in one word---*/
	  draw_window(err_win_id, 0x20);
	  /*------display the given message-------*/
 	  display_string((byte *)err_msg, xy, 0x21, (void *)0);  
	  getch();
	  destroy_win(err_win_id);
	  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_com(i)																	 */
/* PURPOSE       : This is a call back function invoked on Return key. This 	 */
/*                  function sets 'com1' to appropriate base address.			 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/*                  -holds the port number												 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_com(int i)
  {
	 QUIT=0;
    com_str[my_strlen(com_str)-1]=(char)(i+0x30);/*----Change com_str----*/
	 reset_uart();
	 switch (i)
	   {
		  case 1 : com1=0x3f8;   /*---com port 1----*/
		           break;
		  case 2 : com1=0x2f8;	 /*---com port 2----*/
		           break;
		  case 3 : com1=0x3e8;	 /*---com port 3----*/
		           break;
		  case 4 : com1=0x2e8;	 /*---com port 4----*/
					  break;
	  }
	restore_timer();
	set_timer();
	init_uart();	 /*---initialise UART-----*/
	cms_exit=1;
   return(-1);
 }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_coms_exit																 */
/* PURPOSE       : This is a call back function invoked on Esc key.				 */
/* RETURN VALUE  : returns OK																	 */
/*-----------------------------------------------------------------------------*/
int on_coms_exit(void)
   {
	  return(OK);
	}
/*-----------------------------------------------------------------------------*/

int on_retry(int i)
  {
    i++;
	 QUIT=0;
	 return(-1);
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_change_prt(int i)													 */
/* PURPOSE       : To create a menu for changing port									 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_chng_prt(int i)
   {
		
	   win_data *coms_win;
		menu_data *coms_menu;
		byte *coms_opts[]={
		                    (byte *)"\177Com\177 1",
								  (byte *)"\177Com\177 2",
								  (byte *)"\177Com\177 3",
								  (byte *)"\177Com\177 4"
								};
		byte *com_atts[]={&menu_fld_attb[1],&menu_fld_attb[1], &menu_fld_attb[1], &menu_fld_attb[1], &menu_fld_attb[1]};
		int (*com_menu_fns[])(int)={on_com, on_com, on_com, on_com};
		/*------initialise the menu fields with attributes for each menu item----*/
	   coms_menu=menu_field_init(coms_opts, com_atts, (char *)"1234", com_menu_fns, 4);
	   coms_win=(win_data *)GetMem(sizeof(win_data));
	   init_win(coms_win, 20, 10, 6, 30, (byte *)"Select Port", MENU_TYPE, 1, 4, on_coms_exit, (void *)0,
	         (void *)0, (void *)0);
	   coms_win->addnl_info=(void *)coms_menu;
	   realise_win(create_win(coms_win));
	   ReleaseMem((byte *)coms_win);
	   ReleaseMem((byte *)coms_menu);
		if (cms_exit) 
		  return(-1);  /*----exit previous menu-----*/
		else
		  return(NOT_OK);  /*---retain previous menu----*/
	}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME: snd_mdm_cmd(str)															 */
/* PURPOSE      : To issue command to modem												 */
/*	PARAMETER    : str																			 */
/*                  -pointer to an array of bytes										 */
/* RETURN VALUE : NONE																			 */
/*-----------------------------------------------------------------------------*/
void snd_mdm_cmd(byte *str)
  {
	  int i=0;
     while (str[i])			 /*---while not end of command--*/
	    {
		   snd_char(str[i]);  /*----send one byte------------*/
			i++;
		 }
	  snd_char((byte)13);	 /*---send command terminator---*/
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_mdm_resp()															 */
/* PURPOSE       : To receive commands from modem										 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : returns a pointer to modem command									 */
/*-----------------------------------------------------------------------------*/
byte * rcv_mdm_resp()
	{
	  int i=0;
	  byte *str;
	  str=(byte *)GetMem(sizeof(byte)*35);
	  time_on=1;
	  SHOW_CLK_TICKS=(byte)0;
	  TOTAL_TIME_TICKS=550;
	  str[0]=0;
	  while (rcv_char()!=(byte)13) /*-----read CR------*/
		  {
		    time_on=1;
			 if (time_ticks > TOTAL_TIME_TICKS)
			   break;
			 if (_kbhit())
				{
				  time_on=0;
				  getch();
			     my_strcpy(str, (byte *)"Aborted");
				  return(str);
				}
		  }
	  time_on=0;
	  if (time_ticks < TOTAL_TIME_TICKS)
	    {
	       str[i]=rcv_char();						  /*-----read LF------*/
	       while (str[i]!=(byte)13)
		      {
		        i++;
			     str[i]=rcv_char();
		      }
	       rcv_char();	 /*-----read LF----*/
	       str[i]=0;
	       i=0;
	       while (str[i])
	         {
		         str[i]=str[i+1];
			      i++;
		      }
	       str[i-1]=0;  
		 }
	  return(str);
	}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_mdm_cmd(i, dw)														 */
/* PURPOSE       : This is a call back function invoked to validate modem 		 */
/*                   command issued by the user 										 */
/* PARAMETER     : i																				 */
/*                   -integer																	 */
/*                 dw																			 */
/*                   -double word															 */
/*                   -points to user command												 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_mdm_cmd(int i, dword dw)
    {
		 byte *cmd_str;
		 byte at_str[50];
		 byte *resp_str;
		 i++;
		 if (i==3)
		   my_strcpy((byte *)at_str, (byte *)"atdp#");	/*---pulse dialing---*/
		 else
		   my_strcpy((byte *)at_str, (byte *)"atdt#");	/*---Tone dialing----*/
		 cmd_str=far_to_near(dw);
		 my_strcat(at_str, cmd_str);
/*		 if ((cmd_str[0]=='a' || cmd_str[0]=='A') && (cmd_str[1]=='t' || cmd_str[1]=='T')) */
			 { /*---valid modem command-----*/
		      snd_mdm_cmd(at_str);	/*----send modem command-----*/
		      resp_str=rcv_mdm_resp();/*----receive modem command----*/
				display_string((byte *)"                 ", 0xd2c, 0x1f, (void *)0);
				if (resp_str[0])
		         display_string((byte *)resp_str, 0xd2d, 0x1f, (void *)0);
				else
				   display_string((byte *)"No Response", 0xd2c, 0x1f, (void *)0);
		      ReleaseMem((byte *)cmd_str);
		      ReleaseMem((byte *)resp_str);
			 }
/*		 else
		    display_string((byte *)"invalid command", 0xd2c, 0x1f, (void *)0); */
	    return(REFRESH);
	 }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_dial(i)																	 */
/* PURPOSE       : This is a call back function invoked on selecting 'Dial' 	 */
/*                  option from the menu.													 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_dial(int i) 
  {
	 form_data *dial_form;
	 win_data *dial_win;
	 int dial_win_id;
	 byte *address_str, *length_str;
	 dial_form=(form_data *)GetMem(sizeof(form_data)*2);
	 dial_win=(win_data *)GetMem(sizeof(win_data));
	 address_str=(byte *)GetMem(sizeof(byte)*60);
	 length_str=(byte *)GetMem(sizeof(byte)*20);
	 /*-------initialise the form_data structure-----*/
	 init_form_data(&dial_form[0], 2, 1, (byte *)"Phone Number  ",  STRING_TYPE, 41, 15,
						 ALL, on_mdm_cmd, 1, 0, address_str);
	 init_form_data(&dial_form[1], 2, 3, (byte *)"Modem Response",  STRING_TYPE, 3, 25,
	                ALL, (void *)0, 1, 2, length_str);
	 init_win(dial_win, 25, 10, 4, 10, (byte *)"Dialing", FORM_TYPE, 1, 2, 
				 on_dummy_exit, (void *)0, (void *)0, (void *)0);
	 dial_win->addnl_info=(void *)dial_form;
	 dial_win_id=create_win(dial_win);
	 init_uart();
	 snd_mdm_cmd((byte *)"ate0v1");
	 realise_win(dial_win_id);
	 ReleaseMem((byte *)address_str);
	 ReleaseMem((byte *)length_str);
	 ReleaseMem((byte *)dial_form);
	 ReleaseMem((byte *)dial_win);
    i++;
	 return(OK);
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : no_target																	 */
/* PURPOSE       : To create a menu which will allow the user to change port,  */
/*                 Retry or Dial.															 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void no_target()
  {
	win_data *no_trgt_win;
	menu_data *no_trgt_menu;
	byte *no_trgt_opts[]={
									(byte *)"\177C\177hange Ports",
									(byte *)"\177R\177etry       ",
									(byte *)"\177P\177ulse Dial  ",
									(byte *)"\177T\177one Dial   "
								};
  int (*no_trgt_fns[])(int)={on_chng_prt, on_retry, on_dial, on_dial};
  byte *trgt_atts[]={menu_fld_attb, menu_fld_attb, menu_fld_attb, menu_fld_attb};
  /*---initialise the menu fields of the menu------*/
  no_trgt_menu=menu_field_init(no_trgt_opts, trgt_atts, (char *)"crpt", no_trgt_fns, 4);
  no_trgt_win=(win_data *)GetMem(sizeof(win_data));
  init_win(no_trgt_win, 10, 8, 5, 30, (byte *)"Connect", MENU_TYPE, 1, 4, on_exit, (void *)0, 
           (void *)0, connect_help);
  no_trgt_win->addnl_info=(void *)no_trgt_menu;
  realise_win(create_win(no_trgt_win));
  ReleaseMem((byte *)no_trgt_win);
  ReleaseMem((byte *)no_trgt_menu);
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : display_err(err_msg)													 */
/* PURPOSE       : To display an error message											 */
/* PARAMETER     : err_msg																		 */
/*                   -pointer an array of bytes											 */
/*                   -points to error message to be displayed						 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void display_err(byte *err_msg)
  {
     int error_id;
	  int help_win_id;
	  win_data error_win={26, 10, 30, 5, MSG_TYPE, (byte *)"Error", 0};
	  help_win_id=create_win(&help_win);
	  realise_win(help_win_id);

     error_id=create_win(&error_win);
	  realise_win(error_id);
	  draw_window(error_id, 0x1f);
     display_string((byte *)err_msg, 0x0b1d, 0x8f, (void *)0);
	  display_string((byte *)"Press any key to continue", 0x0d1d, 0x0f, (void *)0);
	  get_key();
	  destroy_win(error_id);
	  destroy_win(help_win_id);
	}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_yes(i)																	 */
/* PURPOSE       : This is a call back function invoked on RETURN key. This 	 */
/*                  function sets 'exit_flag' to 1.									 */
/* PARAMETER     : i																				 */
/*                   -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_yes(int i)
    {
	    i++;
		 exit_flag=1;   /*---indicate that user has selected 'Yes' option----*/
		 return(-1);
	 }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_no(i)																	 */
/* PURPOSE       : This is a call back function invoked on RETURN key.      	 */
/* PARAMETER     : i																				 */
/*                   -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_no(int i)
   {
	   i++;
		return(-1);
	}
/*-----------------------------------------------------------------------------*/


int on_esc(void)
   {
	  return(OK);
	}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_exit()																	 */
/* PURPOSE       : To create a menu and to set exit_flag appropriately			 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_exit(void)
     {
		 byte *exit_options[]=
		                 {
							     (byte *)("\177Y\177es"),
								  (byte *)("\177N\177o "),
							  };
		 byte *exit_attbs[]=
		                 {
							    menu_fld_attb,
								 menu_fld_attb,
								 menu_fld_attb
							  };
		 char *exit_keys=(char *)"YN";
		 int (*exit_fn_ptrs[])(int)=
		                         {
										   on_yes,
											on_no
										  };
		 menu_data *exit_menu;
		 /*---initialise the menu fields of the menu----*/
		 exit_menu=menu_field_init(exit_options, exit_attbs, exit_keys, exit_fn_ptrs, 2);
		 exit_win(exit_menu);	/*---realise the menu----*/
		 ReleaseMem((byte *)exit_menu);
		 if (exit_flag)
		   { /*----user has selected 'Yes' option-----*/
			  exit_flag=0;
		     return(OK);
			 }
		 else	 /*----user has selected 'No' option-----*/
		    return(NOT_OK);
	  }
/*-----------------------------------------------------------------------------*/


void on_help(void)
   {
	 /*  HelpHndlr(0, 0);
	  HelpHndlr(0, 1);
	  HelpHndlr(0, 2);
	  HelpHndlr(0, 3);
	  HelpHndlr(0, 4);
	  HelpHndlr(0, 5);
	  HelpHndlr(0, 6);
	  HelpHndlr(0, 7);
	  HelpHndlr(0, 8);
	  HelpHndlr(0, 9);
	  HelpHndlr(0, 10);
	  HelpHndlr(0, 11);
	  HelpHndlr(0, 12);
	  HelpHndlr(0, 13);
	  HelpHndlr(0, 14);
	  HelpHndlr(0, 15);
	  HelpHndlr(0, 16); */
	  ;
	}

void BridgeForeground(void)
  {
   ;
  }

int correct_password(byte *user, byte *passwd)
   {
	   return(!my_strcmp(user, passwd));
	}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : passwd_valid(i, dw)														 */
/* PURPOSE       : This is a call back function invoked on  RETURN key. This 	 */
/*                     function quits the FORM_TYPE window.							 */
/*	PARAMETER     : i	(not used)																 */
/*                   -integer																	 */
/*                 dw (not used)																 */
/*                   -double word															 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int passwd_valid(int i, dword dw)
  {
     i++;
	  i--;
	  dw++;					 
	  *endinput_ptr=TRUE;  /*----This will quit the FORM_TYPE window----*/			
	  chng_flag=1;
	  return(OK);
  }
/*-----------------------------------------------------------------------------*/


int on_passwd_exit(void)
  {
    return(OK);
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : wrong_passwd()															 */
/* PURPOSE       : 																				 */
/*-----------------------------------------------------------------------------*/
void wrong_passwd()
  {
    win_data *wrong_passwd_win;
	 int passwd_id;

	 wrong_passwd_win=(win_data *)GetMem(sizeof(win_data));
	 init_win(wrong_passwd_win, 15, 15, 5, 36, (void *)0, MSG_TYPE, 1, 0, on_passwd_exit, 
	          (void *)0, (void *)0, (void *)0);
	 passwd_id=create_win(wrong_passwd_win);
	 realise_win(passwd_id);
	 draw_window(passwd_id, 0x17);
	 display_string((byte *)"Invalid Password - Access Denied !", 0x1010, 0x9f, (void *)0);
	 display_string((byte *)"Press any key to quit ", 0x1215, 0x17, (void *)0);
	 get_key();
	 destroy_win(passwd_id);
	 ReleaseMem((byte *)wrong_passwd_win);
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : passwd_win()																 */
/* PURPOSE       : To create FORM_TYPE window for accepting password				 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : returns a pointer to an array of bytes							 */
/*-----------------------------------------------------------------------------*/
byte * passwd_win()
  {
     win_data *pass_win;
	  form_data *pass_form;
	  byte *usr_passwd;

	  pass_form=(form_data *)GetMem(sizeof(form_data));
	  pass_win=(win_data *)GetMem(sizeof(win_data));
	  usr_passwd=(byte *)GetMem(sizeof(byte)*12);

	  usr_passwd[0]='\0';
	  /*------initialise the form field with attributes-------*/
	  init_form_data(pass_form, 2, 1, (byte *)"Enter Password ", STRING_TYPE, 10, 10, ALL, passwd_valid, 0, 0, usr_passwd);
	  init_win(pass_win, 10, 10, 0, 0, (void *)0, FORM_TYPE, 1, 1, on_passwd_exit, 
	          (void *)0, (void *)0, (void *)0);
	  pass_win->addnl_info=(void *)pass_form;
	  passwd_win_id=create_win(pass_win);
	  realise_win(passwd_win_id);
	  if (chng_flag)
	     {
	       destroy_win(passwd_win_id);
			 chng_flag=0;
		  }
	  return(usr_passwd);  /*----return the password------*/
  }
/*-----------------------------------------------------------------------------*/

int on_rbt_exit(void)
  {
    return(OK);
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : mem_addr_valid(i, dw)													 */
/* PURPOSE       : This is a call back function invoked to validate the address*/
/*                  field of the form.															 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/*                 dw																			 */
/*                  -double word																 */
/*                  -holds the pointer to length string								 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int mem_addr_valid(int i, dword dw)
   {
	  dword mem_addr;
	  byte *str;
	  str=far_to_near(dw);
	  mem_addr=str2h(str, 0x10); 
	  mem_dt_req_type.Address=little_endian(mem_addr);
	  return(OK);
	}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : length_valid(i, dw)														 */
/* PURPOSE       : This is a call back function invoked to validate the length */
/*                  field of form.															 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/*                 dw																			 */
/*                  -double word																 */
/*                  -holds the pointer to length string								 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int length_valid(int i, dword dw)
   {
	  byte mem_length;
	  byte *str;
	  str=far_to_near(dw);
	  mem_length=(byte)str2h(str, 10);
	  mem_dt_req_type.Length=(byte)mem_length;
	  my_strcpy(sv_str, (byte *)"View Memory ?");
	  save_flag=0;
	  /*---check if address is evenly aligned-----*/
	  if ((little_endian(mem_dt_req_type.Address) % 2) && (mem_length!=1))
		   error_win((byte *)"Address is not even aligned", 25, 14, 27);
	  else
		 {
			  if (mem_length)  /*----is length > 0?------*/
				 {	/*-----length is > 0-----*/
	            cnfrm_sv();	  /*---get confirmed from the user----*/
	            if (save_flag)
		           {  /*----confirmed----*/
	                *endinput_ptr=TRUE;
		             chng_flag=1;
		           }
				 }
		  }
	  return(OK);
	}
/*-----------------------------------------------------------------------------*/

	    
/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : trgt_mem(i)																 */
/* PURPOSE       : To creat a FORM_TYPE menu to accept memory address and      */
/*                  length.																	 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int trgt_mem(int i)
  {
	 form_data *mem_form;
	 menu_data *mem_list;
	 byte wrd_cnt=(byte)0;
	 int ln_cnt=0;
	 ReadLocRespType mem_dt_type;
	 win_data *mem_win, *mem_dt_win;
	 int mem_win_id;
	 byte *address_str, *length_str;
	 mem_form=(form_data *)GetMem(sizeof(form_data)*2);
	 mem_win=(win_data *)GetMem(sizeof(win_data));
	 address_str=(byte *)GetMem(sizeof(byte)*30);
	 length_str=(byte *)GetMem(sizeof(byte)*20);
	 /*-----initialise the fields of form----------*/
	 init_form_data(&mem_form[0], 2, 1, (byte *)"Address (Hex)",  STRING_TYPE, 8, 8,
						 NUMERIC_HEX, mem_addr_valid, 1, 0, address_str);
	 init_form_data(&mem_form[1], 2, 3, (byte *)"Length (Dec) ",  STRING_TYPE, 3, 3,
	                NUMERIC, length_valid, 1, 0, length_str);
	 init_win(mem_win, 25, 10, 4, 10, (byte *)"View Target Memory", FORM_TYPE, 1, 2, 
				 on_dummy_exit, (void *)0, (void *)0, view_memory_help);
	 mem_win->addnl_info=(void *)mem_form;
	 chng_flag=0;
	 mem_win_id=create_win(mem_win);
	 realise_win(mem_win_id);
	 if (chng_flag)
	   { /*--------view target memory------*/
		  destroy_win(mem_win_id);
		  DOWN_LOAD=1;
		  time_on=1;
		  TOTAL_TIME_TICKS=55;
		  mem_dt_req_type.Ptype=READ_REQ_TYPE;
		  /*----send the packet to target------*/
		  snd_packet((byte *)&mem_dt_req_type, sizeof(mem_dt_req_type));
		  rcv_dnld_packet((byte *)&mem_dt_type, sizeof(mem_dt_type));
		  if (time_ticks > 55)
		    error_win((byte *)"No response from Target", 15, 10, 17);
		  else
		    {	/*---response from the target------*/
				ln_cnt=0;
				if (mem_dt_type.Ptype!=RES_TYPE)
				  {
					 if (mem_dt_type.ErrCode==(byte)0)
						{
				        mem_list=(menu_data *)GetMem(sizeof(menu_data)*(mem_dt_type.Length/10+1));
						  /*-----initialise the menu fields------*/
				        while ((int)wrd_cnt < (int)mem_dt_type.Length)
				          {
				             mem_list[ln_cnt].string=(byte *)GetMem(sizeof(byte)*70);
					          sprintf((char *)mem_list[ln_cnt].string, "%08lx:   %02x%02x %02x%02x %02x%02x %02x%02x %02x%02x %02x%02x %02x%02x %02x%02x", 
																  little_endian(mem_dt_req_type.Address)+(int)wrd_cnt,
 																  mem_dt_type.buffer[wrd_cnt % 128],
 																  mem_dt_type.buffer[(wrd_cnt+1)  % 128],
																  mem_dt_type.buffer[(wrd_cnt+2)  % 128],
 																  mem_dt_type.buffer[(wrd_cnt+3)  % 128],
																  mem_dt_type.buffer[(wrd_cnt+4)  % 128],
 																  mem_dt_type.buffer[(wrd_cnt+5) % 128],
																  mem_dt_type.buffer[(wrd_cnt+6) % 128],
 																  mem_dt_type.buffer[(wrd_cnt+7) % 128],
																  mem_dt_type.buffer[(wrd_cnt+8) % 128],
 																  mem_dt_type.buffer[(wrd_cnt+9) % 128],
																  mem_dt_type.buffer[(wrd_cnt+10) % 128],
 																  mem_dt_type.buffer[(wrd_cnt+11) % 128],
																  mem_dt_type.buffer[(wrd_cnt+12) % 128],
 																  mem_dt_type.buffer[(wrd_cnt+13) % 128],
																  mem_dt_type.buffer[(wrd_cnt+14) % 128],
 																  mem_dt_type.buffer[(wrd_cnt+15) % 128]);

					          mem_list[ln_cnt].fn_ptr=on_dummy_return;
					          mem_list[ln_cnt].attb_string=(byte *)GetMem(sizeof(byte)*3);
					          mem_list[ln_cnt].attb_string[0]=menu_fld_attb[1];
					          mem_list[ln_cnt].attb_string[1]=menu_fld_attb[0];
					          mem_list[ln_cnt].select_key=(char)'q';
					          wrd_cnt+=(byte)16;
				             ln_cnt++;
			             }
				        mem_dt_win=(win_data *)GetMem(sizeof(win_data));
				        init_win(mem_dt_win, 20, 10, 8, 40, (byte *)"Target Memory", MENU_TYPE, 1, (byte)ln_cnt, 
				            on_dummy_exit, (void *)0, (void *)0, (void *)0);
				        mem_dt_win->addnl_info=(void *)mem_list;
						  ln_cnt--;
				        if (mem_dt_type.Length % 16)
				           mem_list[ln_cnt].string[(mem_dt_type.Length % 16)*2+(mem_dt_type.Length %16)/2+12]=0;
				        realise_win(create_win(mem_dt_win));
				        ReleaseMem((byte *)mem_dt_win);
				        while (ln_cnt >=0 )
				   	    {
				             ReleaseMem((byte *)mem_list[ln_cnt].string);
				             ReleaseMem((byte *)mem_list[ln_cnt].attb_string);
						       ln_cnt--;
					       }
				        ReleaseMem((byte *)mem_list);
			         }
				    else
						{
					    	error_win((byte *)"Address Out of Range", 25, 14, 28);
						}
				  }
			  else
				  error_win((byte *)"Error ", 15, 10, 21);
			 }
		  chng_flag=0;
		}
	 ReleaseMem((byte *)mem_form);
	 ReleaseMem((byte *)mem_win);
	 ReleaseMem((byte *)address_str);
	 ReleaseMem((byte *)length_str);
    return(OK);
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_diff_pkt()																 */
/* PURPOSE       : To create a menu to allow the user to down load or to test	 */
/*                  hardware.																	 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void on_diff_pkt(void)
  {
     byte *diff_opts[]={
	                (byte *)("\177Down Load Cod\177e"),
						 (byte *)("\177Down Load Confi\177g"),
						 (byte *)("\177Target \177M\177emory"),
						 (byte *)("\177T\177est Hardware")
					  };
	                		  
	   int (*rbt_fns[])(int)={on_dnld, on_dnld, trgt_mem, on_hwtest};
	   byte *attbs[]=
		              {
						    &menu_fld_attb[1],
							 &menu_fld_attb[1],
							 &menu_fld_attb[1],
  							 menu_fld_attb
						  };
		menu_data *rbt_menu;
		win_data *rbt_win;
		ResultType restype;
		TargetCmdType rbt_pkt;
		/*----initialise the menu fields of the menu-------*/
		rbt_menu=menu_field_init(diff_opts, attbs, (char *)"EFMT", rbt_fns, 4);
		rbt_win=(win_data *)GetMem(sizeof(win_data));
		init_win(rbt_win, 15, 7, 4, 30, (byte *)"System", MENU_TYPE, 1, 4, on_rbt_exit,
		         (void *)0, (void *)0, dnld_help);
		rbt_win->addnl_info=(void *)rbt_menu;
		current_pkt=PT_UNKNOWN;
		realise_win(create_win(rbt_win));
		ReleaseMem((byte *)rbt_win);
		ReleaseMem((byte *)rbt_menu);
		if (current_pkt==PT_EOF) /*----is down load successful ?-----*/
		  { /*-----down loaded----*/
		    save_flag=0;
		    my_strcpy(sv_str, (byte *)"Reboot Target ?");
	       cnfrm_sv();  /*-----confirm Rebooting Target------*/
		    if (save_flag)
			   {	/*------Rebooting Confirmed-------*/
					rbt_pkt.TargetAction=REBOOT;
					rbt_pkt.Ptype=TRGT_CMD_TYPE;
			 	   snd_packet((byte *)&rbt_pkt, sizeof(rbt_pkt)); 
					time_on=1;
					TOTAL_TIME_TICKS=55;
			 		rcv_packet((byte *)&restype, sizeof(restype));
					if (time_ticks < 55)
					  {
			 		     if (restype.Ptype==(byte)RES_TYPE && restype.ErrorCode)
			 		       {
			 			       display_string((byte *)"restype.error", 0x1010, 0x1f, (void *)0);
			 			       printf("errorcode=%d", little_endian(restype.ErrorCode));
			 			       get_key();
			 			    }
					  }
					else
					     error_win((byte *)"No Response from Target", 15, 10, 17);
			 	 }
		  }

	}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : exit_win(menu_data_ptr)												 */
/* PURPOSE       : To create a menu.														 */
/* PARAMETER     : menu_data_ptr																 */
/*                   -pointer to an array menu_data structure.						 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void exit_win(menu_data *menu_data_ptr)
  {
    win_data *exit_win_data;
	 int exit_id;
	 exit_win_data=(win_data *)GetMem(sizeof(win_data));
	 exit_win_data->x_val=10;
	 exit_win_data->y_val=10;
	 exit_win_data->win_type=MENU_TYPE;
	 exit_win_data->win_title=(byte *)"Exit Program?";
	 exit_win_data->q_str_ptrs=(void *)0;
	 exit_win_data->no_of_entries=2;
	 exit_win_data->start_field_no=1;
	 exit_win_data->addnl_info=(void *)menu_data_ptr;
	 exit_win_data->e_fn_ptr=on_esc;
	 exit_win_data->h_fn_ptr=(void *)0;
	 exit_win_data->a_fn_ptr=(void *)0;	/* on_invalid */
	 exit_win_data->box_win=1;
	 exit_id=create_win(exit_win_data);
	 realise_win(exit_id);
	 ReleaseMem((byte *)exit_win_data);
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : main_win(menu_data_ptr)												 */
/* PURPOSE       : To create a menu.														 */
/* PARAMETER     : menu_data_ptr																 */
/*                  -pointer to an array of menu_data structure.					 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void main_win(menu_data *menu_data_ptr)
  {
    win_data *main_menu;
	 int menu_id;
	 byte *str=(byte  *)"main";
	 main_menu=(win_data *)GetMem(sizeof(win_data));
	 main_menu->x_val=6;
	 main_menu->y_val=6;
	 main_menu->win_type=MENU_TYPE;
	 main_menu->win_title=(byte *)str;
	 main_menu->box_win=1;		
	 main_menu->no_of_entries=5;
	 main_menu->addnl_info=(void *)menu_data_ptr;
	 main_menu->e_fn_ptr=on_exit;
	 main_menu->a_fn_ptr=(void *)0;   
	 main_menu->h_fn_ptr=gen_info_help;
	 main_menu->q_str_ptrs=(void *)0;
//	 main_menu->q_ascii_ptr=(void *)0;
	 main_menu->start_field_no=1;
	 menu_id=create_win(main_menu);
	 realise_win(menu_id);
	 ReleaseMem((byte *)main_menu);
 }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : copy_right()																 */
/* PURPOSE       : To create a MSG_TYPE window to show copy right message		 */
/* PARAMETER     : NONE																			 */
/*	RETURN VALUE  : returns an integer(window id).										 */
/*-----------------------------------------------------------------------------*/
int copy_right()
 {
   int crightid;
	win_data *cptr;
	cptr=(win_data *)GetMem(sizeof(win_data));
	cptr->x_val=0;
	cptr->y_val=0;
	cptr->win_height=4;
	cptr->win_width=80;
	cptr->win_type=MSG_TYPE;
	cptr->win_title=(byte *)"multi";
	cptr->q_str_ptrs=(void *)0 ;
	cptr->box_win=1;  
	crightid=create_win(cptr);
	draw_window(crightid, (byte)0x30);
	window_blank(cptr, 0x33, 32);
	display_string((byte *)"Express Bridge Configuration ver 2.00", (word)0x0102, 0x30, (byte *)0);
	display_string((byte *)"Multi-Tech Software Systems, Inc.", (word)0x0202, 0x30,  (void *)0);
	return(crightid);
 }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : brd_select_win(menu_data_ptr)										 */
/* PURPOSE       : To create menu.															 */
/* PARAMETER     : menu_data_ptr																 */
/*                   -pointer to an array of menu_data structure					 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void  brd_select_win(menu_data * menu_data_ptr)
  {
    win_data *win_data_ptr;
	 win_data_ptr=(win_data *)GetMem(sizeof(win_data));
	 /*-----initialise MENU_TYPE window--------*/
	 init_win(win_data_ptr, 5, 8, 4, 30, (byte *)"Bridges", MENU_TYPE, 1, (byte)2, on_exit, (void *)0, 
 	          (void *)0, (void *)0);
	 win_data_ptr->addnl_info=(void *)menu_data_ptr;
	 realise_win(create_win(win_data_ptr));
	 ReleaseMem((byte *)win_data_ptr);
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_rbt(i)																	 */
/* PURPOSE       : This is a call back function invoked on RETURN key. This	 */
/*                  function will send a Reboot Packet to the Target				 */
/* PARAMETER     : i																				 */
/*                   -integer																	 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
int on_rbt(int i)
   {
	  ReqType reqtype;
	  ResultType restype;
	  reqtype.Ptype=REBOOT_TYPE;
	  TOTAL_TIME_TICKS=55;
	  snd_packet((byte *)&reqtype, sizeof(reqtype));
	  time_on=1;
	  rcv_packet((byte *)&restype, sizeof(reqtype));
	  if (time_ticks < 55)
	    error_win((byte *)"Bridge is coming down", 25, 10, 28);
	  else
	    error_win((byte *)"No Response from Target", 25, 10, 28);
	  i--;
	  return(-1);
	}
/*-----------------------------------------------------------------------------*/


void main(int argc, char **argv)
  {
		 int i;
	    win_data *root_ptr;
		 byte *incor;
		 word pra;
		 win_data target_win={26, 10, 30, 7, MSG_TYPE, (void *)0, 1};
		 int rootwid=0;
		 int crightid;
		 int trgt_win_id;
		 menu_data *brd_select_menu;
		 ReqType brd_req_type;
		 PasswordPktType passwd_pkt;
		 ResultType restype;
		 byte *brd_select_opts[2];
		 byte *spr_passwd;
		 byte att[]={0x17, 0x17};
		 byte *brd_select_atts[]={att, att, att};
		 int (*brd_select_fns[])(int)={on_brd_select, on_rbt};

		 if (color_crt()) /*------is it color monitor ?-------*/
		   {	/*-----initialise WinAttb with color attributes------*/
		      WinAttbs[0].filler=0x11;
		      WinAttbs[MENU_TYPE].filler=0x11;
		      WinAttbs[MENU_TYPE].field=0x17;
		      WinAttbs[FORM_TYPE].filler=0x11;
		      WinAttbs[FORM_TYPE].string=0x17;
		      WinAttbs[FORM_TYPE].field=0x1e;
		      WinAttbs[DIR_TYPE].filler=0x11;
		      WinAttbs[DIR_TYPE].field=0x17;
		      WinAttbs[DIR_TYPE].header=0x1e;
		      WinAttbs[QHELP_TYPE].filler=0x22;
		      WinAttbs[QHELP_TYPE].string=0x21;
		      WinAttbs[QHELP_TYPE].field=0x2f;
		      WinAttbs[QHELP_TYPE].border=0x20;
		      WinAttbs[USER_TYPE].string=0x20;
		      WinAttbs[USER_TYPE].field=0x21;
				WinAttbs[USER_TYPE].filler=0x22;
				WinAttbs[USER_TYPE].border=0x20;
		      WinAttbs[5].filler=0x17; 
				menu_fld_attb[0]=0x1f;
				menu_fld_attb[1]=0x17;
				menu_fld_attb[2]=0x1f;
				menu_fld_attb[3]=0x17;
			}  
		 /*-----allocate maximum memory required--------*/
		 if (InitMem((word)(31*1024))==(word)0) 
		  {
		   init_wm(0);
			i=0;
		 	init_uart();				/*-----init uart------*/
		   com_str=(byte *)GetMem(sizeof(byte)*30);
			sv_str=(byte *)GetMem(sizeof(byte)*40);
			my_strcpy(com_str, (byte *)"Com 1");
			/*------initialise and realise ROOT_TYPE window ------*/
		 	root_ptr=(win_data *)GetMem(sizeof(win_data));
			root_ptr->x_val=0;
			root_ptr->y_val=0;
			root_ptr->win_height=25;
			root_ptr->win_width=80;
			root_ptr->win_type=ROOT_TYPE;
			root_ptr->win_title=(byte *)"";
			root_ptr->box_win=0;
			root_ptr->q_str_ptrs=(void *)0;
			root_ptr->vscroll_allowed=0;
	      rootwid=create_win(root_ptr);
	      realise_win(rootwid);
  			crightid=copy_right();
			QUIT=0;
			cms_exit=0;
			set_timer();
			TOTAL_TIME_TICKS=55;
			if (argc > 1)
			  on_com((int)str2h((byte *)argv[1], 0x0a)%5);
			else
			  {
			     on_chng_prt(1); 
				  QUIT=1-cms_exit;
			  }
			InitHelpLib((byte *)"xblcon.hlp", (byte *)"HELP", dummy_help_err);
	  		while (!QUIT)
			  {
			    cms_exit=0;
			    brd_req_type.Ptype=QUERY_BRIDGE_NAME;
				 trgt_win_id=create_win(&target_win);     
				 realise_win(trgt_win_id);
				 draw_window(trgt_win_id, 0x20);
				 display_string((byte *)"Looking  for  Target  on", 0x0b1d, 0x1f, (void *)0);
				 display_string((byte *)com_str, 0x0d26, 0x1f, (void *)0);
 				 display_string((byte *)"Clock Ticks :", 0x0f1d, 0x1f, (void *)0);
				 time_on=1;
				 SHOW_CLK_TICKS=(byte)1;
			    TOTAL_TIME_TICKS=55;
				 /*-----send Request packet to Target-----*/
				 clear_uart_buff();
				 while (1)
					{
				     snd_packet((byte *)&brd_req_type.Ptype, sizeof(brd_req_type));
			        if (!rcv_packet((byte *)&bridge1, sizeof(bridge1)))
					     break;  /*------no crc error------*/
   				}
				 QUIT=1;
				 time_on=0;
				 destroy_win(trgt_win_id);    
				 SHOW_CLK_TICKS=(byte)0;
				 if (time_ticks > 55)
				   {	/*-----no response from target------*/
						error_win((byte *)"Target not Found", 25 , 8, 31); 
					   no_target();
					}
				 else
				   {	/*----response from target------*/
					   if (bridge1.Ptype==RES_TYPE)
						  { 
							 incor=(byte *)&pra;
 							 incor[0]=bridge1.BrdName[1];
							 incor[1]=bridge1.BrdName[2];
							 pra=ltl_endian_word(pra);
						switch (pra)
						  {  /*---Error in Bridge Code-----*/
						     case ERR_NO_BRD_GET_PASSWORD : DOWN_LOAD=0;
																		spr_passwd=passwd_win();
																		passwd_pkt.Ptype=(byte)PASSWD_TYPE;
																		my_strcpy(passwd_pkt.Password, spr_passwd);
																		ReleaseMem((byte *)spr_passwd);
																		/*-----Send the password packet to Target---*/
																		time_on=1;
																		TOTAL_TIME_TICKS=55;
																		snd_packet((byte *)&passwd_pkt, sizeof(passwd_pkt));
																		rcv_packet((byte *)&restype, sizeof(ResultType));
																		if (time_on < 55)
																			{
																		      if (restype.Ptype==ERR_PASSWORD)
																			      { /*-----invalide password-----*/
																			         // wrong_passwd();
																			        error_win((byte *)"Wrong Password! Acess Denied", 25, 10, 26);
			                                                        destroy_win(crightid);
			                                                        destroy_win(rootwid);
			                                                        reset_uart();  
			                                                        restore_timer();  
																		          _exit(0);
																			      }
																		       else
																			      on_diff_pkt();
																		   }
																		 else
																		    error_win((byte *)"Time Out", 15, 10, 17);
																		break;

							  case ERR_NO_BRD_NO_PASSWORD  :	on_diff_pkt();
							                                 break;

							  case ERR_CRC						 : error_win((byte *)"Crc Error2", 24, 10, 28);
							                                 QUIT=0;
							                                 break;

							  default                      :	 DOWN_LOAD=0;
			                                              bridge1.BrdName[10]=0;
			                                              brd_select_opts[0]=(byte *)GetMem(sizeof(byte)*20);
			                                              my_strcpy(brd_select_opts[0], bridge1.BrdName);
			                                           //   no_of_bridges=2;
		                                                 brd_select_opts[1]=(byte *)"\177R\177eboot";
			                                              brd_select_menu=menu_field_init(brd_select_opts, brd_select_atts, (char *)"AR", 
												                                                    brd_select_fns, 2);

			                                              brd_select_win(brd_select_menu);   					 
																		 break;
						  }
  						 }
					 else
						 {
							  	 DOWN_LOAD=0;
			                                            bridge1.BrdName[10]=0;
			                                              brd_select_opts[0]=(byte *)GetMem(sizeof(byte)*20);
			                                              my_strcpy(brd_select_opts[0], bridge1.BrdName);
			                                           //   no_of_bridges=2;
		                                                 brd_select_opts[1]=(byte *)"\177R\177eboot";
			                                              brd_select_menu=menu_field_init(brd_select_opts, brd_select_atts, (char *)"AR", 
												                                                    brd_select_fns, 2);

			                                              brd_select_win(brd_select_menu);   					 
						  }

				   }							  
				}  	 
			destroy_win(crightid);
			destroy_win(rootwid);
			reset_uart();  
			restore_timer();  
			ReleaseMem((byte *)sv_str);   
  			  
	  }  						 
  }																								 
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_brd_select(i)															 */
/* PURPOSE       : To create a menu to allow the user to change the information*/
/*                  on producing a valid password if any.							 */
/* PARAMETER     : i																				 */
/*                  -integer																	 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int on_brd_select(int i)
  {
		 ReqType reqtype;
		 byte *usr_passwd;
       byte *str[]=
		            {
						  (byte *)("\177B\177ridge Information"),
						  (byte *)("\177P\177ort Information  "),
						  (byte *)("\177F\177iltering         "),
						  (byte *)("\177S\177tatistics        "),
						  (byte *)("\177M\177odem Setup       ")
						};
		 char *select_keys=(char *)"BPFSM";
		 int (*fn_ptrs[])(int)={
		                          on_brd_info,
										  on_port_info,
										  on_filt_info,
										  on_statics_info,
										  on_modem_info
										};
		 byte *attbs[]=
		              {
						    menu_fld_attb,
  							 menu_fld_attb,
							 menu_fld_attb,
							 menu_fld_attb,
							 menu_fld_attb
						  };
		 menu_data *menu_data_ptr;

		 if ((i-1))
		   my_strcpy(BridgeId, bridge1.BridgeId);
		 else
		   my_strcpy(BridgeId, bridge1.BridgeId);
		 
		 reqtype.Ptype=NEW_TP_CX;
		 time_on=0;
//		 restore_timer();
		 /*----send request packet to target requesting connection information----*/
		 snd_packet((byte *)&reqtype.Ptype, sizeof(reqtype));
		 rcv_packet((byte *)&cnct_brd, sizeof(cnct_brd));   
		 /*-----initialise the menu fields-------*/
		 menu_data_ptr=menu_field_init(str, attbs, select_keys, fn_ptrs, 5);           
		 my_strcpy(glob_info_type.Password, cnct_brd.Password);
		 if (cnct_brd.Password[0])
		    {	 /*----password required for configaration------*/
		       usr_passwd=passwd_win(); /*----accept password from user---*/
		       if (correct_password(usr_passwd, cnct_brd.Password)) /*---if valid passwd--*/
		          main_win(menu_data_ptr);   
		       else
					 {  /*-----invalid password----*/
		          //wrong_passwd();
						error_win((byte *)"Wrong Password! Acess Denied", 25, 10, 26);
					 }
		       ReleaseMem((byte*)usr_passwd);
			 }
		 else  
		    main_win(menu_data_ptr);
		 exit_flag=0;
		 return(NOT_OK);
  }																								 
/*-----------------------------------------------------------------------------*/
