/****************************************************************************
	FILE     : TFTPGLOB.C
	SYNOPSIS : This file contains all the globals that are used a TFTP file
	           transfer session.
	DATE     : 13.11.1995
	EDIT PLAN
	           Instead of having all the parameters of a session in globals
		scattered all over the place, they can be collected in a single
		structure. The application can fill in the required parameters in
		a single "control block", which also has other parameters of the connection
		that have to be maintained by TFTP during the file transfer. This way it is
		possible to have more than one application do a TFTP file transfer. TFTP
		owns the control block till the file transfer is complete i.e, the
		application cannot use the same control block for another transfer till
		the first one is complete, successfully or otherwise.
		No immediate advantage can be seen from the aforementioned change in
		scheme but it is better design without much effort. Such a scheme
		results in a full-fledged TFTP client and a clean programming interface
		which is not what we are looking for right now.
****************************************************************************/

#include "tftp.h"

char TFTPLocalFile[128], TFTPRemoteFile[20], TFTPTempLocalFile[128] ;
FILE *TFTPFilePointer ;
unsigned long TFTPServerIPAddress ;
int ServerProtocolPort ;
enum TFTP_CLIENT_STATE TFTPClientState ;
enum TFTP_REQUEST TFTPRequest ;
int TFTPPacketReceivedFlag = 0 ;
unsigned long TFTPSmoothedTimeout, TFTPTimerCount ;
int TFTPInited ;
int TFTPClientSocket ;
HWND MainWindowHandle ;
unsigned short TFTPRetryCount, TFTPSequenceNumber ;
TFTPHeaderType TFTPFileHeader ;

char TFTPSendBuffer[600], TFTPReceiveBuffer[600] ;
int TFTPSentBufferLength, TFTPReceivedBufferLength ;
enum TFP_FILE_TYPE FileType ; /* code or config */

HINSTANCE WinsockHandle ;
int UDPClientSocket ;
int sock;/* Neelu for Event broadcast */

int (PASCAL FAR *DWSAStartup)(WORD wVersionRequired, LPWSADATA lpWSAData);
int (PASCAL FAR *DWSACleanup)(void);
int (PASCAL FAR *DWSAGetLastError)(void);
int (PASCAL FAR *DWSAAsyncSelect)(SOCKET s, HWND hWnd, u_int wMsg,
                               long lEvent);
int (PASCAL FAR *Dclosesocket)(SOCKET s);
int (PASCAL FAR *Dbind)(SOCKET s, const struct sockaddr FAR *addr, int namelen);
int (PASCAL FAR *Drecvfrom)(SOCKET s, char FAR * buf, int len, int flags,
                         struct sockaddr FAR *from, int FAR * fromlen);
int (PASCAL FAR *Dsendto)(SOCKET s, const char FAR * buf, int len, int flags,
                       const struct sockaddr FAR *to, int tolen);
SOCKET (PASCAL FAR *Dsocket)(int af, int type, int protocol);
u_short (PASCAL FAR *Dntohs)(u_short netshort);
u_long (PASCAL FAR *Dntohl)(u_long netlong);
u_short (PASCAL FAR *Dhtons)(u_short hostshort);

/* Neelu on 04-02-99 */
int (PASCAL FAR *Dgetsockname) (SOCKET s, struct sockaddr FAR *name,
                            int FAR * namelen);

struct sockaddr_in UDPLocalSocket ;
struct sockaddr_in LocalSocket ;/* Neelu for Event Broadcast*/

int (PASCAL FAR *Dsetsockopt)(SOCKET s, int level, int optname,
                           char FAR * optval, int FAR *optlen) ;

int  ( PASCAL FAR *fpSetSockOptRtn)(SOCKET s, int level, int optname,
						const char FAR * optval, int optlen) ;

int  ( PASCAL FAR *fpRecvFromRtn)(SOCKET s, char FAR * buf, int len,int flags, struct sockaddr FAR * from, int FAR * fromlen) ;


struct hostent FAR * (PASCAL FAR *Dgethostbyname)(const char FAR * name);

int (PASCAL FAR *Dgethostname) (char FAR * name, int namelen);

/* Jo 11/01/99 */

/* Neelu*/
struct sockaddr_in EventLocalSocket ;
