/****************************************************************************
	MODULE  	: TFTPIF.C
	SYNOPSIS : This file contains the set of routines callable from the
	        	  Windows UI (ROUCON)
	AUTHOR   : SACHIN .S. DESAI
	DATE     : 13.11.1995
****************************************************************************/

#include "tftp.h"
#include "tftpif.h"
#include "tftpglob.h"

#include <io.h>
#include <string.h>
#include "dos.h"

extern int InitSocket (int,char*) ;
extern int InitTFTP (void) ;
extern void UnInitTFTP (void) ;
extern int TFTPClientStateMachine (void) ;


enum TFTP_COMPLETION_CODE_STATUS TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
enum TFTP_FILE_TRANSFER_STATUS TFTPFileTransferStatus = TFTP_FILE_TRANSFER_NOT_SCHEDULED ;
unsigned long TFTPFileLength=0, TFTPBytesTransfered=0 ;
unsigned char LastTFTPErrorMsg[80], TFTPTempCompFile[128] ;

unsigned long UserDataBaseFileLength ;

enum TFTP_FILE_TRANSFER_RESULT FAR PASCAL _loadds TFTPGetFile (
#if PROXY_SERVER
		char far *LocalFile, char RemoteFile[], char ServerIPAddressString[],
#else
		char LocalFile[], char RemoteFile[], char ServerIPAddressString[],
#endif
														  HWND WindowHandle)
{
	char *TempPointer ;
	char dummy_ptr[16] ;
	int i, ret ,value = 0 ;
	char t1, t2, t3, t4, c ;

	MainWindowHandle = WindowHandle ;
	FixFileType (RemoteFile) ;
	/* Global FileType is set to 0 (config) or 1 (code) or 2 (Boot header)
	   or 3 (User Database) */

	sscanf (ServerIPAddressString, "%d%c%d%c%d%c%d", &t1, &c,
											&t2, &c, &t3, &c, &t4) ;
	TempPointer = (char *) &TFTPServerIPAddress ;
	TempPointer[0] = t1 ;
	TempPointer[1] = t2 ;
	TempPointer[2] = t3 ;
	TempPointer[3] = t4 ;

	strcpy (TFTPRemoteFile, RemoteFile) ;

#if PROXY_SERVER
	if (FileType != FILE_TYPE_PORT_STATUS)
	{
#endif

		strcpy (TFTPLocalFile, LocalFile) ;
		strcpy (TFTPTempLocalFile, LocalFile) ;
		strcpy (TFTPTempCompFile, LocalFile) ;

		for (i = 0 ; ((TFTPTempLocalFile[i] != '.') &&
								(TFTPTempLocalFile[i])) ; i ++) ;
		if (TFTPTempLocalFile[i] != '.')
		{
			TFTPTempLocalFile[i] = '.' ;
			TFTPTempCompFile[i] = '.' ;
		}
		TFTPTempLocalFile[i+1] = '~' ;
		TFTPTempLocalFile[i+2] = '~' ;
		TFTPTempLocalFile[i+3] = '~' ;
		TFTPTempLocalFile[i+4] = 0x00 ;

		TFTPTempCompFile[i+1] = 'C' ;
		TFTPTempCompFile[i+2] = 'M' ;
		TFTPTempCompFile[i+3] = 'P' ;
		TFTPTempCompFile[i+4] = 0x00 ;

#if PROXY_SERVER
	}
	else
		TFTPFilePointer = (FILE *)LocalFile ;
#endif

	if ((ret = InitSocket(value,dummy_ptr)) != 0)
	{
		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;

		switch (ret)
	   {
			case WSASYSNOTREADY :
				return TFTP_NETWORK_SUBSYSTEM_NOT_READY ;

	      case WSAVERNOTSUPPORTED :
          	return TFTP_VERSION_NOT_SUPPORTED ;

	      case LOAD_LIBRARY_FAILED :
           	return TFTP_LOAD_LIBRARY_FAILED ;

	      case GET_PROC_FAILED :
          	return TFTP_GET_PROC_FAILED ;

	      default :
           	return TFTP_SOCKET_INITIALIZATION_FAILED ;
      }
	}

	if (InitTFTP() == -1)
	{
		UnInitTFTP() ;
		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
		return TFTP_FAILURE ;
	}

	TFTPTimerCount = 0 ;
	TFTPRequest = TFTP_REQUEST_GET ;
	TFTPClientState = STATE_SEND_REQUEST ;
	TFTPFileTransferStatus = TFTP_FILE_TRANSFER_IN_PROGRESS ;
	TFTPCompletionCode = TFTP_IN_PROGRESS ;

	TFTPFileLength = 0 ;
	TFTPBytesTransfered = 0 ;

	/* conveys that TFTP file transfer has started off */
	return TFTP_SUCCESS ;
}

/*
BOOL	FileCopy(char *TFTPLocalFile, char *TFTPTempCompFile)
{
	FILE	*ifd, *ofd;
	if ((ifd = fopen(TFTPLocalFile, "rb")) ) {
	}

} */

extern FileHeaderType FileHeader ;

enum TFTP_FILE_TRANSFER_RESULT FAR PASCAL _loadds TFTPPutFile (
	char LocalFile[], char RemoteFile[], char ServerIPAddressString[],
								  HWND WindowHandle, TFTPCodeBurnStruct *CodeAddrPtr)
{
	char *TempPointer = (char *) &TFTPServerIPAddress ;
	FILE *FilePointer ;
	int ret, i ,value = 0;
	int t1, t2, t3, t4, c ;
	struct _find_t FileInfo ;
	char dummy_ptr[16] ;

	MainWindowHandle = WindowHandle ;
	FixFileType (RemoteFile) ;
	/* Global FileType is set to 0 (config) or 1 (code) */
	/* or 3 (user database)  */

#if PROXY_SERVER
	if (FileType == FILE_TYPE_PORT_STATUS)
	{
		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
		return TFTP_FAILURE ;
	}
#endif

	strcpy (TFTPLocalFile, LocalFile) ;
	strcpy (TFTPRemoteFile, RemoteFile) ;
	strcpy (TFTPTempLocalFile, LocalFile) ;
	strcpy (TFTPTempCompFile, LocalFile) ;

	sscanf (ServerIPAddressString, "%d%c%d%c%d%c%d", &t1,
								&c, &t2, &c, &t3, &c, &t4) ;
	*(TempPointer + 0) = t1 ;
	*(TempPointer + 1) = t2 ;
	*(TempPointer + 2) = t3 ;
	*(TempPointer + 3) = t4 ;

	for (i = 0 ; ((TFTPTempLocalFile[i] != '.') && 
									(TFTPTempLocalFile[i])) ; i ++) ;
	if (TFTPTempLocalFile[i] != '.')
	{
		TFTPTempLocalFile[i] = '.' ;
		TFTPTempCompFile[i] = '.' ;
	}
	TFTPTempLocalFile[i+1] = '~' ;
	TFTPTempLocalFile[i+2] = '~' ;
	TFTPTempLocalFile[i+3] = '~' ;
	TFTPTempLocalFile[i+4] = 0x00 ; 

	TFTPTempCompFile[i+1] = 'C' ;
	TFTPTempCompFile[i+2] = 'M' ;
	TFTPTempCompFile[i+3] = 'P' ;
	TFTPTempCompFile[i+4] = 0x00 ;

   switch (FileType)
   {
    	case FILE_TYPE_CODE :
	      if (TFTPCompress (TFTPLocalFile, TFTPTempCompFile))
    	   {
         	TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
	         return TFTP_COMPRESSION_FAILED ;
         }
			FilePointer = fopen (TFTPLocalFile, "r") ;
			if (FilePointer)
		 		fread (&FileHeader, 1, 37, FilePointer) ;

        	if (AddTFTPHeader (TFTPTempCompFile, TFTPTempLocalFile, CodeAddrPtr))
         {
	     		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
   		   remove (TFTPTempCompFile) ;
            return TFTP_FAILURE ;
	      }
         remove (TFTPTempCompFile) ;
         break ;
		
		case FILE_TYPE_CONFIG :
		case FILE_TYPE_SCRIPT_CONFIG :
		case FILE_TYPE_SCRIPT_PORT1 :
		case FILE_TYPE_SCRIPT_PORT2 :
		case FILE_TYPE_SCRIPT_PORT3 :
			if (AddTFTPHeader (TFTPLocalFile, TFTPTempLocalFile, CodeAddrPtr))
         {
      		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
	        	return TFTP_FAILURE ;
	      }
         break ;

		case FILE_TYPE_USER_DATABASE :
			_dos_findfirst (TFTPLocalFile, _A_NORMAL, &FileInfo) ;
			UserDataBaseFileLength = (unsigned long) FileInfo.size ;
#if 0
	      if (TFTPCompress (TFTPLocalFile, TFTPTempCompFile))
    	   {
         	TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
	         return TFTP_COMPRESSION_FAILED ;
	      }
#else
			// Since we are not doing compression of UDB for now,
			// we just rename the TFTPTempCompFile to TFTPTempLocalFile
//			FileCopy (TFTPLocalFile, TFTPTempCompFile);
#endif
         if (AddTFTPHeader (TFTPLocalFile, TFTPTempLocalFile, CodeAddrPtr))
         {
         	TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
				//	remove (TFTPTempCompFile) ;
         	return TFTP_FAILURE ;
	      }
         // remove (TFTPTempCompFile) ;
			break ;

	   default :
        	TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
	      return TFTP_INVALID_BIN_FILE ;
    }

	if ((ret = InitSocket(value,dummy_ptr)) != 0)
   {
		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
	     switch (ret)
      	 {	
		 	case (WSASYSNOTREADY) :
            	return (TFTP_NETWORK_SUBSYSTEM_NOT_READY) ;

	        case (WSAVERNOTSUPPORTED) :
            	return (TFTP_VERSION_NOT_SUPPORTED) ;

            case (LOAD_LIBRARY_FAILED) :
            	return (TFTP_LOAD_LIBRARY_FAILED) ;

            case (GET_PROC_FAILED) :
            	return (TFTP_GET_PROC_FAILED) ;

            default :
            	return (TFTP_SOCKET_INITIALIZATION_FAILED) ;
      	 }
	}

	if (InitTFTP() == -1)
	{
		UnInitTFTP() ;
		TFTPCompletionCode = TFTP_NOT_SCHEDULED ;
		return (TFTP_FAILURE) ;
	}

	TFTPTimerCount = 0 ;
	TFTPRequest = TFTP_REQUEST_PUT ;
	TFTPClientState = STATE_SEND_REQUEST ;
	TFTPFileTransferStatus = TFTP_FILE_TRANSFER_IN_PROGRESS ;
	TFTPCompletionCode = TFTP_IN_PROGRESS ;

	//TFTPFileLength = 0 ;
	TFTPBytesTransfered = 0 ;

	return (TFTP_SUCCESS) ;

	/* conveys that TFTP file transfer has started off */
}


void FAR PASCAL __loadds TFTPProcess (void)
{
	TFTPPacketReceivedFlag = 1 ;
}

void FAR PASCAL __loadds TFTPAbortProcess (void)
{
	UnInitTFTP() ;
	TFTPCompletionCode = TFTP_NOT_SCHEDULED ;

	return ;
}

int InTFTPTimer = 0 ;

void FAR PASCAL __loadds TFTPTimer (void)
{

	if (TFTPCompletionCode == TFTP_NOT_SCHEDULED)
		return ;

	if (TFTPTimerCount)
		TFTPTimerCount -- ;

	if (InTFTPTimer)
		return ;

	InTFTPTimer ++ ;

	TFTPClientStateMachine() ;
    if ((TFTPClientState == STATE_SEND_DATA) ||
   				(TFTPClientState == STATE_SEND_ACK))
    	TFTPClientStateMachine() ;

	InTFTPTimer -- ;
}

unsigned long FAR PASCAL __loadds TFTPGetFileLength (void)
{
	if (TFTPCompletionCode == TFTP_NOT_SCHEDULED)
		return 0 ;

	return TFTPFileLength ;
}

enum TFTP_COMPLETION_CODE_STATUS FAR PASCAL __loadds TFTPGetCompletionCode (void)
{
	return TFTPCompletionCode ;
}

enum TFTP_FILE_TRANSFER_STATUS FAR PASCAL __loadds TFTPGetFileTransferStatus (void)
{
	return TFTPFileTransferStatus ;
}

unsigned long FAR PASCAL __loadds TFTPGetBytesTransfered (void)
{
	if (TFTPCompletionCode == TFTP_NOT_SCHEDULED)
		return 0 ;

	return TFTPBytesTransfered ;
}


int FAR PASCAL __loadds TFTPGetLastErrorMessage (char far *ErrorMessage)
{
   _fstrncpy (ErrorMessage, LastTFTPErrorMsg, 99) ;
   ErrorMessage[99] = 0 ;
   LastTFTPErrorMsg[0] = 0 ;

   return 0 ;
}

