
/****************************************************************************
  FILE     : TFTPIF.H	
  SYNOPSIS : This file contains the extern declarations of all the functions	
             that are callable from the UI. It further gives the defn. of	
             all the constants, return codes etc. shared between TFTP and	
             ROUCON. As such, this is the only file that needs to be included	
             by ROUCON to use TFTP.	
  DATE     : 13.11.95	
****************************************************************************/

#ifndef _TFTPIF_H_

#define _TFTPIF_H_

#ifndef ULONG
#define	ULONG	unsigned long
#endif

#include "tftpdnld.h"
#include "tftp\tftpcons.h"

enum TFTP_FILE_TRANSFER_RESULT
{
	TFTP_SUCCESS = 0,
	TFTP_SOCKET_INITIALIZATION_FAILED,
	TFTP_COMPRESSION_FAILED,
	TFTP_NETWORK_SUBSYSTEM_NOT_READY,
	TFTP_VERSION_NOT_SUPPORTED,
    TFTP_INVALID_BIN_FILE,
    TFTP_LOAD_LIBRARY_FAILED,
    TFTP_GET_PROC_FAILED,
	TFTP_FAILURE = 0xFF
} ;

enum TFTP_FILE_TRANSFER_STATUS
{
	TFTP_FILE_TRANSFER_NOT_SCHEDULED = 0,
	TFTP_NO_RESPONSE_FROM_TARGET,
	TFTP_FILE_TRANSFER_IN_PROGRESS,
	TFTP_FILE_TRANSFER_SUCCESSFUL,
	TFTP_FILE_TRANSFER_FAILED = 0xFF
} ;

enum TFTP_COMPLETION_CODE_STATUS
{
	TFTP_COMPLETE = 0,
	TFTP_IN_PROGRESS,
	TFTP_NOT_SCHEDULED
} ;

#define WM_TFTP WM_USER + 25

/*............. Neelu ported fm Jo on 03/02/99 ...........*/

#define WM_UDP_EVENT_OCCURED WM_USER + 26
/* #define AUTO_DETECTION_OVER WM_USER + 27 */
#define MAX_MAC_ADDRESS_LENGTH	 16


#define MAX_UDP_RESPONSE_WAIT 9000    /*9 secs timer*/
#define MAX_UDP_RETRY_RESPONSE_WAIT 3000    /*3 secs timer*/
#define 	AUTODETECT_TIMERID 	0xfe10
#define 	AUTODETECT_RETRY_TIMERID 	0xfe00
#define MAX_NUMBER_OF_SERVERS 15

#define UDP_DISCOVER_PACKET_TYPE 1
#define UDP_DISCOVER_RESPONSE_PACKET_TYPE 2
#define UDP_CONFIGURE_PACKET_TYPE 3
#define UDP_CONFIGURE_RESPONSE_PACKET_TYPE 4

/*......... Neelu ported fm Jo ends on 03/02/99 ...........*/


#define WM_EVENT       (WM_USER + 63) //For Event broadcast
#define WM_USER_LOG_EVENT       (WM_USER + 65) // Imran,22.3.99
#define WM_LOG_EVENT       (WM_USER + 66) // Imran,7.4.99

#define MAX_EVENT_RESPONSE_WAIT 4000    /*4 secs timer*/
#define MAX_LENGTH_USER_NAME  150
extern int sock ; /* Neelu for event broadcast*/
/*extern int (PASCAL FAR *Drecvfrom)(SOCKET s, char FAR * buf, int len, int flags,
                         struct sockaddr FAR *from, int FAR * fromlen);*/


#define PROXY_SERVER 1



extern "C"
{
extern enum TFTP_FILE_TRANSFER_RESULT FAR PASCAL __loadds

#if PROXY_SERVER

TFTPGetFile (char far *LocalFile, char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle) ;

#else

TFTPGetFile (char LocalFile[], char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle) ;

#endif

extern enum TFTP_FILE_TRANSFER_RESULT  FAR PASCAL __loadds
TFTPPutFile (char LocalFile[], char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle, TFTPCodeBurnStruct *CodeStructPtr) ;
extern void  FAR PASCAL __loadds TFTPProcess (void) ;
extern void  FAR PASCAL __loadds TFTPAbortProcess (void) ;
extern void  FAR PASCAL __loadds TFTPTimer (void) ;
extern void  FAR PASCAL __loadds AbortTFTPTransfer() ;
extern unsigned long FAR PASCAL __loadds TFTPGetFileLength() ;
extern unsigned long FAR PASCAL __loadds TFTPGetBytesTransfered() ;
extern enum TFTP_COMPLETION_CODE_STATUS FAR PASCAL __loadds 
	TFTPGetCompletionCode() ;
extern enum TFTP_FILE_TRANSFER_STATUS FAR PASCAL __loadds 
	TFTPGetFileTransferStatus() ;
extern int FAR PASCAL __loadds 
	TFTPGetLastErrorMessage (char far *ErrorMessage) ;

/* Neelu ported fm Jo on 03-02-99 */
extern int FAR PASCAL __loadds UDPInitSocket (int value, char host_ip_address[16]) ;
extern int FAR PASCAL __loadds StartAutoDetection (HWND WindowHandle, int *pError,
					  unsigned long ip_address, BYTE mac_address[16], int flag) ; 

extern int FAR PASCAL __loadds process_response_from_server (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS],
										int *pError, int *number_of_responses) ;
extern void FAR PASCAL __loadds UnInitUDP () ;
	

extern int FAR PASCAL __loadds InitialiseSocket( HWND WindowHandle,int *pError);  

//Neelu For EventBroadcast

//int FAR PASCAL _loadds recieve_data_from_the_packet (int *pError, enum EVENT_CATEG *event_type,enum EVENT_TYPE_ENUM *broadcast_event_type,char user_string[MAX_DATA_PACKET_SIZE],char user_event_string[400]);
//int FAR PASCAL _loadds recieve_data_from_the_packet (int *pError, enum EVENT_CATEG *event_type,enum EVENT_TYPE_ENUM *broadcast_event_type,char user_string[MAX_DATA_PACKET_SIZE],char user_event_string[400],char final_event_string[400]);
extern int FAR PASCAL _loadds recieve_data_from_the_packet (EventBroadCastDataPacket *pUserDataPacket,int *pError);

//int FAR PASCAL _loadds recieve_data (int *pError, enum EVENT_CATEG *event_type,char user_string[MAX_DATA_PACKET_SIZE]);

//extern int FAR PASCAL _loadds recieve_data_from_the_packet (int *pError,enum EVENT_CATEG* event_type); //For Event broadcast
//Neelu Ends
}
/* Neelu ported fm Jo ends on 03-02-99 */

//extern enum TFTP_COMPLETION_CODE_STATUS TFTPCompletionCode ;
//extern enum TFTP_FILE_TRANSFER_STATUS TFTPFileTransferStatus ;
/* This variable keeps track of the TFTP file transfer status.
   This is absolutely necessary because any call to TFTPGetFile()
   or TFTPPutFile() will only schedule a file transfer and return.
   The completion and the success/failure of the file transfer is
   identified by looking at this variable */

//extern unsigned long TFTPFileLength, TFTPBytesTransfered ;

#endif


/****************************************************************************
	Overview of the TFTP File Transfer :
	----------------------------------
		Any application, seeking to do a TFTP file transfer needs to do the
	following :
	(a). Include the tftpif.h file.
	(b). Make a call to TFTPGetFile() or TFTPPutFile() as the case may be.
	     Having done this, the application should arrange to call TFTPTimer()
	     every 55 milliseconds and in the WindowProcedure, corresponding to
	     the Window Handle passed as a parameter to the above call, make a
		 call to TFTPProcess() on message WM_TFTP.
	(c). Note that TFTPGetFile() / TFTPPutFile() only prepare for file
	     transfer and return. The completion and result of the file transfer
	     are recorded in two globals, TFTPCompletionCode and
		 TFTPFileTransferStatus.
	     It is up to the application to detect the completion of the file
		 transfer by monitoring the two variables.

	TFTPCompletionCode : If this variable holds a non-zero value, it implies
		that file transfer is in progress. Once this variables becomes zero,
		it means that TFTP is done with the file transfer. Note that this
		variable does NOT convey the success/failure of the file transfer.

	TFTPFileTransferStatus : This variable has meaning only after
		TFTPCompletionCode becomes zero. The value reflects the result of the
		file transfer.

****************************************************************************/

