// tftpwrit.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "tftpwrit.h"
#include	"tftpif.h"
#include	"msgumain.h"
#include	"msguview.h"
#include	"dot.h"
#include "tftpdnld.h"

#include "usrdata.h" // Sreelu
#include "usdata.h"	// Sreelu

extern LPCSTR MainMsgHeader ;
extern char TFTPMessageHeader[] ;
char ErrorMessage[100] ;

#ifdef NEW_BOOT_2
extern TFTPCodeBurnStruct TFTPCodeAddressDetails ;
#endif

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define	TFTP_WRITE_TIMER_ID		20
#define	TFTP_DLL_CLOCK_ID			21

#define	TFTP_WRITE_TIMER_PERIOD	1000
#define	TFTP_DLL_CLOCK_PERIOD	55

CHorzGauge *wndHorzWriteGauge;

/////////////////////////////////////////////////////////////////////////////
// tftpwrit dialog


tftpwrit::tftpwrit(CWnd* pParent /*=NULL*/)
	: CDialog(tftpwrit::IDD, pParent)
{
	//{{AFX_DATA_INIT(tftpwrit)
	m_Desc = "";
	m_IPAddr = "";
	m_Size = "" ;
	//}}AFX_DATA_INIT
}

void tftpwrit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(tftpwrit)
	DDX_Text(pDX, IDC_STATIC_DESCRIPTION, m_Desc);
	DDX_Text(pDX, IDC_STATIC_IP_ADDR, m_IPAddr);
	DDX_Text(pDX, IDC_STATIC_SIZE, m_Size);
	//}}AFX_DATA_MAP
}


LRESULT	tftpwrit::OnTFTPWriteCallBack(WPARAM wParam, LPARAM lParam)
{
	TFTPProcess();
	return NULL;
}


BEGIN_MESSAGE_MAP(tftpwrit, CDialog)
	//{{AFX_MSG_MAP(tftpwrit)
	ON_WM_TIMER()
	ON_MESSAGE(WM_TFTP, OnTFTPWriteCallBack)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int TFTPWriteSuccessful ;
/////////////////////////////////////////////////////////////////////////////
// tftpwrit message handlers
// Sachin 29.11.95
BOOL tftpwrit::OnInitDialog()
{
	char FileType = 0, IPAddress[20] ;
	HWND ThisWindowHandle ;
   enum TFTP_FILE_TRANSFER_RESULT TFTPWriteResult ;

	CDialog::OnInitDialog();

	/* The compression takes quite long to complete. So after the
	   user selects download-code, it takes some time for the guage
		to appear. Do something about this by showing a
		   compression in progress, please wait..... message
	*/
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;

	if (strcmpi (TFTPPutRemoteFileName, "MTROUTER.BIN") == 0)
		m_Desc = "Writing Firmware. Please wait..." ;
	else
   	m_Desc = "Writing Configuration. Please wait..." ;

	if (!strcmpi (TFTPPutRemoteFileName, "USER.DTB"))
	{
		m_Desc = "Writing User Data Base. Please wait..." ;
		strcpy (CurrentHeading, "Firewall - Writing User DataBase") ;
	}
	else
		if (strstr (TFTPPutRemoteFileName, "PORT")
				|| strstr (TFTPPutRemoteFileName, "SCRIPT"))
		{
			m_Desc = "Writing Script. Please wait..." ;
			strcpy (CurrentHeading, "Firewall - Writing Script") ;
		}

	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;



	if (!CancelBitmapBtn.LoadBitmaps ("ABORT1", "ABORT2", "ABORT3", "ABORT4"))
		AfxMessageBox ("Failed to load Abort bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();


#if 0
	if (strcmpi (TFTPPutRemoteFileName, "MTROUTER.BIN") == 0)
		FileType = 1 ; // BIN file
	else
		FileType = 0 ; // CONFIG file
#endif

   CenterWindow();
	
	if(CommandLineArgument == 3 ) // Sreelu
		DefaultDbaseYes();

	// TODO: Add extra initialization here
	// Read the TFTP address in dotted notation
	if (GetPrivateProfileString ((LPCSTR) "Port Setup",
		(LPCSTR) "Router IP Address", (LPCSTR) ZeroIPAddress,
			(LPSTR) IPAddress, sizeof (IPAddress), (LPCSTR) OwnIniFile) <= 0)
		CDialog::OnCancel() ;

	m_IPAddr = IPAddress ;

	// Create a gauge to show TFTP File Transfer
	wndHorzWriteGauge = new(CHorzGauge) ;
	CRect rc ;

	GetDlgItem(IDC_STATIC_RECT)->GetWindowRect(&rc);
	ScreenToClient(&rc);

	wndHorzWriteGauge->Create((CWnd *)this, rc) ;	
	wndHorzWriteGauge->SetGaugeInfo("", 0, 100, 
		  GU_ELEVATED ,GU_DEPRESSED, TRUE, FALSE, FALSE, 
						RGB(0xff, 0xff, 0xff), RGB(0x80,0x80, 0x80), 
						RGB(0, 0, 0xff), RGB(0xc0, 0xc0, 0xc0), 
						RGB(0, 0, 0)) ;
   UpdateData(FALSE) ;

	// create a timer to check if read is over and to update the guage
	if (TFTP_WRITE_TIMER_ID != SetTimer (TFTP_WRITE_TIMER_ID,
												TFTP_WRITE_TIMER_PERIOD, NULL))
	{
		wndHorzWriteGauge->DestroyGauge() ;
		delete wndHorzWriteGauge ;
		CDialog::OnCancel() ;
		TFTPWriteSuccessful = 0 ;
		return TRUE ;
	}

	if (TFTP_DLL_CLOCK_ID != SetTimer (TFTP_DLL_CLOCK_ID,
											TFTP_DLL_CLOCK_PERIOD, NULL))
	{
		KillTimer (TFTP_WRITE_TIMER_ID) ;
		wndHorzWriteGauge->DestroyGauge() ;
		delete wndHorzWriteGauge ;
		CDialog::OnCancel() ;
		TFTPWriteSuccessful = 0 ;
		return TRUE ;
	}

	ThisWindowHandle = GetSafeHwnd() ;
	TFTPWriteSuccessful = 1 ;

	if (FileType)
	{
		SetCapture() ;
		AfxGetApp()->LoadCursor(IDC_WAIT) ;
		AfxGetApp()->DoWaitCursor(-1) ;
		AfxGetApp()->DoWaitCursor(1) ;

/*		TFTPWaitMessage TFTPCompressionProgress(this) ; */
	}

	if ((TFTPWriteResult = TFTPPutFile (TFTPPutLocalFileName,
		TFTPPutRemoteFileName, IPAddress, ThisWindowHandle,
			&TFTPCodeAddressDetails)) != TFTP_SUCCESS)
	{
		if (FileType)
		{
			AfxGetApp()->DoWaitCursor(0) ;
			ReleaseCapture() ;
		}
      KillTimer (TFTP_DLL_CLOCK_ID) ;
      KillTimer (TFTP_WRITE_TIMER_ID) ;
      wndHorzWriteGauge->DestroyGauge() ;
      delete wndHorzWriteGauge ;

      switch (TFTPWriteResult)
		{
			case (TFTP_SOCKET_INITIALIZATION_FAILED) :
				RouMsgBox (MSG_TFTP_SOCKET_INIT_FAILED,
					TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

			case (TFTP_COMPRESSION_FAILED) :
				RouMsgBox (MSG_TFTP_COMPRESSION_FAILED, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

			case(TFTP_NETWORK_SUBSYSTEM_NOT_READY) :
				RouMsgBox (MSG_TFTP_NO_DLL_SUPPORT, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

			case (TFTP_VERSION_NOT_SUPPORTED) :
				RouMsgBox (MSG_TFTP_NO_VERSION_SUPPORT, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

			case (TFTP_LOAD_LIBRARY_FAILED) :
				RouMsgBox (MSG_TFTP_WINSOCK_DLL_NOT_FOUND, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

			case (TFTP_GET_PROC_FAILED) :
				RouMsgBox (MSG_TFTP_REQD_FUNCTIONS_NOT_FOUND, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
				break ;

         case (TFTP_INVALID_BIN_FILE) :
            RouMsgBox (MSG_TFTP_INVALID_BIN_FILE, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
            break ;

			case (TFTP_FAILURE) :
            TFTPGetLastErrorMessage (ErrorMessage) ;
            DisplayMessage (ErrorMessage, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
				break ;

			default :
				break ;
		}
      CDialog::OnCancel();

		TFTPWriteSuccessful = 0 ;
		return TRUE ;
	}

	if (FileType)
	{
		AfxGetApp()->DoWaitCursor(0) ;
		ReleaseCapture() ;
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void tftpwrit::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

unsigned long WriteTotalSize = 0 ;
unsigned long WriteCurrentSize = 0 ;
enum TFTP_FILE_TRANSFER_STATUS WriteTFTPStatus ;
enum TFTP_COMPLETION_CODE_STATUS WriteTFTPComplete ;

void tftpwrit::OnTimer (UINT nIDEvent)
{
	int FileTransferPercentage ;
	
	// TODO: Add your message handler code here and/or call default

	if (nIDEvent == TFTP_WRITE_TIMER_ID)
	{
		// this is around a second timer
		// get the CurrentSize and total size
		// display progress

		WriteTotalSize = TFTPGetFileLength () ;
		WriteCurrentSize = TFTPGetBytesTransfered () ;

		if (WriteTotalSize) 
		{
			if (!strlen (m_Size)) 
			{
				char Buf[20];
				ultoa (WriteTotalSize, Buf, 10);
				m_Size = Buf;
				UpdateData (FALSE) ;
			}

			FileTransferPercentage = (int) ((WriteCurrentSize * 100L)
																		/ WriteTotalSize) ;
			wndHorzWriteGauge->UpdateProgress (FileTransferPercentage);
		}
		else 
		{
				// Sachin 29.11.95
				char Buf[20] ;
				strcpy (Buf, "unknown") ;
				m_Size = Buf ;
				UpdateData (FALSE) ;
				wndHorzWriteGauge->UpdateProgress (0);

		}
		//WriteCurrentSize += 5;
		// if xfer done close Gauge and dialog

		WriteTFTPComplete = TFTPGetCompletionCode() ; // Sachin 27.11.95
		WriteTFTPStatus = TFTPGetFileTransferStatus() ; // Sachin 27.11.95
		
		 // Sachin 27.11.95
		if ((WriteTFTPComplete == TFTP_COMPLETE) || (TFTPWriteSuccessful == 0)) 
		{
			// Because Total size is initially set to 0
			// at the end of a read (successful or otherwise) we must destroy the gauge
			//
			wndHorzWriteGauge->DestroyGauge();
			delete wndHorzWriteGauge;
			KillTimer(TFTP_WRITE_TIMER_ID);
			KillTimer(TFTP_DLL_CLOCK_ID);
			CDialog::OnOK();

			switch (WriteTFTPStatus)
			{
				case (TFTP_NO_RESPONSE_FROM_TARGET) :
					RouMsgBox (MSG_TFTP_NO_RESPONSE_FROM_TARGET, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION);
               break ;

				case (TFTP_FILE_TRANSFER_FAILED) :
               TFTPGetLastErrorMessage (ErrorMessage) ;
               if (ErrorMessage[0] != 0)
               {
                  DisplayMessage (ErrorMessage, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
                  break ;
               }
               RouMsgBox (MSG_TFTP_FILE_TRANSFER_FAILURE, TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
               break ;
            
            default :
               break ;
			}
		}
	}
	else
		if (nIDEvent == TFTP_DLL_CLOCK_ID) 
		{
			TFTPTimer();
		}
	CDialog::OnTimer(nIDEvent);
}

// Added by Sreelu.
void tftpwrit::DefaultDbaseYes()
{
// By Default UserDataBase should be Disabled & Default Action should be Forward.w
		FILE *wFile;
		wFile = fopen (UDBUnCompressedDBaseFile, "wb") ;
		USERDATABASE *pUserData = (USERDATABASE *) new USERDATABASE;
		pUserData->magic_id = IP_PROFILE;
		pUserData->number_of_items = 0;
		pUserData->length_of_items = 0;

		pUserData->magic_id	= SwapWord (pUserData->magic_id);
		pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
		pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
		fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

// Writing USER_INFO
		USER_INFO *info;
		info = (USER_INFO *) malloc(sizeof(USER_INFO));
	
		info->enabled = FALSE;
		info->default_action = FORWARD;
		info->enabled = SwapWord(info->enabled);
		info->default_action = SwapWord(info->default_action);
		fwrite (info, sizeof (USER_INFO), 1, wFile) ;

// Write Invalid Magic ID
		pUserData->magic_id = INVALID_MAGIC_ID;
		pUserData->number_of_items = 0;
		pUserData->length_of_items = 0;

		pUserData->magic_id = SwapWord (pUserData->magic_id);
		pUserData->number_of_items = SwapWord (pUserData->number_of_items);	
		pUserData->length_of_items = SwapDWord (pUserData->length_of_items);	

		fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

		delete pUserData;
		free (info);
		fclose (wFile) ;
}

int tftpwrit::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

int tftpwrit::DisplayMessage (char *Message, LPCSTR Header, int Opts)
{
	int	Ret_val;

 	Ret_val = MessageBox(Message, Header, Opts);
	return Ret_val;
}

/////////////////////////////////////////////////////////////////////////////
// TFTPWaitMessage dialog


TFTPWaitMessage::TFTPWaitMessage(CWnd* pParent /*=NULL*/)
	: CDialog(TFTPWaitMessage::IDD, pParent)
{
	//{{AFX_DATA_INIT(TFTPWaitMessage)
	m_szMsg1 = "Compressing Firmware" ;
	m_szMsg2 = "Please Wait..." ;
	//}}AFX_DATA_INIT
	Create(IDD, pParent) ;
	CenterWindow() ;
	ShowWindow(SW_SHOW) ;
}

void TFTPWaitMessage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TFTPWaitMessage)
	DDX_Text(pDX, IDC_STATIC_WAIT_MSG1, m_szMsg1);
	DDX_Text(pDX, IDC_STATIC_WAIT_MSG2, m_szMsg2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(TFTPWaitMessage, CDialog)
	//{{AFX_MSG_MAP(TFTPWaitMessage)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TFTPWaitMessage message handlers

void TFTPWaitMessage::OnDestroy()
{
	CDialog::OnDestroy();
	ReleaseCapture() ;	
	// TODO: Add your message handler code here
}

BOOL TFTPWaitMessage::OnInitDialog()
{
	CDialog::OnInitDialog();
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	UpdateData (FALSE) ;
	
	// TODO: Add extra initialization here
	SetCapture() ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

