// useraddd.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "useraddd.h"
#include "usrdata.h"
#include "userdlg.h"
#include "userfilt.h"
//#include "groupadd.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern BOOL m_DBChanged;

/////////////////////////////////////////////////////////////////////////////
// CUserAddDlg dialog


CUserAddDlg::CUserAddDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUserAddDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUserAddDlg)
	m_bActionEdit = FALSE;
	m_szUserName = "";
	m_szUserPassword = "";
	m_GroupName = "";
	m_szReconfirmPassword = "";
	//}}AFX_DATA_INIT
}

void CUserAddDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUserAddDlg)
	DDX_Control(pDX, IDC_STATIC_ALP, m_AcntLockCtrl);
	DDX_Control(pDX, IDC_STATIC_AS, m_AcntStatusCtrl);
	DDX_Control(pDX, IDC_RECONFIRM_PASSWORD, m_ReconfirmPassword);
	DDX_Control(pDX, IDC_COMBO_GROUP, m_ctrl_combo_group);
	DDX_Control(pDX, IDC_EDIT_USER_PASSWORD, m_UserPasswordWnd);
	DDX_Control(pDX, IDC_EDIT_USER_NAME, m_UserNameEditWnd);
	DDX_Control(pDX, IDC_COMBO_ACCOUNT, m_ctrl_combo_account);
	DDX_Control(pDX, IDC_COMBO_DEFAULTER, m_ctrl_combo_defaulter);
	DDX_Text(pDX, IDC_EDIT_USER_NAME, m_szUserName);
	DDX_Text(pDX, IDC_EDIT_USER_PASSWORD, m_szUserPassword);
	DDX_CBString(pDX, IDC_COMBO_GROUP, m_GroupName);
	DDX_Text(pDX, IDC_RECONFIRM_PASSWORD, m_szReconfirmPassword);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUserAddDlg, CDialog)
	//{{AFX_MSG_MAP(CUserAddDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CUserAddDlg message handlers

BOOL CUserAddDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO: Add extra initialization here
      //Set Bitmaps
 
	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();
      
	
	m_ctrl_combo_defaulter.SetCurSel(0);
	m_ctrl_combo_account.SetCurSel(0);	
     
//     m_ctrl_combo_group.SetCurSel(0);	
	
      int index = 0;
      char tmpGroupname[GROUP_NAME_LEN],tmpGroupdesc[GROUP_DESC_LEN];
      char NameDesc[GROUP_NAME_LEN +GROUP_DESC_LEN ] ;	
      while(1)
      {
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//		CUserDlg *pParent = (CUserDlg *) GetParent() ;
      		if (pParent->m_UserDlg->m_LBoxForGroupName.GetText(index,NameDesc) != LB_ERR)
		{
			sscanf(NameDesc,"%s\t%s",tmpGroupname,tmpGroupdesc);
      			m_ctrl_combo_group.InsertString(index++,tmpGroupname);
	       		
		       //	UpdateData (TRUE);
      		}
		else
		{
	       	      //	UpdateData (TRUE);
			break;
		}
	       
	}   
      m_ctrl_combo_group.SetCurSel(0);	
      CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, sizeof (CurrentHeading)) ;

	// The Window Header says "Add"
	// But while Editing, Edit Flag is Set
	// Using this condition the Window is made to show "Edit"
	// Also Disable User Name Window	while "Edit"

	if (m_bActionEdit)	
	{
		SubHeadingPointer = strchr (CurrentHeading, (int) '(') ;
		SubHeadingPointer ++ ;
		*SubHeadingPointer = 0x00 ;
		strcat (CurrentHeading, "Edit)") ;

		m_UserNameEditWnd.EnableWindow (FALSE) ;
	}

	// Change to Product Name
	ModifyHeader (CurrentHeading, WindowHeader) ;
	SetWindowText (WindowHeader) ;

	// Limit the Text Length in the Edit windows
	m_UserNameEditWnd.LimitText (USER_NAME_LEN - 1) ;
	m_UserPasswordWnd.LimitText (USER_PASSWORD_LEN - 1) ; 

	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
// 	CUserDlg *pParent = (CUserDlg *) GetParent() ;

	USERDATA *pUserData ;

	if (m_bActionEdit)
	{	char UserGroup[100],uname[40],gname[40],Groupname[40],tmpGroupname[40];
		int cindex=0,setindex=0;
		int nSelUserIndex = pParent->m_UserDlg->m_LBoxForUserName.GetCurSel() ;
      		pParent->m_UserDlg->m_LBoxForUserName.GetText(nSelUserIndex,UserGroup);
 		sscanf(UserGroup,"%s\t%s",uname,gname);
		int countindex = m_ctrl_combo_group.GetCount();
		sprintf(tmpGroupname,"%d",countindex);

		// Get the Pointer to User Structure
		pUserData = (USERDATA *)
				  pParent->m_UserDlg->m_LBoxForUserName.GetItemDataPtr (nSelUserIndex) ;

		//Added by Sreelu - If Edit Enable Account Lockout Policy & Account Status fields
		m_AcntStatusCtrl.EnableWindow(TRUE);
		m_ctrl_combo_account.EnableWindow(TRUE);
		if(pUserData->Defaulter)
		{
			m_AcntLockCtrl.EnableWindow(TRUE);
			m_ctrl_combo_defaulter.EnableWindow(TRUE);		
		}
		else
		{
			m_AcntLockCtrl.EnableWindow(FALSE);
			m_ctrl_combo_defaulter.EnableWindow(FALSE);		
		}

		// Assign Class Data members with data members of Data Structure
	       //	m_ctrl_combo_group.SetCurSel(setindex);

		FillClassFields (pUserData) ; 
	       //	m_ctrl_combo_group.SetCurSel(nSelUserIndex);
		m_ReconfirmPassword.SetFocus();
		m_UserPasswordWnd.SetFocus() ;
	       	
		UpdateData(FALSE);
		for(cindex = 0; cindex < countindex; cindex++)
		{
			if(m_ctrl_combo_group.GetLBText(cindex,Groupname) != LB_ERR)
			{
				if(!strcmp(gname,Groupname))
				{
					char INdex[5];
					setindex = m_ctrl_combo_group.GetCurSel();
					sprintf(INdex,"%d",cindex);
					
					m_ctrl_combo_group.SetCurSel(cindex);
					return FALSE;
				}
			}		
		}
	}
	else
	{
		m_UserNameEditWnd.SetFocus() ;
		
			//Added by Sreelu - If !Edit Disable Account Lockout Policy & Account Status fields
		m_AcntStatusCtrl.EnableWindow(FALSE);
		m_ctrl_combo_account.EnableWindow(FALSE);
		m_AcntLockCtrl.EnableWindow(FALSE);
		m_ctrl_combo_defaulter.EnableWindow(FALSE);		
	}

	// Fill all the control windows with data
	UpdateData (FALSE) ;

	return FALSE ;  // return TRUE  unless you set the focus to a control
      
      
      // return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUserAddDlg::FillClassFields (USERDATA *pUser) 
{
 	
	char tmpGroupname[40];
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	CUserDlg *pParent = (CUserDlg *) GetParent() ;
	
  	m_szUserPassword = pUser->UserPassword ;
  	m_szReconfirmPassword = pUser->UserPassword;
	m_szUserName = pUser->UserName ;
  	strcpy(tmpGroupname,pUser->GroupName);
	m_ctrl_combo_defaulter.SetCurSel(pUser->Defaulter);
	if(pUser->Account == TRUE)
		m_ctrl_combo_account.SetCurSel(0);
	else
		m_ctrl_combo_account.SetCurSel(1);
		
	return ;
}


void CUserAddDlg::OnOK()
{
	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

	if (!m_bActionEdit)
	{
		// Check for Empty User Name
		if (!ValidUserName())
		{
			MessageBox ((LPCSTR) "Invalid User name",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
			m_UserNameEditWnd.SetFocus() ;
			return ;
		}

		// duplicate User not allowed
		if (DuplicateUserName())
		{
			MessageBox ((LPCSTR) "Duplicate user name",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
			m_UserNameEditWnd.SetFocus() ;
			return ;
		}
	
	}
	
	if(ValidPassword())
	{
		PostMessage (WM_COMMAND, IDCANCEL) ;
	 
		return;
	}

	// In case of insufficient memory
	if (!FillStructureFields())
	{
		PostMessage (WM_COMMAND, IDCANCEL) ;
		return ; 
	}
#if 0
	if(strcmp(m_szUserPassword,m_szReconfirmPassword)!=0)
	{
		MessageBox ((LPCSTR) "Both the passwords should be same.",
		(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
		
	       
	}

#endif	
	m_DBChanged = TRUE;
	CDialog::OnOK();
}


BOOL CUserAddDlg::ValidUserName()
{
	int nLength ;

	nLength = m_szUserName.GetLength() ;

	// If user name is empty 
	if (nLength == 0)
	{	
/*		AfxMessageBox("Fail");*/
		return FALSE ;
	}
	// First strip off leading blanks
	char c ;
	int i ;
	
	for (i = 0 ; i < nLength ; )
	{
		c = m_szUserName.GetAt (i) ;
		if (c != ' ')
			break ;
		i ++ ;
	}

	// If only blanks
	if (i == nLength)
		return FALSE ;

	// The new user name without leading blanks
	char szName[USER_NAME_LEN] ;
	strcpy (szName, (LPCSTR) m_szUserName) ;
	m_szUserName = szName +	i ;

	strcpy (szName, (LPCSTR) m_szUserName) ;
	nLength = m_szUserName.GetLength() ;

	// Track the trailing blanks
	char *pszName = szName + nLength - 1 ;
	while (*pszName == ' ')
		pszName -- ;
	*(pszName + 1) = 0x00 ;

	// User name without trailing blanks
	m_szUserName = szName ;
	nLength = m_szUserName.GetLength() ;

	// No blanks in the name allowed
	for (i = 0 ; i < nLength ; i ++)
	{
		c = m_szUserName.GetAt (i) ;
		if (c == ' ')
			return FALSE ;
	}
	return TRUE ;
}		


BOOL CUserAddDlg::ValidPassword()
{
	if(strcmp(m_szUserPassword,m_szReconfirmPassword)!=0)
	{
		MessageBox ((LPCSTR) "Both the passwords should be same.",
		(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
		 return TRUE;	       
	}
	else
	return FALSE;

}
BOOL CUserAddDlg::DuplicateUserName (void)
{
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	CUserDlg *pParent = (CUserDlg *) GetParent() ;
	if (pParent->m_UserDlg->m_LBoxForUserName.FindStringExact (-1, m_szUserName)
																					!= LB_ERR)
		return TRUE ;

	return FALSE ;
}

BOOL CUserAddDlg::FillStructureFields (void) 
{
	USERDATA *pUserData ;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
// 	CUserDlg *pParent = (CUserDlg *) GetParent() ;
  //	CGroupAddDlg *gParent = (CGroupAddDlg *) GetParent() ;

	if (m_bActionEdit)
	{
	 	int nSelUserIndex = pParent->m_UserDlg->m_LBoxForUserName.GetCurSel() ;
		// Get the Pointer to User Structure
	 	pUserData = (USERDATA *)
		  pParent->m_UserDlg->m_LBoxForUserName.GetItemDataPtr (nSelUserIndex) ;

		pParent->m_UserDlg->m_LBoxForUserName.DeleteString (nSelUserIndex) ;

		char defaulter[15];
		char account[10];
		char userstring[100];
		char Groupname[40];
		char tmpGroupname[40];
		int i,j,index,nLength;
 	       
		i = m_ctrl_combo_defaulter.GetCurSel();
		
		if(i == 0)
		{ 
		 
		strcpy(defaulter,"None");
		} 
		 else if(i == 1)
		 {
		 	strcpy(defaulter,"Login");
		 }
		else if(i == 2)
		{ 
			strcpy(defaulter,"BlackList");
		}
		j = m_ctrl_combo_account.GetCurSel();
		
		if(j == 0) 
		 strcpy(account,"Enable");
	 	else
		 strcpy(account,"Disable");
		
		index = m_ctrl_combo_group.GetCurSel();
		m_ctrl_combo_group.GetLBText(index,Groupname);
		sscanf(Groupname,"%s",tmpGroupname);
		nLength = strlen(tmpGroupname);
		
		if(nLength==0)
		{
			AfxMessageBox("Enter GroupName");
			return TRUE;
		}
		
		wsprintf(userstring,  "%s\t%s", (LPCSTR)m_szUserName, tmpGroupname); 
		int nIndex = pParent->m_UserDlg->m_LBoxForUserName.AddString (userstring) ;
	       	pParent->m_UserDlg->m_LBoxForUserName.SetItemDataPtr (nIndex, pUserData) ;
		
		lstrcpy ((LPSTR) pUserData->UserName, (LPCSTR) m_szUserName) ;
		lstrcpy ((LPSTR) pUserData->UserPassword, (LPCSTR) m_szUserPassword) ;
		
		pUserData->Defaulter = m_ctrl_combo_defaulter.GetCurSel();

		if( m_ctrl_combo_account.GetCurSel()==0)
			pUserData->Account = TRUE;
		else
			pUserData->Account = FALSE;

		lstrcpy ((LPSTR) pUserData->GroupName,tmpGroupname) ;

		pParent->m_UserDlg->m_LBoxForUserName.SetCurSel(nSelUserIndex) ;
//		m_ctrl_combo_group.SetCurSel(nSelUserIndex) ;
	}
	else
	{
		pUserData = (USERDATA *) new USERDATA ;
		if (pUserData == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
		
		char userstring[100];
		char defaulter[15];
		char account[10];
		char Groupname[40];
		char tmpGroupname[40];
		char tmpGroupName[GROUP_NAME_LEN],tmpUsername[USER_NAME_LEN];
		char tmpDefaulter[15],tmpAccount[10];      	
		char UsGrDeAc[GROUP_NAME_LEN + USER_NAME_LEN + 10 + 15 ] ;
		int uindex=0;
		int i,j,index,count,nLength;
		
		i = m_ctrl_combo_defaulter.GetCurSel();
		
		if(i == 0)
		 strcpy(defaulter,"None");
		else if(i == 1)
		 strcpy(defaulter,"Login");
		else if(i == 2)
		 strcpy(defaulter,"BlackList");
		
		j = m_ctrl_combo_account.GetCurSel();
		
		if(j == 0) 
		 strcpy(account,"Enable");
	 	else
		 strcpy(account,"Disable");
	 	
		index = m_ctrl_combo_group.GetCurSel();
		m_ctrl_combo_group.GetLBText(index,Groupname);
		sscanf(Groupname,"%s",tmpGroupname);
//		m_ctrl_combo_group.SetCurSel(index);//New on 31 may
		nLength = strlen(tmpGroupname);
		count = pParent->m_UserDlg->m_LBoxForUserName.GetCount();
		if(count == 0)
		{
			
			if(nLength==0)
			{
				AfxMessageBox("Enter GroupName");
				return TRUE;
			}
			wsprintf(userstring,  "%s\t%s", (LPCSTR)m_szUserName, tmpGroupname); 
			int nIndex = pParent->m_UserDlg->m_LBoxForUserName.AddString (userstring) ;
	        	pParent->m_UserDlg->m_LBoxForUserName.SetItemDataPtr (nIndex, pUserData) ;
		        pParent->m_UserDlg->m_LBoxForUserName.SetCurSel(nIndex);
		}
		else
		{	BOOL duplicate = FALSE;
			
			while(1)
			{
				if (pParent->m_UserDlg->m_LBoxForUserName.GetText(uindex++,UsGrDeAc) != LB_ERR)
				{
					sscanf(UsGrDeAc,"%s\t%s",tmpUsername,tmpGroupName);
					if(!strcmpi(tmpUsername,m_szUserName))
					{
						MessageBox ((LPCSTR) "This user already Exist\nCan't add duplicate user.",
						(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
						duplicate = TRUE;
					}
				}
				else
				{
					if(duplicate == FALSE)
					{
						if(nLength==0)
						{
							AfxMessageBox("Enter GroupName");
							return TRUE;
						}
						
			    				
						wsprintf(userstring,  "%s\t%s", (LPCSTR)m_szUserName, tmpGroupname); 
						int nIndex = pParent->m_UserDlg->m_LBoxForUserName.AddString (userstring) ;
				        	pParent->m_UserDlg->m_LBoxForUserName.SetItemDataPtr (nIndex, pUserData) ;
					        pParent->m_UserDlg->m_LBoxForUserName.SetCurSel(nIndex);
						
					}
					
					break;
				}
			}
		}		
	lstrcpy ((LPSTR) pUserData->UserName, (LPCSTR) m_szUserName) ;
	lstrcpy ((LPSTR) pUserData->UserPassword, (LPCSTR) m_szUserPassword) ;
       
	pUserData->Defaulter = m_ctrl_combo_defaulter.GetCurSel();
	if( m_ctrl_combo_account.GetCurSel()==0)
		pUserData->Account = TRUE;
	else
		pUserData->Account = FALSE;

       //	 pUserData->Account = m_ctrl_combo_account.GetCurSel();
	lstrcpy ((LPSTR) pUserData->GroupName,tmpGroupname) ;
	
		
	}

	return TRUE ;
}


void CUserAddDlg::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_USER_ADD_OR_EDIT, HELP_CONTEXT);
}
