#ifndef __USERDATA_H__

#define __USERDATA_H__

#define MAX_NUM_OF_USERS 1024

#define UDB_HDR_FILE "UDB.HDR"

#define VERSION2 "v2.00"
#define UDB_VERSION VERSION2		// uncompressed version 12/06/97 vidy
#define VERSION1 "VERSION 1"		// it could be "v1.00" or "" also



#define USER_NAME_LEN (39 + 1)
#define USER_PASSWORD_LEN (7 + 1)
#define USER_CALL_BACK_NUM_LEN (39 + 1)
#define USER_RESERVED 9

typedef struct {
	char UserName[USER_NAME_LEN] ;
 	char UserPassword[USER_PASSWORD_LEN] ;
	DWORD DialInPortMask ;
	DWORD DialOutPortMask ;
	BYTE ProtocolMask ;
	BYTE CallBackSecurity ;
	char CallBackNumber[USER_CALL_BACK_NUM_LEN] ;
	UINT CallBackDelay ;
	BYTE CallBackEnabled ;
	BYTE Reserved[USER_RESERVED] ;
} USERDATA ;

// ProtocolMask ---------- 7  6  5  4  3  2  1  0
//										  |	 |	|
//										  |	 |	|
//										  |	 |	\ 
//										  |	 |	 IP
//										  |	 |
//	 									  |	 \ 
//										  |	  IPX
//										  |
//										  \ 
//										   Spanning Tree	



// DialInPortMask --------- .................2  1  0  
//											 |	|  |  
//											 |	|  |  
//											 |	|  |  
//											 |	|  |  
//											 |	|  |
//											 |	|  \ 
//											 |	|  	WAN Port1
//											 |	|
//											 |	\ 
//											 | 	 WAN Port2
// 											 |
//											 \ 
//											  WAN Port3
//						    .................


// DialOutPortMask --------- Same As DialInPortMask

#endif

