// userdlg.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "userdlg.h"
#include "procon.h"
#include "usrdata.h"
#include "useraddd.h"
#include "groupadd.h"
#include "filterin.h"
#include "userfilt.h"

#include "stdio.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

FILE *rFile,*wFile;
USERDATABASE *pUserData;
USHORT number_of_group_profiles;
USHORT number_of_user_profiles;
USHORT number_of_filter_profiles;

extern TEMP_GROUPDATA *sptr_group_data;
extern int NumOfFilter;
extern int NumOfGroups;
extern int MyID;
extern USHORT NumOfDomainName;
extern BOOL m_DBChanged;

static LPCSTR CheckUserMsgHdr = "UserDatabase Check";
/////////////////////////////////////////////////////////////////////////////
// CUserDlg dialog


CUserDlg::CUserDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUserDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUserDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_DBChanged = FALSE;
	m_szNumGroups = "";
	m_szNumUsers = "";
	//}}AFX_DATA_INIT
	Create (IDD, NULL);
}

void CUserDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUserDlg)
	DDX_Control(pDX, IDC_BTN_FILTER, m_FilterWnd);
	DDX_Control(pDX, IDC_LIST2, m_LBoxForGroupName);
	DDX_Control(pDX, IDC_LIST1, m_LBoxForUserName);
	DDX_Text(pDX, IDC_STATIC_NUM_GROUPS, m_szNumGroups);
	DDX_Text(pDX, IDC_STATIC_NUM_USERS, m_szNumUsers);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUserDlg, CDialog)
	//{{AFX_MSG_MAP(CUserDlg)
	ON_BN_CLICKED(IDC_UESR_EDIT, OnUesrEdit)
	ON_BN_CLICKED(IDC_USER_ADD, OnUserAdd)
	ON_BN_CLICKED(IDC_GROUP_ADD, OnGroupAdd)
	ON_BN_CLICKED(IDC_GROUP_EDIT, OnGroupEdit)
	ON_BN_CLICKED(IDC_GROUP_DELETE, OnGroupDelete)
	ON_BN_CLICKED(IDC_USER_DELETE, OnUserDelete)
	ON_BN_CLICKED(IDC_BTN_FILTER, OnBtnFilter)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDOK, OnOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CUserDlg message handlers

void CUserDlg::OnUesrEdit()
{
	// TODO: Add your control notification handler code here
	// Get which User is currently selected
	
	int nIndex = m_LBoxForUserName.GetCurSel() ;

	// If no User is selected return 
	if (nIndex == LB_ERR)
		return ;

	CUserAddDlg CUserEdit (this) ;
       	CUserEdit.m_bActionEdit = TRUE ;
	
	int nRetVal = CUserEdit.DoModal() ;
	if (nRetVal == IDCANCEL)
      		return ;
       
	// Update the number of Users
  	ShowNumberOfUsers() ;
		
	// Update all controls in the Window
	UpdateData (FALSE) ;
	return ;
}

void CUserDlg::OnUserAdd()
{
	int nNumUsers = m_LBoxForUserName.GetCount() ;
	if (nNumUsers == MAX_NUM_OF_USERS)
 		return ;
	
	int count=m_LBoxForGroupName.GetCount();
	if(count==0)
	{
		MessageBox ((LPCSTR) "You Can't Add the user As there is no group",
		(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
		return;
	}

	CUserAddDlg CUserAdd (this) ;
	CUserAdd.m_bActionEdit = FALSE ;
	CUserAdd.DoModal() ;
  	ShowNumberOfUsers() ;
			
	UpdateData (FALSE) ;
	return ;
}

void CUserDlg::OnGroupAdd()
{
	int nNumUsers = m_LBoxForGroupName.GetCount() ;
	if (nNumUsers >= MAX_NUM_OF_GROUPS)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Can't Add More than 25 Groups",
			(LPCSTR) CheckUserMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
 		return ;
	}
	
	CGroupAddDlg CGroupAdd (this) ;
	CGroupAdd.m_gActionEdit = FALSE ;
	CGroupAdd.DoModal() ;
  	ShowNumberOfGroups();

  	UpdateData (FALSE) ;
	return ;
}

void CUserDlg::OnGroupEdit()
{
	// Get which Group is currently selected
	int nIndex = m_LBoxForGroupName.GetCurSel() ;

	// If no Group is selected return 
	if (nIndex == LB_ERR)
		return ;

	CGroupAddDlg CGroupEdit (this) ;
       	CGroupEdit.m_gActionEdit = TRUE ;
	
	int nRetVal = CGroupEdit.DoModal() ;
	if (nRetVal == IDCANCEL)
		return ;
       
   // Update all controls in the Window
  	ShowNumberOfGroups();
       
	UpdateData (FALSE) ;
	return ;
}

BOOL CUserDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80] ;

	GetWindowText (CurrentHeading, 80) ;
	ModifyHeader (CurrentHeading, WindowHeader) ;
	SetWindowText (WindowHeader) ;

	m_LBoxForUserName.ResetContent() ;
	m_LBoxForGroupName.ResetContent() ;
	
	int TabStops[] = {210};
       	m_LBoxForGroupName.SetTabStops(1, (LPINT)&TabStops);
	m_LBoxForUserName.SetTabStops(1, (LPINT)&TabStops);

	//set bitmaps

	if (!AddUserBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddUserBmpBtn.SubclassDlgItem (IDC_USER_ADD, this));
	AddUserBmpBtn.SizeToContent();

	if (!DeleteUserBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteUserBmpBtn.SubclassDlgItem (IDC_USER_DELETE, this));
	DeleteUserBmpBtn.SizeToContent();

	if (!EditUserBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditUserBmpBtn.SubclassDlgItem (IDC_UESR_EDIT, this));
	EditUserBmpBtn.SizeToContent();

	if (!AddGroupBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddGroupBmpBtn.SubclassDlgItem (IDC_GROUP_ADD, this));
	AddGroupBmpBtn.SizeToContent();

	if (!DeleteGroupBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteGroupBmpBtn.SubclassDlgItem (IDC_GROUP_DELETE, this));
	DeleteGroupBmpBtn.SizeToContent();

	if (!EditGroupBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditGroupBmpBtn.SubclassDlgItem (IDC_GROUP_EDIT, this));
	EditGroupBmpBtn.SizeToContent();

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!FilterBmpBtn.LoadBitmaps ("FILT1", "FILT2", "FILT3", "FILT4"))
		AfxMessageBox ("Failed to load FILTER bitmap");

	VERIFY (FilterBmpBtn.SubclassDlgItem (IDC_BTN_FILTER, this));
	FilterBmpBtn.SizeToContent();

#if Ravi			
	// Delete the Uncompressed file
	rFile = fopen (UDBUnCompressedDBaseFile, "wb") ;
	fclose (rFile) ;
	remove (UDBUnCompressedDBaseFile) ;
#endif
  	ShowNumberOfGroups();
  	ShowNumberOfUsers();
			
	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUserDlg::OnGroupDelete()
{
	// TODO: Add your control notification handler code here
	// Get which Group is currently selected
	int nIndex = m_LBoxForGroupName.GetCurSel() ;

	// If no Group is selected return 
	if (nIndex == LB_ERR)
		return ;

	// If some Group was selected Confirm whether Deletion should proceed
	int nRetVal = MessageBox (
			(LPCSTR) "All the users associated with this group will be deleted.\nDo you really want to delete selected group ?",
						(LPCSTR) "Group - Delete",
								MB_YESNO | MB_ICONQUESTION) ;

	// If Deletion cancelled return
	if (nRetVal == IDNO)
		return ;

	// If to Delete free the memory occupied by the 
	// User data structure to HEAP
	int index=0,count, DeletedGroup;

	//Check if Any user is Associated with the selected group or not
	char tmpGroupname[GROUP_NAME_LEN],tmpGroupdesc[GROUP_DESC_LEN];
	char NameDesc[GROUP_NAME_LEN +GROUP_DESC_LEN ] ;	
	char tmpGroupName[GROUP_NAME_LEN],tmpUsername[USER_NAME_LEN];
	char tmpDefaulter[15],tmpAccount[10];      	
	char UsGrDeAc[GROUP_NAME_LEN + USER_NAME_LEN + 10 + 15 ] ;

	m_LBoxForGroupName.GetText(nIndex,NameDesc); 
	sscanf(NameDesc,"%s\t\t\t\t\t%s",tmpGroupname,tmpGroupdesc);

	count = m_LBoxForUserName.GetCount();
	GROUPDATA *pGroupData = (GROUPDATA *)
		m_LBoxForGroupName.GetItemDataPtr (nIndex) ;
	if(count == 0)
	{
		DeletedGroup = pGroupData->GroupNo;
		delete pGroupData ;
		m_LBoxForGroupName.DeleteString(nIndex);
	}
	else
	{     
		 int cindex;
		 int ind = 0;
		 for (ind=0,cindex = 0; cindex < count; cindex++)
		 {	
		 	if (m_LBoxForUserName.GetText(ind,UsGrDeAc) != LB_ERR)
			{	
				sscanf(UsGrDeAc,"%s\t\t%s\t\t%s\t\t%s",tmpUsername,tmpGroupName,tmpAccount,tmpDefaulter);
				if(!strcmp(tmpGroupname,tmpGroupName))
				{
					USERDATA *pUserData = (USERDATA *)
					m_LBoxForUserName.GetItemDataPtr (ind) ;
					delete pUserData ;
					m_LBoxForUserName.DeleteString(ind);
				}
				else
				{
					ind++;
				}
			}
		}	
		m_LBoxForGroupName.DeleteString(nIndex);
		DeletedGroup = pGroupData->GroupNo;
		delete pGroupData ;
	}
			
// Added by Sreelu For Filters.....
	count = m_LBoxForGroupName.GetCount();
	for(int i = 0; i < count; i++)
	{
		GROUPDATA *pGroupData = (GROUPDATA *) m_LBoxForGroupName.GetItemDataPtr (i) ;
		pGroupData->GroupNo = i + 1;
	}				
//	CFilter filter;
//	filter.ChangeFilterMasks(DeletedGroup);
	ChangeFilterMasks(DeletedGroup);
//.... Added by Sreelu For Filters
	number_of_group_profiles--;
  	m_DBChanged = TRUE ;
	
	// Update all controls in the Window
       	ShowNumberOfUsers() ;
  	ShowNumberOfGroups();
	m_LBoxForGroupName.SetCurSel(nIndex);

	UpdateData (FALSE) ;
	return ;
}

void CUserDlg::OnUserDelete()
{
	// TODO: Add your control notification handler code here
	
	// Get which User is currently selected
	int nIndex = m_LBoxForUserName.GetCurSel() ;

	// If no User is selected return 
	if (nIndex == LB_ERR)
		return ;

	// If some User was selected Confirm whether Deletion should proceed
	int nRetVal = MessageBox (
			(LPCSTR) "Do you really want to delete selected user ?",
						(LPCSTR) "Users - Delete",
								MB_YESNO | MB_ICONQUESTION) ;

	// If Deletion cancelled return
	if (nRetVal == IDNO)
		return ;

	// If to Delete free the memory occupied by the 
	// User data structure to HEAP
	USERDATA *pUserData = (USERDATA *)
	m_LBoxForUserName.GetItemDataPtr (nIndex) ;
	delete pUserData ;

	// Remove the User name from the List Box
	m_LBoxForUserName.DeleteString (nIndex) ;

  	m_DBChanged = TRUE ;
	number_of_user_profiles--;
	
	// Update all controls in the Window
  	ShowNumberOfUsers() ;
	m_LBoxForUserName.SetCurSel(nIndex);

	UpdateData (FALSE) ;
	return ;
}

void CUserDlg::OnOk()
{
//	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

void CUserDlg::OnBtnFilter()
{
	int gIndex;
	char string[50];
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	GROUPDATA *pGProfile;
	TEMP_GROUPDATA *temp_group_data;
	NumOfGroups = m_LBoxForGroupName.GetCount();
	free(sptr_group_data);
	sptr_group_data = (TEMP_GROUPDATA *) calloc(NumOfGroups, sizeof(GROUPDATA));
	temp_group_data = sptr_group_data;
	for(int i=0; i<NumOfGroups; i++)
	{
		pGProfile = (GROUPDATA *) m_LBoxForGroupName.GetItemDataPtr(i);
		strcpy(temp_group_data->GroupName, pGProfile->GroupName);
		pGProfile->GroupNo = i + 1;
		temp_group_data->GroupNo = i + 1;
		temp_group_data->Count = 0;
		int FilterNo = pParent->m_Filter->m_ListCtrl.GetCount();
		for(int j = 0; j < FilterNo; j++)
		{
			FILTER_DATA *pFilter = (FILTER_DATA *)  pParent->m_Filter->m_ListCtrl.GetItemDataPtr (j);
			FilterIn filter;
			if (filter.IsGroupSet(temp_group_data, pFilter))
				temp_group_data->Count++;
		}
		temp_group_data->FilterAction = pGProfile->Allow_Sites;
		temp_group_data++;
	}
	FilterIn  filter(this);
	if(IDCANCEL == filter.DoModal())
	{
		PostQuitMessage (0);
		return;
	}
	return;
}

WORD CUserDlg::SwapWord (WORD IntelMotorola)
{
	WORD TempWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 0) ;

	return TempWord ;
}

DWORD CUserDlg::SwapDWord (DWORD IntelMotorola)
{
	DWORD TempDWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempDWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 3) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 2) ;
	*(TempPtrDest + 2) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 3) = *(TempPtrSrc + 0) ;

	return TempDWord ;
}

void CUserDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);	
}


void CUserDlg::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_USER_LIST_DIALOG, HELP_CONTEXT);
}

void CUserDlg::ShowNumberOfUsers()
{
	char szNum[10] ;
	itoa (m_LBoxForUserName.GetCount(), szNum, 10) ;
	m_szNumUsers = szNum ;
	UpdateData (FALSE) ;
	return ;
}
void CUserDlg::ShowNumberOfGroups()
{
	char szNum[10] ;
	itoa (m_LBoxForGroupName.GetCount(), szNum, 10) ;
	m_szNumGroups = szNum ;
	UpdateData (FALSE) ;
	return ;
}

LRESULT CUserDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CUserDlg::PostNcDestroy(void)
{
	delete this;
}

void CUserDlg::ChangeFilterMasks(int GroupNo)
{
	int i;
	FILTER_DATA *pFilterProfile;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	ULONG MASK = 0xffffffff;
	ULONG GROUP_MASK_ENABLE = 0x00000001;
	ULONG group_mask1, group_mask2 = 0x00000000L, group_mask;
	group_mask1 = MASK << GroupNo;
	for (i = 0; i < GroupNo-1; i++)
	{
		group_mask = GROUP_MASK_ENABLE << i;
		group_mask2 |= group_mask;
	}		

   NumOfFilter = pParent->m_Filter->m_ListCtrl.GetCount();
	for(i = 0; i < NumOfFilter; i++)
	{
		ULONG Result1, Result2;
		pFilterProfile = (FILTER_DATA *) pParent->m_Filter->m_ListCtrl.GetItemDataPtr(i);

		Result1 = group_mask1;		
		Result2 = group_mask2;		

		Result1 &= pFilterProfile->mask;
		Result1 = Result1 >> 1;
		Result2 &= pFilterProfile->mask;
		pFilterProfile->mask = Result1 | Result2;
	}
}
