// userfilt.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "userfilt.h"
#include "filterin.h"
#include "userdlg.h"
#include "authrnge.h"	

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

FILTER_DATA *sptr_filter_data;
extern TEMP_GROUPDATA *sptr_group_data;	
extern FILE *rFile,*wFile;
extern int NumOfFilter;
extern USHORT NumOfDomainName;
extern USERDATABASE *pUserData;
extern USHORT number_of_group_profiles;
extern USHORT number_of_user_profiles;
extern USHORT number_of_filter_profiles;
USHORT number_of_ip_address;
USHORT number_of_application;
BOOL m_DBChanged;
/////////////////////////////////////////////////////////////////////////////
// UserFilterTab dialog


UserFilterTab::UserFilterTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(UserFilterTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(UserFilterTab)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	tabcount = 4;
	m_Filter = new CFilter (this);
	m_UserDlg = new CUserDlg (this);
	m_Default = new Authrnge (this);
}

void UserFilterTab::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(UserFilterTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(UserFilterTab, CTabDialog)
	//{{AFX_MSG_MAP(UserFilterTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// UserFilterTab message handlers

BOOL UserFilterTab::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;
	
	// TODO: Add extra initialization here
	m_DBChanged = FALSE;
	addTabView (m_Filter, "Filter", TRUE, TRUE, 100);
	addTabView (m_UserDlg, "User Management", TRUE, FALSE, 130);
	addTabView (m_Default, "Access Rights", TRUE, FALSE, 100);

	int flag = 0;
//	USERDATABASE *pUserData;
	pUserData = (USERDATABASE *) new USERDATABASE ;
	if (pUserData == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "Users List", MB_OK | MB_ICONSTOP) ;
		return TRUE ;
	}

	rFile = fopen (UDBUnCompressedDBaseFile, "rb") ;

	if (rFile != NULL)
	{
		while (1)
		{
			if (fread (pUserData, sizeof (USERDATABASE), 1, rFile) == 1)
			{
				pUserData->magic_id	= SwapWord (pUserData->magic_id);
				pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
				pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);

				switch (pUserData->magic_id)
				{
					case IP_PROFILE :
						  flag = 1;	
						  ReadIPConfiguration ();
						  break;

					case APP_PROFILE :
						  ReadAPPConfiguration ();
						  break;
	
					case GROUP_PROFILE :
						  GroupProfile ();
						  break;	
																
					case USER_PROFILE :
						  UserProfile ();
						  break;

					case FILTER_PROFILE :
						  NumOfFilter = pUserData->number_of_items;
						  FilterProfile ();
						  break;

					case DEFAULT_FILTER :
						  break;

					default     :	break;
				}
			}
			else 
				break;
	
#if Ravi
			if(!flag)
			{
				UpgradeDbaseYes();
				fseek(rFile, 0, SEEK_SET);
			}
			else
				break ;
#endif

			pUserData = (USERDATABASE *) new USERDATABASE ;
		}
	}
	delete pUserData ;
	fclose (rFile) ;

	if(!flag)
	{
		m_Filter->m_BlockWnd.SetCheck(1);
		m_Filter->m_AllowWnd.SetCheck(0);
		enableView (1, FALSE);
		enableView (2, FALSE);
	}


	int count = m_Filter->m_ListCtrl.GetCount();
	if(!count)
		m_UserDlg->m_FilterWnd.EnableWindow (FALSE);

	AfxGetApp()->DoWaitCursor(0) ;
   CTabDialog::OnInitDialog() ;
	
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void UserFilterTab::OnOK()
{
	if (!UpdateData (TRUE))
		return ;

	int nRetVal ;
	char szMessage[100];
	FILTER_DATA *ptr_filter_data;

	if (m_DBChanged)
		strcpy (szMessage, "") ;
	else
		strcpy (szMessage, "User Data Base not changed.\n") ;

	strcat (szMessage, "Do you want to Download DataBase ?") ;

	nRetVal = MessageBox ((LPCSTR) szMessage,
			(LPCSTR) "Users List", MB_YESNO | MB_ICONQUESTION) ;

	if (nRetVal == IDNO)
		return ;
		
	fclose (rFile) ;
	wFile = fopen (UDBUnCompressedDBaseFile, "wb") ;
	fclose (wFile) ;
	remove (UDBUnCompressedDBaseFile) ;

	wFile = fopen (UDBUnCompressedDBaseFile, "wb") ;

	int nNumOfGroups = m_UserDlg->m_LBoxForGroupName.GetCount();
	int nNumOfUsers = m_UserDlg->m_LBoxForUserName.GetCount();
   NumOfFilter = m_Filter->m_ListCtrl.GetCount();
	int nNumOFIP = m_Default->m_IPAddListCtrl.GetCount();
	int nNumOFAPP = m_Default->m_AppListCtrl.GetCount();
	NumOfDomainName = 0;
	for(int Index = 0; Index < NumOfFilter; Index++)
	{
		FILTER_DATA *pFildata = (FILTER_DATA *) m_Filter->m_ListCtrl.GetItemDataPtr(Index);
		if(pFildata->type == DOMAIN_NAME)
			NumOfDomainName++;
	}


// Writing IP That Needs No Authentication
	USERDATABASE *pUserData = (USERDATABASE *) new USERDATABASE;
	pUserData->magic_id = IP_PROFILE;
	pUserData->number_of_items = nNumOFIP;
	pUserData->length_of_items = nNumOFIP * sizeof(IPDEFAULTS);

	pUserData->magic_id	= SwapWord (pUserData->magic_id);
	pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
	pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;
	delete pUserData;

// Writing USER_INFO
	USER_INFO *info;
	info = (USER_INFO *) malloc(sizeof(USER_INFO));
	if(m_Filter->m_UDBEnabled.GetCheck())
		info->enabled = TRUE;
	else
		info->enabled = FALSE;

	if(m_Filter->m_AllowWnd.GetCheck())
		info->default_action = FILTER;

	if(m_Filter->m_BlockWnd.GetCheck())
		info->default_action = FORWARD;

	info->enabled = SwapWord(info->enabled);
	info->default_action = SwapWord(info->default_action);
	fwrite (info, sizeof (USER_INFO), 1, wFile) ;
	free (info);

	IPDEFAULTS *pIPDefault;
	int IPIndex;

	for (IPIndex = 0; IPIndex < nNumOFIP; IPIndex++)
	{
		pIPDefault = (IPDEFAULTS *) m_Default->m_IPAddListCtrl.GetItemDataPtr (IPIndex);
		fwrite (pIPDefault, sizeof (IPDEFAULTS), 1, wFile) ;
		free (pIPDefault);
	}

// Writing APP That Needs No Authentication
	pUserData = (USERDATABASE *) new USERDATABASE;
	pUserData->magic_id = APP_PROFILE;
	pUserData->number_of_items = nNumOFAPP;
	pUserData->length_of_items = nNumOFAPP * sizeof(APPDEFAULTS);

	pUserData->magic_id	= SwapWord (pUserData->magic_id);
	pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
	pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;
	delete pUserData;

	APPDEFAULTS *pAPPDefault;
	int APPindex;

	for (APPindex = 0; APPindex < nNumOFAPP; APPindex++)
	{
		pAPPDefault = (APPDEFAULTS *) m_Default->m_AppListCtrl.GetItemDataPtr (APPindex);
		pAPPDefault->lower_port = SwapWord (pAPPDefault->lower_port);
		pAPPDefault->upper_port = SwapWord (pAPPDefault->upper_port);
		pAPPDefault->protocol = SwapWord (pAPPDefault->protocol);
		fwrite (pAPPDefault, sizeof (APPDEFAULTS), 1, wFile) ;
		free (pAPPDefault);
	}

// Writing Group Database
	pUserData = (USERDATABASE *) new USERDATABASE;

	pUserData->magic_id = GROUP_PROFILE;
	pUserData->number_of_items = nNumOfGroups;
	pUserData->length_of_items = nNumOfGroups * sizeof(GROUPDATA);

	pUserData->magic_id	= SwapWord (pUserData->magic_id);
	pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
	pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;
	delete pUserData;

	GROUPDATA *pGroupProfile;
	
	for (Index = 0 ; Index < nNumOfGroups ; Index ++)
	{
		pGroupProfile = (GROUPDATA *) m_UserDlg->m_LBoxForGroupName.GetItemDataPtr (Index) ;
			pGroupProfile->GroupNo = Index + 1;	// Added by Sreelu
		
			pGroupProfile->Defaulter_Login_Attempts = SwapWord(pGroupProfile->Defaulter_Login_Attempts);
		  	pGroupProfile->Defaulter_Number_Of_Login_Attempts = SwapWord(pGroupProfile->Defaulter_Number_Of_Login_Attempts);
			pGroupProfile->Defaulter_BlackListed_Sites = SwapWord(pGroupProfile->Defaulter_BlackListed_Sites);
			pGroupProfile->Defaulter_Number_Of_Attempts_Of_BlackListed_Sites = SwapWord(pGroupProfile->Defaulter_Number_Of_Attempts_Of_BlackListed_Sites);
			pGroupProfile->Audit_Log_For_Login_Attempts = SwapWord(pGroupProfile->Audit_Log_For_Login_Attempts);
			pGroupProfile->Audit_Log_For_BlackListed_Sites = SwapWord(pGroupProfile->Audit_Log_For_BlackListed_Sites);
			pGroupProfile->Allow_Sites = SwapWord(pGroupProfile->Allow_Sites);
			pGroupProfile->GroupNo = SwapWord(pGroupProfile->GroupNo);
			
		
			int i;
			for(i=0; i<7; i++)
			{
				pGroupProfile->User_Permission[i] = SwapDWord(pGroupProfile->User_Permission[i]);
			}
		
		fwrite (pGroupProfile, sizeof (GROUPDATA), 1, wFile) ;
		delete pGroupProfile;
	}


// Writing User Database
	pUserData = (USERDATABASE *) new USERDATABASE;

	pUserData->magic_id = USER_PROFILE;
	pUserData->number_of_items = nNumOfUsers;
	pUserData->length_of_items = nNumOfUsers * sizeof(USERDATA);

	pUserData->magic_id = SwapWord (pUserData->magic_id);
	pUserData->number_of_items = SwapWord (pUserData->number_of_items);
	pUserData->length_of_items = SwapDWord (pUserData->length_of_items);
	
	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

	delete pUserData;

	USERDATA *pUserProfile;
	int uIndex;
	
	for (uIndex = 0 ; uIndex < nNumOfUsers ; uIndex ++)
	{
		pUserProfile = (USERDATA *) m_UserDlg->m_LBoxForUserName.GetItemDataPtr (uIndex) ;
	
		pUserProfile->Defaulter = SwapWord(pUserProfile->Defaulter);
		pUserProfile->Account = SwapWord(pUserProfile->Account);
		
		fwrite (pUserProfile, sizeof (USERDATA), 1, wFile) ;
		delete pUserProfile;
	}

// Added by Sreelu.	
//	Writing Filter Database
	FILTER_DATA *pFilterProfile;
	int length;
	pUserData = (USERDATABASE *) malloc(sizeof(USERDATABASE));
	pUserData->magic_id = FILTER_PROFILE;
	pUserData->number_of_items = NumOfFilter;
	pUserData->length_of_items = NumOfFilter * sizeof(FILTER_DATA);

	pUserData->magic_id	= SwapWord (pUserData->magic_id);
	pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
	pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;
	free(pUserData);
	/* Filter Profile Storing Format:
	magic_id, number_of_items, length_of_items, Num of Domain Name Filters,
	Filter type,Group Mask,Action,Length of filter(dynamic length according to 
	the filter type), ::Port, Protocol(for Application Filter)
						::IP Address(for IP Address Filter)
						::Domain Name(for Domain Name Filter) */
	NumOfDomainName = SwapWord(NumOfDomainName);
	fwrite(&NumOfDomainName, sizeof(NumOfDomainName), 1, wFile);

	for (int i = 0 ; i < NumOfFilter ; i ++)
	{
		pFilterProfile = (FILTER_DATA *)m_Filter->m_ListCtrl.GetItemDataPtr(i);
		int type = pFilterProfile->type;
		pFilterProfile->type = SwapWord(pFilterProfile->type);
		pFilterProfile->mask = SwapDWord(pFilterProfile->mask);
		pFilterProfile->action = SwapWord(pFilterProfile->action);

		fwrite (&pFilterProfile->type, sizeof(pFilterProfile->type), 1, wFile) ;
		fwrite (&pFilterProfile->mask, sizeof(pFilterProfile->mask), 1, wFile) ;
		fwrite (&pFilterProfile->action, sizeof(pFilterProfile->action), 1, wFile) ;
		switch(type)
		{
			case 	APPLICATION:
				pFilterProfile->length = 0;
				pFilterProfile->port =SwapWord(pFilterProfile->port);
				pFilterProfile->proto =SwapWord(pFilterProfile->proto);

				pFilterProfile->length	=SwapWord(pFilterProfile->length);
				fwrite (&pFilterProfile->length, sizeof(pFilterProfile->length), 1, wFile) ;
				fwrite (&pFilterProfile->port, sizeof(pFilterProfile->port), 1, wFile) ;
				fwrite (&pFilterProfile->proto, sizeof(pFilterProfile->proto), 1, wFile) ;
				break;
			case IP_ADDRESS:
				pFilterProfile->length = strlen(pFilterProfile->address);
				length = pFilterProfile->length;

				pFilterProfile->length	=SwapWord(pFilterProfile->length);

				fwrite (&pFilterProfile->length, sizeof(pFilterProfile->length), 1, wFile) ;
				fwrite (&pFilterProfile->address, 1, length+1, wFile);
				break;
			case DOMAIN_NAME:
				pFilterProfile->length = strlen(pFilterProfile->address);
				length = pFilterProfile->length;

				pFilterProfile->length	=SwapWord(pFilterProfile->length);

				fwrite (&pFilterProfile->length, sizeof(pFilterProfile->length), 1, wFile) ;
				fwrite (&pFilterProfile->address, 1, length+1, wFile) ;
				break;
		}
		free(pFilterProfile);
	}

	pUserData = (USERDATABASE *) new USERDATABASE;

	pUserData->magic_id = INVALID_MAGIC_ID;
	pUserData->number_of_items = 0;
	pUserData->length_of_items = 0;

	pUserData->magic_id = SwapWord (pUserData->magic_id);
	pUserData->number_of_items = SwapWord (pUserData->number_of_items);	
	pUserData->length_of_items = SwapDWord (pUserData->length_of_items);	

	fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

	delete pUserData;

	fclose (wFile) ;
	ptr_filter_data = sptr_filter_data;
	if (ptr_filter_data == NULL)
	{
		CTabDialog::OnOK() ;
		return ;
	}

	while (1)
	{		
		FILTER_DATA *ptr_filter;
		ptr_filter = ptr_filter_data;		
		ptr_filter_data = ptr_filter_data->next;
#if 0
	char str[50];
	sprintf(str, "%u", ptr_filter->mask);
	AfxMessageBox(str);
#endif
			
		free (ptr_filter);
		if(ptr_filter_data == NULL)
			break;
	}
	free(sptr_group_data);
	CTabDialog::OnOK() ;
	return ;
}

void UserFilterTab::OnCancel()
{
	int count, i, nRetVal ;
	char szMessage[100] ;
	FILTER_DATA *ptr_filter_data;

	if (m_DBChanged)
		strcpy (szMessage, "User Data Base changed.\n") ;
	else
		strcpy (szMessage, "") ;

	strcat (szMessage, "Do you want to Exit ?") ;

	nRetVal = MessageBox ((LPCSTR) szMessage, (LPCSTR) "Users List",
				MB_YESNO | MB_ICONQUESTION) ;
	if (nRetVal == IDNO)
			return ;

	count = m_Filter->m_ListCtrl.GetCount();
	for(i = 0;i < count; i++)
	{
		FILTER_DATA *pFildata = (FILTER_DATA *) m_Filter->m_ListCtrl.GetItemDataPtr(i);
		free(pFildata);
	}

	count = m_UserDlg->m_LBoxForUserName.GetCount();
	for(i = 0;i < count; i++)
	{
		USERDATA *pUserData = (USERDATA *) m_UserDlg->m_LBoxForUserName.GetItemDataPtr (i) ;
		delete pUserData ;
	}

	count = m_UserDlg->m_LBoxForGroupName.GetCount();
	for(i = 0;i < count; i++)
	{
		GROUPDATA *pGroupData = (GROUPDATA *) m_UserDlg->m_LBoxForGroupName.GetItemDataPtr (i) ;
		delete pGroupData ;
	}

	count = m_Default->m_IPAddListCtrl.GetCount();
	for(i = 0;i < count; i++)
	{
		IPDEFAULTS *pIPDefault = (IPDEFAULTS *) m_Default->m_IPAddListCtrl.GetItemDataPtr (i);
		free(pIPDefault);
	}

	count = m_Default->m_AppListCtrl.GetCount();
	for(i = 0;i < count; i++)
	{
		APPDEFAULTS *pAPPDefault = (APPDEFAULTS *) m_Default->m_AppListCtrl.GetItemDataPtr (i);
		free(pAPPDefault);
	}

	ptr_filter_data = sptr_filter_data;
	if (ptr_filter_data == NULL)
	{
		CTabDialog::OnCancel();
		return;
	}

	while (1)
	{		
		FILTER_DATA *ptr_filter;
		ptr_filter = ptr_filter_data;		
		ptr_filter_data = ptr_filter_data->next;
		free (ptr_filter);
		if(ptr_filter_data == NULL)
			break;
	}
	free(sptr_group_data);
	CTabDialog::OnCancel();
}

void UserFilterTab::GroupProfile()
{
	USHORT number_of_group_items = 1;
	int nIndex;

	GROUPDATA *pGroupProfile = (GROUPDATA *) new GROUPDATA ;
	if (pGroupProfile == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "Group Profile List", MB_OK | MB_ICONSTOP) ;
		return;
	}

	while (number_of_group_items <= pUserData->number_of_items)
	{
		if (fread (pGroupProfile, sizeof (GROUPDATA), 1, rFile) == 1)
		{
				/* Scope : Add the Entries in the Group Profile List Box and 
							  point the Pointer to point to that Index
				*/
			char userstring[100];

			pGroupProfile->Defaulter_Login_Attempts = SwapWord(pGroupProfile->Defaulter_Login_Attempts);
		  	pGroupProfile->Defaulter_Number_Of_Login_Attempts = SwapWord(pGroupProfile->Defaulter_Number_Of_Login_Attempts);
			pGroupProfile->Defaulter_BlackListed_Sites = SwapWord(pGroupProfile->Defaulter_BlackListed_Sites);
			pGroupProfile->Defaulter_Number_Of_Attempts_Of_BlackListed_Sites = SwapWord(pGroupProfile->Defaulter_Number_Of_Attempts_Of_BlackListed_Sites);
			pGroupProfile->Audit_Log_For_Login_Attempts = SwapWord(pGroupProfile->Audit_Log_For_Login_Attempts);
			pGroupProfile->Audit_Log_For_BlackListed_Sites = SwapWord(pGroupProfile->Audit_Log_For_BlackListed_Sites);
			pGroupProfile->Allow_Sites = SwapWord(pGroupProfile->Allow_Sites);
			pGroupProfile->GroupNo = SwapWord(pGroupProfile->GroupNo);
			
			int i;
			for(i=0; i<7; i++)
			{
				pGroupProfile->User_Permission[i] = SwapDWord(pGroupProfile->User_Permission[i]);
			}
			sprintf(userstring,  "%s\t%s ",pGroupProfile->GroupName, pGroupProfile->GroupDescription ); 
			nIndex = m_UserDlg->m_LBoxForGroupName.AddString (userstring) ;
			
			m_UserDlg->m_LBoxForGroupName.SetItemDataPtr (nIndex, pGroupProfile) ;
		}
		else
			break;

		number_of_group_items++;
	
		pGroupProfile = (GROUPDATA *) new GROUPDATA ;
	}

	delete(pGroupProfile) ;	
  	m_UserDlg->ShowNumberOfGroups();
	number_of_group_profiles = pUserData->number_of_items ;
	return;
}

void UserFilterTab::UserProfile()
{
	USHORT number_of_user_items = 1;
	int nIndex;

	USERDATA *pUserProfile = (USERDATA *) new USERDATA ;
	if (pUserProfile == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "User Profile List", MB_OK | MB_ICONSTOP) ;
		return;
	}
	
	while (number_of_user_items <= pUserData->number_of_items)
	{
		if (fread (pUserProfile, sizeof (USERDATA), 1, rFile) == 1)
		{
				/* Scope : Add the Entries in the User Profile List Box and 
							  point the Pointer to point to that Index
				*/
			char userstring[100];
			char tmpGroupname[40];
			char defaulter[15];
			char account[10];
		  	
			char temp[10];

			pUserProfile->Defaulter = SwapWord(pUserProfile->Defaulter);
			pUserProfile->Account = SwapWord(pUserProfile->Account);

			sprintf(temp,"%d", pUserProfile->Defaulter);
			
			int i = pUserProfile->Defaulter;
			if(i == 0)
				strcpy(defaulter,"None");
			else if(i == 1)
				strcpy(defaulter,"Login");
			else if(i == 2)
		 		strcpy(defaulter,"BlackList");
				

			BOOL j = pUserProfile->Account;
			
			if(j == TRUE) 
				 strcpy(account,"Enable");
		 	else
				 strcpy(account,"Disable");
		    
			
			strcpy(tmpGroupname,pUserProfile->GroupName);
			wsprintf(userstring,  "%s\t%s",pUserProfile->UserName,tmpGroupname ); 
			
		  	nIndex = m_UserDlg->m_LBoxForUserName.AddString (userstring) ;
			m_UserDlg->m_LBoxForUserName.SetItemDataPtr (nIndex, pUserProfile) ;
		}
		else
			break;

		number_of_user_items++;
	
		pUserProfile = (USERDATA *) new USERDATA ;
	}

	delete(pUserProfile) ;	
  	m_UserDlg->ShowNumberOfUsers();
	number_of_user_profiles = pUserData->number_of_items ;
	return;
}

void UserFilterTab::FilterProfile()
{
	int nIndex, length;
	char proto[10], action[10], string[200], dom_name[255];
	USHORT number_of_filter_items = 1;
	FILTER_DATA *ptr_filter, *ptr_filter_data;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	
	fread(&NumOfDomainName, sizeof(NumOfDomainName), 1, rFile);
	NumOfDomainName = SwapWord(NumOfDomainName);
	ptr_filter_data = (FILTER_DATA *) calloc(1, sizeof(FILTER_DATA));
	if (ptr_filter_data == NULL)
	{
/*		AfxMessageBox("Calloc Failed"); */
		return;
	}

	for(int i = 0; i < NumOfFilter; i++ )
	{
		if(i == 0)
		{
			sptr_filter_data = ptr_filter_data;
			sptr_filter_data->next = NULL;
		}
		else
		{
			ptr_filter_data->next = ptr_filter;
			ptr_filter_data = ptr_filter_data->next;
		}

		fread (&ptr_filter_data->type, sizeof(ptr_filter_data->type), 1, rFile);
		fread (&ptr_filter_data->mask, sizeof(ptr_filter_data->mask), 1, rFile);
		fread (&ptr_filter_data->action, sizeof(ptr_filter_data->action), 1, rFile);
		fread (&ptr_filter_data->length, sizeof(ptr_filter_data->length), 1, rFile);

		ptr_filter_data->type = SwapWord(ptr_filter_data->type);
		ptr_filter_data->mask = SwapDWord(ptr_filter_data->mask);
		ptr_filter_data->action = SwapWord(ptr_filter_data->action);
		ptr_filter_data->length	=SwapWord(ptr_filter_data->length);

		switch(ptr_filter_data->type)
		{
			case APPLICATION:
				fread (&ptr_filter_data->port, sizeof(ptr_filter_data->port), 1, rFile);
				fread (&ptr_filter_data->proto, sizeof(ptr_filter_data->proto), 1, rFile);

				ptr_filter_data->port =SwapWord(ptr_filter_data->port);
				ptr_filter_data->proto =SwapWord(ptr_filter_data->proto);
				break;
			case IP_ADDRESS:
				fread (&ptr_filter_data->address, 1, ptr_filter_data->length+1, rFile);
				break;
			case DOMAIN_NAME:
				fread (&ptr_filter_data->address, 1, ptr_filter_data->length+1, rFile);
				break;
		}
		ptr_filter = (FILTER_DATA *) calloc(1, sizeof(FILTER_DATA));
		if (ptr_filter == NULL)
		{
/*			AfxMessageBox("Calloc Failed"); */
			return;
		}
		ptr_filter->next = NULL;
	}
	number_of_filter_profiles = NumOfFilter;
	m_Filter->DisplayFilterProfile();
	UpdateData (FALSE);
}

void UserFilterTab::ReadIPConfiguration()
{
	USHORT number_of_ip = 1;

	USER_INFO *info;
	info = (USER_INFO *) malloc(sizeof(USER_INFO));
	fread(info, sizeof(USER_INFO), 1, rFile);	
	info->enabled = SwapWord(info->enabled);
	info->default_action = SwapWord(info->default_action);

	if(info->enabled == TRUE)
	{
		m_Filter->m_UDBCheckStr = TRUE;
		m_Filter->m_UDBEnabled.SetCheck(1);
		m_Filter->m_AllowWnd.EnableWindow(FALSE);
		m_Filter->m_BlockWnd.EnableWindow(FALSE);
		enableView (1, TRUE);
		enableView (2, TRUE);
	}
	else
	{
		enableView (1, FALSE);
		enableView (2, FALSE);
		m_Filter->m_UDBCheckStr = FALSE;
		m_Filter->m_UDBEnabled.SetCheck(0);
		m_Filter->m_AllowWnd.EnableWindow(TRUE);
		m_Filter->m_BlockWnd.EnableWindow(TRUE);
	}		

	if(info->default_action == FILTER)
	{
		m_Filter->m_AllowWnd.SetCheck(1);
		m_Filter->m_BlockWnd.SetCheck(0);
	}
	else
	{
		m_Filter->m_AllowWnd.SetCheck(0);
		m_Filter->m_BlockWnd.SetCheck(1);
	}
	free (info);	

	IPDEFAULTS *pIPDefault = (IPDEFAULTS *) malloc (sizeof(IPDEFAULTS));
	if (pIPDefault == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "IP Authentication Profile List", MB_OK | MB_ICONSTOP) ;
		return;
	}

	while (number_of_ip <= pUserData->number_of_items)
	{
		if (fread (pIPDefault, sizeof (IPDEFAULTS), 1, rFile) == 1)
		{
			char string[100];
			wsprintf(string, "%s\t%s",pIPDefault->lower_address, pIPDefault->upper_address);
			int nIndex = m_Default->m_IPAddListCtrl.AddString(string);
		  	m_Default->m_IPAddListCtrl.SetItemDataPtr (nIndex, pIPDefault);
		}
		else
			break;

		number_of_ip++;
		pIPDefault = (IPDEFAULTS *) new IPDEFAULTS;
	}
	free (pIPDefault);	
	number_of_ip_address = pUserData->number_of_items ;
	return;
}

void UserFilterTab::ReadAPPConfiguration()
{
	USHORT number_of_app = 1;
	APPDEFAULTS *pAPPDefault = (APPDEFAULTS *) malloc (sizeof(APPDEFAULTS));
	if (pAPPDefault == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "Authentication Profile List", MB_OK | MB_ICONSTOP) ;
		return;
	}

	while (number_of_app <= pUserData->number_of_items)
	{
		if (fread (pAPPDefault, sizeof (APPDEFAULTS), 1, rFile) == 1)
		{
			char string[100];
			pAPPDefault->lower_port = SwapWord (pAPPDefault->lower_port);
			pAPPDefault->upper_port = SwapWord (pAPPDefault->upper_port);
			pAPPDefault->protocol = SwapWord (pAPPDefault->protocol);
	
			if(pAPPDefault->protocol == TCP_PROTOCOL)
				wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "TCP");
			if(pAPPDefault->protocol == UDP_PROTOCOL)
				wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "UDP");
			if(pAPPDefault->protocol == TCP_UDP_PROTOCOL)
				wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "TCP & UDP");
			int nIndex = m_Default->m_AppListCtrl.AddString(string);
		  	m_Default->m_AppListCtrl.SetItemDataPtr (nIndex, pAPPDefault);
		}
		else
			break;

		number_of_app++;
		pAPPDefault = (APPDEFAULTS *) new APPDEFAULTS;
	}
	free (pAPPDefault);
	number_of_application = pUserData->number_of_items ;
	return;
}

void UserFilterTab::UpgradeDbaseYes()
{
// By Default UserDataBase should be Disabled & Default Action should be Forward.w
		FILE *wFile;
		wFile = fopen (UDBUnCompressedDBaseFile, "wb") ;
		USERDATABASE *pUserData = (USERDATABASE *) new USERDATABASE;
		pUserData->magic_id = IP_PROFILE;
		pUserData->number_of_items = 0;
		pUserData->length_of_items = 0;

		pUserData->magic_id	= SwapWord (pUserData->magic_id);
		pUserData->number_of_items =  SwapWord (pUserData->number_of_items);
		pUserData->length_of_items =  SwapDWord (pUserData->length_of_items);
	
		fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

// Writing USER_INFO
		USER_INFO *info;
		info = (USER_INFO *) malloc(sizeof(USER_INFO));
	
		info->enabled = FALSE;
		info->default_action = FORWARD;
		info->enabled = SwapWord(info->enabled);
		info->default_action = SwapWord(info->default_action);
		fwrite (info, sizeof (USER_INFO), 1, wFile) ;

// Write Invalid Magic ID
		pUserData->magic_id = INVALID_MAGIC_ID;
		pUserData->number_of_items = 0;
		pUserData->length_of_items = 0;

		pUserData->magic_id = SwapWord (pUserData->magic_id);
		pUserData->number_of_items = SwapWord (pUserData->number_of_items);	
		pUserData->length_of_items = SwapDWord (pUserData->length_of_items);	

		fwrite (pUserData, sizeof (USERDATABASE), 1, wFile) ;

		delete pUserData;
		free (info);
		fclose (wFile) ;
}
