                                                        // userlog.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "tftpif.h"
#include "userlog.h"
#include "history.h"
#include "usrdata.h"
#include "view.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
struct USERDATALIST *sptr_user_list = NULL;

const char *users_log_msgs[] = {
		" Logged on",
		" Logged off",
		" Identified as defaulter",
		" Invalid user",
		" Trying invalid Passwords",
		" Account is disabled"
		};

#define MaxINIString 150   // Maximum length of string in the CNF File.

/////////////////////////////////////////////////////////////////////////////
// userlog dialog


userlog::userlog(CWnd* pParent /*=NULL*/)
	: CDialog(userlog::IDD, pParent)
{
	//{{AFX_DATA_INIT(userlog)
	m_group_name = "";
	m_aot_listbox = "";
	m_user_log_listbox = "";
	//}}AFX_DATA_INIT
}

void userlog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(userlog)
	DDX_Control(pDX, IDC_LIST1, m_event_listbox_ctrl);
	DDX_Control(pDX, IDC_LIST2, m_user_log_listbox_ctrl);
	DDX_Control(pDX, IDC_GROUP_NAME, m_group_name_ctrl);
	DDX_CBString(pDX, IDC_GROUP_NAME, m_group_name);
	DDX_LBString(pDX, IDC_LIST1, m_aot_listbox);
	DDX_LBString(pDX, IDC_LIST2, m_user_log_listbox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(userlog, CDialog)
	//{{AFX_MSG_MAP(userlog)
	ON_CBN_DROPDOWN(IDC_GROUP_NAME, OnDropdownGroupName)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_MESSAGE(WM_EVENT,OnBroadcastEvent)
	ON_BN_CLICKED(IDC_HIST_BTN, OnHistBtn)
	ON_BN_CLICKED(IDC_VIEW, OnView)
	ON_CBN_SELCHANGE(IDC_GROUP_NAME, OnSelchangeGroupName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// userlog message handlers

void userlog::OnDropdownGroupName()
{
	// TODO: Add your control notification handler code here
	
}

void userlog::OnHelp()
{
	// TODO: Add your control notification handler code here
	
}


void userlog::OnOK()
{
	// TODO: Add extra validation here
			
      	PostQuitMessage (0) ;
	return ;
		
	CDialog::OnOK();

	
}

BOOL userlog::OnInitDialog()
{
	CDialog::OnInitDialog();
//	AfxMessageBox("OnInit");
	// TODO: Add extra initialization here
	m_group_name_ctrl.SetCurSel(0);
	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();


	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();
	

	if (!ViewBmpBtn.LoadBitmaps ("VIEW1", "VIEW2", "VIEW3"))
		AfxMessageBox ("Failed to load VIEW bitmap");

	VERIFY (ViewBmpBtn.SubclassDlgItem (IDC_VIEW, this));
	ViewBmpBtn.SizeToContent();

	if (!HistoryBmpBtn.LoadBitmaps ("HISTORY1", "HISTORY2", "HISTORY3"))
		AfxMessageBox ("Failed to load HISTORY bitmap");

	VERIFY (HistoryBmpBtn.SubclassDlgItem (IDC_HIST_BTN, this));
	HistoryBmpBtn.SizeToContent();

		

//	int TabStops[] = {40, 45, 80, 240};
	int TabStops[] = {35, 40, 80, 240};
	m_user_log_listbox_ctrl.SetTabStops (4, (LPINT)&TabStops); 
        
//	int TabStops1[] = {80, 220, 225, 280};
	int TabStops1[] = {10, 100,190, 220};
	
	
	m_event_listbox_ctrl.SetTabStops (4, (LPINT)&TabStops1); 	

	char Buf[128];	
	char *ch;
	int InitSock;
	int error_code=0;
	char local[25] ,local1[25] ;
	
	
   InitSock = InitialiseSocket(GetSafeHwnd(),&error_code);
//	AfxMessageBox("Socket Initialise1");
//	sprintf(local, "%d" ,InitSock);
//	sprintf(local1, "%d" ,error_code);
	
//	AfxMessageBox(local);
//	AfxMessageBox(local1);
#if 0	
	
	CStdioFile input;
	char *FileName = UserDataFile ;
	if (!input.Open(FileName, CFile::modeRead | CFile::typeText))
		return (FALSE);
	////Read the strings and if there is a newline character, don't display it
	////Also if the buffer is empty, don't add the empty string to the listbox.
	while((input.ReadString(Buf , MaxINIString)) != NULL)
	{
		if ((ch = strchr (Buf, (int)'\n')) != NULL)
			*ch = '\0';
		if ((ch = strchr (Buf, (int)'#')) != NULL)  
			*ch = '\0';
		if (Buf[0])
			m_user_log_listbox_ctrl.InsertString (m_user_log_listbox_ctrl.GetCount(), Buf);
	}
	input.Close();

	#endif
	CenterWindow();
	UpdateData (FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}



LRESULT userlog::OnBroadcastEvent(WPARAM wParam, LPARAM lParam)
{
	int error_code=0;
	char local1[25];
       	char user_evnt_string[150];
	char evnt_string[400],fin_evnt_string[400];;
	char MsgBuf[30],uname[30];
	USERONLINEDATA *pUserData ;
	EventBroadCastDataPacket user_data_packet;
	unsigned int addr1, addr2, addr3, addr4;
	char dot_decimal_ip_address[50];
	struct USERDATALIST *UserList; //New Addition

	
	userlog Cdlg;
	CWnd *Current_Window = Cdlg.GetActiveWindow();
//	AfxMessageBox("Entering broadcast event");
  	
	recieve_data_from_the_packet(&user_data_packet,&error_code);
//	AfxMessageBox(user_data_packet.username);
	
	sprintf(MsgBuf,"%s",users_log_msgs[user_data_packet.user_event_type]);
    	char user_name[40],group_name[40],u_name[40];
	strcpy(user_name,user_data_packet.username);
	strcpy(u_name,user_data_packet.username);
    	strcpy(group_name,user_data_packet.groupname);

	strncpy((user_name) + 30, "",10);
//	AfxMessageBox(user_name);
	
	sprintf(user_evnt_string,"%s\t%s\t%s\t%s",user_data_packet.time,user_data_packet.date,user_name,MsgBuf);
//	AfxMessageBox(user_evnt_string);
	sprintf(local1, "%d" ,error_code);	
//	AfxMessageBox(local1);
	m_user_log_listbox_ctrl.AddString(user_evnt_string);

	addr4 = (unsigned int) (user_data_packet.ip_address & 0xFF);
	addr3 = (unsigned int) ((user_data_packet.ip_address & 0xFF00) >> 8);
	addr2 = (unsigned int) ((user_data_packet.ip_address & 0xFF0000) >> 16);
	addr1 = (unsigned int) ((user_data_packet.ip_address & 0xFF000000) >> 24);
	
	strncpy((u_name) + 15, "",25);
//	AfxMessageBox(u_name);
	strncpy((group_name) + 15, "",25);
//	AfxMessageBox(group_name);
		
	sprintf (dot_decimal_ip_address, "%u.%u.%u.%u", addr4, addr3, addr2, addr1);	
	sprintf(evnt_string,"%s\t%s\t%s\t%s",u_name,group_name,dot_decimal_ip_address,user_data_packet.login_time);
	

	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGON ) 
  	{
		
		int  index;
		char TmpGname[40];
		int cnt = m_group_name_ctrl.GetCount();
		int counti = 0;
		BOOL duplicate_group_name = FALSE;
   	
		for(counti = 0; counti < cnt; counti++)
		{
			char gpname1[40];
			if(m_group_name_ctrl.GetLBText(counti,gpname1) != LB_ERR)
			{
				if(!strcmp(gpname1, user_data_packet.groupname))
				{ 
					duplicate_group_name = TRUE;
					break;
				}
			}
		 }

		 if(!duplicate_group_name)
				m_group_name_ctrl.AddString(user_data_packet.groupname);
		
	     	char gpname[40];
	     	int sIndex = m_group_name_ctrl.GetCurSel();
	     	m_group_name_ctrl.GetLBText(sIndex,gpname);
		
			
		int count = m_event_listbox_ctrl.GetCount();
		BOOL duplicate = FALSE;
		int countindex=0;

		for(countindex=0; countindex < count; countindex++)
		{
			char UsGrDeAc[200];

			if (m_event_listbox_ctrl.GetText(countindex,UsGrDeAc) != LB_ERR)
			{
				char u_name[40],tmpUsername[15],tmpGroupname[15],tmpIpaddress[15];
				sscanf(UsGrDeAc,"%s\t%s\t%s",tmpUsername,tmpGroupname,tmpIpaddress);

				if(!strcmp(tmpIpaddress, dot_decimal_ip_address))
				{
//					MessageBox ((LPCSTR) "This user already Exist\nCan't add duplicate user.",
//					(LPCSTR) "Users - Log", MB_OK | MB_ICONINFORMATION) ;
					duplicate = TRUE;

					USERONLINEDATA *pUserData = (USERONLINEDATA *)
		 			m_event_listbox_ctrl.GetItemDataPtr (countindex) ;

					delete pUserData ;
					m_event_listbox_ctrl.DeleteString (countindex);


					UserList = (USERDATALIST *) new USERDATALIST ;
					if (UserList == NULL)
					{
						MessageBox ((LPCSTR) "Insufficient memory",
						(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
						return FALSE ;
					}
			
					UserList->event_type = user_data_packet.user_event_type;
					strcpy(UserList->username,user_data_packet.username);
					strcpy(UserList->groupname,user_data_packet.groupname);
					strcpy(UserList->ip_address,dot_decimal_ip_address);
					strcpy(UserList->login_time,user_data_packet.login_time);
					strcpy(UserList->date,user_data_packet.date);
					strcpy(UserList->time,user_data_packet.time);	
					
					char event[20];
					sprintf(event,"%d",UserList->event_type);
		     		//AfxMessageBox(event);
	       	
					DeleteTheEntry(UserList);

					delete (UserList);
					break;
				}
			 }	
		}

		if(!strcmp(gpname,"All") || !strcmp(gpname,user_data_packet.groupname))
		{
			pUserData = (USERONLINEDATA *) new USERONLINEDATA ;
			if (pUserData == NULL)
			{
				MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
				return FALSE;
			}

			int nIndex = m_event_listbox_ctrl.AddString(evnt_string);
			m_event_listbox_ctrl.SetItemDataPtr(nIndex,pUserData);
			m_event_listbox_ctrl.SetCurSel(nIndex);
				
			lstrcpy((LPSTR) pUserData->username,user_data_packet.username);
			lstrcpy((LPSTR) pUserData->groupname,user_data_packet.groupname);
			lstrcpy((LPSTR) pUserData->ip_address,dot_decimal_ip_address);
			lstrcpy((LPSTR) pUserData->login_time,user_data_packet.login_time);
		}

		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}

		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,dot_decimal_ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);
		UserList->link = NULL;
		char event[20];
		sprintf(event,"%d",UserList->event_type);
  		//AfxMessageBox(event);
		AddtoTheList(UserList);
	}
	
	
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGOFF ) 
  	{
	       char uname[40],gname[40],ip_add[50],ltime[15];
	       char usname[40],grname[40],ip_addr[50],lotime[15],combstring[400];
		int index = 0;
	      //AfxMessageBox("Log Off");
	       	sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
		while(1)
		{
			if(m_event_listbox_ctrl.GetText(index,combstring) != LB_ERR)
			{
				sscanf(combstring,"%s%s%s%s",usname,grname,ip_addr,lotime);

				if (strcmp(ip_addr,ip_add) == 0)
				{
					USERONLINEDATA *pUserData = (USERONLINEDATA *)
	 				m_event_listbox_ctrl.GetItemDataPtr (index) ;
	    				delete pUserData ;
					
					m_event_listbox_ctrl.DeleteString (index);
					index++;
					UserList = (USERDATALIST *) new USERDATALIST ;
					if (UserList == NULL)
					{
						MessageBox ((LPCSTR) "Insufficient memory",
						(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
						return FALSE ;
					}
					
					
					UserList->event_type = user_data_packet.user_event_type;
					strcpy(UserList->username,user_data_packet.username);
					strcpy(UserList->groupname,user_data_packet.groupname);
					strcpy(UserList->ip_address,dot_decimal_ip_address);
					strcpy(UserList->login_time,user_data_packet.login_time);
					strcpy(UserList->date,user_data_packet.date);
					strcpy(UserList->time,user_data_packet.time);
  					UserList->link = NULL;
	       	
			//		AfxMessageBox(UserList->groupname);
					DeleteTheEntry(UserList);
					delete(UserList);    
										
				}
			}
			else
			{
				break;
			}
		}
	   #if 0    
		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
			
		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,dot_decimal_ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);
		UserList->link = NULL;
	       	
//		AfxMessageBox(UserList->groupname);
		DeleteTheEntry(UserList);
		delete(UserList);    
	#endif
	}


#if 0
// Post a message to user events log dialog if it is alive
	if(event_type==WAN_EVENT_BDCAST)
		Current_Window->PostMessage(WM_LOG_EVENT, 0 ,0 );
	else
		Current_Window->PostMessage(WM_USER_LOG_EVENT, 0 ,0 );
#endif	
      
	return (NULL) ;

}


#if 0
LRESULT userlog::OnRxEventBroadcast(WPARAM wParam, LPARAM lParam)
{
      #if 0	
  	userlog Cdlg;
   	CWnd *Current_Window = Cdlg.GetActiveWindow();

//AfxMessageBox("Rxed broadcast");
	
	int error_code=0;
	enum EVENT_CATEG event_type;
	char local1[25];
	
       	char user_event_string[150];
      #endif
		
//	AfxMessageBox(user_event_string);
	     //	m_user_log_listbox_ctrl.AddString(user_event_string);

#if 0
int error_code = 0;

	char Buf[248];	
	char *ch;

AfxMessageBox("Rxed broadcast");
	CStdioFile input;
	char *FileName = UserEventBdcastFile ;
	if (!input.Open(FileName, CFile::modeRead | CFile::typeText))
		return (FALSE);
	////Read the strings and if there is a newline character, don't display it
	////Also if the buffer is empty, don't add the empty string to the listbox.
	while((input.ReadString(Buf , MaxINIString)) != NULL)
	{
		if ((ch = strchr (Buf, (int)'\n')) != NULL)
			*ch = '\0';
		if (Buf[0])
		{
			m_user_log_listbox_ctrl.InsertString (m_user_log_listbox_ctrl.GetCount(), Buf);
//			m_user_log_listbox_ctrl.SetCurSel(m_user_log_listbox_ctrl.GetCount() - 1);
		}
	}
	input.Close();

	CenterWindow();
	UpdateData (FALSE);
//AfxMessageBox("Display over");
#endif
	return(NULL);
}
#endif

void userlog::OnHistBtn()
{
	// TODO: Add your control notification handler code here

	CHistory Hist;
	Hist.DoModal();

	return;
}


void userlog::OnView()
{

	
	int nIndex = m_event_listbox_ctrl.GetCurSel() ;
	// If no User is selected return 
	if (nIndex == LB_ERR)
		return ;

	view vew;
	vew.DoModal();
	
	UpdateData (FALSE) ;

	return;

// TODO: Add your control notification handler code here
	
}


void userlog::AddtoTheList(struct USERDATALIST *userlist)
{
	struct USERDATALIST *tempuserlist = NULL;

	if(sptr_user_list == NULL)
	{
		//AfxMessageBox("Adding First Entry ");
		sptr_user_list = userlist;
		return;
	}

	tempuserlist = sptr_user_list ;
	while(1)
	{
		if (!strcmp(tempuserlist->ip_address, userlist->ip_address))
		{
			tempuserlist->event_type = userlist->event_type;
			strcpy(tempuserlist->username,userlist->username);
			//AfxMessageBox(tempuserlist->username);
			//AfxMessageBox(userlist->username);
			strcpy(tempuserlist->groupname,userlist->groupname);
			strcpy(tempuserlist->ip_address,userlist->ip_address);
			//AfxMessageBox(tempuserlist->ip_address);
			//AfxMessageBox(userlist->ip_address);

			strcpy(tempuserlist->login_time,userlist->login_time);
			strcpy(tempuserlist->date,userlist->date);
			strcpy(tempuserlist->time,userlist->time);
			return;
		}

		if(tempuserlist->link == NULL)
		{
			//AfxMessageBox("Adding Next entries");
			tempuserlist->link = userlist;
			return;
		}
		else
			tempuserlist = tempuserlist->link;
	}
}

void userlog::OnSelchangeGroupName()
{
	// TODO: Add your control notification handler code here
	struct USERDATALIST *tempuserlist = sptr_user_list;
	char event_string[200] ;
	USERONLINEDATA *pUserData ;


//	AfxMessageBox("comparison");

	m_event_listbox_ctrl.ResetContent();

	char gpname[40];
	int sIndex = m_group_name_ctrl.GetCurSel();
	m_group_name_ctrl.GetLBText(sIndex,gpname);
	//AfxMessageBox(gpname);

	while(tempuserlist != NULL)
	{
//		AfxMessageBox("comparison1");
	  //	AfxMessageBox(tempuserlist->username);
		
		if(!strcmp(gpname, tempuserlist->groupname) || !strcmp(gpname,"All"))
		{
	  //			AfxMessageBox("comparison2");
			pUserData = (USERONLINEDATA *) new USERONLINEDATA ;
			if (pUserData == NULL)
			{
				MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			}
			
		   	sprintf(event_string,"%s\t%s\t%s\t%s",tempuserlist->username,tempuserlist->groupname,tempuserlist->ip_address,tempuserlist->login_time);
		
			int nIndex = m_event_listbox_ctrl.AddString(event_string);
	    		m_event_listbox_ctrl.SetItemDataPtr(nIndex,pUserData);
			
			lstrcpy((LPSTR) pUserData->username,tempuserlist->username);
			lstrcpy((LPSTR) pUserData->groupname,tempuserlist->groupname);
			lstrcpy((LPSTR) pUserData->ip_address,tempuserlist->ip_address);
			lstrcpy((LPSTR) pUserData->login_time,tempuserlist->login_time);
   	
	// New for log off
			char event[20];
			sprintf(event,"%d",tempuserlist->event_type);
       		//AfxMessageBox(event);
			if(tempuserlist->event_type == LOG_USER_EVENT_LOGOFF)
			{
//			       AfxMessageBox("event Log Off");
			       char uname[40],gname[40],ip_add[50],ltime[15];
			       char usname[40],grname[40],ip_addr[50],lotime[15],combstring[400];
				int index = 0;

			       	//sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
				while(1)
				{
//				       AfxMessageBox("event Log Off1");
			
					if(m_event_listbox_ctrl.GetText(index,combstring) != LB_ERR)
					{
//					       AfxMessageBox("event Log Off2");
				
						sscanf(combstring,"%s%s%s%s",usname,grname,ip_addr,lotime);

						if (strcmp(ip_addr,tempuserlist->ip_address) == 0)
						{						      
							USERONLINEDATA *pUserData = (USERONLINEDATA *)
	 						m_event_listbox_ctrl.GetItemDataPtr (index) ;
	    						delete pUserData ;
					
							m_event_listbox_ctrl.DeleteString (index);
							index++;
						
						}
					}
					else
					{
//					       AfxMessageBox("event Log Off3");
				
						break;
					}
		
				}
	   
			}
		      // new addition ends

		}

		tempuserlist = tempuserlist->link;
	}

}

void userlog :: DeleteTheEntry(struct USERDATALIST *UserDataList)
{
	struct USERDATALIST *tmpUserList,*tempUserList;
	//AfxMessageBox("Delete the Node");
	if(sptr_user_list == NULL)
		return;

	tmpUserList = sptr_user_list;

	if(!strcmp(tmpUserList->ip_address, UserDataList->ip_address))
	{
		sptr_user_list = tmpUserList->link;
		delete(tmpUserList);
		return;
	}

	while(tmpUserList->link !=NULL)
	{
		if(!strcmp(tmpUserList->ip_address, UserDataList->ip_address))
		{
			tempUserList = tmpUserList->link->link;
			delete(tmpUserList->link);
			tmpUserList->link = tempUserList;
		
		}
			tmpUserList = tmpUserList->link;
	}
	return;
}
