// usersdlg.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "userdata.h"
#include "usersadd.h"
#include "usersdlg.h"
#include "stdio.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL m_DBChanged;
/////////////////////////////////////////////////////////////////////////////
// CUsersDlg dialog


CUsersDlg::CUsersDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUsersDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUsersDlg)
	m_szNumUsers = "";
	m_DBChanged = FALSE;
	//}}AFX_DATA_INIT
}

void CUsersDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUsersDlg)
	DDX_Control(pDX, IDC_USERS_NAME_LIST, m_LBoxForUserNames);
	DDX_Text(pDX, IDC_NUM_USERS_STATIC, m_szNumUsers);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUsersDlg, CDialog)
	//{{AFX_MSG_MAP(CUsersDlg)
	ON_BN_CLICKED(IDC_BTN_ADD_USER, OnBtnAddUser)
	ON_BN_CLICKED(IDC_BTN_DELETE_USER, OnBtnDeleteUser)
	ON_BN_CLICKED(IDC_BTN_EDIT_USER, OnBtnEditUser)
	ON_BN_CLICKED(IDD_DNLD_DATABASE, OnDnldDatabase)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CUsersDlg message handlers

BOOL CUsersDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80] ;

	GetWindowText (CurrentHeading, 80) ;
	ModifyHeader (CurrentHeading, WindowHeader) ;
	SetWindowText (WindowHeader) ;

	m_LBoxForUserNames.ResetContent() ;

	USERDATA *pUserData = (USERDATA *) new USERDATA ;
	if (pUserData == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "Users List", MB_OK | MB_ICONSTOP) ;
		return TRUE ;
	}

	FILE *rFile = fopen (UDBUnCompressedDBaseFile, "rb") ;

	int nIndex ;
	if (rFile != NULL)
	{
		while (1)
		{
			if (fread (pUserData, sizeof (USERDATA), 1, rFile) == 1)
			{
				nIndex = m_LBoxForUserNames.AddString (pUserData->UserName) ;
				pUserData->DialInPortMask = SwapDWord (
															pUserData->DialInPortMask) ;
				pUserData->DialOutPortMask = SwapDWord (
															pUserData->DialOutPortMask) ;
				pUserData->CallBackDelay = SwapWord (pUserData->CallBackDelay) ;
				m_LBoxForUserNames.SetItemDataPtr (nIndex, pUserData) ;
			}
			else
				break ;
			pUserData = (USERDATA *) new USERDATA ;
		}
	}
	delete pUserData ;

	fclose (rFile) ;

	// Delete the Uncompressed file
	rFile = fopen (UDBUnCompressedDBaseFile, "wb") ;
	fclose (rFile) ;
	remove (UDBUnCompressedDBaseFile) ;

	// Update the number of Users
	ShowNumberOfUsers() ;

	UpdateData (FALSE) ;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CUsersDlg::OnBtnAddUser()
{
	// TODO: Add your control notification handler code here

	int nNumUsers = m_LBoxForUserNames.GetCount() ;
	if (nNumUsers == MAX_NUM_OF_USERS)
 		return ;

	CUsersAddDlg CUserAdd (this) ;
	CUserAdd.m_bActionEdit = FALSE ;
   CUserAdd.DoModal() ;

	// Update the number of Users
	ShowNumberOfUsers() ;

	UpdateData (FALSE) ;

	return ;
}

void CUsersDlg::OnBtnDeleteUser()
{
	// TODO: Add your control notification handler code here

	// Get which User is currently selected
	int nIndex = m_LBoxForUserNames.GetCurSel() ;

	// If no User is selected return 
	if (nIndex == LB_ERR)
		return ;

	// If some User was selected Confirm whether Deletion should proceed
	int nRetVal = MessageBox (
			(LPCSTR) "Do you really want to delete selected user ?",
						(LPCSTR) "Users - Delete",
								MB_YESNO | MB_ICONQUESTION) ;

	// If Deletion cancelled return
	if (nRetVal == IDNO)
		return ;

	// If to Delete free the memory occupied by the 
	// User data structure to HEAP
	USERDATA *pUserData = (USERDATA *)
										m_LBoxForUserNames.GetItemDataPtr (nIndex) ;
	delete pUserData ;

	// Remove the User name from the List Box
	m_LBoxForUserNames.DeleteString (nIndex) ;

	// Update the number of Users
	ShowNumberOfUsers() ;

	m_DBChanged = TRUE ;

	// Update all controls in the Window
	UpdateData (FALSE) ;

	return ;
}

void CUsersDlg::OnBtnEditUser()
{
	// TODO: Add your control notification handler code here

	// Get which User is currently selected
	int nIndex = m_LBoxForUserNames.GetCurSel() ;

	// If no User is selected return 
	if (nIndex == LB_ERR)
		return ;

	CUsersAddDlg CUserEdit (this) ;
	CUserEdit.m_bActionEdit = TRUE ;

	int nRetVal = CUserEdit.DoModal() ;
	if (nRetVal == IDCANCEL)
		return ;

	// Update the number of Users
	ShowNumberOfUsers() ;

	// Update all controls in the Window
	UpdateData (FALSE) ;

	return ;
}

void CUsersDlg::ShowNumberOfUsers()
{
	char szNum[10] ;
	itoa (m_LBoxForUserNames.GetCount(), szNum, 10) ;
	m_szNumUsers = szNum ;
	return ;
}

		
void CUsersDlg::OnDnldDatabase()
{
	// TODO: Add your control notification handler code here

	if (!UpdateData (TRUE))
		return ;

	int nRetVal ;
	char szMessage[100] ;

	if (m_DBChanged)
		strcpy (szMessage, "") ;
	else
		strcpy (szMessage, "User Data Base not changed.\n") ;

	strcat (szMessage, "Do you want to Download DataBase ?") ;

	nRetVal = MessageBox ((LPCSTR) szMessage,
			(LPCSTR) "Users List", MB_YESNO | MB_ICONQUESTION) ;

	if (nRetVal == IDNO)
		return ;

	FILE *wFile ;
	wFile = fopen (UDBUnCompressedDBaseFile, "wb") ;

	int nNumUsers = m_LBoxForUserNames.GetCount() ;
	USERDATA *pUserData ;

	for (int index = 0 ; index < nNumUsers ; index ++)
	{
		pUserData = (USERDATA *) m_LBoxForUserNames.GetItemDataPtr (index) ;
		pUserData->DialInPortMask = SwapDWord (pUserData->DialInPortMask) ; 
		pUserData->DialOutPortMask = SwapDWord (pUserData->DialOutPortMask) ; 
		pUserData->CallBackDelay = SwapWord (pUserData->CallBackDelay) ; 	
		fwrite (pUserData, sizeof (USERDATA), 1, wFile) ;
		delete pUserData ;
	}

	fclose (wFile) ;

	CDialog::OnOK() ;
}

DWORD CUsersDlg::SwapDWord (DWORD IntelMotorola)
{
	DWORD TempDWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempDWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 3) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 2) ;
	*(TempPtrDest + 2) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 3) = *(TempPtrSrc + 0) ;

	return TempDWord ;
}

WORD CUsersDlg::SwapWord (WORD IntelMotorola)
{
	WORD TempWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 0) ;

	return TempWord ;
}

void CUsersDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	int nRetVal ;
	char szMessage[100] ;

	if (m_DBChanged)
		strcpy (szMessage, "User Data Base changed.\n") ;
	else
		strcpy (szMessage, "") ;

	strcat (szMessage, "Do you want to Exit ?") ;

	nRetVal = MessageBox ((LPCSTR) szMessage, (LPCSTR) "Users List",
														MB_YESNO | MB_ICONQUESTION) ;
	if (nRetVal == IDNO)
			return ;

	USERDATA *pUserData ;

	int nNumUsers = m_LBoxForUserNames.GetCount() ;

	// Release all Structure Buffer Area to HEAP
	for (int index = 0 ; index < nNumUsers ; index ++)
	{
		pUserData = (USERDATA *) m_LBoxForUserNames.GetItemDataPtr (index) ;
		delete pUserData ;
	}
	CDialog::OnCancel();
}

void CUsersDlg::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_USERS_LIST_DIALOG, HELP_CONTEXT);
}

