
#ifndef __USRDATA_H__

#define __USRDATA_H__

#define  TCP_PROTOCOL  6
#define  UDP_PROTOCOL  17
#define  TCP_UDP_PROTOCOL  50

#include "tftpdnld.h"
/* Filter Types */
#define APPLICATION  0
#define IP_ADDRESS   1
#define DOMAIN_NAME  2

/* Filter Action */
#define FILTER  0
#define FORWARD 1
#define DEFAULT 2

#ifndef USHORT
#define	USHORT	unsigned short
#endif

#ifndef ULONG
#define	ULONG	unsigned long
#endif

#ifndef BYTE
#define	BYTE unsigned char
#endif


#define MAX_NUM_OF_USERS 1024
#define MAX_NUM_OF_GROUPS 25

#define UDB_HDR_FILE "UDB.HDR"

//#define VERSION3 "v3.00"
#define VERSION2 "v2.00"

#define UDB_VERSION VERSION2		// uncompressed version 12/06/97 vidy
#define VERSION1 "VERSION 1"		// it could be "v1.00" or "" also



#define USER_NAME_LEN (39 + 1)
#define USER_PASSWORD_LEN (7 + 1)

#define GROUP_NAME_LEN (39 + 1)
#define GROUP_DESC_LEN (39 + 1)

#define IP_PROFILE		0xABAB
#define APP_PROFILE		0xACAC
#define GROUP_PROFILE	0xAAAA
#define USER_PROFILE		0xBBBB
#define FILTER_PROFILE	0xCCCC
#define DEFAULT_FILTER	0xDDDD
#define INVALID_MAGIC_ID 0xFFFF

#define SELECT_IP 0
#define SELECT_APP 1 

typedef struct FILTER_DATA
{
	USHORT type;
	ULONG mask;
	ULONG temp_mask;
	USHORT action;		
	USHORT length;
	char address[255];
	USHORT port;
	USHORT proto;
	FILTER_DATA *next;
}FILTER_DATA;

typedef struct {
	char UserName[USER_NAME_LEN] ;
 	char UserPassword[USER_PASSWORD_LEN] ;
	char GroupName[GROUP_NAME_LEN];
	USHORT Defaulter ;
	BOOL Account ;
} USERDATA;


typedef struct {
	char        GroupName[GROUP_NAME_LEN] ;
 	char        GroupDescription[GROUP_DESC_LEN] ;
	BOOL	      Defaulter_Login_Attempts;
	USHORT      Defaulter_Number_Of_Login_Attempts;
	BOOL        Defaulter_BlackListed_Sites;
	USHORT      Defaulter_Number_Of_Attempts_Of_BlackListed_Sites;
	BOOL        Audit_Log_For_Login_Attempts;
	BOOL        Audit_Log_For_BlackListed_Sites;
	USHORT      Allow_Sites;
	ULONG      	User_Permission[7];
	int 			GroupNo;			//sreelu
} GROUPDATA;

typedef struct{
	char        GroupName[GROUP_NAME_LEN] ;
	int 			GroupNo;	
	int 			Count;
	int 			FilterAction;
}TEMP_GROUPDATA;

typedef struct {
	char 							username[USER_NAME_LEN];
	char							groupname[GROUP_NAME_LEN];
	char							login_time[15];
	char							ip_address[50];
	char							date[25];
	char							time[25];
	}USERONLINEDATA;

 struct USERDATALIST
	{
		EVENT_TYPE_ENUM         event_type;
		char 							username[USER_NAME_LEN];
		char							groupname[GROUP_NAME_LEN];
		char							login_time[15];
		char							ip_address[50];
		char							date[25];
		char							time[25];
		struct USERDATALIST		*link;
	};

// For IP Addresses & Application Ports that Need no Authentication.

typedef struct IPDEFAULTS
{
	char lower_address[16];
	char upper_address[16];
}IPDEFAULTS;

typedef struct APPDEFAULTS
{
	USHORT lower_port;
	USHORT upper_port;
	USHORT protocol;
}APPDEFAULTS;

typedef struct USER_INFO
{
	BOOL enabled;
	USHORT default_action;		
}USER_INFO;

#endif

