#include <stdio.h>
#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions (including VB)


#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"

#ifndef ULONG
#define	ULONG	unsigned long
#endif

BOOL IsWANPort(int PortNumber)
{
        return (PortNumber == 2);
}

BOOL IsSecuredLANPort(int PortNumber)
{
        return (PortNumber == 0);
}

int GetInternetLANPortNumber()
{
        return 1;
}


int GetWANPortNumber()
{
        return 2;
}

int GetNumberOfLANPorts()
{
        return(GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "LSL Number of LAN Ports",2,
				(LPCSTR) IniInWinForm));
}

int GetNumberOfWANPorts()
{
        return(GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "LSL Number of WAN Ports",1,
				(LPCSTR) IniInWinForm));
}
/* Neelu on 04-02-99 */

void get_next_ip_address (char *obtd_host_ip_address, char *next_ip_address) 
{
	ULONG ulong_ip_address ;

	get_ip_address (obtd_host_ip_address, &ulong_ip_address)	;
	if ((++ulong_ip_address & 0xff) == 0xff)
	{
		ulong_ip_address&= 0xffffff00 ;
		ulong_ip_address|= 1 ;
	}
	get_dot_decimal_ip_address (ulong_ip_address, next_ip_address)	;
}

void guess_mask (ULONG ip_address, ULONG *mask_value) 
{
	ip_address&= 0xff000000 ;
	ip_address>>=24 ;
	if (ip_address < 128)
		*mask_value = 0xff000000;
	else
		if (ip_address < 192)
			*mask_value = 0xffff0000;
		else
			*mask_value = 0xffffff00;
}


int check_if_ip_address_belongs_to_same_net (char *obtd_host_ip_address, char *ip_address)
{
	ULONG ip_address1, ip_address2, mask_value ;

	get_ip_address (obtd_host_ip_address, &ip_address1)	;
	get_ip_address (ip_address, &ip_address2)	;
	guess_mask (ip_address1, &mask_value) ;
	if ((ip_address1&mask_value) == (ip_address2&mask_value))
		return TRUE ;
	return FALSE ;
}

DWORD ltl_endian_word (DWORD num)
{
	DWORD num2 ;
	BYTE *str ;
	BYTE *str2 ;
	str = (BYTE *) &num ;
	str2 = (BYTE *) &num2 ;
	if ((int) sizeof (num) == (int) 4)
	{
		str2[3] = str[0] ;
		str2[2] = str[1] ;
		str2[1] = str[2] ;
		str2[0] = str[3] ;
	}
	else
	{ 
		str2[0] = str[1] ;
		str2[1] = str[0] ;
	}
	return num2 ;
}






/* Neelu on 04-02-99 */
