// wandlg.h : header file
//
#include "tabdlg.h"
#include "dot.h"

#define n_PORTMAX_WAN 4
/////////////////////////////////////////////////////////////////////////////
// CWANDlg dialog

class CWANDlg : public CDialog
{
// Construction
public:
	CWANDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWANDlg)
	enum { IDD = IDD_WAN_CONFIG };
	CButton	m_ChkBoxScriptNonCritical;
	CButton	m_ChkBoxScriptAlarm;
	CButton	m_ScriptCtrlGrp;
	CButton	m_BtnAdd;
	CButton	m_MdmCtrlWnd;
	CButton	m_BtnEdit;
	CButton	m_BtnDelete;
	CComboBox	m_combBoxModemTypes;
	CEdit	m_PortWnd;
	BOOL	m_WANEnable;
	BOOL	m_Printf;
	BOOL	m_PrintfRx;
	BOOL	m_PrintfTx;
	BOOL	m_PrintfInitialize;
	BOOL	m_bNonCriticalScriptPrintf;
	BOOL	m_bAlarmScriptPrintf;
	//}}AFX_DATA
   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   CBitmapButton AddBitmapBtn;
   CBitmapButton EditBitmapBtn;
   CBitmapButton DelBitmapBtn;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL GetModemTypes (void) ;
	BOOL WriteToCnfFile (void) ;
	void ReleaseBuffers (void) ;
	void PutModemsInParentsList (void) ;
	void EnableButtons (void) ;
	BOOL m_bMdmConfigChanged ;
	int m_nSelectedModem ;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
   BOOL ValidEditFields (void);

	// Generated message map functions
	//{{AFX_MSG(CWANDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnHelp();
	virtual void OnOK();
	afx_msg void OnSelchangeComboModemTypes();
	afx_msg void OnBtnAddModem();
	afx_msg void OnBtnEditModem();
	afx_msg void OnBtnDeleteModem();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CWANPortDlg dialog

class CWANPortDlg : public CDialog
{
// Construction
public:
	CWANPortDlg(CWnd* pParent = NULL);	// standard constructor
	int GetMyID (void);

// Dialog Data
	//{{AFX_DATA(CWANPortDlg)
	enum { IDD = IDD_WAN_PORT_CONFIG };
	CButton	m_BtnScript;
	CButton	m_RestartScriptWnd;
	CButton	m_ScriptEnableWnd;
	CButton	m_TermServerWnd;
	CButton	m_chkBtnDirConnect;
	CButton	m_chkboxIdleFlags;
	CEdit	m_EditDialNumberWnd;
	CStatic	m_StatDialNumber;
	CStatic	m_StatModemTypes;
	CComboBox	m_ComBoxModemTypes;
	CStatic	m_ClkSpeedHdr;
	CStatic	m_BaudHeader;
	CButton	m_RBtnDialling;
	CButton	m_RBtnAnswering;
	CButton	m_RBtnExtClk;
	CComboBox	m_cboxSyncIntClkWnd;
	CButton	m_RBtnIntClk;
	CButton	m_RBtnSync;
	CComboBox	m_cboxAsyncBaudWnd;
	CButton	m_RBtnAsync;
	BOOL	m_WANPort;
	CString	m_OldSpeedStr;
	CString	m_cboxAsyncBaud;
	CString	m_cboxSyncIntClk;
	CString	m_StrDialNumber;
	BOOL	m_bDirConnect;
	BOOL	m_bRestartScriptOnCommFailure;
	BOOL	m_bScriptEnable;
	BOOL	m_TermServer;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   CBitmapButton AdvBitmapBtn;
   CBitmapButton ScrBitmapBtn;

	CString  m_szOldModemSel;


	// Chidanand - 25 Mar 1997 - PPP Dial Backup UI support	
	BOOL	m_Backup;
		// Corresponds to "Enable Backup" check box in WAN Dialog 
		

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL CheckDialString();
	BOOL ValidEditFields (void) ;
	
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWANPortDlg)
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	afx_msg LRESULT OnSwitchToIden(WPARAM, LPARAM);
	virtual void OnCancel();
	virtual void OnOK();
	virtual void PostNcDestroy();
	afx_msg void OnHelp();
	afx_msg void OnControl();
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioAsync();
	afx_msg void OnRadioSync();
	afx_msg void OnIntClock();
	afx_msg void OnExtClock();
	afx_msg void OnAnswering();
	afx_msg void OnDialling();
	afx_msg void OnAdvanced();
	afx_msg void OnCheckDirConnect();
	afx_msg void OnBtnScript();
	afx_msg void OnWanBackup();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#if 0
/////////////////////////////////////////////////////////////////////////////
// CWANBackupPortDlg dialog

class CWANBackupPortDlg : public CDialog
{
// Construction
public:
	CWANBackupPortDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWANBackupPortDlg)
	enum { IDD = IDD_WAN_BACKUP_PORT_CONFIG };
	CStatic	m_staticDialNumber_2;
	CStatic	m_staticDialNumber_1;
	CButton	m_grpBackup_2;
	CButton	m_grpBackup_1;
	CButton	m_chkboxWAN2_High_Priority;
	CButton	m_chkboxWAN1_High_Priority;
	CEdit	m_EditDialNumberWnd_2;
	CString	m_StrDialNumber_2;
	CEdit	m_EditDialNumberWnd_1;
	CString	m_StrDialNumber_1;
	CComboBox	m_ComBoxModemTypes;
	CComboBox	m_cboxAsyncBaudWind;
	CString		m_cboxAsyncBaud;
	BOOL	m_bWAN1_High_Priority;
	BOOL	m_bWAN2_High_Priority;
	//}}AFX_DATA
	CString  m_szOldModemSel;

public :
	BOOL ValidEditFields (void) ;
	void EnableBackup_1 (BOOL pEnable);
	void EnableBackup_2 (BOOL pEnable);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void PostNcDestroy();

	// Generated message map functions
	//{{AFX_MSG(CWANBackupPortDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnAdvanced();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	afx_msg LRESULT OnSwitchToIden(WPARAM, LPARAM);
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif

/////////////////////////////////////////////////////////////////////////////
// CWANTab dialog

class CWANTab : public CTabDialog
{
// Construction
public:
	CWANTab(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWANTab)
	enum { IDD = IDD_WAN_TAB };
		// NOTE: the ClassWizard will add data members here

	// Added by cfp on 27-3-96
	UINT m_nPort ;

	//}}AFX_DATA
public:
	CWANPortDlg		*(m_pdlgWAN[n_PORTMAX_WAN]);
	
	int tabcount;
	void WriteModemInfoToIni (void) ;

private:                                                    
	int AcceptConfig(void);
	void GetConfig(void);
	
	BOOL GetModemTypes (void) ;

// Implementation
public :
	int RouMsgBox (int, LPCSTR, int) ;
	void GetTabsRectDim (void) ;
	
	// Chidanand - 25 Mar 1997 - PPP Dial Backup UI support	
	void HandleBackupEnable (void);
		// If "Needs Dial Backup" check box is checked in either WAN 1 or WAN 2,
		// then this routine grays "WAN 3" dialog and enables "Backup Port" dialog.
		// Otherwise enables "WAN 3" dialog and grays "Backup Port" dialog.
		// This routine to be called whenever "Needs Dial Backup" check box is clicked
		// in any of WAN 1 or WAN 2	dialog boxes.

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWANTab)
	virtual BOOL OnInitDialog();
  	virtual void OnOK();
	virtual void OnCancel();
   afx_msg int  GetNumberOfLANPorts(); // Added By Naveen for Firewall 10/4/1998   
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#define LEN_DIAL_NUMBER 40

#define MODEM_TYPE_DIRECT_CONNECT "Direct Connection"
