#ifndef _TFTPIF_H_

#define _TFTPIF_H_

#define EVENT_PORT 1023
#define WM_EVENT (WM_USER + 63)
#define MAX_LEN_USER_NAME   40
#define MAX_LEN_GROUP_NAME  40
#define FILE_NAME_SIZE      128

#define MAX_UDP_RESPONSE_WAIT 9000    /*9 secs timer*/
#define MAX_UDP_RETRY_RESPONSE_WAIT 3000    /*3 secs timer*/
#define AUTODETECT_TIMERID 	0xfe10
#define AUTODETECT_RETRY_TIMERID 	0xfe00

#define AutoDetectTimerCount 5000    //Used for setting 4 Sec. timer.
#define AUTODETECT_TIMER	0xfe11
#define WAIT_FOR_BOOT_TIMER	0xfe12
#define MAX_UDP_RESPONSE_TIMER 10000
#define WM_UDP_EVENT_OCCURED  WM_USER + 26

#define UDP_BROADCAST        (u_long)0xffffffff


#define MAX_MAC_ADDRESS_LENGTH  16
#define SERVER_UDP_PORT 1019
#define MAX_NUMBER_OF_SERVERS 15

#define UDP_DISCOVER_PACKET_TYPE 1
#define UDP_DISCOVER_RESPONSE_PACKET_TYPE 2
#define UDP_CONFIGURE_PACKET_TYPE 3
#define UDP_CONFIGURE_RESPONSE_PACKET_TYPE 4

enum EVENT_CATEG { WAN_EVENT_BDCAST, USER_EVENT_BDCAST }; // Neelu 7.4.99
enum EVENT_TYPE_ENUM 
			{
				LOG_USER_EVENT_LOGON,
				LOG_USER_EVENT_LOGOFF,
				LOG_USER_EVENT_DEFAULTER,
				LOG_USER_EVENT_INVALID_NAME,
				LOG_USER_EVENT_INVALID_PASSWORD,
				LOG_USER_EVENT_ACCOUNT_DISABLED,
				FIREWALL_REBOOTED
			};

typedef struct EVENT_BROADCAST_DATA_PACKET
{
	enum EVENT_CATEG	  		event_type;	 // Neelu 7.4.99
	enum EVENT_TYPE_ENUM		user_event_type; 		
	char 						username[MAX_LEN_USER_NAME];
	char						groupname[MAX_LEN_GROUP_NAME];
	char						login_time[15];
	unsigned long				ip_address;
	unsigned long				server_ip_address;
	char						date[25];
	char						time[25];
} EventBroadCastDataPacket;

struct USERDATALIST
	{
		EVENT_TYPE_ENUM         event_type;
		char 							username[MAX_LEN_USER_NAME];
		char							groupname[MAX_LEN_GROUP_NAME];
		char							login_time[15];
		char							ip_address[50];
		char							date[25];
		char							time[25];
		struct USERDATALIST		*link;
	};


typedef struct UDP_DATA_PACKET_TYPE
{
  unsigned char 	packet_type ;
  unsigned long  	ip_address ;
  char 				mac_address[16] ;
  char				description[25] ;
} UDP_DATA_PACKET_TYPE ;

typedef struct SERVER_RESPONSE_ENTRIES
{
  unsigned long server_ip_address ;
  char  server_mac_address[16] ;
  char  server_description[25] ;
} SERVER_RESPONSE_ENTRIES ;


#endif