
// UserLogDlg.cpp : implementation file
//

#include "stdafx.h"
#include "UserLog.h"
#include "UserLogDlg.h"
#include <memory.h>
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "definition.h"
#include "history.h"
#include "refresh.h"
/* Neelu 03/02/99 */
#include <stdlib.h>
#include <malloc.h>
#include <winsock.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
char WinsockDLL[] = "WINSOCK.Dll";
//int sock;
const char *users_log_msgs1[] = {
		"LoggedOn",
		"LoggedOff",
		"IdentifiedAsDefaulter",
		"InvalidUser",
		"TryingInvalidPasswords",
		"AccountIsDisabled",
		"FirewallRebooted",
		"AccessingFilteredSites",
		"AccountLockUp"

		};

const char *users_log_msgs[] = {
		" Logged on",
		" Logged off",
		" Identified as defaulter",
		" Invalid user",
		" Trying invalid Passwords",
		" Account is disabled",
		" Firewall Rebooted",
		" Accesing Filtered Sites",
		"Account Locked Up"
		};

//struct sockaddr_in EventLocalSocket;
struct USERDATALIST *sptr_user_list = NULL;
char UserEventBdcastFile[FILE_NAME_SIZE];

char obtd_host_ip_address[16] ;
unsigned long configured_ip_address;
SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS] ;
int number_of_responses = 0 ;
bool DetectSuccess = FALSE ;
bool ModifyIPAddress = FALSE ; 

struct sockaddr_in EventLocalSocket,UDPLocalSocket;
int sock,UDPClientSocket;
struct sockaddr_in UDPSocketDstAddr;


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUserLogDlg dialog

CUserLogDlg::CUserLogDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUserLogDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUserLogDlg)
	m_szIPaddress = _T("");
	//}}AFX_DATA_INIT
	m_timeout = FALSE ;

	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUserLogDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUserLogDlg)
	DDX_Control(pDX, IDC_EDIT1, m_IPaddressctrl);
	DDX_Control(pDX, IDC_LIST1, m_Listctrl);
	DDX_Control(pDX, IDC_COMBO1, m_group_name_ctrl);
	DDX_Control(pDX, IDC_LIST3, m_LowerBox);
	DDX_Control(pDX, IDC_LIST2, m_UpperBox);
	DDX_Text(pDX, IDC_EDIT1, m_szIPaddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUserLogDlg, CDialog)
	//{{AFX_MSG_MAP(CUserLogDlg)
	ON_MESSAGE(WM_EVENT,OnBroadcastEvent)
	ON_MESSAGE(WM_UDP_EVENT_OCCURED,OnDiscovery)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(NM_CLICK, IDC_LIST3, OnClickList3)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_BN_CLICKED(IDC_HISTORY, OnHistory)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_BN_CLICKED(IDC_REFRESH_LIST, OnRefreshList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUserLogDlg message handlers
#if 0
int CUserLogDlg::InitSocket(char host_ip_address[16])
{
	WSADATA wsaData ;
	int ret ;
	struct sockaddr_in LocalSocket ;
   int option_value = 1, name_len = 50 ;
	char name_buff[50] ;
	int ncounter = 0;
	char name[5];
	HINSTANCE WinsockHandle;

	WinsockHandle = LoadLibrary (WinsockDLL) ;

     WORD wVersionRequested;
	wVersionRequested = MAKEWORD( 1, 1 ); 
   
	ret = WSAStartup (wVersionRequested, &wsaData) ;
	if (ret != 0)
   {
   	FreeLibrary (WinsockHandle) ;
       //	AfxMessageBox("Debs");
	   return ret ;
   }
		sock = socket(PF_INET,SOCK_DGRAM,0);
   
			if(sock == INVALID_SOCKET)
   		{
				int	LastError = WSAGetLastError() ;
					return LastError ;
			       //	AfxMessageBox("Deb");			
//				return -1;
   		}
   
			memset (&EventLocalSocket, 0, sizeof (EventLocalSocket)) ;
   		EventLocalSocket.sin_family = PF_INET ;
   		EventLocalSocket.sin_port = htons(EVENT_PORT);
		   EventLocalSocket.sin_addr.s_addr = 0 ;
   
			ret = bind(sock,(struct sockaddr FAR *) &EventLocalSocket,sizeof(EventLocalSocket));
  
   		if(ret == SOCKET_ERROR)
			{
					int LastError = WSAGetLastError() ;
					return LastError ;
			 // AfxMessageBox("Deb1");
			//	return -1;
			}
	
/*  			 DWSAAsyncSelect(sock, WindowHandle , WM_EVENT, FD_READ);*/

			 
			
				
		
		return 0 ;
}
#endif
struct hostent *host_info;
int CUserLogDlg::InitSocket(int value,char host_ip_address[16])
{
	WSADATA wsaData ;
	int ret ;
	struct sockaddr_in LocalSocket ;
   int option_value = 1, name_len = 50 ;
	char name_buff[50] ;
	int ncounter = 0;
	char name[5];
	HINSTANCE WinsockHandle;

	WinsockHandle = LoadLibrary (WinsockDLL) ;

     WORD wVersionRequested;
	wVersionRequested = MAKEWORD( 1, 1 ); 
   
	ret = WSAStartup (wVersionRequested, &wsaData) ;
	if (ret != 0)
   {
   	FreeLibrary (WinsockHandle) ;
       //	AfxMessageBox("Debs");
	   return ret ;
   }
	switch (value)
 	{
		case 0:
	
	
		sock = socket(PF_INET,SOCK_DGRAM,0);
   
			if(sock == INVALID_SOCKET)
   			{
				int	LastError = WSAGetLastError() ;
					return LastError ;
			       //	AfxMessageBox("Deb");			
//				return -1;
   		}
   
			memset (&EventLocalSocket, 0, sizeof (EventLocalSocket)) ;
   		EventLocalSocket.sin_family = PF_INET ;
   		EventLocalSocket.sin_port = htons(EVENT_PORT);
		   EventLocalSocket.sin_addr.s_addr = 0 ;
   
			ret = bind(sock,(struct sockaddr FAR *) &EventLocalSocket,sizeof(EventLocalSocket));
  
   		if(ret == SOCKET_ERROR)
			{
					int LastError = WSAGetLastError() ;
					return LastError ;
			 // AfxMessageBox("Deb1");
				//return -1;
			}
	
			break;

		case 1:
			      // AfxMessageBox("Auto");
				UDPClientSocket = socket (PF_INET, SOCK_DGRAM, 0);
			       //	AfxMessageBox("aAuto");
				int LastError;
				if (UDPClientSocket == INVALID_SOCKET)
				{
					LastError = WSAGetLastError() ;
					AfxMessageBox("Auto1");
					return LastError ;
				}
			       //	AfxMessageBox("bAuto");

				if (setsockopt(UDPClientSocket, SOL_SOCKET, SO_BROADCAST,
					(char *) &option_value, sizeof(int)) == SOCKET_ERROR)
				{
					LastError = WSAGetLastError() ;
					AfxMessageBox("Auto2");
					return LastError ;
				}
		       //	AfxMessageBox("cAuto");
			// Client Socket, take any port
				memset (&UDPLocalSocket, 0, sizeof (UDPLocalSocket)) ;

				UDPLocalSocket.sin_family = PF_INET ;
				UDPLocalSocket.sin_addr.s_addr = 0 ;
				UDPLocalSocket.sin_port = 0 ;

				ret = bind (UDPClientSocket, (struct sockaddr FAR *) &UDPLocalSocket,
   												 sizeof (UDPLocalSocket)) ;
				if (ret == SOCKET_ERROR)
				{
					LastError = WSAGetLastError() ;
					AfxMessageBox("Auto3");
					return LastError ;
				}

/* Get host address */

				ret = gethostname ((char FAR * )name_buff, name_len) ;
				if (ret == SOCKET_ERROR)
				{
					LastError = WSAGetLastError() ;
					AfxMessageBox("Auto4");
					return LastError ;
				}

				(struct hostent FAR *)host_info = (struct hostent FAR *) gethostbyname ((const char FAR*)name_buff) ;
				if (host_info == NULL)
				{
					LastError = WSAGetLastError() ;
					AfxMessageBox("Auto5");
					return LastError ; 
				}
				else
				{
					strcpy(host_ip_address, "\0") ;
					while (ncounter != host_info->h_length)
					{
						itoa((int)host_info->h_addr_list[0][ncounter] & 0xff, name, 10) ;
						if(strlen(name) == 1)
						{
							name[2] = name[0] ;
							name[1] = name[0]= '0' ;
						}
						if(strlen(name) == 2)
						{
							name[2] = name[1] ;
							name[1] = name[0] ;
							name[0] = '0' ;
						}
						name[3] = '\0' ;
						strcat(host_ip_address, name) ;
						ncounter++ ;
						if (ncounter < host_info->h_length)
							strcat(host_ip_address, ".") ;
					}
	
				}
				break;
	
	}	
		
		return 0 ;
}

int CUserLogDlg::InitialiseSocket(HWND WindowHandle,int *pError)
{
   
	int ret,ret1;
	char  host_ip_address[16] ;
	
 	
	ret = InitSocket(0,host_ip_address)	;
 	
	if(ret != 0)
	{
/*	  *pError = DWSAGetLastError();*/
	       //	AfxMessageBox("Debug");
		return -1;
	}
	
	ret1 = WSAAsyncSelect(sock, WindowHandle , WM_EVENT, FD_READ);
	
	if (ret1 == SOCKET_ERROR)
	{
		*pError = WSAGetLastError();
	       //	AfxMessageBox("Debug1");
		return -1;
	}
	
	return 0;

}

int CUserLogDlg::UDPInitSocket (int value, char host_ip_address[16]) 
{
	int ret ;
       //	AfxMessageBox("Autodet");
	//if (TFTPClientState != STATE_NOOP)
	//{
	//	WSACleanup() ;
   //	FreeLibrary (WinsockHandle) ;
//	}
	ret = InitSocket(1, host_ip_address)	;
	char val[5];
	sprintf(val,"%d",ret);
       //	AfxMessageBox(val);
	if (ret != 0)
	{
		
		
		closesocket (UDPClientSocket) ;
		WSACleanup() ;
      //FreeLibrary (WinsockHandle) ;
	}
	return ret ;
}


void CUserLogDlg:: UnInitUDP()
{
	closesocket (UDPClientSocket) ;
	WSACleanup() ;
   //FreeLibrary (WinsockHandle) ;
	return ;
}


int CUserLogDlg::StartAutoDetection (HWND WindowHandle, int *pError, 
			unsigned long ip_address, char mac_address[16], int flag) 
{
	int count, ret, i, j, number_of_retries = 3 ;
	UDP_DATA_PACKET_TYPE ServerDiscoverPacket ;
	char buff[100], desc_buff[25] ;
	UINT nTimerID = 0xFEFF ;
		unsigned int addr5, addr6, addr7, addr8;
	char ip_address1[40];
	
	if (!flag)
	{
		ret = WSAAsyncSelect (UDPClientSocket, WindowHandle, 
												WM_UDP_EVENT_OCCURED, FD_READ) ;
		if (ret == SOCKET_ERROR)
		{
			*pError = WSAGetLastError();
			return -1;
		}

		UDPSocketDstAddr.sin_family = AF_INET ;
		UDPSocketDstAddr.sin_addr.s_addr = UDP_BROADCAST ;
		UDPSocketDstAddr.sin_port = change_endian (SERVER_UDP_PORT) ;

		strcpy (desc_buff, "Discover Packet\0") ;
		ServerDiscoverPacket.packet_type = UDP_DISCOVER_PACKET_TYPE ;
	 }
	 else
	 {
		strcpy (desc_buff, "Configure Packet\0") ;
		ServerDiscoverPacket.packet_type = UDP_CONFIGURE_PACKET_TYPE ;
	 }
	 ServerDiscoverPacket.ip_address = ltl_endian_word(ip_address) ;
	addr8 = (unsigned int) (ServerDiscoverPacket.ip_address & 0xFF);
	addr7 = (unsigned int) ((ServerDiscoverPacket.ip_address & 0xFF00) >> 8);
	addr6 = (unsigned int) ((ServerDiscoverPacket.ip_address & 0xFF0000) >> 16);
	addr5 = (unsigned int) ((ServerDiscoverPacket.ip_address & 0xFF000000) >> 24);
	sprintf (ip_address1, "%u.%u.%u.%u", addr8, addr7, addr6, addr5);	
//	AfxMessageBox(ip_address1);

	 strcpy (ServerDiscoverPacket.mac_address, mac_address) ;//neelu
	 strcpy (ServerDiscoverPacket.description, desc_buff)  ;

	 count = 0 ;
	 memcpy (&buff[count++], &ServerDiscoverPacket.packet_type, sizeof(BYTE)) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.ip_address, sizeof(unsigned long)) ;
	 count += sizeof (unsigned long) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.mac_address, strlen(ServerDiscoverPacket.mac_address)) ;
	 count += strlen(ServerDiscoverPacket.mac_address) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.description, strlen(ServerDiscoverPacket.description)) ;
	 count += strlen(ServerDiscoverPacket.description) ;
	 buff[count++]	= '\0' ;

	 if (flag)
	 {
		for (i = 0; i < number_of_retries; i++)
		{
 	 		ret = sendto (UDPClientSocket, (char far *)(buff), (int) count, 0,
	      	(struct sockaddr far *) &UDPSocketDstAddr, (int) sizeof(struct sockaddr)) ;

		 	if (ret == SOCKET_ERROR)			
		 	{				 
				*pError = WSAGetLastError();
				return -1 ;
	 		}
		}
	 }
	 else
	 {
 	 	ret = sendto (UDPClientSocket, (char far *)(buff), (int) count, 0,
	      	(struct sockaddr far *) &UDPSocketDstAddr, (int) sizeof(struct sockaddr)) ;

		if (ret == SOCKET_ERROR)			
		{				 
			*pError = WSAGetLastError();
			return -1 ;
	 	}
	 }
	 return 0 ;
}

#define UDP_RECEIVE_BUFFER_SIZE	512
int CUserLogDlg::process_response_from_server (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS], int *pError,
																		int *number_of_responses) 
{
	UDP_DATA_PACKET_TYPE ServerRespPacket ;
	int length, ret ;
	BYTE *resp_packet, *temp_ptr ;
	struct sockaddr_in DstAddr ;

		unsigned int addr5, addr6, addr7, addr8;
	char ip_address1[40];
	resp_packet = (BYTE *) malloc (512) ;
	if ( resp_packet == NULL )
  	{	 	
		AfxMessageBox("Return neg");
		return -1 ;
	}
	length = sizeof(struct sockaddr_in) ;
      	ret = recvfrom(UDPClientSocket, (char *)resp_packet, sizeof(BYTE)*512, 0, (struct sockaddr FAR *) &DstAddr, (int FAR *)&length) ;
//	ret = recvfrom(UDPClientSocket, (char *)resp_packet, UDP_RECEIVE_BUFFER_SIZE, 0, (struct sockaddr FAR *) &DstAddr, (int  FAR*)&length) ;
	
	if (ret == SOCKET_ERROR)
	{ 
		free(resp_packet) ;
		*pError = WSAGetLastError();
	       //	AfxMessageBox("return -1");
		return -1 ;

	}
	temp_ptr = resp_packet ;
	ServerRespPacket.packet_type = *temp_ptr ;
	temp_ptr++ ;
	ServerRespPacket.ip_address = *(ULONG *)temp_ptr ;
	temp_ptr+= sizeof(ULONG) ;
	memcpy (ServerRespPacket.mac_address, temp_ptr, MAX_MAC_ADDRESS_LENGTH) ;
	ServerRespPacket.mac_address[MAX_MAC_ADDRESS_LENGTH] = '\0' ;
	
	addr8 = (unsigned int) (ServerRespPacket.ip_address & 0xFF);
	addr7 = (unsigned int) ((ServerRespPacket.ip_address & 0xFF00) >> 8);
	addr6 = (unsigned int) ((ServerRespPacket.ip_address & 0xFF0000) >> 16);
	addr5 = (unsigned int) ((ServerRespPacket.ip_address & 0xFF000000) >> 24);
	sprintf (ip_address1, "%u.%u.%u.%u", addr8, addr7, addr6, addr5);	
	
		int counti = m_Listctrl.GetCount();
		char tmpipadd[40];
		int ind = 0;
		bool duplicate_ip_address = FALSE;

		for(ind =0; ind<counti; ind++)
		{
			if(m_Listctrl.GetText(ind,tmpipadd) != LB_ERR)
			{
				if(!strcmp(ip_address1,tmpipadd))
				{
					duplicate_ip_address = TRUE;
					break;
				}
			}
		}

		if(!duplicate_ip_address)
			m_Listctrl.AddString(ip_address1);
		 
      //	m_Listctrl.AddString(ip_address1);
       //	AfxMessageBox(ip_address1);

#if 0
	switch (ServerRespPacket.packet_type)
	{
		   case UDP_DISCOVER_RESPONSE_PACKET_TYPE : 
						 //	AfxMessageBox("tftpop:UDp Packet");

							if (not_a_duplicate_entry (response_entries, ServerRespPacket.mac_address, *number_of_responses))
							{
								response_entries[*number_of_responses].server_ip_address = ltl_endian_word (ServerRespPacket.ip_address) ;				
								strcpy ((char *) response_entries[*number_of_responses].server_mac_address, (char *) ServerRespPacket.mac_address) ;
								*number_of_responses += 1 ;
							}
							break;
				
		   case UDP_CONFIGURE_RESPONSE_PACKET_TYPE : 
							break;
			default : break ;
	}
#endif
	if (resp_packet != NULL)
		free(resp_packet) ;
	return 0 ;
}

int CUserLogDlg::not_a_duplicate_entry (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS], 
								char mac_address_string[16], int number_of_entries)
{
	int i ;

	for (i = 0; i < number_of_entries; i++)
 	{
		if (strcmp(response_entries[i].server_mac_address, mac_address_string) == 0)
	//	AfxMessageBox("Return 0");	
		return 0 ;
	}
	//	printf("Return 1");	

	return 1 ;
}


bool CUserLogDlg::UDPInitialiseSockets(int retry)
{
	int ret, flag, error_code, value = 1 ;

	if (!retry)
	{	
		ret = UDPInitSocket (value, obtd_host_ip_address) ;
	  	if (ret != 0)
 		{
// char tempbuf[50] ;
// sprintf (tempbuf, "%d", ret) ;
// ::MessageBox (GetSafeHwnd(), tempbuf, "Warning!!!", MB_OK | MB_ICONINFORMATION) ;

	  		 AfxMessageBox("Failed to initialize socket....");
   		 return FALSE ;
		}
	}

	flag = 0 ;
	configured_ip_address = 0 ;
	 char mac_address1[16];		
	//strcpy ((char *)mac_address1, "000000000000\0") ;
	strcpy (mac_address1, "000000000000\0") ;
	ret = StartAutoDetection (m_hWnd, &error_code, configured_ip_address, mac_address1 , flag) ;  

	if (ret == -1)
	{
			AfxMessageBox("StartAutoDetection failed") ;
  	    	return FALSE ;
	}

	//AfxMessageBox("StartAutoDetection Success") ;

	if (!retry)
	{
		UINT nTimerID  = this->SetTimer(AUTODETECT_TIMERID, MAX_UDP_RESPONSE_WAIT, NULL) ;
		if(nTimerID == 0)
		{
//  		  	AfxMessageBox("Failure To Create the Timer....");
				return FALSE;
		}
	}
	UINT nRetryTimerID  = this->SetTimer(AUTODETECT_RETRY_TIMERID, MAX_UDP_RETRY_RESPONSE_WAIT, NULL) ;
	if(nRetryTimerID == 0)
	{
			return FALSE;
	}
	//AfxMessageBox("success");
	return TRUE;
}
#if 0
int CUserLogDlg::InitialiseSocket(HWND WindowHandle,int *pError)
{
   
	int ret,ret1;
	char  host_ip_address[16] ;

 	
	ret = InitSocket(host_ip_address)	;
 	
	if(ret != 0)
	{
/*	  *pError = DWSAGetLastError();*/
	       //	AfxMessageBox("Debug");
		return -1;
	}
	
	ret1 = WSAAsyncSelect(sock, WindowHandle , WM_EVENT, FD_READ);
	
	if (ret1 == SOCKET_ERROR)
	{
		*pError = WSAGetLastError();
	       //	AfxMessageBox("Debug1");
		return -1;
	}
	
	return 0;

}
#endif
int CUserLogDlg::recieve_data_from_the_packet (EventBroadCastDataPacket *UserDataPacket,int *pError)
{
	//EventBroadCastDataPacket *UserBroadCastDataPacket;

	int length,ret,len;
	BYTE *data_packet, *temp_ptr;
	struct sockaddr_in DstAddr;
	FILE *Stream,*FStream;
	char userstring [150];
	char usereventstring[400],finaleventstring[400];
	char MsgBuf[20];
	unsigned int addr1, addr2, addr3, addr4;
	char dot_decimal_ip_address[50];
	char usrstring[200];
	char uname[15],tmpuname[15],tmpgname[15];	
	data_packet = (BYTE *) malloc (512);

	
	if (data_packet == NULL)
	{	
	  // AfxMessageBox("Null");
		*pError = -1;
		return -1;
	}
 	
	length = sizeof(DstAddr);
	ret = recvfrom(sock, (char *)data_packet,sizeof(BYTE)*512,0,(struct sockaddr FAR *)&DstAddr,(int FAR *)&length);
	if(ret == SOCKET_ERROR)
	{
   	*pError = WSAGetLastError();
       //	AfxMessageBox("socket error");
		return -1;
	}

	char tmp[10],tmp1[10],tmp2	[10];

	temp_ptr = data_packet;
	UserDataPacket->event_type = (enum EVENT_CATEG) *(temp_ptr+1);
/*	*event_type = UserDataPacket.event_type;*/
	//temp_ptr += sizeof(enum EVENT_CATEG); 
	temp_ptr +=2;


	UserDataPacket->user_event_type = (enum EVENT_TYPE_ENUM) * (temp_ptr+1);
/*	*broadcast_event_type = UserDataPacket.user_event_type;*/
	//temp_ptr += sizeof(enum EVENT_TYPE_ENUM); 
	temp_ptr +=2;
  
	memcpy(UserDataPacket->username, temp_ptr, MAX_LEN_USER_NAME);  
	temp_ptr+=MAX_LEN_USER_NAME;
	UserDataPacket->username[MAX_LEN_USER_NAME] = '\0';	

	
	memcpy(UserDataPacket->groupname, temp_ptr, MAX_LEN_USER_NAME);  
	temp_ptr+=MAX_LEN_USER_NAME;
	UserDataPacket->groupname[MAX_LEN_GROUP_NAME] = '\0';	


	sprintf(tmp,"%d",UserDataPacket->event_type);
//	AfxMessageBox(tmp);
	
	sprintf(tmp1,"%d",UserDataPacket->user_event_type);
//	AfxMessageBox(tmp1);

//	AfxMessageBox(UserDataPacket->username);
//	AfxMessageBox(UserDataPacket->groupname);

	memcpy(UserDataPacket->login_time, temp_ptr, 15);  
	temp_ptr+=15;	
	UserDataPacket->login_time[15] = '\0';	
	
		
//	AfxMessageBox(UserDataPacket->login_time);
	
	UserDataPacket->ip_address = *(unsigned long *)temp_ptr;
	temp_ptr+=sizeof(unsigned long);


	memcpy(UserDataPacket->date, temp_ptr, 25);  
	temp_ptr += 25;	
	UserDataPacket->date[25] = '\0';	
//	AfxMessageBox(UserDataPacket->date);

	memcpy(UserDataPacket->time, temp_ptr, 25);  
	temp_ptr += 25;	
	UserDataPacket->time[25] = '\0';	
//	AfxMessageBox(UserDataPacket->time);

	
	sprintf(MsgBuf,"%s",users_log_msgs[UserDataPacket->user_event_type]);
	sprintf(usrstring,"%s  %s  %s  %s",UserDataPacket->time,UserDataPacket->date,UserDataPacket->username,MsgBuf);
	
	Stream = fopen( "userfile", "a");
	if(Stream == NULL)
	{	
/*		*pError = DWSAGetLastError();*/
	 	return -1;
	}
	
 	fprintf(Stream, "%s\n", usrstring); 
  
	fclose(Stream);
	
	free(data_packet);

	return 0;	
}


BOOL CUserLogDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	char acPath[256],len[10];
	int length ;
   char *ptr ;
	length = GetModuleFileName (NULL, acPath, FILE_NAME_SIZE) ;
	sprintf(len,"%d",length);
	//AfxMessageBox(len);
	ptr = &acPath[length] ;
	while (*ptr != '\\')
      ptr -- ;
   *(ptr + 1) = NULL ;

	strcpy (UserEventBdcastFile, acPath) ;  // File containing latest bd'cast message
	strcat (UserEventBdcastFile, USER_EVENTS_BROADCAST_FILE) ;

	m_group_name_ctrl.SetCurSel(0);
	int InitSock;
	int error_code=0;
	char local[25] ,local1[25] ;

	InitSock = InitialiseSocket(GetSafeHwnd(),&error_code);
	sprintf(local,"%d",InitSock);
       //	AfxMessageBox(local);
	
	//	AfxMessageBox("userLogDlg");
	// TODO: Add extra initialization here
		char col1[10],col2[15],col3[15],col4[15],col5[15],colm4[15],colm5[15];
	strcpy(col1,"Date");
	strcpy(col2,"LoginTime");
	strcpy(col3,"IPAddress");
	strcpy(col4,"Username");
	strcpy(col5,"Groupname");
	strcpy(colm4,"EventMessage");
	strcpy(colm5,"ServerIPAddress");
	m_UpperBox.InsertColumn(1,col1,LVCFMT_LEFT,70,-1);
	m_UpperBox.InsertColumn(2,col2,LVCFMT_LEFT,70,-1);	
	m_UpperBox.InsertColumn(3,col3,LVCFMT_LEFT,90,-1);
	m_UpperBox.InsertColumn(4,col4,LVCFMT_LEFT,80,-1);
	m_UpperBox.InsertColumn(5,col5,LVCFMT_LEFT,100,-1);
	
	m_LowerBox.InsertColumn(1,col1,LVCFMT_LEFT,100,-1);
	m_LowerBox.InsertColumn(2,col2,LVCFMT_LEFT,100,-1);	
	m_LowerBox.InsertColumn(3,col4,LVCFMT_LEFT,160,-1);
	m_LowerBox.InsertColumn(4,colm4,LVCFMT_LEFT,220,-1);
//	m_LowerBox.InsertColumn(5,colm5,LVCFMT_LEFT,100,-1);
	//m_UpperBox.SetTextBkColor(0x00f0f0f0);
	//m_LowerBox.SetTextBkColor(0x00f0f0f0);
	//m_UpperBox.SetTextColor(0x00000000);
	//m_LowerBox.SetTextColor(0x00000000);
	//m_ListCtrl.SetBkColor(0xffffffff);
//	m_EditCtrl.SetBackgroundColor(FALSE,0x00ffff00);
	return TRUE;  // return TRUE  unless you set the focus to a control
}
LRESULT CUserLogDlg::OnDiscovery(WPARAM wParam, LPARAM lParam)
{
     	AfxMessageBox("OnDiscovery");
	ResponseReceived();
	return(NULL);
}

LRESULT CUserLogDlg::OnBroadcastEvent(WPARAM wParam, LPARAM lParam)
{

	//AfxMessageBox("Event Ocurrs");
	CUserLogDlg Cdlg;
	CWnd *Current_Window = Cdlg.GetActiveWindow();
  	EventBroadCastDataPacket user_data_packet;
	int error_code = 0,i=0,j=0;
	char user_name[40],group_name[40],MsgBuf[40],Date[40],Time[40];
	unsigned int addr5, addr6, addr7, addr8,addr1,addr2,addr3,addr4;
	char ip_address[40],ip_address1[40];
	struct USERDATALIST *UserList;
	recieve_data_from_the_packet(&user_data_packet,&error_code);	


	char Item[4][40];
	sprintf(MsgBuf,"%s",users_log_msgs[user_data_packet.user_event_type]);
	strcpy(Item[0],user_data_packet.date);
	strcpy(Item[1],user_data_packet.time);
	strcpy(Item[2],user_data_packet.username);
	strcpy(Item[3],MsgBuf);

	

//	AfxMessageBox(user_data_packet.date);	
//	AfxMessageBox(user_data_packet.login_time);
//	AfxMessageBox(user_data_packet.username);
	
//	addr8 = (unsigned int) (user_data_packet.server_ip_address & 0xFF);
//	addr7 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF00) >> 8);
//	addr6 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF0000) >> 16);
//	addr5 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF000000) >> 24);
//	sprintf (ip_address1, "%u.%u.%u.%u", addr8, addr7, addr6, addr5);	
//	strcpy(Item[3],ip_address1);
//	AfxMessageBox(ip_address1);

	addr4 = (unsigned int) (user_data_packet.ip_address & 0xFF);
	addr3 = (unsigned int) ((user_data_packet.ip_address & 0xFF00) >> 8);
	addr2 = (unsigned int) ((user_data_packet.ip_address & 0xFF0000) >> 16);
	addr1 = (unsigned int) ((user_data_packet.ip_address & 0xFF000000) >> 24);
	sprintf (ip_address, "%u.%u.%u.%u", addr4, addr3, addr2, addr1);	
	
//	strcpy(Item[4],ip_address1);

       //	AfxMessageBox(ip_address);

	LVITEM lvItem,lvItem1;
	
	for(i=0;i<4; i++)
		{
			lvItem.mask = LVIF_TEXT;
			lvItem.iItem = 0;		//row
			lvItem.iSubItem = 0;	//column	
			lvItem.pszText = Item[i];
			lvItem.cchTextMax = 40;
		}
		
	
	int p = m_LowerBox.InsertItem(&lvItem);
	char val[5];
	sprintf(val,"%d",p);
	//AfxMessageBox(val);
	for(i=0; i<4; i++)
	{
		if(m_LowerBox.SetItemText(p,j++,Item[i]) == 0)
		{
		       //	AfxMessageBox("False");
		}
	} 
		char Itemu[5][40];
		strcpy(Itemu[0],user_data_packet.date);
		strcpy(Itemu[1],user_data_packet.login_time);
		strcpy(Itemu[2],ip_address);
		strcpy(Itemu[3],user_data_packet.username);
		strcpy(Itemu[4],user_data_packet.groupname);
	      #if 0
		int counti = m_Listctrl.GetCount();
		char tmpipadd[40];
		int ind = 0;
		bool duplicate_ip_address = FALSE;

		for(ind =0; ind<counti; ind++)
		{
			if(m_Listctrl.GetText(ind,tmpipadd) != LB_ERR)
			{
				if(!strcmp(ip_address1,tmpipadd))
				{
					duplicate_ip_address = TRUE;
					break;
				}
			}
		}

		if(!duplicate_ip_address)
			m_Listctrl.AddString(ip_address1);
	       #endif
		
		if(user_data_packet.user_event_type == FIREWALL_REBOOTED ) 
		{
	       //	AfxMessageBox("Firewall Rebooted");
			int countIndex = m_UpperBox.GetItemCount();
			int index = 0;
			for (index = 0; index < countIndex; index++)
			{
			 
				UserList = (USERDATALIST *) new USERDATALIST ;
				if (UserList == NULL)
				{
					MessageBox ((LPCSTR) "Insufficient memory",
					(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
					return FALSE ;
				}
			
				UserList->event_type = user_data_packet.user_event_type;
				strcpy(UserList->username,user_data_packet.username);
				strcpy(UserList->groupname,user_data_packet.groupname);
				strcpy(UserList->ip_address,ip_address);
				strcpy(UserList->login_time,user_data_packet.login_time);
				strcpy(UserList->date,user_data_packet.date);
				strcpy(UserList->time,user_data_packet.time);	
					
	       		RefreshTheEntry(UserList);
				delete UserList;

		}
		m_UpperBox.DeleteAllItems();
//		delete sptr_user_list;
//		sptr_user_list == NULL;
		return NULL;
	}

		
		
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGON ) 
  	{
		
		int  index;
		char TmpGname[40];
		int cnt = m_group_name_ctrl.GetCount();
		int counti = 0;
		bool duplicate_group_name = FALSE;
   	
		for(counti = 0; counti < cnt; counti++)
		{
			char gpname1[40];
			if(m_group_name_ctrl.GetLBText(counti,gpname1) != LB_ERR)
			{
				if(!strcmp(gpname1, user_data_packet.groupname))
				{ 
					duplicate_group_name = TRUE;
					break;
				}
			}
		 }

		 if(!duplicate_group_name)
				m_group_name_ctrl.AddString(user_data_packet.groupname);
		
	     	char gpname[40];
	     	int sIndex = m_group_name_ctrl.GetCurSel();
	     	m_group_name_ctrl.GetLBText(sIndex,gpname);
	  
		int count = m_UpperBox.GetItemCount();
		bool duplicate = FALSE;
		int countindex=0;

		for(countindex=0; countindex < count; countindex++)
		{
			char tmpIpaddress[40];

			if (m_UpperBox.GetItemText(countindex,2,tmpIpaddress,40) != LB_ERR)
			{
				
				if(!strcmp(tmpIpaddress,ip_address))
				{
					duplicate = TRUE;
					m_UpperBox.DeleteItem (countindex);
					UserList = (USERDATALIST *) new USERDATALIST ;
					if (UserList == NULL)
					{
						MessageBox ((LPCSTR) "Insufficient memory",
						(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
						return FALSE ;
					}
			
					UserList->event_type = user_data_packet.user_event_type;
					strcpy(UserList->username,user_data_packet.username);
					strcpy(UserList->groupname,user_data_packet.groupname);
					strcpy(UserList->ip_address,ip_address);
					strcpy(UserList->login_time,user_data_packet.login_time);
					strcpy(UserList->date,user_data_packet.date);
					strcpy(UserList->time,user_data_packet.time);	
					
					char event[20];
					sprintf(event,"%d",UserList->event_type);
	       	
					DeleteTheEntry(UserList);

					delete (UserList);
					break;
				}
			 }	
		}

		if(!strcmp(gpname,"All") || !strcmp(gpname,user_data_packet.groupname))
		{
			int l=0,m=0,n=0;
			char value[5];
		
			for(m=0;m<5; m++)
			{
				lvItem1.mask = LVIF_TEXT;
				lvItem1.iItem = 0;		//row
				lvItem1.iSubItem = 0;	//column	
				lvItem1.pszText = Itemu[m];
				lvItem1.cchTextMax = 40;
			}
		
	
			int o = m_UpperBox.InsertItem(&lvItem1);
			char val[5];
			sprintf(val,"%d",0);
			//AfxMessageBox(value);
			for(m=0; m<5; m++)
			{
				if(m_UpperBox.SetItemText(o,n++,Itemu[m]) == 0)
				{
					//AfxMessageBox("False");
				}
			} 
			//int nIndex = m_event_listbox_ctrl.AddString(evnt_string);
			//m_event_listbox_ctrl.SetItemDataPtr(nIndex,pUserData);
			//m_event_listbox_ctrl.SetCurSel(nIndex);
				
//			lstrcpy((LPSTR) pUserData->username,user_data_packet.username);
//			lstrcpy((LPSTR) pUserData->groupname,user_data_packet.groupname);
//			lstrcpy((LPSTR) pUserData->ip_address,dot_decimal_ip_address);
//			lstrcpy((LPSTR) pUserData->login_time,user_data_packet.login_time);
		}

		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}

		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);
		UserList->link = NULL;
		char event[20];
		sprintf(event,"%d",UserList->event_type);
  		//AfxMessageBox(event);
		AddtoTheList(UserList);
	}
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGOFF ) 
  	{
	       char uname[40],gname[40],ip_add[40],ltime[15];
	       char usname[40],grname[40],ip_addr[40],lotime[15],combstring[400];
	  	 	int index = 0;
	      //AfxMessageBox("Log Off");
	       	//sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
	      	int count = m_UpperBox.GetItemCount();
			int countindex = 0;
			bool entry = FALSE;
		
		for(countindex=0; countindex < count; countindex++)
		{
			if(m_UpperBox.GetItemText(countindex,2,ip_addr,40) != LB_ERR)
			{
				if (!strcmp(ip_addr,Itemu[2]))
				{
					entry = TRUE;
									
					m_UpperBox.DeleteItem (countindex);
//					break;					
				}
			}
		}
		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
					
					
		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);

		DeleteTheEntry(UserList);
		delete(UserList);    
	}
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGOFF ) 
  	{
	       char uname[40],gname[40],ip_add[50],ltime[15];
	       char usname[40],grname[40],ip_addr[50],lotime[15],combstring[400];
	  	 	int index = 0;
	      //AfxMessageBox("Log Off");
	       	//sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
	      	int count = m_UpperBox.GetItemCount();
				int countindex = 0;
				bool entry = FALSE;
		
		for(countindex=0; countindex < count; countindex++)
		{
			if(m_UpperBox.GetItemText(countindex,2,ip_addr,40) != LB_ERR)
			{
				//sscanf(combstring,"%s\t%s\t%s\t%s",usname,grname,ip_addr,lotime);
				if (!strcmp(ip_addr,Itemu[2]))
				{
					entry = TRUE;
					m_UpperBox.DeleteItem(countindex);
//					break;					
				}
			}
		}
		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
					
					
		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);

		DeleteTheEntry(UserList);
		delete(UserList);    
	}
#if 0
	int error_code=0;
	char local1[25];
       	char user_evnt_string[150];
	char evnt_string[400],fin_evnt_string[400];;
	char MsgBuf[35],uname[30];

	USERONLINEDATA *pUserData ;
	EventBroadCastDataPacket user_data_packet;
	unsigned int addr1, addr2, addr3, addr4;
	char dot_decimal_ip_address[50];
	unsigned int addr5, addr6, addr7, addr8;
	char dot_decimal_ip_address1[50];

	struct USERDATALIST *UserList; //New Addition

	
	userlog Cdlg;
	CWnd *Current_Window = Cdlg.GetActiveWindow();
  	
	recieve_data_from_the_packet(&user_data_packet,&error_code);
	
	sprintf(MsgBuf,"%s",users_log_msgs[user_data_packet.user_event_type]);
    	char user_name[40],group_name[40],u_name[40];
	strcpy(user_name,user_data_packet.username);
	strcpy(u_name,user_data_packet.username);
    	strcpy(group_name,user_data_packet.groupname);

	strncpy((user_name) + 30, "",10);
	
	sprintf(user_evnt_string,"%s\t%s\t%s\t%s",user_data_packet.time,user_data_packet.date,user_name,MsgBuf);
	sprintf(local1, "%d" ,error_code);	
//	AfxMessageBox(local1);
	m_user_log_listbox_ctrl.AddString(user_evnt_string);

	addr8 = (unsigned int) (user_data_packet.server_ip_address & 0xFF);
	addr7 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF00) >> 8);
	addr6 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF0000) >> 16);
	addr5 = (unsigned int) ((user_data_packet.server_ip_address & 0xFF000000) >> 24);
	sprintf (dot_decimal_ip_address1, "%u.%u.%u.%u", addr8, addr7, addr6, addr5);	
	//AfxMessageBox(dot_decimal_ip_address1);


	addr4 = (unsigned int) (user_data_packet.ip_address & 0xFF);
	addr3 = (unsigned int) ((user_data_packet.ip_address & 0xFF00) >> 8);
	addr2 = (unsigned int) ((user_data_packet.ip_address & 0xFF0000) >> 16);
	addr1 = (unsigned int) ((user_data_packet.ip_address & 0xFF000000) >> 24);
	sprintf (dot_decimal_ip_address, "%u.%u.%u.%u", addr4, addr3, addr2, addr1);	
	
       //	AfxMessageBox(dot_decimal_ip_address);

	
	strncpy((u_name) + 15, "",25);
	strncpy((group_name) + 15, "",25);
		
	
	
	sprintf(evnt_string,"%s\t%s\t%s\t%s",u_name,group_name,dot_decimal_ip_address,user_data_packet.login_time);
	
	if(user_data_packet.user_event_type == FIREWALL_REBOOTED ) 
	{
	       //	AfxMessageBox("Firewall Rebooted");
		int countIndex = m_event_listbox_ctrl.GetCount();
		int index = 0;
		for (index = 0; index < countIndex; index++)
		{
			USERONLINEDATA *pUserData = (USERONLINEDATA *)
			m_event_listbox_ctrl.GetItemDataPtr (index) ;
		     	delete pUserData;
			 
			UserList = (USERDATALIST *) new USERDATALIST ;
			if (UserList == NULL)
			{
				MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
				return FALSE ;
			}
			
			UserList->event_type = user_data_packet.user_event_type;
			strcpy(UserList->username,user_data_packet.username);
			strcpy(UserList->groupname,user_data_packet.groupname);
			strcpy(UserList->ip_address,dot_decimal_ip_address);
			strcpy(UserList->login_time,user_data_packet.login_time);
			strcpy(UserList->date,user_data_packet.date);
			strcpy(UserList->time,user_data_packet.time);	
					
	       		RefreshTheEntry(UserList);
			delete UserList;

		}
		m_event_listbox_ctrl.ResetContent();
		return NULL;
	}

	
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGON ) 
  	{
		
		int  index;
		char TmpGname[40];
		int cnt = m_group_name_ctrl.GetCount();
		int counti = 0;
		bool duplicate_group_name = FALSE;
   	
		for(counti = 0; counti < cnt; counti++)
		{
			char gpname1[40];
			if(m_group_name_ctrl.GetLBText(counti,gpname1) != LB_ERR)
			{
				if(!strcmp(gpname1, user_data_packet.groupname))
				{ 
					duplicate_group_name = TRUE;
					break;
				}
			}
		 }

		 if(!duplicate_group_name)
				m_group_name_ctrl.AddString(user_data_packet.groupname);
		
	     	char gpname[40];
	     	int sIndex = m_group_name_ctrl.GetCurSel();
	     	m_group_name_ctrl.GetLBText(sIndex,gpname);
	  
		int count = m_event_listbox_ctrl.GetCount();
		bool duplicate = FALSE;
		int countindex=0;

		for(countindex=0; countindex < count; countindex++)
		{
			char UsGrDeAc[200];

			if (m_event_listbox_ctrl.GetText(countindex,UsGrDeAc) != LB_ERR)
			{
				char u_name[40],tmpUsername[15],tmpGroupname[15],tmpIpaddress[15];
				sscanf(UsGrDeAc,"%s\t%s\t%s",tmpUsername,tmpGroupname,tmpIpaddress);

				if(!strcmp(tmpIpaddress, dot_decimal_ip_address))
				{
					duplicate = TRUE;

					USERONLINEDATA *pUserData = (USERONLINEDATA *)
		 			m_event_listbox_ctrl.GetItemDataPtr (countindex) ;

					delete pUserData ;
					m_event_listbox_ctrl.DeleteString (countindex);


					UserList = (USERDATALIST *) new USERDATALIST ;
					if (UserList == NULL)
					{
						MessageBox ((LPCSTR) "Insufficient memory",
						(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
						return FALSE ;
					}
			
					UserList->event_type = user_data_packet.user_event_type;
					strcpy(UserList->username,user_data_packet.username);
					strcpy(UserList->groupname,user_data_packet.groupname);
					strcpy(UserList->ip_address,dot_decimal_ip_address);
					strcpy(UserList->login_time,user_data_packet.login_time);
					strcpy(UserList->date,user_data_packet.date);
					strcpy(UserList->time,user_data_packet.time);	
					
					char event[20];
					sprintf(event,"%d",UserList->event_type);
	       	
					DeleteTheEntry(UserList);

					delete (UserList);
					break;
				}
			 }	
		}

		if(!strcmp(gpname,"All") || !strcmp(gpname,user_data_packet.groupname))
		{
			pUserData = (USERONLINEDATA *) new USERONLINEDATA ;
			if (pUserData == NULL)
			{
				MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
				return FALSE;
			}

			int nIndex = m_event_listbox_ctrl.AddString(evnt_string);
			m_event_listbox_ctrl.SetItemDataPtr(nIndex,pUserData);
			m_event_listbox_ctrl.SetCurSel(nIndex);
				
			lstrcpy((LPSTR) pUserData->username,user_data_packet.username);
			lstrcpy((LPSTR) pUserData->groupname,user_data_packet.groupname);
			lstrcpy((LPSTR) pUserData->ip_address,dot_decimal_ip_address);
			lstrcpy((LPSTR) pUserData->login_time,user_data_packet.login_time);
		}

		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}

		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,dot_decimal_ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);
		UserList->link = NULL;
		char event[20];
		sprintf(event,"%d",UserList->event_type);
  		//AfxMessageBox(event);
		AddtoTheList(UserList);
	}
	
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGOFF ) 
  	{
	       char uname[40],gname[40],ip_add[50],ltime[15];
	       char usname[40],grname[40],ip_addr[50],lotime[15],combstring[400];
	  	 	int index = 0;
	      //AfxMessageBox("Log Off");
	       	sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
	      	int count = m_UpperBox.GetCount();
			int countindex = 0;
			bool entry = FALSE;
		
		for(countindex=0; countindex < count; countindex++)
		{
			if(m_UpperBox.GetItemText(countindex,2,ip_addr) != LB_ERR)
			{
				if (!strcmp(ip_addr,ip_add))
				{
					entry = TRUE;
									
					m_UpperBox.DeleteItem (countindex);
//					break;					
				}
			}
		}
		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
					
					
		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,dot_decimal_ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);

		DeleteTheEntry(UserList);
		delete(UserList);    
	}
	if(user_data_packet.user_event_type == LOG_USER_EVENT_LOGOFF ) 
  	{
	       char uname[40],gname[40],ip_add[50],ltime[15];
	       char usname[40],grname[40],ip_addr[50],lotime[15],combstring[400];
	  	 	int index = 0;
	      //AfxMessageBox("Log Off");
	       	//sscanf(evnt_string,"%s%s%s%s",uname,gname,ip_add,ltime);
	      	int count = m_UpperBox.GetItemCount();
				int countindex = 0;
				bool entry = FALSE;
		
		for(countindex=0; countindex < count; countindex++)
		{
			if(m_UpperBox.GetItemText(countindex,2,ip_addr,40) != LB_ERR)
			{
				//sscanf(combstring,"%s\t%s\t%s\t%s",usname,grname,ip_addr,lotime);
				if (!strcmp(ip_addr,ip_add))
				{
					entry = TRUE;
					m_UpperBox.DeleteItem(countindex);
//					break;					
				}
			}
		}
		UserList = (USERDATALIST *) new USERDATALIST ;
		if (UserList == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
			(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
					
					
		UserList->event_type = user_data_packet.user_event_type;
		strcpy(UserList->username,user_data_packet.username);
		strcpy(UserList->groupname,user_data_packet.groupname);
		strcpy(UserList->ip_address,dot_decimal_ip_address);
		strcpy(UserList->login_time,user_data_packet.login_time);
		strcpy(UserList->date,user_data_packet.date);
		strcpy(UserList->time,user_data_packet.time);

		DeleteTheEntry(UserList);
		delete(UserList);    
	}
#endif 
	return (NULL) ;

}

void CUserLogDlg::AddtoTheList(struct USERDATALIST *userlist)
{
	struct USERDATALIST *tempuserlist = NULL;

	if(sptr_user_list == NULL)
	{
		//AfxMessageBox("Adding First Entry ");
		sptr_user_list = userlist;
		return;
	}

	tempuserlist = sptr_user_list ;
	while(1)
	{
		if (!strcmp(tempuserlist->ip_address, userlist->ip_address))
		{
			tempuserlist->event_type = userlist->event_type;
			strcpy(tempuserlist->username,userlist->username);
			//AfxMessageBox(tempuserlist->username);
			//AfxMessageBox(userlist->username);
			strcpy(tempuserlist->groupname,userlist->groupname);
			strcpy(tempuserlist->ip_address,userlist->ip_address);
			//AfxMessageBox(tempuserlist->ip_address);
			//AfxMessageBox(userlist->ip_address);

			strcpy(tempuserlist->login_time,userlist->login_time);
			strcpy(tempuserlist->date,userlist->date);
			strcpy(tempuserlist->time,userlist->time);
			return;
		}

		if(tempuserlist->link == NULL)
		{
			//AfxMessageBox("Adding Next entries");
			tempuserlist->link = userlist;
			return;
		}
		else
			tempuserlist = tempuserlist->link;
	}
}

void CUserLogDlg :: DeleteTheEntry(struct USERDATALIST *UserDataList)
{
	struct USERDATALIST *tmpUserList,*tempUserList;
	//AfxMessageBox("Delete the Node");
	if(sptr_user_list == NULL)
		return;

	tmpUserList = sptr_user_list;

	if(!strcmp(tmpUserList->ip_address, UserDataList->ip_address))
	{
		sptr_user_list = tmpUserList->link;
		delete(tmpUserList);
		return;
	}

	while(tmpUserList->link !=NULL)
	{
		if(!strcmp(tmpUserList->link->ip_address, UserDataList->ip_address))
		{
			tempUserList = tmpUserList->link->link;
			delete(tmpUserList->link);
			tmpUserList->link = tempUserList;
		}
		else
			tmpUserList = tmpUserList->link;

		if(tmpUserList == NULL)
				break;
	}
	return;
}
void CUserLogDlg :: RefreshTheEntry(struct USERDATALIST *UserDataList)
{
	struct USERDATALIST *tmpUserList,*tempUserList;
//	AfxMessageBox("Refresh the Node");
	if(sptr_user_list == NULL)
		return;
	
	tmpUserList = sptr_user_list;
	   	
	while(tmpUserList->link != NULL)
	{		       		
  //			AfxMessageBox("debug 3");
			
			tempUserList = tmpUserList->link;
			delete(tmpUserList);
			tmpUserList = tempUserList;
	}
	
      	if(tmpUserList != NULL)
       		delete(tmpUserList);
	
      	sptr_user_list = NULL;
	

	return;
}

void CUserLogDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CUserLogDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUserLogDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUserLogDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUserLogDlg::OnClickList3(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CUserLogDlg::OnSelchangeCombo1() 
{
	// TODO: Add your control notification handler code here
	struct USERDATALIST *tempuserlist = sptr_user_list;
	char event_string[200] ;
	
	int index=0;		

	int countIndex = m_UpperBox.GetItemCount();

	m_UpperBox.DeleteAllItems();

	char gpname[40];
	int sIndex = m_group_name_ctrl.GetCurSel();
	m_group_name_ctrl.GetLBText(sIndex,gpname);
	
	while(tempuserlist != NULL)
	{
		if(!strcmp(gpname, tempuserlist->groupname) || !strcmp(gpname,"All"))
		{
		    LVITEM lvItem1;	    
			int l=0,m=0,n=0;
			char value[5];
			char Itemu[5][40];
			strcpy(Itemu[0],tempuserlist->date);
			strcpy(Itemu[1],tempuserlist->login_time);
			strcpy(Itemu[2],tempuserlist->ip_address);
			strcpy(Itemu[3],tempuserlist->username);
			strcpy(Itemu[4],tempuserlist->groupname);
			for(m=0;m<5; m++)
			{
				lvItem1.mask = LVIF_TEXT;
				lvItem1.iItem = 0;		//row
				lvItem1.iSubItem = 0;	//column	
				lvItem1.pszText = Itemu[m];
				lvItem1.cchTextMax = 40;
			}
		
	
			int o = m_UpperBox.InsertItem(&lvItem1);
			char val[5];
			sprintf(val,"%d",0);
			//AfxMessageBox(value);
			for(m=0; m<5; m++)
			{
				if(m_UpperBox.SetItemText(o,n++,Itemu[m]) == 0)
				{
			//		AfxMessageBox("False");
				}
			} 
			
		}

		tempuserlist = tempuserlist->link;
	}
}



void CUserLogDlg::OnHistory() 
{
	// TODO: Add your control notification handler code here
	history hist(this);
	hist.DoModal();
}

void CUserLogDlg::OnSelchangeList1() 
{
	// TODO: Add your control notification handler code here
	char tipadd[40];
       //	AfxMessageBox("On selchange");
	m_Listctrl.GetText(m_Listctrl.GetCurSel(),tipadd);
	//strcpy((LPCTSTR)m_szIPaddress,(LPSTR)tipadd);
       //	AfxMessageBox(tipadd);
	m_IPaddressctrl.SetWindowText(tipadd);
}

bool CUserLogDlg::ResponseReceived(void) 
{
   int ret, error_code ;
   char szBuf[50] ;

   ret = process_response_from_server (response_entries, &error_code, &number_of_responses) ;
   
   char local[10];
   sprintf(local,"%d",error_code);
//   AfxMessageBox(local);
   if (ret == -1)
   {		
   	       //	AfxMessageBox( "DetectSuccess is False");
		return FALSE ;
   }

   DetectSuccess = TRUE ;
   return TRUE ;
}

void CUserLogDlg::TimerExpired(UINT nIDEvent)
{
	KillTimer(nIDEvent);
	m_timeout == TRUE ;
}

unsigned short CUserLogDlg::change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;


	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

unsigned long CUserLogDlg:: ltl_endian_word (unsigned long num)
{
	unsigned long num2 ;
	BYTE *str ;
	BYTE *str2 ;
	str = (BYTE *) &num ;
	str2 = (BYTE *) &num2 ;
	if ((int) sizeof (num) == (int) 4)
	{
		str2[3] = str[0] ;
		str2[2] = str[1] ;
		str2[1] = str[2] ;
		str2[0] = str[3] ;
	}
	else
	{ 
		str2[0] = str[1] ;
		str2[1] = str[0] ;
	}
	return num2 ;
}



void CUserLogDlg::OnRefreshList() 
{
	// TODO: Add your control notification handler code here
	int retry = 0 ;
				refresh r;
			//	t.DoModal();
				bool result = UDPInitialiseSockets(retry);
		
			//AfxMessageBox("Start");	
				if (result == FALSE)
				{
		  		  	AfxMessageBox("Unable to proceed with autodetection....") ;
					UnInitUDP() ;
					return ;
				}

				WPARAM wparam;
				LPARAM lparam;
				OnDiscovery(wparam,lparam);
					
		#if 0
					MSG Msg;
				bool bMsgFound;
				bool bTimerExpired = FALSE;
				bool return_value ;

				while(bTimerExpired == FALSE)
				{
					return_value = ResponseReceived();
					if (return_value == FALSE)
					break;
				
					
				}
				class1 c1;	
				while(bTimerExpired == FALSE)
				{
				      
				        bMsgFound = PeekMessage(&Msg, c1.m_hWnd,0,0,PM_REMOVE);
					if(bMsgFound == TRUE)
					{
					   
						switch(Msg.message)
						{
							case WM_TIMER:
								AfxMessageBox("WM_TIMER");	
								TimerExpired(Msg.wParam);
								
									if (Msg.wParam == AUTODETECT_TIMERID)
									{
									
										bTimerExpired = TRUE;
									}
									else
										if (Msg.wParam == AUTODETECT_RETRY_TIMERID)
										{
											retry = 1 ;
												return_value = ResponseReceived();
											UDPInitialiseSockets(retry);
										}
									break;
							case WM_UDP_EVENT_OCCURED:
							   // AfxMessageBox("WM_UDP_EVENT_OCURRED");    	
								return_value = ResponseReceived();
								      	
									break;
							default:break;
						}

						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}

				if (DetectSuccess == FALSE)
				{
			           	AfxMessageBox ("Auto Detection Failed") ;
						UnInitUDP() ;
				   	return  ;
				}
			//     //	else
			//     //	{
			//	 //  CIPDetect ipdetect ;	
			//	//   ipdetect.DoModal() ;
			//    //	}
//				char WindowText[80] ;

//				strcpy (WindowText, "Please Wait...Configuring ProxyServer and rebooting") ; 
//				Autodetect.m_wait_msg = WindowText ;
//				Autodetect.SetWindowText (m_wait_msg) ;

				bTimerExpired = FALSE;
				UINT nTimerID = SetTimer(WAIT_FOR_BOOT_TIMER, MAX_UDP_RESPONSE_TIMER, NULL) ;
				while(bTimerExpired == FALSE)
				{
				         bMsgFound = PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE);
					if(bMsgFound == TRUE)
					{
						switch(Msg.message)
						{
							case WM_TIMER:
									if (Msg.wParam == WAIT_FOR_BOOT_TIMER)
									{
										TimerExpired(Msg.wParam);
										bTimerExpired = TRUE;
									}
									break;
							case WM_UDP_EVENT_OCCURED:
							        	return_value = ResponseReceived();
										break;
							default:break;
						}
						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}
			#endif
				UnInitUDP() ;
			       // AfxMessageBox ("Sockets inited") ;

					ModifyIPAddress = TRUE ;
			
//			AfxMessageBox("Auto Detect is Disabled");

	
	// TODO: Add your control notification handler code here
	
}
