// applicat.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "applicat.h"
#include "cryptfns.h"
#include	"secthdr.h"
#include <ctype.h>

LPCSTR TNETSectionHeader = "TELNET Server";
LPCSTR TFTPSectionHeader = "TFTP";
LPCSTR WEBSectionHeader = "WEB Server";
LPCSTR SNMPSectionHeader = "SNMP Management";

#define PASSWORD_LEN 48
#define SERVER_NAME_LEN 41

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// APPLICAT dialog


APPLICAT::APPLICAT(CWnd* pParent /*=NULL*/)
	: CDialog(APPLICAT::IDD, pParent)
{
	//{{AFX_DATA_INIT(APPLICAT)
	m_PWordStr = "";
	m_TFTPEnable = FALSE;
	m_TNETEnable = FALSE;
	m_DumbTerminalMgmtEnable = FALSE;
	m_WEBServer = FALSE;
	m_IPAddr = "";
	m_SNMPEnable = FALSE;
	m_bAGServer = FALSE;
	m_bDispConnManagMenu = FALSE;
	m_SerNameStr = "";
	//}}AFX_DATA_INIT

	m_bDialogInited = FALSE ;
}

void APPLICAT::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(APPLICAT)
	DDX_Control(pDX, IDC_STATIC_AG_SERVER_NAME, m_ctrl_server_name);
	DDX_Control(pDX, IDC_EDIT_SERVER_NAME, m_EditSerNameWnd);
	DDX_Control(pDX, IDC_CHECK_DISP_CONN_MANAG_MENU, m_chkDispConnManagMenu);
	DDX_Control(pDX, IDC_CHECK_AG_SERVER, m_chkAGServer);
	DDX_Control(pDX, IDC_STATIC_AG_SERVER_GRP, m_GrpAGServer);
	DDX_Control(pDX, IDC_ENABLE_WEB_SERVER_MGMT, m_WEBWnd);
	DDX_Control(pDX, IDC_EDIT_PWORD, m_EditPasWordWnd);
	DDX_Text(pDX, IDC_EDIT_PWORD, m_PWordStr);
	DDX_Check(pDX, IDC_ENABLE_TFTP, m_TFTPEnable);
	DDX_Check(pDX, IDC_ENABLE_TNET, m_TNETEnable);
	DDX_Check(pDX, IDC_ENABLE_DUMB_TERMINAL, m_DumbTerminalMgmtEnable);
	DDX_Check(pDX, IDC_ENABLE_WEB_SERVER_MGMT, m_WEBServer);
	DDX_Text(pDX, IDC_EDITIP_ADDRESS, m_IPAddr);
	DDX_Check(pDX, IDC_CHECK_SNMP, m_SNMPEnable);
	DDX_Check(pDX, IDC_CHECK_AG_SERVER, m_bAGServer);
	DDX_Check(pDX, IDC_CHECK_DISP_CONN_MANAG_MENU, m_bDispConnManagMenu);
	DDX_Text(pDX, IDC_EDIT_SERVER_NAME, m_SerNameStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(APPLICAT, CDialog)
	//{{AFX_MSG_MAP(APPLICAT)
	ON_EN_UPDATE(IDC_EDIT_PWORD, OnUpdateEditPword)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_EN_UPDATE(IDC_EDIT_SERVER_NAME, OnUpdateEditServerName)
	ON_BN_CLICKED(IDC_CHECK_AG_SERVER, OnCheckAgServer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// APPLICAT message handlers

BOOL APPLICAT::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char szBuf[100] ;
	char szPWord[100];
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;

	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	GetPrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Server", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_TNETEnable = TRUE ;
	else
		m_TNETEnable = FALSE ;

	m_EditPasWordWnd.LimitText (PASSWORD_LEN - 1) ;
	GetPrivateProfileString ((LPCSTR) TNETSectionHeader, 
		(LPCSTR) "Telnet Server Password",
				(LPCSTR)	StrNull, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
	Decrypt(szBuf, szPWord);
	m_PWordStr = szPWord ;

	GetPrivateProfileString ((LPCSTR) TFTPSectionHeader,
			(LPCSTR) "TFTP", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_TFTPEnable = TRUE ;
	else
		m_TFTPEnable = FALSE ;

	GetPrivateProfileString ((LPCSTR) WEBSectionHeader, (LPCSTR) "WEB Server", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_WEBServer = TRUE;
	else
		m_WEBServer = FALSE;

	GetPrivateProfileString ((LPCSTR) TNETSectionHeader, (LPCSTR) "Telnet Dumb TTY Management", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_DumbTerminalMgmtEnable = TRUE;
	else
		m_DumbTerminalMgmtEnable = FALSE;

	GetPrivateProfileString ((LPCSTR) SNMPSectionHeader, (LPCSTR) "SNMP", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_SNMPEnable = TRUE;
	else
		m_SNMPEnable = FALSE;

	GetPrivateProfileString (SNMPSectionHeader,
			(LPCSTR) "SNMP Local Internet Address",
					StrNull, (LPSTR) szBuf ,sizeof(szBuf),
							(LPCSTR) IniInWinForm);
	m_IPAddr = szBuf;

    // Brindha for AG on 27/10/98
    ProcessAGSection() ;

	CenterWindow() ;

	// Update the Dialog Box fields.
	UpdateData (FALSE) ;
	m_bDialogInited = TRUE ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void APPLICAT::OnOK()
{   
	char szNewHeader[50] ;
	char CurrentHeading[80];

	GetWindowText (CurrentHeading, 80) ;
	ModifyHeader (CurrentHeading, szNewHeader) ;

	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

	LPCSTR temp ;

	if (m_TNETEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Server", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	char szPassWd[PASSWORD_LEN] ;
	char szEncryptPassWd[PASSWORD_LEN] ;
	if (m_EditPasWordWnd.GetModify())
	{
		strcpy (szPassWd, (LPCSTR) m_PWordStr) ;
		Encrypt (szPassWd, szEncryptPassWd) ;
		WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
			(LPCSTR) "Telnet Server Password",
					(LPCSTR) szEncryptPassWd, (LPCSTR) IniInWinForm) ;
	}

	if (m_TFTPEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TFTPSectionHeader,
		(LPCSTR) "TFTP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_WEBServer)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WEBSectionHeader,
		(LPCSTR) "WEB Server", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_DumbTerminalMgmtEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Dumb TTY Management", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

   //Write the BOOL parameters
	if(m_SNMPEnable)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(SNMPSectionHeader , (LPCSTR) "SNMP",
					temp, (LPCSTR) IniInWinForm);	

// brindha on 6/5/99. 
	if (!CheckServerName())
		return ;

 // Brindha for AG on 27/10/98 
	WriteAGStrings() ;

	CDialog::OnOK();
}

void APPLICAT::OnHelp()
{
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_APPLICATIONS, HELP_CONTEXT) ;
}

// Brindha included the following 2 functions for AG on 27/10/98
void APPLICAT::ProcessAGSection (void) 
{
	char szRHS[20] ;

	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
		(LPCSTR) "AG", (LPCSTR) StrDisabled, (LPSTR) szRHS,
				sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (strcmp (szRHS, StrEnabled) == 0)
	{
		m_bAGServer = TRUE ;
		m_chkAGServer.SetCheck(1) ;
	}
	else
	{
		m_bAGServer = FALSE ;
		m_chkAGServer.SetCheck(0) ;
		m_ctrl_server_name.EnableWindow (FALSE) ;
		m_EditSerNameWnd.EnableWindow (FALSE) ;
	}

	m_EditSerNameWnd.LimitText (SERVER_NAME_LEN - 1) ;
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
		(LPCSTR) "AG Server Name", 
			(LPCSTR) "PROXYAG", (LPSTR) szRHS,
				sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	
	m_SerNameStr = szRHS ;


	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
		(LPCSTR) "AG Display Connection Manager Menu", 
		(LPCSTR) StrDisabled, (LPSTR) szRHS,
		sizeof (szRHS), (LPCSTR) IniInWinForm) ;

	if (strcmp (szRHS, StrEnabled) == 0)
		m_bDispConnManagMenu = TRUE ;
	else
		m_bDispConnManagMenu = FALSE ;

	UpdateData (FALSE) ;

#if 0
        if (!m_bAG)
        {
        	RECT FullRect ;
		RECT ClipRect ;

		GetWindowRect (&FullRect) ;
		m_GrpAGServer.GetWindowRect (&ClipRect) ;

		m_chkDispConnManagMenu.EnableWindow (FALSE) ;
		m_chkAGServer.EnableWindow (FALSE) ;
		m_GrpAGServer.EnableWindow (FALSE) ;

		m_chkDispConnManagMenu.ShowWindow (SW_HIDE) ;
		m_chkAGServer.ShowWindow (SW_HIDE) ;
		m_GrpAGServer.ShowWindow (SW_HIDE) ;

		FullRect.bottom = ClipRect.top ;
		MoveWindow (&FullRect, TRUE) ;

        }
#endif
}

void APPLICAT::WriteAGStrings()
{
	LPCSTR lpcszRHS ;
	char szServerName[SERVER_NAME_LEN] ;

	lpcszRHS = (m_bAGServer == TRUE) ? StrEnabled : StrDisabled ;
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
			(LPCSTR) "AG", lpcszRHS, (LPCSTR) IniInWinForm) ;
		
	lpcszRHS = m_bDispConnManagMenu ? StrEnabled : StrDisabled ;
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
				(LPCSTR) "AG Display Connection Manager Menu",
							lpcszRHS, (LPCSTR) IniInWinForm) ;

	strcpy (szServerName, m_SerNameStr) ;
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
				(LPCSTR) "AG Server Name",
					(LPCSTR) szServerName, (LPCSTR) IniInWinForm) ;

}

void APPLICAT::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void APPLICAT::OnUpdateEditPword()
{
	// TODO: Add your control notification handler code here

	int nPassLen = m_PWordStr.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_EditPasWordWnd.LineLength (-1) > nPassLen || m_EditPasWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			m_PWordStr = "" ;
			UpdateData (FALSE) ;
		}
	}
}

// brindha on 6/5/99.
BOOL APPLICAT::CheckServerName()
{
	char temp_name[40] ;

	if (m_bAGServer)
	{
		m_EditSerNameWnd.GetWindowText(m_SerNameStr) ;
		if (m_SerNameStr.IsEmpty())
		{
			::MessageBox (GetSafeHwnd(), "Enter the server name since AG Server is enabled.", 
			"APPLICATION - INFO", MB_OK | MB_ICONINFORMATION) ; 
			m_EditSerNameWnd.SetFocus() ;
			return FALSE ;
		}

		sprintf(temp_name,"%s",m_SerNameStr) ;

		int index = 0 ;

		if  ( (!isalpha(temp_name[index])) || (!isupper(temp_name[index])))
		{	
			::MessageBox (GetSafeHwnd(), "Enter an uppercase alphabet as the first letter.",
			"APPLICATION - INFO", MB_OK | MB_ICONINFORMATION) ;
			m_EditSerNameWnd.SetFocus() ;
			return FALSE ;
		}
		index++ ;
		while ( temp_name[index] != '\0' )
		{
			if ( !(__iscsym(temp_name[index])) || (isalpha(temp_name[index]) && !(isupper(temp_name[index]))) )
			{
				::MessageBox (GetSafeHwnd(), "Enter only uppercase alphabets,digits & underscore (A-Z,0-9,_) \
for the server name", "APPLICATION - INFO", MB_OK | MB_ICONINFORMATION) ;
				m_EditSerNameWnd.SetFocus() ;
				return FALSE ;
			}
			index++ ;
		}
	}
	
	return TRUE ;

}

void APPLICAT::OnUpdateEditServerName()
{
	// TODO: Add your control notification handler code here
//	CheckServerName () ;
	
}

void APPLICAT::OnCheckAgServer()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE) ;
	if (m_chkAGServer.GetCheck())
	{
		m_bAGServer = TRUE ;
		m_ctrl_server_name.EnableWindow (TRUE);
		m_EditSerNameWnd.EnableWindow (TRUE);
	}
	else
	{
		m_bAGServer = FALSE ;
		m_ctrl_server_name.EnableWindow (FALSE);
		m_EditSerNameWnd.EnableWindow (FALSE);
	}
	UpdateData (FALSE) ;
	
}
